#!/usr/bin/python

import sys

def calc( addr ):
	out = 0;
	
	# disassemble address
	cpu_addr = (addr & 0xF) << 13;

	ba13 = cpu_addr & (1 << 15);
	# BIOS area
	bios = (cpu_addr == (0xFE000 & (0xF << 13)));
	# INT handler area
	bios |= (cpu_addr == (0xF4000 & (0xF << 13)));
		
	# assemble output data
	if ba13:
		out |= 0x5;
	if bios:
		out |= 0xA;
	
	return out;

for i in range( 1 << 8 ):
	data = calc( i );
	sys.stdout.write( chr(data) );
