TICK=$5C78

TIME = $8000-2
ORG  $8000
PI_LEN = 51
PI_SUM = $9000
PI_10 = $9800
PI_239 = $A000
PI_515 = $A800
PI_TMP = $B000
FONT2 = $B100
M100T = $B700
D25T = $B800
M200T = $BA00
D103T = $BC00
D239T = $BE00

START:
        LD SP,$6000
        EI
        CALL CLEAR
        CALL BENCH
        CALL INITF
        CALL INIT25
        CALL INIT100
        CALL INIT103
        CALL INIT200
        CALL INIT239
        
MAIN:
        CALL CALC
        CALL PRINT
        CALL BENCH
        JP MAIN

DIV15:
        LD HL,$4300
        INC (HL)
        INC L
        LD (DIV15+1),HL
        LD HL,(DIV_N+1)
        LD DE,-2
        ADD HL,DE
        LD (DIV_N+1),HL
        RET NC
        LD HL,(DIV_P+1)
        LD DE,2
        ADD HL,DE
        LD (DIV_P+1),HL
        LD A,H
        OR A
        JR NZ,DIV15_Y
        LD A,L
        NEG
        JP M,DIV7_Y
DIV15_Y:
        LD HL,0
        LD BC,(PI_10)
        JP DIV15_T
DIV15_A:ADC A
        ADD HL,HL
        ADD BC
        JR C,DIV15_2
DIV15_B:ADC A
        ADD HL,HL
        ADD BC
        JR C,DIV15_3
DIV15_C:ADC A
        ADD HL,HL
        ADD BC
        JR C,DIV15_4
DIV15_D:ADC A
        ADD HL,HL
        ADD BC
        JR C,DIV15_5
DIV15_E:ADC A
        ADD HL,HL
        ADD BC
        JR C,DIV15_6
DIV15_F:ADC A
        ADD HL,HL
        ADD BC
        JR C,DIV15_7
DIV15_G:ADC A
        JP DIV15_8
DIV15_L:
        LD A,L
        ADD A
        LD (DIV15L+1),A
        LD A,H
        ADC A
        ADD A
        LD (DIV15H+1),A
        LD A,(BC)
        PUSH BC
DIV15L: LD HL,(M100T)
        ADD L
        ADD A
        LD (DIV15_8+1),A
        LD A,H
DIV15H: LD HL,(M100T)
        ADC L
        ADD A
        LD L,A
        JR NC,$+3
        INC H
DIV_N:  LD DE,-1
DIV_P:	LD BC,1
;34x7t
        ADD DE
        JR NC,DIV15_A
DIV15_1:ADC A
        ADD HL,HL
        ADD DE
        JR NC,DIV15_B
DIV15_2:ADC A
        ADD HL,HL
        ADD DE
        JR NC,DIV15_C
DIV15_3:ADC A
        ADD HL,HL
        ADD DE
        JR NC,DIV15_D
DIV15_4:ADC A
        ADD HL,HL
        ADD DE
        JR NC,DIV15_E
DIV15_5:ADC A
        ADD HL,HL
        ADD DE
        JR NC,DIV15_F
DIV15_6:ADC A
        ADD HL,HL
        ADD DE
        JR NC,DIV15_G
DIV15_7:ADC A
        ADD DE
DIV15_8:LD DE,0
        SRL E
        ADD DE
        JR C,$+4
        ADD BC
        CCF
        ADC 0
        POP BC
        LD (BC),A
        INC C
        JP NZ,DIV15_L
DIV15_X:
        INC B
DIV15_T:
        LD A,PI_10>>8
        CP B
        JP NZ,DIV15_L
        RET

DIV7:;[BC]/DIV
        LD A,(DIV_N+1)
        SUB 2
        LD (DIV_N+1),A
        RET C
DIV7_Y:
        LD E,A
        NEG
        LD D,A
        LD L,0
        LD BC,(PI_10)
        JP DIV7_T
DIV7_A: RL H
        ADC A
        ADD D
        JR C,DIV7_2
DIV7_B: RL H
        ADC A
        ADD D
        JR C,DIV7_3
DIV7_C: RL H
        ADC A
        ADD D
        JR C,DIV7_4
DIV7_D: RL H
        ADC A
        ADD D
        JR C,DIV7_5
DIV7_E: RL H
        ADC A
        ADD D
        JR C,DIV7_6
DIV7_F: RL H
        ADC A
        ADD D
        JR C,DIV7_7
DIV7_G: ADD D
        LD L,A
        LD A,H
        ADD A ;22t
        LD (BC),A
        INC C
        JR Z,DIV7_X
DIV7_L: ; 266t
        LD A,(BC) ;51t
        ADD A
        LD H,M200T>>8
        ADD A,(HL)
        INC H
        LD L,(HL)
        LD H,A
        LD A,L
        ADC 0
        RL H ;26x7
        ADC A
        ADD E 
        JR NC,DIV7_A
DIV7_1: RL H
        ADC A
        ADD E
        JR NC,DIV7_B
DIV7_2: RL H
        ADC A
        ADD E
        JR NC,DIV7_C
DIV7_3: RL H
        ADC A
        ADD E
        JR NC,DIV7_D
DIV7_4: RL H
        ADC A
        ADD E
        JR NC,DIV7_E
DIV7_5: RL H
        ADC A
        ADD E
        JR NC,DIV7_F
DIV7_6: RL H
        ADC A
        ADD E
        JR NC,DIV7_G
DIV7_7: LD L,A  ;33
        LD A,H
        ADC A
        LD (BC),A 
        INC C
        JP NZ,DIV7_L
DIV7_X:
        INC B
DIV7_T:
        LD A,PI_10>>8
        CP B
        JP NZ,DIV7_L
        RET

CALC:;pi=32*10-4*239-16*515
        LD A,PI_SUM>>8
        LD (PISUB+1),A
        LD HL,PI_10-PI_LEN-1
        LD (PI_10),HL
        LD HL,1
        LD (DIV_P+1),HL
        LD (DIV_N+1),HL
        CALL SETPI
        CALL SET239
        CALL SET515
CALC_3:
        CALL SET10
        CALL DIV239
        CALL NEG239
        CALL DIV103
        CALL SUB515
        CALL DIV15
        CALL PISUB
        CALL DIV239
        CALL DIV103
        CALL DIV25
        LD A,(PI_515+1)
        CP A,PI_515>>8
        JP C,CALC_3
CALC_2:
        CALL SET10
        CALL DIV239
        CALL NEG239
        CALL DIV15
        CALL PISUB
        CALL DIV239
        LD A,(PI_239+1)
        CP A,PI_239>>8
        JP C,CALC_2
CALC_1:
        CALL SET10
        CALL DIV15
        CALL PISUB
        LD A,(PI_10+1)
        CP A,PI_10>>8
        JP C,CALC_1
        CALL PI_SUB
        RET

PI_SUB:
        LD BC,-PI_LEN
        LD DE,PI_SUM
        LD HL,PI_TMP
        LD C,100
        JP PI_SUB_3
PI_SUB_1:;41+10t
        LD A,(DE)
        SBC (HL)
        JR NC,$+3
        ADD C
        LD (DE),A
PI_SUB_2:
        DEC E
        DEC L
        JP NZ,PI_SUB_1
        LD A,(DE)
        SBC (HL)
        JR NC,$+3
        ADD C
        LD (DE),A
PI_SUB_3:
        DEC H
        DEC D
        INC B
        JR NZ,PI_SUB_2
        LD BC,-PI_LEN
        LD B,100
PI_SUB_4:;41+14t
        DEC E
        DEC L
        LD A,(DE)
        SBC (HL)
        JR NC,$+3
        ADD B
        LD (DE),A
        INC C
        JP NZ,PI_SUB_4
        RET

PISUB:
        LD A,PI_SUM>>8
        LD BC,-PI_10
        LD HL,(PI_10)
        ADD HL,BC
        RET C
        LD B,100
        LD C,H
        XOR PI_SUM>>8
        XOR PI_TMP>>8
        LD (PISUB+1),A
        LD D,A
        LD E,0
        LD HL,PI_10
        JP PISUB_3
PISUB_1:;41+10t
        LD A,(DE)
        SBC (HL)
        JR NC,$+3
        ADD A,B
        LD (DE),A
PISUB_2:
        DEC E
        DEC L
        JP NZ,PISUB_1
        LD A,(DE)
        SBC (HL)
        JR NC,$+3
        ADD A,B
        LD (DE),A
PISUB_3:
        DEC H
        DEC D
        INC C
        JR NZ,PISUB_2
        LD A,(PI_10)
        LD C,A
PISUB_4:;41+14t
        DEC E
        DEC L
        LD A,(DE)
        SBC (HL)
        JR NC,$+3
        ADD A,B
        LD (DE),A
        INC C
        JP NZ,PISUB_4
        RET NC
PISUB_5:
        DEC DE
        LD A,(DE)
        SBC C ; 0
        JR NC,$+3
        ADD A,B
        LD (DE),A
        JP C,PISUB_5
        RET

NEG239:
        LD DE,(PI_239)
        LD HL,PI_10-PI_239
        ADD HL,DE
        EX DE,HL
        LD B,99
        JP NEG239_2
NEG239_1:;26+10t
        LD A,B
        SUB (HL)
        INC L
        LD (DE),A
        INC E
        JP NZ,NEG239_1
        INC H
        INC D
NEG239_2:
        LD A,PI_239>>8
        CP H
        JP NZ,NEG239_1
        RET

SUB515:
        LD DE,-PI_515
        LD HL,(PI_515)
        ADD HL,DE
        RET C
        LD B,100
        LD C,H
        LD DE,PI_10
        LD HL,PI_515
        JP SUB515_3
SUB515_1:;41+10t
        LD A,(DE)
        SBC (HL)
        JR NC,$+3
        ADD A,B
        LD (DE),A
SUB515_2:
        DEC E
        DEC L
        JP NZ,SUB515_1
        LD A,(DE)
        SBC (HL)
        JR NC,$+3
        ADD A,B
        LD (DE),A
SUB515_3:
        DEC H
        DEC D
        INC C
        JR NZ,SUB515_2
        LD A,(PI_515)
        LD C,A
SUB515_4:;41+14t
        DEC E
        DEC L
        LD A,(DE)
        SBC (HL)
        JR NC,$+3
        ADD A,B
        LD (DE),A
SUB515_5:
        INC C
        JP NZ,SUB515_4
        RET NC
SUB515_6:
        DEC DE
        LD A,(DE)
        SBC C ; 0
        JR NC,$+3
        ADD A,B
        LD (DE),A
        JP C,SUB515_6
        RET

SET515:
        LD HL,PI_515-PI_LEN
        LD (PI_515),HL
        LD A,PI_515>>8
        LD BC,32;16*10/5
        JR SET10_1
SET239:
        LD HL,PI_239-PI_LEN
        LD (PI_239),HL
        LD A,PI_239>>8
        LD BC,40;4*10
        JR SET10_1
SET10:
        LD HL,(PI_10)
        SUB A,A
        LD (HL),A
        LD A,PI_10>>8
        INC HL
        LD (PI_10),HL
        LD BC,99*256+31;32*10/10
SET10_1:
        CP H
        JR Z,SET10_X
        LD (HL),C
        INC HL
        CP H
        JR Z,SET10_X
SET10_2:;11+10t
        LD (HL),B
        INC L
        JP NZ,SET10_2
        INC H
SET10_3:
        CP H
        JR NZ,SET10_2
SET10_X:
        RET
SETPI:
        LD A,99
        LD BC,PI_LEN+256
        LD DE,PI_TMP-PI_LEN
        LD HL,PI_SUM-PI_LEN
SETPI_1:;22+10
        LD (HL),A
        LD (DE),A
        INC L
        INC E
        JP NZ,SETPI_1
        INC H
        INC D
        DEC B
        JR NZ,SETPI_1
        RET

INIT100:
        LD BC,200
        LD HL,M100T
INIT100_0:
        LD A,0
INIT100_L:
        RRC A
        LD (HL),A
        ADD A
        INC L
        LD (HL),B
        ADD A,C
        JR NC,INIT100_1
        INC B
INIT100_1:
        INC L
        JP NZ,INIT100_L
        RET

INIT200:
        LD BC,200
        LD HL,M200T
INIT200_0:
        LD A,0
INIT200_L:
        LD (HL),A
        INC H
        LD (HL),B
        DEC H
        ADD A,C
        JR NC,INIT200_1
        INC B
INIT200_1:
        INC L
        JP NZ,INIT200_L
        RET

INIT25:
        LD A,0
        LD BC,0*256+100
        LD HL,D25T
INIT25_2:
        LD (HL),A
        INC H
        LD (HL),B
        DEC H
        ADD A,4
        CP A,C;100
        JP C,INIT25_3
        SUB A,C;100
        INC B
INIT25_3:
        INC L
        JP NZ,INIT25_2
        RET

INIT103:
        LD DE,-103*256+100
        LD HL,D103T
        LD A,D
        LD B,L
        JP INIT239_2
INIT239:
        LD DE,-239*256+100
        LD HL,D239T
        LD A,D
        LD B,L
        JP INIT239_2
INIT239_1:
        INC L
        JR Z,INIT239_3
INIT239_2:;49/55t
        LD (HL),A
        INC H
        LD (HL),B
        DEC H
        ADD A,E
        JR NC,INIT239_1
        ADD A,D
        INC B
        INC L
        JP NZ,INIT239_2
INIT239_3:RET

DIV25:
        LD HL,(PI_515)
        LD B,0
        LD DE,D25T
        JP DIV25_T
DIV25_L:;58 t/b
        LD E,(HL)       ;7
        INC D           ;4
        LD A,(DE)       ;7
        DEC D           ;4
        ADD A,B         ;4
        LD (HL),A       ;7
        LD A,(DE)       ;7
        LD B,A          ;4
        INC L           ;4
        JP NZ,DIV25_L   ;10
DIV25_X:
        INC H
DIV25_T:
        LD A,PI_515>>8
        CP H
        JR NZ,DIV25_L
        LD HL,(PI_515)
        CP H
        JR Z,DIV25_R
        LD A,(HL)
        OR A,A
        JR NZ,DIV25_R
        INC HL
        LD (PI_515),HL
DIV25_R:
        RET

DIV103:
        LD BC,D103T
        LD DE,D103T+256
        LD HL,(PI_515)
        JP DIV103_T
DIV103_1:
        LD C,A          ;4
        LD A,(DE)       ;7
        INC A           ;4
        LD (HL),A       ;7
        INC L           ;4
        JR Z,DIV103_X   ;7
DIV103_L:;64 t/b
        LD E,C          ;4
        LD A,(BC)       ;7
        ADD A,(HL)      ;7
        JR C,DIV103_1   ;7/12
        ADD A,103       ;7
        LD C,A          ;4
        LD A,(DE)       ;7
        LD (HL),A       ;7
        INC L           ;4
        JP NZ,DIV103_L  ;10
DIV103_X:
        INC H
DIV103_T:
        LD A,PI_515>>8
        CP H
        JR NZ,DIV103_L
        LD HL,(PI_515)
        CP H
        JR Z,DIV103_R
        INC HL
        LD (PI_515),HL
DIV103_R:
        RET

DIV239:
        LD BC,D239T
        LD DE,D239T+256
        LD HL,(PI_239)
        JP DIV239_T
DIV239_1:
        LD C,A          ;4
        LD A,(DE)       ;7
        INC A           ;4
        LD (HL),A       ;7
        INC L           ;4
        JR Z,DIV239_X   ;7
DIV239_L:;64 t/b
        LD E,C          ;4
        LD A,(BC)       ;7
        ADD A,(HL)      ;7
        JR C,DIV239_1   ;7/12
        ADD A,239       ;7
        LD C,A          ;4
        LD A,(DE)       ;7
        LD (HL),A       ;7
        INC L           ;4
        JP NZ,DIV239_L  ;10
DIV239_X:
        INC H
DIV239_T:
        LD A,PI_239>>8
        CP H
        JR NZ,DIV239_L
        LD HL,(PI_239)
        CP H
        JR Z,DIV239_R
        INC HL
        LD (PI_239),HL
        CP H
        JR Z,DIV239_R
        LD A,(HL)
        OR A,A
        JR NZ,DIV239_R
        INC HL
        LD (PI_239),HL
DIV239_R:
        RET

BENCH:
        LD HL,(TIME)
        EX DE,HL
        LD HL,(TICK)
BENCH_P:LD (TIME),HL
        LD A,L
        SUB A,E
        LD L,A
        LD A,H
        SBC A,D
        LD H,A
        LD DE,$5A6D
        CALL PRINT_NUM
        LD A,(BENCH+1)
        ADD 2
        JP NZ,BENCH_1
        LD A,TIME
BENCH_1:LD (BENCH+1),A
        LD (BENCH_P+1),A
        RET

CLEAR:
        LD HL,$4000
        LD BC,$1800
CLEAR_1:
        LD (HL),C
        INC L
        JR NZ,CLEAR_1
        INC H
        DEC B
        JR NZ,CLEAR_1
        LD A,$41
        LD BC,$305
        LD E,10
CLEAR_2:
        LD (HL),A
        DEC C
        JR NZ,CLEAR_3
        XOR 3
        LD C,5
        DEC E
        JR NZ,CLEAR_3
        XOR $44
        LD E,10
CLEAR_3:
        INC L
        JR NZ,CLEAR_2
        INC H
        DEC B
        JR NZ,CLEAR_2
        LD HL,P_END+1
CLEAR_4:
        LD (HL),C
        INC L
        JR NZ,CLEAR_4
        INC H
        JR NZ,CLEAR_4
        RET

INITF:
        LD DE,FONT2
        LD BC,FONT
        LD HL,FONT
        CALL INTIF_1
        LD HL,FONT+10
        CALL INTIF_1
        LD HL,FONT+20
        CALL INTIF_1
        LD HL,FONT+30
        CALL INTIF_1
        LD HL,FONT+40
        CALL INTIF_1
        RET
INTIF_1:
        CALL INITF_2
        CALL INITF_2
        CALL INITF_2
        CALL INITF_2
        CALL INITF_2
        CALL INITF_2
        CALL INITF_2
        CALL INITF_2
        CALL INITF_2
        CALL INITF_2
        LD E,0
        INC D
        RET
INITF_2:
        LD A,(BC)
        INC BC
        ADD A
        ADD A
        ADD A
        ADD A
        PUSH HL
        CALL INITF_3
        CALL INITF_3
        CALL INITF_3
        CALL INITF_3
        CALL INITF_3
        CALL INITF_3
        CALL INITF_3
        CALL INITF_3
        CALL INITF_3
        CALL INITF_3
        POP HL
        RET
INITF_3:
        ADD (HL)
        LD (DE),A
        SUB (HL)
        INC E
        INC HL
        RET
FONT:   DEFB 7,2,7,7,4, 7,3,7,7,7
        DEFB 5,6,1,1,5, 4,4,1,5,5
        DEFB 5,2,3,2,7, 7,7,1,2,7
        DEFB 5,2,4,1,1, 1,5,1,5,1
        DEFB 7,2,7,7,1, 7,7,1,7,6

PRINT:
        LD HL,PI_SUM-PI_LEN
        LD DE,$4000
        LD BC,FONT2
        CALL PRINT_A
        CALL PRINT_A
        CALL PRINT_A
        CALL PRINT_A
        CALL PRINT_A
        RET
PRINT_A:
        PUSH HL
        PUSH DE
        JP PRINT_T
PRINT_D:
        LD A,D
        ADD 8
        CP $58
        LD D,A
        JR NC,PRINT_X
        JP PRINT_E
PRINT_B:
        LD C,(HL)
        LD A,(BC)
        LD (DE),A
        INC E
        JR Z,PRINT_D
PRINT_E:
        INC L
        JR NZ,PRINT_B
        INC H
PRINT_T:
        LD A,PI_SUM>>8
        CP H
        JR NZ,PRINT_B
PRINT_X:
        POP DE
        POP HL
        INC B
        INC D
        RET

COLOR: DEFW $445F
PRINT_DIG MACRO AA,BB,CC,DD,EE,FF,GG,HH,II,JJ,KK,LL,MM,NN,OO
        SBC HL,BC
        PUSH HL
        EX DE,HL
        LD DE,30
        LD BC,(COLOR)
        LD (HL),AA
        INC L
        LD (HL),BB
        INC L
        LD (HL),CC
        PUSH HL
        ADD HL,DE
        LD (HL),DD
        INC L
        LD (HL),EE
        INC L
        LD (HL),FF
        ADD HL,DE
        LD (HL),GG
        INC L
        LD (HL),HH
        INC L
        LD (HL),II
        ADD HL,DE
        LD (HL),JJ
        INC L
        LD (HL),KK
        INC L
        LD (HL),LL
        ADD HL,DE
        LD (HL),MM
        INC L
        LD (HL),NN
        INC L
        LD (HL),OO
        POP DE
        INC E
        INC E
        POP HL
        RET
        ENDM

PRINT_NUM_COL:
        LD (COLOR),BC
PRINT_NUM:
        LD BC,-10000
        CALL PRINT_0
        LD BC,-1000
        CALL PRINT_0
        LD BC,-100
        CALL PRINT_0
        LD BC,-10
        CALL PRINT_0
        LD BC,-1
PRINT_0:
        ADD HL,BC
        JR C,PRINT_1
        PRINT_DIG C,C,C, C,B,C, C,B,C, C,B,C, C,C,C
PRINT_1:
        ADD HL,BC
        JR C,PRINT_2
        PRINT_DIG B,B,C, B,C,C, B,B,C, B,B,C, B,B,C
PRINT_2:
        ADD HL,BC
        JR C,PRINT_3
        PRINT_DIG C,C,C, B,B,C, B,C,C, C,B,B, C,C,C
PRINT_3:
        ADD HL,BC
        JR C,PRINT_4
        PRINT_DIG C,C,C, B,B,C, B,C,B, B,B,C, C,C,C
PRINT_4:
        ADD HL,BC
        JR C,PRINT_5
        PRINT_DIG C,B,B, C,B,C, C,C,C, B,B,C, B,B,C
PRINT_5:
        ADD HL,BC
        JR C,PRINT_6
        PRINT_DIG C,C,C, C,B,B, C,C,C, B,B,C, C,C,C
PRINT_6:
        ADD HL,BC
        JR C,PRINT_7
        PRINT_DIG B,C,C, C,B,B, C,C,C, C,B,C, C,C,C
PRINT_7:
        ADD HL,BC
        JR C,PRINT_8
        PRINT_DIG C,C,C, B,B,C, B,B,C, B,B,C, B,B,C
PRINT_8:
        ADD HL,BC
        JR C,PRINT_9
        PRINT_DIG C,C,C, C,B,C, B,C,B, C,B,C, C,C,C
PRINT_9:
        ADD HL,BC
        PRINT_DIG C,C,C, C,B,C, C,C,C, B,B,C, C,C,B

P_END = $
