#include <stdint.h>
#include <string.h>
#define LEN 501

//    10pi=320*atan(1/10)-40*atan(1/239)-160*atan(1/515)
uint8_t pi[LEN];//   ,    tmp
uint8_t tmp[LEN];//   
uint8_t d10[LEN];//320/10^n
uint8_t d239[LEN];//40/239^n
uint8_t d515[LEN];//160/515^n

//   v  s,        x
//            
void pi_sub(uint8_t *s, uint8_t *v, int x){
	int i=LEN, c=0;
	while(i>x || c){
		--i;
		s[i]-=v[i]+c;//   
		c=s[i]>99;//     ,     
		if(c)
			s[i]+=100;
	}
}

//    
int r25[256];//i%25 //  24*4+100 
int q25[256];//i/25
int r103[256];//i*100%103 // 103 
int q103[256];//i*100/103
int r239[256];//i*100%239 // 239 
int q239[256];//i*100/239

//   d515  25
int div25(int x){
	for(int i=x,r=0;i<LEN;i++){
//    r    d515  (100r+d)/25  (100r+d)%25
		int d=d515[i];
		d515[i]=r*4+q25[d];
		r=r25[d];
	}
	while(x<LEN && !d515[x]) ++x;//     
	return x;
}

//   d515  103
int div103(int x){
	for(int i=x,r=0;i<LEN;i++){
//    r    d515  (100r+d)/103  (100r+d)%103
		int d=q103[r];
		r=r103[r]+d515[i];
		if(r>=103){//  r103  103,        
			r-=103;
			++d;
		}
		d515[i]=d;
	}
	while(x<LEN && !d515[x]) ++x;
	return x;
}

//   d239  239
int div239(int x){
	for(int i=x,r=0;i<LEN;i++){
//    r    d239  (100r+d)/239  (100r+d)%239
		int d=q239[r];
		r=r239[r]+d239[i];
		if(r>=239){//  r239  239,        
			r-=239;
			++d;
		}
		d239[i]=d;
	}
	while(x<LEN && !d239[x]) ++x;
	return x;
}

//  :   ,      239^2
int div239_2(int x){
	for(int i=x,r1=0,r2=0;i<LEN;i++){
//    r    d239  (100r+d)/239  (100r+d)%239
		int d1=q239[r1];
		r1=r239[r1]+d239[i];
		if(r1>=239){
			r1-=239;
			++d1;
		}
		int d2=q239[r2];
		r2=r239[r2]+d1;
		if(r2>=239){
			r2-=239;
			++d2;
		}
		d239[i]=d2;
	}
	while(x<LEN && !d239[x]) ++x;
	return x;
}

//    n
int Q[LEN*2];//i*100/n
int R[LEN*2];//i*100%r
//  n>100  
void div10T(int x, int n){
	int q=0,r=0,i=0;
	do{//   
		Q[i]=q;
		R[i]=r;
		++i;
		r+=100;
		if(r>=n){//       
			r-=n;//        n     
			++q;
		}
	}while(q<100);
//      LEN,     ,    
	for(int i=x,r=0;i<LEN;i++){
		int d=Q[r];
		r=R[r]+d10[i];
		if(r>=n){//     
			r-=n;
			++d;
		}
		d10[i]=d;
	}
}

//  d10(=d10-d239-d515)   
//    
void div10(int x, int n){
	if(n>100 && n<LEN*13/7){ // n<100   
		//   n    ,     
		div10T(x,n);
		return;
	}
	for(int i=x,r=0;i<LEN;i++){
		int s=r*100+d10[i];
		d10[i]=s/n;
		r=s%n;
	}
}

//    10pi=320*atan(1/10)-40*atan(1/239)-160*atan(1/515)
void calc_pi(){
	for(int i=0;i<256;i++){// 
		r25[i]=i%25;
		q25[i]=i/25;
		r103[i]=i*100%103;
		q103[i]=i*100/103;
		r239[i]=i*100%239;
		q239[i]=i*100/239;
	}
	memset(pi,99,LEN);//  
	memset(tmp,99,LEN);
	memset(d239,0,LEN); d239[0]=40;
	memset(d515,0,LEN); d515[0]=160/5;
	int i239=div239(0);
	int i515=div103(0);
	for(int i10=0;i10<LEN;i10++){
		memset(d10+i10,99,i239-i10); d10[i10]=31; //319999999....
		for(int i=i239;i<LEN;i++)//neg239
			d10[i]=99-d239[i];
		pi_sub(d10,d515,i515);
		div10(i10,i10*2+1);
		if(i10&1)
			pi_sub(pi,d10,i10);
		else
			pi_sub(tmp,d10,i10);
		d10[i10]=0; //  ,   x    
//		i239=div239(div239(i239));
		i239=div239_2(i239);
		i515=div103(div103(div25(i515)));
	}
	pi_sub(pi,tmp,0);
	for(int i=0;i<LEN;i++)
		printf("%02d",pi[i]);
}
