;      pi  
; 10pi=32atan(1/10)-40atan(1/239)-160atan(1/515)
;  8000-9500,  000  
;       
;  EmuZWin,     8080
;    578,     

; 100  ,      
; 100  300  1000  2000  3000   4000 
; 13   67   649   2513  5589   9879 
;0.26 1.34 12.98 50.26 111.78 197.58 

;      
; 5000  6000  7000  8000  9000 10000 
;15487 22246 30225 39421 49839 61473 
; 309   445   604   788   997   1229 

;    ,   
PI_EXT = 1
TICK=$5C78      ; 
START = $8000   ; 
;      10 
PI_MEM=$800     ;$1400  ;    pi  
PI_SUM = $A700  ;$7F00	;  pi
TICKS=PI_SUM-PI_EXT	;    
PI_TMP=$A800    ;$9600	;  
PI_10 = PI_TMP+1*PI_MEM 
PI_239 = PI_TMP+2*PI_MEM
PI_515 = PI_TMP+3*PI_MEM

        org START
        JR MAIN
        DEFW 0
        DEFW 0,0,0,0,0,0,0,0

DIV_TH = $60E8 ;    
; N<100     100i/N, 100i%N  i/N
; N<256     100i/N  100i%N
TH_FULL: DEFW 0 ;      
TH_HALF: DEFW 0 ;      
;   

LEN_PI: DEFW 0  ;  = digits/2
LEN_10: DEFW 0  ; 32/10^n
LEN_239: DEFW 0 ; 40/239^n
LEN_515: DEFW 0 ; 160/515^n

END_10: DEFW 0  ; 32/10^n
END_239: DEFW 0 ; 40/239^n
END_515: DEFW 0 ; 160/515^n
REST_100: DEFW 0;    max(100,n)/min(100,n)

LOG239 = 24798  ;REST(LOG(239^2)/LOG(100))*2^16
LOG515 = 46648  ;REST(LOG(515^2)/LOG(100))*2^16
LOG239S = 25439 ;(LOG(239)-LOG(40))/LOG(100)*2^16
LOG515S = 16635 ;(LOG(103)-LOG(32))/LOG(100)*2^16
LOW_239: DEFW 0 ;   40/239^n
LOW_515: DEFW 0 ;   160/515^n
;      
DIV_P: DEFW 0   
DIV_N: DEFW 0

MAIN:
        DI
        LD SP,STACK
        CALL CLEAR      ; 
        EI
MAIN_1:
        LD HL,TICKS
        LD (TIME+1),HL  ;    
;     
        LD BC,DIV_TH
        LD HL,-PI_EXT-100>>1
        CALL BENCH
        CALL DELAY
        LD BC,DIV_TH
        LD HL,-PI_EXT-300>>1
        CALL BENCH
        LD BC,DIV_TH
        LD HL,-PI_EXT-1000>>1
        CALL BENCH
        LD BC,DIV_TH
        LD HL,-PI_EXT-2000>>1
        CALL BENCH
        LD BC,DIV_TH
        LD HL,-PI_EXT-3000>>1
        CALL BENCH
        LD BC,DIV_TH
        LD HL,-PI_EXT-4000>>1
        CALL BENCH
        CALL DELAY
        JP MAIN_1
;   
FOR FVAR=6 TO 5
        LD BC,$60E8+FVAR*$001
        LD HL,-PI_EXT-4000>>1
        CALL BENCH
ENDFOR
;        JP MAIN_1

DELAY:
        LD A,16 ;16  
DELAY_L:
        DEC L
        JR NZ,DELAY_L
        DEC H
        JR NZ,DELAY_L
        DEC A
        JR NZ,DELAY_L
        RET

;     
DIVHALF:
        CALL FILLHALF
        LD HL,(LEN_10)
        EX DE,HL
        LD HL,(END_10)
        ADD HL,DE
        LD B,H
        LD C,L
        
        LD HL,(DIV_N)
        LD (DIVHALF_N+1),HL
        RRC L
        SLA L
        JP DIVHALF_2
DIVHALF_1:;106/117
        RRC A   ;41
        ADD A
        LD E,A
        LD A,(HL)
        LD (BC),A
        INC C
        EX DE,HL
        JR Z,DIVHALF_4
DIVHALF_2:;144
        LD A,(BC)       ;53
        JR NC,$+4
        ADD A,100
DIVHALF_3:
        ADD HL,HL       
        ADD (HL)
        INC L
        LD D,(HL)
        INC L
        JR NC,DIVHALF_1  ;11/12
        INC D
        JR NZ,DIVHALF_1  ;80/12
        LD E,A
        LD A,(HL)
DIVHALF_N: LD HL,0
        ADD HL,DE
        RRC L
        SLA L
        INC A
        LD (BC),A
        INC C
        JP NZ,DIVHALF_2
DIVHALF_4:
        INC B
        LD A,(BC)       ;46
        JR NC,$+4
        ADD A,100
        LD D,A
        LD A,(END_10+1)
        CP B
        LD A,D
        JR NZ,DIVHALF_3

        LD HL,(DIV_N)
        LD BC,-2
        ADD HL,BC
        LD (DIV_N),HL

        LD HL,(DIV_P)
        LD BC,2
        ADD HL,BC
        LD (DIV_P),HL

        EX DE,HL
        LD HL,(TH_HALF)
        ADD HL,DE
        RET NC
        LD HL,DIV15
        LD (DIVALG),HL
        RET

FILLHALF:;  
        LD HL,(DIV_P)
        LD A,(REST_100+1)
        SRL A
        JR FILLBIG
FILLFULL:;  
        LD HL,(DIV_P)
        ADD HL,HL
        LD A,(REST_100+1)
FILLBIG:;  
        LD (FILLBIG_PP+1),HL
        NEG
        LD L,A
        LD E,A
        SBC A
        LD H,A
        LD D,A
        ADD HL,HL
        ADD HL,DE
        LD DE,FILLBIG_Z1
        ADD HL,DE
        LD (FILLBIG_J1+1),HL
        LD (FILLBIG_J2+1),HL

        LD HL,0
        ADD HL,SP
        LD (FILLBIG_SP+1),HL
        LD A,-1
        LD BC,99
        LD DE,-200
        LD HL,-200
        LD SP,0
        JP FILLBIG_J1-1
FOR FVAR=0 TO PI_MEM STEP 50
        PUSH BC         ;33t
        PUSH HL
        ADD HL,DE       ;-200
ENDFOR
FILLBIG_Z1:
        EX DE,HL
FILLBIG_PP:LD HL,0
        ADD HL,DE       ;+=2P
        JR NC,FILLBIG_D
        PUSH BC
        PUSH DE
        LD DE,-200
        ADD HL,DE
        DEC C
        CP C
FILLBIG_J1:JP NZ,FILLBIG_Z1
        PUSH BC
        PUSH HL
        JR FILLBIG_SP
FILLBIG_D:
        LD DE,-200
        DEC C
        CP C
FILLBIG_J2:JP NZ,FILLBIG_Z1
        PUSH BC
        PUSH HL
FILLBIG_SP:LD SP,0
        LD A,(REST_100)
        ADD 2
        LD (REST_100),A
        SUB 100
        RET C
        LD (REST_100),A
        LD HL,REST_100+1
        INC (HL)
        RET

;   
DIVFULL:
        CALL FILLFULL

        LD HL,(LEN_10)
        EX DE,HL
        LD HL,(END_10)
        ADD HL,DE
        LD B,H
        LD C,L

        LD HL,(DIV_N)
        ADD HL,HL
        LD (DIVFULL_2N+1),HL
        JP DIVFULL_2
DIVFULL_1:;89/100
        EX DE,HL        ;22
        LD (BC),A
        INC C
        JR Z,DIVFULL_4
DIVFULL_2:;119
        ADD HL,HL       ;55
        LD A,(BC)
        ADD A
        ADD (HL)
        INC L
        LD D,(HL)
        LD E,A
        INC L
        LD A,(HL)
        JR NC,DIVFULL_1   ;11/12
        INC D
        JR NZ,DIVFULL_1   ;53/12
        INC A
DIVFULL_2N: LD HL,0
        ADD HL,DE
        LD (BC),A
        INC C
        JP NZ,DIVFULL_2
DIVFULL_4:
        INC B
        LD A,(END_10+1)
        CP B
        JP NZ,DIVFULL_2

        LD HL,(DIV_N)
        LD BC,-2
        ADD HL,BC
        LD (DIV_N),HL

        LD HL,(DIV_P)
        LD BC,2
        ADD HL,BC
        LD (DIV_P),HL

        EX DE,HL
        LD HL,(TH_FULL)
        ADD HL,DE
        RET NC
        LD HL,DIVHALF
        LD (DIVALG),HL
        RET

;  
;use AF,B,HL
TIME:   LD HL,START-PI_EXT+3    ;  
        LD B,(HL)       ;   
        LD A,(TICK)     
        LD (HL),A
        SUB B   ;    
TIME_1:
        DEC HL
        ADD (HL)        ;  
        LD (HL),A
        SUB 100         
        RET C           ;    
        LD (HL),A
        LD A,1          ;   
        JR TIME_1

;  pi
CALC:
        LD HL,INITDIV
        LD (DIVALG),HL

        LD HL,PI_10
        LD (END_10),HL
        LD HL,LOG239S
        LD (LOW_239),HL
        LD HL,LOG515S
        LD (LOW_515),HL

        LD HL,(LEN_PI)
        INC HL
        LD (LEN_239),HL
        LD (LEN_515),HL
        DEC HL
        LD (LEN_10),HL
        LD BC,$9C9C     ;  pi   -100
        EX DE,HL        ;  
        LD HL,PI_SUM
        CALL SETVAR

        LD BC,$2800
        LD HL,(LEN_PI)
        EX DE,HL
        LD HL,PI_239
        LD (END_239),HL
        CALL SETVAR
        LD HL,(LEN_PI)
        CALL DIV239

        LD BC,$2000
        LD HL,(LEN_PI)
        EX DE,HL
        LD HL,PI_515
        LD (END_515),HL
        CALL SETVAR
        LD HL,(LEN_PI)
        CALL DIV103
CALC_L: ; 
;        CALL MOVE      ;    10 
        CALL SET10      ;  
        LD HL,(LEN_239)
        LD A,H
        OR A
        CALL NZ,NEG239  ;    
        LD HL,(LEN_515)
        LD A,H
        OR A
        CALL NZ,SUB515  ;    
        CALL DIV10      ;    
        CALL ADD10      ;    pi
        CALL TIME
        LD HL,(LEN_10)
        INC HL
        LD (LEN_10),HL
        LD A,H
        OR A
        RET Z           ;    
        
        CALL SET10
        LD HL,(LEN_239)
        LD A,H
        OR A
        CALL NZ,NEG239
        LD HL,(LEN_515)
        LD A,H
        OR A
        CALL NZ,SUB515
        CALL DIV10
        CALL SUB10      ;   
        LD HL,(LEN_10)
        INC HL
        LD (LEN_10),HL
        LD A,H
        OR A
        JR NZ,CALC_L
        CALL TIME
        RET

;      
MOVE:
        LD HL,0
        ADD HL,SP
        LD (MOVE_SP+1),HL

        LD DE,PI_TMP
        LD HL,(END_10)
        LD A,(LEN_10+1)
        ADD H
        JR NC,MOVE_1
        LD B,H
        LD H,A
        LD A,D
        SUB H
        JR Z,MOVE_1
        ADD B
        LD (END_10+1),A
MOVE_1:

        LD HL,(END_10)
        EX DE,HL
        LD HL,(END_239)
        LD A,(LEN_239+1)
        ADD H
        JR NC,MOVE_3
        LD B,H
        LD H,A
        LD A,D
        SUB H
        JR Z,MOVE_3
        ADD B
        LD (END_239+1),A
        LD SP,HL
        EX DE,HL
MOVE_2:
        POP BC
        LD (HL),C
        INC L
        LD (HL),B
        INC L
        JP NZ,MOVE_2
        INC H
        CP H
        JR NZ,MOVE_2
MOVE_3:
        LD HL,(END_239)
        EX DE,HL
        LD HL,(END_515)
        LD A,(LEN_515+1)
        ADD H
        JR NC,MOVE_5
        LD B,H
        LD H,A
        LD A,D
        SUB H
        JR Z,MOVE_5
        ADD B
        LD (END_515+1),A
        LD SP,HL
        EX DE,HL
MOVE_4:
        POP BC
        LD (HL),C
        INC L
        LD (HL),B
        INC L
        JP NZ,MOVE_4
        INC H
        CP H
        JR NZ,MOVE_4
MOVE_5:
MOVE_SP: LD SP,0
        RET

; HL=HL*A/128
;use AF,DE
MULHLA:
        EX DE,HL
        LD HL,0
MULHLA_1:
        ADD A
        JR NC,$+3
        ADD HL,DE
        RET Z
        SRA D
        RR E
        JR MULHLA_1

;IN: DE=LEN
BENCH:
        LD (LEN_PI),HL  ;  
        LD A,B
        CALL MULHLA
        LD (TH_FULL),HL
        LD HL,(LEN_PI)
        LD A,C
        CALL MULHLA
        LD (TH_HALF),HL

        LD HL,(TIME+1)  ;  
        SUB A
        LD (HL),A
        INC HL
        LD (HL),A
        INC HL
        LD (HL),A
        INC HL
        LD (HL),A
        LD (TIME+1),HL  ;  
        
        LD HL,0 	
        LD (TICK),HL    ;  
        
        CALL CALC       ; pi
        
        SUB A           ;  
        LD HL,(TIME+1)
        LD (HL),A

        LD BC,0         ; 
        LD DE,-$17C0
        LD HL,$5800
        CALL SETVAR
BENCH_C:
        DEC L
        LD (HL),B
        JP NZ,BENCH_C
;       
PRNT:
        LD HL,(LEN_PI)
        LD A,L
        SUB 18-PI_EXT
        LD C,A
        LD A,H
        SBC 0
        LD B,$50
        INC A
        JR Z,PRNT_1
        LD B,$48
        INC A
        JR Z,PRNT_1
        LD B,$40
        INC A
        JR Z,PRNT_1
        LD C,0
        LD HL,-750-PI_EXT
PRNT_1:
        LD DE,PI_SUM
        ADD HL,DE
        EX DE,HL
;    6  
PRINT:
        LD A,(DE)       ;  
        PUSH DE
        LD DE,$0301
        LD HL,$1E0A
        CALL DIGIT_L    ;   
        EX DE,HL
        CALL DIGIT_L
        RL L
        RL H
        SBC A
        RL E
        RL D
        PUSH BC
        CALL PRINT_F    ; 5   
        CALL PRINT_C
        CALL PRINT_C
        LD D,E
        LD H,L
        CALL PRINT_C
        CALL PRINT_C
        POP BC
        POP DE
        INC DE
        INC C
        JR NZ,PRINT     ;  
        LD A,B
        ADD 8
        LD B,A
        CP $58
        JR C,PRINT      ;   
        RET

;    
PRINT_C:
        INC B
        RL H
        SBC A
        RL D
PRINT_F:
        ADC A
        RL D
        ADC A
        RL D
        ADC A
        ADD A
        RLC A
        RL H
        ADC A
        RL H
        ADC A
        ADD A
        LD (BC),A
        RET

;   
DIGIT_L:	
        SUB H
        JR C,DIGIT_0
        SUB H
        JR C,DIGIT_3
        SUB H
        JR C,DIGIT_6
DIGIT_9:LD HL,75716.o*2
        RET
DIGIT_0:ADD L
        JR C,DIGIT_2
        ADD L
        JR C,DIGIT_1
        ADD L
        LD HL,75557.o*2
        RET
DIGIT_1:LD HL,26227.o*2
        RET
DIGIT_2:LD HL,71347.o*2
        RET
DIGIT_3:ADD L
        JR C,DIGIT_5
        ADD L
        JR C,DIGIT_4
        ADD L
        LD HL,71217.o*2
        RET
DIGIT_4:LD HL,45711.o*2
        RET
DIGIT_5:LD HL,74717.o*2
        RET
DIGIT_6:ADD L
        JR C,DIGIT_8
        ADD L
        JR C,DIGIT_7
        ADD L
        LD HL,34757.o*2
        RET
DIGIT_7:LD HL,71122.o*2
        RET
DIGIT_8:LD HL,75257.o*2
        RET
        
;      
SET10:
        LD BC,$1F63
        LD HL,(LEN_239)
        EX DE,HL
        LD HL,(END_10)
        ADD HL,DE
        LD A,(LEN_10)
        SUB E
        LD E,A
        LD A,(LEN_10+1)
        SBC D
        LD D,A
;IN: BC=VAL, DE=-LEN, HL=END
;USE: ALL
SETVAR:
        LD (SETVAR_END+1),HL
        ADD HL,DE
        RET NC
        LD (SETVAR_VAR+1),HL
        LD A,B
        LD B,C
        LD HL,0
        ADD HL,SP
        LD (SETVAR_SP+1),HL
SETVAR_END:LD SP,0
        SCF
        RR E
        SRA E
        JR C,$+3
        PUSH BC
        SRA E
        JR C,$+4
        PUSH BC
        PUSH BC
        SRA E
        JR C,SETVAR_T
        PUSH BC
        PUSH BC
        PUSH BC
        PUSH BC
        JP SETVAR_T
SETVAR_L:
        PUSH BC
        PUSH BC
        PUSH BC
        PUSH BC
        PUSH BC
        PUSH BC
        PUSH BC
SETVAR_T:
        PUSH BC
        INC E
        JP NZ,SETVAR_L
        LD E,-16
        INC D
        JP NZ,SETVAR_L
SETVAR_SP:LD SP,0
SETVAR_VAR:LD HL,0
        LD (HL),A
        INC L
        JR Z,$+3
        LD (HL),B
        RET

; 3   103
DIV103:
        EX DE,HL
        LD HL,(END_515)
        ADD HL,DE
        LD BC,T103MOD
        LD DE,T103DIV
        JP DIV103_L
DIV103_1:
        LD C,A          ;32
        LD A,(DE)
        INC A
        LD (HL),A
        INC L
        JR Z,DIV103_2
DIV103_L:;57/70=62t/b
        LD E,C          ;18
        LD A,(BC)
        ADD (HL)
        JR C,DIV103_1  ;7/12
        ADD A,103       ;40
        LD C,A
        LD A,(DE)
        LD (HL),A
        INC L
        JP NZ,DIV103_L
DIV103_2:
        INC H
        LD A,(END_515+1)
        CP H
        JR NZ,DIV103_L
        RET

; 2   239
DIV239:
        EX DE,HL
        LD HL,(END_239)
        ADD HL,DE
        LD BC,T239MOD
        LD DE,T239DIV
        JP DIV239_L
DIV239_1:
        LD C,A          ;32
        LD A,(DE)
        INC A
        LD (HL),A
        INC L
        JR Z,DIV239_2
DIV239_L:;57/70=62t/b
        LD E,C          ;18
        LD A,(BC)
        ADD (HL)
        JR C,DIV239_1  ;7/12
        ADD A,239       ;40
        LD C,A
        LD A,(DE)
        LD (HL),A
        INC L
        JP NZ,DIV239_L
DIV239_2:
        INC H
        LD A,(END_239+1)
        CP H
        JR NZ,DIV239_L
        RET

; 2   1   31999999...
;  99  1   
NEG239:
        LD B,H
        LD C,L
        LD HL,(END_10)
        ADD HL,BC
        EX DE,HL
        LD HL,(END_239)
        ADD HL,BC
        LD B,99
NEG239_L:
        LD A,B
        SUB (HL)
        LD (DE),A
        INC L
        INC E
        JP NZ,NEG239_L
        INC H
        INC D
        LD A,(END_239+1)
        CP H
        JR NZ,NEG239_L
DD239:  ; 2   239^2
        LD HL,(LEN_239)
        EX DE,HL
        LD HL,(END_239)
        ADD HL,DE
        RET NC
        EX DE,HL
        LD BC,0
        LD HL,T239MOD
        JP DD239_L
DD239_1:
        LD C,A
        INC H
        LD A,(HL)
        DEC H
        INC A
        LD (DE),A
        INC E
        JR Z,DD239_2
DD239_L:
        LD L,B
        LD A,(DE)
        ADD (HL)
        JR C,$+4
        SUB -239
        LD B,A
        INC H
        LD A,(HL)
        DEC H
        LD L,C
        ADC (HL)
        JR C,DD239_1
        SUB -239
        LD C,A
        INC H
        LD A,(HL)
        DEC H
        LD (DE),A
        INC E
        JP NZ,DD239_L
DD239_2:
        INC D
        LD A,(END_239+1)
        CP D
        JR NZ,DD239_L
INC239: ;   2 
        LD DE,LOG239
        LD HL,(LOW_239)
        ADD HL,DE
        LD (LOW_239),HL
        LD HL,(LEN_239)
        JR NC,$+3
        INC HL
        INC HL
        INC HL
        LD (LEN_239),HL
        LD A,H
        OR A
        RET NZ
        LD (LEN_239),A
        RET

; 3   1
SUB515:
        LD HL,(LEN_515)
        LD A,H
        OR L
        RET Z
        LD B,H
        LD C,L
        LD HL,(END_10)
        EX DE,HL
        LD HL,(END_515)
        PUSH BC
        LD C,100
        JP SUB515_4
SUB515_1:
        LD (DE),A       ;18
        DEC E
        JR Z,SUB515_33
SUB515_2:;50/48=49
        DEC L
        LD A,(DE)       ;18
        SBC (HL)
        JR NC,SUB515_1  ;7/12
        ADD A,C ;=100   ;25
        LD (DE),A
SUB515_3:
        DEC E
        JP NZ,SUB515_2
SUB515_33:
        DEC L
        LD A,(DE)       ;18
        SBC (HL)
        JR NC,$+3  ;7/12
        ADD A,C ;=100   ;25
        LD (DE),A
SUB515_4:
        DEC D
        DEC H
        INC B
        JR NZ,SUB515_3
        POP BC
        LD B,100
        JP SUB515_6
SUB515_5:
        LD (DE),A       ;22
        INC C
        JR Z,SUB515_8
SUB515_6:;54/52=53
        DEC E
        DEC L
        LD A,(DE)       ;18
        SBC (HL)
        JR NC,SUB515_5  ;7/12
        ADD A,B ;=100   ;29
        LD (DE),A
SUB515_7:
        INC C
        JR NZ,SUB515_6
SUB515_8:
        JR NC,DIV25
        DEC DE
        LD A,(DE)
        SBC A,0
        JR NC,$+3
        ADD A,B
        LD (DE),A
        JR SUB515_8
DIV25:  ; 3   25
        LD HL,(LEN_515)
        EX DE,HL
        LD HL,(END_515)
        ADD HL,DE
        RET NC
        LD BC,T25MOD
        LD DE,T25DIV
        EX DE,HL
DIV25_L:;50t
        LD A,(DE)
        LD L,A
        LD A,(BC)
        LD C,L
        ADD (HL)
        LD (DE),A
        INC E
        JP NZ,DIV25_L
        INC D
        LD A,(END_515+1)
        CP D
        JR NZ,DIV25_L
DD103:  ; 3   103^2
        LD HL,(LEN_515)
        EX DE,HL
        LD HL,(END_515)
        ADD HL,DE
        RET NC
        LD BC,0
        EX DE,HL
        LD HL,T103MOD
        JP DD103_L
DD103_1:
        LD C,A
        INC H
        LD A,(HL)
        DEC H
        INC A
        LD (DE),A
        INC E
        JR Z,DD103_2
DD103_L:
        LD L,B
        LD A,(DE)
        ADD (HL)
        JR C,$+4
        SUB -103
        LD B,A
        INC H
        LD A,(HL)
        DEC H
        LD L,C
        ADC (HL)
        JR C,DD103_1
        SUB -103
        LD C,A
        INC H
        LD A,(HL)
        DEC H
        LD (DE),A
        INC E
        JP NZ,DD103_L
DD103_2:
        INC D
        LD A,(END_515+1)
        CP D
        JR NZ,DD103_L
INC515: ;   3 
        LD DE,LOG515
        LD HL,(LOW_515)
        ADD HL,DE
        LD (LOW_515),HL
        LD HL,(LEN_515)
        JR NC,$+3
        INC HL
        INC HL
        INC HL
        LD (LEN_515),HL
        LD A,H
        OR A
        RET NZ
        LD (LEN_515),A
        RET

;     n  pi
;      100
;  ,      
;  ,   pi   
SUB10:
        LD HL,(LEN_10)
        INC HL
        LD B,H
        LD C,L
        LD DE,PI_SUM
        LD HL,(END_10)
        LD A,B
        OR A
        JP Z,SUB10_8
        PUSH BC
        LD C,-100
        JP SUB10_4
SUB10_1:
        LD (DE),A       ;18
        DEC E
        JR Z,SUB10_33
SUB10_2:;50/48=49
        DEC L
        LD A,(DE)       ;18
        SBC (HL)
        JR C,SUB10_1  ;7/12
        ADD A,C ;=100   ;25
        LD (DE),A
SUB10_3:
        DEC E
        JP NZ,SUB10_2
SUB10_33:
        DEC L
        LD A,(DE)       ;18
        SBC (HL)
        JR C,$+3  ;7/12
        ADD A,C ;=100   ;25
        LD (DE),A
SUB10_4:
        DEC D
        DEC H
        INC B
        JR NZ,SUB10_3
        POP BC
        LD B,-100
        JP SUB10_6
SUB10_5:
        LD (DE),A       ;22
        INC C
        JR Z,SUB10_8
SUB10_6:;54/52=53
        DEC E
        DEC L
        LD A,(DE)       ;18
        SBC (HL)
        JR C,SUB10_5  ;7/12
        ADD A,B ;=100   ;29
        LD (DE),A
SUB10_7:
        INC C
        JR NZ,SUB10_6
SUB10_8:
        DEC DE
        DEC HL
        LD A,(DE)
        SBC (HL)
        JR NC,$+4
        ADD 100
        LD (DE),A
SUB10_9:
        RET NC
        DEC DE
        LD A,(DE)
        SBC A,0
        JR NC,$+3
        ADD A,100
        LD (DE),A
        JR SUB10_9

;     n  pi
;  pi     
;    100,   
;       ,  pi, 
;        
ADD10:
        LD HL,(LEN_10)
        LD A,H
        OR L
        RET Z
        LD B,H
        LD C,L
        LD DE,PI_SUM
        LD HL,(END_10)
        PUSH BC
        LD C,-100
        JP ADD10_4
ADD10_1:
        LD (DE),A       ;18
        DEC E
        JR Z,ADD10_33
ADD10_2:;50/48=49
        DEC L
        LD A,(DE)       ;18
        ADC (HL)
        JR C,ADD10_1  ;7/12
        SUB A,C ;=100   ;25
        LD (DE),A
ADD10_3:
        DEC E
        JP NZ,ADD10_2
ADD10_33:
        DEC L
        LD A,(DE)       ;18
        ADC (HL)
        JR C,$+3  ;7/12
        SUB A,C ;=100   ;25
        LD (DE),A
ADD10_4:
        DEC D
        DEC H
        INC B
        JR NZ,ADD10_3
        POP BC
        LD B,-100
        JP ADD10_6
ADD10_5:
        LD (DE),A       ;22
        INC C
        JR Z,ADD10_8
ADD10_6:;54/52=53
        DEC E
        DEC L
        LD A,(DE)       ;18
        ADC (HL)
        JR C,ADD10_5  ;7/12
        SUB A,B ;=100   ;29
        LD (DE),A
ADD10_7:
        INC C
        JR NZ,ADD10_6
ADD10_8:
        RET NC
        DEC DE
        LD A,(DE)
        ADC A,-100
        JR C,$+3
        SUB A,-100
        LD (DE),A
        JR ADD10_8

DIV10:
        JP INITDIV
DIVALG=$-2

;  
INITDIV:
        SUB A
        LD (T100MOD),A
        LD (T100DIV),A
        LD HL,$2101   	;100/3 100%3
        LD (REST_100),HL;   n
        LD HL,3         ; 
        LD (DIV_P),HL
        LD HL,-3        
        LD (DIV_N),HL
        LD HL,DIV7      ;    100
        LD (DIVALG),HL
        LD HL,F7DIV_Z1-1;   
        LD (F7DIV_J2+1),HL; 
        RET

; T100DIV&MOD     N  101  255
F8D100:
        LD A,(DIV_P)
        LD (F8D100_A1+1),A
        NEG
        LD D,T100MOD>>8
        LD E,A
        LD H,D
        INC H
        LD L,A
        LD BC,$0164
F8D100_L:;54/48t
        LD (DE),A
        LD (HL),B
        ADD C
        JR NC,$+5
F8D100_A1:SUB 0
        INC B
        INC E
        INC L
        JP NZ,F8D100_L
        RET

;  N  101  255  
DIV8T:
        LD HL,(LEN_10)
        EX DE,HL
        LD HL,(END_10)
        ADD HL,DE
        LD A,(DIV_N)
        LD (DIV8T_A1+1),A
        LD B,T100MOD>>8
        LD C,A
        LD D,B
        INC D
        LD E,A
        JP DIV8T_L
DIV8T_1:
        LD C,A
        LD A,(DE)
        DEC A
        LD E,C
        LD (HL),A
        INC L
        JR Z,DIV8T_2
DIV8T_L:;64/53t
        LD A,(BC)
        ADD (HL)
        JR NC,DIV8T_1
DIV8T_A1: ADD A,0
        LD C,A
        LD A,(DE)
        LD E,C
        LD (HL),A
        INC L
        JR NZ,DIV8T_L
DIV8T_2:
        INC H
        LD A,(END_10+1)
        CP H
        JR NZ,DIV8T_L
        RET

;  N  101  255
DIV8:
        CALL F8D100
        CALL DIV8T
        LD A,(DIV_N)
        SUB 2
        JR NC,DIV8_N
        LD HL,DIVFULL   ;    
        LD (DIVALG),HL
        LD HL,$0239     ;257/100 & 257%100
        LD (REST_100),HL
        LD HL,257
        LD (DIV_P),HL
        LD HL,-257
        LD (DIV_N),HL
        RET
DIV8_N:
        LD (DIV_N),A
        NEG
        LD (DIV_P),A
        RET
        
; T100DIV&MOD     N<100
F7D100:
        LD A,(DIV_P)
        LD (F7D100_A1+1),A
        LD B,T100MOD>>8
        LD C,A
        LD D,B
        INC D
        LD E,A
        LD HL,(REST_100)
        LD A,100
        LD (DE),A
        SUB A
F7D100_L:;63t
        SUB L
        JR NC,$+4
F7D100_A1: ADD 0
        DEC C
        LD (BC),A
        LD A,(DE)
        SBC H
        DEC E
        LD (DE),A
        LD A,(BC)
        JP NZ,F7D100_L
        RET

;     100 
F7C100:
        LD DE,T100MOD
        LD HL,(DIV_P)
        LD H,D
        LD C,49
        LD A,(DE)
        LD (HL),A
        INC D
        INC H
        LD A,(DE)
        LD (HL),A
F7C100_L:
        INC E
        INC L
        LD A,(DE)
        LD (HL),A
        DEC D
        DEC H
        LD A,(DE)
        LD (HL),A
        INC E
        INC L
        LD A,(DE)
        LD (HL),A
        INC D
        INC H
        LD A,(DE)
        LD (HL),A
        DEC C
        JP NZ,F7C100_L
        RET
        
; T1DIV     N<100
F7DIV:
        LD HL,0
        ADD HL,SP
        LD (F7DIV_SP+1),HL

        LD HL,(F7DIV_J2+1)
        DEC HL
        LD (F7DIV_J2+1),HL

        LD A,(REST_100+1)
        INC A
        LD D,A
        LD E,A

        LD A,(DIV_P)
        ADD 100
        LD L,A
        LD H,T1DIV>>8

        LD A,(REST_100)
        NEG
        SRA A
        JR C,$+4
        INC HL
        DEC A
        ADD F7DIV_Z1
        LD (F7DIV_J1+1),A
        LD A,F7DIV_Z1>>8
        ADC -1
        LD (F7DIV_J1+2),A

        LD SP,HL
        LD A,-1
F7DIV_J1: JP F7DIV_Z1
FOR FVAR=1 TO 50
        PUSH DE
ENDFOR
F7DIV_Z1:DEC D
        DEC E
        INC SP
        CP D
F7DIV_J2: JP NZ,F7DIV_Z1
        
F7DIV_SP: LD SP,0
        RET

;  N<100  
DIV7T:
        LD HL,(LEN_10)
        EX DE,HL
        LD HL,(END_10)
        ADD HL,DE
        EX DE,HL
        LD HL,T100MOD
        LD BC,T1DIV
DIV7T_L:;65t
        LD A,(DE)
        ADD (HL)
        LD C,A
        LD A,(BC)
        INC H
        ADD (HL)
        DEC H
        LD L,C
        LD (DE),A
        INC E
        JP NZ,DIV7T_L
        INC D
        LD A,(END_10+1)
        CP D
        JP NZ,DIV7T_L
        RET

;  N<100
DIV7:
        CALL F7DIV
        CALL F7D100
        CALL F7C100
        CALL DIV7T
        
        LD A,(DIV_N)
        SUB 2
        LD (DIV_N),A
        NEG
        LD (DIV_P),A
        CP A,100
        JR C,REST
        LD HL,DIV8
        LD (DIVALG),HL
        RET
; REST_100=100%N,100/N
REST:
        LD D,A
        LD HL,(REST_100)
        LD A,L
        RLC H
        SUB H
        JR NC,REST_2
REST_1:
        DEC H
        DEC H
        ADD D
        JR NC,REST_1
REST_2:
        RRC H
        LD L,A
        LD (REST_100),HL
        RET
        
;   N<2^14
DIV15:
        LD HL,(DIV_N)
        LD (DIV15_N+1),HL
        LD DE,-2
        ADD HL,DE
        LD (DIV_N),HL
        
        LD HL,(DIV_P)
        LD (DIV15_P+1),HL
        LD DE,2
        ADD HL,DE
        LD (DIV_P),HL

        LD HL,(LEN_10)
        EX DE,HL
        LD HL,(END_10)
        ADD HL,DE
        LD B,H
        LD C,L
        LD HL,0
        JP DIV15_T
DIV15_A:ADC A
        ADD HL,HL
        ADD BC
        JR C,DIV15_2
DIV15_B:ADC A
        ADD HL,HL
        ADD BC
        JR C,DIV15_3
DIV15_C:ADC A
        ADD HL,HL
        ADD BC
        JR C,DIV15_4
DIV15_D:ADC A
        ADD HL,HL
        ADD BC
        JR C,DIV15_5
DIV15_E:ADC A
        ADD HL,HL
        ADD BC
        JR C,DIV15_6
DIV15_F:ADC A
        ADD HL,HL
        ADD BC
        JR C,DIV15_7
DIV15_G:ADC A
        JP DIV15_8
DIV15_L:
        LD A,L
        ADD A
        LD (DIV15L+1),A
        LD A,H
        ADC A
        ADD A
        LD (DIV15H+1),A
        LD A,(BC)
        PUSH BC
DIV15L: LD HL,(T100MUL)
        ADD L
        ADD A
        LD (DIV15_8+1),A
        LD A,H
DIV15H: LD HL,(T100MUL)
        ADC L
        ADD A
        LD L,A
        JR NC,$+3
        INC H
DIV15_N:  LD DE,-1
DIV15_P:  LD BC,1
;34x7t
        ADD DE
        JR NC,DIV15_A
DIV15_1:ADC A
        ADD HL,HL
        ADD DE
        JR NC,DIV15_B
DIV15_2:ADC A
        ADD HL,HL
        ADD DE
        JR NC,DIV15_C
DIV15_3:ADC A
        ADD HL,HL
        ADD DE
        JR NC,DIV15_D
DIV15_4:ADC A
        ADD HL,HL
        ADD DE
        JR NC,DIV15_E
DIV15_5:ADC A
        ADD HL,HL
        ADD DE
        JR NC,DIV15_F
DIV15_6:ADC A
        ADD HL,HL
        ADD DE
        JR NC,DIV15_G
DIV15_7:ADC A
        ADD DE
DIV15_8:LD DE,0
        SRL E
        ADD DE
        JR C,$+4
        ADD BC
        CCF
        ADC 0
        POP BC
        LD (BC),A
        INC C
        JP NZ,DIV15_L
DIV15_X:
        INC B
DIV15_T:
        LD A,(END_10+1)
        CP B
        JP NZ,DIV15_L
        RET

; 
CLEAR:
        LD HL,0
        ADD SP
        LD (CLEAR_SP+1),HL
        LD SP,$5B00
        LD BC,$4141
        LD DE,$4142
        LD HL,$4242
        PUSH BC
        PUSH DE
        PUSH HL
        PUSH BC
        PUSH DE
        PUSH HL
        PUSH BC
        PUSH DE
        PUSH HL
        LD A,-15
        JR CLEAR_3
CLEAR_1:
        LD BC,$4343
        LD DE,$4344
        LD HL,$4444
        ADD $50
CLEAR_2:
        PUSH BC
        PUSH BC
        PUSH DE
        PUSH HL
        PUSH HL
        SUB $10
        JR NC,CLEAR_2
CLEAR_3:
        LD BC,$4545
        LD DE,$4546
        LD HL,$4646
        ADD $50
CLEAR_4:
        PUSH BC
        PUSH BC
        PUSH DE
        PUSH HL
        PUSH HL
        SUB $10
        JR NC,CLEAR_4
        ADD 2
        JR NC,CLEAR_1
CLEAR_SP:LD SP,0
        LD BC,0
        LD DE,-PI_MEM
        LD HL,PI_SUM
        CALL SETVAR
        LD BC,0
        LD DE,PI_TMP+1
        LD HL,-1
        CALL SETVAR
        RET
        DEFS 32
STACK:
        DEFS (-$)%256

T239MOD:
FOR FVAR=0 TO 255
        DEFB FVAR*100%239-239
ENDFOR
T239DIV:
FOR FVAR=0 TO 255
        DEFB FVAR*100/239
ENDFOR
T103MOD:
FOR FVAR=0 TO 255
        DEFB FVAR*100%103-103
ENDFOR
T103DIV:
FOR FVAR=0 TO 255
        DEFB FVAR*100/103
ENDFOR
T25MOD:
FOR FVAR=0 TO 255
        DEFB FVAR %25*4
ENDFOR
T25DIV:
FOR FVAR=0 TO 255
        DEFB FVAR/25
ENDFOR
T100MUL:
FOR FVAR=0 TO 127
        DEFB FVAR*100%128, FVAR*100/128
ENDFOR
T100MOD: DEFS 256
T100DIV: DEFS 256
T1DIV: DEFS 256


