// scn82bmp.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <windows.h> 
#include <stdio.h> 

typedef struct tsSCNFILEHEADER
{
	WORD wType;
	WORD wReserved1;
	WORD wReserved2;
	WORD wOffBits;
} SCNFILEHEADER;

typedef struct tsSCNINFOHEADER
{
	WORD wWidth;
	WORD wHeight;
	WORD wBitCount; //8 - RGB332, 15 - RGB555, 16 - RGB565
	WORD wReserved;
} SCNINFOHEADER;

typedef struct tsRGBDOUBLE
{
	BYTE rgbINK;
	BYTE rgbPAPER;
} RGBDOUBLE;

struct uRastr
{
	BYTE bA : 4;
	BYTE bB : 4;
} stRastr;

int main(int argc, char *argv[])
{
	BITMAPFILEHEADER bfh;
	BITMAPINFOHEADER bih;
	SCNFILEHEADER sfh;
	SCNINFOHEADER sih;
	FILE *bmpfile;
	FILE *scnfile;
	int ibfile;
	int isfile;
	int Width, Height;
	int iBlockWidth, iBlockHeight;
	RGBTRIPLE *outBuf;
	DWORD OffBits;
	int i, j;
	BYTE *RastrBuf;
	RGBDOUBLE *AttrBuf;
	BYTE *NewRastrBuf;
	RGBDOUBLE *NewAttrBuf;
	int iX, iY, iA, iP, iS, iL;

	if (argc < 3)
		printf("Usage: scn2bmp <>.scn <>.bmp \n\a");

	isfile = fopen_s(&scnfile, argv[1], "rb");
	if (isfile)
	{
		printf("scnfile was not opened\n");
		return 1;
	}

	ibfile = fopen_s(&bmpfile, argv[2], "wb");
	if (ibfile)
	{
		printf("bmpfile was not opened\n");
		fclose(scnfile);
		return 1;
	}

	//    scn 
	fread_s(&sfh, sizeof(SCNFILEHEADER), sizeof(BYTE), sizeof(SCNFILEHEADER), scnfile);
	fread_s(&sih, sizeof(SCNINFOHEADER), sizeof(BYTE), sizeof(SCNINFOHEADER), scnfile);

	Width = sih.wWidth;
	Height = sih.wHeight;
	OffBits = 0;

	iBlockHeight = Height >> 2;
	iBlockWidth = Width >> 2;

	//  
	RastrBuf = new BYTE[Height * (Width >> 3)];
	AttrBuf = new RGBDOUBLE[iBlockHeight * iBlockWidth];
	outBuf = new RGBTRIPLE[Width];

	//  
	fread_s(RastrBuf, Height * (Width >> 3), sizeof(BYTE), Height * (Width >> 3), scnfile);
	fread_s(AttrBuf, sizeof(RGBDOUBLE) * iBlockHeight * iBlockWidth, sizeof(BYTE), sizeof(RGBDOUBLE) * iBlockHeight * iBlockWidth, scnfile);

	NewAttrBuf = new RGBDOUBLE[(Height >> 2) * (Width >> 2)];
	NewRastrBuf = new BYTE[Height * (Width >> 3)];

	//    
	for (iY = 0; iY < Height; iY++)
	{
		for (iX = 0; iX < (Width >> 3); iX++)
		{
			NewRastrBuf[((Height - 1) - iY) * (Width >> 3) + iX] = RastrBuf[iY * (Width >> 3) + iX];
		}
	}

	//    8
	if ((Height == 192) && (Width == 256))
	{
		for (iP = 0; iP < 3; iP++)
		{
			for (iL = 0; iL < 8; iL++)
			{
				for (iS = 0; iS < 8; iS++)
				{
					for (iX = 0; iX < 32; iX++)
					{
						RastrBuf[(iP * 2048) + (iL * 32) + (iS * 256) + iX] = NewRastrBuf[(iP * 2048) + (iL * 256) + (iS * 32) + iX];
					}
				}
			}
		}
	}
	else
	{
		for (iA = 0; iA < (Height * (Width >> 3)); iA++)
		{
			RastrBuf[iA] = NewRastrBuf[iA];
		}
	}
	delete NewRastrBuf;

	//    
	for (iY = 0; iY < iBlockHeight; iY++)
	{
		for (iX = 0; iX < iBlockWidth; iX++)
		{
			NewAttrBuf[((iBlockHeight - 1) - iY) * iBlockWidth + iX].rgbINK = AttrBuf[iY * iBlockWidth + iX].rgbINK;
			NewAttrBuf[((iBlockHeight - 1) - iY) * iBlockWidth + iX].rgbPAPER = AttrBuf[iY * iBlockWidth + iX].rgbPAPER;
		}
	}
	delete AttrBuf;

	//  
	memset(&bfh, 0, sizeof(bfh));				//  
	bfh.bfType = 0x4D42;						// ,   bmp 'BM'
	bfh.bfOffBits = sizeof(bfh) + sizeof(bih);	//    
	bfh.bfSize = bfh.bfOffBits + 4 * Width * Height + Height * (Width % 4);		//  

	memset(&bih, 0, sizeof(bih));				//  
	bih.biSize = sizeof(bih);					//  
	bih.biBitCount = 24;						// 24   
	bih.biCompression = BI_RGB;					//  
	bih.biHeight = Height;
	bih.biWidth = Width;
	bih.biPlanes = 1;							//   1
												//    

	//  
	fwrite(&bfh, sizeof(BYTE), sizeof(BITMAPFILEHEADER), bmpfile);
	fwrite(&bih, sizeof(BYTE), sizeof(BITMAPINFOHEADER), bmpfile);

	//  
	for (i = 0; i < Height; i++) //   
	{
		for (j = 0; j < Width; j++) //   
		{
			if ((RastrBuf[(i * (Width >> 3)) + (j >> 3)] & (0x80 >> (j & 0x7))) == 0) //    = 0,  PAPER,  INK
				{
				outBuf[j].rgbtRed = (NewAttrBuf[((i >> 2) * iBlockWidth) + (j >> 2)].rgbPAPER & 0xE0);
				outBuf[j].rgbtRed |= (outBuf[j].rgbtRed >> 3) & 0x1C;
				outBuf[j].rgbtGreen = (NewAttrBuf[((i >> 2) * iBlockWidth) + (j >> 2)].rgbPAPER & 0x1C) << 3;
				outBuf[j].rgbtGreen |= (outBuf[j].rgbtGreen >> 3) & 0x1C;
				outBuf[j].rgbtBlue = (NewAttrBuf[((i >> 2) * iBlockWidth) + (j >> 2)].rgbPAPER & 0x03) << 6;
				outBuf[j].rgbtBlue |= (outBuf[j].rgbtBlue >> 2) & 0x30;
				outBuf[j].rgbtBlue |= ((outBuf[j].rgbtBlue & 0x30) >> 2) & 0x0C;
			}
			else
			{
				outBuf[j].rgbtRed = (NewAttrBuf[((i >> 2) * iBlockWidth) + (j >> 2)].rgbINK & 0xE0);
				outBuf[j].rgbtRed |= (outBuf[j].rgbtRed >> 3) & 0x1C;
				outBuf[j].rgbtGreen = (NewAttrBuf[((i >> 2) * iBlockWidth) + (j >> 2)].rgbINK & 0x1C) << 3;
				outBuf[j].rgbtGreen |= (outBuf[j].rgbtGreen >> 3) & 0x1C;
				outBuf[j].rgbtBlue = (NewAttrBuf[((i >> 2) * iBlockWidth) + (j >> 2)].rgbINK & 0x03) << 6;
				outBuf[j].rgbtBlue |= (outBuf[j].rgbtBlue >> 2) & 0x30;
				outBuf[j].rgbtBlue |= ((outBuf[j].rgbtBlue & 0x30) >> 2) & 0x0C;
			}
		}
		//  
		fwrite(outBuf, sizeof(char), sizeof(RGBTRIPLE) * Width, bmpfile);
	}

	//  
	delete RastrBuf;
	delete NewAttrBuf;
	delete outBuf;

	//  
	fclose(bmpfile);
	fclose(scnfile);

	return 0;
}

