	device zxspectrum128
        ORG #6000
begin
tab2x2 equ $B000 ;    22,  512 
tab4x4 equ tab2x2+512 ;    44,  1024 
t4x4:
 db 0,0,0,0;  ,     256
	call show_sprite;   

	call gen2x2;  LUT   22
	call gen4x4;  LUT   4x4


	call show2x2;   22

wait_space:
	ld a,$7F
	in a,($FE)
	rra
	jr c,wait_space
	
	call show4x4;   4x4
	jr $

;  22
show2x2:
	ld hl,frog
	ld de,$4000+6*32
	ld b,tab2x2/256
	
	ld ixl,48
ylp:
	push de
	ld a,6;   48 , 48/8=6
xlp:
	exa
	ld c,(hl)
	inc hl

	ld a,(bc)
	ld (de),a
	inc d
	ld (de),a

	inc e
	inc b

	ld a,(bc)
	ld (de),a
	dec d
	ld (de),a
	dec b

	inc e

	exa
	dec a
	jr nz,xlp
	pop de
	call down_de
	call down_de
	dec ixl
	jr nz,ylp

	ret

;   4x4
show4x4:
	ld hl,frog
	ld de,$4000
	ld ixl,48
lpy2:
	push de
	ld a,6
lpx2:
	exa
	ld b,tab4x4/256+3
	ld c,(hl)
	inc hl

	ld a,(bc)

	ld (de),a
	inc d
	ld (de),a
	inc d
	ld (de),a
	inc d
	ld (de),a

	inc e

	dec b
	ld a,(bc)

	ld (de),a
	dec d
	ld (de),a
	dec d
	ld (de),a
	dec d
	ld (de),a

	inc e

	dec b
	ld a,(bc)

	ld (de),a
	inc d
	ld (de),a
	inc d
	ld (de),a
	inc d
	ld (de),a

	inc e

	dec b
	ld a,(bc)

	ld (de),a
	dec d
	ld (de),a
	dec d
	ld (de),a
	dec d
	ld (de),a

	inc e

	exa
	dec a
	jp nz,lpx2
	pop de
	call down_de
	call down_de
	call down_de
	call down_de
	dec ixl
	jp nz,lpy2
	ret

;  LUT   4x4
gen4x4:
;    
	ld hl, data4x4
	ld de, t4x4
	ld bc,4
	ldir

;   "!"   ...
	ld hl, tab4x4
gen4lp:

	ld a,l
	ld d, t4x4/256
	ld b,4
	push hl

mkg:
	push af
	and 3
	ld e,a
	ld a,(de)
	ld (hl),a
	inc h
	pop af
	srl a
	srl a
	djnz mkg

	pop hl
	inc l
	jr nz,gen4lp

	ret
data4x4:
;0:00
;1:01
;2:10
;3:11
	db $00,$0F,$F0,$FF




;  LUT   22
;    0-255  76543210    7766554433221100,  77665544  tab2x2, 33221100  tab2x2+256
gen2x2:
	ld hl,tab2x2
glp:
	ld a,l
	ex de,hl
	ld hl,0

	ld b,8
glp1:
	add a,a
	push af
	sbc a,a
	and 3
	add hl,hl
	add hl,hl
	or l
	ld l,a
	pop af
	djnz glp1
	
	ex de,hl
	ld (hl),d
	inc h
	ld (hl),e
	dec h
	inc l
	jr nz,glp
	ret

;   
show_sprite:
	ld hl,frog
	ld de,$4000
	ld ixl,48; 
sy:
	push de
	ld bc,6
	ldir
	pop de
	call down_de
	dec ixl
	jr nz,sy
	ret

down_de ;   , DE= 
	INC D
	LD A,D
	AND 7
	RET NZ
	LD A,E
	ADD A,#20
	LD E,A
	RET C
	LD A,D
	SUB 8
	LD D,A
	RET

frog:incbin "frog_spr.bin"

end
	display /d,end-begin
	savesna "!void.sna",begin

