module ZX_clock_gen(
	CLK,
	OSC,
	OSCN,
	DC0,
	DC1,
	DC1N,
	DC2,
	DC2N,
	H,
	V,
	HSYN,
	VSYN,
	BORD,
	BLANCN
);

input CLK;
output OSC;
output OSCN;
output DC0;
output DC1;
output DC1N;
output DC2;
output DC2N;
output [4:0] H;
output [7:0] V;
output HSYN;
output VSYN;
output BORD;
output BLANCN;

reg	[8:0]	cntH;
reg	[8:0]	cntV;
reg HBR, HBL, VBR, VBL, OSC;
reg HSYN, VSYN, BORD;
reg BLANCN;

always @(posedge CLK)
	OSC <= ~OSC;

always @(posedge OSC)
begin
	cntH <= cntH + 1;
	case(cntH)
		256:HBR <= 1;
		320:HSYN <= 1;
		352:begin
				HSYN <= 0;
				HBL <= 1;
			end
		384:HBL <= 0;
		448:begin
				cntV <= cntV + 1;
				cntH <= 0;
				HBR <= 0;
				case(cntV)
					192:VBR <= 1;
					240:VSYN <= 1;
					256:begin
							VSYN <= 0;
							VBL <= 1;
						end
					264:VBL <= 0;
					320:begin
							cntV <= 0;
							VBR <= 0;
						end
				endcase
			end
	endcase
	BLANCN <= ~(VBL + HBL);
end

always @(negedge DC2)
	BORD <= (VBR | HBR);

assign OSCN = ~OSC;
assign DC0 = cntH[0];
assign DC1 = cntH[1];
assign DC1N = ~cntH[1];
assign DC2 = cntH[2];
assign DC2N = ~cntH[2];
assign H = cntH[6:3];
assign V = cntV[7:0];

endmodule
