module Syncro_VGA
(
	input	wire		picselclock,		// 
	output	wire		Den,				//Data Enable
	output	reg			h_sinc = 1,			// Horizontal syncronization
	output	reg			v_sinc = 1			// Vertical syncronization
);
//*********************************************
parameter ScreenX = 640;//1024;	//      X
parameter ScreenY = 480;//768;	//      Y
parameter FrontPorchX = 24;//16;//24;	//      
parameter FrontPorchY = 9;//11;//3;	//      
parameter PulseX = 40;//96;//136;		//   
parameter PulseY = 3;//2;//6;		//   
parameter BlankX = 128;//48;//160;		//        X
parameter BlankY = 31;//31;//29;		//        Y
// 832  523  (640 24 40 128   480 9 3 28/31)
//  894  622
//*********************************************
/*---------------------------------------------
  
---------------------------------------------*/
reg	[10:0]	hcnt = 0;		reg [10:0]	vcnt = 0;
reg			h_blank = 0;	reg			v_blank = 0;
assign	Den = ~(h_blank | v_blank);
//=============================================
always @(posedge picselclock) begin
	hcnt <= hcnt + 1;			//     
	if (hcnt == ScreenX) begin		//     
		h_blank <= 1;			//   
	end else if (hcnt == ScreenX+FrontPorchX) begin			// Start H-syncro
		h_sinc <= 0;
	end else if (hcnt == ScreenX+FrontPorchX+PulseX) begin		// End H-syncro
		h_sinc <= 1;
	end else if (hcnt == ScreenX+FrontPorchX+PulseX+BlankX) begin
		vcnt <= vcnt + 1;		//   
		h_blank <= 0;			//   
		hcnt <= 0;
		if	(vcnt == ScreenY) begin	//     
			v_blank <= 1;		//   
		end else if	(vcnt == ScreenY+FrontPorchY) begin			// Start V-syncro
			v_sinc <= 0;
		end else if	(vcnt == ScreenY+FrontPorchY+PulseY) begin		// End V-syncro
			v_sinc <= 1;
		end else if	(vcnt == ScreenY+FrontPorchY+PulseY+BlankY) begin
			v_blank <= 0;	//   
			vcnt <= 0;
		end
	end	//if
end		//always
//=============================================
endmodule
//*********************************************
