module ZX_clock_gen(
	input wire CLK, // 14 MHz clock input
	output reg OSC = 0,
	output wire OSCN,
	output wire DC0,
	output wire DC1,
	output wire DC1N,
	output wire DC2,
	output wire DC2N,
	output wire [4:0] H,
	output wire [7:0] V,
	output reg HSYN = 0,
	output reg VSYN = 0,
	output reg BORD = 0,
	output wire BLANCN
);
parameter HBorderStart = 256; // X resolution
parameter HBlancSynStart = 320;
parameter HSynEnd = 352;
parameter HBlancEnd = 384;
parameter HLineEnd = 448;

parameter VBorderStart = 192; // Y Resolution
parameter VBlancSynStart = 240;
parameter VSynEnd = 256;
parameter VBlancEnd = 264;
parameter VLineEnd = 320;

reg	[8:0]	cntH = 0;
reg	[8:0]	cntV = 0;
reg HBL = 0, VBL = 0, HBR = 0, VBR = 0;

always @(posedge CLK)
	OSC <= ~OSC;

always @(posedge OSC)
begin
	cntH <= cntH + 1;
	case(cntH)
		HBorderStart: HBR <= 1;
		HBlancSynStart: begin
				HBL <= 1;
				HSYN <= 1;
			end
		HSynEnd: HSYN <= 0;
		HBlancEnd: HBL <= 0;
		HLineEnd: begin
				cntH <= 0;
				HBR <= 0;
				cntV <= cntV + 1;
				case(cntV)
					VBorderStart: VBR <= 1;
					VBlancSynStart: begin
							VSYN <= 1;
							VBL <= 1;
						end
					VSynEnd: VSYN <= 0;
					VBlancEnd: VBL <= 0;
					VLineEnd: begin
							cntV <= 0;
							VBR <= 0;
						end
				endcase
			end
	endcase
end

always @(negedge DC2)
	BORD <= (VBR | HBR);

assign OSCN = ~OSC;
assign DC0 = cntH[0];
assign DC1 = cntH[1];
assign DC1N = ~cntH[1];
assign DC2 = cntH[2];
assign DC2N = ~cntH[2];
assign H = cntH[6:3];
assign V = cntV[7:0];
assign BLANCN = ~(VBL | HBL);

endmodule
