module ZX_clock_gen(
	input wire CLK, // 14 MHz clock input
	output reg PIXCLK = 0,
	output wire PIXCLKn,
	output wire DC0,
	output wire DC1,
	output wire DC1n,
	output wire DC2,
	output wire DC2n,
	output wire [4:0] H,
	output wire [7:0] V,
	output reg HSYN = 0,
	output reg VSYN = 0,
	output reg BORD = 0,
	output wire BLANCn,
	output reg INTn = 1
);
parameter HBorderStart = 256; // X resolution
parameter HBlancSynStart = 320;
parameter HSynEnd = 352;
parameter HBlancEnd = 384;
parameter HLineEnd = 448;
parameter HIntRes = 64;

parameter VBorderStart = 192; // Y Resolution
parameter VBlancSynStart = 240;
parameter VSynEnd = 256;
parameter VBlancEnd = 272;
parameter VLineEnd = 320;

reg HBL = 0, VBL = 0;
reg HBR = 0, VBR = 0;
reg	[8:0]	cntH = 0;
reg	[8:0]	cntV = 0;

always @(posedge CLK)
	PIXCLK <= ~PIXCLK;

always @(posedge PIXCLK)
begin
	cntH <= cntH + 1;
	if(cntH==HBorderStart) HBR <= 1;
	else if(cntH==HBlancSynStart) begin
				HBL <= 1;
				HSYN <= 1;
			end
	else if(cntH==HSynEnd) HSYN <= 0;
	else if(cntH==HBlancEnd) HBL <= 0;
	else if(cntH==HLineEnd) begin
				cntH <= 0;
				HBR <= 0;
				cntV <= cntV + 1;
				if(cntV==VBorderStart) begin
						VBR <= 1;
						//INTn <= 0;
					end
				else if	(cntV==VBlancSynStart) begin
						VSYN <= 1;
						VBL <= 1;
						INTn <= 0; //
					end
				else if(cntV==VSynEnd) VSYN <= 0;
				else if(cntV==VBlancEnd) VBL <= 0;
				else if(cntV==VLineEnd) begin
						cntV <= 0;
						VBR <= 0;
					end
			end
	if(cntH == HIntRes) INTn <= 1;
end

always @(negedge DC2)
	BORD <= (VBR | HBR);

assign PIXCLKn = ~PIXCLK;
assign DC0 = cntH[0];
assign DC1 = cntH[1];
assign DC1n = ~cntH[1];
assign DC2 = cntH[2];
assign DC2n = ~cntH[2];
assign H = cntH[6:3];
assign V = cntV[7:0];
assign BLANCn = ~(VBL | HBL);

endmodule
