`ifndef defs_V
`define defs_V

//	
`define		Base_State			2'b00	//  
`define		Wait_Transmit		2'b01	//     

`define		Do_Transmit			2'b10 	//  
`define		Do_Nothing			2'b11	// 


//	  
`define		SOPbyte							8'h80	// 0b10000000 (80)
//	TOKEN - 
`define		OUTPID_PID						4'b0001	// 0b11100001 (E1)_
`define		IN_PID							4'b1001	// 0b01101001 (69)_
`define		SETUP_PID						4'b1101	// 0b00101101 (2D)_
`define		SOF_PID							4'b0101	// 0b10100101 (A5)	 
//	DATA - 
`define		DATA0_PID						4'b0011	// 0b11000011 (C3)_
`define		DATA1_PID						4'b1011	// 0b01001011 (4B)_
//	HANDSAKE - 
`define		ACK_PID							4'h2	// 0b11010010 (D2)
`define		NAK_PID							4'hA	// 0b01011010 (5A)
`define		STALL_PID						4'hE	// 0b00011110 (1E)
`define		PRE_PID							4'hC	// 0b00111100 (3C)	

//	 
`define		GET_STATUS				4'h0		// Two zero answer
`define		CLEAR_FEATURE			4'h1		// ComposeZeroDATA1PIDAnswer
`define		SET_FEATURE				4'h3		// ComposeZeroDATA1PIDAnswer
`define		SET_ADDRESS				4'h5		// my_USB_address = data
`define		GET_DESCRIPTOR			4'h6		// 
`define		SET_DESCRIPTOR			4'h7
`define		GET_CONFIGURATION		4'h8
`define		SET_CONFIGURATION		4'h9
`define		GET_INTERFACE			4'hA
`define		SET_INTERFACE			4'hB
`define		SYNCH_FRAME				4'hC

//	 
`define		DEVICE					4'h1
`define		CONFIGURATION			4'h2
`define		STRING					4'h3
`define		INTERFACE				4'h4
`define		ENDPOINT				4'h5

`define		USER_FNC_NUMBER			8d100

//	 
`define		Device_Descriptor_Addr		8'h38
`define		Config_Descriptor_Addr		8'h58
`define		Interface_Descriptor_Addr	8'h61
`define		Endpoint_Descriptor_Addr	8'h6A

`define		Device_Descriptor_Len		8'h12	// 18
`define		Config_Descriptor_Len		8'h19	// 25
`define		C_Short_Descriptor_Len		8'h09	// 9
`define		Interface_Descriptor_Len	8'h09	// 9
`define		Endpoint_Descriptor_Len		8'h07	// 7

// String Descriptors
`define		LSD_Descriptor_Addr			8'h78	// Language String Descriptor
`define		VSD_Descriptor_Addr			8'h80	// Vendor String Descriptor
`define		DSD_Descriptor_Addr			8'hA0	// Device String Descriptor

`define		LSD_Descriptor_Len			8'h04	// 4
`define		VSD_Descriptor_Len			8'h12	// 18
`define		DSD_Descriptor_Len			8'h4C	// 76



`endif // `ifndef DEFINE_V
