//
//  (c) CATS 1998
//   䠩 MS-DOS  ࠧ ᪥ CP/M   -128
//  Borland C 3.1
//  ( ࠬ ஥ "ᯮ C...")
//  v 1.02
//
#include <stdio.h>
#include <dir.h>
#include <fcntl.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <io.h>
#include <bios.h>
#include <dos.h>
#include <sys\stat.h>
#include "util.h"


#define sys_len 0x5000
#define sect_len 0x400
#define MAX_EXT 1024
#define BASE 0x5000
#define EXTSIZEINBYTES 0x800

#define E_SEEK      0xf1 // seek error
#define E_READ      0xf2 // read error
#define E_WRITE     0xf3 // write error
#define E_NOENTRY   0xf4 // no free directory entry
#define E_OPENFILE  0xf5 // open source file error
#define E_OPENIMAGE 0xf6 // open image file error


  int extent[MAX_EXT];
  int dos_file;
  int odi_file;

void errors(int errno, char *msg)
{
  switch(errno)
  {
    case E_SEEK:      printf("Seek error !\n"); exit(E_SEEK);
    case E_READ:      printf("%s reading error !\n",msg) ; exit(E_READ);
    case E_WRITE:     printf("%s writting error !\n",msg); exit(E_WRITE);
    case E_NOENTRY:   printf("No empty directory entry !\n");exit(E_NOENTRY);
    case E_OPENFILE:  printf("%s file open error !\n",msg);exit(E_OPENFILE);
    case E_OPENIMAGE: printf("%s image open error !\n",msg);exit(E_OPENIMAGE);
    default:          printf("Unknown error !!!\n");exit(-1);
  }
}

long ext_off(int extent)
{
 return (long)BASE+(long)extent*(long)EXTSIZEINBYTES;
}

int read_extent(int extent_no, cluster *buf)
{
  if(lseek(odi_file,ext_off(extent_no),SEEK_SET)==-1L) errors (E_SEEK,NULL);
  if(read(odi_file,buf,EXTSIZEINBYTES)==-1) errors (E_READ,"Image");
  return 0;
}

int write_extent(int extent_no, cluster *buf)
{
  if(lseek(odi_file,ext_off(extent_no),SEEK_SET)==-1L) errors (E_SEEK,NULL);
  if(write(odi_file,buf,EXTSIZEINBYTES)==-1) errors (E_WRITE,"Image");
  extent[extent_no]=-1;
  return 0;
}

void init_dir(void)
{
 int i,j;

 for (i=0;i<MAX_EXT;i++) extent[i]=0;

 for(i=0;i<=1;i++) read_extent(i,(cluster*)&d_dir.buf[i]);

 /*  ⠡ ⥭⮢ */
 for(i=0;i<DIR_ENTRY;i++)
 {
  if(d_dir.dir[i].user!=0xe5)
   {
    for(j=0;j<8;j++) extent[d_dir.dir[i].extent[j]]=-1;
   }
 }
}

int get_next_extent(int extent_no)
{
 while(extent[extent_no]!=0) extent_no++;
 return(extent_no);
}

char get_next_entry(char entry)
{
  int j;
   for(j=entry;j<DIR_ENTRY;j++)
    {
     if(d_dir.dir[j].user==0xe5)break;
    }

   if(j==DIR_ENTRY) errors (E_NOENTRY,NULL);

  return(j);
}

int main(int argc, char **argv)
{
  char buf[EXTSIZEINBYTES];
  int ch;
  int i,j,k,bytes_read;
  int curr_extent;
  char recno;
  char drive[3],dir[128],name[9],ext[5];


  printf("Write DOS file to .ODI (ORION DISK IMAGE) file\nv1.02\n(c) Cats 1998\n");

  if(argc!=3)
   {
    printf ("USE: file2odi <file_to_copy> <ODI_filename>\n");
    exit(0);
   }

   if((dos_file=open(argv[1],O_RDONLY|O_BINARY))==-1) errors(E_OPENFILE,argv[1]);

   fnsplit(argv[1],drive,dir,name,ext);

   if((odi_file=open(argv[2],O_RDWR|O_BINARY))==NULL) errors(E_OPENIMAGE,argv[2]);

   init_dir();
   j=get_next_entry(0);

   recno=0;
   curr_extent=2;

    d_dir.dir[j].user=0;
    d_dir.dir[j].recno=recno;
    d_dir.dir[j].rezerv1=0;
    d_dir.dir[j].rezerv2=0;
    d_dir.dir[j].ext_size=0;
    for(k=0;k<8;k++)d_dir.dir[j].extent[k]=0;

    k=0;
    while(name[k]>0)
    {
       d_dir.dir[j].name[k]=toupper(name[k]);
       k++;
    }
    while(k<8)
    {
       d_dir.dir[j].name[k]=0x20;
       k++;
    }

    k=0;
    while(ext[1+k]>0)
    {
       d_dir.dir[j].ext[k]=toupper(ext[1+k]);
       k++;
    }
    while(k<3)
	{
	   d_dir.dir[j].ext[k]=0x20;
	   k++;
	}
	for(k=0;k<8;k++) d_dir.dir[j].extent[k]=0;

	i=0;

   while(!eof(dos_file))
   {
	  if((bytes_read=read(dos_file,&buf,EXTSIZEINBYTES))!=0)
	  {
		  if(bytes_read==-1) errors(E_READ,"Source");
		  write_extent((curr_extent=get_next_extent(curr_extent)),(cluster*)&buf);

		  if((bytes_read&(EXT_SIZE-1))!=0) d_dir.dir[j].ext_size+=(bytes_read/EXT_SIZE)+1;
		  else d_dir.dir[j].ext_size+=(bytes_read/EXT_SIZE);

		  d_dir.dir[j].extent[i]=curr_extent;
		  i++;
		  if((i==8)&&!eof(dos_file))
		  {
			  i=0;
			  j=get_next_entry(j);

			  recno+=1;

			  d_dir.dir[j].user=0;
			  d_dir.dir[j].recno=recno;
			  d_dir.dir[j].rezerv1=0;
			  d_dir.dir[j].rezerv2=0;
			  d_dir.dir[j].ext_size=0;
			  for(k=0;k<8;k++)d_dir.dir[j].extent[k]=0;

			  k=0;
			  while(name[k]>0)
			  {
				  d_dir.dir[j].name[k]=toupper(name[k]);
				  k++;
			  }
			  while(k<=8)
			  {
				  d_dir.dir[j].name[k]=0x20;
				  k++;
			  }

			 k=0;
			 while(ext[1+k]>0)
			 {
				 d_dir.dir[j].ext[k]=toupper(ext[1+k]);
				 k++;
			 }
			 while(k<3)
			 {
				 d_dir.dir[j].ext[k]=0x20;
				 k++;
			 }
		  }
	  }
   }
   for(i=0;i<=1;i++)
   write_extent(i,(cluster*)&d_dir.buf[i]);
   fcloseall();
   return 0;
}
