//
//  (c) CATS 1998
//  "몠稢"  ࠧ ᪥ CP/M   -128  䠩 8-)))
//  Borland C 3.1
//  ( ࠬ ஥ "ᯮ C...")
//  v 0.01b
//
#include <stdio.h>
#include <dir.h>
#include <fcntl.h>
#include <stdlib.h>
#include <conio.h>
#include <ctype.h>
#include <io.h>
#include <bios.h>
#include <dos.h>
#include <sys\stat.h>
#include "util.h"


#define sys_len 0x5000
#define sect_len 0x400
#define MAX_EXT 1024
#define BASE 0x5000
#define EXTSIZEINBYTES 0x800

#define E_SEEK      0xf1 // seek error
#define E_READ      0xf2 // read error
#define E_WRITE     0xf3 // write error
#define E_NOENTRY   0xf4 // no free directory entry
#define E_OPENFILE  0xf5 // open source file error
#define E_OPENIMAGE 0xf6 // open image file error


  int extent[MAX_EXT];
  int dos_file;
  int odi_file;

void errors(int errno, char *msg)
{
  switch(errno)
  {
    case E_SEEK:      printf("Seek error !\n"); exit(E_SEEK);
    case E_READ:      printf("%s reading error !\n",msg) ; exit(E_READ);
    case E_WRITE:     printf("%s writting error !\n",msg); exit(E_WRITE);
    case E_NOENTRY:   printf("No empty directory entry !\n");exit(E_NOENTRY);
    case E_OPENFILE:  printf("%s file open error !\n",msg);exit(E_OPENFILE);
    case E_OPENIMAGE: printf("%s image open error !\n",msg);exit(E_OPENIMAGE);
    default:          printf("Unknown error !!!\n");exit(-1);
  }
}

long ext_off(int extent)
{
 return (long)BASE+(long)extent*(long)EXTSIZEINBYTES;
}

int read_extent(int extent_no, cluster *buf)
{
  if(lseek(odi_file,ext_off(extent_no),SEEK_SET)==-1L) errors (E_SEEK,NULL);
  if(read(odi_file,buf,EXTSIZEINBYTES)==-1) errors (E_READ,"Image");
  return 0;
}

int write_extent(int extent_no, cluster *buf)
{
  if(lseek(odi_file,ext_off(extent_no),SEEK_SET)==-1L) errors (E_SEEK,NULL);
  if(write(odi_file,buf,EXTSIZEINBYTES)==-1) errors (E_WRITE,"Image");
  extent[extent_no]=-1;
  return 0;
}

unsigned char find_dir(unsigned char recno)
{
 int i;

 for (i=recno+1;i<DIR_ENTRY;i++)
 {
  if((d_dir.dir[i].user!=0xe5)&&(d_dir.dir[i].recno==0)) break;
 }

  if(i==DIR_ENTRY) i=255;

  return i;
}

int get_next_extent(int extent_no)
{
 while(extent[extent_no]!=0) extent_no++;
 return(extent_no);
}

unsigned char get_next_entry(char entry, char *fname, char recno)
{
  int j;
   for(j=entry;j<DIR_ENTRY;j++)
    {
     if((!strnicmp(d_dir.dir[j].name,fname,11))&&(d_dir.dir[j].recno==recno+1))break;
    }

   if(j==DIR_ENTRY) j=255;

  return(j);
}

int main(int argc, char **argv)
{
  char buf[EXTSIZEINBYTES];
  int ch,Ok;
  int i,k,bytes_read;
  int curr_extent;
  char recno;
  char fname[13];
  unsigned char j,l;

  printf("Write DOS file to .ODI (ORION DISK IMAGE) file\nv1.01\n(c) Cats 1998\n");

  if(argc!=2)
   {
    printf ("USE: odi_grab <ODI_filename>\n");
    exit(0);
   }

   if((odi_file=open(argv[1],O_RDONLY|O_BINARY))==-1) errors(E_OPENFILE,argv[1]);

   j=-1;
   for(i=0;i<=1;i++) read_extent(i,(cluster*)d_dir.buf[i]);

   while((j=find_dir(j))!=255)
   {
     i=0; k=0; l=j;
     while((d_dir.dir[j].name[i]!=' ')&&(i<8))
     {
      if((d_dir.dir[j].name[i]=='\\')||(d_dir.dir[j].name[i]=='/')||(d_dir.dir[j].name[i]=='*')) fname[k]='_';
      else fname[k]=d_dir.dir[j].name[i];
      i+=1;
      k+=1;
     }
     fname[k]='.';
     k+=1;
     i=0;
     while((d_dir.dir[j].ext[i]!=' ')&&(i<3))
     {
      fname[k]=d_dir.dir[j].ext[i]&0x7f;
      i+=1;
      k+=1;
     }
     fname[k]=0;

     printf("Found %s\n",fname);

     _fmode=O_BINARY;
     if((dos_file=creat(fname,S_IREAD|S_IWRITE))==-1) errors (E_OPENFILE,fname);
     Ok=-1;
     while(Ok)
     {
     for(i=0;i<8;i++)
	 {
	  if(d_dir.dir[l].extent[i]==0) break;
	  read_extent(d_dir.dir[l].extent[i],(cluster*)buf);

      for(k=0;k<16;k++)
	   {
        write(dos_file,&buf[k*EXT_SIZE],EXT_SIZE);
        if((d_dir.dir[l].ext_size-=1)==0)
         {
          i=8;
          break;
	 }
	   }
	 }

       if((l=get_next_entry(l,d_dir.dir[l].name,d_dir.dir[l].recno))==255)
       {
         close(dos_file);
         Ok=0;
       }
     }


   }
   fcloseall();
   return 0;
}
