module ZX_clock_gen(
	input wire CLK, // 14 MHz clock input
	input wire M1n,
	input wire IORQn,
	input wire RESn,
	output reg PIXCLK = 0,
	output wire PIXCLKn,
	output wire DC0,
	output wire DC0n,
	output wire DC1,
	output wire DC1n,
	output wire DC2,
	output wire DC2n,
	output wire [4:0] H,
	output wire [7:0] V,
	output reg HSYN = 0,
	output reg VSYN = 0,
	output wire BORD,
	output wire BLANCn,
	output reg INTn,
	output wire SYNn
);
parameter HBorderStart = 256-1; // X resolution
parameter HBlancStart = 320-1;
parameter HBlancEnd = 384-1;
parameter HSynStart = 320-1;
parameter HSynEnd = 352-1;
parameter HLineEnd = 448-1;

parameter VBorderStart = 192-1; // Y Resolution
parameter VBlancStart = 248-1;
parameter VBlancEnd = 256-1;
parameter VSynStart = 248-1;
parameter VSynEnd = 256-1;
parameter VIntStart = 256-1;
parameter VIntEnd = 264-1;
parameter VLineEnd = 320-1;

reg	[8:0]	cntH = 0;
reg	[8:0]	cntV = 0;
reg HBL = 0, VBL = 0;
reg HBR = 0, VBR = 0;

always @(negedge CLK)
	PIXCLK <= PIXCLK + 1'd1;

always @(negedge PIXCLK)
begin
	if(cntH < HLineEnd)
		cntH <= cntH + 9'd1;
	else
		cntH <= 9'b000000000;

	HSYN <= (cntH >= HSynStart && cntH <= HSynEnd ) ? 1'b1 : 1'b0;
	HBR <= (cntH >= HBorderStart) ? 1'b1 : 1'b0;
	HBL <= (cntH >= HBlancStart && cntH <= HBlancEnd ) ? 1'b1 : 1'b0;
end


always @(posedge HSYN)
begin
	if(cntV < VLineEnd) // should be cntH + 1 as it is non blocking!
		cntV <= cntV + 9'd1;
	else
		cntV <= 9'd0;

	if(cntV == VSynStart) VSYN <= 1'b1;
	if(cntV == VSynEnd) VSYN <= 1'b0;
	if(cntV == VSynStart) VSYN <= 1'b1;
	if(cntV == VSynEnd) VSYN <= 1'b0;
	VBR <= (cntV >= VBorderStart) ? 1'b1 : 1'b0;
	if(cntV == VBlancStart) VBL <= 1'b1;
	if(cntV == VBlancEnd) VBL <= 1'b0;	
	if(cntV == VIntStart) INTn <= 1'b0;
	if(cntV == VIntEnd) INTn <= 1'b1;
end

assign PIXCLKn = PIXCLK;
assign DC0 = cntH[0];
assign DC0n = ~cntH[0];
assign DC1 = cntH[1];
assign DC1n = ~cntH[1];
assign DC2 = cntH[2];
assign DC2n = ~cntH[2];
assign H[4:0] = cntH[7:3];
assign V[7:0] = cntV[7:0];
assign BLANCn = ~(VBL | HBL);
assign SYNn = ~(HSYN ^ VSYN);
assign BORD = VBR | HBR;

endmodule
