module ZX_mem_mgr(
	input wire RESn,
	input wire [7:0] D,
	input wire [15:0] A,
	input wire DOS,
	input wire wr_FDn,
	input wire wr_7FFDn,
	input wire wr_1FFDn,
	output wire [19:14] RAM,
	output wire P0_RAM,
	output wire SCR,
	output wire ROM14,
	output wire ROM15
);

reg [7:0] pXFD_data = 0;
reg [7:0] p1FFD_data = 0;

wire wr_XFDn = wr_FDn | wr_7FFDn;

/*always @(negedge wr_XFDn or negedge RESn)
	if(~RESn)
		pXFD_data <= 8'h00;
	else 
	begin
		if(~pXFD_data[5])
			pXFD_data <= D;
	end

always @(negedge wr_1FFDn or negedge RESn)
	if(~RESn)
		p1FFD_data <= 8'h00;
	else
		p1FFD_data <= D;
*/

assign RAM = 2'b00;//(A[14]|A[15]) ? {p1FFD_data[7:6],p1FFD_data[4],pXFD_data[2:0]} : {3'b000,A[14],A[15],A[14]};
assign SCR = 1'b0;//pXFD_data[3];
assign P0_RAM = p1FFD_data[0];

assign ROM14 = pXFD_data[4];
assign ROM15 = p1FFD_data[1] | DOS;

endmodule