module ZX_mux(
	input wire [4:0] H,		// horizontal counter
	input wire [7:0] V,		// vertical counter
	input wire [19:14] RAM,	// Muxed Extended RAM address
	input wire [15:0] A,	// Z80 adderss
	input wire S0,			// RAS
	input wire DC1,			// H1
	input wire DC2,			// H2
	input wire SCR,			// Second SCREEN (128k)
	output wire [9:0] MA
);

always_comb begin
	casex({DC1,S0,DC2})
		'b00X: MA <= A[9:0];
		'b01X: MA <= {RAM[19], RAM[17], RAM[15], A[13:10], RAM[18], RAM[16], RAM[14]};
		'b100: MA <= {V[7:6], V[5:3], H[4:0]};
		'b101: MA <= {V[1:0], V[5:3], H[4:0]};
		'b110: MA <= {2'b00,1'b0/*SCR*/,7'b0110011};
		'b111: MA <= {2'b00,1'b0/*SCR*/,1'b0,{V[7],V[6],V[2]}, 3'b011};
	endcase
end

endmodule
