module ZX_video(
	input wire [7:0] D,
	input wire [7:0] MD,
	input wire DC0,
	input wire DC1,
	input wire DC2,
	input wire DC2n,
	input wire BORD,
	input wire VSYN,
	input wire OSC,
	input wire CLK,
	input wire BLANCn,
	input wire wr_FEn,
	output wire BEEPER,
	output wire TAPE_OUT,
	output wire B_OUT,
	output wire R_OUT,
	output wire G_OUT,
	output wire Y_OUT	
);

reg [7:0] ATTR = 7;
reg [7:0] SHIFT_REG = 0;
reg [4:0] FLASH_CNT = 0;
reg [4:0] PORTFE = 0;
reg [2:0] pixcnt = 0;

wire pixlatch = OSC & CLK & DC2n & DC1 & DC0;
wire attrlatch = OSC & CLK & DC2 & DC1 & DC0;

always @(posedge attrlatch)
	ATTR <= MD;

// latch pixels/attributes pixel shift
always @(posedge OSC or posedge pixlatch)
begin
	if(pixlatch)
		SHIFT_REG <= MD;
	else
		SHIFT_REG <= SHIFT_REG << 1;
end

// flash generator
always @(posedge VSYN)
	FLASH_CNT <= FLASH_CNT + 1'b1;

// border, beeper, tapeout
always @(negedge wr_FEn)
	PORTFE <= D[4:0];

wire flash = ATTR[6] & FLASH_CNT[4];
wire fpix = SHIFT_REG[7] ^ flash;
wire fpixn = ~fpix;
wire BORDn = ~BORD;

assign B_OUT = (((ATTR[3] & fpixn) | (ATTR[0] & fpix)) & BORDn) | (PORTFE[0] & BORD & BLANCn);
assign R_OUT = (((ATTR[4] & fpixn) | (ATTR[1] & fpix)) & BORDn) | (PORTFE[1] & BORD & BLANCn);
assign G_OUT = (((ATTR[5] & fpixn) | (ATTR[2] & fpix)) & BORDn) | (PORTFE[2] & BORD & BLANCn);

assign Y_OUT = ATTR[7] & (ATTR[5:0] != 0) & BORDn;

assign TAPE_OUT = PORTFE[3];
assign BEEPER = PORTFE[4];

endmodule