module SQRUM (
	input wire res_n,
	input wire gclk_n,
	input wire mreq_n,
	input wire iorq_n,
	input wire rd_n,
	input wire wr_n,
	input wire m1_n,
	input wire [15:0] a,
	inout wire [7:0] dt,
	inout wire [7:0] md,
	output reg [9:0] ma,
	output wire ras_n,
	output wire cas_n,
	output wire clk_z,
	output wire B_OUT,
	output wire R_OUT,
	output wire G_OUT,
	output wire Y_OUT,
	output wire syn_n,
	output wire [15:14] rom,
	output wire romcs_n,
	output wire ramwe_n,
	output wire int_n
);
///
///
///// COUNTER -------------------------------------------------
parameter HLineEnd = 448-1;
parameter HBorderStart = 256-1; // X resolution
parameter HBlancStart = 320-1;
parameter HBlancEnd = 384-1;
parameter HSynStart = 320-1;
parameter HSynEnd = 352-1;
parameter VBorderStart = 192-1; // Y Resolution
parameter VBlancStart = 248-1;
parameter VBlancEnd = 256-1;
parameter VSynStart = 248-1;
parameter VSynEnd = 256-1;
parameter VIntStart = 256-1;
parameter VIntEnd = 264-1;
parameter VLineEnd = 320-1;

reg casn = 1;
reg rasn = 1;
reg pixclk = 0;
reg [8:0] hcnt = 0;
reg [8:0] vcnt = 0;
reg intn = 1;
assign int_n = intn;

// pixelclock 7MHz generation
always @(negedge gclk_n)
	pixclk <= ~pixclk;

reg vsyn = 0, hsyn = 0;
reg hblanc = 0, vblanc = 0;
reg vbord = 0, hbord = 0;

// horizontal/vertical counter
always @(negedge pixclk)
begin
	if(hcnt < HLineEnd)
		hcnt <= hcnt + 1'b1;
	else
	begin
		hcnt <= 9'd0;
		
		if(vcnt < VLineEnd)
			vcnt <= vcnt + 9'd1;
		else
			vcnt <= 9'd0;
			//vcnt[8:1] <= 8'd0;
		vsyn <= (vcnt >= VSynStart && vcnt <= VSynEnd ) ? 1'b1 : 1'b0;
		vbord <= (vcnt >= VBorderStart) ? 1'b1 : 1'b0;
		vblanc <= (vcnt >= VBlancStart && vcnt <= VBlancEnd ) ? 1'b1 : 1'b0;
		intn <= (vcnt >= VIntStart && vcnt <= VIntEnd ) ? 1'b0 : 1'b1;
	end
	
	hsyn <= (hcnt >= HSynStart && hcnt <= HSynEnd ) ? 1'b1 : 1'b0;
	hbord <= (hcnt >= HBorderStart) ? 1'b1 : 1'b0;
	hblanc <= (hcnt >= HBlancStart && hcnt <= HBlancEnd ) ? 1'b1 : 1'b0;
end

assign syn_n = ~(hsyn ^ vsyn);

// CAS
always @(posedge gclk_n)
	casn <= ~hcnt[0];

// /RAS
always @(posedge pixclk)
	rasn <= hcnt[0];

assign cas_n = casn;
assign ras_n = rasn;
assign clk_z = rasn;
wire bord = vbord | hbord;
wire blanc_n = ~(vblanc | hblanc);
/// END COUNTER -----------------------------------------------

///
///
///// MEMORY PORT MODULE --------------------------------------
wire port_wr_req = wr_n | iorq_n;// | m1_n;
wire wr_FEn = wr_n | iorq_n | a[0];
wire wr_FDn = port_wr_req | a[1] | a[15] | a[9] | a[13] | a[14];
wire na14 = ~a[14];
wire na9 = ~a[9];
wire wr_7FFDn = port_wr_req | a[1] | a[15] | na14;
wire wr_1FFDn = port_wr_req | a[1] | a[15] | a[13] | a[14] | na9;

reg [7:0] pXFD_data = 0;
reg [7:0] p1FFD_data = 0;
wire wr_XFDn = wr_FDn | wr_7FFDn;
always @(negedge wr_XFDn)// or negedge res_n)
	//if(!res_n)
		//pXFD_data <= 8'd0;
	//else 
		if(~pXFD_data[5])
			pXFD_data <= dt;

always @(negedge wr_1FFDn)// or negedge res_n)
	//if(!res_n)
		//p1FFD_data <= 8'd0;
	//else
		p1FFD_data <= dt;

wire [19:14] ram = a[14] & a[15] ? {p1FFD_data[7:6],p1FFD_data[4],pXFD_data[2:0]} : {3'b000,a[14],a[15],a[14]}; // port ram address
wire scr_addr = pXFD_data[3]; // 128k screen select
wire p0_ram = 1'b0;//p1FFD_data[0];
assign rom = { 1'b0, 1'b1 };//pXFD_data[4], p1FFD_data[1] };// | DOS};
/// END MEMORY PORT MODULE ------------------------------------

///
///
///// MULTIPLEXOR ---------------------------------------------
always @(*)
	casex({hcnt[1],hcnt[0],hcnt[2]}) // 1024K multiplexor
		'b10X: ma <= a[9:0];															// column Z80 address
		'b11X: ma <= {ram[19], ram[17], ram[15], a[13:10], ram[18], ram[16], ram[14]};	// row Z80 address
		'b001: ma <= {vcnt[7:6], vcnt[5:3], hcnt[7:3]}; 								// column attr
		'b000: ma <= {vcnt[1:0], vcnt[5:3], hcnt[7:3]}; 								// column pixels
		'b011: ma <= {2'b00,scr_addr,1'b0, 6'b110011};									// row attr
		'b010: ma <= {2'b00,scr_addr,1'b0,vcnt[7],vcnt[6],vcnt[2], 3'b011};				// row pixels
	endcase
/// END MULTIPLEXOR -------------------------------------------


///
///
///// VIDEO ---------------------------------------------------
reg [7:0] pixels = 0;
reg [7:0] attr = 0;
reg [4:0] flash_cnt = 0;
reg [4:0] port_FE = 0;

// flash generator
always @(posedge vsyn)
	flash_cnt <= flash_cnt + 1'b1;

always @(posedge pixclk)
begin
	pixels <= pixels << 1;
		
	case(hcnt[2:0])
		'b001: pixels <= md;
		'b101: attr <= md;
	endcase
end
	

//always @(posedge pixclk)
	//if(hcnt[2:0] == 3'b111)
		//attr <= md;


//always @(negedge hcnt[2])//posedge attrlatch)
	//attr <= md;


// border, beeper, tapeout
always @(negedge wr_FEn)
	port_FE <= dt[4:0];

wire fpix = pixels[7] ^ (attr[7] & flash_cnt[4]);
wire [2:0] img = fpix ? attr[2:0] : attr[5:3];

assign B_OUT = blanc_n & (bord ? port_FE[0] : img[0]);
assign R_OUT = blanc_n & (bord ? port_FE[1] : img[1]);
assign G_OUT = blanc_n & (bord ? port_FE[2] : img[2]);
assign Y_OUT = blanc_n & (bord ? 1'bZ : |img & attr[6]);

/// END VIDEO -------------------------------------------------

///
///
///// BUFFERS -------------------------------------------------
wire readn = rd_n | mreq_n;
wire romn = a[14] | a[15];

assign romcs_n = readn | romn;
wire ramcsn = readn | ~romcs_n;
reg ramwen = 1'b1;
assign ramwe_n = ramwen;

reg [7:0] wr_buf = 0;
wire wrbuf = hcnt[0] & hcnt[1];

wire en_wr = wr_n | mreq_n | ras_n;
wire res_wr = ~hcnt[1];
always @ (posedge res_wr or negedge en_wr)
	if (res_wr)
		ramwen <= 1'b1;
	else
		ramwen <= 1'b0;

always @(negedge wrbuf)
	wr_buf <= md;

assign dt = ramcsn ? 8'bzzzzzzzz : wr_buf;
assign md = ramwen ? 8'bzzzzzzzz : dt;
/// END BUFFERS -----------------------------------------------

///
///
///// RAM_ROM -------------------------------------------------
/// END RAM_ROM -----------------------------------------------


endmodule
