-------------------------------------------------------------------------------
--
-- Title       : nzxvga
-- Design      : nzx80soc
-- Author      : Yefremoff Nick
-- Company     : Home
--
-------------------------------------------------------------------------------
--
-- File        : nzxvga_600x480x60.vhd
-- Generated   : Wed Jan  2 11:32:16 2016
--
-------------------------------------------------------------------------------
--
-- Description : VGA controller (640x480) 60 fps. Data = 320(32+256+32)x240(24+192+24) pixels.
--
-------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use ieee.std_logic_unsigned.all;

entity nzxvga is
	 port(
		pres   : in std_logic; --- active high
		aclk   : in std_logic; --- 25 MHz
		l0data : in std_logic_vector(7 downto 0);
		l1data : in std_logic_vector(7 downto 0);
		border : in std_logic_vector(2 downto 0);
		iMode  : in std_logic; --- 0 - ZX, 1 - new
		i1Layer: in std_logic; --- 0 - Off, 1 - On
		l0addr : out std_logic_vector(15 downto 0);
		l1addr : out std_logic_vector(15 downto 0);
		blank  : out std_logic; --- active high
		vgar   : out std_logic_vector(7 downto 0);
		vgag   : out std_logic_vector(7 downto 0);
		vgab   : out std_logic_vector(7 downto 0);
		vsync  : out std_logic; --- active low
		hsync  : out std_logic; --- active low
		oInt   : out std_logic --- active high
		 );
end;

architecture beh of nzxvga is
signal saddr : std_logic_vector(16 downto 0);
signal sd1addr : std_logic_vector(2 downto 0);
signal sd2addr : std_logic_vector(2 downto 0);
signal sd3addr : std_logic_vector(2 downto 0);
signal sd4addr : std_logic_vector(2 downto 0);
signal sd5addr : std_logic_vector(2 downto 0);
signal sd6addr : std_logic_vector(2 downto 0);
signal sd7addr : std_logic_vector(2 downto 0);
signal sd8addr : std_logic_vector(2 downto 0);
signal spix  : std_logic;
signal stwopix  : std_logic_vector(1 downto 0);
signal stwopixl : std_logic_vector(15 downto 0);
signal sdtwopixl : std_logic_vector(15 downto 0);
signal st2twopixl : std_logic_vector(15 downto 0);
signal st20attr  : std_logic_vector(7 downto 0);
signal st21attr  : std_logic_vector(7 downto 0);
signal st22attr  : std_logic_vector(7 downto 0);
signal st23attr  : std_logic_vector(7 downto 0);
signal s0attr  : std_logic_vector(7 downto 0);
signal s1attr  : std_logic_vector(7 downto 0);
signal s2attr  : std_logic_vector(7 downto 0);
signal s3attr  : std_logic_vector(7 downto 0);
signal sd0attr  : std_logic_vector(7 downto 0);
signal sd1attr  : std_logic_vector(7 downto 0);
signal sd2attr  : std_logic_vector(7 downto 0);
signal sd3attr  : std_logic_vector(7 downto 0);
signal spixl : std_logic_vector(7 downto 0);
signal sdpixl : std_logic_vector(7 downto 0);
signal st2pixl : std_logic_vector(7 downto 0);
signal satt  : std_logic_vector(7 downto 0);
signal st2att  : std_logic_vector(7 downto 0);
signal sIattr  : std_logic_vector(15 downto 0);
signal sPattr  : std_logic_vector(15 downto 0);
signal sdIattr  : std_logic_vector(15 downto 0);
signal sdPattr  : std_logic_vector(15 downto 0);
signal st2Iattr  : std_logic_vector(15 downto 0);
signal st2Pattr  : std_logic_vector(15 downto 0);
signal sattr : std_logic_vector(7 downto 0);
signal svgar : std_logic_vector(1 downto 0);
signal sdvgar : std_logic_vector(7 downto 0);
signal svgag : std_logic_vector(1 downto 0);
signal sdvgag : std_logic_vector(7 downto 0);
signal svgab : std_logic_vector(1 downto 0);
signal sdvgab : std_logic_vector(7 downto 0);
signal s64cnt : std_logic_vector(5 downto 0);
signal t2cnt : std_logic;
signal o12cnt,o14cnt,o16cnt,o18cnt,o20cnt,o22cnt,o24cnt,o26cnt : std_logic;
signal s397cnt : std_logic_vector(8 downto 0);
signal s525cnt : std_logic_vector(9 downto 0);
signal shsync,svsync : std_logic;
signal slayeren : std_logic_vector(1 downto 0);
signal sA : std_logic_vector(1 downto 0);
signal sMode : std_logic;
signal s1Layer : std_logic;
signal sscnr : std_logic_vector(7 downto 5);
signal sscng : std_logic_vector(4 downto 2);
signal sscnb : std_logic_vector(1 downto 0);
signal sblock : std_logic;
signal snscnr : std_logic_vector(7 downto 5);
signal snscng : std_logic_vector(4 downto 2);
signal snscnb : std_logic_vector(1 downto 0);
signal snscn : std_logic_vector(7 downto 0);

begin

vgar <= sdvgar;
vgag <= sdvgag;
vgab <= sdvgab;
hsync <= shsync;
vsync <= svsync;
oInt <= not svsync;
svgar(1) <=	(not spix and st2att(4)) or (spix and st2att(1)) after 1 ns;
svgar(0) <= st2att(6) and ((not spix and st2att(4)) or (spix and st2att(1))) after 1 ns;
svgag(1) <=	(not spix and st2att(5)) or (spix and st2att(2)) after 1 ns;
svgag(0) <= st2att(6) and ((not spix and st2att(5)) or (spix and st2att(2))) after 1 ns;
svgab(1) <=	(not spix and st2att(3)) or (spix and st2att(0)) after 1 ns;
svgab(0) <= st2att(6) and ((not spix and st2att(3)) or (spix and st2att(0))) after 1 ns;

mk_sync:process (pres,aclk,t2cnt,iMode,i1Layer,shsync,svsync)
begin
	if pres = '1' then
		s397cnt <= "110001100" after 1 ns; ---396
		s525cnt <= "1000001100" after 1 ns; ---524
		shsync <= '1' after 1 ns;
		svsync <= '1' after 1 ns;
		s64cnt <= "000000" after 1 ns;
		sMode <= '0' after 1 ns;
		s1Layer <= '0' after 1 ns;
		t2cnt <= '0' after 1 ns;
		o12cnt <= '0' after 1 ns;
		o14cnt <= '0' after 1 ns;
		o16cnt <= '0' after 1 ns;
		o18cnt <= '0' after 1 ns;
		o20cnt <= '0' after 1 ns;
		o22cnt <= '0' after 1 ns;
		o24cnt <= '0' after 1 ns;
		o26cnt <= '0' after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		s64cnt <= s64cnt + "000001" after 1 ns;
		if (s64cnt(3 downto 0) = "0001") then
			o12cnt <= '1' after 1 ns;
		else o12cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(3 downto 0) = "0011") then
			o14cnt <= '1' after 1 ns;
		else o14cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(3 downto 0) = "0101") then
			o16cnt <= '1' after 1 ns;
		else o16cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(3 downto 0) = "0111") then
			o18cnt <= '1' after 1 ns;
		else o18cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(3 downto 0) = "1001") then
			o20cnt <= '1' after 1 ns;
		else o20cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(3 downto 0) = "1011") then
			o22cnt <= '1' after 1 ns;
		else o22cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(3 downto 0) = "1101") then
			o24cnt <= '1' after 1 ns;
		else o24cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(3 downto 0) = "1111") then
			o26cnt <= '1' after 1 ns;
		else o26cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(0) = '0') then
			t2cnt <= '1' after 1 ns;
		else t2cnt <= '0' after 1 ns;
		end if;
		if t2cnt = '1' then
			if s397cnt = "000000110" then ---6
				shsync <= '0' after 1 ns;
			elsif s397cnt = "000110101" then ---53
				shsync <= '1' after 1 ns;
			end if;
			if s397cnt = "110001100" then ---396
				s64cnt <= "000000" after 1 ns;
				s397cnt <= "000000000" after 1 ns;
				if s525cnt = "1000001100" then ---524
					s525cnt <= "0000000000" after 1 ns;
				else
					s525cnt <= s525cnt + "1" after 1 ns;
				end if;
			else s397cnt <= s397cnt + "1" after 1 ns;
			end if;
			if s397cnt = "000000110" then ---6
				if s525cnt = "0000000000" then ---0
					svsync <= '0' after 1 ns;
				elsif s525cnt = "0000000010" then ---2
					svsync <= '1' after 1 ns;
				end if;
			end if;
		end if;
		if (shsync = '0' and svsync = '0' and s64cnt = "000000") then
			sMode <= iMode after 1 ns;
			s1Layer <= i1Layer after 1 ns;
		end if;
	end if;
end process;

mk_sd2addr:process (pres,saddr,aclk,t2cnt)
begin
	if pres = '1' then
		sd1addr <= "000" after 1 ns;
		sd2addr <= "000" after 1 ns;
		sd3addr <= "000" after 1 ns;
		sd4addr <= "000" after 1 ns;
		sd5addr <= "000" after 1 ns;
		sd6addr <= "000" after 1 ns;
		sd7addr <= "000" after 1 ns;
		sd8addr <= "000" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t2cnt = '1' then
			sd1addr <= saddr(2 downto 0) after 1 ns;
			sd2addr <= sd1addr after 1 ns;
			sd3addr <= sd2addr after 1 ns;
			sd4addr <= sd3addr after 1 ns;
			sd5addr <= sd4addr after 1 ns;
			sd6addr <= sd5addr after 1 ns;
			sd7addr <= sd6addr after 1 ns;
			sd8addr <= sd7addr after 1 ns;
		end if;
	end if;
end process;

sblock <= sd8addr(2);

mk_st2pixl:process (pres,aclk,t2cnt,sdpixl,sdIattr,sdPattr)
begin
	if pres = '1' then
		st2att <= x"00" after 1 ns;
		st2pixl <= x"00" after 1 ns;
		st2Iattr <= x"0000" after 1 ns;
		st2Pattr <= x"0000" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t2cnt = '1' then
			st2att <= satt after 1 ns;
			st2pixl <= sdpixl after 1 ns;
			st2Iattr <= sdIattr after 1 ns;
			st2Pattr <= sdPattr after 1 ns;
		end if;
	end if;
end process;

mk_spix:process (sd8addr,st2pixl)
begin
	case sd8addr(2 downto 0) is
		when "000" => spix <= st2pixl(7);
		when "001" => spix <= st2pixl(6);
		when "010" => spix <= st2pixl(5);
		when "011" => spix <= st2pixl(4);
		when "100" => spix <= st2pixl(3);
		when "101" => spix <= st2pixl(2);
		when "110" => spix <= st2pixl(1);
		when others => spix <= st2pixl(0);
	end case;
end process;

mk_sscn:process (spix,st2Iattr,st2Pattr,sblock)
begin
	if sblock = '0' then
		if spix = '1' then  --- Ink
			sscnr <= st2Iattr(7 downto 5);
			sscng <= st2Iattr(4 downto 2);
			sscnb <= st2Iattr(1 downto 0);
		else --- Paper
			sscnr <= st2Pattr(7 downto 5);
			sscng <= st2Pattr(4 downto 2);
			sscnb <= st2Pattr(1 downto 0);
		end if;
	else
		if spix = '1' then --- Ink
			sscnr <= st2Iattr(15 downto 13);
			sscng <= st2Iattr(12 downto 10);
			sscnb <= st2Iattr(9 downto 8);
		else --- Paper
			sscnr <= st2Pattr(15 downto 13);
			sscng <= st2Pattr(12 downto 10);
			sscnb <= st2Pattr(9 downto 8);
		end if;
	end if;
end process;

mk_st2twopixl:process (pres,aclk,t2cnt,sdtwopixl,sd0attr,sd1attr,sd2attr,sd3attr)
begin
	if pres = '1' then
		st2twopixl <= x"0000" after 1 ns;
		st20attr <= x"00" after 1 ns;
		st21attr <= x"00" after 1 ns;
		st22attr <= x"00" after 1 ns;
		st23attr <= x"00" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t2cnt = '1' then
			st2twopixl <= sdtwopixl after 1 ns;
			st20attr <= sd0attr after 1 ns;
			st21attr <= sd1attr after 1 ns;
			st22attr <= sd2attr after 1 ns;
			st23attr <= sd3attr after 1 ns;
		end if;
	end if;
end process;

mk_stwopix:process (sd8addr,st2twopixl)
begin
	case sd8addr(2 downto 0) is
		when "000" => stwopix <= st2twopixl(15 downto 14);
		when "001" => stwopix <= st2twopixl(13 downto 12);
		when "010" => stwopix <= st2twopixl(11 downto 10);
		when "011" => stwopix <= st2twopixl(9 downto 8);
		when "100" => stwopix <= st2twopixl(7 downto 6);
		when "101" => stwopix <= st2twopixl(5 downto 4);
		when "110" => stwopix <= st2twopixl(3 downto 2);
		when others => stwopix <= st2twopixl(1 downto 0);
	end case;
end process;

mk_snscn:process (stwopix,st20attr,st21attr,st22attr,st23attr)
begin
	case stwopix is
		when "00" =>
			snscnr <= st20attr(7 downto 5);
			snscng <= st20attr(4 downto 2);
			snscnb <= st20attr(1 downto 0);
		when "01" =>
			snscnr <= st21attr(7 downto 5);
			snscng <= st21attr(4 downto 2);
			snscnb <= st21attr(1 downto 0);
		when "10" =>
			snscnr <= st22attr(7 downto 5);
			snscng <= st22attr(4 downto 2);
			snscnb <= st22attr(1 downto 0);
		when others =>
			snscnr <= st23attr(7 downto 5);
			snscng <= st23attr(4 downto 2);
			snscnb <= st23attr(1 downto 0);
	end case;
end process;

mk_paddr:process (pres,aclk,o12cnt,o14cnt,o16cnt,o18cnt,o20cnt,o22cnt,o24cnt,o26cnt,l0data,l1data,s397cnt,s525cnt,saddr,sMode)
begin
	if pres = '1' then
		spixl   <= x"00" after 1 ns;
		sdpixl  <= x"00" after 1 ns;
		stwopixl   <= x"0000" after 1 ns;
		sdtwopixl  <= x"0000" after 1 ns;
		satt    <= x"00" after 1 ns;
		sattr   <= x"00" after 1 ns;
		s0attr  <= x"00" after 1 ns;
		s1attr  <= x"00" after 1 ns;
		s2attr  <= x"00" after 1 ns;
		s3attr  <= x"00" after 1 ns;
		sd0attr  <= x"00" after 1 ns;
		sd1attr  <= x"00" after 1 ns;
		sd2attr  <= x"00" after 1 ns;
		sd3attr  <= x"00" after 1 ns;
		sIattr  <= x"0000" after 1 ns;
		sPattr  <= x"0000" after 1 ns;
		sdIattr <= x"0000" after 1 ns;
		sdPattr <= x"0000" after 1 ns;
		l0addr  <= "0000000000000000" after 1 ns;
		l1addr  <= "0000000000000000" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if (s525cnt > "0001010010") and (s525cnt < "0111010011") then --- > 82 and < 467
			if s397cnt > "001101000" and s397cnt < "101101001" then --- > 104 and < 361
				if o12cnt = '1' then
					l1addr <= "00" & saddr(16 downto 9) & saddr(7 downto 2) after 1 ns; --- pixls
				elsif o14cnt = '1' then
					l1addr <= ("00" & saddr(16 downto 9) & saddr(7 downto 2)) + x"1" after 1 ns; --- pixls
				elsif o16cnt = '1' then
					l1addr <= "0011" & saddr(16 downto 12) & saddr(7 downto 2) & "0" after 1 ns; --- new attrs
				elsif o18cnt = '1' then
					l1addr <= ("0011" & saddr(16 downto 12) & saddr(7 downto 2) & "0") + x"1" after 1 ns; --- new attrs
				elsif o20cnt = '1' then
					l1addr <= "0011" & saddr(16 downto 12) & saddr(7 downto 2) & "0" after 1 ns; --- new attrs
				elsif o22cnt = '1' then
					l1addr <= ("0011" & saddr(16 downto 12) & saddr(7 downto 2) & "0") + x"1" after 1 ns; --- new attrs
				end if;
				if o14cnt = '1' then
					stwopixl(7 downto 0) <= l1data after 1 ns;
				end if;
				if o16cnt = '1' then
					stwopixl(15 downto 8) <= l1data after 1 ns;
				end if;
				if o18cnt = '1' then
					s0attr(7 downto 0) <= l1data after 1 ns;
				end if;
				if o20cnt = '1' then
					s1attr(7 downto 0) <= l1data after 1 ns;
				end if;
				if o22cnt = '1' then
					s2attr(7 downto 0) <= l1data after 1 ns;
				end if;
				if o24cnt = '1' then
					s3attr(7 downto 0) <= l1data after 1 ns;
				end if;
				if o26cnt = '1' then
					sdtwopixl <= stwopixl after 1 ns;
					sd0attr <= s0attr after 1 ns;
					sd1attr <= s1attr after 1 ns;
					sd2attr <= s2attr after 1 ns;
					sd3attr <= s3attr after 1 ns;
				end if;
	
				if sMode = '0' then	--- ZX attr
					if o14cnt = '1' then
						l0addr <= "010110" & saddr(16 downto 12) & saddr(7 downto 3) after 1 ns; --- ZX attrs
						spixl <= l0data after 1 ns;
					elsif o12cnt = '1' then
						l0addr <= "010" & saddr(16 downto 15) & saddr(11 downto 9) & saddr(14 downto 12) & saddr(7 downto 3) after 1 ns; --- pixls
					end if;
					if o16cnt = '1' then
						sattr <= l0data after 1 ns;
					end if;
					if o26cnt = '1' then
						sdpixl <= spixl after 1 ns;
						satt <= sattr after 1 ns;
					end if;
				else --- new attr
					if o12cnt = '1' then
						l0addr <= "010" & saddr(16 downto 15) & saddr(11 downto 9) & saddr(14 downto 12) & saddr(7 downto 3) after 1 ns; --- pixls
					elsif o14cnt = '1' or o16cnt = '1' then
						l0addr <= ("010" & saddr(16 downto 15) & saddr(14 downto 11) & saddr(7 downto 1)) + x"1800" after 1 ns; --- new attrs
					elsif o18cnt = '1' or o20cnt = '1' then
						l0addr <= ("010" & saddr(16 downto 15) & saddr(14 downto 11) & saddr(7 downto 1)) + x"1801" after 1 ns; --- new attrs
					end if;
					if o14cnt = '1' then
						spixl <= l0data after 1 ns;
					end if;
					if o16cnt = '1' then
						sIattr(7 downto 0) <= l0data after 1 ns;
					end if;
					if o18cnt = '1' then
						sPattr(7 downto 0) <= l0data after 1 ns;
					end if;
					if o20cnt = '1' then
						sIattr(15 downto 8) <= l0data after 1 ns;
					end if;
					if o22cnt = '1' then
						sPattr(15 downto 8) <= l0data after 1 ns;
					end if;
					if o26cnt = '1' then
						sdpixl <= spixl after 1 ns;
						sdIattr <= sIattr after 1 ns;
						sdPattr <= sPattr after 1 ns;
					end if;
				end if;
			end if;
		end if;
	end if;
end process;

mk_saddr:process (pres,aclk,t2cnt,s525cnt,s397cnt)
begin
	if pres = '1' then
		saddr <= "00000000000000000" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t2cnt = '1' then
			if s397cnt = "000000110" and s525cnt = "0000000000" then --- =6 and =0
				saddr <= "00000000000000000" after 1 ns;
			elsif (s525cnt > "0001010010") and (s525cnt < "0111010011") then --- > 82 and < 467
				if s397cnt > "001101000" and s397cnt < "101101001" then --- > 104 and < 361
					saddr <= saddr + "1" after 1 ns;
				end if;
			end if;
		end if;
	end if;
end process;

mk_blank:process (pres,aclk,t2cnt,s525cnt,s397cnt)
begin
	if pres = '1' then
		blank <= '1' after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t2cnt = '1' then
			if s525cnt < "1000000011" and s525cnt > "0000100010" then --- < 515 and > 34
				if s397cnt > "001001010" and s397cnt < "110001100" then --- > 74 and < 396
					blank <= '0' after 1 ns;
				else
					blank <= '1' after 1 ns;
				end if;
			else
				blank <= '1' after 1 ns;
			end if;
		end if;
	end if;
end process;

snscn <= snscnr(7) & snscnr(6) & snscnr(5) & snscng(4) & snscng(3) & snscng(2) & snscnb(1) & snscnb(0);

mk_svga:process (pres,aclk,t2cnt,s525cnt,s397cnt,svgag,svgab,svgar,sscng,sscnb,sscnr,snscng,snscnb,snscnr,snscn,sMode,s1Layer)
begin
	if pres = '1' then
		sdvgar <= x"00" after 1 ns;
		sdvgag <= x"00" after 1 ns;
		sdvgab <= x"00" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t2cnt = '1' then
			if s525cnt > "0001010010" and s525cnt < "0111010011" then --- > 82 and < 467
				if s397cnt > "001110000" and s397cnt < "101110001" then --- > 112 and < 369
					if s1Layer = '1' then
						if snscn = x"00" then
							if sMode = '0' then
								sdvgar <= svgar(1) & svgar(0) & svgar(1) & svgar(0) & svgar(1) & svgar(0) & svgar(1) & svgar(0) after 1 ns;
								sdvgag <= svgag(1) & svgag(0) & svgag(1) & svgag(0) & svgag(1) & svgag(0) & svgag(1) & svgag(0) after 1 ns;
								sdvgab <= svgab(1) & svgab(0) & svgab(1) & svgab(0) & svgab(1) & svgab(0) & svgab(1) & svgab(0) after 1 ns;
							else --- sMode = '1'
								sdvgar <= sscnr(7) & sscnr(6) & sscnr(5) & sscnr(7) & sscnr(6) & sscnr(5) & "00" after 1 ns;
								sdvgag <= sscng(4) & sscng(3) & sscng(2) & sscng(4) & sscng(3) & sscng(2) & "00" after 1 ns;
								sdvgab <= sscnb(1) & sscnb(0) & sscnb(1) & sscnb(0) & sscnb(1) & sscnb(0) & "00" after 1 ns;
							end if;
						else
							sdvgar <= snscnr(7) & snscnr(6) & snscnr(5) & snscnr(7) & snscnr(6) & snscnr(5) & "00" after 1 ns;
							sdvgag <= snscng(4) & snscng(3) & snscng(2) & snscng(4) & snscng(3) & snscng(2) & "00" after 1 ns;
							sdvgab <= snscnb(1) & snscnb(0) & snscnb(1) & snscnb(0) & snscnb(1) & snscnb(0) & "00" after 1 ns;
						end if;	
					else
						if sMode = '0' then
							sdvgar <= svgar(1) & svgar(0) & svgar(1) & svgar(0) & svgar(1) & svgar(0) & svgar(1) & svgar(0) after 1 ns;
							sdvgag <= svgag(1) & svgag(0) & svgag(1) & svgag(0) & svgag(1) & svgag(0) & svgag(1) & svgag(0) after 1 ns;
							sdvgab <= svgab(1) & svgab(0) & svgab(1) & svgab(0) & svgab(1) & svgab(0) & svgab(1) & svgab(0) after 1 ns;
						else --- sMode = '1'
							sdvgar <= sscnr(7) & sscnr(6) & sscnr(5) & sscnr(7) & sscnr(6) & sscnr(5) & "00" after 1 ns;
							sdvgag <= sscng(4) & sscng(3) & sscng(2) & sscng(4) & sscng(3) & sscng(2) & "00" after 1 ns;
							sdvgab <= sscnb(1) & sscnb(0) & sscnb(1) & sscnb(0) & sscnb(1) & sscnb(0) & "00" after 1 ns;
						end if;
					end if;
				else
					sdvgag <= border(2) & border(2) & border(2) & border(2) & border(2) & border(2) & border(2) & border(2) after 1 ns;
					sdvgab <= border(1) & border(1) & border(1) & border(1) & border(1) & border(1) & border(1) & border(1) after 1 ns;
					sdvgar <= border(0) & border(0) & border(0) & border(0) & border(0) & border(0) & border(0) & border(0) after 1 ns;
				end if;
			else
				sdvgag <= border(2) & border(2) & border(2) & border(2) & border(2) & border(2) & border(2) & border(2) after 1 ns;
				sdvgab <= border(1) & border(1) & border(1) & border(1) & border(1) & border(1) & border(1) & border(1) after 1 ns;
				sdvgar <= border(0) & border(0) & border(0) & border(0) & border(0) & border(0) & border(0) & border(0) after 1 ns;
			end if;
		end if;
	end if;
end process;

end;
