-------------------------------------------------------------------------------
--
-- Title       : nzxvga
-- Design      : nzx80soc
-- Author      : Yefremoff Nick
-- Company     : Home
--
-------------------------------------------------------------------------------
--
-- File        : nzxvga_600x480x60.vhd
-- Generated   : Wed Jan  2 11:32:16 2016
--
-------------------------------------------------------------------------------
--
-- Description : VGA controller (640x480) 60 fps. Data = 320(32+256+32)x240(24+192+24) pixels.
--
-------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.all;
use ieee.std_logic_unsigned.all;

entity nzxvga is
	 port(
		pres   : in std_logic; --- active high
		aclk   : in std_logic; --- 25 MHz
		l1data : in std_logic_vector(7 downto 0);
		l2data : in std_logic_vector(7 downto 0);
		zxvdata: in std_logic_vector(7 downto 0);
		border : in std_logic_vector(2 downto 0);
		iMode  : in std_logic; --- 0 - ZX, 1 - new
		iLayers: in std_logic_vector(1 downto 0); --- 00 - L0 & L1 Off, 01 - L0 On, 10 - L1 On, 11 - L0 & L1 On;
		l1addr : out std_logic_vector(15 downto 0);
		l2addr : out std_logic_vector(15 downto 0);
		zxvaddr: out std_logic_vector(15 downto 0);
		blank  : out std_logic; --- active high
		vgar   : out std_logic_vector(7 downto 0);
		vgag   : out std_logic_vector(7 downto 0);
		vgab   : out std_logic_vector(7 downto 0);
		vsync  : out std_logic; --- active low
		hsync  : out std_logic; --- active low
		oInt   : out std_logic --- active high
		 );
end;

architecture beh of nzxvga is
signal saddr : std_logic_vector(16 downto 0);
signal sd1addr : std_logic_vector(2 downto 0);
signal sd2addr : std_logic_vector(2 downto 0);
signal sd3addr : std_logic_vector(2 downto 0);
signal sd4addr : std_logic_vector(2 downto 0);
signal sd5addr : std_logic_vector(2 downto 0);
signal sd6addr : std_logic_vector(2 downto 0);
signal sd7addr : std_logic_vector(2 downto 0);
signal sd8addr : std_logic_vector(2 downto 0);
signal spix  : std_logic;
signal stl2wopix  : std_logic_vector(1 downto 0);
signal stl2wopixl : std_logic_vector(15 downto 0);
signal sdtl2wopixl : std_logic_vector(15 downto 0);
signal st2tl2wopixl : std_logic_vector(15 downto 0);
signal stl1wopix  : std_logic_vector(1 downto 0);
signal stl1wopixl : std_logic_vector(15 downto 0);
signal sdtl1wopixl : std_logic_vector(15 downto 0);
signal st2tl1wopixl : std_logic_vector(15 downto 0);
signal st20l1attr  : std_logic_vector(7 downto 0);
signal st21l1attr  : std_logic_vector(7 downto 0);
signal st22l1attr  : std_logic_vector(7 downto 0);
signal st23l1attr  : std_logic_vector(7 downto 0);
signal st20l2attr  : std_logic_vector(7 downto 0);
signal st21l2attr  : std_logic_vector(7 downto 0);
signal st22l2attr  : std_logic_vector(7 downto 0);
signal st23l2attr  : std_logic_vector(7 downto 0);
signal s0l1attr  : std_logic_vector(7 downto 0);
signal s1l1attr  : std_logic_vector(7 downto 0);
signal s2l1attr  : std_logic_vector(7 downto 0);
signal s3l1attr  : std_logic_vector(7 downto 0);
signal sd0l1attr  : std_logic_vector(7 downto 0);
signal sd1l1attr  : std_logic_vector(7 downto 0);
signal sd2l1attr  : std_logic_vector(7 downto 0);
signal sd3l1attr  : std_logic_vector(7 downto 0);
signal s0l2attr  : std_logic_vector(7 downto 0);
signal s1l2attr  : std_logic_vector(7 downto 0);
signal s2l2attr  : std_logic_vector(7 downto 0);
signal s3l2attr  : std_logic_vector(7 downto 0);
signal sd0l2attr  : std_logic_vector(7 downto 0);
signal sd1l2attr  : std_logic_vector(7 downto 0);
signal sd2l2attr  : std_logic_vector(7 downto 0);
signal sd3l2attr  : std_logic_vector(7 downto 0);
signal spixl : std_logic_vector(7 downto 0);
signal sdpixl : std_logic_vector(7 downto 0);
signal st2pixl : std_logic_vector(7 downto 0);
signal satt  : std_logic_vector(7 downto 0);
signal st2att  : std_logic_vector(7 downto 0);
signal sIattr  : std_logic_vector(15 downto 0);
signal sPattr  : std_logic_vector(15 downto 0);
signal sdIattr  : std_logic_vector(15 downto 0);
signal sdPattr  : std_logic_vector(15 downto 0);
signal st2Iattr  : std_logic_vector(15 downto 0);
signal st2Pattr  : std_logic_vector(15 downto 0);
signal sattr : std_logic_vector(7 downto 0);
signal svgar : std_logic_vector(1 downto 0);
signal sdvgar : std_logic_vector(7 downto 0);
signal svgag : std_logic_vector(1 downto 0);
signal sdvgag : std_logic_vector(7 downto 0);
signal svgab : std_logic_vector(1 downto 0);
signal sdvgab : std_logic_vector(7 downto 0);
signal s64cnt : std_logic_vector(5 downto 0);
signal t2cnt : std_logic;
signal o12cnt,o14cnt,o16cnt,o18cnt,o20cnt,o22cnt,o24cnt,o26cnt : std_logic;
signal s397cnt : std_logic_vector(8 downto 0);
signal s525cnt : std_logic_vector(9 downto 0);
signal shsync,svsync : std_logic;
signal slayeren : std_logic_vector(1 downto 0);
signal sA : std_logic_vector(1 downto 0);
signal sMode : std_logic;
signal sLayers : std_logic_vector(1 downto 0);
signal sscnr : std_logic_vector(7 downto 5);
signal sscng : std_logic_vector(4 downto 2);
signal sscnb : std_logic_vector(1 downto 0);
signal sblock : std_logic;
signal snl1scnr : std_logic_vector(7 downto 5);
signal snl1scng : std_logic_vector(4 downto 2);
signal snl1scnb : std_logic_vector(1 downto 0);
signal snl2scnr : std_logic_vector(7 downto 5);
signal snl2scng : std_logic_vector(4 downto 2);
signal snl2scnb : std_logic_vector(1 downto 0);
signal snl1scn : std_logic_vector(7 downto 0);
signal snl2scn : std_logic_vector(7 downto 0);

begin

vgar <= sdvgar;
vgag <= sdvgag;
vgab <= sdvgab;
hsync <= shsync;
vsync <= svsync;
oInt <= not svsync;
svgar(1) <=	(not spix and st2att(4)) or (spix and st2att(1)) after 1 ns;
svgar(0) <= st2att(6) and ((not spix and st2att(4)) or (spix and st2att(1))) after 1 ns;
svgag(1) <=	(not spix and st2att(5)) or (spix and st2att(2)) after 1 ns;
svgag(0) <= st2att(6) and ((not spix and st2att(5)) or (spix and st2att(2))) after 1 ns;
svgab(1) <=	(not spix and st2att(3)) or (spix and st2att(0)) after 1 ns;
svgab(0) <= st2att(6) and ((not spix and st2att(3)) or (spix and st2att(0))) after 1 ns;

mk_sync:process (pres,aclk,t2cnt,iMode,iLayers,shsync,svsync)
begin
	if pres = '1' then
		s397cnt <= "110001100" after 1 ns; ---396
		s525cnt <= "1000001100" after 1 ns; ---524
		shsync <= '1' after 1 ns;
		svsync <= '1' after 1 ns;
		s64cnt <= "000000" after 1 ns;
		sMode <= '0' after 1 ns;
		sLayers <= "00" after 1 ns;
		t2cnt <= '0' after 1 ns;
		o12cnt <= '0' after 1 ns;
		o14cnt <= '0' after 1 ns;
		o16cnt <= '0' after 1 ns;
		o18cnt <= '0' after 1 ns;
		o20cnt <= '0' after 1 ns;
		o22cnt <= '0' after 1 ns;
		o24cnt <= '0' after 1 ns;
		o26cnt <= '0' after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		s64cnt <= s64cnt + "000001" after 1 ns;
		if (s64cnt(3 downto 0) = "0001") then
			o12cnt <= '1' after 1 ns;
		else o12cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(3 downto 0) = "0011") then
			o14cnt <= '1' after 1 ns;
		else o14cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(3 downto 0) = "0101") then
			o16cnt <= '1' after 1 ns;
		else o16cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(3 downto 0) = "0111") then
			o18cnt <= '1' after 1 ns;
		else o18cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(3 downto 0) = "1001") then
			o20cnt <= '1' after 1 ns;
		else o20cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(3 downto 0) = "1011") then
			o22cnt <= '1' after 1 ns;
		else o22cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(3 downto 0) = "1101") then
			o24cnt <= '1' after 1 ns;
		else o24cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(3 downto 0) = "1111") then
			o26cnt <= '1' after 1 ns;
		else o26cnt <= '0' after 1 ns;
		end if;
		if (s64cnt(0) = '0') then
			t2cnt <= '1' after 1 ns;
		else t2cnt <= '0' after 1 ns;
		end if;
		if t2cnt = '1' then
			if s397cnt = "000000110" then ---6
				shsync <= '0' after 1 ns;
			elsif s397cnt = "000110101" then ---53
				shsync <= '1' after 1 ns;
			end if;
			if s397cnt = "110001100" then ---396
				s64cnt <= "000000" after 1 ns;
				s397cnt <= "000000000" after 1 ns;
				if s525cnt = "1000001100" then ---524
					s525cnt <= "0000000000" after 1 ns;
				else
					s525cnt <= s525cnt + "1" after 1 ns;
				end if;
			else s397cnt <= s397cnt + "1" after 1 ns;
			end if;
			if s397cnt = "000000110" then ---6
				if s525cnt = "0000000000" then ---0
					svsync <= '0' after 1 ns;
				elsif s525cnt = "0000000010" then ---2
					svsync <= '1' after 1 ns;
				end if;
			end if;
		end if;
		if (shsync = '0' and svsync = '0' and s64cnt = "000000") then
			sMode <= iMode after 1 ns;
			sLayers <= iLayers after 1 ns;
		end if;
	end if;
end process;

mk_sd2addr:process (pres,saddr,aclk,t2cnt)
begin
	if pres = '1' then
		sd1addr <= "000" after 1 ns;
		sd2addr <= "000" after 1 ns;
		sd3addr <= "000" after 1 ns;
		sd4addr <= "000" after 1 ns;
		sd5addr <= "000" after 1 ns;
		sd6addr <= "000" after 1 ns;
		sd7addr <= "000" after 1 ns;
		sd8addr <= "000" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t2cnt = '1' then
			sd1addr <= saddr(2 downto 0) after 1 ns;
			sd2addr <= sd1addr after 1 ns;
			sd3addr <= sd2addr after 1 ns;
			sd4addr <= sd3addr after 1 ns;
			sd5addr <= sd4addr after 1 ns;
			sd6addr <= sd5addr after 1 ns;
			sd7addr <= sd6addr after 1 ns;
			sd8addr <= sd7addr after 1 ns;
		end if;
	end if;
end process;

sblock <= sd8addr(2);

mk_st2pixl:process (pres,aclk,t2cnt,sdpixl,sdIattr,sdPattr)
begin
	if pres = '1' then
		st2att <= x"00" after 1 ns;
		st2pixl <= x"00" after 1 ns;
		st2Iattr <= x"0000" after 1 ns;
		st2Pattr <= x"0000" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t2cnt = '1' then
			st2att <= satt after 1 ns;
			st2pixl <= sdpixl after 1 ns;
			st2Iattr <= sdIattr after 1 ns;
			st2Pattr <= sdPattr after 1 ns;
		end if;
	end if;
end process;

mk_spix:process (sd8addr,st2pixl)
begin
	case sd8addr(2 downto 0) is
		when "000" => spix <= st2pixl(7);
		when "001" => spix <= st2pixl(6);
		when "010" => spix <= st2pixl(5);
		when "011" => spix <= st2pixl(4);
		when "100" => spix <= st2pixl(3);
		when "101" => spix <= st2pixl(2);
		when "110" => spix <= st2pixl(1);
		when others => spix <= st2pixl(0);
	end case;
end process;

mk_sscn:process (spix,st2Iattr,st2Pattr,sblock)
begin
	if sblock = '0' then
		if spix = '1' then  --- Ink
			sscnr <= st2Iattr(7 downto 5);
			sscng <= st2Iattr(4 downto 2);
			sscnb <= st2Iattr(1 downto 0);
		else --- Paper
			sscnr <= st2Pattr(7 downto 5);
			sscng <= st2Pattr(4 downto 2);
			sscnb <= st2Pattr(1 downto 0);
		end if;
	else
		if spix = '1' then --- Ink
			sscnr <= st2Iattr(15 downto 13);
			sscng <= st2Iattr(12 downto 10);
			sscnb <= st2Iattr(9 downto 8);
		else --- Paper
			sscnr <= st2Pattr(15 downto 13);
			sscng <= st2Pattr(12 downto 10);
			sscnb <= st2Pattr(9 downto 8);
		end if;
	end if;
end process;

mk_st2twopixl:process (pres,aclk,t2cnt,sdtl2wopixl,sdtl1wopixl,sd0l1attr,sd1l1attr,sd2l1attr,sd3l1attr,sd0l2attr,sd1l2attr,sd2l2attr,sd3l2attr)
begin
	if pres = '1' then
		st2tl1wopixl <= x"0000" after 1 ns;
		st2tl2wopixl <= x"0000" after 1 ns;
		st20l1attr <= x"00" after 1 ns;
		st21l1attr <= x"00" after 1 ns;
		st22l1attr <= x"00" after 1 ns;
		st23l1attr <= x"00" after 1 ns;
		st20l2attr <= x"00" after 1 ns;
		st21l2attr <= x"00" after 1 ns;
		st22l2attr <= x"00" after 1 ns;
		st23l2attr <= x"00" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t2cnt = '1' then
			st2tl1wopixl <= sdtl1wopixl after 1 ns;
			st2tl2wopixl <= sdtl2wopixl after 1 ns;
			st20l1attr <= sd0l1attr after 1 ns;
			st21l1attr <= sd1l1attr after 1 ns;
			st22l1attr <= sd2l1attr after 1 ns;
			st23l1attr <= sd3l1attr after 1 ns;
			st20l2attr <= sd0l2attr after 1 ns;
			st21l2attr <= sd1l2attr after 1 ns;
			st22l2attr <= sd2l2attr after 1 ns;
			st23l2attr <= sd3l2attr after 1 ns;
		end if;
	end if;
end process;

mk_stl1wopix:process (sd8addr,st2tl1wopixl)
begin
	case sd8addr(2 downto 0) is
		when "000" => stl1wopix <= st2tl1wopixl(15 downto 14);
		when "001" => stl1wopix <= st2tl1wopixl(13 downto 12);
		when "010" => stl1wopix <= st2tl1wopixl(11 downto 10);
		when "011" => stl1wopix <= st2tl1wopixl(9 downto 8);
		when "100" => stl1wopix <= st2tl1wopixl(7 downto 6);
		when "101" => stl1wopix <= st2tl1wopixl(5 downto 4);
		when "110" => stl1wopix <= st2tl1wopixl(3 downto 2);
		when others => stl1wopix <= st2tl1wopixl(1 downto 0);
	end case;
end process;

mk_stl2wopix:process (sd8addr,st2tl2wopixl)
begin
	case sd8addr(2 downto 0) is
		when "000" => stl2wopix <= st2tl2wopixl(15 downto 14);
		when "001" => stl2wopix <= st2tl2wopixl(13 downto 12);
		when "010" => stl2wopix <= st2tl2wopixl(11 downto 10);
		when "011" => stl2wopix <= st2tl2wopixl(9 downto 8);
		when "100" => stl2wopix <= st2tl2wopixl(7 downto 6);
		when "101" => stl2wopix <= st2tl2wopixl(5 downto 4);
		when "110" => stl2wopix <= st2tl2wopixl(3 downto 2);
		when others => stl2wopix <= st2tl2wopixl(1 downto 0);
	end case;
end process;

mk_snl1scn:process (stl1wopix,st20l1attr,st21l1attr,st22l1attr,st23l1attr)
begin
	case stl1wopix is
		when "00" =>
			snl1scnr <= st20l1attr(7 downto 5);
			snl1scng <= st20l1attr(4 downto 2);
			snl1scnb <= st20l1attr(1 downto 0);
		when "01" =>
			snl1scnr <= st21l1attr(7 downto 5);
			snl1scng <= st21l1attr(4 downto 2);
			snl1scnb <= st21l1attr(1 downto 0);
		when "10" =>
			snl1scnr <= st22l1attr(7 downto 5);
			snl1scng <= st22l1attr(4 downto 2);
			snl1scnb <= st22l1attr(1 downto 0);
		when others =>
			snl1scnr <= st23l1attr(7 downto 5);
			snl1scng <= st23l1attr(4 downto 2);
			snl1scnb <= st23l1attr(1 downto 0);
	end case;
end process;

mk_snl2scn:process (stl2wopix,st20l2attr,st21l2attr,st22l2attr,st23l2attr)
begin
	case stl2wopix is
		when "00" =>
			snl2scnr <= st20l2attr(7 downto 5);
			snl2scng <= st20l2attr(4 downto 2);
			snl2scnb <= st20l2attr(1 downto 0);
		when "01" =>
			snl2scnr <= st21l2attr(7 downto 5);
			snl2scng <= st21l2attr(4 downto 2);
			snl2scnb <= st21l2attr(1 downto 0);
		when "10" =>
			snl2scnr <= st22l2attr(7 downto 5);
			snl2scng <= st22l2attr(4 downto 2);
			snl2scnb <= st22l2attr(1 downto 0);
		when others =>
			snl2scnr <= st23l2attr(7 downto 5);
			snl2scng <= st23l2attr(4 downto 2);
			snl2scnb <= st23l2attr(1 downto 0);
	end case;
end process;

mk_paddr:process (pres,aclk,o12cnt,o14cnt,o16cnt,o18cnt,o20cnt,o22cnt,o24cnt,o26cnt,l1data,l2data,s397cnt,s525cnt,saddr,sMode)
begin
	if pres = '1' then
		spixl   <= x"00" after 1 ns;
		sdpixl  <= x"00" after 1 ns;
		stl1wopixl   <= x"0000" after 1 ns;
		sdtl1wopixl  <= x"0000" after 1 ns;
		stl2wopixl   <= x"0000" after 1 ns;
		sdtl2wopixl  <= x"0000" after 1 ns;
		satt    <= x"00" after 1 ns;
		sattr   <= x"00" after 1 ns;
		s0l1attr  <= x"00" after 1 ns;
		s1l1attr  <= x"00" after 1 ns;
		s2l1attr  <= x"00" after 1 ns;
		s3l1attr  <= x"00" after 1 ns;
		sd0l1attr  <= x"00" after 1 ns;
		sd1l1attr  <= x"00" after 1 ns;
		sd2l1attr  <= x"00" after 1 ns;
		sd3l1attr  <= x"00" after 1 ns;
		s0l2attr  <= x"00" after 1 ns;
		s1l2attr  <= x"00" after 1 ns;
		s2l2attr  <= x"00" after 1 ns;
		s3l2attr  <= x"00" after 1 ns;
		sd0l2attr  <= x"00" after 1 ns;
		sd1l2attr  <= x"00" after 1 ns;
		sd2l2attr  <= x"00" after 1 ns;
		sd3l2attr  <= x"00" after 1 ns;
		sIattr  <= x"0000" after 1 ns;
		sPattr  <= x"0000" after 1 ns;
		sdIattr <= x"0000" after 1 ns;
		sdPattr <= x"0000" after 1 ns;
		zxvaddr <= "0000000000000000" after 1 ns;
		l1addr  <= "0000000000000000" after 1 ns;
		l2addr  <= "0000000000000000" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if (s525cnt > "0001010010") and (s525cnt < "0111010011") then --- > 82 and < 467
			if s397cnt > "001101000" and s397cnt < "101101001" then --- > 104 and < 361
				if o12cnt = '1' then
					l1addr <= "00" & saddr(16 downto 9) & saddr(7 downto 2) after 1 ns; --- pixls
					l2addr <= "00" & saddr(16 downto 9) & saddr(7 downto 2) after 1 ns; --- pixls
				elsif o14cnt = '1' then
					l1addr <= ("00" & saddr(16 downto 9) & saddr(7 downto 2)) + x"1" after 1 ns; --- pixls
					l2addr <= ("00" & saddr(16 downto 9) & saddr(7 downto 2)) + x"1" after 1 ns; --- pixls
				elsif o16cnt = '1' then
					l1addr <= "0011" & saddr(16 downto 12) & saddr(7 downto 2) & "0" after 1 ns; --- new attrs
					l2addr <= "0011" & saddr(16 downto 12) & saddr(7 downto 2) & "0" after 1 ns; --- new attrs
				elsif o18cnt = '1' then
					l1addr <= ("0011" & saddr(16 downto 12) & saddr(7 downto 2) & "0") + x"1" after 1 ns; --- new attrs
					l2addr <= ("0011" & saddr(16 downto 12) & saddr(7 downto 2) & "0") + x"1" after 1 ns; --- new attrs
				elsif o20cnt = '1' then
					l1addr <= "0011" & saddr(16 downto 12) & saddr(7 downto 2) & "0" after 1 ns; --- new attrs
					l2addr <= "0011" & saddr(16 downto 12) & saddr(7 downto 2) & "0" after 1 ns; --- new attrs
				elsif o22cnt = '1' then
					l1addr <= ("0011" & saddr(16 downto 12) & saddr(7 downto 2) & "0") + x"1" after 1 ns; --- new attrs
					l2addr <= ("0011" & saddr(16 downto 12) & saddr(7 downto 2) & "0") + x"1" after 1 ns; --- new attrs
				end if;
				if o14cnt = '1' then
					stl1wopixl(7 downto 0) <= l1data after 1 ns;
					stl2wopixl(7 downto 0) <= l2data after 1 ns;
				end if;
				if o16cnt = '1' then
					stl1wopixl(15 downto 8) <= l1data after 1 ns;
					stl2wopixl(15 downto 8) <= l2data after 1 ns;
				end if;
				if o18cnt = '1' then
					s0l1attr(7 downto 0) <= l1data after 1 ns;
					s0l2attr(7 downto 0) <= l2data after 1 ns;
				end if;
				if o20cnt = '1' then
					s1l1attr(7 downto 0) <= l1data after 1 ns;
					s1l2attr(7 downto 0) <= l2data after 1 ns;
				end if;
				if o22cnt = '1' then
					s2l1attr(7 downto 0) <= l1data after 1 ns;
					s2l2attr(7 downto 0) <= l2data after 1 ns;
				end if;
				if o24cnt = '1' then
					s3l1attr(7 downto 0) <= l1data after 1 ns;
					s3l2attr(7 downto 0) <= l2data after 1 ns;
				end if;
				if o26cnt = '1' then
					sdtl1wopixl <= stl1wopixl after 1 ns;
					sdtl2wopixl <= stl2wopixl after 1 ns;
					sd0l1attr <= s0l1attr after 1 ns;
					sd1l1attr <= s1l1attr after 1 ns;
					sd2l1attr <= s2l1attr after 1 ns;
					sd3l1attr <= s3l1attr after 1 ns;
					sd0l2attr <= s0l2attr after 1 ns;
					sd1l2attr <= s1l2attr after 1 ns;
					sd2l2attr <= s2l2attr after 1 ns;
					sd3l2attr <= s3l2attr after 1 ns;
				end if;
	
				if sMode = '0' then	--- ZX attr
					if o14cnt = '1' then
						zxvaddr <= "010110" & saddr(16 downto 12) & saddr(7 downto 3) after 1 ns; --- ZX attrs
						spixl <= zxvdata after 1 ns;
					elsif o12cnt = '1' then
						zxvaddr <= "010" & saddr(16 downto 15) & saddr(11 downto 9) & saddr(14 downto 12) & saddr(7 downto 3) after 1 ns; --- pixls
					end if;
					if o16cnt = '1' then
						sattr <= zxvdata after 1 ns;
					end if;
					if o26cnt = '1' then
						sdpixl <= spixl after 1 ns;
						satt <= sattr after 1 ns;
					end if;
				else --- new attr
					if o12cnt = '1' then
						zxvaddr <= "010" & saddr(16 downto 15) & saddr(11 downto 9) & saddr(14 downto 12) & saddr(7 downto 3) after 1 ns; --- pixls
					elsif o14cnt = '1' or o16cnt = '1' then
						zxvaddr <= ("010" & saddr(16 downto 15) & saddr(14 downto 11) & saddr(7 downto 1)) + x"1800" after 1 ns; --- new attrs
					elsif o18cnt = '1' or o20cnt = '1' then
						zxvaddr <= ("010" & saddr(16 downto 15) & saddr(14 downto 11) & saddr(7 downto 1)) + x"1801" after 1 ns; --- new attrs
					end if;
					if o14cnt = '1' then
						spixl <= zxvdata after 1 ns;
					end if;
					if o16cnt = '1' then
						sIattr(7 downto 0) <= zxvdata after 1 ns;
					end if;
					if o18cnt = '1' then
						sPattr(7 downto 0) <= zxvdata after 1 ns;
					end if;
					if o20cnt = '1' then
						sIattr(15 downto 8) <= zxvdata after 1 ns;
					end if;
					if o22cnt = '1' then
						sPattr(15 downto 8) <= zxvdata after 1 ns;
					end if;
					if o26cnt = '1' then
						sdpixl <= spixl after 1 ns;
						sdIattr <= sIattr after 1 ns;
						sdPattr <= sPattr after 1 ns;
					end if;
				end if;
			end if;
		end if;
	end if;
end process;

mk_saddr:process (pres,aclk,t2cnt,s525cnt,s397cnt)
begin
	if pres = '1' then
		saddr <= "00000000000000000" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t2cnt = '1' then
			if s397cnt = "000000110" and s525cnt = "0000000000" then --- =6 and =0
				saddr <= "00000000000000000" after 1 ns;
			elsif (s525cnt > "0001010010") and (s525cnt < "0111010011") then --- > 82 and < 467
				if s397cnt > "001101000" and s397cnt < "101101001" then --- > 104 and < 361
					saddr <= saddr + "1" after 1 ns;
				end if;
			end if;
		end if;
	end if;
end process;

mk_blank:process (pres,aclk,t2cnt,s525cnt,s397cnt)
begin
	if pres = '1' then
		blank <= '1' after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t2cnt = '1' then
			if s525cnt < "1000000011" and s525cnt > "0000100010" then --- < 515 and > 34
				if s397cnt > "001001010" and s397cnt < "110001100" then --- > 74 and < 396
					blank <= '0' after 1 ns;
				else
					blank <= '1' after 1 ns;
				end if;
			else
				blank <= '1' after 1 ns;
			end if;
		end if;
	end if;
end process;

snl2scn <= snl2scnr(7) & snl2scnr(6) & snl2scnr(5) & snl2scng(4) & snl2scng(3) & snl2scng(2) & snl2scnb(1) & snl2scnb(0);
snl1scn <= snl1scnr(7) & snl1scnr(6) & snl1scnr(5) & snl1scng(4) & snl1scng(3) & snl1scng(2) & snl1scnb(1) & snl1scnb(0);

mk_svga:process (pres,aclk,t2cnt,s525cnt,s397cnt,svgag,svgab,svgar,sscng,sscnb,sscnr,snl2scng,snl2scnb,snl2scnr,snl2scn,sMode,sLayers)
begin
	if pres = '1' then
		sdvgar <= x"00" after 1 ns;
		sdvgag <= x"00" after 1 ns;
		sdvgab <= x"00" after 1 ns;
	elsif (aclk = '1' and aclk'event) then
		if t2cnt = '1' then
			if s525cnt > "0001010010" and s525cnt < "0111010011" then --- > 82 and < 467
				if s397cnt > "001110000" and s397cnt < "101110001" then --- > 112 and < 369
					if sLayers(1) = '1' then
						if snl2scn = x"00" then
							if sLayers(0) = '1'	then
								if snl1scn = x"00" then
									if sMode = '0' then
										sdvgar <= svgar(1) & svgar(0) & svgar(1) & svgar(0) & svgar(1) & svgar(0) & svgar(1) & svgar(0) after 1 ns;
										sdvgag <= svgag(1) & svgag(0) & svgag(1) & svgag(0) & svgag(1) & svgag(0) & svgag(1) & svgag(0) after 1 ns;
										sdvgab <= svgab(1) & svgab(0) & svgab(1) & svgab(0) & svgab(1) & svgab(0) & svgab(1) & svgab(0) after 1 ns;
									else --- sMode = '1'
										sdvgar <= sscnr(7) & sscnr(6) & sscnr(5) & sscnr(7) & sscnr(6) & sscnr(5) & "00" after 1 ns;
										sdvgag <= sscng(4) & sscng(3) & sscng(2) & sscng(4) & sscng(3) & sscng(2) & "00" after 1 ns;
										sdvgab <= sscnb(1) & sscnb(0) & sscnb(1) & sscnb(0) & sscnb(1) & sscnb(0) & "00" after 1 ns;
									end if;
								else
									sdvgar <= snl1scnr(7) & snl1scnr(6) & snl1scnr(5) & snl1scnr(7) & snl1scnr(6) & snl1scnr(5) & "00" after 1 ns;
									sdvgag <= snl1scng(4) & snl1scng(3) & snl1scng(2) & snl1scng(4) & snl1scng(3) & snl1scng(2) & "00" after 1 ns;
									sdvgab <= snl1scnb(1) & snl1scnb(0) & snl1scnb(1) & snl1scnb(0) & snl1scnb(1) & snl1scnb(0) & "00" after 1 ns;
								end if;
							else
								if sMode = '0' then
									sdvgar <= svgar(1) & svgar(0) & svgar(1) & svgar(0) & svgar(1) & svgar(0) & svgar(1) & svgar(0) after 1 ns;
									sdvgag <= svgag(1) & svgag(0) & svgag(1) & svgag(0) & svgag(1) & svgag(0) & svgag(1) & svgag(0) after 1 ns;
									sdvgab <= svgab(1) & svgab(0) & svgab(1) & svgab(0) & svgab(1) & svgab(0) & svgab(1) & svgab(0) after 1 ns;
								else --- sMode = '1'
									sdvgar <= sscnr(7) & sscnr(6) & sscnr(5) & sscnr(7) & sscnr(6) & sscnr(5) & "00" after 1 ns;
									sdvgag <= sscng(4) & sscng(3) & sscng(2) & sscng(4) & sscng(3) & sscng(2) & "00" after 1 ns;
									sdvgab <= sscnb(1) & sscnb(0) & sscnb(1) & sscnb(0) & sscnb(1) & sscnb(0) & "00" after 1 ns;
								end if;
							end if;
						else
							sdvgar <= snl2scnr(7) & snl2scnr(6) & snl2scnr(5) & snl2scnr(7) & snl2scnr(6) & snl2scnr(5) & "00" after 1 ns;
							sdvgag <= snl2scng(4) & snl2scng(3) & snl2scng(2) & snl2scng(4) & snl2scng(3) & snl2scng(2) & "00" after 1 ns;
							sdvgab <= snl2scnb(1) & snl2scnb(0) & snl2scnb(1) & snl2scnb(0) & snl2scnb(1) & snl2scnb(0) & "00" after 1 ns;
						end if;	
					else
						if sLayers(0) = '1'	then
							if snl1scn = x"00" then
								if sMode = '0' then
									sdvgar <= svgar(1) & svgar(0) & svgar(1) & svgar(0) & svgar(1) & svgar(0) & svgar(1) & svgar(0) after 1 ns;
									sdvgag <= svgag(1) & svgag(0) & svgag(1) & svgag(0) & svgag(1) & svgag(0) & svgag(1) & svgag(0) after 1 ns;
									sdvgab <= svgab(1) & svgab(0) & svgab(1) & svgab(0) & svgab(1) & svgab(0) & svgab(1) & svgab(0) after 1 ns;
								else --- sMode = '1'
									sdvgar <= sscnr(7) & sscnr(6) & sscnr(5) & sscnr(7) & sscnr(6) & sscnr(5) & "00" after 1 ns;
									sdvgag <= sscng(4) & sscng(3) & sscng(2) & sscng(4) & sscng(3) & sscng(2) & "00" after 1 ns;
									sdvgab <= sscnb(1) & sscnb(0) & sscnb(1) & sscnb(0) & sscnb(1) & sscnb(0) & "00" after 1 ns;
								end if;
							else
								sdvgar <= snl1scnr(7) & snl1scnr(6) & snl1scnr(5) & snl1scnr(7) & snl1scnr(6) & snl1scnr(5) & "00" after 1 ns;
								sdvgag <= snl1scng(4) & snl1scng(3) & snl1scng(2) & snl1scng(4) & snl1scng(3) & snl1scng(2) & "00" after 1 ns;
								sdvgab <= snl1scnb(1) & snl1scnb(0) & snl1scnb(1) & snl1scnb(0) & snl1scnb(1) & snl1scnb(0) & "00" after 1 ns;
							end if;
						else
							if sMode = '0' then
								sdvgar <= svgar(1) & svgar(0) & svgar(1) & svgar(0) & svgar(1) & svgar(0) & svgar(1) & svgar(0) after 1 ns;
								sdvgag <= svgag(1) & svgag(0) & svgag(1) & svgag(0) & svgag(1) & svgag(0) & svgag(1) & svgag(0) after 1 ns;
								sdvgab <= svgab(1) & svgab(0) & svgab(1) & svgab(0) & svgab(1) & svgab(0) & svgab(1) & svgab(0) after 1 ns;
							else --- sMode = '1'
								sdvgar <= sscnr(7) & sscnr(6) & sscnr(5) & sscnr(7) & sscnr(6) & sscnr(5) & "00" after 1 ns;
								sdvgag <= sscng(4) & sscng(3) & sscng(2) & sscng(4) & sscng(3) & sscng(2) & "00" after 1 ns;
								sdvgab <= sscnb(1) & sscnb(0) & sscnb(1) & sscnb(0) & sscnb(1) & sscnb(0) & "00" after 1 ns;
							end if;
						end if;
					end if;
				else
					sdvgag <= border(2) & border(2) & border(2) & border(2) & border(2) & border(2) & border(2) & border(2) after 1 ns;
					sdvgab <= border(1) & border(1) & border(1) & border(1) & border(1) & border(1) & border(1) & border(1) after 1 ns;
					sdvgar <= border(0) & border(0) & border(0) & border(0) & border(0) & border(0) & border(0) & border(0) after 1 ns;
				end if;
			else
				sdvgag <= border(2) & border(2) & border(2) & border(2) & border(2) & border(2) & border(2) & border(2) after 1 ns;
				sdvgab <= border(1) & border(1) & border(1) & border(1) & border(1) & border(1) & border(1) & border(1) after 1 ns;
				sdvgar <= border(0) & border(0) & border(0) & border(0) & border(0) & border(0) & border(0) & border(0) after 1 ns;
			end if;
		end if;
	end if;
end process;

end;
