;********************************************************
;*	     CP/M-80 V2.2 emulator v0.8			*
;* 			cpm.exe				*
;*	Copyright (C) 1989-2012 by K.Murakami		*
;*							*
;*  v0.1 '89/04/1-22 쐬		     hi	*
;*  v0.2 '89/05/03 bug fix 			V	*
;*  v0.3 '89/08/19 V30			V	*
;*	 '89/08/31 Ȑl𗐐		V	*
;*  v0.4 '89/12/19 fileT[`		V	*
;*  v0.5 '94/06/30 үމpꉻ			V	*
;*  v0.6 '94/10/28 v0.6 Ή			V	*
;*  v0.7 '96/09/08 V30 o@P		V	*
;*	 '97/12/07 Ή BDOS R[s for HitechC *
;*	 '04/07/16-21 .COM Ή BDOS No12 HL:=122(MP/M)	*
;*		   Ή BDOS BIOS R[\	*
;*		   BIOS Gg[ύX for MBASIC	*
;*  v0.8 '09/04/16 SP lύX			*
;********************************************************

	public	em_bdos,em_bios

	include	msdos.mac

FCB	struc
drv	db	0
fname	db	8 dup(' ')
fext	db	3 dup(' ')
	db	0
fno	dw      0
	db	0
FCB	ends

V$START		equ	0f1h
V$BDOS		equ	V$START+1
V$BIOS		equ	V$START+2

MAXBLK	equ	400h

jp80	macro	adr
	db	0c3h
	dw	adr
	endm

call80	macro	adr
	db	0cdh
	dw	adr
	endm

ret80	macro
	db	0c9h
	endm

calln	macro	vct
	db	0edh,0edh,vct
	endm

retem	macro
	db	0edh,0fdh
	endm

incsp	macro
	db	3e
	endm

nop80	macro
	db	0
	endm

_TEXT	segment	word public 'CODE'
_TEXT	ends


_DATA	segment	para public 'DATA'

	extw	_SP,_PC
	extb	_R

psp_add	label	word
	org	5ch
fcb_1	label	byte
	org	6ch
fcb_2	label	byte
	org	80h
dmabuf	db	128 dup(?)

cpmentry label	byte

	org	0fe00h
bdos_add	label	word
bdoscall:	db	3 dup(?)
		db	?

usr_no_sv	db	?
dmy_dpb		dw	?
dmy_dpb_sft	db	?
dmy_dpb_msk	dw	?
		dw	?

dmy_alloc	db	MAXBLK/8 dup(?)

	org	0ff00h
bios_add	label	word
coldboot:	db	3 dup(?)
wormboot:	db	3 dup(?)
    rept 15
	db	3 dup (?)
    endm
biosbase:	dd	17 dup(?)
bioscall:	dd	?

file_name	db	80 dup(?)
cpm_version	dw	?		; 2004.07 CP/M o[WC
a_drv		db	?		; '96.09 `hCu̒u

_DATA	ends

stack	segment	word stack 'STACK'
	dw	256 dup(?)
stack	ends

	extrn	_em180:far

_TEXT	segment	word public 'CODE'
	assume	cs:_TEXT,ds:_TEXT,es:_DATA,ss:stack

entry	proc
	cld
	mov	dx,_DATA
	mov	es,dx
	push	ds
	push	cs
	pop	ds

	msdos	F$GETDRV		; JghCu 0004h ɐݒ
	mov	cur_drv,al

	xor	ax,ax
	mov	di,ax
	mov	cx,8000h
   rep	stosw
	mov	si,offset psp_code
	mov	di,offset psp_add
	mov	cx,(psp_code_sz + 1) / 2
   rep	movsw
	mov	si,offset bdos_code
	mov	di,offset bdos_add
	mov	cx,(bdos_code_sz + 1) / 2
   rep	movsw
   	mov	si,offset bios_code
	mov	di,offset bios_add
	mov	cx,(bios_code_sz + 1) / 2
   rep	movsw
	pop	ds

	mov	si,COMLINE
        lodsb
	add	cl,al
	jz	usage
;			 vÕZbg

	mov	di,offset file_name
skpsp0:	lodsb
	cmp	al,' '
	loopz	skpsp0
	jz	usage
	stosb
	jcxz	noarg
cpycmd:	cmp	byte ptr [si],' '
	je      arg1
	movsb
	loop	cpycmd
noarg:	mov	ds,dx
     	jmp	setDTA
arg1:
	mov	bx,di
	mov	al,cl
   	mov	di,offset dmabuf
	stosb
   rep	movsb

	assume	ds:_DATA
	mov	ds,dx
	mov	si,offset dmabuf
	mov	di,offset fcb_1		; FCB1̃Zbg
skpsp1:	inc	si
	cmp	byte ptr [si],' '
	je	skpsp1
	msdos	F$PARSE,0
	mov	di,offset fcb_2		; FCB2̃Zbg
skpsp2:	inc	si
	cmp	byte ptr [si],' '
	je	skpsp2
        msdos	F$PARSE,0
	mov	di,bx

setDTA:	mov	dx,offset dmabuf
	msdos	F$SETDTA

	mov	cpm_version, 22h

	mov	bx,1			; '96.09
	msdos	F$IOCTL,A$$CHANGEABLE	;
	test	ax,ax			;
	jnz	Afix			; `hCu[ouȂ
	mov	a_drv,'C'-'A'+1		;     `hCu̒u
Afix:
	mov	word ptr [di],'C.'	; vÕ[h .cpm
	mov	word ptr [di+2],'MP'
	mov	byte ptr [di+4],0
	mov	dx,offset file_name
	msdos	F$OPEN,A$$READ
	jnc	soft_emu
;	mov	word ptr [di],'C.'	; vÕ[h .com
	mov	word ptr [di+2],'MO'
;	mov	byte ptr [di+4],0
	mov	dx,offset file_name
	msdos	F$OPEN,A$$READ
	jnc	soft_emu_mpm
;	mov	word ptr [di],'C.'	; vÕ[h .cpv
	mov	word ptr [di+2],'VP'
;	mov	byte ptr [di+4],0
	mov	dx,offset file_name
	msdos	F$OPEN,A$$READ
	jc	err_open
	mov	bx,ax

	mov	ax,100h			; '96.09 check V30 (AAD 0)
	db	0d5h,0			;  if V30 then ax = 0ah; zf = 0;
	jz	soft_emu		;  	  else ax = 00h; zf = 1;

	mov	dx,offset cpmentry
	mov	cx,offset bdoscall - offset cpmentry
	msdos	F$READ
	jc	err_read
	msdos	F$CLOSE

	assume	ds:_TEXT
	push	es
	push	ds
	push	cs
	pop	ds
	msdos	F$GETVCT,V$START
	mov	int_start_seg,es
	mov	int_start_off,bx
	msdos	F$GETVCT,V$BDOS
	mov	int_bdos_seg,es
	mov	int_bdos_off,bx
	msdos	F$GETVCT,V$BIOS
	mov	int_bios_seg,es
	mov	int_bios_off,bx
	mov	dx,offset em_bdos
	msdos	F$SETVCT,V$BDOS
	mov	dx,offset em_bios
	msdos	F$SETVCT,V$BIOS
	pop	ds
        pop	es
	mov	dx,offset cpmentry
	msdos	F$SETVCT,V$START
	assume	ds:_DATA

	mov	bp,offset bdoscall-2	; 2009.04 SP l ύX
        db	0fh,0ffh		; V30 8080G~[^Ăяo
	db	V$START

exit:	mov	cl,0
restor_vct:
	lds	dx,int_start_ptr
	mov	ax,ds
	or	ax,dx
	jz	quit
	msdos	F$SETVCT, V$START
	lds	dx,int_bdos_ptr
	msdos	F$SETVCT, V$BDOS
	lds	dx,int_bdos_ptr
	msdos	F$SETVCT, V$BIOS
quit:	xchg	ax,cx
	msdos	F$EXIT

soft_emu_mpm:
	mov	cpm_version, 122h
soft_emu:
	mov	bx,ax
	mov	dx,offset cpmentry
	mov	cx,offset bdoscall - offset cpmentry
	msdos	F$READ
	jc	err_read
	msdos	F$CLOSE

	msdos	F$GETIME	; 擾ĂqWX^̏lƂ
	mov	al,60
	mul	cl
	add	al,dh
	mov	_R,al

	mov	_SP,offset bdoscall-2	; 2009.04 SP l ύX
	mov     _PC,offset cpmentry	; 64180G~[^Ăяo
	mov     al,V$START
	call	_em180
	test	ax,ax
	jz	exit

err_illop:				; 2004.7 IyR[h\
	mov	bl, dh
	mov	bh, dl
	mov	dx,offset msg_err_illop
	push	cs
	pop	ds
	msdos	F$DSPSTR
;	mov	ax, si
;	call	hexout4
;	mov	dl, ' ';
;	msdos	F$CONOUT
	mov	ax, bx
	call	hexout4
	mov	dx, offset crlf
	jmp	err_exit
err_open:
        mov	dx,offset msg_err_open
	jmp	err_exit
err_read:
	mov	dx,offset msg_err_read
err_exit:
	mov	cl, 2
dsp_exit:
	push	cs
	pop	ds
	msdos	F$DSPSTR
	jmp	restor_vct

usage:	mov	dx,offset msg_titl
	mov	cl, 1
	jmp	dsp_exit

hexout4:		; 2004.7 16 io
	push	ax
	mov	al, ah
	call	hexout2
	pop	ax
hexout2:
	push	ax
	shr	al, 1
	shr	al, 1
	shr	al, 1
	shr	al, 1
	call	hexout1
	pop	ax
	and	al, 0fh
hexout1:
	add	al, 90h
	daa
	adc	al, 40h
	daa
	mov	dl, al
	msdos	F$CONOUT
	ret

;msg_err_open	db 'vO܂',0dh,0ah,'$'
;msg_err_read	db 'vO[hł܂',0dh,0ah,'$'
;msg_err_illop	db '`߂s܂',0dh,0ah,'$'
msg_err_open	db 'program not found',0dh,0ah,'$'
msg_err_read	db 'program can not loaded',0dh,0ah,'$'
msg_err_illop	db 'undefined op-code executed $'
msg_titl	db 'CPM.EXE -- CP/M program EXEcutor V0.8',0dh,0ah
		db 'Copyright (C) 1989-2012 by K.Murakami',0dh,0ah
                db '  Usage: CPM command arg1 arg2 ...',0dh,0ah,'$'
entry	endp

int_start_ptr	label	dword
int_start_off	dw	0
int_start_seg	dw	0
int_bdos_ptr	label	dword
int_bdos_off	dw	0
int_bdos_seg	dw	0
int_bios_ptr	label	dword
int_bios_off	dw	0
int_bios_seg	dw	0

;----------------------------------------
; em_bdos -- BDOS emulation
;	al : A
;	cx : BC
;	dx : DE
;	bx : HL

em_bdos	proc	far
	pushm	cx,dx,bp,si,di
	cmp	cl,36
	ja	supportless
	mov	ch,0
	mov	di,cx
	add	di,di
	jmp	bdostbl[di]
con_in:
con_out:
aux_in:
aux_out:
lst_out:
con_io:
str_out:
str_in:
rst_dsk:
sel_dsk:
;f_open:
;f_close:
;f_del:
;f_make:
;f_ren:
get_cd:
set_dma:
;get_fsiz:
set_rno:
do_msdos0:
	mov	ah,cl
do_msdos:
        msdos
ret_bdos:
	popm	di,si,bp,dx,cx
	iret

f_close:
f_del:
f_make:
f_ren:
get_fsiz:
f_open:	mov	ah,cl
do_swp:	mov	di,dx		; '96.09 `hCu̒u
	cmp	byte ptr [di],'A'-'A'+1
	jne	do_msdos
	mov	cl, a_drv
	test	cl,cl
	jz	do_msdos
	mov	[di],cl
	msdos
	mov	byte ptr [di],'A'-'A'+1
	jmp	ret_bdos

supportless:
get_iob:
set_iob:
f_atrb:
	mov	dx,offset msg_err_bdos
;	jmp	err_exit
	push	ds		;; '97.12.07 Ƃ肠s
	push	cs		;
	pop	ds		;
	msdos	F$DSPSTR	;
	mov	al, cl		;  2004.7 @\R[h\
	call	hexout2		;
	mov	dx, offset crlf	;
	msdos	F$DSPSTR	;
	pop	ds		;
	xor	bx,bx		; ʃR[h 0
	jmp	ret_bdos	;

con_st:	mov	ah,cl
	msdos
	and	al,1
	mov	bl,al
	xor	bh,bh
	jmp	ret_bdos

ver_no:	mov	bx,cpm_version	; 2004.7 .COM - MP/M for HI-TECH C
	mov	al,bl
        jmp	ret_bdos

f_s_rd:	mov	ah,cl
	msdos
	inc	al	;  0 1 2 3
	shr	al,1	;  0 1 1 0
	and	al,1
	jmp	ret_bdos

f_s_wr:	mov	ah,cl
	msdos
	inc	al	;  0 1 2
	shr	al,1	;  0 1 1
	jmp	ret_bdos

f_r_rd:	mov	ah,cl
	msdos
	mov	ch,al	;  0 1 2 3
	shr	al,1	;  0 1 3 0
	add	al,ch
	and	al,3
	jmp	ret_bdos

f_r_wr:	mov	ah,cl
	msdos
	inc	al	;  0 1 2
	and	al,2	;  0 2 2
	jmp	ret_bdos

usr_no:	cmp	dl,0ffh
	je	usrq
	mov	usr_no_sv,dl
usrq:	mov	al,usr_no_sv
	jmp	ret_bdos

f_serch0:
	mov	ah,cl
	mov	si,dx
	mov	di,offset file_name
	mov	dx,di
	mov	cx,12h
   rep	movsw
;	jmp	do_msdos
	jmp	do_swp

f_serch1:
	mov	dx,offset file_name
;	jmp	do_msdos0
	jmp	f_open

get_dpa:
	mov	dl,0
	msdos	F$DSKFREE
	mul	cx			; coCg
	mul	bx
	mov	cl,9			; if (coCg >= 0x1000000) {
	mov	bx,1			;   dx = coCg>>16;
	test	dh,dh			;   cl = 9;
	jnz	gd02			; } else {
	mov	dh,dl			;   dx = coCg>>8;
	mov	dl,ah			;   cl = 1;
	mov	cl,bl			; }
gd01:	shr	dx,1			; while ( dx >= MAXBLK) {
	inc	cx			;   dx >>= 1; cl++;
gd02:	cmp	dx,MAXBLK		; } ubNMAXBLKɂȂ悤
	jae	gd01			;   ubNTCY𒲐߂
	mov	dmy_dpb_sft,cl		;   2^clFubNTCY
	shl	bx,cl
	dec	bx
	mov	dmy_dpb_msk,bx
	mov	cx,dx
	shr	cx,1
	shr	cx,1
	shr	cx,1
	shr	cx,1
	mov	bx,MAXBLK/16
	sub	bx,cx
	xor	ax,ax
	mov	di,offset dmy_alloc
	rep stosw
	mov	cl,dl
	and	cl,0fh
	not	ax
	shl	ax,cl
	stosw
	mov	cx,bx
	dec	cx
	sbb	ax,ax
	rep stosw
	mov	bx,offset dmy_dpb
	jmp	ret_bdos

get_alloc:
	mov	bx,offset dmy_alloc
	jmp	ret_bdos

;msg_err_bdos	db 'T|[gĂȂacnrR[sȂ܂'
msg_err_bdos	db 'unsupported BDOS call occur. $'
crlf		db 0dh,0ah,'$'

bdostbl	dw	exit, con_in, con_out, aux_in, aux_out
	dw	lst_out, con_io, get_iob, set_iob, str_out
	dw	str_in, con_st, ver_no, rst_dsk, sel_dsk
	dw	f_open, f_close, f_serch0, f_serch1, f_del
	dw	f_s_rd, f_s_wr, f_make, f_ren, supportless
	dw	get_cd, set_dma, get_alloc, supportless, supportless
	dw	f_atrb, get_dpa, usr_no, f_r_rd, f_r_wr
	dw	get_fsiz, set_rno

em_bdos	endp

;----------------------------------------
; em_bios -- BIOS emulation
;	al : A
;	cx : BC
;	dx : DE
;	bx : HL
;	bp : SP

em_bios proc	far
	pushm	dx,di
	mov	di,word ptr ds:[bp]
	inc	bp
	inc	bp
	sub	di,offset biosbase + 3
	shr	di,1
	cmp	di,20h
	ja	ill_bios
	jmp	biostbl[di]
const:
	push	bx
	xor	bx,bx
	msdos	F$IOCTL,I$STAT
	pop	bx
ret_bios:
	popm	di,dx
	iret
conin:
	msdos	F$DCONIN
	jmp	ret_bios
conout:
	mov	dl,cl
	msdos	F$CONIO
	jmp	ret_bios
lstout:
	mov	dl,cl
	msdos	F$PRNOUT
	jmp	ret_bios
auxout:
	mov	dl,cl
	msdos	F$AUXOUT
	jmp	ret_bios
auxin:
	msdos	F$AUXIN
	jmp	ret_bios
ill_bios:
lstst:
seek0:
seldrv:
seltrk:
selsct:
setdma:
rdsct:
wrsct:
cnvsct:	mov	dx,offset msg_err_bios
	push	cs
	pop	ds
	msdos	F$DSPSTR	;
	mov	ax, di
	shr	ax, 1
	call	hexout4
	mov	dx,offset crlf
	jmp	err_exit

;msg_err_bios	db 'T|[gĂȂahnrR[sȂ܂'
msg_err_bios	db 'unsupported BIOS call occur. $'
;		db 0dh,0ah,'$'

biosfunc macro s
    irp	f,<s>
        dw	f
	db	0
    endm
	endm

biostbl label word
;	biosfunc <exit,  exit,  const, conin,conout>
;	biosfunc <lstout,auxout,auxin, seek0, seldrv>
;	biosfunc <seltrk,selsct,setdma,rdsct, wrsct>
;	biosfunc <lstst, cnvsct>
	dw	exit,  exit,  const, conin,conout
	dw	lstout,auxout,auxin, seek0,seldrv
	dw	seltrk,selsct,setdma,rdsct,wrsct
	dw	lstst, cnvsct

em_bios	endp

; _DATA@f[^

psp_code label	word
	jp80	wormboot
	db	0
cur_drv	db	0
	jp80	bdoscall
	db	5ch - ($ - psp_code) dup (0)
	FCB	<>
	FCB	<>

psp_code_sz equ	$ - psp_code

bdos_code label	word
	calln	V$BDOS
	ret80

	db	0
	dw	64
	db	4
	dw	(1 shl 4)-1
	dw	MAXBLK

bdos_code_sz	equ	$ - bdos_code

bios_code label	word
n$bios = 0
    rept 17
	jp80	<biosbase + n$bios>
	n$bios = n$bios + 4
    endm
	retem
	db	0,0
	retem
	db	0,0
    rept 15
	call80	bioscall
	db	0
    endm
	calln	V$BIOS
	ret80

bios_code_sz	equ	$ - bios_code

_TEXT	ends

	end	entry
