;********************************************************
;*      HD64180(Z80) emulator for CPM.EXE v0.7		*
;*			em180.asm			*
;*	Copyright (C) 1989-2012 by K.Murakami		*
;*							*
;*   v0.1 '89/04/01-20	쐬		     hi	*
;*   v0.3 '89/08/19 cpm v0.3 Ή		V	*
;*   v0.4 '89/08/31 cpm v0.4 Ή		V	*
;*   v0.5 '94/03    CP?R,LD?R,Vflag bug fix	V	*
;*   v0.6 '94/10/23 SET,RES bug fix		V	*
;*   v0.7 '96/09/08 SET,RES bug fix (flag)	V	*
;*		    RR,RL,RRC,RLC (HL) bug fix	V	*
;*		    speed up for 486		V	*
;*   	  '97/12/07 op (IXL,IY,IXL,IX) bug fix	V	*
;*	  '99/09    speed up for 486		V	*
;*	  '04/07/14 speed up for 486		V	*
;*   v0.8 '12/05/14 fix HF                              *
;********************************************************

ifdef ??version
	SMART
else
	.EN	UJ,SI
endif
	.lall

	public	_AF,_BC,_DE,_HL,_IX,_IY,_R
	public  _AF2,_BC2,_DE2,_HL2,_SP,_PC
	public	_em180

	extrn	em_bdos:far,em_bios:far

OFFSET_CB	equ	 40h
OFFSET_ED	equ	 60h
OFFSET_DD	equ	0a0h
OFFSET_FD	equ	0c0h
OFFSET_DD_CB	equ	0e0h

R$IO	equ	1
R$HALT	equ	2
R$ERR	equ	3

_DATA	segment	word public 'DATA'
_AF	label	word
_F	db	?
_A	db	?
_BC	label	word
_C	db	?
_B	db	?
_DE	label	word
_E	db	?
_D	db	?
_HL	label	word
_L	db	?
_H	db	?
_IX	label	word
_IXL	db      ?
_IXH	db	?
_IY	label	word
_IYL	db	?
_IYH	db	?
_AF2	dw	?
_BC2	dw	?
_DE2	dw	?
_HL2	dw	?
_SP	dw	?
_PC	dw	?
_I	db	?
_R	db	?
_IEF	db	?
bdoscode db	?
_DATA	ends

	irp	reg,<BC,C,B,DE,E,D,IX,IXL,IXH,IY,IYL,IYH>
reg	equ	_&reg
	endm
	irp	reg,<AF2,BC2,DE2,HL2,PC,I,R,IEF>
reg	equ	_&reg
	endm
ZSP	equ	bp
AF	equ	cx
A	equ	ch
F	equ	cl
HL	equ	bx
H	equ	bh
L	equ	bl

	.xlist

T$REG	equ	00001100b
T$BREG	equ	00000100b
T$WREG	equ	00001000b

SF	equ	10000000b
ZF	equ	01000000b
HF	equ	00010000b
PF	equ	00000100b
VF	equ	PF
NF	equ	00000010b
CF	equ	00000001b

opcode	equ	<org	base+100h*>

NEXT	macro
  if (base NE 0)
	mov	dl,0
  endif
;;	lodsb
;;	mov	dh,al
	mov	dh,[si]
	inc	si
	jmp	dx
	endm

; -------- ] --------

z_MOV	macro	dst,src
  ifidn <src>,<imm>
    if ((.type dst) and T$REG)		;; '96.09 speed up
	mov	dst,[si]		;;
	inc	si			;;
    else				;;
	lodsb
	mov	dst,al
    endif				;;
  else
  ifidn <src>,<HL>
    if ((.type dst) and T$REG)
	mov	dst,[HL]
    else
	mov	al,[HL]
	mov	dst,al
    endif
  else 
  if ((.type dst) and T$REG) or ((.type src) and T$REG)
	mov	dst,src
  else
	mov	al,src
	mov	dst,al
  endif
  endif
  endif
	NEXT
	endm

z_ST	macro	dst,src
    ifidn <dst>,<abs>
	lodsw
        mov	di,ax
    else
	mov	di,dst
    endif
    if ((.type src) and T$REG)
	mov	[di],src
    else 
    ifidn <src>,<imm>
	movsb
    else
	mov	al,src
	mov	[di],al
    endif
    endif
	NEXT
	endm

z_LD	macro	dst,src
    ifidn <src>,<abs>
	lodsw
	mov	di,ax
    else
	mov	di,src
    endif
    if ((.type dst) and T$REG)
	mov	dst,[di]
    else
	mov	al,[di]
        mov	dst,al
    endif
	NEXT
	endm

z_STX	macro	dst,src
	lodsb
        cbw
	mov	di,dst
	add	di,ax
    if ((.type src) and T$REG)
	mov	[di],src
    else 
    ifidn <src>,<imm>
	movsb
    else
	mov	al,src
	mov	[di],al
    endif
    endif
	NEXT
	endm

z_LDX	macro	dst,src
	lodsb
        cbw
	mov	di,src
	add	di,ax
    if ((.type dst) and T$REG)
	mov	dst,[di]
    else
	mov	al,[di]
        mov	dst,al
    endif
	NEXT
	endm

z_MOVW	macro	dst,src
  if ((.type src) and T$REG)
	mov	dst,src
  else
  ifidn <src>,<imm>
	lodsw
	mov	dst,ax
  else 
  if ((.type dst) and T$REG)
	mov	dst,src
  else
	mov	ax,src
	mov	dst,ax
  endif
  endif
  endif
	NEXT
	endm

z_STW	macro	dst,src
    ifidn <dst>,<abs>
	lodsw
	mov	di,ax
     else
	mov	di,dst
     endif
     ifidn <src>,<imm>
	movsw
     else 
     if ((.type src) and T$REG)
	mov	[di],src
     else
	mov	ax,src
	mov	[di],ax
     endif
     endif
	NEXT
	endm

z_LDW	macro	dst,src
    ifidn <src>,<abs>
	lodsw
	mov	di,ax
    else
	mov	di,src
    endif
    if ((.type dst) and T$REG)
	mov	dst,[di]
    else
	mov	ax,[di]
        mov	dst,ax
    endif
	NEXT
	endm

PUSH_rx	macro	r
	sub	bp, 2		;; '96.09 speed up
	mov	ds:[bp],r
	endm

POP_rx	macro	r
	mov	r,ds:[bp]
	add	bp, 2		;; '96.09 speed up
	endm

z_PUSH	macro	wr
  if ((.type wr) and T$REG)
	PUSH_rx	wr
  else
	mov	ax,wr
	PUSH_rx	ax
  endif
	NEXT
	endm

z_POP	macro	wr
  if ((.type wr) and T$REG)
	POP_rx	wr
  else
	POP_rx	ax
	mov	wr,ax
  endif
	NEXT
	endm

z_EXSP	macro	wr
  if ((.type wr) and T$REG)
	mov	ax,ds:[bp]	;; '99.09 xchg r
	mov	ds:[bp],wr	;;
	mov	wr,ax		;;
  else
	mov	di,ds:[bp]	;; '99.09 xchg r
	mov	ax,wr		;;
	mov	wr,di		;;
	mov	ds:[bp],ax	;;
  endif
	NEXT
	endm

; -------- Z --------

OP_EXE	macro	op,src,ff
  ifidn <src>,<imm>
    ifnb <ff>
	mov	ah,F
	sahf
    endif
	lodsb
	op	A,al
  else 
  ifidn <src>,<HL>
    ifnb <ff>
	mov	ah,F
	sahf
    endif
	op	A,[HL]
  else 
  if ((type src) eq 2)
	lodsb
	cbw
	mov	di,src
	add	di,ax
    ifnb <ff>
	mov	ah,F
	sahf
    endif
	op	A,[di]
  else
    ifnb <ff>
	mov	ah,F
	sahf
    endif
	op	A,src
  endif
  endif
  endif
	endm

OP1_EXE	macro	op,dst,ff
  ifidn <dst>,<HL>
    ifnb <ff>
	mov	ah,F
	sahf
    endif
 	op	byte ptr [HL]
  else 
  if ((type dst) eq 2)
	lodsb
	cbw
	mov	di,dst
	add	di,ax
    ifnb <ff>
	mov	ah,F
	sahf
    endif
	op	byte ptr [di]
  else
    ifnb <ff>
	mov	ah,F
	sahf
    endif
	op	dst
  endif
  endif
	endm

setF_add macro
	local	lv
	lahf
	mov	F,VF
	jo	lv
	mov	F,0
lv:	and	ah,not (PF or NF)
	or	F,ah
	endm

setF_sub macro
	local	lv
	lahf
	mov	F,VF or NF
	jo	lv
	mov	F,NF
lv:	and	ah,not (PF or NF)
	or	F,ah
	endm

z_ADD	macro	src
	OP_EXE	<add>,src
	setF_add
	NEXT
	endm

z_ADC	macro	src
	OP_EXE	<adc>,src,<c>
	setF_add
	NEXT
	endm

z_SUB	macro	src
	OP_EXE	<sub>,src
	setF_sub
	NEXT
	endm

z_SBC	macro	src
	OP_EXE	<sbb>,src,<c>
	setF_sub
	NEXT
	endm

z_AND	macro	src
	OP_EXE	<and>,src
	lahf
	and	ah,not(HF or NF)
	or	ah, HF		;; '12.05 fix HF
	mov	F,ah
	NEXT
	endm

z_XOR	macro	src
	OP_EXE	<xor>,src
	lahf
	and	ah,not(HF or NF) ;; '12.05 fix HF,NF
	mov	F,ah
	NEXT
	endm

z_OR	macro	src
	OP_EXE	<or>,src
	lahf
	and	ah,not(HF or NF) ;; '12.05 fix HF,NF
	mov	F,ah
	NEXT
	endm

z_CP	macro	src
	OP_EXE	<cmp>,src
	setF_sub
	NEXT
	endm

z_INC	macro	dst
	OP1_EXE	inc,dst,<c>
	setF_add
	NEXT
	endm

z_DEC	macro	dst
	OP1_EXE	dec,dst,<c>
	setF_sub
	NEXT
	endm

z_TST	macro	src
	OP_EXE	test,src
	lahf
	and	ah,not(HF or NF) ;; '12.05 fix NF
	or	ah, HF           ;; '12.05 fix HF
	mov	F,ah
	NEXT
	endm

z_ADDW	macro	dst,src
	and	F,not( NF or CF)
    if ((.type src) and T$REG) or ((.type dst) and T$REG)
	add	dst,src
    else
	mov	ax,src
	add     dst,ax
    endif
	adc	F,0
	NEXT
	endm

z_ADCW	macro	src
	mov	ah,F
	sahf
  if ((.type src) and T$REG)
	adc	HL,src
  else
	mov	ax,src
	adc	HL,ax
  endif
	setF_add
	NEXT
	endm

z_SBCW	macro	src
	mov	ah,F
	sahf
  if ((.type src) and T$REG)
	sbb	HL,src
  else
	mov	ax,src
	sbb	HL,ax
  endif
	setF_sub
	NEXT
	endm

z_INCW	macro	dst
	inc	dst
	NEXT
	endm

z_DECW	macro	dst
	dec	dst
	NEXT
	endm

z_MLT	macro	dst
	mov	ax,dst
	mul	ah
	mov	dst,ax
	NEXT
	endm

; -------- Vtgn --------

ROT_EXE	macro	op,dst
  ifidn <dst>,<HL>
	mov	al,[HL]
	op	al,1
	mov	[HL],al			;; '96.09 bug-fix di->HL
	inc	al
	dec	al
  else 
  if ((.type dst) and T$WREG)
	mov	al,[dst]
	op	al,1
	mov	[dst],al
	inc	al
	dec	al
  else 
  if ((.type dst) and T$BREG)
	op	dst,1
	inc	dst
	dec	dst
  else
	mov	al,dst
	op	al,1
	mov	dst,al
	inc	al
	dec	al
  endif
  endif
  endif
	endm

SFT_EXE	macro	op,dst
  ifidn <dst>,<HL>
	op	byte ptr [HL],1
  else 
  if ((.type dst) and T$WREG)
	op	byte ptr [dst],1
  else
	op	dst,1
  endif
  endif
	endm

z_ROTA	macro	op
	mov	ah,F
	and	F,not(HF or NF or CF)	; 2012/05 fix FLAGS
	sahf
	op	A,1
	adc	F,0			; 
	NEXT
	endm

z_RL	macro	dst
	mov	ah,F
	sahf
	ROT_EXE	rcl,dst
	lahf
	and	ah, not(HF or NF)
	mov	F,ah
	NEXT
	endm

z_RR	macro	dst
	mov	ah,F
	sahf
	ROT_EXE	rcr,dst
	lahf
	and	ah, not(HF or NF)
	mov	F,ah
	NEXT
	endm

z_RLC	macro	dst
	ROT_EXE	rol,dst
	lahf
	and	ah, not(HF or NF)
	mov	F,ah
	NEXT
	endm

z_RRC	macro	dst
	ROT_EXE	ror,dst
	lahf
	and	ah, not(HF or NF)
	mov	F,ah
	NEXT
	endm

z_SLA	macro	dst
	SFT_EXE	sal,dst
	lahf
	and	ah, not(HF or NF)
	mov	F,ah
	NEXT
	endm

z_SRA	macro	dst
	SFT_EXE	sar,dst
	lahf
	and	ah, not(HF or NF)
	mov	F,ah
	NEXT
	endm

z_SRL	macro	dst
	SFT_EXE	shr,dst
	lahf
	and	ah, not(HF or NF)
	mov	F,ah
	NEXT
	endm

z_SL1	macro	dst
	stc
	ROT_EXE	rcl,dst
	lahf
	and	ah, not(HF or NF)
	mov	F,ah
	NEXT
	endm

; -------- 򖽗 --------

cc_NZ	equ	<nz, ZF>
cc_Z	equ	<z, ZF>
cc_NC	equ	<nz, CF>
cc_C    equ	<z, CF>
cc_PO	equ	<nz, PF>
cc_PE	equ	<z, PF>
cc_PL	equ	<nz, SF>
cc_MI	equ	<z, SF>

z_JR	macro	cnd, flg
	local	jrend
	lodsb
    ifnb <cnd>
;;	mov	ah,F
;;	sahf
	test	F,flg
	j&cnd	jrend
    endif
	cbw
	add	si,ax
jrend:	NEXT
	endm

z_JP	macro	cnd,flg
	local	jpend
    ifnb <cnd>
;;	mov	ah,F
;;	sahf
	test	F,flg
	j&cnd	jpend
    endif
	mov	si,[si]
	NEXT
    ifnb <cnd>
jpend:	add	si,2
	NEXT
    endif
	endm

z_JPX	macro	wr
	mov	si,wr
	NEXT
	endm

z_CALL	macro	cnd, flg
        local	clend
    ifnb <cnd>
;;	mov	ah,F
;;	sahf
	test	F,flg
	j&cnd	clend
    endif
	lodsw
	PUSH_rx	si
	mov	si,ax
	NEXT
    ifnb <cnd>
clend:	add	si,2
	NEXT
    endif
	endm

z_RET	macro	cnd, flg
	local	rtend
    ifnb <cnd>
;;	mov	ah,F
;;	sahf
	test	F,flg
	j&cnd	rtend
    endif
	POP_rx	si
rtend:	NEXT
	endm

z_RST	macro	adr
	PUSH_rx	si
	mov	si,adr
	NEXT
	endm

; -------- rbg얽 --------

z_BIT	macro	src,bit
  ifidn <src>,<HL>
	mov	di,HL
	test	byte ptr [di],1 SHL bit
  else 
  ifidn <src>,<di>
	test	byte ptr [di],1 SHL bit
  else
	test	src,1 SHL bit
  endif
  endif
	lahf
	and	F, SF or PF or CF ;; '12.05 fix flags
	and	ah, ZF            ;;
	or	F,ah
	or	F, HF		  ;;
	NEXT
	endm

z_SET	macro	dst,bit
  ifidn <dst>,<HL>
	mov	di,HL
	or	byte ptr [di],1 SHL bit
  else 
  ifidn <dst>,<di>				;; '94.10 bug-fix
	or	byte ptr [di],1 SHL bit
  else
	or	dst,1 SHL bit
  endif
  endif
;;	lahf					;; '96.09 bug-fix
;;	and	F,CF
;;	or	F,ah
	NEXT
	endm

z_RES	macro	dst,bit
  ifidn <dst>,<HL>
	mov	di,HL
	and	byte ptr [di],not(1 SHL bit)
  else 
  ifidn <dst>,<di>				;; '94.10 bug-fix
	and	byte ptr [di],not(1 SHL bit)
  else
	and	dst,not(1 SHL bit)
  endif
  endif
;;	lahf					;; '95.09 bug-fix
;;	and	F,CF
;;	or	F,ah
	NEXT
	endm

; -------- ̑ --------

z_MOVM	macro	dir,rp		; '94.3 bug-fix
	local	mvm1
  ifidn <dir>,<DOWN>
	std
  endif
	mov	di,DE
	xchg	si,HL
	and	F,not(HF or PF or NF)
  ifidn <rp>,<REP>
	mov	ax,cx		;; 2004.07 xchg r
	mov	cx,BC		;;
	movsb
	dec	cx
    rep movsb
	mov	BC,cx		;; 2004.07 xchg r
	mov	cx,ax		;;
  else
	movsb
	dec	BC
	jz	mvm1
	or	F,PF
  endif
mvm1:	xchg	HL,si
	mov	DE,di
  ifidn <dir>,<DOWN>
	cld
  endif
	NEXT
	endm

z_CPM	macro	dir,rp			; '94.3 bug-fix
	local	cpm1,cpm_z
  ifidn <dir>,<DOWN>
	std
  endif
	mov	di,HL
	mov	al,A
  ifidn <rp>,<REP>
	mov	bx,cx		;; 2004.09 xchg r
	mov	cx,BC		;;
	dec	cx
	scasb
	je	cpm_z
  repnz scasb
cpm_z:	lahf
	and	ah,not(PF or CF)
	jcxz	cpm1
	or	ah,PF
cpm1:	mov	BC,cx		;; 2004.09 xchg r
	mov	cx,bx		;;
	and	F,CF
	or	F,ah
  else
	scasb
	lahf
	and	ah,not(PF or CF)
	dec	BC
	jz	cpm1
	or	ah,PF
cpm1:	and	F,CF
	or	F,ah
  endif
	mov	HL,di
  ifidn <dir>,<DOWN>
	cld
  endif
	NEXT
	endm

z_IN	macro	reg,io
	mov	dl,prebyte
	mov	ax,R$IO
	jmp	ret_em
	endm

z_OUT	macro	reg,io
	mov	dl,prebyte
	mov	ax,R$IO
	jmp	ret_em
	endm

z_INM	macro	io,dir,rep
	mov	dl,prebyte
	mov	ax,R$IO
	jmp	ret_em
	endm

z_OUTM	macro	io,dir,rep
	mov	dl,prebyte
	mov	ax,R$IO
	jmp	ret_em
	endm

z_ILLOP	macro	dmy1,dmy2
	mov	dl,prebyte
	mov	ax,R$ERR
	jmp	ret_em
	endm

	.list

em_TEXT	segment	para public 'CODE'
	assume	cs:em_TEXT,ds:_DATA

;======== PnoR[h (xx) ========
base	=	0

noop:	NEXT

_em180	label	far
        and	al,al
	jz	nobdos
	inc	al
	mov     bdoscode,al
nobdos:	mov	si,_PC
	mov	bp,_SP
	mov	AF,_AF
	mov	bx,_HL
	mov	dl,0
	jmp	noop

	opcode	01h
	z_MOVW	BC,<imm>	; LD BC,imm

	opcode	02h
	z_ST	BC,A		; LD (BC),A

	opcode	03h
	z_INCW	BC

	opcode	04h
	z_INC	B

	opcode	05h
	z_DEC	B

	opcode	06h
	z_MOV	B,<imm>		; LD B,imm

	opcode	07h
	z_ROTA	rol		; RLCA

	opcode	08h
	mov	ax,AF2		; EX AF,AF'	;; '99.09 xchg r
	mov	AF2,AF
	mov	AF,ax
	NEXT

	opcode	09h
	z_ADDW	HL,BC

	opcode	0ah
        z_LD	A,BC		; LD A,(BC)

	opcode	0bh
	z_DECW	BC

	opcode	0ch
	z_INC	C

	opcode	0dh
	z_DEC	C

	opcode	0eh
	z_MOV	C,<imm>

	opcode	0fh
	z_ROTA	ror		; RRCA

	opcode	10h
	lodsb			; DJNZ rel
	dec	B
	jz	djend
	cbw
	add	si,ax
djend:	NEXT

	opcode	11h
	z_MOVW	DE,<imm>	; LD DE,imm

	opcode	12h
	z_ST	DE,A		; LD (DE),A

	opcode	13h
	z_INCW	DE

	opcode	14h
	z_INC	D

	opcode	15h
	z_DEC	D

	opcode	16h
	z_MOV	D,<imm>		; LD d,imm

	opcode	17h
	z_ROTA	rcl	; RLA

	opcode	18h
	z_JR

	opcode	19h
	z_ADDW	HL,DE

	opcode	1ah
	z_LD	A,DE		; LD A,(DE)

	opcode	1bh
	z_DECW	DE

	opcode	1ch
        z_INC	E

	opcode	1dh
	z_DEC	E

	opcode	1eh
	z_MOV	E,<imm>		; LD E,imm

	opcode	1fh
	z_ROTA	rcr	; RRA

	opcode	20h
%	z_JR	cc_NZ		; JR NZ,rel

	opcode	21h
	z_MOVW	HL,<imm>	; LD HL,imm

	opcode	22h
	z_STW	<abs>,HL	; LD (abs),HL

	opcode	23h
	z_INCW	HL

	opcode	24h
	z_INC	H

	opcode	25h
	z_DEC	H

	opcode	26h
	z_MOV	H,<imm>		; LD H,imm

	opcode	27h
	mov	al,A		; DAA
	mov	ah,F
	test	ah,NF
	jz	da1
	sahf
	das
	jmp	da2
da1:	sahf
	daa
da2:	lahf
	mov	F,ah
	mov	A,al
        NEXT

	opcode	28h
%	z_JR	cc_Z		; JR Z,rel

	opcode	29h
	z_ADDW	HL,HL

	opcode	2ah
	z_LDW	HL,<abs>	; LD HL,(abs)

	opcode	2bh
	z_DECW	HL

	opcode	2ch
	z_INC	L

	opcode	2dh
	z_DEC	L

	opcode	2eh
	z_MOV	L,<imm>		; LD L,imm

	opcode	2fh
	not	A		; CPL
	or	F,HF or NF
	NEXT

	opcode	30h
%	z_JR	cc_NC		; JR NC,rel

	opcode	31h
	z_MOVW	ZSP,<imm>	; LD SP,imm

	opcode	32h
	z_ST	<abs>,A		; LD (abs),A

	opcode	33h
	z_INCW	ZSP		; INC SP

	opcode	34h
	z_INC	<HL>		; INC (HL)

	opcode	35h
	z_DEC	<HL>		; DEC (HL)

	opcode	36h
	z_ST	HL,<imm>	; LD (HL),imm

	opcode	37h
	or	F,CF		; SCF
	and	F,not(NF or HF)
	NEXT

	opcode	38h
%	z_JR	cc_C		; JR C,rel

	opcode	39h
	z_ADDW	HL,ZSP		; ADD HL,SP

	opcode	3ah
	z_LD	A,<abs>		; LD A,(abs)

	opcode	3bh
	z_DECW	ZSP		; DEC SP

	opcode	3ch
	z_INC	A

	opcode	3dh
	z_DEC	A

	opcode	3eh
	z_MOV	A,<imm>		; LD A,imm

	opcode	3fh
	xor	F,CF		; CCF
	and	F,not(HF or NF)
	NEXT

LD_to	macro	dst,op
	v$op = op
	irp	rg,<B,C,D,E,H,L,<HL>,A>
	    opcode   v$op
	    z_MOV    dst,rg	; LD dst,r
	    v$op = v$op + 1
	endm
  	endm

	LD_to	B,40h
	LD_to	C,48h
	LD_to	D,50h
	LD_to	E,58h
	LD_to	H,60h
	LD_to	L,68h

	v$op = 70h
	irp	rg,<B,C,D,E,H,L>
	    opcode   v$op
	    z_ST     HL,rg	; LD (HL),r
	    v$op = v$op + 1
	endm

	opcode	76h
exit:	mov	ax,R$HALT	; HALT
ret_em:
	mov	_PC,si
	mov	_SP,bp
	mov	_AF,AF
	mov	_HL,bx
	retf

	opcode	77h
	z_ST	HL,A		; LD (HL),A

	LD_to	A,78h

map	macro	op
	irp	rg,<B,C,D,E,H,L,<HL>,A>
	    opcode   v$op
	    op    rg
	    v$op = v$op + 1;
	endm
	endm

	v$op = 80h
	map z_ADD
	map z_ADC
	map z_SUB
	map z_SBC
	map z_AND
	map z_XOR
	map z_OR
	map z_CP

	opcode	0c0h
%	z_RET	cc_NZ

	opcode	0c1h
	z_POP	BC

	opcode	0c2h
%	z_JP	cc_NZ

	opcode	0c3h
	z_JP

	opcode	0c4h
%	z_CALL	cc_NZ

	opcode	0c5h
	z_PUSH	BC

	opcode	0c6h
	z_ADD	<imm>

	opcode	0c7h
	z_RST	00h

	opcode  0c8h
%	z_RET	cc_Z

	opcode	0c9h
	z_RET

	opcode	0cah
%	z_JP	cc_Z

	opcode	0cbh		; voCg : CB
	mov	dl,OFFSET_CB
	NEXT

	opcode	0cch
%	z_CALL	cc_Z

	opcode	0cdh
	z_CALL

	opcode	0ceh
	z_ADC	<imm>

	opcode	0cfh
	z_RST	08H

	opcode	0d0h
%	z_RET	cc_NC

	opcode	0d1h
	z_POP	DE

	opcode	0d2h
%	z_JP	cc_NC

	opcode	0d3h
	inc	si		; OUT (io),A
	mov	ax, R$IO
	jmp	ret_em

	opcode	0d4h
%	z_CALL	cc_NC

	opcode	0d5h
	z_PUSH	DE

	opcode	0d6h
	z_SUB	<imm>

	opcode	0d7h
	z_RST	10h

	opcode  0d8h
%	z_RET	cc_C

	opcode	0d9h
	mov	ax,BC		; EXX	;; '99.09 xchg r
	mov	di,BC2
	mov	BC2,ax
	mov	BC,di
	mov	ax,DE
	mov	di,DE2
	mov	DE2,ax
	mov	DE,di
	mov	ax,HL2
	mov	HL2,bx
	mov	bx,ax
	NEXT

	opcode	0dah
%	z_JP	cc_C

	opcode	0dbh
	inc	si		; IN (io),A
	mov	ax, R$IO
	jmp	ret_em

	opcode	0dch
%	z_CALL	cc_C

	opcode	0ddh		; voCg : DD
	mov	dl,OFFSET_DD
	NEXT

	opcode	0deh
	z_SBC	<imm>

	opcode	0dfh
	z_RST	18H

	opcode	0e0h
%	z_RET	cc_PO

	opcode	0e1h
	z_POP	HL

	opcode	0e2h
%	z_JP	cc_PO

	opcode	0e3h
	z_EXSP	HL		; EX (SP),HL

	opcode	0e4h
%	z_CALL	cc_PO

	opcode	0e5h
	z_PUSH	HL

	opcode	0e6h
	z_AND	<imm>

	opcode	0e7h
	z_RST	20h

	opcode  0e8h
%	z_RET	cc_PE

	opcode	0e9h
	z_JPX	<HL>		; JP (HL)

	opcode	0eah
%	z_JP	cc_PE

	opcode	0ebh		; EX DE,HL
  	mov	ax,DE			;; '99.09 xchg r
	mov	DE,bx
	mov	bx,ax
	NEXT

	opcode	0ech
%	z_CALL	cc_PE

	opcode	0edh		; voCg ED
	mov	dl,OFFSET_ED
	NEXT
	opcode	0eeh
	z_XOR	<imm>

	opcode	0efh
	z_RST	28H

	opcode	0f0h
%	z_RET	cc_PL

	opcode	0f1h
	z_POP	AF

	opcode	0f2h
%	z_JP	cc_PL

	opcode	0f3h
	mov	IEF,dl		; DI
	NEXT

	opcode	0f4h
%	z_CALL	cc_PL

	opcode	0f5h
	z_PUSH	AF

	opcode	0f6h
	z_OR	<imm>

	opcode	0f7h
	z_RST	30h

	opcode  0f8h
%	z_RET	cc_MI

	opcode	0f9h
	z_MOVW	ZSP,HL		; LD SP,HL

	opcode	0fah
%	z_JP	cc_MI

	opcode	0fbh
	mov	IEF,0ffh	; EI
	NEXT

	opcode	0fch
%	z_CALL	cc_MI

	opcode	0fdh		; voCg : FD
	mov	dl,OFFSET_FD
	NEXT

	opcode	0feh
	z_CP	<imm>

	opcode	0ffh
	z_RST	38H

;======== QnoR[h (CB xx) ========
prebyte	=	0cbh
base	=	OFFSET_CB
v$op	=	00h
	irp op,<RLC,RRC,RL,RR,SLA,SRA,SL1,SRL>
            irp reg,<B,C,D,E,H,L,<HL>,A>
		opcode	v$op
		z_&op	reg
		v$op = v$op + 1
	    endm
	endm
	irp op,<BIT,RES,SET>
	  irp bit,<0,1,2,3,4,5,6,7>
            irp reg,<B,C,D,E,H,L,<HL>,A>
		opcode	v$op
		z_&op	reg,bit
		v$op = v$op + 1
	    endm
	  endm
	endm

;======== QnoR[h (ED xx) ========
prebyte	=	0edh
base	=	OFFSET_ED
v$op	=	00h

map_illop macro	op,rp
	  v$op = op
	  rept rp
		opcode	v$op
		z_ILLOP
		v$op = v$op + 1
	  endm
	endm

	irp reg,<B,C,D,E,H,L,<HL>,A>
		opcode	v$op
		z_IN	reg,<io>
		opcode	(v$op+1)
		z_OUT	<io>,reg
		opcode	(v$op+2)
		z_ILLOP
		opcode	(v$op+3)
		z_ILLOP
		opcode	(v$op+4)
		z_TST	reg
		opcode	(v$op+5)
		z_ILLOP
		opcode	(v$op+6)
		z_ILLOP
		opcode	(v$op+7)
		z_ILLOP
		v$op = v$op + 8
	endm
	irp arg,<<B,D,H,<>>,<C,E,L,A>>
	    v$op2 = v$op
	    irp reg,<arg>
		opcode	v$op2
		z_IN	reg,<BC>
		opcode	(v$op2+1)
		z_OUT	<BC>,reg
		v$op2 = v$op2 + 16
	    endm
	    v$op = v$op + 8
	endm
v$op	=	42h
	irp ww,<BC,DE,HL,ZSP>
		opcode	v$op
		z_SBCW	ww
		opcode	(v$op+1)
		z_STW	<abs>,ww
		opcode	(v$op+8)
		z_ADCW	ww
		opcode	(v$op+9)
		z_LDW	ww,<abs>
		opcode	(v$op+10)
		z_MLT	ww
		v$op = v$op + 16
	endm

	opcode	44h
	neg	A		; NEG A
	setF_sub
	NEXT
	opcode	45h		; RETN
	z_RET
	opcode	46h		; IM0
	jmp	noop
	opcode	47h		; LD I,A
	z_MOV	I,A

	opcode	4dh		; RETI
	z_RET
	opcode	4eh
	z_ILLOP
	opcode	4fh		; LD R,A
	z_MOV	R,A

	opcode	54h
	z_ILLOP
	opcode	55h
	z_ILLOP
	opcode	56h		; IM1
	jmp	noop
	opcode	57h
	z_MOV	A,I		; LD A,I

	opcode	5dh
	z_ILLOP
	opcode	5eh		; IM2
	jmp	noop
	opcode	5fh		; LD A,R
	mov	al,R
	mov	ah,19
	imul	ah
	inc	al
	mov	R,al
	mov	A,al
	NEXT

	opcode	64h		; TST imm
	z_TST	<imm>
	opcode	65h
	z_ILLOP
	opcode	66h
	z_ILLOP
	opcode	67h		; RRD
	mov	ah,A
	and	A,0f0h
	mov	al,[HL]			; 2004/07 œK
	mov	dh,al
	and	dh,0fh
	ror	ax,1
	ror	ax,1
	ror	ax,1
	ror	ax,1
	mov	[HL],al			; 2004/07 œK
	or	A,dh
	lahf
	and	ah, not(HF or NF or CF) ; 2012/05 fix FLAGS
	and	F,CF
	or	F,ah
	NEXT

	opcode	6dh
	z_ILLOP
	opcode	6eh
	z_ILLOP
	opcode	6fh		; RLD
	mov	al,[HL]			; 2004/07 œK
	mov	ah,0
	rol	ax,1
	rol	ax,1
	rol	ax,1
	rol	ax,1
	mov	dh,A
	and	dh,0fh
	and	A,0f0h
	or	al,dh
	or	A,ah
	mov	[HL],al			; 2004/07 œK
	lahf
	and	ah, not(HF or NF or CF) ; 2012/05 fix FLAGS
	and	F,CF
	or	F,ah
	NEXT

	opcode	74h		; TSTIO imm
	z_IN	<imm>,<C>
	opcode	75h
	z_ILLOP
	opcode	76h		; SLP
	mov	dl,prebyte
	jmp	exit
	opcode	77h
	z_ILLOP

	map_illop 7dh,6
	opcode	83h		; OTIM
	z_OUTM	<C>,<UP>
	map_illop 84h,7
	opcode	8bh		; OTDM
	z_OUTM	<C>,<DOWN>
	map_illop 8ch,7
	opcode	93h		; OTIMR
	z_OUTM	<C>,<UP>,<REP>
	map_illop 94h,7
	opcode	9bh		; OTDMR
	z_OUTM	<C>,<DOWN>,<REP>
	map_illop 9ch,4

	irp x,<<>,<REP>>
	  irp y,<<UP>,<DOWN>>
		opcode	v$op
		z_MOVM	y,x
		opcode	(v$op+1)
		z_CPM	y,x
		opcode	(v$op+2)
		z_INM	y,x
		opcode	(v$op+3)
		z_OUTM	<BC>,y,x
		map_illop (v$op+4),4
	  endm
	endm

	map_illop 0c0h,2dh
	opcode	0edh		; CALLN (v30)
	lodsb
	mov	ah,al
	mov	al,A
	mov	_AF,cx		;; '99.09 xchg r
	mov	cx,BC		;;
	mov	dx,DE
	pushf
	sub	ah,bdoscode
	jne     ed1
	call	em_bdos
	jmp	ed2
ed1:	call	em_bios
ed2:	mov	DE,dx
	mov	BC,cx		;; '99.09 xchg r
	mov	cx,_AF		;;
	mov	A,al
	NEXT
	map_illop 0eeh,16

	opcode	0fdh		; RETEM (v30)
	mov	dl,prebyte
	xor	ax,ax
	jmp	ret_em

	map_illop 0feh,2

;======== QnoR[h (DD xx) ========
prebyte =	0ddh
base	=	OFFSET_DD

z_ILLOP2 macro
	z_ILLOP
;;	mov	dl, 0   ;; xx s
;;	jmp	dx
	endm

map_illop2 macro	op,rp
	  v$op = op
	  rept rp
		opcode	v$op
		z_ILLOP2
		v$op = v$op + 1
	  endm
	endm


	map_illop2 00h,9
	opcode	09h
	z_ADDW	IX,BC
	map_illop2 0ah,15
	opcode	19h
	z_ADDW	IX,DE
	map_illop2 1ah,6

	opcode	20h
	z_ILLOP2
	opcode	21h
	z_MOVW	IX,<imm>
	opcode	22h
	z_STW	<abs>,IX
	opcode	23h
	z_INCW	IX
	opcode	24h		;; '12.05 add INC IXH
	z_INC	IXH		;;
	opcode	25h		;; '12.05 add DEC IXH
	z_DEC	IXH		;;
	opcode	26h		;; '12.05 add LD IXH,imm
	z_MOV	IXH,<imm>	;;
	map_illop2 27h,2	;;
	opcode	29h
	z_ADDW	IX,IX
	opcode	2ah
	z_LDW	IX,<abs>
	opcode	2bh
	z_DECW	IX
	opcode	2ch		;; '12.05 add INC IXL
	z_INC	IXL		;;
	opcode	2dh		;; '12.05 add DEC IXL
	z_DEC	IXL		;;
	opcode	2eh		;; '12.05 add LD IXL,imm
	z_MOV	IXL,<imm>	;;
	map_illop2 2fh,1	;;

	map_illop2 30h,4
	opcode	34h
	z_INC	<IX>
	opcode	35h
	z_DEC	<IX>
	opcode	36h
	z_STX	<IX>,<imm>
	map_illop2 37h,2
	opcode	39h
	z_ADDW	IX,ZSP
	map_illop2 3ah,6

v$op	=	40h
  ifdef undoc
	irp dreg,<B,C,D,E,H,L,IX,A>
	    irp sreg,<B,C,D,E,H,L,IX,A>
		local v$dst
		ifidn <dreg>,<H>
		    v$dst EQU <IXH>
		else ifidn <dreg>,<L>
		    v$dst EQU <IXL>
		else
		    v$dst EQU <dreg>
		endif

		opcode v$op
		ifidn <sreg>,<IX>
		    ifidn <dreg>,<IX>
			z_ILLOP2
		    else
			z_LDX	dreg,<IX>
		    endif
		else ifidn <dreg>,<IX>
			z_STX	<IX>,sreg
		else ifidn <sreg>,<H>
			z_MOV	v$dst,IXH
		else ifidn <sreg>,<L>
			z_MOV	v$dst,IXL
		else ifidn <dreg>,<H>
			z_MOV	IXH,sreg
		else ifidn <dreg>,<L>
			z_MOV	IXL,sreg
		else
			z_ILLOP2
		endif
		v$op = v$op + 1
	    endm
	endm
	irp op,<ADD,ADC,SUB,SBC,AND,XOR,OR,CP>
		map_illop2 v$op,4
		opcode	v$op
		z_&op	<IXH>
		opcode	(v$op+1)	; '97.12.07 ()ǉ
		z_&op	<IXL>
		opcode	(v$op+2)	; '97.12.07 ()ǉ
		z_&op	<IX>
		map_illop2 (v$op+3),1
	endm
  else
	irp reg,<B,C,D,E,H,L>
		map_illop2 v$op,6
		opcode	v$op
		z_LDX	reg,<IX>
        	map_illop2 (v$op+1),1
	endm
	irp reg,<B,C,D,E,H,L>
		opcode	v$op
		z_STX	<IX>,reg
		v$op = v$op + 1
	endm
	map_illop2 v$op,1
	opcode	v$op
	z_STX	<IX>,A
	map_illop2 (v$op+1),6
	opcode	v$op
	z_LDX	A,<IX>
       	map_illop2 (v$op+1),1

	irp op,<ADD,ADC,SUB,SBC,AND,XOR,OR,CP>
		map_illop2 v$op,6
		opcode	v$op
		z_&op	<IX>
		map_illop2 (v$op+1),1
	endm
  endif

	map_illop2 v$op,11
	opcode	v$op
	lodsb
	cbw
	mov	di,IX
	add	di,ax
	mov	dl,OFFSET_DD_CB
;	lodsb
;	mov	dh,al
	mov	dh,[si]
	inc	si
	jmp	dx

	map_illop2 (v$op+1),15h

	opcode	v$op
	z_POP	IX

	map_illop2 (v$op+1),1

	opcode	v$op
	z_EXSP	IX

	map_illop2 (v$op+1),1

	opcode	v$op
	z_PUSH	IX

	map_illop2 (v$op+1),3

	opcode	v$op
	z_JPX	IX

	map_illop2 (v$op+1),15

	opcode	v$op
	z_MOVW	ZSP,IX

	map_illop2 (v$op+1),6

;======== QnoR[h (FD xx) ========
prebyte =	0fdh
base	=	OFFSET_FD

	map_illop2 00h,9
	opcode	09h
	z_ADDW	IY,BC
	map_illop2 0ah,15
	opcode	19h
	z_ADDW	IY,DE
	map_illop2 1ah,6

	opcode	20h
	z_ILLOP2
	opcode	21h
	z_MOVW	IY,<imm>
	opcode	22h
	z_STW	<abs>,IY
	opcode	23h
	z_INCW	IY
	opcode	24h		;; '12.05 add INC IYH
	z_INC	IYH		;;
	opcode	25h		;; '12.05 add DEC IYH
	z_DEC	IYH		;;
	opcode	26h		;; '12.05 add LD IYH,imm
	z_MOV	IYH,<imm>	;;
	map_illop2 27h,2	;;
	opcode	29h
	z_ADDW	IY,IY
	opcode	2ah
	z_LDW	IY,<abs>
	opcode	2bh
	z_DECW	IY
	opcode	2ch		;; '12.05 add INC IYL
	z_INC	IYL		;;
	opcode	2dh		;; '12.05 add DEC IYL
	z_DEC	IYL		;;
	opcode	2eh		;; '12.05 add LD IYL,imm
	z_MOV	IYL,<imm>	;;
	map_illop2 2fh,1	;;

	map_illop2 30h,4
	opcode	34h
	z_INC	<IY>
	opcode	35h
	z_DEC	<IY>
	opcode	36h
	z_STX	<IY>,<imm>
	map_illop2 37h,2
	opcode	39h
	z_ADDW	IY,ZSP
	map_illop2 3ah,6

v$op	=	40h
  ifdef undoc
	irp dreg,<B,C,D,E,H,L,IY,A>
	    irp sreg,<B,C,D,E,H,L,IY,A>
		local	v$dst
		ifidn <dreg>,<H>
		    v$dst EQU <IYH>
		else ifidn <dreg>,<L>
		    v$dst EQU <IYL>
		else
		    v$dst EQU <dreg>
		endif

		opcode v$op
		ifidn <sreg>,<IY>
		    ifidn <dreg>,<IY>
			z_ILLOP2
		    else
			z_LDX	dreg,<IY>
		    endif
		else ifidn <dreg>,<IY>
			z_STX	<IY>,sreg
		else ifidn <sreg>,<H>
			z_MOV	v$dst,IYH
		else ifidn <sreg>,<L>
			z_MOV	v$dst,IYL
		else ifidn <dreg>,<H>
			z_MOV	IYH,sreg
		else ifidn <dreg>,<L>
			z_MOV	IYL,sreg
		else
			z_ILLOP2
		endif
		v$op = v$op + 1
	    endm
	endm
	irp op,<ADD,ADC,SUB,SBC,AND,XOR,OR,CP>
		map_illop2 v$op,4
		opcode	v$op
		z_&op	<IYH>
		opcode	(v$op+1)	; '97.12.07 ()ǉ
		z_&op	<IYL>
		opcode	(v$op+2)	; '97.12.07 ()ǉ
		z_&op	<IY>
		map_illop2 (v$op+3),1
	endm
  else
	irp reg,<B,C,D,E,H,L>
		map_illop2 v$op,6
		opcode	v$op
		z_LDX	reg,<IY>
        	map_illop2 (v$op+1),1
	endm
	irp reg,<B,C,D,E,H,L>
		opcode	v$op
		z_STX	<IY>,reg
		v$op = v$op + 1
	endm
	map_illop2 v$op,1
	opcode	v$op
	z_STX	<IY>,A
	map_illop2 (v$op+1),6
	opcode	v$op
	z_LDX	A,<IY>
       	map_illop2 (v$op+1),1

	irp op,<ADD,ADC,SUB,SBC,AND,XOR,OR,CP>
		map_illop2 v$op,6
		opcode	v$op
		z_&op	<IY>
		map_illop2 (v$op+1),1
	endm
  endif

	map_illop2 v$op,11
	opcode	v$op
	lodsb
	cbw
	mov	di,IY
	add	di,ax
	mov	dl,OFFSET_DD_CB
;	lodsb
;	mov	dh,al
	mov	dh,[si]
	inc	si
	jmp	dx

	map_illop2 (v$op+1),15h

	opcode	v$op
	z_POP	IY

	map_illop2 (v$op+1),1

	opcode	v$op
	z_EXSP	IY

	map_illop2 (v$op+1),1

	opcode	v$op
	z_PUSH	IY

	map_illop2 (v$op+1),3

	opcode	v$op
	z_JPX	IY

	map_illop2 (v$op+1),15

	opcode	v$op
	z_MOVW	ZSP,IY

	map_illop2 (v$op+1),6

;======== RnoR[h (DD/FD CB xx) ========
prebyte	=	0cbh
base	=	OFFSET_DD_CB
v$op	=	00h
	irp op,<RLC,RRC,RL,RR,SLA,SRA,SL1,SRL>
		map_illop v$op,6
		opcode v$op
		z_&op	<di>
		map_illop (v$op+1),1
        endm
	irp op,<BIT,RES,SET>
	  irp bit,<0,1,2,3,4,5,6,7>
		map_illop v$op,6
		opcode v$op
		z_&op	<di>,bit
		map_illop (v$op+1),1
	   endm
	 endm

em_TEXT	ends

	end
