RUN_F2_ExxtROM:                         ; CODE XREF: RAM:04A8j
RAM:04B7                 call    cls1?
RAM:04BA ;
RAM:04BA                 ld      hl, PPI2_RUS
RAM:04BD                 ld      de, PIC_RUS
RAM:04C0                 ld      (hl), ppi_0_|ppi_b7 ; XS1:32 - set bit to 0 (linked to IRQ0)
RAM:04C0                                         ;
RAM:04C2                 ld      a, (de)
RAM:04C3                 cpl
RAM:04C4                 and     1
RAM:04C6                 jp      z, errNoExtRom
RAM:04C9 ;
RAM:04C9                 ld      (hl), ppi_1_|ppi_b7
RAM:04CB                 ld      a, (de)
RAM:04CC                 and     1
RAM:04CE                 jp      nz, extRomFound ; xx0B PPI3RUS
RAM:04D1
RAM:04D1 errNoExtRom:                            ; CODE XREF: RAM:04C6j
RAM:04D1                 or      c
RAM:04D2                 jp      z, R_LOAD_TST
RAM:04D5 ;
RAM:04D5                 ld      hl, aNetVnesnegoPzu ; "Iao aiaoiaai ICO"
RAM:04D8                 jp      putAndHalt
RAM:04DB ; ---------------------------------------------------------------------------
RAM:04DB
RAM:04DB errRomInvalidCRC:                       ; CODE XREF: RAM:05A6j
RAM:04DB                 ld      hl, aNevernaqKs ; "Iaaa?iay EN"
RAM:04DE
RAM:04DE putAndHalt:                             ; CODE XREF: RAM:04D8j
RAM:04DE                 ld      de, ACZU
RAM:04E1                 call    BiosOUT
RAM:04E4
RAM:04E4 HALT:                                   ; CODE XREF: RAM:05E2j
RAM:04E4                                         ; RAM:05F2j
RAM:04E4                 halt
RAM:04E4 ; ---------------------------------------------------------------------------
RAM:04E5 

RAM:0578 ; ---------------------------------------------------------------------------
RAM:0578 ;DE - FB28 PIC_RUS
RAM:0578 ;HL - FB33 PPI2RUS
RAM:0578
RAM:0578
RAM:0578 extRomFound:                            ; CODE XREF: RAM:04CEj
RAM:0578                 ld      l, 0Bh          ; xx0B PPI3RUS
RAM:057A                 ld      (hl), 90h ; '?' ; All out?
RAM:057C ;
RAM:057C                 ld      l, 9            ; xx09 -  PPI3.B
RAM:057E                 ld      (hl), 4
RAM:0580                 ex      de, hl
RAM:0581                 dec     de              ; FB08 - PPI3.A
RAM:0582                 ld      a, (de)         ; 4
RAM:0583                 ld      l, a
RAM:0584                 call    nextRomAddr     ; DE - PPI3.A
RAM:0587                 ld      a, (de)         ; 5
RAM:0588                 ld      h, a            ; START addr
RAM:0589                 call    nextRomAddr     ; DE - PPI3.A
RAM:058C                 push    hl
RAM:058D                 ld      a, (de)         ; 6
RAM:058E                 ld      h, a            ; LOAD Page xx00
RAM:058F                 ld      l, 0
RAM:0591                 call    nextRomAddr     ; DE - PPI3.A
RAM:0594                 push    hl
RAM:0595                 ld      a, (de)         ; 7
RAM:0596                 ld      b, a            ; PAGE count
RAM:0597                 call    extRomeResetAddr ; DE - PPI3.A
RAM:059A ;
RAM:059A                 ld      c, 0            ; Init CRC
RAM:059C
RAM:059C CalcRomCRC:                             ; CODE XREF: RAM:05A2j
RAM:059C                 ld      a, (de)
RAM:059D                 add     a, c
RAM:059E                 ld      c, a
RAM:059F                 call    nextRomAddr     ; DE - PPI3.A
RAM:05A2                 jp      nz, CalcRomCRC
RAM:05A5                 inc     c
RAM:05A6                 jp      nz, errRomInvalidCRC
RAM:05A9                 call    extRomeResetAddr ; DE - PPI3.A
RAM:05AC
RAM:05AC copyRom2Ram:                            ; CODE XREF: RAM:05B2j
RAM:05AC                 ld      a, (de)
RAM:05AD                 ld      (hl), a
RAM:05AE                 inc     hl
RAM:05AF                 call    nextRomAddr     ; DE - PPI3.A
RAM:05B2                 jp      nz, copyRom2Ram
RAM:05B5 ;
RAM:05B5                 call    extRomeResetAddr ; DE - PPI3.A
RAM:05B8                 ld      hl,  ACZU+40h
RAM:05BB                 ex      (sp), hl
RAM:05BC                 ld      c, 56           ; print error count ...
RAM:05BE
RAM:05BE VerifyROM:                              ; CODE XREF: RAM:05EBj
RAM:05BE                 ld      a, (de)
RAM:05BF                 cp      (hl)
RAM:05C0                 jp      z, VerifyRomNextByte
RAM:05C3                 ex      de, hl
RAM:05C4                 ex      (sp), hl        ; addr
RAM:05C5                 call    PrintHEX_DE
RAM:05C8                 ld      (hl), ' '
RAM:05CA                 inc     hl
RAM:05CB                 ld      a, (de)         ; RAM
RAM:05CC                 call    PrintHEXa
RAM:05CF                 ld      (hl), ' '
RAM:05D1                 inc     hl
RAM:05D2                 ex      (sp), hl
RAM:05D3                 ld      a, (hl)         ; ROM
RAM:05D4                 ex      (sp), hl
RAM:05D5                 call    PrintHEXa
RAM:05D8
RAM:05D8 loc_5D8:                                ; CODE XREF: RAM:05DEj
RAM:05D8                 ld      (hl), ' '
RAM:05DA                 inc     hl
RAM:05DB                 ld      a, l
RAM:05DC                 and     0Fh
RAM:05DE                 jp      nz, loc_5D8
RAM:05E1                 dec     c
RAM:05E2                 jp      z, HALT
RAM:05E5                 ex      (sp), hl
RAM:05E6                 ex      de, hl
RAM:05E7
RAM:05E7 VerifyRomNextByte:                      ; CODE XREF: RAM:05C0j
RAM:05E7                 inc     hl
RAM:05E8                 call    nextRomAddr     ; DE - PPI3.A
RAM:05EB                 jp      nz, VerifyROM
RAM:05EE                 pop     hl
RAM:05EF ;
RAM:05EF                 ld      a, c            ; print error count ...
RAM:05F0                 cp      56
RAM:05F2                 jp      nz, HALT
RAM:05F5                 pop     hl
RAM:05F6                 jp      (hl)
RAM:05F6 ; ---------------------------------------------------------------------------
RAM:05F7 aNetVnesnegoPzu:.ascii 'Iao aiaoiaai ICO' ; DATA XREF: RAM:04D5o
RAM:0607                 db    0
RAM:0608 aNevernaqKs:    .ascii 'Iaaa?iay EN'    ; DATA XREF: RAM:errRomInvalidCRCo
RAM:0613                 db    0
RAM:0614
RAM:0614 ; =============== S U B R O U T I N E =======================================
RAM:0614
RAM:0614 ; DE - PPI3.A
RAM:0614
RAM:0614 extRomeResetAddr:                       ; CODE XREF: RAM:0597p
RAM:0614                                         ; RAM:05A9p ...
RAM:0614                 xor     a
RAM:0615                 inc     de              ; PPI3.B
RAM:0616                 ld      (de), a
RAM:0617                 inc     de              ; PPI3.C
RAM:0618                 ld      (de), a
RAM:0619                 dec     de
RAM:061A                 dec     de
RAM:061B                 ret
RAM:061B ; End of function extRomeResetAddr
RAM:061B
RAM:061C DE - PPI3.A
RAM:061C
RAM:061C
RAM:061C
RAM:061C ; =============== S U B R O U T I N E =======================================
RAM:061C
RAM:061C ; DE - PPI3.A
RAM:061C
RAM:061C nextRomAddr:                            ; CODE XREF: RAM:0584p
RAM:061C                                         ; RAM:0589p ...
RAM:061C                 inc     de
RAM:061D                 ld      a, (de)         ; PPI3.B
RAM:061E                 inc     a
RAM:061F                 ld      (de), a
RAM:0620                 dec     de
RAM:0621                 ret     nz
RAM:0622                 inc     de
RAM:0623                 inc     de              ; PPI3.C
RAM:0624                 ld      a, (de)
RAM:0625                 inc     a
RAM:0626                 ld      (de), a
RAM:0627                 dec     de
RAM:0628                 dec     de
RAM:0629                 cp      b
RAM:062A                 ret
RAM:062A ; End of function nextRomAddr
RAM:062A
RAM:062B
RAM:062B ; =============== S U B R O U T I N E =======================================
RAM:062B
RAM:062B
RAM:062B cls1?:                                  ; CODE XREF: RAM:RUN_F2_ExxtROMp
RAM:062B                 ld      hl, ACZU
RAM:062E                 ld      de, 3E8h
RAM:0631
RAM:0631 loc_631:                                ; CODE XREF: cls1?+Cj
RAM:0631                 ld      (hl), 0
RAM:0633                 inc     hl
RAM:0634                 dec     de
RAM:0635                 ld      a, e
RAM:0636                 or      d
RAM:0637                 jp      nz, loc_631
RAM:063A                 ret
RAM:063A ; End of function cls1?
RAM:063A
RAM:063B ; ---------------------------------------------------------------------------

