module SQRUM_PORTS(
	input wire [15:0] a,
	input wire iorq_n,
	input wire rd_n,
	input wire wr_n,
	input wire m1_n,
	input wire res_n,
	input wire tape_in,
	input wire clk,
	
	input wire SD_MISO,
	output wire SD_CS,
	output wire SD_SCK,
	output wire SD_MOSI,
	
	output wire iorq_out_n, // remove it later!
	output wire speaker,
	output wire rd_fe,
	output reg BDIR,
	output reg BC1,
	inout wire [7:0] dt
);

assign iorq_out_n = iorq_n;

///
///
///// DOS SELECT MODULE ---------------------------------------
reg DOS = 0;
wire fetch_opcode = rd_n | m1_n;// | mreq_n;
always @(negedge fetch_opcode or negedge res_n)
	if(!res_n)
		DOS <= 'b0;
	else
	begin
		if (port_7FFD[4] == 1'b1 && a[15:8] == 'h3D)
			DOS <= 1'b1;
		else
			if(a[14] | a[15]) DOS <= 1'b0;
	end
///// END DOS SELECT MODULE -----------------------------------


///
///
///// Z-CONTROLLER MODULE -------------------------------------
///// Port #77 - control
///// Port #57 - data in/out with auto clock
reg sd_cs_r = 1;
reg [7:0] port_57_w;
reg [7:0] port_57_r;
reg [3:0] zc_cnt = 8;
wire zc_iorqge = (iorq_n == 0 && m1_n && (a[7:0] == 8'h57 || a[7:0] == 8'h77)); //its O.K. as DOS use port #77 too

wire port_57_sel = iorq_n == 0 && a[7:0] == 8'h57 && m1_n && (DOS == 0 || (DOS==1 && a[15]==0));
wire port_57_rd = rd_n == 0 && port_57_sel;
wire port_57_wr = wr_n == 0 && port_57_sel;
wire port_77_wr = wr_n == 0 && iorq_n == 0 && m1_n && ((DOS == 0 && a[7:0] == 8'h77) || (DOS == 1 && a[7:0] == 8'h57 && a[15]==1));


always @(posedge port_77_wr or negedge res_n)
	if(!res_n)
		sd_cs_r <= 1;
	else
		sd_cs_r <= dt[1];

always @(negedge clk or negedge res_n)
	if(!res_n)
		zc_cnt <= 4'd8;
	else if(port_57_sel)
		zc_cnt <= 4'b1110;
	else if(zc_cnt != 4'd8)
		zc_cnt <= zc_cnt + 4'd1;

always @(posedge port_57_wr or negedge clk)
	if(port_57_wr)
		port_57_w <= dt;
	else if(!zc_cnt[3])
		port_57_w <= {port_57_w[6:0],1'b1};

always @(posedge clk)
	if(!zc_cnt[3])
		port_57_r <= {port_57_r[6:0],SD_MISO};

assign dt = port_57_rd ? port_57_r : 8'bzzzzzzzz;

assign SD_CS = sd_cs_r;
assign SD_MOSI = port_57_w[7];
assign SD_SCK = clk & ~zc_cnt[3];

///// END Z-CONTROLLER MODULE ---------------------------------


///
///
///// PORTS MODULE --------------------------------------------
assign speaker = port_FE[4];// ^ port_FE[3]; // ^ tape_in

reg short_port = 0; // SHORT PORT ADDRESS active 1
always @(posedge fetch_opcode or negedge res_n)
	if(!res_n)
		short_port <= 1'b0;
	else
		short_port <= (dt[7:4]==4'b1101 && dt[2:0] == 3'b011);

reg [4:3] port_FE = 0; // speaker & tapeout only
reg [5:4] port_7FFD = 0;
reg port_DFFD = 0; // bit 4 only

// write ports
wire port_wr = iorq_n | wr_n | ~m1_n;
always @(negedge res_n or negedge port_wr)
	if(!res_n)
	begin
		port_FE <= 2'd0;
		port_DFFD <= 1'b0;
		port_7FFD <= 2'd0;
	end
	else
	casex({a[15:0],DOS,short_port})
		/*#FE*/		'bXXXXXXXX_1XX11X10_0X: port_FE <= dt[4:3];
		// don't block #7FFD if DOS active for RAM DISK to work in 48K mode!
		/*#7FFD*/	'b01XXXXXX_XXXXXX0X_X0: if( ~port_7FFD[5] | port_DFFD | DOS) port_7FFD <= dt[5:4];
		/*#DFFD*/	'b11011111_XXXXXX0X_X0: port_DFFD <= dt[4];
		/*#FD*/		'b0XXXXXXX_11111101_X1: port_7FFD[4] <= dt[4];
	endcase


// read ports
always @(*)
begin
	BC1 = m1_n == 1 && iorq_n == 0 && a[15:13]==3'b111 && a[1:0]==2'b01;
	BDIR = m1_n == 1 && iorq_n == 0 && wr_n==0 && a[15]==1 && a[13]==1 && a[1:0]==2'b01;
end

// read port 7FFD;
//assign read_7ffd = iorq_n | rd_n | ~DOS | short_port | a[15] | ~a[14] | a[1];
//assign dt = !read_7ffd ? port_7FFD : 8'bzzzzzzzz;
//assign read_dffd = iorq_n | rd_n | ~DOS | short_port | ~(a[15:8] == 8'hDF) | a[1];
//assign dt = !read_dffd ? port_DFFD : 8'bzzzzzzzz;

// read port FE tape_in only block when TRDOS or ZC active
assign rd_fe = iorq_n | DOS | zc_iorqge | rd_n | a[0] | ~(a[1] & a[3] & a[4] & a[7]);
wire tap = !port_FE[4] ? tape_in : 1'bz; // block tape_in if bit4 of portFE is set
assign dt[6] = rd_fe ? 1'bz : tap; // read #FE
///// END PORTS MODULE ----------------------------------------


endmodule