// bxx2bmp.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <windows.h> 
#include <stdio.h> 

BYTE RedBuf[256] = {
	0x00,0x00,0x17,0x37,0x5b,0x83,0xb3,0xe7,0xb7,0xbf,0xcb,0xd3,0xdf,0xe7,0xf3,0xff,
	0x00,0x07,0x17,0x2f,0x4f,0x73,0x9f,0xd3,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0x67,0x7b,0x8f,0xa7,0xbb,0xd3,0xe7,0xff,0x7f,0x8f,0xa3,0xb3,0xc7,0xd7,0xeb,0xff,
	0x0b,0x1b,0x2f,0x4b,0x67,0x8b,0xb3,0xdf,0x33,0x43,0x53,0x6b,0x87,0xab,0xcf,0xff,
	0xc3,0xaf,0xbb,0xc7,0xd7,0xe3,0xef,0xff,0x4b,0x63,0x7b,0x97,0xaf,0xcb,0xe3,0xff,
	0x00,0x43,0x63,0x7f,0x9f,0xbb,0xdb,0xfb,0xa3,0xaf,0xbb,0xc7,0xd7,0xe3,0xef,0xff,
	0x00,0x17,0x33,0x4f,0x6b,0x8b,0xaf,0xd3,0x00,0x17,0x2f,0x4b,0x67,0x83,0xa3,0xc3,
	0x4f,0x5f,0x73,0x8b,0x9f,0xb7,0xcb,0xe7,0x8b,0x9b,0xab,0xbb,0xcb,0xdb,0xeb,0xff,
	0x37,0x3b,0x3b,0x3b,0x33,0x27,0x17,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x1b,0x37,0x4f,0x6b,0x87,0xa3,0xbf,0x00,0x1b,0x37,0x4f,0x6b,0x87,0xa3,0xbf,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x1b,0x37,0x4f,0x6b,0x87,0xa3,0xbf,0x00,0x1b,0x37,0x4f,0x6b,0x87,0xa3,0xbf,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x3f,0x57,0x73,0x8f,0xab,0xc7,0xe3,0xff,0x3f,0x57,0x73,0x8f,0xab,0xc7,0xe3,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x3f,0x57,0x73,0x8f,0xab,0xc7,0xe3,0xff,0x3f,0x57,0x73,0x8f,0xab,0xc7,0xe3,0xff
};

BYTE GreenBuf[256] = {
	0x00,0x00,0x2f,0x63,0x93,0xbf,0xe3,0xff,0x00,0x17,0x33,0x53,0x77,0x9b,0xc3,0xef,
	0x37,0x53,0x6f,0x8b,0xa7,0xc3,0xdf,0xff,0x4b,0x77,0x9f,0xbf,0xdb,0xeb,0xf7,0xff,
	0x2b,0x3b,0x4f,0x67,0x83,0x9f,0xbf,0xe7,0x00,0x13,0x2b,0x4b,0x6f,0x9b,0xcb,0xff,
	0x23,0x33,0x47,0x63,0x7f,0x9f,0xbf,0xe7,0x7f,0x8f,0xa3,0xb3,0xc7,0xd7,0xeb,0xff,
	0x00,0x17,0x33,0x53,0x7b,0xa3,0xcf,0xff,0x4b,0x63,0x7b,0x97,0xaf,0xcb,0xe3,0xff,
	0x00,0x43,0x63,0x7f,0x9f,0xbb,0xdb,0xfb,0x6f,0x7f,0x8f,0xa3,0xb7,0xc7,0xdb,0xef,
	0xab,0xb3,0xbb,0xc7,0xcf,0xdb,0xe7,0xf3,0xd3,0xd7,0xdf,0xe3,0xeb,0xef,0xf7,0xff,
	0x4f,0x5f,0x73,0x8b,0x9f,0xb7,0xcb,0xe7,0x83,0x93,0xa3,0xb3,0xc3,0xd7,0xe7,0xfb,
	0x57,0x6f,0x87,0x9f,0xb7,0xcf,0xe7,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x1b,0x37,0x4f,0x6b,0x87,0xa3,0xbf,0x00,0x1b,0x37,0x4f,0x6b,0x87,0xa3,0xbf,
	0x00,0x1b,0x37,0x4f,0x6b,0x87,0xa3,0xbf,0x00,0x1b,0x37,0x4f,0x6b,0x87,0xa3,0xbf,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x3f,0x57,0x73,0x8f,0xab,0xc7,0xe3,0xff,0x00,0x23,0x47,0x6b,0x8f,0xb3,0xdb,0xff,
	0x3f,0x57,0x73,0x8f,0xab,0xc7,0xe3,0xff,0x3f,0x57,0x73,0x8f,0xab,0xc7,0xe3,0xff
};

BYTE BlueBuf[256] = {
	0x00,0x9b,0xab,0xbb,0xcb,0xdb,0xeb,0xff,0x00,0x17,0x33,0x53,0x77,0x9b,0xc3,0xef,
	0x23,0x3b,0x53,0x73,0x8f,0xb3,0xd3,0xf7,0x00,0x1f,0x3f,0x63,0x83,0xa7,0xc7,0xeb,
	0x00,0x0b,0x23,0x3b,0x5b,0x7f,0xa7,0xd7,0x4b,0x5b,0x73,0x8b,0xa3,0xbf,0xdf,0xff,
	0x73,0x87,0x9b,0xaf,0xc3,0xd7,0xeb,0xff,0x23,0x1f,0x1f,0x1b,0x17,0x0f,0x07,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x47,0x5b,0x73,0x8b,0xa3,0xbf,0xdb,
	0x00,0x43,0x63,0x7f,0x9f,0xbb,0xdb,0xfb,0x57,0x63,0x6f,0x7b,0x8b,0x9b,0xab,0xbb,
	0xcb,0xcf,0xd7,0xdf,0xe3,0xeb,0xf3,0xfb,0x00,0x17,0x2f,0x4b,0x67,0x83,0xa3,0xc3,
	0x67,0x7b,0x8f,0xa7,0xbb,0xd3,0xe7,0xff,0x00,0x0f,0x23,0x3b,0x53,0x73,0x93,0xbb,
	0x57,0x6f,0x87,0x9f,0xb7,0xcf,0xe7,0xff,0x00,0x1b,0x37,0x4f,0x6b,0x87,0xa3,0xbf,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1b,0x37,0x4f,0x6b,0x87,0xa3,0xbf,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1b,0x37,0x4f,0x6b,0x87,0xa3,0xbf,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1b,0x37,0x4f,0x6b,0x87,0xa3,0xbf,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0x57,0x73,0x8f,0xab,0xc7,0xe3,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0x57,0x73,0x8f,0xab,0xc7,0xe3,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x23,0x47,0x6b,0x8f,0xb3,0xdb,0xff,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0x57,0x73,0x8f,0xab,0xc7,0xe3,0xff
};

int main(int argc, char *argv[])
{
	BITMAPFILEHEADER bfh;
	BITMAPINFOHEADER bih;
	FILE *bmpfile;
	FILE *bxxfile;
	int ibfile;
	int isfile;
	int Width, Height;
	RGBTRIPLE *outBuf;
	DWORD OffBits;
	int i, j;
	BYTE *RastrBuf;
	BYTE *NewRastrBuf;
	int iX, iY, iA;

	if (argc < 3)
	{
		printf("Usage: bxx2bmp <>.bxx <>.bmp \n\a");
		return 1;
	}

	isfile = fopen_s(&bxxfile, argv[1], "rb");
	if (isfile)
	{
		printf("bxxfile was not opened\n");
		return 1;
	}

	ibfile = fopen_s(&bmpfile, argv[2], "wb");
	if (ibfile)
	{
		printf("bmpfile was not opened\n");
		fclose(bxxfile);
		return 1;
	}

	Width = 320;
	Height = 200;
	OffBits = 0;

	//  
	RastrBuf = new BYTE[Height * Width];
	outBuf = new RGBTRIPLE[Width];

	//  
	fread_s(RastrBuf, Height * Width, sizeof(BYTE), Height * Width, bxxfile);

	NewRastrBuf = new BYTE[Height * Width];

	//    
	for (iY = 0; iY < Height; iY++)
	{
		for (iX = 0; iX < Width; iX++)
		{
			NewRastrBuf[((Height - 1) - iY) * Width + iX] = RastrBuf[iY * Width + iX];
		}
	}

	for (iA = 0; iA < (Height * Width); iA++)
		{
			RastrBuf[iA] = NewRastrBuf[iA];
		}
	delete NewRastrBuf;

	//  
	memset(&bfh, 0, sizeof(bfh));				//  
	bfh.bfType = 0x4D42;						// ,   bmp 'BM'
	bfh.bfOffBits = sizeof(bfh) + sizeof(bih);	//    
	bfh.bfSize = bfh.bfOffBits + 4 * Width * Height + Height * (Width % 4);		//  

	memset(&bih, 0, sizeof(bih));				//  
	bih.biSize = sizeof(bih);					//  
	bih.biBitCount = 24;						// 24   
	bih.biCompression = BI_RGB;					//  
	bih.biHeight = Height;
	bih.biWidth = Width;
	bih.biPlanes = 1;							//   1
												//    

	//  
	fwrite(&bfh, sizeof(BYTE), sizeof(BITMAPFILEHEADER), bmpfile);
	fwrite(&bih, sizeof(BYTE), sizeof(BITMAPINFOHEADER), bmpfile);

	//  
	for (i = 0; i < Height; i++) //   
	{
		for (j = 0; j < Width; j++) //   
		{
			outBuf[j].rgbtRed = RedBuf[RastrBuf[(i * Width) + j]];
			outBuf[j].rgbtGreen = GreenBuf[RastrBuf[(i * Width) + j]];
			outBuf[j].rgbtBlue = BlueBuf[RastrBuf[(i * Width) + j]];
		}
		//  
		fwrite(outBuf, sizeof(char), sizeof(RGBTRIPLE) * Width, bmpfile);
	}

	//  
	delete RastrBuf;
	delete outBuf;

	//  
	fclose(bmpfile);
	fclose(bxxfile);

	return 0;
}

