/******************************************************************/
/*                                                                */
/* Module:       jb_device_info.h                                 */
/*                                                                */
/* Descriptions: Contain information of Altera devices.           */
/*                                                                */
/* Revisions:   1.0 02/22/02                                      */
/*				 .2 10/23/02									  */
/*				 Stratix JTAG ID-Code added						  */
/*				 .3 1/24/03										  */
/*				 Cyclone JTAG ID-Code added						  */
/*				 .4 6/3/03										  */
/*				 Stratix GX JTAG ID-Code added					  */
/*				 1C4 JTAG ID-Code added							  */
/*				 .5 6/1/04										  */
/*				 Stratix II EP2S60 JTAG ID-Code added			  */
/*				 .6 1/28/05										  */
/*				 Stratix II JTAG ID-Code added					  */
/*               Cyclone II EP2C35 JTAG ID-Code added			  */
/*				 .7 11/15/05									  */
/*               Cyclone II JTAG ID-Code added					  */
/*				 .8 05/29/06									  */
/*               BYPASS_DEV10 device info added					  */
/*				 .9 01/24/07									  */
/*				 Stratix II GX JTAG ID-Code added				  */
/*               Cyclone III EP3C25 JTAG ID-Code added			  */
/*		    2.0 	 04/26/07						 	          */
/*			Cyclone III all devices densities and package         */
/*			support added										  */
/*			2.1		 06/11/07									  */
/*			Arria GX all devices densities and package            */
/*			support added	                                      */
/*			Stratix III all devices densities and package         */
/*			support added										  */
/*			2.2		03/12/2009									  */
/*			Cyclone II EP2C15F256 JTAG ID-Code added			  */
/*			Cyclone II EP2C15F484 JTAG ID-Code added			  */	
/*			Stratix IV GX,E,GT all device densities and package   */
/*			support added										  */	
/*			2.3		 06/01/09									  */
/*			Cyclone III LS all devices densities and package      */
/*			support added	                                      */
/*			2.4		03/24/2010									  */
/*			Arria II GX and Cyclone IV all devices				  */
/*			densities and package support added					  */
/*			2.5		08/01/2012									  */
/*			Stratix V all devices densities	and package			  */
/*			support added			                    		  */
/*			Arria V GT and GX devices densities	and package		  */
/*			support added			                    		  */
/*			2.6		11/15/2012									  */
/*			Updated Stratix V, Arria V GT & GX devices, added	  */
/*			Arria V GZ, Arria V SoC devices, Cyclone V and		  */
/*			Cyclone V SoC devices.								  */
/******************************************************************/

#ifndef JB_DEVICE_INFO_H
#define JB_DEVICE_INFO_H


#define MAX_DEV_FAMILY 24		/*how many device family listed? */
#define MAX_DEV_LIST   869

int start_of_device_family[MAX_DEV_FAMILY] = {
	0,   /* ACEX      */
	14,  /* APEX II   */
	24,  /* APEX 20K  */
	35,  /* APEX 20KC */
	47,  /* APEX 20KE */
	83,  /* FLEX 10KE */
	112, /* MERCURY   */
	114, /* STRATIX   */
	143, /* CYCLONE   */	//AKL4A22 Change from 145 to 143
	155, /* STRATIX GX */
	158, /* STRATIX II */
	174, /* CYCLONE II */
	191, /* NON ALTR */
	192, /* STRATIX II GX */
	198, /* CYCLONE III */
	228, /* ARRIA GX */
	239, /* STRATIX III */
	262, /* STRATIX IV */
	309, /* CYCLONE III LS */
	319, /* ARRIA II GX */
	335, /* CYCLONE IV */
	371, /* STRATIX V */
	583,  /* ARRIA V */
	742	  /* CYCLONE V */
};

int MAX_JTAG_INIT_CLOCK[MAX_DEV_FAMILY] = {
	30,   /* ACEX      */
	175,  /* APEX II   */
	175,  /* APEX 20K  */
	175,  /* APEX 20KC */
	175,  /* APEX 20KE */
	30,   /* FLEX 10KE */
	175,  /* MERCURY   */
	175,  /* STRATIX   */
	175,  /* CYCLONE   */
	175,  /* STRATIX GX */
	300,  /* STRATIX II */
	300,  /* CYCLONE II */
	300,  /* NON ALTR */
	300,  /* STRATIX II GX */
	3181, /* CYCLONE III */
	300,  /* ARRIA GX */
	4436, /* STRATIX III */ 
	8532, /* STRATIX IV */
	3192, /* CYCLONE III LS */
	8532, /* ARRIA II GX */
	3192,  /* CYCLONE IV */
	17408, /* STRATIX V */
	17408,  /* ARRIA V */
	17408	/* CYCLONE V */
};

char family_name[MAX_DEV_FAMILY][17] = {
	{"ACEX 1K"},
	{"APEX II"},
	{"APEX 20K"},
	{"APEX 20KC"},
	{"APEX 20KE"},
	{"FLEX 10KE"},
	{"MERCURY"},
	{"STRATIX"},
	{"CYCLONE"},
	{"STRATIX GX"},
	{"STRATIX II"},
	{"CYCLONE II"},
	{"BYPASS DEV"},
	{"STRATIX II GX"},
	{"CYCLONE III"},
	{"ARRIA GX"},
	{"STRATIX III"},
	{"STRATIX IV"},
	{"CYCLONE III LS"},
	{"CYCLONE IV"},
	{"ARRIA II GX"},
	{"STRATIX V"},
	{"ARRIA V"},
	{"CYCLONE V"}
};

char device_name[MAX_DEV_LIST][23] = {
/* ACEX 1K */
	{"EP1K10F256"},/* start of ACEX 0 */
	{"EP1K10Q208"},//	1
	{"EP1K10T100"},//	2
	{"EP1K10T144"},//	3
	{"EP1K30F256"},//	4
	{"EP1K30Q208"},//	5
	{"EP1K30T144"},//	6
	{"EP1K50F256"},//	7
	{"EP1K50F484"},//	8
	{"EP1K50Q208"},//	9
	{"EP1K50T144"},//	10
	{"EP1K100F256"},//	11
	{"EP1K100F484"},//	12
	{"EP1K100Q208"},//	13
/* APEX II */
	{"EP2A15B724"},/* start of APEX II 14 */
	{"EP2A15F672"},//	15
	{"EP2A25B724"},//	16
	{"EP2A25F672"},//	17
	{"EP2A25F1020"},//	18
	{"EP2A40B724"},//	19
	{"EP2A40F672"},//	20
	{"EP2A40F1020"},//	21
	{"EP2A70B724"},//	22
	{"EP2A70F1508"},//	23
/* APEX 20K */
	{"EP20K100B356"},/* start of APEX 20K 24 */
	{"EP20K100F324"},//	25
	{"EP20K100Q208"},//	26
	{"EP20K100Q240"},//	27
	{"EP20K100T144"},//	28
	{"EP20K200B356"},//	29
	{"EP20K200F484"},//	30
	{"EP20K200R208"},//	31
	{"EP20K200R240"},//	32
	{"EP20K400B652"},//	33
	{"EP20K400F672"},//	34
/* APEX 20KC */
	{"EP20K200CB356"},/* start of APEX 20KC 35 */
	{"EP20K200CF484"},//	36
	{"EP20K200CQ208"},//	37
	{"EP20K200CQ240"},//	38
	{"EP20K400CB652"},//	39
	{"EP20K400CF672"},//	40
	{"EP20K600CB652"},//	41
	{"EP20K600CF672"},//	42
	{"EP20K600CF33"},//		43
	{"EP20K1000CB652"},//	44
	{"EP20K1000CF672"},//	45
	{"EP20K1000CF33"},//	46
/* APEX 20KE */
	{"EP20K30ET144"},/* start of APEX 20KE 47 */
	{"EP20K60EB356"},//	48
	{"EP20K60EF144"},//	49
	{"EP20K60EF324"},//	50
	{"EP20K60EQ208"},//	51
	{"EP20K60ET144"},//	52
	{"EP20K100EB356"},//	53
	{"EP20K100EF144"},//	54
	{"EP20K100EF324"},//	55
	{"EP20K100EQ208"},//	56
	{"EP20K100EQ240"},//	57
	{"EP20K100ET144"},//	58
	{"EP20K160EB356"},//	59
	{"EP20K160EF484"},//	60
	{"EP20K160EQ208"},//	61
	{"EP20K160EQ240"},//	62
	{"EP20K160ET144"},//	63
	{"EP20K200EB356"},//	64
	{"EP20K200EB652"},//	65
	{"EP20K200EF484"},//	66
	{"EP20K200EF672"},//	67
	{"EP20K200EQ208"},//	68
	{"EP20K200EQ240"},//	69
	{"EP20K300EB652"},//	70
	{"EP20K300EF672"},//	71
	{"EP20K300EQ240"},//	72
	{"EP20K400EB652"},//	73
	{"EP20K400EF672"},//	74
	{"EP20K600EB652"},//	75
	{"EP20K600EF672"},//	76
	{"EP20K600EF33"},//		77
	{"EP20K1000EB652"},//	78
	{"EP20K1000EF672"},//	79
	{"EP20K1000EF33"},//	80
	{"EP20K1500EB652"},//	81
	{"EP20K1500EF33"},//	82
/* FLEX 10KE */
	{"EPF10K30EF256"},/* start of FLEX 10KE 83 */
	{"EPF10K30EF484"},//	84
	{"EPF10K30EQ208"},//	85
	{"EPF10K30ET144"},//	86
	{"EPF10K50EF256"},//	87
	{"EPF10K50EQ240"},//	88
	{"EPF10K50ET144"},//	89
	{"EPF10K50SB356"},//	90
	{"EPF10K50SF256"},//	91
	{"EPF10K50SF484"},//	92
	{"EPF10K50SQ208"},//	93
	{"EPF10K50SQ240"},//	94
	{"EPF10K50ST144"},//	95
	{"EPF10K100EB356"},//	96
	{"EPF10K100EF256"},//	97
	{"EPF10K100EF484"},//	98
	{"EPF10K100EQ208"},//	99
	{"EPF10K100EQ240"},//	100
	{"EPF10K130EB356"},//	101
	{"EPF10K130EB600"},//	102
	{"EPF10K130EF484"},//	103
	{"EPF10K130EF672"},//	104
	{"EPF10K130EQ240"},//	105
	{"EPF10K200EB600"},//	106
	{"EPF10K200SB356"},//	107
	{"EPF10K200SB600"},//	108
	{"EPF10K200SF484"},//	109
	{"EPF10K200SF672"},//	110
	{"EPF10K200SR240"},//	111
/* MERCURY */
	{"EP1M120F484"},/* start of MERCURY 112 */
	{"EP1M350F780"},//		113
/* STRATIX */
	{"EP1S10B672"},/* start of STRATIX 114 */
	{"EP1S10F484"},//		115
	{"EP1S10F672"},//		116
	{"EP1S10F780"},//		117
	{"EP1S10B672ES"},//		118
	{"EP1S10F484ES"},//		119
	{"EP1S10F672ES"},//		120
	{"EP1S10F780ES"},//		121
	{"EP1S20B672"},//		122
	{"EP1S20F484"},//		123
	{"EP1S20F672"},//		124
	{"EP1S20F780"},//		125
	{"EP1S25B672"},//		126
	{"EP1S25F672"},//		127
	{"EP1S25F780"},//		128
	{"EP1S25F1020"},//		129
	{"EP1S30B956"},//		130
	{"EP1S30F780"},//		131
	{"EP1S30F1020"},//		132
	{"EP1S40B956"},//		133
	{"EP1S40F780"},//		134
	{"EP1S40F1020"},//		135
	{"EP1S40F1508"},//		136
	{"EP1S60B956"},//		137
	{"EP1S60F1020"},//		138
	{"EP1S60F1508"},//		139
	{"EP1S80B956"},//		140
	{"EP1S80F1020"},//		141
	{"EP1S80F1508"},//		142
/* CYCLONE */
	{"EP1C20F324"},/* start of CYCLONE 143 */
	{"EP1C20F400"},//		144
	{"EP1C12F256"},//		145
	{"EP1C12F324"},//		146
	{"EP1C12Q240"},//		147
	{"EP1C6F256"},//		148
	{"EP1C6Q240"},//		149
	{"EP1C6T144"},//		150
	{"EP1C4F400"},//		151
	{"EP1C4F324"},//		152
	{"EP1C3T100"},//		153
	{"EP1C3T144"},//		154
/* STRATIX GX */
	{"EP1SGX40"},/* start of STRATIX GX 155 */
	{"EP1SGX25"},//		156
	{"EP1SGX10"},//		157
/* STRATIX II ES*/
	{"EP2S60F484ES"},///* start of STRATIX II ES 158 */	
	{"EP2S60F672ES"},//		159
	{"EP2S60F1020ES"},//	160
/* STRATIX II */
	{"EP2S15F484"},///* start of STRATIX II 161 */
	{"EP2S15F672"},//		162
	{"EP2S30F484"},//		163
	{"EP2S30F672"},//		164
	{"EP2S60F484"},//		165
	{"EP2S60F672"},//		166
	{"EP2S60F1020"},//		167
	{"EP2S90F1020"},//		168
	{"EP2S90F1508"},//		169
	{"EP2S130F1020"},//		170
	{"EP2S130F1508"},//		171
	{"EP2S180F1020"},//		172
	{"EP2S180F1508"},//		173
/* CYCLONE II */
	{"EP2C35F484"},///* start of CYCLONE II 174 */
	{"EP2C35F672"},//		175
	{"EP2C5T144"},//		176
	{"EP2C5Q208"},//		177	
	{"EP2C5F256"},//		178
	{"EP2C8T144"},//		179	
	{"EP2C8Q208"},//		180
	{"EP2C8F256"},//		181	
	{"EP2C15F256"},//		182	
	{"EP2C15F484"},//		183
	{"EP2C20Q240"},//		184
	{"EP2C20F256"},//		185	
	{"EP2C20F484"},//		186
	{"EP2C50F484"},//		187	
	{"EP2C50F672"},//		188
	{"EP2C70F672"},//		189	
	{"EP2C70F896"},//		190	
	{"BYPASS_DEV10"},//		191		//Bypass device on the JTAG chain	
/* STRATIX II GX */
	{"EP2SGX30F780"},///* start of STRATIX II GX 192 */
	{"EP2SGX60F780"},//		193
	{"EP2SGX60F1152"},//	194
	{"EP2SGX90F1152"},//	195
	{"EP2SGX90F1508"},//	196
	{"EP2SGX130F1508"},//	197
/* CYCLONE III */
	{"EP3C25F324"},///* start of CYCLONE III 198 */
	{"EP3C25E144"},//		199
	{"EP3C25Q240"},//		200
	{"EP3C25F256"},//		201
	{"EP3C25U256"},//		202
	{"EP3C5E144"},//		203
	{"EP3C5F256"},//		204
	{"EP3C5U256"},//		205
	{"EP3C10E144"},//		206
	{"EP3C10F256"},//		207
	{"EP3C10U256"},//		208
	{"EP3C16E144"},//		209
	{"EP3C16Q240"},//		210
	{"EP3C16F256"},//		211
	{"EP3C16U256"},//		212
	{"EP3C16F484"},//		213
	{"EP3C16U484"},//		214
	{"EP3C40Q240"},//		215
	{"EP3C40F324"},//		216
	{"EP3C40F484"},//		217
	{"EP3C40U484"},//		218
	{"EP3C40U780"},//		219
	{"EP3C55F484"},//		220
	{"EP3C55U484"},//		221
	{"EP3C55U780"},//		222
	{"EP3C80F484"},//		223
	{"EP3C80U484"},//		224
	{"EP3C80F780"},//		225
	{"EP3C120F484"},//		226
	{"EP3C120F780"},		///*end of Cyclone III*/// 227
/* ARRIA GX */
	{"EP1AGX20F484"},//		228
	{"EP1AGX20F780"},//		229
	{"EP1AGX35F484"},//		230
	{"EP1AGX35F780"},//		231
	{"EP1AGX50F484"},//		232
	{"EP1AGX50F780"},//		233
	{"EP1AGX50F1152"},//	234
	{"EP1AGX60F484"},//		235
	{"EP1AGX60F780"},//		236
	{"EP1AGX60F1152"},//	237
	{"EP1AGX90F1152"},		///*end of Arria GX*/// 238
/* STRATIX III */
	{"EP3SL50F484"},//		239
	{"EP3SL50F780"},//		240
	{"EP3SL70F484"},//		241
	{"EP3SL70F780"},//		242
	{"EP3SL110F780"},//		243
	{"EP3SL110F1152"},//	244
	{"EP3SL150F780"},//		245
	{"EP3SL150F1152"},//	246
	{"EP3SL200F780"},//		247
	{"EP3SL200F1152"},//	248
	{"EP3SL200F1517"},//	249
	{"EP3SL340F1152"},//	250
	{"EP3SL340F1517"},//	251
	{"EP3SL340F1760"},//	252
	{"EP3SE50F484"},//		253
	{"EP3SE50F780"},//		254
	{"EP3SE80F780"},//		255
	{"EP3SE80F1152"},//		256
	{"EP3SE110F780"},//		257
	{"EP3SE110F1152"},//	258
	{"EP3SE260F780"},//		259
	{"EP3SE260F1152"},//	260
	{"EP3SE260F1517"},		///*end of Stratix III */// 261
/* Stratix IV */
	{"EP4SGX70DF29"},//		262
	{"EP4SGX70DF35"},//		263
	{"EP4SGX110DF29"},//	264
	{"EP4SGX110FF35"},//	265
	{"EP4SGX180DF29"},//	266
	{"EP4SGX180FF35"},//	267
	{"EP4SGX180HF35"},//	268
	{"EP4SGX180KF40"},//	269
	{"EP4SGX230DF29"},//	270
	{"EP4SGX230FF35"},//	271
	{"EP4SGX230HF35"},//	272
	{"EP4SGX230KF40"},//	273
	{"EP4SGX290FH29"},//	274
	{"EP4SGX290FF35"},//	275
	{"EP4SGX290HF35"},//	276
	{"EP4SGX290KF40"},//	277
	{"EP4SGX290KF43"},//	278
	{"EP4SGX290NF45"},//	279
	{"EP4SGX360FF29"},//	280
	{"EP4SGX360FF35"},//	281
	{"EP4SGX360HF35"},//	282
	{"EP4SGX360KF40"},//	283
	{"EP4SGX360KF43"},//	284
	{"EP4SGX360NF45"},//	285
	{"EP4SGX530HH35"},//	286
	{"EP4SGX530KH40"},//	287
	{"EP4SGX530KF43"},//	288
	{"EP4SGX530NF45"},//	289
	{"EP4SE110F29"},//		290
	{"EP4SE230F29"},//		291
	{"EP4SE290F29"},//		292
	{"EP4SE290F35"},//		293
	{"EP4SE290F40"},//		294
	{"EP4SE360F29"},//		295
	{"EP4SE360F35"},//		296
	{"EP4SE360F40"},//		297
	{"EP4SE530H35"},//		298
	{"EP4SE530H40"},//		299
	{"EP4SE530F43"},//		300
	{"EP4SE680F35"},//		301
	{"EP4SE680F40"},//		302
	{"EP4SE680F43"},//		303
	{"EP4S40G2F40"},//		304
	{"EP4S40G5H40"},//		305
	{"EP4S100G2F40"},//		306
	{"EP4S100G5F40"},//		307
	{"EP4S100G5H45"}, ///*end of Stratix IV *///308		
/* Cyclone III LS */
	{"EP3CLS70F484"},//		309
	{"EP3CLS70U484"},//		310
	{"EP3CLS70F780"},//		311
	{"EP3CLS100F484"},//	312
	{"EP3CLS100U484"},//	313
	{"EP3CLS100F780"},//	314
	{"EP3CLS150F484"},//	315
	{"EP3CLS150F780"},//	316
	{"EP3CLS200F484"},//	317
	{"EP3CLS200F780"}, ///*end of Cyclone III LS */// 318
/* Arria II GX */
	{"EP2AGX45CU17"},//		319
	{"EP2AGX45DF25"},//		320
	{"EP2AGX45DF29"},//		321
	{"EP2AGX65CU17"},//		322
	{"EP2AGX65DF25"},//		323
	{"EP2AGX65DF29"},//		324
	{"EP2AGX95DF25"},//		325
	{"EP2AGX95EF29"},//		326
	{"EP2AGX95EF35"},//	327
	{"EP2AGX125DF25"},//	328
	{"EP2AGX125EF29"},//	329
	{"EP2AGX125EF35"},//	330
	{"EP2AGX190EF29"},//	331
	{"EP2AGX190FF35"},//	332
	{"EP2AGX260EF29"},//	333
	{"EP2AGX260FF35"},///*end of Arria II GX *///	334
/* Cyclone IV */
	{"EP4CE6E22"},//		335
	{"EP4CE6F17"},//		336
	{"EP4CE10E22"},//		337
	{"EP4CE10F17"},//		338
	{"EP4CE15E22"},//		339
	{"EP4CE15F17"},//		340
	{"EP4CE15F23"},//		341
	{"EP4CE22E22"},//		342
	{"EP4CE22F17"},//		343
	{"EP4CE30F23"},//		344
	{"EP4CE30F29"},//		345
	{"EP4CE40F23"},//		346
	{"EP4CE40F29"},//		347
	{"EP4CE55F23"},//		348
	{"EP4CE55F29"},//		349
	{"EP4CE75F23"},//		350
	{"EP4CE75F29"},//		351
	{"EP4CE115F23"},//		352
	{"EP4CE115F29"},//		353
	{"EP4CGX15BF14"},//		354
	{"EP4CGX15BN11"},//		355
	{"EP4CGX22BF14"},//		356
	{"EP4CGX22CF19"},//		357
	{"EP4CGX30BF14"},//		358
	{"EP4CGX30CF19"},//		359
	{"EP4CGX30CF23"},//		360
	{"EP4CGX50CF23"},//		361
	{"EP4CGX50DF27"},//		362
	{"EP4CGX75CF23"},//		363
	{"EP4CGX75DF27"},//		364
	{"EP4CGX110CF23"},//	365
	{"EP4CGX110DF27"},//	366
	{"EP4CGX110DF31"},//	367
	{"EP4CGX150CF23"},//	368
	{"EP4CGX150DF27"},//	369
	{"EP4CGX150DF31"},///*end of Cyclone IV *///	370
/* STRATIX V */
	{"5SEE9F45"},//			371
	{"5SEE9H40"},//			372
	{"5SEEBF45"},//			373
	{"5SEEBH40"},//			374
	{"5SGSED6K1F40"},//		375
	{"5SGSED6K2F40"},//		376
	{"5SGSED6K3F40"},//		377
	{"5SGSED6N1F45"},//		378
	{"5SGSED6N2F45"},//		379
	{"5SGSED6N3F45"},//		380
	{"5SGSED8K1F40"},//		381
	{"5SGSED8K2F40"},//		382
	{"5SGSED8K3F40"},//		383
	{"5SGSED8N1F45"},//		384
	{"5SGSED8N2F45"},//		385
	{"5SGSED8N3F45"},//		386
	{"5SGSMD3E1H29"},//		387
	{"5SGSMD3E2H29"},//		388
	{"5SGSMD3E3H29"},//		389
	{"5SGSMD3H1F35"},//		390
	{"5SGSMD3H2F35"},//		391
	{"5SGSMD3H3F35"},//		392
	{"5SGSMD4E1H29"},//		393
	{"5SGSMD4E2H29"},//		394
	{"5SGSMD4E3H29"},//		395
	{"5SGSMD4H1F35"},//		396
	{"5SGSMD4H2F35"},//		397
	{"5SGSMD4H3F35"},//		398
	{"5SGSMD4K1F40"},//		399
	{"5SGSMD4K2F40"},//		400
	{"5SGSMD4K3F40"},//		401
	{"5SGSMD5H1F35"},//		402
	{"5SGSMD5H2F35"},//		403
	{"5SGSMD5H3F35"},//		404
	{"5SGSMD5K1F40"},//		405
	{"5SGSMD5K2F40"},//		406
	{"5SGSMD5K3F40"},//		407
	{"5SGSMD6K1F40"},//		408
	{"5SGSMD6K2F40"},//		409
	{"5SGSMD6K3F40"},//		410
	{"5SGSMD6N1F45"},//		411
	{"5SGSMD6N2F45"},//		412
	{"5SGSMD6N3F45"},//		413
	{"5SGSMD8K1F40"},//		414
	{"5SGSMD8K2F40"},//		415
	{"5SGSMD8K3F40"},//		416
	{"5SGSMD8N1F45"},//		417
	{"5SGSMD8N2F45"},//		418
	{"5SGSMD8N3F45"},//		419
	{"5SGTMC5K2F40"},//		420
	{"5SGTMC5K3F40"},//		421
	{"5SGTMC7K2F40"},//		422
	{"5SGTMC7K3F40"},//		423
	{"5SGXEA3H1F35"},//		424
	{"5SGXEA3H2F35"},//		425
	{"5SGXEA3H3F35"},//		426
	{"5SGXEA3K1F35"},//		427
	{"5SGXEA3K1F40"},//		428
	{"5SGXEA3K2F35"},//		429
	{"5SGXEA3K2F40"},//		430
	{"5SGXEA3K3F35"},//		431
	{"5SGXEA3K3F40"},//		432
	{"5SGXEA4H1F35"},//		433
	{"5SGXEA4H2F35"},//		434
	{"5SGXEA4H3F35"},//		435
	{"5SGXEA4K1F35"},//		436
	{"5SGXEA4K1F40"},//		437
	{"5SGXEA4K2F35"},//		438
	{"5SGXEA4K2F40"},//		439
	{"5SGXEA4K3F35"},//		440
	{"5SGXEA4K3F40"},//		441
	{"5SGXEA5H1F35"},//		442
	{"5SGXEA5H2F35"},//		443
	{"5SGXEA5H3F35"},//		444
	{"5SGXEA5K1F35"},//		445
	{"5SGXEA5K1F40"},//		446
	{"5SGXEA5K2F35"},//		447
	{"5SGXEA5K2F40"},//		448
	{"5SGXEA5K3F35"},//		449
	{"5SGXEA5K3F40"},//		450
	{"5SGXEA5N1F40"},//		451
	{"5SGXEA5N1F45"},//		452
	{"5SGXEA5N2F40"},//		453
	{"5SGXEA5N2F45"},//		454
	{"5SGXEA5N3F40"},//		455
	{"5SGXEA5N3F45"},//		456
	{"5SGXEA7H1F35"},//		457
	{"5SGXEA7H2F35"},//		458
	{"5SGXEA7H3F35"},//		459
	{"5SGXEA7K1F35"},//		460
	{"5SGXEA7K1F40"},//		461
	{"5SGXEA7K2F35"},//		462
	{"5SGXEA7K2F40"},//		463
	{"5SGXEA7K3F35"},//		464
	{"5SGXEA7K3F40"},//		465
	{"5SGXEA7N1F40"},//		466
	{"5SGXEA7N1F45"},//		467
	{"5SGXEA7N2F40"},//		468
	{"5SGXEA7N2F45"},//		469
	{"5SGXEA7N3F40"},//		470
	{"5SGXEA7N3F45"},//		471
	{"5SGXEA9K1H40"},//		472
	{"5SGXEA9K2H40"},//		473
	{"5SGXEA9K3H40"},//		474
	{"5SGXEA9N1F45"},//		475
	{"5SGXEA9N2F45"},//		476
	{"5SGXEA9N3F45"},//		477
	{"5SGXEABK1H40"},//		478
	{"5SGXEABK2H40"},//		479
	{"5SGXEABK3H40"},//		480
	{"5SGXEABN1F45"},//		481
	{"5SGXEABN2F45"},//		482
	{"5SGXEABN3F45"},//		483
	{"5SGXEB5R1F40"},//		484
	{"5SGXEB5R1F43"},//		485
	{"5SGXEB5R2F40"},//		486
	{"5SGXEB5R2F43"},//		487
	{"5SGXEB5R3F40"},//		488
	{"5SGXEB5R3F43"},//		489
	{"5SGXEB6R1F40"},//		490
	{"5SGXEB6R1F43"},//		491
	{"5SGXEB6R2F40"},//		492
	{"5SGXEB6R2F43"},//		493
	{"5SGXEB6R3F40"},//		494
	{"5SGXEB6R3F43"},//		495
	{"5SGXEB9R1H43"},//		496
	{"5SGXEB9R2H43"},//		497
	{"5SGXEB9R3H43"},//		498
	{"5SGXEBBR1H43"},//		499
	{"5SGXEBBR2H43"},//		500
	{"5SGXEBBR3H43"},//		501
	{"5SGXMA3E1H29"},//		502
	{"5SGXMA3E2H29"},//		503
	{"5SGXMA3E3H29"},//		504
	{"5SGXMA3H1F35"},//		505
	{"5SGXMA3H2F35"},//		506
	{"5SGXMA3H3F35"},//		507
	{"5SGXMA3K1F35"},//		508
	{"5SGXMA3K1F40"},//		509
	{"5SGXMA3K2F35"},//		510
	{"5SGXMA3K2F40"},//		511
	{"5SGXMA3K3F35"},//		512
	{"5SGXMA3K3F40"},//		513
	{"5SGXMA4H1F35"},//		514
	{"5SGXMA4H2F35"},//		515
	{"5SGXMA4H3F35"},//		516
	{"5SGXMA4K1F35"},//		517
	{"5SGXMA4K1F40"},//		518
	{"5SGXMA4K2F35"},//		519
	{"5SGXMA4K2F40"},//		520
	{"5SGXMA4K3F35"},//		521
	{"5SGXMA4K3F40"},//		522
	{"5SGXMA5H1F35"},//		523
	{"5SGXMA5H2F35"},//		524
	{"5SGXMA5H3F35"},//		525
	{"5SGXMA5K1F35"},//		526
	{"5SGXMA5K1F40"},//		527
	{"5SGXMA5K2F35"},//		528
	{"5SGXMA5K2F40"},//		529
	{"5SGXMA5K3F35"},//		530
	{"5SGXMA5K3F40"},//		531
	{"5SGXMA5N1F40"},//		532
	{"5SGXMA5N1F45"},//		533
	{"5SGXMA5N2F40"},//		534
	{"5SGXMA5N2F45"},//		535
	{"5SGXMA5N3F40"},//		536
	{"5SGXMA5N3F45"},//		537
	{"5SGXMA7H1F35"},//		538
	{"5SGXMA7H2F35"},//		539
	{"5SGXMA7H3F35"},//		540
	{"5SGXMA7K1F35"},//		541
	{"5SGXMA7K1F40"},//		542
	{"5SGXMA7K2F35"},//		543
	{"5SGXMA7K2F40"},//		544
	{"5SGXMA7K3F35"},//		545
	{"5SGXMA7K3F40"},//		546
	{"5SGXMA7N1F40"},//		547
	{"5SGXMA7N1F45"},//		548
	{"5SGXMA7N2F40"},//		549
	{"5SGXMA7N2F45"},//		550
	{"5SGXMA7N3F40"},//		551
	{"5SGXMA7N3F45"},//		552
	{"5SGXMA9K1H40"},//		553
	{"5SGXMA9K2H40"},//		554
	{"5SGXMA9K3H40"},//		555
	{"5SGXMA9N1F45"},//		556
	{"5SGXMA9N2F45"},//		557
	{"5SGXMA9N3F45"},//		558
	{"5SGXMABK1H40"},//		559
	{"5SGXMABK2H40"},//		560
	{"5SGXMABK3H40"},//		561
	{"5SGXMABN1F45"},//		562
	{"5SGXMABN2F45"},//		563
	{"5SGXMABN3F45"},//		564
	{"5SGXMB5R1F40"},//		565
	{"5SGXMB5R1F43"},//		566
	{"5SGXMB5R2F40"},//		567
	{"5SGXMB5R2F43"},//		568
	{"5SGXMB5R3F40"},//		569
	{"5SGXMB5R3F43"},//		570
	{"5SGXMB6R1F40"},//		571
	{"5SGXMB6R1F43"},//		572
	{"5SGXMB6R2F40"},//		573
	{"5SGXMB6R2F43"},//		574
	{"5SGXMB6R3F40"},//		575
	{"5SGXMB6R3F43"},//		576
	{"5SGXMB9R1H43"},//		577
	{"5SGXMB9R2H43"},//		578
	{"5SGXMB9R3H43"},//		579
	{"5SGXMBBR1H43"},//		580
	{"5SGXMBBR2H43"},//		581
	{"5SGXMBBR3H43"},///*end of Stratix V *///	582
/* ARRIA V */
	{"5AGTFC7H3F35"},//		583
	{"5AGTFD3H3F35"},//		584
	{"5AGTFD3H3F40"},//		585
	{"5AGTFD7H3F35"},//		586
	{"5AGTFD7K3F40"},//		587
	{"5AGTMC3D3F27"},//		588
	{"5AGTMC3D3F31"},//		589
	{"5AGTMC7G3F31"},//		590
	{"5AGTMD3G3F31"},//		591
	{"5AGXBA1D4F27"},//		592
	{"5AGXBA1D4F31"},//		593
	{"5AGXBA1D6F27"},//		594
	{"5AGXBA1D6F31"},//		595
	{"5AGXBA3D4F27"},//		596
	{"5AGXBA3D4F31"},//		597
	{"5AGXBA3D6F27"},//		598
	{"5AGXBA3D6F31"},//		599
	{"5AGXBA5D4F27"},//		600
	{"5AGXBA5D4F31"},//		601
	{"5AGXBA5D4F35"},//		602
	{"5AGXBA5D6F27"},//		603
	{"5AGXBA5D6F31"},//		604
	{"5AGXBA5D6F35"},//		605
	{"5AGXBA7D4F27"},//		606
	{"5AGXBA7D4F31"},//		607
	{"5AGXBA7D4F35"},//		608
	{"5AGXBA7D6F27"},//		609
	{"5AGXBA7D6F31"},//		610
	{"5AGXBA7D6F35"},//		611
	{"5AGXBB1D4F31"},//		612
	{"5AGXBB1D4F35"},//		613
	{"5AGXBB1D4F40"},//		614
	{"5AGXBB1D6F31"},//		615
	{"5AGXBB1D6F35"},//		616
	{"5AGXBB1D6F40"},//		617
	{"5AGXBB3D4F31"},//		618
	{"5AGXBB3D4F35"},//		619
	{"5AGXBB3D4F40"},//		620
	{"5AGXBB3D6F31"},//		621
	{"5AGXBB3D6F35"},//		622
	{"5AGXBB3D6F40"},//		623
	{"5AGXBB5D4F35"},//		624
	{"5AGXBB5D4F40"},//		625
	{"5AGXBB5D6F35"},//		626
	{"5AGXBB5D6F40"},//		627
	{"5AGXBB7D4F35"},//		628
	{"5AGXBB7D4F40"},//		629
	{"5AGXBB7D6F35"},//		630
	{"5AGXBB7D6F40"},//		631
	{"5AGXFA5H4F35"},//		632
	{"5AGXFA5H6F35"},//		633
	{"5AGXFA7H4F35"},//		634
	{"5AGXFA7H6F35"},//		635
	{"5AGXFB1H4F35"},//		636
	{"5AGXFB1H4F40"},//		637
	{"5AGXFB1H6F35"},//		638
	{"5AGXFB1H6F40"},//		639
	{"5AGXFB3H4F35"},//		640
	{"5AGXFB3H4F40"},//		641
	{"5AGXFB3H6F35"},//		642
	{"5AGXFB3H6F40"},//		643
	{"5AGXFB5H4F35"},//		644
	{"5AGXFB5H6F35"},//		645
	{"5AGXFB5K4F40"},//		646
	{"5AGXFB5K6F40"},//		647
	{"5AGXFB7H4F35"},//		648
	{"5AGXFB7H6F35"},//		649
	{"5AGXFB7K4F40"},//		650
	{"5AGXFB7K6F40"},//		651
	{"5AGXMA1D4F27"},//		652
	{"5AGXMA1D4F31"},//		653
	{"5AGXMA1D6F27"},//		654
	{"5AGXMA1D6F31"},//		655
	{"5AGXMA3D4F27"},//		656
	{"5AGXMA3D4F31"},//		657
	{"5AGXMA3D6F27"},//		658
	{"5AGXMA3D6F31"},//		659
	{"5AGXMA5D4F27"},//		660
	{"5AGXMA5D6F27"},//		661
	{"5AGXMA5G4F31"},//		662
	{"5AGXMA5G4F35"},//		663
	{"5AGXMA5G6F31"},//		664
	{"5AGXMA5G6F35"},//		665
	{"5AGXMA7D4F27"},//		666
	{"5AGXMA7D6F27"},//		667
	{"5AGXMA7G4F31"},//		668
	{"5AGXMA7G4F35"},//		669
	{"5AGXMA7G6F31"},//		670
	{"5AGXMA7G6F35"},//		671
	{"5AGXMB1G4F31"},//		672
	{"5AGXMB1G4F35"},//		673
	{"5AGXMB1G4F40"},//		674
	{"5AGXMB1G6F31"},//		675
	{"5AGXMB1G6F35"},//		676
	{"5AGXMB1G6F40"},//		677
	{"5AGXMB3G4F31"},//		678
	{"5AGXMB3G4F35"},//		679
	{"5AGXMB3G4F40"},//		680
	{"5AGXMB3G6F31"},//		681
	{"5AGXMB3G6F35"},//		682
	{"5AGXMB3G6F40"},//		683
	{"5AGXMB5G4F35"},//		684
	{"5AGXMB5G4F40"},//		685
	{"5AGXMB5G6F35"},//		686
	{"5AGXMB5G6F40"},//		687
	{"5AGXMB7G4F35"},//		688
	{"5AGXMB7G4F40"},//		689
	{"5AGXMB7G6F35"},//		690
	{"5AGXMB7G6F40"},//		691
	{"5ASTFD3G3F35"},//		692
	{"5ASTFD3K3F40"},//		693
	{"5ASTFD5G3F35"},//		694
	{"5ASTFD5K3F40"},//		695
	{"5ASTMD3E3F31"},//		696
	{"5ASTMD5E3F31"},//		697
	{"5ASXBB3D4F31"},//		698
	{"5ASXBB3D4F35"},//		699
	{"5ASXBB3D4F40"},//		700
	{"5ASXBB3D6F31"},//		701
	{"5ASXBB3D6F35"},//		702
	{"5ASXBB3D6F40"},//		703
	{"5ASXBB5D4F31"},//		704
	{"5ASXBB5D4F35"},//		705
	{"5ASXBB5D4F40"},//		706
	{"5ASXBB5D6F31"},//		707
	{"5ASXBB5D6F35"},//		708
	{"5ASXBB5D6F40"},//		709
	{"5ASXFB3G4F35"},//		710
	{"5ASXFB3G6F35"},//		711
	{"5ASXFB3H4F40"},//		712
	{"5ASXFB3H6F40"},//		713
	{"5ASXFB5G4F35"},//		714
	{"5ASXFB5G6F35"},//		715
	{"5ASXFB5H4F40"},//		716
	{"5ASXFB5H6F40"},//		717
	{"5ASXMB3E4F31"},//		718
	{"5ASXMB3E6F31"},//		719
	{"5ASXMB3G4F40"},//		720
	{"5ASXMB3G6F40"},//		721
	{"5ASXMB5E4F31"},//		722
	{"5ASXMB5E6F31"},//		723
	{"5ASXMB5G4F40"},//		724
	{"5ASXMB5G6F40"},//		725
	{"5AGZME1E2H29"},//		726
	{"5AGZME1E3H29"},//		727
	{"5AGZME1H2F35"},//		728
	{"5AGZME1H3F35"},//		729
	{"5AGZME3E2H29"},//		730
	{"5AGZME3E3H29"},//		731
	{"5AGZME3H2F35"},//		732
	{"5AGZME3H3F35"},//		733
	{"5AGZME5H2F35"},//		734
	{"5AGZME5H3F35"},//		735
	{"5AGZME5K2F40"},//		736
	{"5AGZME5K3F40"},//		737
	{"5AGZME7H2F35"},//		738
	{"5AGZME7H3F35"},//		739
	{"5AGZME7K2F40"},//		740
	{"5AGZME7K3F40"},///*end of Arria V *///	741
/* CYCLONE V */
	{"5CEBA2F17"},//		742
	{"5CEBA2F23"},//		743
	{"5CEBA2U15"},//		744
	{"5CEBA2U19"},//		745
	{"5CEBA4F17"},//		746
	{"5CEBA4F23"},//		747
	{"5CEBA4U15"},//		748
	{"5CEBA4U19"},//		749
	{"5CEBA5F23"},//		750
	{"5CEBA5U19"},//		751
	{"5CEBA7F23"},//		752
	{"5CEBA7F27"},//		753
	{"5CEBA7F31"},//		754
	{"5CEBA7U19"},//		755
	{"5CEBA9F23"},//		756
	{"5CEBA9F27"},//		757
	{"5CEBA9F31"},//		758
	{"5CEFA2F17"},//		759
	{"5CEFA2F23"},//		760
	{"5CEFA2U15"},//		761
	{"5CEFA2U19"},//		762
	{"5CEFA4F17"},//		763
	{"5CEFA4F23"},//		764
	{"5CEFA4U15"},//		765
	{"5CEFA4U19"},//		766
	{"5CEFA5F23"},//		767
	{"5CEFA5U19"},//		768
	{"5CEFA7F23"},//		769
	{"5CEFA7F27"},//		770
	{"5CEFA7F31"},//		771
	{"5CEFA7U19"},//		772
	{"5CEFA9F23"},//		773
	{"5CEFA9F27"},//		774
	{"5CEFA9F31"},//		775
	{"5CGTFD5C5F23"},//		776
	{"5CGTFD5C5F27"},//		777
	{"5CGTFD5C5U19"},//		778
	{"5CGTFD7C5F23"},//		779
	{"5CGTFD7C5U19"},//		780
	{"5CGTFD7D5F27"},//		781
	{"5CGTFD7D5F31"},//		782
	{"5CGTFD9C5F23"},//		783
	{"5CGTFD9D5F27"},//		784
	{"5CGTFD9E5F31"},//		785
	{"5CGTFD9E5F35"},//		786
	{"5CGXBC3B6F23"},//		787
	{"5CGXBC3B6U15"},//		788
	{"5CGXBC3B6U19"},//		789
	{"5CGXBC3B7F23"},//		790
	{"5CGXBC3B7U15"},//		791
	{"5CGXBC3B7U19"},//		792
	{"5CGXBC4C6F23"},//		793
	{"5CGXBC4C6F27"},//		794
	{"5CGXBC4C6U19"},//		795
	{"5CGXBC4C7F23"},//		796
	{"5CGXBC4C7F27"},//		797
	{"5CGXBC4C7U19"},//		798
	{"5CGXBC5C6F23"},//		799
	{"5CGXBC5C6F27"},//		800
	{"5CGXBC5C6U19"},//		801
	{"5CGXBC5C7F23"},//		802
	{"5CGXBC5C7F27"},//		803
	{"5CGXBC5C7U19"},//		804
	{"5CGXBC7C6F23"},//		805
	{"5CGXBC7C6U19"},//		806
	{"5CGXBC7C7F23"},//		807
	{"5CGXBC7C7U19"},//		808
	{"5CGXBC7D6F27"},//		809
	{"5CGXBC7D6F31"},//		810
	{"5CGXBC7D7F27"},//		811
	{"5CGXBC7D7F31"},//		812
	{"5CGXBC9C6F23"},//		813
	{"5CGXBC9C7F23"},//		814
	{"5CGXBC9D6F27"},//		815
	{"5CGXBC9D7F27"},//		816
	{"5CGXBC9E6F31"},//		817
	{"5CGXBC9E6F35"},//		818
	{"5CGXBC9E7F31"},//		819
	{"5CGXBC9E7F35"},//		820
	{"5CGXFC3B6F23"},//		821
	{"5CGXFC3B6U15"},//		822
	{"5CGXFC3B6U19"},//		823
	{"5CGXFC3B7F23"},//		824
	{"5CGXFC3B7U15"},//		825
	{"5CGXFC3B7U19"},//		826
	{"5CGXFC4C6F23"},//		827
	{"5CGXFC4C6F27"},//		828
	{"5CGXFC4C6U19"},//		829
	{"5CGXFC4C7F23"},//		830
	{"5CGXFC4C7F27"},//		831
	{"5CGXFC4C7U19"},//		832
	{"5CGXFC5C6F23"},//		833
	{"5CGXFC5C6F27"},//		834
	{"5CGXFC5C6U19"},//		835
	{"5CGXFC5C7F23"},//		836
	{"5CGXFC5C7F27"},//		837
	{"5CGXFC5C7U19"},//		838
	{"5CGXFC7C6F23"},//		839
	{"5CGXFC7C6U19"},//		840
	{"5CGXFC7C7F23"},//		841
	{"5CGXFC7C7U19"},//		842
	{"5CGXFC7D6F27"},//		843
	{"5CGXFC7D6F31"},//		844
	{"5CGXFC7D7F27"},//		845
	{"5CGXFC7D7F31"},//		846
	{"5CGXFC9C6F23"},//		847
	{"5CGXFC9C7F23"},//		848
	{"5CGXFC9D6F27"},//		849
	{"5CGXFC9D7F27"},//		850
	{"5CGXFC9E6F31"},//		851
	{"5CGXFC9E6F35"},//		852
	{"5CGXFC9E7F31"},//		853
	{"5CGXFC9E7F35"},//		854
	{"5CSEBA5U19"},//		855
	{"5CSEBA5U23"},//		856
	{"5CSEBA6U19"},//		857
	{"5CSEBA6U23"},//		858
	{"5CSEMA5F31"},//		859
	{"5CSEMA5U23"},//		860
	{"5CSEMA6F31"},//		861
	{"5CSEMA6U23"},//		862
	{"5CSTFD5D5F31"},//		863
	{"5CSTFD6D5F31"},//		864
	{"5CSXFC5C6U23"},//		865
	{"5CSXFC5D6F31"},//		866
	{"5CSXFC6C6U23"},//		867
	{"5CSXFC6D6F31"}///*end of CYCLONE V *///	868
	};


unsigned int device_info[MAX_DEV_LIST][4] = {
/* Device,        Idcode,   Max      Conf_done Instruction */
/*                          JTAG     JTAG      Length      */
/*                          Sequence,Sequence,             */ 
/* ACEX 1K */
	/* 10F256     */ {0x110100DD, 146, 146, 10},	//0
	/* 10Q208     */ {0x110100DD, 146, 146, 10},	//1
	/* 10T100     */ {0x110100DD, 146, 146, 10},	//2
	/* 10T144     */ {0x110100DD, 146, 146, 10},	//3
	/* 30F256     */ {0x110300DD, 230, 230, 10},	//4
	/* 30Q208     */ {0x110300DD, 230, 230, 10},	//5
	/* 30T144     */ {0x110300DD, 230, 230, 10},	//6
	/* 50F256     */ {0x110500DD, 266, 266, 10},	//7
	/* 50F484     */ {0x110500DD, 266, 266, 10},	//8
	/* 50Q208     */ {0x110500DD, 266, 266, 10},	//9
	/* 50T144     */ {0x110500DD, 266, 266, 10},	//10
	/* 100F256    */ {0x201000DD, 350, 350, 10},	//11
	/* 100F484    */ {0x201000DD, 350, 350, 10},	//12
	/* 100Q208    */ {0x201000DD, 350, 350, 10},	//13
/* APEX II */
	/* 15B724     */ {0xC4000DD, 508, 191, 10},		//14
	/* 15F672     */ {0xC4000DD, 508, 191, 10},		//15
	/* 25B724     */ {0xC6000DD, 628, 251, 10},		//16
	/* 25F672     */ {0xC6000DD, 628, 251, 10},		//17
	/* 25F1020    */ {0xC6000DD, 628, 251, 10},		//18
	/* 40B724     */ {0xD0000DD, 776, 293, 10},		//19
	/* 40F672     */ {0xD0000DD, 776, 293, 10},		//20
	/* 40F1020    */ {0xD0000DD, 776, 293, 10},		//21
	/* 70B724     */ {0xE0000DD, 1076, 443, 10},	//22
	/* 70F1508    */ {0XE0000DD, 1076, 443, 10},	//23
/* APEX 20K */
	/* 100B356    */ {0x04160DD, 262, 98, 10},		//24
	/* 100F324    */ {0x04160DD, 262, 98, 10},		//25
	/* 100Q208    */ {0x04160DD, 262, 98, 10},		//26
	/* 100Q240    */ {0x04160DD, 262, 98, 10},		//27
	/* 100T144    */ {0x04160DD, 262, 98, 10},		//28
	/* 200B356    */ {0x08320DD, 392, 163, 10},		//29
	/* 200F484    */ {0x08320DD, 392, 163, 10},		//30
	/* 200R208    */ {0x08320DD, 392, 163, 10},		//31
	/* 200R240    */ {0x08320DD, 392, 163, 10},		//32
	/* 400B652    */ {0x16640DD, 512, 193, 10},		//33
	/* 400F672    */ {0x16640DD, 512, 193, 10},		//34
/* APEX 20KC */
	/* 200CB356   */ {0x82000DD, 388, 159, 10},		//35
	/* 200CF484   */ {0x82000DD, 388, 159, 10},		//36
	/* 200CQ208   */ {0x82000DD, 388, 159, 10},		//37
	/* 200CQ240   */ {0x82000DD, 388, 159, 10},		//38
	/* 400CB652   */ {0x84000DD, 502, 189, 10},		//39
	/* 400CF672   */ {0x84000DD, 502, 189, 10},		//40
	/* 600CB652   */ {0x84000DD, 602, 239, 10},		//41
	/* 600CF672   */ {0x84000DD, 602, 239, 10},		//42
	/* 600CF33    */ {0x84000DD, 602, 239, 10},		//43
	/* 1000CB652  */ {0x90000DD, 730, 271, 10},		//44
	/* 1000CF672  */ {0x90000DD, 730, 271, 10},		//45
	/* 1000CF33   */ {0x90000DD, 730, 271, 10},		//46
/* APEX 20KE */
	/* 30ET144    */ {0x80300DD, 140, 47, 10},		//47
	/* 60EB356    */ {0x80600DD, 208, 69, 10},		//48
	/* 60EF144    */ {0x80600DD, 208, 69, 10},		//49
	/* 60EF324    */ {0x80600DD, 208, 69, 10},		//50
	/* 60EQ208    */ {0x80600DD, 208, 69, 10},		//51
	/* 60ET144    */ {0x80600DD, 208, 69, 10},		//52
	/* 100EB356   */ {0x81000DD, 258, 94, 10},		//53
	/* 100EF144   */ {0x81000DD, 258, 94, 10},		//54
	/* 100EF324   */ {0x81000DD, 258, 94, 10},		//55
	/* 100EQ208   */ {0x81000DD, 258, 94, 10},		//56
	/* 100EQ240   */ {0x81000DD, 258, 94, 10},		//57
	/* 100ET144   */ {0x81000DD, 258, 94, 10},		//58
	/* 160EB356   */ {0x81600DD, 328, 129, 10},		//59
	/* 160EF484   */ {0x81600DD, 328, 129, 10},		//60
	/* 160EQ208   */ {0x81600DD, 328, 129, 10},		//61
	/* 160EQ240   */ {0x81600DD, 328, 129, 10},		//62
	/* 160ET144   */ {0x81600DD, 328, 129, 10},		//63
	/* 200EB356   */ {0x82000DD, 388, 159, 10},		//64
	/* 200EB652   */ {0x82000DD, 388, 159, 10},		//65
	/* 200EF484   */ {0x82000DD, 388, 159, 10},		//66
	/* 200EF672   */ {0x82000DD, 388, 159, 10},		//67
	/* 200EQ208   */ {0x82000DD, 388, 159, 10},		//68
	/* 200EQ240   */ {0x82000DD, 388, 159, 10},		//69
	/* 300EB652   */ {0x83000DD, 422, 149, 10},		//70
	/* 300EB672   */ {0x83000DD, 422, 149, 10},		//71
	/* 300EQ240   */ {0x83000DD, 422, 149, 10},		//72
	/* 400EB652   */ {0x84000DD, 502, 189, 10},		//73
	/* 400EF672   */ {0x84000DD, 502, 189, 10},		//74
	/* 600EB652   */ {0x84000DD, 602, 239, 10},		//75
	/* 600EF672   */ {0x84000DD, 602, 239, 10},		//76
	/* 600EF33    */ {0x84000DD, 602, 239, 10},		//77
	/* 1000EB652  */ {0x90000DD, 730, 271, 10},		//78
	/* 1000EF672  */ {0x90000DD, 730, 271, 10},		//79
	/* 1000EF33   */ {0x90000DD, 730, 271, 10},		//80
	/* 1500EB652  */ {0x95000DD, 834, 323, 10},		//81
	/* 1500EF33   */ {0x95000DD, 834, 323, 10},		//82
/* FLEX 10KE */
	/* 30EF256    */ {0x110300DD, 230, 230, 10},	//83
	/* 30EF484    */ {0x110300DD, 230, 230, 10},	//84
	/* 30EQ208    */ {0x110300DD, 230, 230, 10},	//85
	/* 30ET144    */ {0x110300DD, 230, 230, 10},	//86
	/* 50EF256    */ {0x110500DD, 266, 266, 10},	//87
	/* 50EQ240    */ {0x110500DD, 266, 266, 10},	//88
	/* 50ET144    */ {0x110500DD, 266, 266, 10},	//89
	/* 50SB356    */ {0x110500DD, 266, 266, 10},	//90
	/* 50SF256    */ {0x110500DD, 266, 266, 10},	//91
	/* 50SF484    */ {0x110500DD, 266, 266, 10},	//92
	/* 50SQ208    */ {0x110500DD, 266, 266, 10},	//93
	/* 50SQ240    */ {0x110500DD, 266, 266, 10},	//94
	/* 50ST144    */ {0x110500DD, 266, 266, 10},	//95
	/* 100EB356   */ {0x201000DD, 350, 350, 10},	//96
	/* 100EF256   */ {0x201000DD, 350, 350, 10},	//97
	/* 100EF484   */ {0x201000DD, 350, 350, 10},	//98
	/* 100EQ208   */ {0x201000DD, 350, 350, 10},	//99
	/* 100EQ240   */ {0x201000DD, 350, 350, 10},	//100
	/* 130EB356   */ {0x101300DD, 436, 436, 10},	//101
	/* 130EB600   */ {0x101300DD, 436, 436, 10},	//102
	/* 130EF484   */ {0x101300DD, 436, 436, 10},	//103
	/* 130EF672   */ {0x101300DD, 436, 436, 10},	//104
	/* 130EQ240   */ {0x101300DD, 436, 436, 10},	//105
	/* 200EB600   */ {0x102000DD, 482, 482, 10},	//106
	/* 200SB356   */ {0x102000DD, 482, 482, 10},	//107
	/* 200SB600   */ {0x102000DD, 482, 482, 10},	//108
	/* 200SF484   */ {0x102000DD, 482, 482, 10},	//109
	/* 200SF672   */ {0x102000DD, 482, 482, 10},	//110
	/* 200SR240   */ {0x102000DD, 482, 482, 10},	//111
/* MERCURY */
	/* 120F484    */ {0x30000DD, 375, 5, 10},		//112
	/* 350F780    */ {0x30010DD, 565, 7, 10},		//113
/* STRATIX */
	/* 10B672     */ {0x20010DD, 439, 391, 10},		//114
	/* 10F484     */ {0x20010DD, 439, 391, 10},		//115
	/* 10F672     */ {0x20010DD, 439, 391, 10},		//116
	/* 10F780     */ {0x20010DD, 439, 391, 10},		//117
	/* 10B672ES   */ {0x20030DD, 439, 391, 10},		//118
	/* 10F484ES   */ {0x20030DD, 439, 391, 10},		//119
	/* 10F672ES   */ {0x20030DD, 439, 391, 10},		//120
	/* 10F780ES   */ {0x20030DD, 439, 391, 10},		//121
	/* 20B672     */ {0x20020DD, 599, 533, 10},		//122
	/* 20F484     */ {0x20020DD, 599, 533, 10},		//123
	/* 20F672     */ {0x20020DD, 599, 533, 10},		//124
	/* 20F780     */ {0x20020DD, 599, 533, 10},		//125
	/* 25B672     */ {0x20030DD, 719, 635, 10},		//126
	/* 25F672     */ {0x20030DD, 719, 635, 10},		//127
	/* 25F780     */ {0x20030DD, 719, 635, 10},		//128
	/* 25F1020    */ {0x20030DD, 719, 635, 10},		//129
	/* 30B956     */ {0x20040DD, 751, 667, 10},		//130
	/* 30F780     */ {0x20040DD, 751, 667, 10},		//131
	/* 30F1020    */ {0x20040DD, 751, 667, 10},		//132
	/* 40B956     */ {0x20050DD, 843, 741, 10},		//133
	/* 40F780	  */ {0x20050DD, 843, 741, 10},		//134
	/* 40F1020    */ {0x20050DD, 843, 741, 10},		//135
	/* 40F1508    */ {0x20050DD, 843, 741, 10},		//136
	/* 60B956     */ {0x20060DD, 1043, 923, 10},	//137
	/* 60F1020    */ {0x20060DD, 1043, 923, 10},	//138
	/* 60F1508    */ {0x20060DD, 1043, 923, 10},	//139
	/* 80B956     */ {0x20070DD, 1259, 1121, 10},	//140
	/* 80F1020    */ {0x20070DD, 1259, 1121, 10},	//141
	/* 80F1508    */ {0x20070DD, 1259, 1121, 10},	//142
/* CYCLONE */	
	/* 20F324	  */ {0x20840DD, 310, 197, 10},		//143
	/* 20F400	  */ {0x20840DD, 310, 197, 10},		//144
	/* 12F256	  */ {0x20830DD, 258, 163, 10},		//145
	/* 12F324	  */ {0x20830DD, 258, 163, 10},		//146
	/* 12Q240	  */ {0x20830DD, 258, 163, 10},		//147
	/* 6F256	  */ {0x20820DD, 194, 121, 10},		//148
	/* 6Q240	  */ {0x20820DD, 194, 121, 10},		//149
	/* 6T144	  */ {0x20820DD, 194, 121, 10},		//150
	/* 4F400	  */ {0x20850DD, 310, 198, 10},		//151
	/* 4F324	  */ {0x20850DD, 310, 198, 10},		//152
	/* 3T100	  */ {0x20810DD, 113, 69, 10},		//153
	/* 3T144	  */ {0x20810DD, 113, 69, 10},		//154
/* STRATIX GX */
	/* 1SGX40     */ {0x20450DD, 647, 545, 10},		//155
	/* 1SGX25     */ {0x20430DD, 555, 471, 10},		//156
	/* 1SGX10	  */ {0x20410DD, 343, 295, 10},		//157
/* STRATIX II ES*/
	/* 2S60F484ES */ {0x20930DD, 732, 731, 10},		//158
	/* 2S60F672ES */ {0x20930DD, 732, 731, 10},		//159
	/* 2S60F1020ES*/ {0x20930DD, 732, 731, 10},		//160
/* STRATIX II */
	/* 2S15F484 */   {0x20910DD, 380, 379, 10},		//161
	/* 2S15F672 */   {0x20910DD, 380, 379, 10},		//162
	/* 2S30F484 */   {0x20920DD, 564, 563, 10},		//163
	/* 2S30F672 */   {0x20920DD, 564, 563, 10},		//164
	/* 2S60F484 */   {0x120930DD,732, 731, 10},		//165
	/* 2S60F672 */   {0x120930DD,732, 731, 10},		//166
	/* 2S60F1020*/   {0x120930DD,732, 731, 10},		//167
	/* 2S90F1020*/   {0x20940DD, 916, 915, 10},		//168
	/* 2S90F1508*/   {0x20940DD, 916, 915, 10},		//169
	/* 2S130F1020*/  {0x20950DD, 1140,1139,10},		//170
	/* 2S130F1508*/  {0x20950DD, 1140,1139,10},		//171
	/* 2S180F1020*/  {0x20960DD, 1316,1315,10},		//172
	/* 2S180F1508*/  {0x20960DD, 1316,1315,10},		//173
/* CYCLONE II */
	/* 2C35F484 */   {0x20B40DD, 483, 296, 10},		//174
	/* 2C35F672 */   {0x20B40DD, 483, 296, 10}, 	//175
	/* 2C5T144	*/	 {0x20B10DD, 166,  97, 10},		//176
	/* 2C5Q208	*/	 {0x20B10DD, 166,  97, 10},		//177	
	/* 2C5F256	*/	 {0x20B10DD, 166,  97, 10},		//178	
	/* 2C8T144	*/	 {0x20B20DD, 199, 119, 10},		//179
	/* 2C8Q208	*/	 {0x20B20DD, 199, 119, 10},		//180	
	/* 2C8F256	*/	 {0x20B20DD, 199, 119, 10},		//181	
	/* 2C15F256	*/	 {0x20B30DD, 323, 193, 10},		//182
	/* 2C15F484	*/	 {0x20B30DD, 323, 193, 10},		//183
	/* 2C20Q240	*/	 {0x20B30DD, 323, 193, 10},		//184
	/* 2C20F256	*/	 {0x20B30DD, 323, 193, 10},		//185
	/* 2C20F484	*/	 {0x20B30DD, 323, 193, 10},		//186
	/* 2C50F484	*/	 {0x20B50DD, 458, 280, 10},		//187	
	/* 2C50F672	*/	 {0x20B50DD, 458, 280, 10},		//188
	/* 2C70F672	*/	 {0x20B60DD, 630, 391, 10},		//189
	/* 2C70F896	*/	 {0x20B60DD, 630, 391, 10},		//190
/* BYPASS_DEVICE */
/* BYPASS_DEV10  */	 {0x0000000, 000, 000, 10},		//191		//Bypass device with 10-bit Instruction Length
/* STRATIX II GX */
	/* 2SGX30F780 */ {0x20E10DD, 564, 563, 10},		//192
	/* 2SGX60F780 */ {0x20E20DD, 732, 731, 10},		//193
	/* 2SGX60F1152*/ {0x20E20DD, 732, 731, 10},		//194
	/* 2SGX90F1152*/ {0x20E30DD, 672, 671, 10},		//195
	/* 2SGX90F1508*/ {0x20E30DD, 672, 671, 10},		//196
	/* 2SGX130F1508*/{0x20E40DD, 816, 815, 10},		//197
/* CYCLONE III */
	/* 3C25F324*/    {0x20F30DD, 244, 149, 10},			//198
	/* 3C25E144*/	 {0x20F30DD, 244, 149, 10},			//199
	/* 3C25Q240*/	 {0x20F30DD, 244, 149, 10},			//200
	/* 3C25F256*/    {0x20F30DD, 244, 149, 10},			//201
	/* 3C25U256*/    {0x20F30DD, 244, 149, 10},			//202
	/* 3C5E144*/	 {0x20F10DD, 201, 126, 10},			//203
	/* 3C5F256*/	 {0x20F10DD, 201, 126, 10},			//204
	/* 3C5U256*/ 	 {0x20F10DD, 201, 126, 10},			//205
	/* 3C10E144*/    {0x20F10DD, 201, 126, 10},			//206
	/* 3C10F256*/    {0x20F10DD, 201, 126, 10},			//207
	/* 3C10U256*/    {0x20F10DD, 201, 126, 10},			//208
	/* 3C16E144*/    {0x20F20DD, 360, 224, 10},			//209
	/* 3C16Q240*/    {0x20F20DD, 360, 224, 10},			//210
	/* 3C16F256*/    {0x20F20DD, 360, 224, 10},			//211
	/* 3C16U256*/    {0x20F20DD, 360, 224, 10},			//212
	/* 3C16F484*/    {0x20F20DD, 360, 224, 10},			//213
	/* 3C16U484*/    {0x20F20DD, 360, 224, 10},			//214
	/* 3C40Q240*/    {0x20F40DD, 544, 343, 10},			//215
	/* 3C40F324*/    {0x20F40DD, 544, 343, 10},			//216
	/* 3C40F484*/    {0x20F40DD, 544, 343, 10},			//217
	/* 3C40U484*/    {0x20F40DD, 544, 343, 10},			//218
	/* 3C40U780*/    {0x20F40DD, 544, 343, 10},			//219
	/* 3C55F484*/    {0x20F50DD, 388, 241, 10},			//220
	/* 3C55U484*/    {0x20F50DD, 388, 241, 10},			//221
	/* 3C55U780*/    {0x20F50DD, 388, 241, 10},			//222
	/* 3C80F484*/    {0x20F60DD, 438, 271, 10},			//223
	/* 3C80U484*/    {0x20F60DD, 438, 271, 10},			//224
	/* 3C80F780*/    {0x20F60DD, 438, 271, 10},			//225
	/* 3C120F484*/   {0x20F70DD, 540, 336, 10},			//226
	/* 3C120F780*/   {0x20F70DD, 540, 336, 10},			//227
/* ARRIA GX */
	/* 1AGX20F484*/   {0x21210DD, 440, 439, 10},		//228
	/* 1AGX20F780*/   {0x21210DD, 440, 439, 10},		//229
	/* 1AGX35F484*/   {0x21210DD, 440, 439, 10},		//230
	/* 1AGX35F780*/   {0x21210DD, 440, 439, 10},		//231
	/* 1AGX50F484*/   {0x21220DD, 556, 555, 10},		//232
	/* 1AGX50F780*/   {0x21220DD, 556, 555, 10},		//233
	/* 1AGX50F1152*/  {0x21220DD, 556, 555, 10},		//234
	/* 1AGX60F484*/   {0x21220DD, 556, 555, 10},		//235
	/* 1AGX60F780*/   {0x21220DD, 556, 555, 10},		//236
	/* 1AGX60F1152*/  {0x21220DD, 556, 555, 10},		//237
	/* 1AGX90F1152*/  {0x21230DD, 672, 671, 10}, 		//238
/* STRATIX III */
	/* EP3SL50F484*/  {0x21080DD, 502, 122, 10},		//239
	/* EP3SL50F780*/  {0x21080DD, 502, 122, 10},		//240
	/* EP3SL70F484*/  {0x21010DD, 502, 122, 10},		//241
	/* EP3SL70F780*/  {0x21010DD, 502, 122, 10},		//242
	/* EP3SL110F780*/ {0x21090DD, 758, 186, 10},		//243
	/* EP3SL110F1152*/{0x21090DD, 758, 186, 10},		//244
	/* EP3SL150F780*/ {0x21020DD, 758, 186, 10},		//245
	/* EP3SL150F1152*/{0x21020DD, 758, 186, 10},		//246
	/* EP3SL200F780*/ {0x21030DD, 894, 190, 10},		//247
	/* EP3SL200F1152*/{0x21030DD, 894, 190, 10},		//248
	/* EP3SL200F1517*/{0x21030DD, 894, 190, 10}, 		//249
	/* EP3SL340F1152*/{0x21050DD,1134, 278, 10},		//250
	/* EP3SL340F1517*/{0x21050DD,1134, 278, 10},		//251
	/* EP3SL340F1760*/{0x21050DD,1134, 278, 10},		//252
	/* EP3SE50F484*/  {0x21060DD, 502, 122, 10},		//253
	/* EP3SE50F780*/  {0x21060DD, 502, 122, 10},		//254
	/* EP3SE80F780*/  {0x210A0DD, 502, 122, 10},		//255
	/* EP3SE80F1152*/ {0x210A0DD, 502, 122, 10},		//256
	/* EP3SE110F780*/ {0x21070DD, 758, 186, 10},		//257
	/* EP3SE110F1152*/{0x21070DD, 758, 186, 10},		//258
	/* EP3SE260F780*/ {0x21040DD, 990, 238, 10},		//259
	/* EP3SE260F1152*/{0x21040DD, 990, 238, 10}, 		//260
	/* EP3SE260F1517*/{0x21040DD, 990, 238, 10}, 		//261
/* STRATIX IV*/
	/*EP4SGX70DF29*/  {0x24200DD, 438, 122, 10},		//262
	/*EP4SGX70DF35*/  {0x24200DD, 438, 122, 10},		//263
	/*EP4SGX110DF29*/ {0x24000DD, 438, 122, 10},		//264
	/*EP4SGX110FF35*/ {0x24000DD, 438, 122, 10},		//265
	/*EP4SGX180DF29*/ {0x24210DD, 758, 186, 10},		//266
	/*EP4SGX180FF35*/ {0x24210DD, 758, 186, 10},		//267
	/*EP4SGX180HF35*/ {0x24210DD, 758, 186, 10},		//268
	/*EP4SGX180FF40*/ {0x24210DD, 758, 186, 10},		//269
	/*EP4SGX230DF29*/ {0x24090DD, 758, 186, 10},		//270
	/*EP4SGX230FF35*/ {0x24090DD, 758, 186, 10},		//271
	/*EP4SGX230HF35*/ {0x24090DD, 758, 186, 10},		//272
	/*EP4SGX230KF40*/ {0x24090DD, 758, 186, 10},		//273
	/*EP4SGX290FH29*/ {0x24220DD, 894, 190, 10},		//274
	/*EP4SGX290FF35*/ {0x24220DD, 894, 190, 10},		//275
	/*EP4SGX290HF35*/ {0x24220DD, 894, 190, 10},		//276
	/*EP4SGX290KF40*/ {0x24220DD, 894, 190, 10},		//277
	/*EP4SGX290KF43*/ {0x24220DD, 894, 190, 10},		//278
	/*EP4SGX290NF45*/ {0x24430DD, 990, 238, 10},		//279
	/*EP4SGX360FF29*/ {0x24020DD, 894, 190, 10},		//280
	/*EP4SGX360FF35*/ {0x24020DD, 894, 190, 10},		//281
	/*EP4SGX360HF35*/ {0x24020DD, 894, 190, 10},		//282
	/*EP4SGX360KF40*/ {0x24020DD, 894, 190, 10},		//283
	/*EP4SGX360KF43*/ {0x24020DD, 894, 190, 10},		//284
	/*EP4SGX360NF45*/ {0x24830DD, 990, 238, 10},		//285
	/*EP4SGX530HH35*/ {0x24030DD, 990, 238, 10},		//286
	/*EP4SGX530KH40*/ {0x24030DD, 990, 238, 10},		//287
	/*EP4SGX530KF43*/ {0x24030DD, 990, 238, 10},		//288
	/*EP4SGX530NF45*/ {0x24030DD, 990, 238, 10},		//289
	/*EP4SE110F29*/   {0x24100DD, 438, 122, 10},		//290
	/*EP4SE230F29*/   {0x24110DD, 758, 186, 10},		//291
	/*EP4SE290F29*/   {0x24420DD, 894, 190, 10},		//292
	/*EP4SE290F35*/   {0x24420DD, 894, 190, 10},		//293
	/*EP4SE290F40*/   {0x24420DD, 894, 190, 10},		//294
	/*EP4SE360F29*/   {0x24120DD, 894, 190, 10},		//295
	/*EP4SE360F35*/   {0x24120DD, 894, 190, 10},		//296
	/*EP4SE360F40*/   {0x24120DD, 894, 190, 10},		//297
	/*EP4SE530H35*/   {0x24130DD, 990, 238, 10},		//298
	/*EP4SE530H40*/   {0x24130DD, 990, 238, 10},		//299
	/*EP4SE530F43*/   {0x24130DD, 990, 238, 10},		//300
	/*EP4SE680F35*/   {0x24040DD, 1134, 278, 10},		//301
	/*EP4SE680F40*/   {0x24040DD, 1134, 278, 10},		//302
	/*EP4SE680F43*/   {0x24040DD, 1134, 278, 10},		//303
	/*EP4S40G2F40*/	  {0x24010DD, 758, 186, 10},		//304
	/*EP4S40G5H40*/   {0x24030DD, 990, 238, 10},		//305
	/*EP4S100G2F40*/  {0x24010DD, 758, 186, 10},		//306
	/*EP4S100G5F40*/  {0x24030DD, 990, 238, 10},		//307
	/*EP4S100G5H45*/  {0x24030DD, 990, 238, 10}, //*end of Stratix IV *///308		
/* Cyclone III LS */
	/*EP3CLS70F484*/ {0x27010DD, 438, 271, 10},		//309
	/*EP3CLS70U484*/ {0x27010DD, 438, 271, 10},		//310
	/*EP3CLS70F780*/ {0x27010DD, 438, 271, 10},		//311
	/*EP3CLS100F484*/{0x27000DD, 438, 271, 10},		//312
	/*EP3CLS100U484*/{0x27000DD, 438, 271, 10},		//313
	/*EP3CLS100F780*/{0x27000DD, 438, 271, 10},		//314
	/*EP3CLS150F484*/{0x27030DD, 438, 271, 10},		//315
	/*EP3CLS150F780*/{0x27030DD, 438, 271, 10},		//316
	/*EP3CLS200F484*/{0x27020DD, 438, 271, 10},		//317
	/*EP3CLS200F780*/{0x27020DD, 438, 271, 10},	///*end of Cyclone III LS *///318
/* Arria II GX */
	/*EP2AGX45CU17*/  {0x25120DD, 433, 42, 10},		//319
	/*EP2AGX45DF25*/  {0x25120DD, 433, 42, 10},		//320
	/*EP2AGX45DF29*/  {0x25120DD, 433, 42, 10},		//321
	/*EP2AGX65CU17*/  {0x25020DD, 433, 42, 10},		//322
	/*EP2AGX65DF25*/  {0x25020DD, 433, 42, 10},		//323
	/*EP2AGX65DF29*/  {0x25020DD, 433, 42, 10},		//324
	/*EP2AGX95DF25*/  {0x25130DD, 525, 62, 10},		//325
	/*EP2AGX95EF29*/  {0x25130DD, 525, 62, 10},		//326
	/*EP2AGX95EF35*/ {0x25130DD, 525, 62, 10},		//327
	/*EP2AGX125DF25*/ {0x25030DD, 525, 62, 10},		//328
	/*EP2AGX125EF29*/ {0x25030DD, 525, 62, 10},		//329
	/*EP2AGX125EF35*/{0x25030DD, 525, 62, 10},		//330
	/*EP2AGX190EF29*/ {0x25140DD, 705, 82, 10},		//331
	/*EP2AGX190FF35*/{0x25140DD, 705, 82, 10},		//332
	/*EP2AGX260EF29*/ {0x25040DD, 705, 82, 10},		//333
	/*EP2AGX260FF35*/{0x25040DD, 705, 82, 10},	///*end of Arria II GX *///334
/* Cyclone IV */
	/*EP4CE6E22*/  {0x20F10DD, 201, 126, 10},		//335
	/*EP4CE6F17*/  {0x20F10DD, 201, 126, 10},		//336
	/*EP4CE10E22*/ {0x20F10DD, 201, 126, 10},		//337
	/*EP4CE10F17*/ {0x20F10DD, 201, 126, 10},		//338
	/*EP4CE15E22*/ {0x20F20DD, 360, 224, 10},		//339
	/*EP4CE15F17*/ {0x20F20DD, 360, 224, 10},		//340
	/*EP4CE15F23*/ {0x20F20DD, 360, 224, 10},		//341
	/*EP4CE22E22*/ {0x20F30DD, 244, 149, 10},		//342
	/*EP4CE22F17*/ {0x20F30DD, 244, 149, 10},		//343
	/*EP4CE30F23*/ {0x20F40DD, 544, 343, 10},		//344
	/*EP4CE30F29*/ {0x20F40DD, 544, 343, 10},		//345
	/*EP4CE40F23*/ {0x20F40DD, 544, 343, 10},		//346
	/*EP4CE40F29*/ {0x20F40DD, 544, 343, 10},		//347
	/*EP4CE55F23*/ {0x20F50DD, 388, 241, 10},		//348
	/*EP4CE55F29*/ {0x20F50DD, 388, 241, 10},		//349
	/*EP4CE75F23*/ {0x20F60DD, 438, 271, 10},		//350
	/*EP4CE75F29*/ {0x20F60DD, 438, 271, 10},		//351
	/*EP4CGX15BF14*/{0x28010DD, 96, 20, 10},		//352
	/*EP4CE115F780*/{0x20F70DD, 540, 336, 10},		//353
	/*EP4CGX15F169*/ {0x28010DD, 96, 20, 10},		//354
	/*EP4CGX15BN11*/ {0x28010DD, 96, 20, 10},		//355
	/*EP4CGX22BF14*/ {0x28120DD, 174, 20, 10},		//356
	/*EP4CGX22CF19*/ {0x28120DD, 174, 20, 10},		//357 
	/*EP4CGX30BF14*/ {0x28020DD, 174, 20, 10},		//358
	/*EP4CGX30CF19*/ {0x28020DD, 174, 20, 10},		//359
	/*EP4CGX30CF23*/ {0x28130DD, 354, 38, 10},		//360 
	/*EP4CGX50CF23*/ {0x28230DD, 354, 38, 10},		//361
	/*EP4CGX50DF27*/ {0x28230DD, 354, 38, 10},		//362
	/*EP4CGX75CF23*/ {0x28030DD, 354, 38, 10},		//363
	/*EP4CGX75DF27*/ {0x28030DD, 354, 38, 10},		//364
	/*EP4CGX110CF23*/{0x28140DD, 516, 37, 10},		//365
	/*EP4CGX110DF27*/{0x28140DD, 516, 37, 10},		//366
	/*EP4CGX110DF31*/{0x28140DD, 516, 37, 10},		//367
	/*EP4CGX150CF23*/{0x28040DD, 516, 37, 10},		//368
	/*EP4CGX150F672*/{0x28040DD, 516, 37, 10},		//369
	/*EP4CGX150DF27*/{0x28040DD, 516, 37, 10},	///*end of Cyclone IV *///	370
/* Stratix V */
	/*5SEE9F45*/ {0x29450DD, 1165, 424, 10},		//371
	/*5SEE9H40*/ {0x29450DD, 1165, 424, 10},		//372
	/*5SEEBF45*/ {0x29250DD, 1165, 424, 10},		//373
	/*5SEEBH40*/ {0x29250DD, 1165, 424, 10},		//374
	/*5SGSED6K1F40*/ {0x29140DD, 1081, 424, 10},		//375
	/*5SGSED6K2F40*/ {0x29140DD, 1081, 424, 10},		//376
	/*5SGSED6K3F40*/ {0x29140DD, 1081, 424, 10},		//377
	/*5SGSED6N1F45*/ {0x29140DD, 1081, 424, 10},		//378
	/*5SGSED6N2F45*/ {0x29140DD, 1081, 424, 10},		//379
	/*5SGSED6N3F45*/ {0x29140DD, 1081, 424, 10},		//380
	/*5SGSED8K1F40*/ {0x29040DD, 1081, 424, 10},		//381
	/*5SGSED8K2F40*/ {0x29040DD, 1081, 424, 10},		//382
	/*5SGSED8K3F40*/ {0x29040DD, 1081, 424, 10},		//383
	/*5SGSED8N1F45*/ {0x29040DD, 1081, 424, 10},		//384
	/*5SGSED8N2F45*/ {0x29040DD, 1081, 424, 10},		//385
	/*5SGSED8N3F45*/ {0x29040DD, 1081, 424, 10},		//386
	/*5SGSMD3E1H29*/ {0x29110DD, 777, 328, 10},		//387
	/*5SGSMD3E2H29*/ {0x29110DD, 777, 328, 10},		//388
	/*5SGSMD3E3H29*/ {0x29110DD, 777, 328, 10},		//389
	/*5SGSMD3H1F35*/ {0x29110DD, 777, 328, 10},		//390
	/*5SGSMD3H2F35*/ {0x29110DD, 777, 328, 10},		//391
	/*5SGSMD3H3F35*/ {0x29110DD, 777, 328, 10},		//392
	/*5SGSMD4E1H29*/ {0x29010DD, 777, 328, 10},		//393
	/*5SGSMD4E2H29*/ {0x29010DD, 777, 328, 10},		//394
	/*5SGSMD4E3H29*/ {0x29010DD, 777, 328, 10},		//395
	/*5SGSMD4H1F35*/ {0x29010DD, 777, 328, 10},		//396
	/*5SGSMD4H2F35*/ {0x29010DD, 777, 328, 10},		//397
	/*5SGSMD4H3F35*/ {0x29010DD, 777, 328, 10},		//398
	/*5SGSMD4K1F40*/ {0x29170DD, 1025, 424, 10},		//399
	/*5SGSMD4K2F40*/ {0x29170DD, 1025, 424, 10},		//400
	/*5SGSMD4K3F40*/ {0x29170DD, 1025, 424, 10},		//401
	/*5SGSMD5H1F35*/ {0x29070DD, 1025, 424, 10},		//402
	/*5SGSMD5H2F35*/ {0x29070DD, 1025, 424, 10},		//403
	/*5SGSMD5H3F35*/ {0x29070DD, 1025, 424, 10},		//404
	/*5SGSMD5K1F40*/ {0x29070DD, 1025, 424, 10},		//405
	/*5SGSMD5K2F40*/ {0x29070DD, 1025, 424, 10},		//406
	/*5SGSMD5K3F40*/ {0x29070DD, 1025, 424, 10},		//407
	/*5SGSMD6K1F40*/ {0x29140DD, 1081, 424, 10},		//408
	/*5SGSMD6K2F40*/ {0x29140DD, 1081, 424, 10},		//409
	/*5SGSMD6K3F40*/ {0x29140DD, 1081, 424, 10},		//410
	/*5SGSMD6N1F45*/ {0x29140DD, 1081, 424, 10},		//411
	/*5SGSMD6N2F45*/ {0x29140DD, 1081, 424, 10},		//412
	/*5SGSMD6N3F45*/ {0x29140DD, 1081, 424, 10},		//413
	/*5SGSMD8K1F40*/ {0x29040DD, 1081, 424, 10},		//414
	/*5SGSMD8K2F40*/ {0x29040DD, 1081, 424, 10},		//415
	/*5SGSMD8K3F40*/ {0x29040DD, 1081, 424, 10},		//416
	/*5SGSMD8N1F45*/ {0x29040DD, 1081, 424, 10},		//417
	/*5SGSMD8N2F45*/ {0x29040DD, 1081, 424, 10},		//418
	/*5SGSMD8N3F45*/ {0x29040DD, 1081, 424, 10},		//419
	/*5SGTMC5K2F40*/ {0x29230DD, 1081, 424, 10},		//420
	/*5SGTMC5K3F40*/ {0x29230DD, 1081, 424, 10},		//421
	/*5SGTMC7K2F40*/ {0x29430DD, 1081, 424, 10},		//422
	/*5SGTMC7K3F40*/ {0x29430DD, 1081, 424, 10},		//423
	/*5SGXEA3H1F35*/ {0x29210DD, 777, 328, 10},		//424
	/*5SGXEA3H2F35*/ {0x29210DD, 777, 328, 10},		//425
	/*5SGXEA3H3F35*/ {0x29210DD, 777, 328, 10},		//426
	/*5SGXEA3K1F35*/ {0x29210DD, 777, 328, 10},		//427
	/*5SGXEA3K1F40*/ {0x29470DD, 1025, 424, 10},		//428
	/*5SGXEA3K2F35*/ {0x29210DD, 777, 328, 10},		//429
	/*5SGXEA3K2F40*/ {0x29470DD, 1025, 424, 10},		//430
	/*5SGXEA3K3F35*/ {0x29210DD, 777, 328, 10},		//431
	/*5SGXEA3K3F40*/ {0x29470DD, 1025, 424, 10},		//432
	/*5SGXEA4H1F35*/ {0x29270DD, 1025, 424, 10},		//433
	/*5SGXEA4H2F35*/ {0x29270DD, 1025, 424, 10},		//434
	/*5SGXEA4H3F35*/ {0x29270DD, 1025, 424, 10},		//435
	/*5SGXEA4K1F35*/ {0x29270DD, 1025, 424, 10},		//436
	/*5SGXEA4K1F40*/ {0x29270DD, 1025, 424, 10},		//437
	/*5SGXEA4K2F35*/ {0x29270DD, 1025, 424, 10},		//438
	/*5SGXEA4K2F40*/ {0x29270DD, 1025, 424, 10},		//439
	/*5SGXEA4K3F35*/ {0x29270DD, 1025, 424, 10},		//440
	/*5SGXEA4K3F40*/ {0x29270DD, 1025, 424, 10},		//441
	/*5SGXEA5H1F35*/ {0x29130DD, 1081, 424, 10},		//442
	/*5SGXEA5H2F35*/ {0x29130DD, 1081, 424, 10},		//443
	/*5SGXEA5H3F35*/ {0x29130DD, 1081, 424, 10},		//444
	/*5SGXEA5K1F35*/ {0x29130DD, 1081, 424, 10},		//445
	/*5SGXEA5K1F40*/ {0x29130DD, 1081, 424, 10},		//446
	/*5SGXEA5K2F35*/ {0x29130DD, 1081, 424, 10},		//447
	/*5SGXEA5K2F40*/ {0x29130DD, 1081, 424, 10},		//448
	/*5SGXEA5K3F35*/ {0x29130DD, 1081, 424, 10},		//449
	/*5SGXEA5K3F40*/ {0x29130DD, 1081, 424, 10},		//450
	/*5SGXEA5N1F40*/ {0x29130DD, 1081, 424, 10},		//451
	/*5SGXEA5N1F45*/ {0x29130DD, 1081, 424, 10},		//452
	/*5SGXEA5N2F40*/ {0x29130DD, 1081, 424, 10},		//453
	/*5SGXEA5N2F45*/ {0x29130DD, 1081, 424, 10},		//454
	/*5SGXEA5N3F40*/ {0x29130DD, 1081, 424, 10},		//455
	/*5SGXEA5N3F45*/ {0x29130DD, 1081, 424, 10},		//456
	/*5SGXEA7H1F35*/ {0x29030DD, 1081, 424, 10},		//457
	/*5SGXEA7H2F35*/ {0x29030DD, 1081, 424, 10},		//458
	/*5SGXEA7H3F35*/ {0x29030DD, 1081, 424, 10},		//459
	/*5SGXEA7K1F35*/ {0x29030DD, 1081, 424, 10},		//460
	/*5SGXEA7K1F40*/ {0x29030DD, 1081, 424, 10},		//461
	/*5SGXEA7K2F35*/ {0x29030DD, 1081, 424, 10},		//462
	/*5SGXEA7K2F40*/ {0x29030DD, 1081, 424, 10},		//463
	/*5SGXEA7K3F35*/ {0x29030DD, 1081, 424, 10},		//464
	/*5SGXEA7K3F40*/ {0x29030DD, 1081, 424, 10},		//465
	/*5SGXEA7N1F40*/ {0x29030DD, 1081, 424, 10},		//466
	/*5SGXEA7N1F45*/ {0x29030DD, 1081, 424, 10},		//467
	/*5SGXEA7N2F40*/ {0x29030DD, 1081, 424, 10},		//468
	/*5SGXEA7N2F45*/ {0x29030DD, 1081, 424, 10},		//469
	/*5SGXEA7N3F40*/ {0x29030DD, 1081, 424, 10},		//470
	/*5SGXEA7N3F45*/ {0x29030DD, 1081, 424, 10},		//471
	/*5SGXEA9K1H40*/ {0x29150DD, 1165, 424, 10},		//472
	/*5SGXEA9K2H40*/ {0x29150DD, 1165, 424, 10},		//473
	/*5SGXEA9K3H40*/ {0x29150DD, 1165, 424, 10},		//474
	/*5SGXEA9N1F45*/ {0x29150DD, 1165, 424, 10},		//475
	/*5SGXEA9N2F45*/ {0x29150DD, 1165, 424, 10},		//476
	/*5SGXEA9N3F45*/ {0x29150DD, 1165, 424, 10},		//477
	/*5SGXEABK1H40*/ {0x29050DD, 1165, 424, 10},		//478
	/*5SGXEABK2H40*/ {0x29050DD, 1165, 424, 10},		//479
	/*5SGXEABK3H40*/ {0x29050DD, 1165, 424, 10},		//480
	/*5SGXEABN1F45*/ {0x29050DD, 1165, 424, 10},		//481
	/*5SGXEABN2F45*/ {0x29050DD, 1165, 424, 10},		//482
	/*5SGXEABN3F45*/ {0x29050DD, 1165, 424, 10},		//483
	/*5SGXEB5R1F40*/ {0x29120DD, 925, 304, 10},		//484
	/*5SGXEB5R1F43*/ {0x29120DD, 925, 304, 10},		//485
	/*5SGXEB5R2F40*/ {0x29120DD, 925, 304, 10},		//486
	/*5SGXEB5R2F43*/ {0x29120DD, 925, 304, 10},		//487
	/*5SGXEB5R3F40*/ {0x29120DD, 925, 304, 10},		//488
	/*5SGXEB5R3F43*/ {0x29120DD, 925, 304, 10},		//489
	/*5SGXEB6R1F40*/ {0x29020DD, 925, 304, 10},		//490
	/*5SGXEB6R1F43*/ {0x29020DD, 925, 304, 10},		//491
	/*5SGXEB6R2F40*/ {0x29020DD, 925, 304, 10},		//492
	/*5SGXEB6R2F43*/ {0x29020DD, 925, 304, 10},		//493
	/*5SGXEB6R3F40*/ {0x29020DD, 925, 304, 10},		//494
	/*5SGXEB6R3F43*/ {0x29020DD, 925, 304, 10},		//495
	/*5SGXEB9R1H43*/ {0x29150DD, 1165, 424, 10},		//496
	/*5SGXEB9R2H43*/ {0x29150DD, 1165, 424, 10},		//497
	/*5SGXEB9R3H43*/ {0x29150DD, 1165, 424, 10},		//498
	/*5SGXEBBR1H43*/ {0x29050DD, 1165, 424, 10},		//499
	/*5SGXEBBR2H43*/ {0x29050DD, 1165, 424, 10},		//500
	/*5SGXEBBR3H43*/ {0x29050DD, 1165, 424, 10},		//501
	/*5SGXMA3E1H29*/ {0x29210DD, 777, 328, 10},		//502
	/*5SGXMA3E2H29*/ {0x29210DD, 777, 328, 10},		//503
	/*5SGXMA3E3H29*/ {0x29210DD, 777, 328, 10},		//504
	/*5SGXMA3H1F35*/ {0x29210DD, 777, 328, 10},		//505
	/*5SGXMA3H2F35*/ {0x29210DD, 777, 328, 10},		//506
	/*5SGXMA3H3F35*/ {0x29210DD, 777, 328, 10},		//507
	/*5SGXMA3K1F35*/ {0x29210DD, 777, 328, 10},		//508
	/*5SGXMA3K1F40*/ {0x29470DD, 1025, 424, 10},		//509
	/*5SGXMA3K2F35*/ {0x29210DD, 777, 328, 10},		//510
	/*5SGXMA3K2F40*/ {0x29470DD, 1025, 424, 10},		//511
	/*5SGXMA3K3F35*/ {0x29210DD, 777, 328, 10},		//512
	/*5SGXMA3K3F40*/ {0x29470DD, 1025, 424, 10},		//513
	/*5SGXMA4H1F35*/ {0x29270DD, 1025, 424, 10},		//514
	/*5SGXMA4H2F35*/ {0x29270DD, 1025, 424, 10},		//515
	/*5SGXMA4H3F35*/ {0x29270DD, 1025, 424, 10},		//516
	/*5SGXMA4K1F35*/ {0x29270DD, 1025, 424, 10},		//517
	/*5SGXMA4K1F40*/ {0x29270DD, 1025, 424, 10},		//518
	/*5SGXMA4K2F35*/ {0x29270DD, 1025, 424, 10},		//519
	/*5SGXMA4K2F40*/ {0x29270DD, 1025, 424, 10},		//520
	/*5SGXMA4K3F35*/ {0x29270DD, 1025, 424, 10},		//521
	/*5SGXMA4K3F40*/ {0x29270DD, 1025, 424, 10},		//522
	/*5SGXMA5H1F35*/ {0x29130DD, 1081, 424, 10},		//523
	/*5SGXMA5H2F35*/ {0x29130DD, 1081, 424, 10},		//524
	/*5SGXMA5H3F35*/ {0x29130DD, 1081, 424, 10},		//525
	/*5SGXMA5K1F35*/ {0x29130DD, 1081, 424, 10},		//526
	/*5SGXMA5K1F40*/ {0x29130DD, 1081, 424, 10},		//527
	/*5SGXMA5K2F35*/ {0x29130DD, 1081, 424, 10},		//528
	/*5SGXMA5K2F40*/ {0x29130DD, 1081, 424, 10},		//529
	/*5SGXMA5K3F35*/ {0x29130DD, 1081, 424, 10},		//530
	/*5SGXMA5K3F40*/ {0x29130DD, 1081, 424, 10},		//531
	/*5SGXMA5N1F40*/ {0x29130DD, 1081, 424, 10},		//532
	/*5SGXMA5N1F45*/ {0x29130DD, 1081, 424, 10},		//533
	/*5SGXMA5N2F40*/ {0x29130DD, 1081, 424, 10},		//534
	/*5SGXMA5N2F45*/ {0x29130DD, 1081, 424, 10},		//535
	/*5SGXMA5N3F40*/ {0x29130DD, 1081, 424, 10},		//536
	/*5SGXMA5N3F45*/ {0x29130DD, 1081, 424, 10},		//537
	/*5SGXMA7H1F35*/ {0x29030DD, 1081, 424, 10},		//538
	/*5SGXMA7H2F35*/ {0x29030DD, 1081, 424, 10},		//539
	/*5SGXMA7H3F35*/ {0x29030DD, 1081, 424, 10},		//540
	/*5SGXMA7K1F35*/ {0x29030DD, 1081, 424, 10},		//541
	/*5SGXMA7K1F40*/ {0x29030DD, 1081, 424, 10},		//542
	/*5SGXMA7K2F35*/ {0x29030DD, 1081, 424, 10},		//543
	/*5SGXMA7K2F40*/ {0x29030DD, 1081, 424, 10},		//544
	/*5SGXMA7K3F35*/ {0x29030DD, 1081, 424, 10},		//545
	/*5SGXMA7K3F40*/ {0x29030DD, 1081, 424, 10},		//546
	/*5SGXMA7N1F40*/ {0x29030DD, 1081, 424, 10},		//547
	/*5SGXMA7N1F45*/ {0x29030DD, 1081, 424, 10},		//548
	/*5SGXMA7N2F40*/ {0x29030DD, 1081, 424, 10},		//549
	/*5SGXMA7N2F45*/ {0x29030DD, 1081, 424, 10},		//550
	/*5SGXMA7N3F40*/ {0x29030DD, 1081, 424, 10},		//551
	/*5SGXMA7N3F45*/ {0x29030DD, 1081, 424, 10},		//552
	/*5SGXMA9K1H40*/ {0x29150DD, 1165, 424, 10},		//553
	/*5SGXMA9K2H40*/ {0x29150DD, 1165, 424, 10},		//554
	/*5SGXMA9K3H40*/ {0x29150DD, 1165, 424, 10},		//555
	/*5SGXMA9N1F45*/ {0x29150DD, 1165, 424, 10},		//556
	/*5SGXMA9N2F45*/ {0x29150DD, 1165, 424, 10},		//557
	/*5SGXMA9N3F45*/ {0x29150DD, 1165, 424, 10},		//558
	/*5SGXMABK1H40*/ {0x29050DD, 1165, 424, 10},		//559
	/*5SGXMABK2H40*/ {0x29050DD, 1165, 424, 10},		//560
	/*5SGXMABK3H40*/ {0x29050DD, 1165, 424, 10},		//561
	/*5SGXMABN1F45*/ {0x29050DD, 1165, 424, 10},		//562
	/*5SGXMABN2F45*/ {0x29050DD, 1165, 424, 10},		//563
	/*5SGXMABN3F45*/ {0x29050DD, 1165, 424, 10},		//564
	/*5SGXMB5R1F40*/ {0x29120DD, 925, 304, 10},		//565
	/*5SGXMB5R1F43*/ {0x29120DD, 925, 304, 10},		//566
	/*5SGXMB5R2F40*/ {0x29120DD, 925, 304, 10},		//567
	/*5SGXMB5R2F43*/ {0x29120DD, 925, 304, 10},		//568
	/*5SGXMB5R3F40*/ {0x29120DD, 925, 304, 10},		//569
	/*5SGXMB5R3F43*/ {0x29120DD, 925, 304, 10},		//570
	/*5SGXMB6R1F40*/ {0x29020DD, 925, 304, 10},		//571
	/*5SGXMB6R1F43*/ {0x29020DD, 925, 304, 10},		//572
	/*5SGXMB6R2F40*/ {0x29020DD, 925, 304, 10},		//573
	/*5SGXMB6R2F43*/ {0x29020DD, 925, 304, 10},		//574
	/*5SGXMB6R3F40*/ {0x29020DD, 925, 304, 10},		//575
	/*5SGXMB6R3F43*/ {0x29020DD, 925, 304, 10},		//576
	/*5SGXMB9R1H43*/ {0x29150DD, 1165, 424, 10},	//577
	/*5SGXMB9R2H43*/ {0x29150DD, 1165, 424, 10},	//578
	/*5SGXMB9R3H43*/ {0x29150DD, 1165, 424, 10},	//579
	/*5SGXMBBR1H43*/ {0x29050DD, 1165, 424, 10},	//580
	/*5SGXMBBR2H43*/ {0x29050DD, 1165, 424, 10},	//581
	/*5SGXMBBR3H43*/ {0x29050DD, 1165, 424, 10},	///*end of Stratix V *///  582
/* Arria V */
	/*5AGTFC7H3F35*/ {0x2A020DD, 560, 554, 10},		//583
	/*5AGTFD3H3F35*/ {0x2A030DD, 720, 714, 10},		//584
	/*5AGTFD3H3F40*/ {0x2A030DD, 720, 714, 10},		//585
	/*5AGTFD7H3F35*/ {0x2A060DD, 720, 714, 10},		//586
	/*5AGTFD7K3F40*/ {0x2A060DD, 720, 714, 10},		//587
	/*5AGTMC3D3F27*/ {0x2A030DD, 720, 714, 10},		//588
	/*5AGTMC3D3F31*/ {0x2A030DD, 720, 714, 10},		//589
	/*5AGTMC7G3F31*/ {0x2A020DD, 560, 554, 10},		//590
	/*5AGTMD3G3F31*/ {0x2A030DD, 720, 714, 10},		//591
	/*5AGXBA1D4F27*/ {0x2A110DD, 496, 490, 10},		//592
	/*5AGXBA1D4F31*/ {0x2A110DD, 496, 490, 10},		//593
	/*5AGXBA1D6F27*/ {0x2A110DD, 496, 490, 10},		//594
	/*5AGXBA1D6F31*/ {0x2A110DD, 496, 490, 10},		//595
	/*5AGXBA3D4F27*/ {0x2A010DD, 496, 490, 10},		//596
	/*5AGXBA3D4F31*/ {0x2A010DD, 496, 490, 10},		//597
	/*5AGXBA3D6F27*/ {0x2A010DD, 496, 490, 10},		//598
	/*5AGXBA3D6F31*/ {0x2A010DD, 496, 490, 10},		//599
	/*5AGXBA5D4F27*/ {0x2A120DD, 560, 554, 10},		//600
	/*5AGXBA5D4F31*/ {0x2A120DD, 560, 554, 10},		//601
	/*5AGXBA5D4F35*/ {0x2A120DD, 560, 554, 10},		//602
	/*5AGXBA5D6F27*/ {0x2A120DD, 560, 554, 10},		//603
	/*5AGXBA5D6F31*/ {0x2A120DD, 560, 554, 10},		//604
	/*5AGXBA5D6F35*/ {0x2A120DD, 560, 554, 10},		//605
	/*5AGXBA7D4F27*/ {0x2A020DD, 560, 554, 10},		//606
	/*5AGXBA7D4F31*/ {0x2A020DD, 560, 554, 10},		//607
	/*5AGXBA7D4F35*/ {0x2A020DD, 560, 554, 10},		//608
	/*5AGXBA7D6F27*/ {0x2A020DD, 560, 554, 10},		//609
	/*5AGXBA7D6F31*/ {0x2A020DD, 560, 554, 10},		//610
	/*5AGXBA7D6F35*/ {0x2A020DD, 560, 554, 10},		//611
	/*5AGXBB1D4F31*/ {0x2A130DD, 720, 714, 10},		//612
	/*5AGXBB1D4F35*/ {0x2A130DD, 720, 714, 10},		//613
	/*5AGXBB1D4F40*/ {0x2A130DD, 720, 714, 10},		//614
	/*5AGXBB1D6F31*/ {0x2A130DD, 720, 714, 10},		//615
	/*5AGXBB1D6F35*/ {0x2A130DD, 720, 714, 10},		//616
	/*5AGXBB1D6F40*/ {0x2A130DD, 720, 714, 10},		//617
	/*5AGXBB3D4F31*/ {0x2A030DD, 720, 714, 10},		//618
	/*5AGXBB3D4F35*/ {0x2A030DD, 720, 714, 10},		//619
	/*5AGXBB3D4F40*/ {0x2A030DD, 720, 714, 10},		//620
	/*5AGXBB3D6F31*/ {0x2A030DD, 720, 714, 10},		//621
	/*5AGXBB3D6F35*/ {0x2A030DD, 720, 714, 10},		//622
	/*5AGXBB3D6F40*/ {0x2A030DD, 720, 714, 10},		//623
	/*5AGXBB5D4F35*/ {0x2A160DD, 720, 714, 10},		//624
	/*5AGXBB5D4F40*/ {0x2A160DD, 720, 714, 10},		//625
	/*5AGXBB5D6F35*/ {0x2A160DD, 720, 714, 10},		//626
	/*5AGXBB5D6F40*/ {0x2A160DD, 720, 714, 10},		//627
	/*5AGXBB7D4F35*/ {0x2A060DD, 720, 714, 10},		//628
	/*5AGXBB7D4F40*/ {0x2A060DD, 720, 714, 10},		//629
	/*5AGXBB7D6F35*/ {0x2A060DD, 720, 714, 10},		//630
	/*5AGXBB7D6F40*/ {0x2A060DD, 720, 714, 10},		//631
	/*5AGXFA5H4F35*/ {0x2A120DD, 560, 554, 10},		//632
	/*5AGXFA5H6F35*/ {0x2A120DD, 560, 554, 10},		//633
	/*5AGXFA7H4F35*/ {0x2A020DD, 560, 554, 10},		//634
	/*5AGXFA7H6F35*/ {0x2A020DD, 560, 554, 10},		//635
	/*5AGXFB1H4F35*/ {0x2A130DD, 720, 714, 10},		//636
	/*5AGXFB1H4F40*/ {0x2A130DD, 720, 714, 10},		//637
	/*5AGXFB1H6F35*/ {0x2A130DD, 720, 714, 10},		//638
	/*5AGXFB1H6F40*/ {0x2A130DD, 720, 714, 10},		//639
	/*5AGXFB3H4F35*/ {0x2A030DD, 720, 714, 10},		//640
	/*5AGXFB3H4F40*/ {0x2A030DD, 720, 714, 10},		//641
	/*5AGXFB3H6F35*/ {0x2A030DD, 720, 714, 10},		//642
	/*5AGXFB3H6F40*/ {0x2A030DD, 720, 714, 10},		//643
	/*5AGXFB5H4F35*/ {0x2A160DD, 720, 714, 10},		//644
	/*5AGXFB5H6F35*/ {0x2A160DD, 720, 714, 10},		//645
	/*5AGXFB5K4F40*/ {0x2A160DD, 720, 714, 10},		//646
	/*5AGXFB5K6F40*/ {0x2A160DD, 720, 714, 10},		//647
	/*5AGXFB7H4F35*/ {0x2A060DD, 720, 714, 10},		//648
	/*5AGXFB7H6F35*/ {0x2A060DD, 720, 714, 10},		//649
	/*5AGXFB7K4F40*/ {0x2A060DD, 720, 714, 10},		//650
	/*5AGXFB7K6F40*/ {0x2A060DD, 720, 714, 10},		//651
	/*5AGXMA1D4F27*/ {0x2A110DD, 496, 490, 10},		//652
	/*5AGXMA1D4F31*/ {0x2A110DD, 496, 490, 10},		//653
	/*5AGXMA1D6F27*/ {0x2A110DD, 496, 490, 10},		//654
	/*5AGXMA1D6F31*/ {0x2A110DD, 496, 490, 10},		//655
	/*5AGXMA3D4F27*/ {0x2A010DD, 496, 490, 10},		//656
	/*5AGXMA3D4F31*/ {0x2A010DD, 496, 490, 10},		//657
	/*5AGXMA3D6F27*/ {0x2A010DD, 496, 490, 10},		//658
	/*5AGXMA3D6F31*/ {0x2A010DD, 496, 490, 10},		//659
	/*5AGXMA5D4F27*/ {0x2A120DD, 560, 554, 10},		//660
	/*5AGXMA5D6F27*/ {0x2A120DD, 560, 554, 10},		//661
	/*5AGXMA5G4F31*/ {0x2A120DD, 560, 554, 10},		//662
	/*5AGXMA5G4F35*/ {0x2A120DD, 560, 554, 10},		//663
	/*5AGXMA5G6F31*/ {0x2A120DD, 560, 554, 10},		//664
	/*5AGXMA5G6F35*/ {0x2A120DD, 560, 554, 10},		//665
	/*5AGXMA7D4F27*/ {0x2A020DD, 560, 554, 10},		//666
	/*5AGXMA7D6F27*/ {0x2A020DD, 560, 554, 10},		//667
	/*5AGXMA7G4F31*/ {0x2A020DD, 560, 554, 10},		//668
	/*5AGXMA7G4F35*/ {0x2A020DD, 560, 554, 10},		//669
	/*5AGXMA7G6F31*/ {0x2A020DD, 560, 554, 10},		//670
	/*5AGXMA7G6F35*/ {0x2A020DD, 560, 554, 10},		//671
	/*5AGXMB1G4F31*/ {0x2A130DD, 720, 714, 10},		//672
	/*5AGXMB1G4F35*/ {0x2A130DD, 720, 714, 10},		//673
	/*5AGXMB1G4F40*/ {0x2A130DD, 720, 714, 10},		//674
	/*5AGXMB1G6F31*/ {0x2A130DD, 720, 714, 10},		//675
	/*5AGXMB1G6F35*/ {0x2A130DD, 720, 714, 10},		//676
	/*5AGXMB1G6F40*/ {0x2A130DD, 720, 714, 10},		//677
	/*5AGXMB3G4F31*/ {0x2A030DD, 720, 714, 10},		//678
	/*5AGXMB3G4F35*/ {0x2A030DD, 720, 714, 10},		//679
	/*5AGXMB3G4F40*/ {0x2A030DD, 720, 714, 10},		//680
	/*5AGXMB3G6F31*/ {0x2A030DD, 720, 714, 10},		//681
	/*5AGXMB3G6F35*/ {0x2A030DD, 720, 714, 10},		//682
	/*5AGXMB3G6F40*/ {0x2A030DD, 720, 714, 10},		//683
	/*5AGXMB5G4F35*/ {0x2A160DD, 720, 714, 10},		//684
	/*5AGXMB5G4F40*/ {0x2A160DD, 720, 714, 10},		//685
	/*5AGXMB5G6F35*/ {0x2A160DD, 720, 714, 10},		//686
	/*5AGXMB5G6F40*/ {0x2A160DD, 720, 714, 10},		//687
	/*5AGXMB7G4F35*/ {0x2A060DD, 720, 714, 10},		//688
	/*5AGXMB7G4F40*/ {0x2A060DD, 720, 714, 10},		//689
	/*5AGXMB7G6F35*/ {0x2A060DD, 720, 714, 10},		//690
	/*5AGXMB7G6F40*/ {0x2A060DD, 720, 714, 10},		//691
	/*5ASTFD3G3F35*/ {0x2D130DD, 823, 817, 10},		//692
	/*5ASTFD3K3F40*/ {0x2D130DD, 823, 817, 10},		//693
	/*5ASTFD5G3F35*/ {0x2D030DD, 823, 817, 10},		//694
	/*5ASTFD5K3F40*/ {0x2D030DD, 823, 817, 10},		//695
	/*5ASTMD3E3F31*/ {0x2D130DD, 823, 817, 10},		//696
	/*5ASTMD5E3F31*/ {0x2D030DD, 823, 817, 10},		//697
	/*5ASXBB3D4F31*/ {0x2D130DD, 823, 817, 10},		//698
	/*5ASXBB3D4F35*/ {0x2D130DD, 823, 817, 10},		//699
	/*5ASXBB3D4F40*/ {0x2D130DD, 823, 817, 10},		//700
	/*5ASXBB3D6F31*/ {0x2D130DD, 823, 817, 10},		//701
	/*5ASXBB3D6F35*/ {0x2D130DD, 823, 817, 10},		//702
	/*5ASXBB3D6F40*/ {0x2D130DD, 823, 817, 10},		//703
	/*5ASXBB5D4F31*/ {0x2D030DD, 823, 817, 10},		//704
	/*5ASXBB5D4F35*/ {0x2D030DD, 823, 817, 10},		//705
	/*5ASXBB5D4F40*/ {0x2D030DD, 823, 817, 10},		//706
	/*5ASXBB5D6F31*/ {0x2D030DD, 823, 817, 10},		//707
	/*5ASXBB5D6F35*/ {0x2D030DD, 823, 817, 10},		//708
	/*5ASXBB5D6F40*/ {0x2D030DD, 823, 817, 10},		//709
	/*5ASXFB3G4F35*/ {0x2D130DD, 823, 817, 10},		//710
	/*5ASXFB3G6F35*/ {0x2D130DD, 823, 817, 10},		//711
	/*5ASXFB3H4F40*/ {0x2D130DD, 823, 817, 10},		//712
	/*5ASXFB3H6F40*/ {0x2D130DD, 823, 817, 10},		//713
	/*5ASXFB5G4F35*/ {0x2D030DD, 823, 817, 10},		//714
	/*5ASXFB5G6F35*/ {0x2D030DD, 823, 817, 10},		//715
	/*5ASXFB5H4F40*/ {0x2D030DD, 823, 817, 10},		//716
	/*5ASXFB5H6F40*/ {0x2D030DD, 823, 817, 10},		//717
	/*5ASXMB3E4F31*/ {0x2D130DD, 823, 817, 10},		//718
	/*5ASXMB3E6F31*/ {0x2D130DD, 823, 817, 10},		//719
	/*5ASXMB3G4F40*/ {0x2D130DD, 823, 817, 10},		//720
	/*5ASXMB3G6F40*/ {0x2D130DD, 823, 817, 10},		//721
	/*5ASXMB5E4F31*/ {0x2D030DD, 823, 817, 10},		//722
	/*5ASXMB5E6F31*/ {0x2D030DD, 823, 817, 10},		//723
	/*5ASXMB5G4F40*/ {0x2D030DD, 823, 817, 10},		//724
	/*5ASXMB5G6F40*/ {0x2D030DD, 823, 817, 10},		//725
	/*5AGZME1E2H29*/ {0x29310DD, 777, 328, 10},		//726
	/*5AGZME1E3H29*/ {0x29710DD, 777, 328, 10},		//727
	/*5AGZME1H2F35*/ {0x29310DD, 777, 328, 10},		//728
	/*5AGZME1H3F35*/ {0x29310DD, 777, 328, 10},		//729
	/*5AGZME3E2H29*/ {0x29710DD, 777, 328, 10},		//730
	/*5AGZME3E3H29*/ {0x29710DD, 777, 328, 10},		//731
	/*5AGZME3H2F35*/ {0x29710DD, 777, 328, 10},		//732
	/*5AGZME3H3F35*/ {0x29710DD, 777, 328, 10},		//733
	/*5AGZME5H2F35*/ {0x29770DD, 1025, 424, 10},	//734
	/*5AGZME5H3F35*/ {0x29770DD, 1025, 424, 10},	//735
	/*5AGZME5K2F40*/ {0x29770DD, 1025, 424, 10},	//736
	/*5AGZME5K3F40*/ {0x29770DD, 1025, 424, 10},	//737
	/*5AGZME7H2F35*/ {0x29F70DD, 1025, 424, 10},	//738
	/*5AGZME7H3F35*/ {0x29F70DD, 1025, 424, 10},	//739
	/*5AGZME7K2F40*/ {0x29F70DD, 1025, 424, 10},	//740
	/*5AGZME7K3F40*/ {0x29F70DD, 1025, 424, 10},	///*end of Arria V *///  741
/* CYCLONE V */
	/*5CEBA2F17*/ {0x2B150DD, 288, 234, 10},		//742
	/*5CEBA2F23*/ {0x2B150DD, 288, 234, 10},		//743
	/*5CEBA2U15*/ {0x2B150DD, 288, 234, 10},		//744
	/*5CEBA2U19*/ {0x2B150DD, 288, 234, 10},		//745
	/*5CEBA4F17*/ {0x2B050DD, 288, 234, 10},		//746
	/*5CEBA4F23*/ {0x2B050DD, 288, 234, 10},		//747
	/*5CEBA4U15*/ {0x2B050DD, 288, 234, 10},		//748
	/*5CEBA4U19*/ {0x2B050DD, 288, 234, 10},		//749
	/*5CEBA5F23*/ {0x2B220DD, 368, 362, 10},		//750
	/*5CEBA5U19*/ {0x2B220DD, 368, 362, 10},		//751
	/*5CEBA7F23*/ {0x2B130DD, 496, 490, 10},		//752
	/*5CEBA7F27*/ {0x2B130DD, 496, 490, 10},		//753
	/*5CEBA7F31*/ {0x2B130DD, 496, 490, 10},		//754
	/*5CEBA7U19*/ {0x2B130DD, 496, 490, 10},		//755
	/*5CEBA9F23*/ {0x2B140DD, 576, 570, 10},		//756
	/*5CEBA9F27*/ {0x2B140DD, 576, 570, 10},		//757
	/*5CEBA9F31*/ {0x2B140DD, 576, 570, 10},		//758
	/*5CEFA2F17*/ {0x2B150DD, 288, 234, 10},		//759
	/*5CEFA2F23*/ {0x2B150DD, 288, 234, 10},		//760
	/*5CEFA2U15*/ {0x2B150DD, 288, 234, 10},		//761
	/*5CEFA2U19*/ {0x2B150DD, 288, 234, 10},		//762
	/*5CEFA4F17*/ {0x2B050DD, 288, 234, 10},		//763
	/*5CEFA4F23*/ {0x2B050DD, 288, 234, 10},		//764
	/*5CEFA4U15*/ {0x2B050DD, 288, 234, 10},		//765
	/*5CEFA4U19*/ {0x2B050DD, 288, 234, 10},		//766
	/*5CEFA5F23*/ {0x2B220DD, 368, 362, 10},		//767
	/*5CEFA5U19*/ {0x2B220DD, 368, 362, 10},		//768
	/*5CEFA7F23*/ {0x2B130DD, 496, 490, 10},		//769
	/*5CEFA7F27*/ {0x2B130DD, 496, 490, 10},		//770
	/*5CEFA7F31*/ {0x2B130DD, 496, 490, 10},		//771
	/*5CEFA7U19*/ {0x2B130DD, 496, 490, 10},		//772
	/*5CEFA9F23*/ {0x2B140DD, 576, 570, 10},		//773
	/*5CEFA9F27*/ {0x2B140DD, 576, 570, 10},		//774
	/*5CEFA9F31*/ {0x2B140DD, 576, 570, 10},		//775
	/*5CGTFD5C5F23*/ {0x2B020DD, 368, 362, 10},		//776
	/*5CGTFD5C5F27*/ {0x2B020DD, 368, 362, 10},		//777
	/*5CGTFD5C5U19*/ {0x2B020DD, 368, 362, 10},		//778
	/*5CGTFD7C5F23*/ {0x2B030DD, 496, 490, 10},		//779
	/*5CGTFD7C5U19*/ {0x2B030DD, 496, 490, 10},		//780
	/*5CGTFD7D5F27*/ {0x2B030DD, 496, 490, 10},		//781
	/*5CGTFD7D5F31*/ {0x2B030DD, 496, 490, 10},		//782
	/*5CGTFD9C5F23*/ {0x2B040DD, 576, 570, 10},		//783
	/*5CGTFD9D5F27*/ {0x2B040DD, 576, 570, 10},		//784
	/*5CGTFD9E5F31*/ {0x2B040DD, 576, 570, 10},		//785
	/*5CGTFD9E5F35*/ {0x2B040DD, 576, 570, 10},		//786
	/*5CGXBC3B6F23*/ {0x2B010DD, 240, 234, 10},		//787
	/*5CGXBC3B6U15*/ {0x2B010DD, 240, 234, 10},		//788
	/*5CGXBC3B6U19*/ {0x2B010DD, 240, 234, 10},		//789
	/*5CGXBC3B7F23*/ {0x2B010DD, 240, 234, 10},		//790
	/*5CGXBC3B7U15*/ {0x2B010DD, 240, 234, 10},		//791
	/*5CGXBC3B7U19*/ {0x2B010DD, 240, 234, 10},		//792
	/*5CGXBC4C6F23*/ {0x2B120DD, 368, 362, 10},		//793
	/*5CGXBC4C6F27*/ {0x2B120DD, 368, 362, 10},		//794
	/*5CGXBC4C6U19*/ {0x2B120DD, 368, 362, 10},		//795
	/*5CGXBC4C7F23*/ {0x2B120DD, 368, 362, 10},		//796
	/*5CGXBC4C7F27*/ {0x2B120DD, 368, 362, 10},		//797
	/*5CGXBC4C7U19*/ {0x2B120DD, 368, 362, 10},		//798
	/*5CGXBC5C6F23*/ {0x2B020DD, 368, 362, 10},		//799
	/*5CGXBC5C6F27*/ {0x2B020DD, 368, 362, 10},		//800
	/*5CGXBC5C6U19*/ {0x2B020DD, 368, 362, 10},		//801
	/*5CGXBC5C7F23*/ {0x2B020DD, 368, 362, 10},		//802
	/*5CGXBC5C7F27*/ {0x2B020DD, 368, 362, 10},		//803
	/*5CGXBC5C7U19*/ {0x2B020DD, 368, 362, 10},		//804
	/*5CGXBC7C6F23*/ {0x2B030DD, 496, 490, 10},		//805
	/*5CGXBC7C6U19*/ {0x2B030DD, 496, 490, 10},		//806
	/*5CGXBC7C7F23*/ {0x2B030DD, 496, 490, 10},		//807
	/*5CGXBC7C7U19*/ {0x2B030DD, 496, 490, 10},		//808
	/*5CGXBC7D6F27*/ {0x2B030DD, 496, 490, 10},		//809
	/*5CGXBC7D6F31*/ {0x2B030DD, 496, 490, 10},		//810
	/*5CGXBC7D7F27*/ {0x2B030DD, 496, 490, 10},		//811
	/*5CGXBC7D7F31*/ {0x2B030DD, 496, 490, 10},		//812
	/*5CGXBC9C6F23*/ {0x2B040DD, 576, 570, 10},		//813
	/*5CGXBC9C7F23*/ {0x2B040DD, 576, 570, 10},		//814
	/*5CGXBC9D6F27*/ {0x2B040DD, 576, 570, 10},		//815
	/*5CGXBC9D7F27*/ {0x2B040DD, 576, 570, 10},		//816
	/*5CGXBC9E6F31*/ {0x2B040DD, 576, 570, 10},		//817
	/*5CGXBC9E6F35*/ {0x2B040DD, 576, 570, 10},		//818
	/*5CGXBC9E7F31*/ {0x2B040DD, 576, 570, 10},		//819
	/*5CGXBC9E7F35*/ {0x2B040DD, 576, 570, 10},		//820
	/*5CGXFC3B6F23*/ {0x2B010DD, 240, 234, 10},		//821
	/*5CGXFC3B6U15*/ {0x2B010DD, 240, 234, 10},		//822
	/*5CGXFC3B6U19*/ {0x2B010DD, 240, 234, 10},		//823
	/*5CGXFC3B7F23*/ {0x2B010DD, 240, 234, 10},		//824
	/*5CGXFC3B7U15*/ {0x2B010DD, 240, 234, 10},		//825
	/*5CGXFC3B7U19*/ {0x2B010DD, 240, 234, 10},		//826
	/*5CGXFC4C6F23*/ {0x2B120DD, 368, 362, 10},		//827
	/*5CGXFC4C6F27*/ {0x2B120DD, 368, 362, 10},		//828
	/*5CGXFC4C6U19*/ {0x2B120DD, 368, 362, 10},		//829
	/*5CGXFC4C7F23*/ {0x2B120DD, 368, 362, 10},		//830
	/*5CGXFC4C7F27*/ {0x2B120DD, 368, 362, 10},		//831
	/*5CGXFC4C7U19*/ {0x2B120DD, 368, 362, 10},		//832
	/*5CGXFC5C6F23*/ {0x2B020DD, 368, 362, 10},		//833
	/*5CGXFC5C6F27*/ {0x2B020DD, 368, 362, 10},		//834
	/*5CGXFC5C6U19*/ {0x2B020DD, 368, 362, 10},		//835
	/*5CGXFC5C7F23*/ {0x2B020DD, 368, 362, 10},		//836
	/*5CGXFC5C7F27*/ {0x2B020DD, 368, 362, 10},		//837
	/*5CGXFC5C7U19*/ {0x2B020DD, 368, 362, 10},		//838
	/*5CGXFC7C6F23*/ {0x2B030DD, 496, 490, 10},		//839
	/*5CGXFC7C6U19*/ {0x2B030DD, 496, 490, 10},		//840
	/*5CGXFC7C7F23*/ {0x2B030DD, 496, 490, 10},		//841
	/*5CGXFC7C7U19*/ {0x2B030DD, 496, 490, 10},		//842
	/*5CGXFC7D6F27*/ {0x2B030DD, 496, 490, 10},		//843
	/*5CGXFC7D6F31*/ {0x2B030DD, 496, 490, 10},		//844
	/*5CGXFC7D7F27*/ {0x2B030DD, 496, 490, 10},		//845
	/*5CGXFC7D7F31*/ {0x2B030DD, 496, 490, 10},		//846
	/*5CGXFC9C6F23*/ {0x2B040DD, 576, 570, 10},		//847
	/*5CGXFC9C7F23*/ {0x2B040DD, 576, 570, 10},		//848
	/*5CGXFC9D6F27*/ {0x2B040DD, 576, 570, 10},		//849
	/*5CGXFC9D7F27*/ {0x2B040DD, 576, 570, 10},		//850
	/*5CGXFC9E6F31*/ {0x2B040DD, 576, 570, 10},		//851
	/*5CGXFC9E6F35*/ {0x2B040DD, 576, 570, 10},		//852
	/*5CGXFC9E7F31*/ {0x2B040DD, 576, 570, 10},		//853
	/*5CGXFC9E7F35*/ {0x2B040DD, 576, 570, 10},		//854
	/*5CSEBA5U19*/ {0x2D120DD, 495, 489, 10},		//855
	/*5CSEBA5U23*/ {0x2D120DD, 495, 489, 10},		//856
	/*5CSEBA6U19*/ {0x2D020DD, 495, 489, 10},		//857
	/*5CSEBA6U23*/ {0x2D020DD, 495, 489, 10},		//858
	/*5CSEMA5F31*/ {0x2D120DD, 495, 489, 10},		//859
	/*5CSEMA5U23*/ {0x2D120DD, 495, 489, 10},		//860
	/*5CSEMA6F31*/ {0x2D020DD, 495, 489, 10},		//861
	/*5CSEMA6U23*/ {0x2D020DD, 495, 489, 10},		//862
	/*5CSTFD5D5F31*/ {0x2D120DD, 495, 489, 10},		//863
	/*5CSTFD6D5F31*/ {0x2D020DD, 495, 489, 10},		//864
	/*5CSXFC5C6U23*/ {0x2D120DD, 495, 489, 10},		//865
	/*5CSXFC5D6F31*/ {0x2D120DD, 495, 489, 10},		//866
	/*5CSXFC6C6U23*/ {0x2D020DD, 495, 489, 10},		//867
	/*5CSXFC6D6F31*/ {0x2D020DD, 495, 489, 10}		///*end of CYCLONE V *///  868
	};

#endif

















