' BREAK/SPACE
' By @Blerkotron
' (C)2017, Blerkotronic Software
' For ZX Spectrum BASIC Jam (https://itch.io/jam/zx-spectrum-basic-jam)
' Version 1.5, ZX BASIC port (https://www.boriel.com/en/software/the-zx-basic-compiler/)
' Check for updates at https://blerkotron.itch.io/breakspace

' If compiling yourself, use the following options:
' zxb Break-Space.bas -t -B -a --array-base=1 --string-base=1 --strict-bool --explicit -O2 -S24576

#include <string.bas> 
#include <alloc.bas>

'constants
const DEBUGMODE as ubyte = 0

'variables
dim result, fuel, redraw, shipy, shipx, my, mx, oldx, oldy, race, maxshld, kv as ubyte
dim zsize, posn, n, weight, tc, rc, i, miss, maxmiss, maxfuel, by, mptr, bo, z as ubyte
dim rx, ry, att, maxdef, drv, found, act, amiss, dam, bink, pmax, pnum as ubyte
dim bdrv, batt, aact, rep, maxweight, ml, q, mxpos, mypos, qx, msize, sl as ubyte
dim mf, mi, mz, oo, zx, zy, zt, mmi as ubyte
dim rv, def, adef, shld, ashld as byte
dim time, mdata, cash, oldcash, pprice, pk as uinteger
dim k$, st$, zed$, cee$, mm$ as string
dim pmod as float

'arrays
DIM m(10,20) as ubyte
DIM a(6) as ubyte
DIM d(6) as ubyte
DIM g(6) as ubyte
DIM h(6) as ubyte
DIM b(6) as ubyte
DIM s(6) as ubyte
DIM r(6) as ubyte
DIM name$(6) as string
DIM zz(20) as ubyte
DIM qq(20) as ubyte
DIM t(20) as ubyte
DIM pee$(20) as string
DIM e(6) as ubyte
DIM c(3) as ubyte
DIM w(4,2) as ubyte
DIM o$(6) as string
dim msgbuf(14) as string
dim inkbuf(14) as ubyte

'start
goto 6

'load data for fonts, graphics, messages, etc.
#include "BinaryData.bas"
#include "Messages.bas"


' -----------------------------------------------------------------------------
' Decompress (from source to destination address) data that was previously
' compressed using ZX7. This is the smallest version of the ZX7 decompressor.
'
' Parameters:
'     src: source address (compressed data)
'     dst: destination address (decompressing)
' -----------------------------------------------------------------------------
sub FASTCALL dzx7Standard(src as UINTEGER, dst as UINTEGER)
    asm
        pop bc          ; RET address
        pop de          ; DE=dst
        push bc         ; restore RET address
#include "dzx7_standard.asm"
    end asm
end sub

sub initarrays()
	pee$(1)="nok"
	pee$(2)="fra"
	pee$(3)="gog"
	pee$(4)="frak"
	pee$(5)="tut"
	pee$(6)="zex"
	pee$(7)="gal"
	pee$(8)="shun"
	pee$(9)="ren"
	pee$(10)="kal"
	pee$(11)="sun"
	pee$(12)="xox"
	pee$(13)="yen"
	pee$(14)="soo"
	pee$(15)="arc"
	pee$(16)="qir"
	pee$(17)="oon"
	pee$(18)="tak"
	pee$(19)="raak"
	pee$(20)="wyk"
	o$(1)="Investigate"
	o$(2)="Destroy"
	o$(3)="Ignore"
	o$(4)="Enter"
	o$(5)="Probe"
	o$(6)="Retrieve"
end sub

'for debug purposes
sub printmem()

	'do nothing if switched off
	if DEBUGMODE <> 1 then
		return
	end if

	dim f, m as uinteger
	f = memavail
	m = maxavail
	print at 22,0; ink 7; paper 1; flash 1;str$(f);" ";at 22,15;str$(m);" "
end sub

'read a single message 0-terminated message from a memory location into the msgbuf array
function readMsg(mptr as uinteger, mbp as ubyte) as uinteger
	dim mbyte as ubyte
	dim tempstr as string
	
	'clear buffer
	tempstr = ""
	
	'read first byte
	mbyte = peek mptr
	
	'loop until zero
	do while mbyte <> 0
	
		'load char into buffer
		tempstr = tempstr + chr$(mbyte)
		
		'increase pointer and read again
		mptr = mptr+1
		mbyte = peek mptr
	loop
	
	'write temp string to buffer
	msgbuf(mbp) = tempstr
	
	'increase mptr one more time and return
	mptr = mptr + 1
	return mptr
	
end function

'read a number of messages from a memory location into the msgbuf array
sub readMsgBuf(mptr as uinteger, mlen as ubyte)
	dim mbp as ubyte
	
	'loop through mlen times
	for mbp = 1 to mlen
	
		'read next message
		mptr = readMsg(mptr, mbp)
		
	next mbp
end sub

'read a number of ink colours and messages from a memory location into the inkbuf/msgbuf arrays
sub readColourMsgBuf(mptr as uinteger, mlen as ubyte)
	dim mbp as ubyte
	
	'loop through mlen times
	for mbp = 1 to mlen
	
		'ink first
		inkbuf(mbp) = peek(mptr)
		
		'message next
		mptr = readMsg(mptr + 1, mbp)
	
	next mbp
	
end sub

'set UDG bank
sub setUDGbank(num as ubyte)
	dim addr as uinteger
	
	'choose bank
	if num = 1 then
		addr = @UDGS
	else
		addr = @UDGS2
	end if
	
	'set udg pointer
	POKE 23675, addr-((int(addr/256))*256)
	POKE 23676, int(addr/256)
	
end sub

'pause replacement
sub wait(ms as uinteger)

	'wait for pressed key to be released
	do
	loop until inkey$ = ""
	
	'and then pause
	pause ms
	
end sub

'slow things down a bit, machine code is FAST
sub doHalt()
	dim p as uinteger

	for p = 1 to 1000
	next p

end sub

'capitalise a string
function capitalise(srcstr as string) as string

	'sanity check
	if len(srcstr) < 1 then
		return srcstr
	end if

	'get the first character and capitalise
	dim capstr as string
	capstr = ucase(srcstr(1 to 1))

	'and add the rest
	if len(srcstr) > 1 then
		capstr = capstr + srcstr(2 to)
	end if

	'done
	return capstr

end function

'funky menu animations while it waits for you to press a key
sub animatemenu()
	dim mi(6) as ubyte
	dim n, si, d, dx as ubyte

	'init colours
	si = 1
	for n = 1 to 6
		mi(n) = n
	next n

	'wait for key up
	do loop until inkey$ = ""

	'animate
	d = 1
	dx = 1
	do while inkey$ = ""

		'delay
		d = d - 1
		if d = 0 then
				
			'characters
			for n = 1 to 6
				print at 2,8+(2*n); ink mi(n); chr$(152 + n)
				mi(n) = mi(n) + 1
				if mi(n) > 7 then
					mi(n) = 1
				end if
			next n
			
			'reset delay
			d = 80

		end if

		'delay 2
		dx = dx - 1
		if dx = 0 then

			'start message
			print at 21,5; ink si; "PRESS ANY KEY TO START"
			si = si + 1
			if si > 7 then
				si = 1
			end if
		
			'reset delay 2
			dx = 30

		end if

	loop

end sub

'animated 'any key to start' message
sub animatestart()
	dim si, d as ubyte
	si = 1
	d = 1

	'wait for key up
	do loop until inkey$ = ""

	'print message
	do while inkey$ = ""

		'delay
		d = d - 1
		if d = 0 then

			'print message 
			print at 20,5; ink si; "Press any key to start"
			si = si + 1
			if si > 7 then
				si = 1
			end if

			'reset delay
			d = 50
			
		end if
	loop

end sub

'animated 'game over' message with optional 'you win'
function animategameover(result as ubyte) as string
	dim si(3) as ubyte
	dim spx(3) as ubyte
	dim spy(3) as ubyte
	dim sm(3) as string
	dim kp as string
	dim d, st, lp as ubyte

	'initial colours
	for lp = 1 to 3
		si(lp) = (lp - 1) * 3
	next lp

	'initial delay
	d = 1

	'possible messages and their coordinates
	spy(1) = 15
	spx(1) = 8
	sm(1) = "CONGRATULATIONS!"
	spy(2) = 16
	spx(2) = 3
	sm(2) = "You are on your way home!"
	spy(3) = 18
	spx(3) = 11
	sm(3) = "GAME OVER"

	'print one message or three?
	st = 3
	if result = 0 then
		st = 1
	end if

	'wait for key up
	do loop until inkey$ = ""

	'print message(s)
	kp = inkey$
	do while kp = ""
	
		'delay
		d = d - 1
		if d = 0 then

			for lp = st to 3
			
				'print message(s)
				print paper 2; ink si(lp); at spy(lp), spx(lp); sm(lp)

				'next colour
				si(lp) = si(lp) + 1
				if si(lp) > 7 then
					si(lp) = 0
				elseif si(lp) = 2 then
					si(lp) = 3
				end if

			next lp

			'reset delay
			d = 50

		end if

		'read keyboard again
		kp = inkey$

	loop

	'return key pressed
	return kp

end function

'original source code starts here, with a few modifications for ZX Basic compatibility
'and a few bug fixes over the last BASIC-only version (specifically the mission bug, which
'prevented most of the missions from working as intended).

   5 REM one-time setup
   6 POKE 23658,8: POKE 23739,244: GO SUB 9900: GO SUB 9850
  10 BORDER 0: PAPER 0: INK 7: BRIGHT 1: FLASH 0: INVERSE 0: RANDOMIZE : CLS

  29 REM menu
  30 GO SUB 9600
  
  99 REM init game
 100 CLS : GO SUB 7800: PRINT AT 18,6; INK 5;"Building Universe..."; INK 1;AT 20,9; INK 1;"\g \g \g \g \g \g \g"
 105 GO SUB 9000: print at 18,6; ink 5; "Universe Complete...": animatestart()
 110 GO SUB 9400: GO SUB 8700
 
 199 REM play game
 200 LET result=99
 210 LET redraw=1: GO SUB 1000
 220 GO SUB 8600
 230 IF result=0 THEN PRINT AT 15,8; PAPER 2; INK 7; "CONGRATULATIONS!"; INK 7; AT 16,3;"You are on your way home!": BEEP .1,10: BEEP .1,15: BEEP .1,20: END IF
 240 IF result=1 THEN PRINT AT 15,3; PAPER 2; INK 7;"Ship fatally compromised,";AT 16,7;"all hope is lost.": END IF
 250 IF result=2 THEN PRINT AT 15,4; PAPER 2; INK 7;"The wormhole has closed,";AT 16,3;"you can never return home.": END IF
 260 IF result=3 THEN PRINT AT 15,3; PAPER 2; INK 7;"Your ship is out of fuel,";AT 16,7;"all hope is lost.": END IF
 265 IF result<>0 THEN BEEP .1,20: BEEP .1,10: BEEP .1,0: END IF
 
 299 REM game over
 300 PRINT AT 18,11; PAPER 2; INK 6;"GAME OVER"; INK 5;AT 20,6;"SPACE to reveal map";AT 21,5;"or any key to continue"
 310 k$ = animategameover(result)
 320 IF k$<>" " THEN GO TO 995: END IF
 
 989 REM reveal
 990 GO SUB 8600: GO SUB 8800: PRINT AT 18,9; PAPER 2; INK 5;"Press any key": GO SUB 9500
 
 994 REM back to menu
 995 GO TO 30
 
 999 REM main game loop
1000 printmem(): IF result<>99 THEN RETURN: END IF
1005 IF time<=0 THEN LET result=2: RETURN: END IF
1006 IF fuel<=0 THEN LET result=3: RETURN: END IF
1010 IF redraw<>0 THEN LET mdata=@MSG1: GO SUB 8650: LET redraw=0: END IF
1030 LET k$=INKEY$: IF k$<>"5" AND k$<>"6" AND k$<>"7" AND k$<>"8" AND k$<>"Q" AND k$<>"A" AND k$<>"O" AND k$<>"P" AND k$<>" " THEN GO TO 1030: END IF
1040 GO SUB 1500: REM tick
1050 IF k$<>" " THEN GO SUB 1600: END IF: REM move ship
1100 LET posn=m(shipy,shipx)
1110 IF posn>0 AND posn<8 THEN GO SUB 2000: GO TO 1200: END IF: REM planet
1120 IF posn>10 AND posn<17 THEN GO SUB 3000: GO TO 1200: END IF: REM alien
1130 IF posn=100 THEN GO SUB 4000: GO TO 1200: END IF: REM mission
1140 IF posn=200 THEN GO SUB 5000: GO TO 1200: END IF: REM piece
1150 IF posn=201 THEN GO SUB 5500: GO TO 1200: END IF: REM wormhole
1200 IF posn<>0 THEN LET redraw=1: END IF
1490 GO TO 1000

1499 REM wait
1500 LET time=time-1: GO SUB 8730
1510 IF shld<maxshld THEN LET shld=shld+1: GO SUB 8701: END IF
1520 RETURN

1599 REM move ship
1600 LET oldx=shipx: LET oldy=shipy
1610 IF (k$="5" or k$="O") AND shipx>1 THEN LET shipx=shipx-1: GO TO 1650: END IF
1620 IF (k$="8" or k$="P") AND shipx<20 THEN LET shipx=shipx+1: GO TO 1650: END IF
1630 IF (k$="7" or k$="Q") AND shipy>1 THEN LET shipy=shipy-1: GO TO 1650: END IF
1640 IF (k$="6" or k$="A") AND shipy<10 THEN LET shipy=shipy+1: END IF
1650 IF shipx=oldx AND shipy=oldy THEN RETURN: END IF
1655 doHalt()	
1660 LET mx=oldx: LET my=oldy: GO SUB 8900
1670 LET mx=shipx: LET my=shipy: GO SUB 8900: BEEP .01,20
1680 LET fuel=fuel-1: GO SUB 8710
1690 RETURN

1999 REM planet
2000 IF m(shipy,shipx)=7 THEN GO TO 2400: END IF
2010 LET race=m(shipy,shipx): LET zed$="planet": GO SUB 8200
2020 IF r(race)<8 THEN GO TO 2080: END IF
2030 LET n=INT (RND*100)+1
2040 IF n>((r(race)-7)*25) THEN GO TO 2070: END IF

2049 REM fight
2050 LET mdata=@MSG10: GO SUB 8660: GO SUB 9500: LET tc=2: GO SUB 6000
2060 RETURN

2069 REM flee
2070 LET mdata=@MSG9: GO SUB 8660: GO SUB 9500: RETURN

2079 REM trade
2080 LET oldcash=cash: LET mdata=@MSG8: GO SUB 8660
2085 GO SUB 9500: IF k$<>"1" AND k$<>"2" THEN GO TO 2085: END IF
2086 IF k$="2" THEN RETURN: END IF
2090 GO SUB 6500: LET shld=maxshld: GO SUB 8710
2095 LET time=time-5: IF time<0 THEN LET time=0: END IF
2096 GO SUB 8730
2097 IF oldcash<>cash THEN LET rc=10: LET rv=-1: GO SUB 8100: GO SUB 8110: END IF
2098 RETURN

2399 REM uninhabited planet
2400 LET mdata=@MSG6: GO SUB 8650
2410 GO SUB 9500: IF k$<>"1" AND k$<>"2" THEN GO TO 2410: END IF
2420 IF k$="2" THEN RETURN: END IF
2430 LET i=INT (RND*10)+1: LET time=time-i: IF time<0 THEN LET time=0: END IF
2440 LET n=INT (RND*10)+1: IF weight+n>50 THEN LET n=50-weight: END IF
2445 LET c(3)=c(3)+n: LET weight=weight+n
2450 IF shld<maxshld THEN LET shld=shld+i: IF shld>maxshld THEN LET shld=maxshld: END IF: END IF
2460 LET mdata=@MSG7: GO SUB 8650
2470 PRINT AT 19,4; PAPER 2; INK 7;n;" tons of minerals mined";AT 20,10;"in ";i;" hours.": BEEP .01,10
2480 GO SUB 8730: GO SUB 8710: GO SUB 8740: GO SUB 9500
2490 RETURN

2999 REM alien ship
3000 LET race=m(shipy,shipx)-10: LET zed$="ship": GO SUB 8200
3010 IF r(race)<6 THEN GO TO 3050: END IF
3020 LET n=INT (RND*100)+1: IF ((r(race)=6 AND n>10) OR (r(race)=7 AND n>40)) THEN GO TO 3050: END IF

3029 REM attack
3030 LET mdata=@MSG18: GO SUB 8660: GO SUB 9500: LET rc=100: LET rv=1: GO SUB 8100: GO SUB 8110: LET tc=2: GO SUB 6000
3040 RETURN

3049 REM menu
3050 LET mdata=@MSG19: GO SUB 8660
3054 GO SUB 9500
3055 IF k$>="1" AND k$<="3" THEN GO TO 3060: END IF
3056 GO TO 3054
3060 IF k$="3" THEN RETURN: END IF
3070 IF k$="1" THEN GO SUB 3100: RETURN: END IF
3080 LET tc=1: GO SUB 6000: RETURN

3099 REM hail ship
3100 LET oldcash=cash: LET n=INT (RND*100)+1
3110 IF n<=33 THEN LET mdata=@MSG20: GO TO 3400: END IF
3120 IF n<=66 THEN GO TO 3300: END IF

3199 REM buy
3200 LET n=INT (RND*3)+1: LET i=INT (RND*3)+3
3210 LET mdata=@MSG21: GO SUB 8650
3220 LET st$="`"+STR$ (25*i)+" for "+STR$ (i)
3221 IF n=1 THEN LET st$=st$+"\r": END IF
3222 IF n=2 THEN LET st$=st$+"\s": END IF
3223 IF n=3 THEN LET st$=st$+"\q": END IF
3224 PRINT AT 18,(32-LEN (st$))/2; PAPER 2; INK 3+n;st$: BEEP .01,10
3225 LET mdata=@MSG22: GO SUB 8660
3230 GO SUB 9500: IF k$<>"1" AND k$<>"2" THEN GO TO 3230: END IF
3235 IF k$="2" THEN LET mdata=@MSG24: GO TO 3400: END IF
3240 IF c(n)>=i THEN LET c(n)=c(n)-i: LET weight=weight-i: LET cash=cash+(i*25): GO SUB 8720: GO SUB 8740: LET mdata=@MSG23: GO TO 3400: END IF
3250 LET mdata=@MSG27: GO SUB 8650: LET mdata=@MSG24: GO TO 3405

3299 REM sell
3300 LET n=INT (RND*2)+1: LET i=INT (RND*3)+2
3305 IF n=2 THEN LET i=i*2: LET pprice=1: GO TO 3310: END IF
3306 LET pprice=5
3310 LET mdata=@MSG25: GO SUB 8650
3320 LET st$=STR$ (i)
3321 IF n=1 THEN LET st$=st$+" missiles": END IF
3322 IF n=2 THEN LET st$=st$+" fuel": END IF
3324 LET st$=st$+" for `"+STR$ (i*pprice): PRINT AT 18,(32-LEN (st$))/2; PAPER 2; INK 5;st$: BEEP .01,10
3325 LET mdata=@MSG26: GO SUB 8660
3330 GO SUB 9500: IF k$<>"1" AND k$<>"2" THEN GO TO 3330: END IF
3340 IF k$="2" THEN LET mdata=@MSG24: GO TO 3400: END IF
3345 IF cash<(pprice*i) THEN LET mdata=@MSG28: GO SUB 8650: LET mdata=@MSG24: GO TO 3405: END IF
3350 IF n=1 THEN LET miss=miss+i: IF miss>maxmiss THEN LET miss=maxmiss: END IF: END IF
3360 IF n=2 THEN LET fuel=fuel+i: IF fuel>maxfuel THEN LET fuel=maxfuel: END IF: END IF
3370 LET cash=cash-(pprice*i): GO SUB 8710: GO SUB 8720: LET mdata=@MSG23
3400 GO SUB 8600
3405 GO SUB 8660: GO SUB 9500: LET m(shipy,shipx)=0: GO SUB 8900
3410 IF oldcash<>cash THEN LET rc=10: LET rv=-1: GO SUB 8100: GO SUB 8110: END IF
3420 RETURN

3999 REM mission
4000 LET by=19: LET mptr=mptr+1: IF mptr>20 THEN LET mptr=1: END IF
4010 IF t(mptr)<=4 THEN GO SUB 4100: GO TO 4020: END IF
4011 IF t(mptr)<=8 THEN GO SUB 4200: GO TO 4020: END IF
4012 IF t(mptr)<=12 THEN GO SUB 4300: GO TO 4020: END IF
4013 IF t(mptr)<=16 THEN GO SUB 4400: GO TO 4020: END IF
4014 GO SUB 4500
4020 LET m(shipy,shipx)=0: GO SUB 8900: GO SUB 8700: RETURN

4099 REM wreck
4100 LET mdata=@MSG31: GO SUB 8650: LET bo=1: GO SUB 4600: LET bo=2: GO SUB 4600: LET bo=3: GO SUB 4600
4110 GO SUB 9500: IF k$<"1" OR k$>"3" THEN GO TO 4110: END IF
4120 LET z=INT (RND*(3-(k$<>"1"))+1)
4130 IF (k$="1" OR k$="2") AND z=1 THEN GO SUB 4610: GO TO 4198: END IF
4135 IF k$="1" AND z=2 THEN GO SUB 4960: GO TO 4198: END IF
4140 IF (k$="1" AND z=3) OR (k$="3" AND z=2) THEN GO SUB 4650: GO TO 4198: END IF
4145 IF k$="2" AND z=2 THEN GO SUB 4900: GO TO 4198: END IF
4150 IF k$="3" AND z=1 THEN GO SUB 4700: GO TO 4198: END IF
4198 RETURN

4199 REM message
4200 LET mdata=@MSG32: GO SUB 8650: LET bo=1: GO SUB 4600: LET bo=3: GO SUB 4600
4210 GO SUB 9500: IF k$<"1" OR k$>"2" THEN GO TO 4210: END IF
4220 LET z=INT (RND*2)+1
4230 IF k$="2" THEN GO SUB 4700: GO TO 4298: END IF
4240 IF z=1 THEN GO SUB 4610: GO TO 4298: END IF
4245 IF z=2 THEN GO SUB 4650: GO TO 4298: END IF
4298 RETURN

4299 REM nebula
4300 LET mdata=@MSG33: GO SUB 8650: LET bo=1: GO SUB 4600: LET bo=3: GO SUB 4600
4310 GO SUB 9500: IF k$<"1" OR k$>"2" THEN GO TO 4310: END IF
4320 LET z=INT (RND*(3-(k$<>"1"))+1)
4330 IF k$="1" AND z=1 THEN GO SUB 4610: GO TO 4398: END IF
4335 IF k$="1" AND z=2 THEN GO SUB 4650: GO TO 4398: END IF
4340 IF k$="1" AND z=3 THEN GO SUB 4800: GO TO 4398: END IF
4345 IF k$="2" AND z=1 THEN GO SUB 4700: GO TO 4398: END IF
4350 IF k$="2" AND z=2 THEN GO SUB 4650: GO TO 4398: END IF
4398 RETURN

4399 REM anomaly
4400 LET mdata=@MSG34: GO SUB 8650: LET bo=4: GO SUB 4600: LET bo=5: GO SUB 4600: LET bo=3: GO SUB 4600
4410 GO SUB 9500: IF k$<"1" OR k$>"3" THEN GO TO 4410: END IF
4420 LET z=INT (RND*3)+1
4425 IF k$="3" THEN GO SUB 4700: GO TO 4498: END IF
4430 IF k$="1" AND z=1 THEN GO SUB 4850: GO TO 4498: END IF
4435 IF (k$="1" AND z=2) OR (k$="2" AND z=1) THEN GO SUB 4610: GO TO 4498: END IF
4440 IF (k$="1" AND z=3) OR (k$="2" AND z=2) THEN GO SUB 4900: GO TO 4498: END IF
4445 IF k$="2" AND z=3 THEN GO SUB 4950: GO TO 4498: END IF
4498 RETURN

4499 REM artifact
4500 LET mdata=@MSG35: GO SUB 8650: LET bo=6: GO SUB 4600: LET bo=5: GO SUB 4600: LET bo=3: GO SUB 4600
4510 GO SUB 9500: IF k$<"1" OR k$>"3" THEN GO TO 4510: END IF
4520 LET z=INT (RND*(3-(k$<>"1"))+1)
4525 IF k$="3" THEN GO SUB 4700: GO TO 4598: END IF
4530 IF k$="1" AND z=1 THEN GO SUB 4960: GO TO 4598: END IF
4535 IF (k$="1" AND z=2) OR (k$="2" AND z=1) THEN GO SUB 4610: GO TO 4598: END IF
4540 IF (k$="1" AND z=3) OR (k$="2" AND z=2) THEN GO SUB 4900: GO TO 4598: END IF
4598 RETURN

4599 REM menu
4600 LET st$=STR$ ((by-18))+". "+o$(bo): PRINT AT by,9; PAPER 2; INK 7;st$: BEEP .0,10: LET by=by+1: RETURN
4605 GO SUB 8650: LET mdata=@MSG30: GO SUB 8660: RETURN
4608 GO SUB 9350: LET my=shipy: LET mx=shipx: LET m(my,mx)=0: LET shipy=ry: LET shipx=rx: GO SUB 8900: LET my=shipy: LET mx=shipx: GO SUB 8900: RETURN

4609 REM stuff
4610 LET mdata=@MSG36: GO SUB 4605: GO SUB 9500
4620 LET z=INT (RND*3)+1: GO SUB 7900
4648 RETURN

4649 REM attack
4650 LET mdata=@MSG37: GO SUB 4605: GO SUB 9500
4660 LET race=INT (RND*6)+1: LET tc=2: GO SUB 6000
4698 RETURN

4699 REM ignore
4700 LET mdata=@MSG38: GO SUB 4605: GO SUB 9500
4748 RETURN

4749 REM destroy
4750 LET mdata=@MSG39: GO SUB 4605: GO SUB 9500
4760 LET z=2: GO SUB 7900
4798 RETURN

4799 REM lost/time
4800 LET mdata=@MSG40: GO SUB 4605
4810 LET time=time-INT (RND*20)+10: IF time<0 THEN LET time=0: END IF
4815 GO SUB 4608
4820 GO SUB 8730: GO SUB 9500
4848 RETURN

4849 REM lost/time+
4850 LET mdata=@MSG41: GO SUB 4605
4860 LET time=time+INT (RND*20)+10
4865 GO SUB 4608
4870 GO SUB 8730: GO SUB 9500
4898 RETURN

4899 REM explosion
4900 LET mdata=@MSG42: GO SUB 4605
4910 LET shld=0: LET def=def-(INT (RND*def)+1): IF def<0 THEN LET def=0: END IF
4911 IF def=0 THEN LET result=1: END IF
4915 GO SUB 8701: GO SUB 8710: GO SUB 9500
4948 RETURN

4949 REM nothing
4950 LET mdata=@MSG43: GO SUB 4605: GO SUB 9500
4958 RETURN

4959 REM upgrade
4960 LET mdata=@MSG44: GO SUB 4605
4962 LET z=INT (RND*6)+1
4970 IF z=1 THEN PRINT AT 19,8; PAPER 2; INK 7;"ATTACK IMPROVED": LET att=att+1: IF att>10 THEN LET att=10: END IF: END IF
4971 IF z=2 THEN PRINT AT 19,8; PAPER 2; INK 7;"DEFENCE IMPROVED": LET maxdef=maxdef+5: IF maxdef>50 THEN LET maxdef=50: END IF: END IF
4972 IF z=3 THEN PRINT AT 19,9; PAPER 2; INK 7;"DRIVE IMPROVED": LET drv=drv+1: IF drv>10 THEN LET drv=10: END IF: END IF
4973 IF z=4 THEN PRINT AT 19,5; PAPER 2; INK 7;"MAX MISSILES INCREASED": LET maxmiss=maxmiss+2: IF maxmiss>30 THEN LET maxmiss=30: END IF: END IF
4974 IF z=5 THEN PRINT AT 19,4; PAPER 2; INK 7;"FUEL CAPACITY INCREASED": LET maxfuel=maxfuel+5: IF maxfuel>80 THEN LET maxfuel=80: END IF: END IF
4975 IF z=6 THEN PRINT AT 19,8; PAPER 2; INK 7;"SHIELDS IMPROVED": LET maxshld=maxshld+5: IF maxshld>30 THEN LET maxshld=30: END IF: END IF
4976 BEEP .01,20
4980 GO SUB 9500
4998 RETURN

4999 REM piece
5000 LET mdata=@MSG2: GO SUB 8650
5010 LET found=found+1: GO SUB 8750
5020 GO SUB 9500
5030 IF found=4 THEN LET mdata=@MSG3: GO SUB 8650: END IF
5040 LET mx=shipx: LET my=shipy: GO SUB 8960
5050 GO SUB 9500: RETURN

5499 REM wormhole
5500 IF found<>4 THEN LET mdata=@MSG4: GO SUB 8650: GO SUB 9500: RETURN: END IF
5510 LET mdata=@MSG5: GO SUB 8650: GO SUB 9500: LET result=0: RETURN

5999 REM battle
6000 LET act=0: GO SUB 8610
6001 IF a(race)>5 THEN LET amiss=INT (RND*3)+8: GO TO 6004: END IF
6002 LET amiss=INT (RND*5)+3
6004 LET adef=d(race): LET ashld=h(race)
6005 GO SUB 8000
6006 IF tc<>1 AND (drv>g(race) OR (INT (RND*10)+1)<=drv) THEN LET tc=1: END IF
6010 IF tc=2 THEN GO TO 6250: END IF

6019 REM goodies
6020 LET dam=0: GO SUB 8615: PRINT AT 16,17; INK 7; PAPER 1; FLASH 1;"ORDERS?": BEEP .01,20: BEEP .01,20
6021 LET bink=4: LET bdrv=g(race): LET batt=att
6025 GO SUB 9500: IF k$>="1" AND k$<="4" AND NOT (k$="2" AND miss=0) THEN GO TO 6027: END IF
6026 GO TO 6025
6027 LET act=VAL (k$)
6030 IF act=1 THEN GO SUB 6400: END IF
6031 IF act=2 AND miss>0 THEN GO SUB 6430: LET miss=miss-1: END IF
6032 IF act=3 THEN GO SUB 6460: LET shld=shld+z: IF shld>maxshld THEN LET shld=maxshld: END IF: END IF
6033 IF act=4 THEN PRINT AT 17,12; INK 4; PAPER 0;"ATTEMPTING ESCAPE": BEEP .01,10: wait(60): END IF
6200 IF dam=0 THEN GO TO 6210: END IF
6201 wait(60): LET bink=6: GO SUB 6470
6202 IF ashld>0 THEN LET ashld=ashld-dam: LET dam=-1: IF ashld<0 THEN LET dam=ABS (ashld): LET ashld=0: END IF: END IF
6203 IF ashld=0 AND dam>0 THEN LET adef=adef-dam: IF adef<0 THEN LET adef=0: END IF: END IF
6210 GO SUB 8710: GO SUB 8000: IF act<=2 AND dam=0 THEN LET bink=4: wait(60): GO SUB 6475: END IF
6215 wait(60)
6220 IF adef=0 THEN LET bink=5: GO SUB 6480: GO SUB 7900: LET m(shipy,shipx)=0: GO SUB 8900: RETURN: END IF

6249 REM baddies
6250 LET dam=0: GO SUB 8615: PRINT AT 16,16; INK 2; PAPER 6; FLASH 1;"ENEMY TURN": BEEP .01,0: BEEP .01,0: wait(60)
6255 LET bink=2: LET bdrv=drv: LET batt=a(race): LET aact=1
6260 IF adef<=3 AND act<>4 AND INT (RND*100)+1>75 THEN LET aact=3: GO TO 6280: END IF
6265 IF amiss>0 AND (INT (RND*10)+1)<=a(race) THEN GO SUB 6430: LET amiss=amiss-1: GO TO 6300: END IF
6270 GO SUB 6400: GO TO 6300
6280 GO SUB 6460: LET ashld=ashld+z: IF ashld>h(race) THEN LET ashld=h(race): END IF
6300 IF dam=0 THEN GO TO 6310: END IF
6301 LET bink=3: GO SUB 6470
6302 IF shld>0 THEN LET shld=shld-dam: LET dam=-1: IF shld<0 THEN LET dam=ABS (shld): LET shld=0: END IF: END IF
6303 IF shld=0 AND dam>0 THEN LET def=def-dam: IF def<0 THEN LET def=0: END IF: END IF
6310 GO SUB 8000: GO SUB 8701: GO SUB 8710: IF aact<=2 AND dam=0 THEN LET bink=2: GO SUB 6475: END IF
6315 wait(60)
6320 IF def=0 THEN LET bink=7: GO SUB 6480: LET result=1: RETURN: END IF
6325 IF act=4 THEN GO SUB 8615: PRINT AT 16,17; INK 4; PAPER 0; FLASH 1;"ESCAPED!": BEEP .01,10: BEEP .01,20: wait(60): RETURN: END IF
6330 GO TO 6020

6399 REM battle actions
6400 PRINT AT 17,14; INK bink; PAPER 0;"FIRING PHASERS": BEEP .01,10: wait(60)
6410 LET dam=0: LET i=INT (RND*100)+1: IF i>(bdrv*7.5) THEN LET dam=INT (RND*(batt/2))+1: END IF
6420 RETURN
6430 PRINT AT 17,14; INK bink; PAPER 0;"FIRING MISSILE": BEEP .01,10: wait(60)
6440 LET dam=0: LET i=INT (RND*100)+1: IF i>(bdrv*7.5) THEN LET dam=INT (RND*(batt/2))+2: END IF
6450 RETURN
6460 PRINT AT 17,13; INK bink; PAPER 0;"BOOSTING SHIELDS": BEEP .01,10: wait(60): LET z=INT (RND*3)+1: RETURN
6470 GO SUB 8615: PRINT AT 16,14; PAPER 0; INK bink;"HIT: ";STR$ (dam);" DAMAGE": BEEP .01,10: BEEP .01,20: BEEP .01,10: RETURN
6475 GO SUB 8615: PRINT AT 16,18; INK bink; PAPER 0; FLASH 1;"MISS!": BEEP .01,10: BEEP .01,0: RETURN
6480 PRINT AT 17,13; INK bink; PAPER 1; FLASH 1;"SHIP DESTROYED!": BEEP .01,10: BEEP .01,20: BEEP .01,0: wait(60): RETURN

6499 REM trade
6500 LET pmod=(r(race)+rep): IF pmod<=10 THEN LET pmod=1-((pmod*2)/100): GO TO 6505: END IF
6502 LET pmod=1+((pmod*2)/100)
6505 GO SUB 8700: LET mdata=@MSG11: GO SUB 8650
6510 GO SUB 9500: IF k$>="1" AND k$<="5" THEN GO TO 6520: END IF
6515 GO TO 6510
6520 IF k$="5" THEN RETURN: END IF
6530 LET kv=VAL(k$)
6540 if kv=1 then go sub 6600: go to 6505: END IF
6542 if kv=2 then go sub 6650: go to 6505: END IF
6544 if kv=3 then go sub 6700: go to 6505: END IF
6546 if kv=4 then go sub 6750: go to 6505: END IF

6599 REM sell cargo
6600 IF c(1)=0 AND c(2)=0 AND c(3)=0 THEN LET mdata=@MSG12: GO SUB 8650: GO SUB 9500: RETURN: END IF
6601 LET mdata=@MSG13: GO SUB 8650
6602 LET e(1)=INT (5*pmod): LET e(2)=INT (10*pmod): LET e(3)=INT (3*pmod)
6603 LET e(b(race))=INT (e(b(race))*1.3): LET e(s(race))=INT (e(s(race))*0.6)
6604 LET st$="PPT: \r:`"+STR$ (e(1))+" \s:`"+STR$ (e(2))+" \q:`"+STR$ (e(3))
6605 PRINT AT 15,(32-LEN (st$))/2; PAPER 2; INK 7;st$: BEEP .01,10
6606 GO SUB 9500
6607 IF k$>="1" AND k$<="4" THEN GO TO 6610: END IF
6608 GO TO 6606
6610 IF k$="4" THEN RETURN: END IF
6620 LET kv=VAL(k$): LET pmax=c(kv)
6623 IF pmax=0 THEN GO TO 6606: END IF
6625 LET pprice=e(kv): GO SUB 8300: IF pnum=0 THEN GO TO 6600: END IF
6630 LET cash=cash+(pnum*e(kv)): LET c(kv)=c(kv)-pnum
6640 LET weight=c(1)+c(2)+c(3): GO SUB 8720: GO SUB 8740
6645 GO TO 6600
6648 RETURN

6649 REM buy cargo
6650 LET mdata=@MSG14: GO SUB 8650
6652 LET e(1)=INT (5*pmod): LET e(2)=INT (10*pmod): LET e(3)=INT (3*pmod)
6653 LET e(b(race))=INT (e(b(race))*1.6): LET e(s(race))=INT (e(s(race))*0.7)
6654 LET st$="PPT: \r:`"+STR$ (e(1))+" \s:`"+STR$ (e(2))+" \q:`"+STR$ (e(3))
6655 PRINT AT 15,(32-LEN (st$))/2; PAPER 2; INK 7;st$: BEEP .01,10
6656 GO SUB 9500
6657 IF k$>="1" AND k$<="4" THEN GO TO 6660: END IF
6658 GO TO 6656
6660 IF k$="4" THEN RETURN: END IF
6670 LET pmax=maxweight-weight
6671 LET kv=VAL (k$): LET pprice=e(kv): IF cash-(pmax*e(kv))<0 THEN LET pmax=INT (cash/e(kv)): END IF
6672 GO SUB 8300: IF pnum=0 THEN GO TO 6650: END IF
6675 LET cash=cash-(pnum*e(kv)): LET c(kv)=c(kv)+pnum
6680 LET weight=c(1)+c(2)+c(3): GO SUB 8720: GO SUB 8740: BEEP .01,20: GO TO 6650
6698 RETURN

6699 REM buy upgrades
6700 LET pprice=100*pmod: LET st$="Upgrades cost `"+STR$ (pprice)+" each": GO SUB 8600: PRINT AT 14,(32-LEN (st$))/2; PAPER 2; INK 7;st$: BEEP .01,10: LET mdata=@MSG16: GO SUB 8660
6705 GO SUB 9500: IF k$>="1" AND k$<="7" THEN GO TO 6710: END IF
6706 GO TO 6705
6710 IF k$="7" THEN RETURN: END IF
6711 IF cash<pprice THEN GO TO 6705: END IF
6712 IF k$="1" AND att<10 THEN LET att=att+1: LET cash=cash-pprice: END IF
6713 IF k$="2" AND maxdef<50 THEN LET maxdef=maxdef+5: LET cash=cash-pprice: LET def=def+5: IF def>maxdef THEN LET def=maxdef: END IF: END IF
6715 IF k$="3" AND drv<10 THEN LET drv=drv+10: LET cash=cash-pprice: END IF
6716 IF k$="4" AND maxmiss<30 THEN LET maxmiss=maxmiss+2: LET cash=cash-pprice: END IF
6717 IF k$="5" AND maxfuel<80 THEN LET maxfuel=maxfuel+5: LET cash=cash-pprice: END IF
6718 IF k$="6" AND maxshld<30 THEN LET maxshld=maxshld+5: LET cash=cash-pprice: END IF
6720 GO SUB 8701: GO SUB 8710: GO SUB 8720: BEEP .01,20
6725 GO TO 6705

6749 REM buy consumables/repairs/info
6750 LET e(1)=INT (10*pmod): LET e(2)=INT (2*pmod): LET e(3)=INT (5*pmod): LET e(4)=INT (50*pmod): LET st$="Missiles: `"+STR$ (e(1))+" Fuel: `"+STR$ (e(2)): GO SUB 8600: PRINT AT 14,(32-LEN (st$))/2; PAPER 2; INK 7;st$: BEEP .01,10: LET st$="Repairs: `"+STR$ (e(3))+" Info: `"+STR$ (e(4)): PRINT AT 15,(32-LEN (st$))/2; PAPER 2; INK 7;st$: BEEP .01,10: LET mdata=@MSG17: GO SUB 8660
6755 GO SUB 9500: IF k$>="1" AND k$<="5" THEN GO TO 6760: END IF
6756 GO TO 6755
6760 IF k$="5" THEN RETURN: END IF
6762 IF k$="1" AND miss<maxmiss AND cash>=e(1) THEN LET miss=miss+1: LET cash=cash-e(1): END IF
6763 IF k$="2" AND fuel<maxfuel AND cash>=e(2) THEN LET fuel=fuel+1: LET cash=cash-e(2): GO TO 6763: END IF
6764 IF k$="3" AND def<maxdef AND cash>=e(3) THEN LET def=def+1: LET cash=cash-e(3): END IF
6765 IF k$="4" AND cash>=e(4) THEN GO SUB 6800: LET cash=cash-e(4): END IF
6790 GO SUB 8701: GO SUB 8710: GO SUB 8720: BEEP .01,20: GO TO 6755

6799 REM buy info
6800 LET mx=shipx-1: LET my=shipy-1: GO SUB 6890
6801 LET mx=mx+1: GO SUB 6890: LET mx=mx+1: GO SUB 6890
6810 LET my=my+1: GO SUB 6890: LET mx=shipx-1: GO SUB 6890
6820 LET my=my+1: GO SUB 6890: LET mx=mx+1: GO SUB 6890: LET mx=mx+1: GO SUB 6890
6825 GO SUB 7700
6830 FOR n=1 TO 5: LET mx=INT (RND*20)+1: LET my=INT (RND*10)+1: IF n=5 AND ml<>0 AND INT (RND*10)>4 THEN LET my=w(ml,1): LET mx=w(ml,2): LET w(ml,1)=0: LET w(ml,2)=0: END IF
6835 BEEP .01,20: GO SUB 8900: wait(30): NEXT n
6840 RETURN
6890 BEEP .01,20: IF mx>0 AND my>0 AND mx<=20 AND my<=10 THEN GO SUB 8900: END IF
6895 wait(30): RETURN

7699 REM core finder
7700 LET ml=0
7710 FOR z=1 TO 4: IF w(z,1)<>0 AND w(z,2)<>0 THEN IF m(w(z,1),w(z,2))=200 THEN LET ml=z: LET z=5: END IF: END IF
7720 NEXT z: RETURN

7799 REM intro
7800 readMsgBuf(@INTROMSG, 14): FOR n=1 TO 14: PRINT AT n,(32-LEN (msgbuf(n)))/2; INK 7;msgbuf(n): BEEP .01,10: NEXT n: RETURN

7899 REM loot
7900 GO SUB 8600: FOR i=1 TO 3: LET e(i)=0: NEXT i
7910 IF z=1 OR z=3 THEN LET e(1)=INT (RND*11): LET e(2)=INT (RND*5): END IF
7915 IF z=1 THEN GO TO 7930: END IF
7920 LET i=11: IF (maxweight-weight)<10 THEN LET i=maxweight-weight: END IF
7925 LET e(3)=INT (RND*i): LET e(4)=INT (RND*3)+1
7930 LET mdata=@MSG29: GO SUB 8650
7940 LET i=17: IF e(1)>0 THEN LET st$=STR$ (e(1))+" fuel": PRINT AT i,11; INK 7; PAPER 2;st$: BEEP .01,20: LET i=i+1: LET fuel=fuel+e(1): IF fuel>maxfuel THEN LET fuel=maxfuel: END IF: END IF
7945 IF e(2)>0 THEN LET st$=STR$ (e(2))+" missiles": PRINT AT i,11; INK 7; PAPER 2;st$: BEEP .01,20: LET i=i+1: LET miss=miss+e(2): IF miss>maxmiss THEN LET miss=maxmiss: END IF: END IF
7950 IF e(3)=0 THEN GO TO 7970: END IF
7960 LET st$=STR$ (e(3)): IF e(4)=1 THEN LET st$=st$+" \r": LET c(1)=c(1)+e(3): END IF
7962 IF e(4)=2 THEN LET st$=st$+" \s": LET c(2)=c(2)+e(3): END IF
7964 IF e(4)=3 THEN LET st$=st$+" \q": LET c(3)=c(3)+e(3): END IF
7965 PRINT AT i,11; INK 7; PAPER 2;st$: BEEP .01,20
7970 GO SUB 8710: GO SUB 8740: LET mdata=@MSG30: GO SUB 8660
7990 GO SUB 9500: RETURN

7999 REM battle data
8000 PRINT AT 16,4; PAPER 6; INK 2;"\h:";AT 17,4;"\b:";AT 18,4;"\f:";AT 19,4;"\p:";AT 20,4;"\d:"
8010 LET st$=STR$ (a(race)): IF LEN (st$)<2 THEN LET st$="0"+st$: END IF
8011 PRINT PAPER 6; INK 2;AT 16,7;st$
8012 LET st$=STR$ (adef): IF LEN (st$)<2 THEN LET st$="0"+st$: END IF
8013 PRINT PAPER 6; INK 2;AT 17,7; FLASH (adef<5);st$
8014 LET st$=STR$ (g(race)): IF LEN (st$)<2 THEN LET st$="0"+st$: END IF
8015 PRINT PAPER 6; INK 2;AT 18,7;st$
8016 LET st$=STR$ (amiss): IF LEN (st$)<2 THEN LET st$="0"+st$: END IF
8017 PRINT PAPER 6; INK 2;AT 19,7; FLASH (amiss<5);st$
8018 LET st$=STR$ (ashld): IF LEN (st$)<2 THEN LET st$="0"+st$: END IF
8019 PRINT PAPER 6; INK 2;AT 20,7; FLASH (ashld<5);st$
8020 RETURN

8099 REM rep changes
8100 LET z=INT (RND*100)+1: IF z<=rc THEN LET r(race)=r(race)+rv: END IF
8101 IF r(race)<0 THEN LET r(race)=0: END IF
8102 IF r(race)>10 THEN LET r(race)=10: END IF
8105 RETURN
8110 LET z=INT (RND*100)+1: IF z<rc THEN LET rep=rep+rv: END IF
8111 IF rep<0 THEN LET rep=0: END IF
8112 IF rep>10 THEN LET rep=10: END IF
8115 RETURN

8199 REM alien encounter
8200 GO SUB 8600
8210 GO SUB 8450: LET st$=st$+" "+zed$: PRINT AT 15,(32-LEN (st$))/2; PAPER 2; INK 5;st$: BEEP .01,10
8215 LET cee$=CHR$ (152+race): PRINT INK race+1; PAPER 0;AT 15,2;cee$;AT 15,29;cee$: BEEP .01,10
8220 GO SUB 8400: LET st$="Reception: "+st$: PRINT AT 16,(32-LEN (st$))/2; PAPER 2; INK 7; FLASH (r(race)>=8);st$: BEEP .01,10
8230 RETURN

8299 REM selling interface
8300 LET mdata=@MSG15: GO SUB 8650
8305 LET pnum=pmax
8310 PRINT AT 20,11; PAPER 2; INK 7;"Amount: ";pnum;" ";AT 21,11; INK 5;"Value: `";pnum*pprice;" ": BEEP .01,10
8320 GO SUB 9500: IF k$<>"7" AND k$<>"6" AND k$<>" " THEN GO TO 8320: END IF
8325 IF k$=" " THEN RETURN: END IF
8330 IF k$="7" AND pnum<pmax THEN LET pnum=pnum+1: END IF
8332 IF k$="6" AND pnum>0 THEN LET pnum=pnum-1: END IF
8340 GO TO 8310

8399 REM persuasion
8400 IF r(race)<=3 THEN LET st$="friendly": GO TO 8420: END IF
8405 IF r(race)>=8 THEN LET st$="hostile": GO TO 8420: END IF
8410 LET st$="neutral"
8420 IF r(race)=1 OR r(race)>9 THEN LET st$="very "+st$: END IF
8430 RETURN

8449 REM trim alien name
8450 LET st$=name$(race)
8470 RETURN

8499 REM alien names
8500 printmem(): LET zsize=20: GO SUB 9300: LET i=1:printmem()
8510 FOR n=1 TO 6: LET st$=pee$(zz(i)):printmem()
8520 LET q=INT (RND*9)+1
8530 IF q<=3 THEN LET st$=st$+"'": GO TO 8540: END IF
8535 IF q>=7 THEN LET st$=st$+"-": END IF
8540 printmem(): LET i=i+1: LET st$=st$+pee$(zz(i)): LET i=i+1:printmem()
8550 printmem(): LET name$(n)=capitalise(st$): printmem(): NEXT n
8560 printmem(): RETURN

8599 REM clear data panel
8600 FOR q=14 TO 21: PRINT AT q,1; PAPER 2;"                              ": NEXT q
8605 RETURN
8610 GO SUB 8600: FOR q=15 TO 21: PRINT PAPER 6;AT q,3;"       ": NEXT q
8611 FOR q=20 TO 21: PRINT PAPER 5;AT q,12;"                 ": NEXT q
8612 PRINT PAPER 5; INK 1;AT 20,15;"1:\h 2:\p 3:\d";AT 21,17;"4:ESCAPE"
8613 LET cee$=CHR$ (152+race): PRINT INK race+1; PAPER 0;AT 15,2;cee$
8615 FOR q=15 TO 18: PRINT PAPER 0;AT q,12;"                 ": NEXT q: RETURN

8649 REM print message to display panel
8650 GO SUB 8600
8660 let mypos=peek(mdata): let mxpos=peek(mdata+1): let msize=peek(mdata+2)
8665 readColourMsgBuf((mdata+3), msize)
8670 FOR q=mypos TO mypos+(msize-1): let mmi=inkbuf((q-mypos)+1): let mm$=msgbuf((q-mypos)+1): LET qx=mxpos: IF qx=0 THEN LET qx=(32-LEN (mm$))/2: END IF
8675 PRINT PAPER 2; INK mmi;AT q,qx;mm$: BEEP .01,10: NEXT q
8680 RETURN

8699 REM update panel - in parts or all at once
8700 GO SUB 8701: GO SUB 8710: GO SUB 8720: GO SUB 8730: GO SUB 8740: GO SUB 8750: RETURN
8701 LET st$=STR$ (att): IF LEN (st$)<2 THEN LET st$="0"+st$: END IF
8702 PRINT PAPER 6; INK 0;AT 2,28;st$
8703 LET st$=STR$ (def): IF LEN (st$)<2 THEN LET st$="0"+st$: END IF
8704 PRINT PAPER 6; INK (0+((def<maxdef)*2));AT 3,28; FLASH (def<5);st$
8705 LET st$=STR$ (drv): IF LEN (st$)<2 THEN LET st$="0"+st$: END IF
8706 PRINT PAPER 6; INK 0;AT 4,28;st$
8707 RETURN
8710 LET st$=STR$ (miss): IF LEN (st$)<2 THEN LET st$="0"+st$: END IF
8711 PRINT PAPER 6; INK 1;AT 6,28; FLASH (miss<5);st$
8712 LET st$=STR$ (fuel): IF LEN (st$)<2 THEN LET st$="0"+st$: END IF
8713 PRINT PAPER 6; INK 1;AT 7,28; FLASH (fuel<5);st$
8714 LET st$=STR$ (shld): IF LEN (st$)<2 THEN LET st$="0"+st$: END IF
8715 PRINT PAPER 6; INK (1+(shld<maxshld));AT 8,28; FLASH (shld<5);st$
8716 RETURN
8720 LET st$=STR$ (cash)
8721 IF LEN (st$)<4 THEN LET st$="0"+st$: GO TO 8721: END IF
8725 PRINT AT 9,26; PAPER 6; INK 2;st$: RETURN
8730 LET st$=STR$ (time): LET sl=LEN (st$)
8731 IF sl=2 THEN LET st$="0"+st$: END IF
8732 IF sl=1 THEN LET st$="00"+st$: END IF
8735 PRINT AT 13,27; PAPER 0; INK 7; FLASH (time<10);st$: RETURN
8740 LET st$=STR$ (c(1)): IF c(1)<10 THEN LET st$="0"+st$: END IF
8741 PRINT BRIGHT 1; INK 4;AT 23,4;st$
8742 LET st$=STR$ (c(2)): IF c(2)<10 THEN LET st$="0"+st$: END IF
8743 PRINT BRIGHT 1; INK 5;AT 23,9;st$
8744 LET st$=STR$ (c(3)): IF c(3)<10 THEN LET st$="0"+st$: END IF
8745 PRINT BRIGHT 1; INK 6;AT 23,14;st$: RETURN
8750 IF found>0 THEN PRINT BRIGHT 1; INK 7;AT 23,20;"\g": END IF
8751 IF found>1 THEN PRINT BRIGHT 1; INK 7;AT 23,23;"\g": END IF
8752 IF found>2 THEN PRINT BRIGHT 1; INK 7;AT 23,26;"\g": END IF
8753 IF found>3 THEN PRINT BRIGHT 1; INK 7;AT 23,29;"\g": END IF
8754 RETURN

8799 REM reveal whole map
8800 FOR n=1 TO 10: FOR i=1 TO 20: LET my=n: LET mx=i
8810 GO SUB 8900: NEXT i: NEXT n
8820 RETURN

8899 REM reveal a map cell
8900 LET mf=0: IF my=shipy AND mx=shipx THEN LET mf=1: END IF
8901 IF m(my,mx)=0 AND my=shipy AND mx=shipx THEN LET cee$="\b": LET mi=5: GO TO 8950: END IF
8902 IF m(my,mx)=0 THEN LET cee$=" ": LET mi=0: GO TO 8950: END IF
8905 IF m(my,mx)>10 THEN GO TO 8910: END IF
8906 LET cee$="\e": LET mi=m(my,mx)+1: IF mi=8 THEN LET mi=1: END IF
8907 GO TO 8950
8910 IF m(my,mx)>20 THEN GO TO 8920: END IF
8915 LET cee$=CHR$ (152+(m(my,mx)-10)): LET mi=m(my,mx)-9: GO TO 8950
8920 IF m(my,mx)=100 THEN LET cee$="\g": LET mi=6: GO TO 8950: END IF
8930 IF m(my,mx)=200 THEN LET cee$="\g": LET mi=5: GO TO 8950: END IF
8940 IF m(my,mx)=201 THEN LET cee$="\i": LET mi=4: GO TO 8950: END IF
8950 PRINT AT my,mx; INK mi; FLASH mf;cee$
8955 RETURN

8959 REM clear a map cell
8960 LET m(my,mx)=0
8990 RETURN

8999 REM setup new game
9000 LET att=1: LET def=10: LET drv=1: LET maxdef=10
9010 LET fuel=40: LET miss=10: LET shld=10: LET maxfuel=40: LET maxmiss=10: LET maxshld=10: LET rep=5: LET cash=100
9020 LET time=300: LET found=0
9030 LET c(1)=10: LET c(2)=10: LET c(3)=10: LET weight=c(1)+c(2)+c(3): LET maxweight=50
9035 printmem(): PRINT AT 20,9; INK 6;"\g"
9040 LET zsize=20: GO SUB 9300: FOR n=1 TO 20: LET t(n)=zz(n): NEXT n: LET mptr=0: REM shuffle missions
9050 GO SUB 9200: REM generate aliens
9090 GO SUB 9100
9095 RETURN

9099 REM setup new map
9100 FOR n=1 TO 10: FOR i=1 TO 20: LET m(n,i)=0: NEXT i: NEXT n

9110 REM planets
9111 printmem(): PRINT AT 20,11; INK 6;"\g": LET i=INT (RND*10)+10: FOR n=1 TO i: GO SUB 9350: LET m(ry,rx)=INT (RND*7)+1: NEXT n

9120 REM missions
9121 printmem(): PRINT AT 20,13; INK 6;"\g": LET i=INT (RND*10)+10: FOR n=1 TO i: GO SUB 9350: LET m(ry,rx)=100: NEXT n

9130 REM ships
9131 printmem(): PRINT AT 20,15; INK 6;"\g": LET i=INT (RND*10)+10: FOR n=1 TO i: GO SUB 9350: LET m(ry,rx)=INT (RND*6)+11: NEXT n

9140 REM pieces
9141 printmem(): PRINT AT 20,17; INK 6;"\g": FOR n=1 TO 4: GO SUB 9350: LET m(ry,rx)=200: LET w(n,1)=ry: LET w(n,2)=rx: NEXT n

9150 REM wormhole
9151 printmem(): PRINT AT 20,19; INK 6;"\g": GO SUB 9350: LET m(ry,rx)=201

9160 REM ship
9161 printmem(): PRINT AT 20,21; INK 6;"\g": LET shipy=ry: LET shipx=rx
9195 RETURN

9199 REM generate aliens
9200 LET zsize=6: GO SUB 9300: FOR n=1 TO 6: LET qq(n)=zz(n): NEXT n
9205 FOR n=1 TO 6
9210 LET mz=1: IF n>3 THEN LET mz=5: END IF
9215 LET a(qq(n))=INT (RND*3)+mz: LET d(qq(n))=INT (RND*3)+mz: LET r(qq(n))=INT (RND*5)+mz+1: LET g(qq(n))=INT (RND*2)+mz: LET h(qq(n))=INT (RND*10)+mz
9220 LET zsize=3: GO SUB 9300
9230 LET b(qq(n))=zz(1): LET s(qq(n))=zz(3)
9240 NEXT n
9285 GO SUB 8500: REM names
9290 RETURN

9299 REM shuffle
9300 FOR oo=1 TO zsize: LET zz(oo)=oo: NEXT oo
9310 FOR oo=1 TO INT (zsize*2.5): LET zx=INT (RND*zsize)+1: LET zy=INT (RND*zsize)+1: LET zt=zz(zx): LET zz(zx)=zz(zy): LET zz(zy)=zt: NEXT oo
9320 RETURN

9349 REM find a blank tile
9350 LET rx=INT (RND*20)+1: LET ry=INT (RND*10)+1: IF m(ry,rx)=0 THEN RETURN: END IF
9360 GO TO 9350

9399 REM draw screen
9400 CLS: setUDGbank(2)
9410 PRINT AT 0,0; PAPER 0; INK 1;"\e\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\f";AT 0,23;"\e\a\a\a\a\a\a\a\f"
9415 FOR n=1 TO 10: PRINT AT n,0; PAPER 0; INK 1;"\c";at n,21;"\d";AT n,23;"\c"; PAPER 6;"       "; PAPER 0;"\d": NEXT n
9420 PRINT AT 11,0; PAPER 0; INK 1;"\g\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\h";AT 11,23;"\g\b\b\b\b\b\b\b\h"
9430 PRINT AT 13,0; PAPER 0; INK 1;"\e\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a"; INK 7;"T:000"; INK 1;"\a\f"
9440 FOR n=14 TO 22: PRINT at n,0; PAPER 0; INK 1;"\c"; PAPER 2;"                              "; PAPER 0;"\d": NEXT n
9450 PRINT AT 23,0; BRIGHT 1; PAPER 0; INK 1;"\g\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\h"
9455 setUDGbank(1)
9460 FOR n=1 TO 10: PRINT AT n,1; PAPER 0; INK 1; BRIGHT 0;"\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a\a": NEXT n
9465 PRINT AT 23,2; BRIGHT 1; PAPER 0; INK 4;"\r:00"; at 23,7; INK 5;"\s:00"; at 23,12; INK 6;"\q:00"; ink 1; at 23,20;"\g";at 23,23;"\g";at 23,26;"\g";at 23,29;"\g"
9470 PRINT PAPER 6; INK 0;AT 2,25;"\h: 00";AT 3,25;"\b: 00";AT 4,25;"\f: 00"; INK 1;AT 6,25;"\p: 00";AT 7,25;"\c: 00";AT 8,25;"\d: 00"; INK 2;AT 9,25;"`0000"
9480 LET mx=shipx: LET my=shipy: GO SUB 8900
9495 RETURN

9499 REM get keypress
9500 IF INKEY$<>"" THEN GO TO 9500: END IF
9510 LET k$=INKEY$: IF k$="" THEN GO TO 9510: END IF
9520 RETURN

9599 REM menu
9600 CLS: dzx7Standard(@BSSC, 16384)
9610 PRINT AT 12,5; INK 4;"Written by @Blerkotron";ink 5;AT 13,6;"Logo by @hot_piping"
9615 PRINT AT 16,2; INK 2;"\*2017, Blerkotronic Software";at 17,1; ink 1; "blerkotron.itch.io/breakspace"
9695 printmem(): animatemenu(): RETURN

9849 REM alien name pot
9850 initarrays()
9898 RETURN

9899 REM initial UDG and font setup
9900 setUDGbank(1)
9901 POKE 23606,@FONT-((int(@FONT/256))*256): POKE 23607,(int(@FONT/256))-1
9905 RETURN
