;*****************************************************************************************************;
;                               Z DISPLAY DRIVER V2.0   03.03.2017                                   ;
;                                        designed by KeKc                                             ;
;                                      special for zx.pk.ru                                           ;
;*****************************************************************************************************;
DISPLAY_BASE_PORT .equ $D0           ;   LCD
DISPLAY_COMMAND_NOP .equ DISPLAY_BASE_PORT+0
DISPLAY_COMMAND_L .equ DISPLAY_BASE_PORT+2
DISPLAY_COMMAND_R .equ DISPLAY_BASE_PORT+4
DISPLAY_COMMAND_LR .equ DISPLAY_BASE_PORT+6
DISPLAY_DATA_NOP .equ DISPLAY_BASE_PORT+1
DISPLAY_DATA_L .equ DISPLAY_BASE_PORT+3
DISPLAY_DATA_R .equ DISPLAY_BASE_PORT+5
DISPLAY_DATA_LR .equ DISPLAY_BASE_PORT+7
DISPLAY_STATUS_L .equ DISPLAY_BASE_PORT+10
DISPLAY_STATUS_R .equ DISPLAY_BASE_PORT+12
DISPLAY_READDATA_L .equ DISPLAY_BASE_PORT+11
DISPLAY_READDATA_R .equ DISPLAY_BASE_PORT+13
;LCD_TYPE = BG12864AGPLHn$
X_POZ .equ $FFF8                ;    
Y_POZ .equ $FFF9                ;    Y
Z_POZ .equ $FFFA                ;    Z
CUR_SYMBOL .equ $FFFB           ;   ASCII 
FONT_ADR .equ $02               ;    
CURSOR_SYM_DEFAULT .equ 95      ; ASCII    

;#define InitLCD  rst 10h\ ld a, %00111111\ out (DISPLAY_COMMAND_LR), a ;   

;*****************************************************************************************************;
;----------------------------------------  ---------------------------------------------;
;*****************************************************************************************************;  
  .org $0200 
Font_table:   
    .db $00, $3E, $3E, $0C, $08, $1C, $1C, $00, $7F, $00, $04, $30, $06, $20, $60, $2A
    .db $00, $08, $14, $00, $06, $4A, $60, $54, $04, $10, $08, $08, $0C, $1C, $30, $06
    .db $00, $00, $00, $14, $24, $23, $36, $00, $00, $00, $14, $08, $00, $08, $00, $20
    .db $3E, $44, $42, $21, $18, $27, $3C, $01, $36, $06, $00, $00, $08, $14, $00, $02
    .db $3E, $7C, $7F, $3E, $7F, $7F, $7F, $3E, $7F, $00, $20, $7F, $7F, $7F, $7F, $3E
    .db $7F, $3E, $7F, $46, $01, $3F, $1F, $3F, $63, $03, $61, $00, $02, $00, $04, $80
    .db $00, $20, $7F, $38, $38, $38, $08, $08, $7F, $00, $20, $7F, $00, $7C, $7C, $38
    .db $7C, $08, $7C, $48, $04, $3C, $1C, $3C, $44, $0C, $44, $00, $00, $00, $10, $70
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $FF, $3E, $3E, $3E, $3E
    .db $80, $C0, $D0, $D8, $DA, $DB, $40, $60, $60, $60, $78, $78, $78, $1C, $41, $41
    .db $1C, $41, $5D, $5D, $22, $00, $00, $46, $7E, $08, $00, $08, $7F, $03, $22, $02
    .db $06, $44, $1C, $20, $20, $80, $44, $00, $38, $7C, $10, $14, $0E, $20, $38, $02
    .db $7E, $7F, $7F, $7F, $70, $7F, $77, $41, $7F, $7F, $7F, $20, $7F, $7F, $3E, $7F
    .db $7F, $3E, $01, $47, $0C, $63, $3F, $07, $7F, $7F, $01, $7F, $7F, $22, $7F, $46
    .db $20, $7C, $7C, $7C, $60, $38, $6C, $44, $7C, $7C, $7C, $20, $7C, $7C, $38, $7C
    .db $7C, $38, $04, $0C, $08, $44, $7C, $0C, $7C, $7C, $04, $7C, $7C, $28, $7C, $48
    .db $00, $55, $6B, $1E, $1C, $4A, $4E, $1C, $63, $1C, $66, $48, $29, $70, $7F, $1C
    .db $7F, $1C, $22, $5F, $09, $55, $60, $62, $02, $20, $08, $1C, $08, $3E, $3C, $1E
    .db $00, $00, $07, $7F, $2A, $13, $49, $00, $1C, $41, $08, $08, $A0, $08, $C0, $10
    .db $51, $42, $61, $41, $14, $45, $4A, $71, $49, $49, $36, $B6, $14, $14, $41, $01
    .db $41, $12, $49, $41, $41, $49, $09, $41, $08, $41, $40, $08, $40, $02, $04, $41
    .db $09, $41, $09, $49, $01, $40, $20, $40, $14, $04, $51, $7F, $04, $41, $02, $80
    .db $01, $54, $48, $44, $44, $54, $7E, $54, $10, $44, $40, $10, $41, $04, $08, $44
    .db $14, $14, $08, $54, $3F, $40, $20, $40, $28, $50, $64, $08, $00, $41, $08, $48
    .db $3E, $00, $3A, $22, $0E, $2E, $3E, $02, $3E, $2E, $08, $FF, $00, $3E, $3E, $3E
    .db $80, $C0, $D0, $D8, $DA, $DB, $00, $00, $00, $00, $00, $00, $00, $77, $41, $41
    .db $77, $41, $5D, $5D, $1C, $08, $00, $5D, $4B, $08, $14, $14, $41, $05, $14, $55
    .db $09, $44, $14, $3E, $50, $7C, $3C, $00, $55, $10, $20, $08, $06, $10, $30, $04
    .db $09, $49, $49, $01, $29, $49, $08, $41, $10, $20, $08, $41, $02, $08, $41, $01
    .db $09, $41, $01, $48, $12, $14, $20, $08, $40, $40, $7F, $48, $48, $41, $08, $29;
    .db $54, $54, $54, $04, $34, $54, $10, $54, $20, $21, $10, $44, $08, $10, $44, $04
    .db $14, $44, $04, $50, $14, $6C, $40, $10, $40, $40, $7C, $50, $50, $44, $10, $54
    .db $00, $51, $6F, $3C, $3E, $7F, $7F, $1C, $63, $14, $7F, $4D, $79, $3F, $05, $77
    .db $3E, $3E, $7F, $00, $7F, $55, $60, $7F, $7F, $7F, $2A, $2A, $08, $08, $3F, $7E
    .db $00, $5F, $00, $14, $7F, $08, $56, $07, $22, $22, $3E, $3E, $60, $08, $C0, $08
    .db $49, $7F, $51, $45, $12, $45, $49, $09, $49, $49, $36, $76, $22, $14, $22, $51
    .db $5D, $11, $49, $41, $41, $49, $09, $49, $08, $7F, $41, $14, $40, $0C, $08, $41
    .db $09, $51, $19, $49, $7F, $40, $40, $30, $08, $78, $49, $41, $08, $41, $01, $80
    .db $02, $54, $44, $44, $44, $54, $09, $54, $08, $7D, $40, $10, $7F, $78, $04, $44
    .db $14, $14, $04, $54, $44, $40, $40, $30, $10, $50, $54, $36, $7F, $36, $10, $44
    .db $22, $3E, $2A, $2A, $08, $2A, $2A, $02, $2A, $2A, $08, $FF, $00, $00, $00, $00
    .db $80, $C0, $D0, $D8, $DA, $DB, $40, $40, $70, $70, $40, $7C, $7C, $41, $41, $41
    .db $41, $41, $41, $41, $14, $1C, $77, $55, $4A, $2A, $08, $22, $71, $7F, $7F, $7D
    .db $09, $5F, $1C, $61, $3F, $20, $04, $08, $54, $20, $10, $22, $0A, $0A, $28, $28
    .db $09, $49, $49, $01, $27, $49, $7F, $49, $08, $11, $08, $3F, $04, $08, $41, $01
    .db $09, $41, $7F, $48, $7F, $08, $20, $08, $7E, $7E, $48, $30, $48, $49, $3E, $19
    .db $54, $54, $54, $04, $2C, $54, $7C, $54, $10, $12, $10, $3C, $10, $10, $44, $04
    .db $14, $44, $7C, $50, $7C, $10, $40, $10, $70, $78, $50, $20, $50, $54, $38, $34
    .db $00, $55, $6B, $1E, $1C, $4A, $4E, $1C, $63, $1C, $66, $33, $29, $02, $35, $1C
    .db $1C, $7F, $22, $5F, $01, $55, $60, $62, $02, $20, $1C, $08, $08, $3E, $3C, $1E
    .db $00, $00, $07, $7F, $2A, $64, $20, $00, $41, $1C, $08, $08, $00, $08, $00, $04
    .db $45, $40, $49, $4B, $7F, $45, $49, $05, $49, $29, $00, $00, $41, $14, $14, $09
    .db $55, $12, $49, $41, $22, $49, $09, $49, $08, $41, $3F, $22, $40, $02, $10, $41
    .db $09, $21, $29, $49, $01, $40, $20, $40, $14, $04, $45, $41, $10, $7F, $02, $80
    .db $04, $54, $44, $44, $48, $54, $01, $58, $08, $40, $3D, $28, $40, $04, $04, $44
    .db $14, $14, $04, $54, $40, $20, $20, $40, $28, $50, $4C, $41, $00, $08, $20, $48
    .db $3E, $00, $2E, $3E, $3E, $3A, $3A, $3E, $3E, $3E, $08, $FF, $00, $00, $3E, $3E
    .db $80, $C0, $D0, $D8, $DA, $DB, $00, $00, $00, $00, $00, $00, $00, $41, $41, $7F
    .db $5D, $5D, $5D, $7F, $1C, $08, $00, $5D, $4B, $08, $14, $08, $31, $05, $55, $05
    .db $06, $44, $22, $3E, $02, $3C, $7C, $00, $55, $7F, $08, $14, $10, $06, $04, $30
    .db $09, $49, $49, $01, $21, $49, $08, $49, $04, $08, $14, $01, $02, $08, $41, $01
    .db $09, $41, $01, $48, $12, $14, $3F, $08, $40, $40, $48, $00, $48, $49, $41, $09;
    .db $54, $54, $54, $04, $24, $54, $10, $54, $08, $09, $28, $04, $08, $10, $44, $04
    .db $14, $44, $04, $50, $14, $6C, $7C, $10, $40, $40, $50, $00, $50, $54, $44, $14
    .db $00, $3E, $3E, $0C, $08, $1C, $1C, $00, $7F, $00, $04, $07, $06, $04, $3F, $2A
    .db $08, $00, $14, $00, $7F, $29, $60, $54, $04, $10, $08, $08, $08, $1C, $30, $06
    .db $00, $00, $00, $14, $12, $62, $50, $00, $00, $00, $14, $08, $00, $08, $00, $02
    .db $3E, $40, $46, $31, $10, $39, $30, $03, $36, $1E, $00, $00, $00, $14, $08, $06
    .db $5E, $7C, $36, $22, $1C, $41, $01, $7A, $7F, $00, $01, $41, $60, $7F, $7F, $3E
    .db $06, $5E, $46, $31, $01, $3F, $1F, $3F, $63, $03, $43, $00, $20, $00, $04, $80
    .db $00, $78, $38, $48, $7F, $18, $02, $3C, $70, $00, $00, $44, $00, $78, $78, $38
    .db $08, $7C, $08, $24, $20, $7C, $1C, $3C, $44, $3C, $44, $00, $00, $00, $10, $70
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $FF, $00, $00, $00, $3E
    .db $80, $C0, $D0, $D8, $DA, $DB, $40, $40, $40, $78, $40, $40, $7E, $41, $41, $00
    .db $5D, $5D, $5D, $00, $22, $00, $00, $31, $42, $08, $00, $14, $1F, $03, $22, $02
    .db $00, $44, $7F, $20, $0C, $40, $44, $00, $18, $03, $04, $08, $20, $0E, $02, $38
    .db $7E, $31, $36, $01, $7F, $41, $77, $36, $7F, $7F, $63, $7F, $7F, $7F, $3E, $7F
    .db $06, $41, $01, $3F, $0C, $63, $60, $7F, $7F, $FF, $30, $7F, $30, $3E, $3E, $7F
    .db $78, $20, $28, $0C, $7C, $18, $6C, $28, $7C, $7C, $44, $7C, $7C, $7C, $38, $7C
    .db $08, $28, $04, $3C, $08, $44, $C0, $7C, $7C, $FC, $20, $7C, $20, $38, $38, $7C
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $41, $41, $00
    .db $41, $41, $41, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00
    .db $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00, $00

;*****************************************************************************************************;
;------------------------------------    -----------------------------------;
;*****************************************************************************************************;
GetCursorPozition:
    push hl                     ; D=X_POZ, E=Y_POZ, C=Z_POZ  
    ld hl, X_POZ                 
    ld d, (hl)
    inc hl
    ld e, (hl)
    inc hl
    ld c, (hl)
    pop hl
    ret
    
;*****************************************************************************************************;
;------------------------------------    ----------------------------------;
;*****************************************************************************************************;
SetCursorPozition:
    push af                             ; X_POZ=D, Y_POZ=E, Z_POZ=C  
    ld a, d
    call LcdSetX
    ld a, e
    call LcdSetY
    ld a, c
    call LcdSetZ
    pop af
    ret
    
;*****************************************************************************************************;
;---------------------------------   X=0, Y=0, Z=0 -------------------------------;
;*****************************************************************************************************;
LcdResXYZ:
    ld a, %01000000
    out (DISPLAY_COMMAND_LR), a
    xor a
    ld (X_POZ), a           
    ld a, %10111000
    out (DISPLAY_COMMAND_LR), a 
    xor a
    ld (Y_POZ), a 
    ld a, %11000000
    out (DISPLAY_COMMAND_LR), a  
    xor a
    ld (Z_POZ), a
    ret
    
;*****************************************************************************************************;
;---------------------------------------   X=0 -----------------------------------;
;*****************************************************************************************************;
LcdResetX:
    xor a
    ld (X_POZ), a 
    add a, %01000000        
    out (DISPLAY_COMMAND_LR), a    
    ret      
;*****************************************************************************************************;
;----------------------------------   X (0...127) --------------------------------;
;*****************************************************************************************************;
LcdSetX: 
    and 127
    ld (X_POZ), a                
    cp 64                  ; c=1  0<=X<=63
    jp c, Lcd_set_XL       ; c=0  X>=64       
Lcd_set_XR:  
    out (DISPLAY_COMMAND_R), a   
    ld a, %01000000   
    out (DISPLAY_COMMAND_L), a  
    ret
Lcd_set_XL: 
    add a, %01000000
    out (DISPLAY_COMMAND_L), a  
    ld a, %01000000        
    out (DISPLAY_COMMAND_R), a    
    ret 

;*****************************************************************************************************;
;------------------------------------   Y=0 --------------------------------------;
;*****************************************************************************************************;
LcdResetY:
    xor a       
;*****************************************************************************************************;
;----------------------------------   Y (0...7) ----------------------------------;
;*****************************************************************************************************;
LcdSetY: 
    and 7 
    ld (Y_POZ), a
    add a, %10111000
    out (DISPLAY_COMMAND_LR), a  
    ret 

;*****************************************************************************************************;
;---------------------------------------   Z=0 -----------------------------------;
;*****************************************************************************************************;
LcdResetZ:
    xor a       
;*****************************************************************************************************;
;------------------------------------   Z (0...63) -------------------------------;
;*****************************************************************************************************; 
LcdSetZ: 
    ld (Z_POZ), a 
    or %11000000
    out (DISPLAY_COMMAND_LR), a  
    ret                                                                                                
    
;*****************************************************************************************************;
;-------------------------------------------   -----------------------------------------;
;*****************************************************************************************************;
ResetLCD:
    push bc
    ld c, 7 
ClearLcdLoop:    
    ld a, c
    add a, %10111000
    out (DISPLAY_COMMAND_LR), a
    ld a, %01000000        
    out (DISPLAY_COMMAND_LR), a  
    xor a
    ld b, 64    
ClearLcdLoop2:    
    nop ; 4
    out (DISPLAY_DATA_LR), a ; 11
    djnz ClearLcdLoop2 ; 13 (8)
    dec c
    jp p, ClearLcdLoop
    call LcdResXYZ   
    pop bc
    ret               
                      
;*****************************************************************************************************;        
;----------------------------------------     ---------------------------------------;
;*****************************************************************************************************;   
LcdWriteData:
    push af
    ld a, (X_POZ)
    cp 64                   ; c=1  0<=X<=63 
    jp c, LcdWriteL       ; c=0  X>=64   
LcdWriteR:
    pop af  
    out (DISPLAY_DATA_R), a  
    jp LcdWriteData2
LcdWriteL: 
    pop af
    out (DISPLAY_DATA_L), a     
LcdWriteData2:
    ld a, (X_POZ)
    inc a
    ld (X_POZ), a    
    cp 128                  ; c=1  X<128         
    ret                     ; c=0  X>=128 -     

;*****************************************************************************************************;        
;--------------------------------------  HEX    ----------------------------------;
;*****************************************************************************************************; 
; A(ASCII)=A(HEX)+48,  A=0...9  
; A(ASCII)=A(HEX)+48+7,  A=A...F 
PrintHEX:           ; HEX    , 
    push af
    and $0F         ;  ASCII    
    add a, 48       
    cp 58           ; c=1  A=0...9
    jr c, PrintAsciiNoCRLF2
    add a, 7        
    jr PrintAsciiNoCRLF2
    
;*****************************************************************************************************;        
;--------------------------------------      -------------------------------;
;*****************************************************************************************************;
PrintAscii0:
    xor a      
;*****************************************************************************************************;        
;--------------------------------------  ASCII    --------------------------------;
;*****************************************************************************************************; 
PrintAscii:             ; ASCII     
  ;  push af
  ;  call TxD
   ; pop af
    cp $0D              ;    0x0D
    jr z, LcdCRLF       ;    
PrintAsciiNoCRLF:
    push af
PrintAsciiNoCRLF2:
    push bc
    push hl  
    ld h, FONT_ADR
    ld b, 6     
    ld l, a  
    ld a, (X_POZ)
    cp 122              ;     (C=0) 
    call nc, LcdCRLF    ;    
PrintAsciiLoop:            
    ld a, (hl)
    inc h
    call LcdWriteData
    djnz PrintAsciiLoop
    pop hl
    pop bc
    pop af
    ret   
       
;*****************************************************************************************************;
;----------------------------------------   --------------------------------------------;
;*****************************************************************************************************;
LcdCRLF:
    push af
    push bc
    ld bc, X_POZ
    xor a
    ld (bc), a 
    inc bc      ;  bc       Y
    ld a, (bc)  ; A=Y_POZ
    inc a       
    and 7       ; z=1      Z
    ld (bc), a  ;    Y  
    inc bc      ;  bc       Z
    push af     ;    z   Y
    ld a, (bc)  ; A=Z_POZ
    jp z, LcdScroll
    cp 64       ; c=1  Z<64
    jp c, LcdCRLFEnd
LcdScroll:   
    add a, 8
    or %11000000
    ld (bc), a
    out (DISPLAY_COMMAND_LR), a
LcdCRLFEnd:
    pop af    
    add a, %10111000
    out (DISPLAY_COMMAND_LR), a  
    ld b, 64
    xor a
LcdCRLFLoop:    
    nop
    out (DISPLAY_DATA_LR), a
    djnz LcdCRLFLoop 
    ld a, %01000000        
    out (DISPLAY_COMMAND_LR), a
    pop bc
    pop af
    ret  

;*****************************************************************************************************;      
;---------------------------      --------------------------------;
;*****************************************************************************************************;
PrintA:
    push af          
    rra
    rra
    rra
    rra
    call PrintHEX
    pop af    
    call PrintHEX
    ret
    
;*****************************************************************************************************;        
;--------------------------------     BC -------------------------------------;
;*****************************************************************************************************;    
PrintBC: 
    push af  
    ld a, b
    call PrintA
    ld a, c
    call PrintA
    pop af      
    ret
    
;*****************************************************************************************************;        
;---------------------------------     DE ------------------------------------;
;*****************************************************************************************************;    
PrintDE: 
    push af  
    ld a, d
    call PrintA
    ld a, e
    call PrintA
    pop af      
    ret  
                
;*****************************************************************************************************;       
;---------------------------------     HL ------------------------------------;
;*****************************************************************************************************;     
PrintHL: 
    push af  
    ld a, h
    call PrintA
    ld a, l
    call PrintA
    pop af      
    ret            
    
;*****************************************************************************************************;        
;---------------------------------      -----------------------------------;
;*****************************************************************************************************;
BackSymbol:
    push af
    push bc
    push de
    call GetCursorPozition
    ld a, d
    sub 6      
    jp nc, BackSymbol2      ; C=1 -      
    ld a, e
    dec a
    jp p, BackSymbol3
    ld a, c
    sub 8 
    and 64
    ld c, a   
    call LcdSetZ
    ld a, 7
BackSymbol3:
    ld e, a 
    call LcdSetY
    ld a, 120
BackSymbol2:
    ld d, a 
    call LcdSetX  
    call PrintAscii0 
    call SetCursorPozition
    pop de
    pop bc
    pop af
    ret       
    
;*****************************************************************************************************;       
;--------------------------------      -----------------------------------;
;*****************************************************************************************************;
DelSymbol:
    push af
    push bc
    push de
    call GetCursorPozition
    call PrintAscii0
    call SetCursorPozition
    pop de
    pop bc
    pop af
    ret
    
;*****************************************************************************************************;       
;--------------------------------------     --------------------------------------;
;*****************************************************************************************************;
LcdDelRow:
    push af
    push bc
    ld b, 64
    xor a
LcdDelRowLoop:
    nop
    out (DISPLAY_DATA_LR), a
    djnz LcdDelRowLoop
    xor a
    ld (X_POZ), a
    ld a, %01000000        
    out (DISPLAY_COMMAND_LR), a
    pop bc
    pop af
    ret

;*****************************************************************************************************;       
;-----------------------------------    ------------------------------------;
;*****************************************************************************************************;
CursorON:
    push af
    ld a, i
    or %00000001
    ld i, a
    pop af
    ret
    
;*****************************************************************************************************;       
;-----------------------------------    -----------------------------------;
;*****************************************************************************************************;
CursorOFF:
    push af
    ld a, i
    and %11111110
    ld i, a
    pop af
    ret  
    
;*****************************************************************************************************;       
;-----------------------------------------   -------------------------------------------;
;*****************************************************************************************************;
ShowCursor:
    ld a, (CUR_SYMBOL)
RefreshCursor:
    call GetCursorPozition
    call PrintAscii
    call SetCursorPozition
    ret 
      
 .end