;*****************************************************************************************************;
;                                  Z MONITOR V2.0   03.03.2017                                       ;
;                                        designed by KeKc                                             ;
;                                      special for zx.pk.ru                                           ;
;*****************************************************************************************************;
#define Fosc  7372,8        ;    [K]
#define Fcpu  3686,4        ;    [K]
#define Ftmr  1843,2        ;    [K]

;*****************************************************************************************************;
;-------------------------------------  / --------------------------------------------;
;*****************************************************************************************************;
KEY_LINE_1 .equ $00         ;  1-  
KEY_LINE_2 .equ $10         ;  2-  
KEY_LINE_3 .equ $20         ;  3-  
KEY_LINE_4 .equ $30         ;  4-  

TMR_BASE_PORT .equ $A0      ;   53 
UART_BASE_PORT .equ $C0     ;   51
;DISPLAY_BASE_PORT .equ $D0           ;   LCD
LPT_BASE_PORT .equ $F0      ;   55 

TMR_CHANNEL_0 .equ TMR_BASE_PORT+0
TMR_CHANNEL_1 .equ TMR_BASE_PORT+1
TMR_CHANNEL_2 .equ TMR_BASE_PORT+2
TMR_CONTROL .equ TMR_BASE_PORT+3

UART_COMMAND .equ UART_BASE_PORT+1
UART_DATA .equ UART_BASE_PORT+0

LPT_CHANNEL_0 .equ LPT_BASE_PORT+0
LPT_CHANNEL_1 .equ LPT_BASE_PORT+1
LPT_CHANNEL_2 .equ LPT_BASE_PORT+2
LPT_CONTROL .equ LPT_BASE_PORT+3

;*****************************************************************************************************;
;------------------------------------------  -----------------------------------------------;
;*****************************************************************************************************;
ENT_KEY .equ $10            ;   ENT
DEL_KEY .equ $11            ;   DEL
BAK_KEY .equ $12            ;   BAK
ESC_KEY .equ $13            ;   ESC

KEY_PER_LINE .equ 5         ;    

;*****************************************************************************************************;
;----------------------------------------   ---------------------------------------------;
;*****************************************************************************************************;
CLOCK_HOR .equ $FFEE        ;  
CLOCK_MIN .equ $FFEF        ;  
CLOCK_SEC .equ $FFF0        ;  
CLOCK_MSEC .equ $FFF1       ;   (),   1      NMI

;*****************************************************************************************************;
;----------------------------------    -------------------------------------;
;*****************************************************************************************************;
#define ClearLCD  rst 08h
#define PrintMessage(MES_ADR, NMB_SYM)  ld hl, MES_ADR\ ld b, NMB_SYM\ rst 10h
#define DelayFast  rst 18h
#define WaitAnyKeyPress  rst 20h
#define BeepMessage  rst 28h
#define UserCall  rst 30h
#define PrintSFR  rst 38h

REG1 .equ $FFF2             ;     , 
                            ;   1      NMI (  )
REG2 .equ $FFF3             ;      
REG3 .equ $FFF4             ;      
REG4 .equ $FFF5             ;      
REG5 .equ $FFF6             ;      
REG6 .equ $FFF7             ;      

;X_POZ .equ $FFF8            ;    
;Y_POZ .equ $FFF9            ;    Y
;Z_POZ .equ $FFFA            ;    Z
;CUR_SYMBOL .equ $FFFB       ; ASCII  

RAND_REG0 .equ $FFFC
RAND_REG1 .equ $FFFE

RAM_START .equ $4000        ;  
RAM_END .equ $FFFF          ;  

LPT_MODE .equ %10001011     ;   - , . - 
UART_RESET .equ $40
UART_MODE .equ %01001110    ; 1  ,   , 
                            ;   8 ,    k=16
                                                     
                            ; UART_SPEED = 1228800 / (   * k)
UART_SPEED_DEFAULT .equ 8   ; (0 - 19200, 1 - 9600, 2 - 4800, 3 - 2400, 4 - 1200, 5 - 600, 6 - 300, 7 - 110, 8 - 2)  
UART_DISABLE .equ %00000000 
UART_ENABLE .equ %00100111       
                               
TMR0_MODE .equ %00110110    ;  0 -  3,      
TMR1_MODE .equ %01110100    ;  1 -  2,                                
TMR2_MODE .equ %10110110    ;  2 -  3,                         

NOTE_ADR .equ $01           ;    
;FONT_ADR .equ $02           ;    
;FONT_SIZE_X .equ 6          ;    
;CURSOR_SYM_DEFAULT .equ 95  ; ASCII    

TEMP .equ 120

;  i   
; I(bit0) 0 -   , 1 -  
; I(bit1) 0 -   , 1 -   
; I(bit2) 0 -   , 1 -   


;*****************************************************************************************************;
;--------------------------------------    ---------------------------------------;
;*****************************************************************************************************;
;#define PauseCyc(numCyc)  ld hl, 65535-(numCyc-128)/23\ call Pause
;#define Pausems(numms)  ld hl, 65535-(numms*Fcpu-128)/23\ call Pause

#include "Note.asm"
           
  .org $0000
;*****************************************************************************************************;
;---------------------------------------------   -----------------------------------------;
;*****************************************************************************************************;
    ld sp, $FFEA        ;  
    jp Main
    
ROM_CRC:
    .dw $FFFF
    
  .org $0008
;*****************************************************************************************************;
;------------------------------------    -----------------------------------;
;*****************************************************************************************************;
    jp $086A
    .db $FF
    .db $FF
    .db $FF
    .db $FF
    .db $FF
      
  .org $0010
;*****************************************************************************************************;     
;-------------------------------------     ------------------------------------;
;*****************************************************************************************************; 
                        ;  -   
    ld a, (hl)          ; HL-     
    call PrintAscii
    inc hl
    djnz $0010
    ret     
 
  .org $0018
;*****************************************************************************************************;
;------------------------------------------  0,2 c-----------------------------------------------;
;*****************************************************************************************************; 
    push af
    push hl       
    ld hl, $82CD
    jp Pause2

  .org $0020
;*****************************************************************************************************;
;----------------------------------    -------------------------------------;
;*****************************************************************************************************;     
    call Key_scan
    jp z, $0020
    DelayFast
    ret
    
;*****************************************************************************************************;       
;-------------------------------------    --------------------------------------;
;*****************************************************************************************************;  
  .org $0028 
    push hl
    call Beep_music
    pop hl
    ret
    .db $FF
    .db $FF   

;*****************************************************************************************************; 
;-----------------------------------------    04004 ----------------------------------;
;*****************************************************************************************************; 
  .org $0030
    jp $4004
    .db $FF
    .db $FF
    .db $FF
    .db $FF
    .db $FF
            
  .org $0038       
;*****************************************************************************************************;        
;--------------------------------------------  INT -----------------------------------------;
;*****************************************************************************************************;
    ret;push af
    push bc
    push hl
    call RegInfo
    PrintMessage(PRESS_ANY_KEY_MESSAGE-1, 22) 
    BeepMessage     
    WaitAnyKeyPress         ;     
    pop hl
    pop bc
    pop af
    ei
    ret
    
;*****************************************************************************************************;       
;-------------------------------------------  X  -----------------------------------------------;
;*****************************************************************************************************; 
;    ld hl, nn
;    call Pause 
Pause:
    push af ;11
    push hl ; 11
Pause2:
    push bc ; 11
    ld bc, $0001 ;10
PauseLoop:
    add hl, bc ;11
    jr nc, PauseLoop ;12 (7)
    pop bc ;10
    pop hl  ;10
    pop af ;10
    ret ;(10) +call (17)+ ld hl, nn (10)
    
 ;delay(cycles)=128+23*(65535-nn)
  
 ;nn(cycles)=65535-(DelayCyc-128)/23
  
 ;nn(ms)=65535-(Delayms*Fcpu-128)/23
 
;*****************************************************************************************************;       
;-------------------------------------     ---------------------------------------;
;*****************************************************************************************************;
InputNumber:         
    WaitAnyKeyPress             ;     
    cp ENT_KEY                  ; Z=0 -   ENT  
    ret                         ; C=1    0...F
                                ; C=0     (ENT, DEL, BAK, ESC) 
    
;*****************************************************************************************************;       
;--------------------------------    ---------------------------------;
;*****************************************************************************************************;        
StopMusic:
    push af
    ld a, i
    and %11111101
    ld i, a
    pop af
    ret
    .db $FF
        
  .org $0066       
;*****************************************************************************************************;        
;-----------------------------------------  NMI --------------------------------------------;
;*****************************************************************************************************;   
; I(bit0) - enable cursor
; I(bit1) - play music
; I(bit2) - enable clock                                
Timer_int:
    push af
    push hl  
      
    ld hl, CLOCK_MSEC 
    ld a, (hl)
    add a, 1
    daa
    ld (hl), a
    cp $60
    call z, Sec_int
    
    ld a, i     
    and %00000001   
    jp z, Music_int     
      
    ld a, (hl)
    cp $30
    call z, ShowCursor
    cp 0
    call z, RefreshCursor 
         
Music_int:     
    ld a, i
    and %00000010    
    jp z, Exit_int
    
    inc hl      ; HL=REG1 ($FFF2)
    dec (hl)    ; (REG1)=(REG1)-1
    jp nz, Exit_int
    
    ld hl, (REG2) ; H=(REG3), L=(REG2)
    ld a, (hl)    ; A=(REG3,REG2)
    cp 0
    jp z, Stop_sound   
    cp 1
    jp z, Repeat_sound      
            
    ld (REG1), a  ; (REG1)=A             
    
    inc hl      ; REG3,REG2=REG3,REG2+1
    ld a, (hl)
    inc hl
    ld (REG2), hl    
    cp 108
    jp nc, Stop_sound
    add a, a    ; A=A*2
    jp z, Pause_sound
        
    ld h, NOTE_ADR
    ld l, a
    ld a, TMR0_MODE        
    out (TMR_CONTROL), a 
    ld a, (hl)
    out (TMR_CHANNEL_0), a
    inc hl
    ld a, (hl)
    out (TMR_CHANNEL_0), a             
    jp Exit_int  
    
Stop_sound:
    ld a, i
    and %11111101
    ld i, a   
Pause_sound:
    ld a, TMR0_MODE        
    out (TMR_CONTROL), a             
    jp Exit_int    
Repeat_sound:
    ld a, (REG4)
    ld (REG2), a
    ld a, (REG5)
    ld (REG3), a
    ld a, 1
    ld (REG1), a    
Exit_int:
    pop hl
    pop af
    retn
        
    .db $FF, $FF, $FF, $FF, $FF, $FF, $FF, $FF
    
;*****************************************************************************************************;
;----------------------------------------   UART -------------------------------------;
;*****************************************************************************************************;
UART_SPEED_const:   
    .dw $0006 ; 19200              (0)
    .dw $000C ; 9600               (1) 
    .dw $0018 ; 4800               (2)             
    .dw $0030 ; 2400               (3)
    .dw $0060 ; 1200               (4)
    .dw $00C0 ; 600                (5)
    .dw $0180 ; 300                (6)
    .dw $0417 ; 110                (7)
    .dw $E100 ; 2        (8)                                                    
                            
;*****************************************************************************************************;
;-----------------------------------------    ----------------------------------------;
;*****************************************************************************************************;
;  .org $0100    
Note_table:
.dw $0000, $0000
;     A0    A#0    H0     C0     C#1    D1     D#1    E1     F1     F#1    G1     G#1    
.dw $0000, $F720, $E941, $DC29, $CFCE, $C424, $B922, $AEBE, $A4EF, $9BAE, $92F1, $8AB2
;     A1    A#1    H1     C1     C#2    D2     D#2    E2    F2      F#2    G2     G#2    
.dw $82E9, $7B90, $74A0, $6E15, $67E7, $6212, $5C91, $575F, $5278, $4DD7, $4978, $4559
;     A2    A#2    H2     C2     C#3    D3     D#3    E3    F3      F#3    G3     G#3    
.dw $4174, $3DC8, $3A50, $370A, $33F4, $3109, $2E49, $2BB0, $293C, $26EB, $24BC, $22AC
;     A3    A#3    H3     C3     C#4    D4     D#4    E4    F4      F#4    G4     G#4    
.dw $20BA, $1EE4, $1D28, $1B85, $19FA, $1885, $1724, $15D8, $149E, $1376, $125E, $1156
;     A4    A#4    H4     C4     C#5    D5     D#5    E5    F5      F#5    G5     G#5    
.dw $105D, $0F72, $0E94, $0DC3, $0CFD, $0C42, $0B92, $0AEC, $0A4F, $09BB, $092F, $08AB
;     A5    A#5    H5     C5     C#6    D6     D#6    E6    F6     F#6     G6     G#6    
.dw $082F, $07B9, $074A, $06E1, $067E, $0621, $05C9, $0576, $0527, $04DD, $0498, $0456
;     A6    A#6    H6     C6     C#7    D7     D#7    E7    F7     F#7     G7     G#7    
.dw $0417, $03DC, $03A5, $0371, $033F, $0311, $02E5, $02BB, $0294, $026F, $024C, $022B
;     A7    A#7    H7     C7     C#8    D8     D#8    E8    F8     F#8     G8     G#8    
.dw $020C, $01EE, $01D3, $01B8, $01A0, $0188, $0172, $015D, $014A, $0137, $0126, $0115
;     A8    A#8    H8     C8     C#9    D9     D#9    E9    F9     F#9   
.dw $0106, $00F7, $00E9, $00DC, $00D0, $00C4, $00B9, $00AF, $00A5, $009C

Beep_music:
    ld hl, Beep_note    
;*****************************************************************************************************;       
;--------------------------------------   --------------------------------------;
;*****************************************************************************************************;
Play_music:
    push af          ;     HL
    ld a, l
    ld (REG2), a
    ld (REG4), a
    ld a, h
    ld (REG3), a
    ld (REG5), a
    ld a, 1
    ld (REG1), a
    ld a, i
    or %00000010
    ld i, a
    pop af
    ret      

Beep_note:
    NOTE(10, E4_NOTE)
    STOP_MUSIC
Beep_note2:
    NOTE(10, E4_NOTE)
    NOTE(10, PAUSE_NOTE)
    REPEAT_MUSIC 
    .db $FF         

#include "Display_Driver.asm"
    
;*****************************************************************************************************;
;--------------------------------------   ----------------------------------------;
;*****************************************************************************************************;                           
Main:
    ld a, TMR1_MODE         ;  TMR1
    out (TMR_CONTROL), a
    ld hl, $AA55            ;   
    push hl                 ;  55  
    pop hl                  ;   .
    ld a, h                 ;   
    cp $AA
    jp nz, SystemFail      ;     
    ld a, l                 ;  
    cp $55
    jp nz, SystemFail  
    
    im 1
    xor a
    ld i, a
    ld a, CURSOR_SYM_DEFAULT
    ld (CUR_SYMBOL), a
    
    DelayFast   
    ld a, %00111111       ;   
    out (DISPLAY_COMMAND_LR), a   

    ld a, LPT_MODE         ;  55
    out (LPT_CONTROL), a 
    xor a
    out (LPT_CHANNEL_0), a
    out (LPT_CHANNEL_1), a
    out (LPT_CHANNEL_2), a                    
    
    ld a, TMR0_MODE        ;  53
    out (TMR_CONTROL), a       
    ld a, TMR1_MODE
    out (TMR_CONTROL), a
    ld a, $00       
    out (TMR_CHANNEL_1), a  
    ld a, $78      
    out (TMR_CHANNEL_1), a 
    
    ld a, UART_SPEED_DEFAULT
    call Set_uart_speed            
             
    xor a                   ;  BB51
    out (UART_COMMAND), a 
    out (UART_COMMAND), a 
    out (UART_COMMAND), a             
    ld a, UART_RESET        ;   51     
    out (UART_COMMAND), a   
    ld a, UART_MODE         ;   
    out (UART_COMMAND), a   
    ld a, UART_DISABLE      ;    UART
    out (UART_COMMAND), a 

    call CursorOFF
    call ClockON
    BeepMessage
    di  
;*****************************************************************************************************;
;------------------------------------   -----------------------------------------------;
;*****************************************************************************************************;
Menu_1: 
    ClearLCD   
    PrintMessage(START_MESSAGE, 140) ;    
Main_loop:                      ; ,   
    WaitAnyKeyPress
    cp $F
    jp z, Menu_2    
    cp $E
    jp nc, Main_loop        
    ld hl, Main_menu_table  
    add a, a
    add a, l
    ld l, a
    jr nc, $+3
    inc h
    ld e, (hl)
    inc hl
    ld d, (hl)
    ex de, hl
    jp (hl)
Main_menu_table: 
    .dw Menu_1
    .dw Write_ram 
    .dw Read_ram 
    .dw Start_programm 
    .dw Load_uart 
    .dw Unload_uart 
    .dw CHECKSUM 
    .dw Copy_data 
    .dw Move_adr 
    .dw IO_work 
    .dw Games 
    .dw Terminal 
    .dw Programs
    .dw TestSystem 
    
Menu_2:
    ClearLCD
    PrintMessage(START_MESSAGE_2, 114) 
    jp Main_loop 

;*****************************************************************************************************;
;-------------------------------------------   ------------------------------------------;
;*****************************************************************************************************;
Sec_int:            ;   1   
    ld a, i
    and %00000100
    ret z
    
    push hl
    xor a
    ld (hl), a
    dec hl          ; HL=$FFF0
    ld a, (hl)
    add a, 1
    daa
    ld (hl), a
    cp $60
    jp nz, Exit_clock_int
Min_int:
    xor a
    ld (hl), a
    dec hl          ; HL=$FFEF
    ld a, (hl)
    add a, 1
    daa
    ld (hl), a
    cp $60
    jp nz, Exit_clock_int
Hor_int:
    xor a
    ld (hl), a
    dec hl          ; HL=$FFEE
    ld a, (hl)
    add a, 1
    daa
    ld (hl), a
    cp $24
    jp nz, Exit_clock_int
Day_int:
    xor a
    ld (hl), a
Exit_clock_int:
    pop hl
    ret
    
;*****************************************************************************************************;        
;------------------------------------    ----------------------------------;
;*****************************************************************************************************;  
Rnd:
    push de
    push hl
    ld hl, (RAND_REG0)    ;    
    ld de, (RAND_REG1)    ;    
    ld (RAND_REG1), hl    ; 0...255  
    ld a, r
    sbc a, l         
    add a, a        
    add a, a 
    add a, a
    xor l
    ld l, a
    ld a, d
    add a, a
    xor d
    ld h, a
    rra
    xor h
    xor l
    ld h, e
    ld l, a
    ld (RAND_REG0), hl
    pop hl
    pop de   
    ret
                                                                                                                                                                  
;*****************************************************************************************************;       
;---------------------------------------   -------------------------------------------;
;*****************************************************************************************************; 
Key_scan:               ;      
    in a, (KEY_LINE_4)  ;    
    call RowScan       ; FF -     , Z=1
    ret nz
Row_1:
    in a, (KEY_LINE_3)
    call RowScan
    jp z, Row_2
    add a, KEY_PER_LINE
    ret
Row_2:
    in a, (KEY_LINE_2)
    call RowScan
    jp z, Row_3
    add a, KEY_PER_LINE*2
    ret  
Row_3:
    in a, (KEY_LINE_1)
    call RowScan
    ret z
    add a, KEY_PER_LINE*3
    ret                     
          
;*****************************************************************************************************;        
;----------------------------------      -----------------------------;
;*****************************************************************************************************;    
RowScan:  
    push bc         ;     
    ld b, 8         ;       A
KeyLoop:           ;       =FF, Z=1
    rla
    jp nc, KeyEndScan
    djnz KeyLoop
KeyEndScan:
    ld a, b
    dec a
    cp $FF
    pop bc
    ret


;*****************************************************************************************************;       
;-------------------------------------    --------------------------------------;
;*****************************************************************************************************;
ClockON:
    push af
    ld a, i
    or %00000100
    ld i, a
    pop af
    ret
    
;*****************************************************************************************************;       
;-------------------------------------    -------------------------------------;
;*****************************************************************************************************;
ClockOFF:
    push af
    ld a, i
    and %11111011
    ld i, a
    pop af
    ret
    
;*****************************************************************************************************;      
;-------------------------------------     ---------------------------------------;
;*****************************************************************************************************;
InputA:
    push bc
    call InputNumber   
    jr c, InputA2
    cp BAK_KEY
    jr nc, InputAend
    jr InputA
InputA2:
    call PrintHEX
    rla
    rla
    rla
    rla
    and $F0
    ld c, a
InputA3:
    call InputNumber 
    jr c, InputA4
    cp BAK_KEY
    jr nc, InputAend
    cp DEL_KEY
    jr nz, InputA3
    call BackSymbol
    jr InputA    
InputA4:
    call PrintHEX
    add a, c
    ld c, a
InputA5:
    call InputNumber
    jr z, InputAend2
    cp BAK_KEY
    jr nc, InputAend
    cp DEL_KEY
    jr nz, InputA5
    call BackSymbol
    jr InputA3    
InputAend:
    scf
InputAend2:
    ld a, c
    pop bc
    ret    
    
;*****************************************************************************************************;        
;----------------------------------       BC ---------------------------------;
;*****************************************************************************************************;
InputBC:
    push hl
    call InputHL
    ld b, h
    ld c, l
    pop hl
    ret
    
;*****************************************************************************************************;        
;----------------------------------       DE ---------------------------------;
;*****************************************************************************************************;
InputDE:
    push hl
    call InputHL
    ex de, hl
    pop hl
    ret
            
;*****************************************************************************************************;       
;-----------------------------------       HL --------------------------------;
;*****************************************************************************************************;
InputHL:
    push bc
InputHL_loop:
    call InputNumber
    jr nc, InputHL_loop
    call PrintHEX
    rla
    rla
    rla
    rla
    and $F0
    ld h, a
InputHL_loop_2:    
    call InputNumber
    jr c, InputHL_loop_3   ; =1 -> 0...F
    jr z, InputHL_loop_2   ; Z=1 -> Enter
    call BackSymbol        
    jr InputHL_loop 
InputHL_loop_3:         
    call PrintHEX
    add a, h
    ld h, a 
InputHL_loop_4:    
    call InputNumber
    jr c, InputHL_loop_5   ; =1 -> 0...F
    jr z, InputHL_loop_4   ; Z=1 -> Enter
    call BackSymbol        
    jr InputHL_loop_2
InputHL_loop_5:     
    call PrintHEX
    rla
    rla
    rla
    rla
    and $F0
    ld l, a 
InputHL_loop_6:              
    call InputNumber
    jr c, InputHL_loop_7   ; =1 -> 0...F
    jr z, InputHL_loop_6   ; Z=1 -> Enter
    call BackSymbol        
    jr InputHL_loop_4         
InputHL_loop_7:         
    call PrintHEX
    add a, l
    ld l, a   
InputHL_loop_8:       
    call InputNumber
    jr c, InputHL_loop_8 
    jr z, End_InputHL
    call BackSymbol
    jr InputHL_loop_6
End_InputHL:
    pop bc
    ret 
         
;*****************************************************************************************************;       
;-------------------------------------------  BC  HL --=====================-----------------;
;*****************************************************************************************************;
Compare_bc_hl:
    ld a, b         ; Z=1 -> BC=HL
    cp h            ; C=0 -> BC>=HL
    ret nz          ; C=1 -> BC<HL
    ld a, c
    cp l
    ret
    
;*****************************************************************************************************;        
;------------------------------------------  DE  HL -----------------------------------------;
;*****************************************************************************************************;
Compare_de_hl:
    ld a, d         ; Z=1 -> DE=HL
    cp h            ; C=0 -> DE>=HL
    ret nz          ; C=1 -> DE<HL
    ld a, e
    cp l
    ret 

;*****************************************************************************************************;        
;------------------------------------------  BC  DE -----------------------------------------;
;*****************************************************************************************************;
Compare_bc_de:
    ld a, b         ; Z=1 -> BC=DE
    cp d            ; C=0 -> BC>=DE
    ret nz          ; C=1 -> BC<DE
    ld a, c
    cp e
    ret 
           
;*****************************************************************************************************;        
;-------------------------------------   UART --------------------------------------;
;*****************************************************************************************************;        
Set_uart_speed:
    push hl
    ld hl, UART_SPEED_const ;  
    cp 9                   ; C=1    
    ret nc                  ; =0    ,
    add a, a               ;   
    add a, l
    ld l, a 
      
    ld a, TMR2_MODE        ;   UART
    out (TMR_CONTROL), a    
    ld a, (hl)       
    out (TMR_CHANNEL_2), a
    inc hl  
    ld a, (hl)    
    out (TMR_CHANNEL_2), a
    pop hl
    scf
    ret   
    
;*****************************************************************************************************;       
;--------------------------------------    RS232 -----------------------------------------;
;*****************************************************************************************************;       
RxD:  
    in a, (UART_COMMAND) 
    and %00000010
    jr z, RxD               ;    
    in a, (UART_DATA)
    ret   

;*****************************************************************************************************;        
;------------------------------------    RS232 ----------------------------------------;
;*****************************************************************************************************;    
TxD:
    push de
    ld e, a
    in a, (UART_COMMAND)
    and %00000001
    ld a, e
    pop de
    jr z, TxD           ;   
    out (UART_DATA), a 
    ret          
                
;*****************************************************************************************************;        
;--------------------------------------- 1.    ---------------------------------------------;
;*****************************************************************************************************;
Write_ram:
    call Ram_MESSAGE
Write_ram_loop:
    call PrintHL
    call PrintAscii0
    call InputA
    jr nc, Write_ram_loop2
    call LcdDelRow
    cp ESC_KEY
    jr z, Write_ram_loop
    dec hl
    jr Write_ram_loop    
Write_ram_loop2:
    ld (hl), a
    call LcdCRLF
    inc hl
    jr Write_ram_loop
    
;*****************************************************************************************************;       
;---------------------------------------- 2.   ----------------------------------------------;
;*****************************************************************************************************;   
Read_ram:
    call Ram_MESSAGE        
Read_ram_loop:
    call PrintHL       ;      
    call PrintAscii0
    ld a, (hl)         ;  . DEL -   
    call PrintA        ;  , BAK -    
    WaitAnyKeyPress             
    cp BAK_KEY
    jr nz, Read_ram_loop1
    call LcdDelRow
    dec hl
    jr Read_ram_loop    
Read_ram_loop1:    
    cp DEL_KEY
    call z, Step_back   
    call LcdCRLF
    inc hl
    jr Read_ram_loop 
Step_back:
    call LcdDelRow
    call PrintHL
    call PrintAscii0
    call InputA
    ld (hl), a 
    ret                        

;*****************************************************************************************************;       
;----------------------------------------- 3.   -----------------------------------------;
;*****************************************************************************************************;
Start_programm:
    ClearLCD
    PrintMessage(PROG_START_MESSAGE, 20) 
    call InputHL
    jp (hl)

;*****************************************************************************************************;        
;-------------------------------------- 4.    RS232 -------------------------------------;
;*****************************************************************************************************;
Load_uart:
    call Uart_speed
    ClearLCD
    PrintMessage(UART_MESSAGE_6, 42)
    PrintMessage(ADR_CORRECT_MESSAGE2, 16)
    call InputNumber
    jr z, Load_uart_loop2
    
    PrintMessage(UART_MESSAGE_3, 16)
    ld a, UART_ENABLE         ;    UART
    out (UART_COMMAND), a     
    in a, (UART_DATA) 

    call RxD ; DE =  
    ld e, a
    call RxD 
    ld d, a
    call RxD ; HL =       
    ld l, a
    call RxD 
    ld h, a
    push de                                 
 
Load_uart_loop:
    call RxD
    ld (de), a     
    call Compare_de_hl
    inc de     
    jr nz, Load_uart_loop 
    jp Uart_end
       
Load_uart_loop2:   
    call UART_MESSAGE
    PrintMessage(UART_MESSAGE_3, 16)
    ld a, UART_ENABLE         ;    UART
    out (UART_COMMAND), a     
    in a, (UART_DATA)
    push de
    jr Load_uart_loop

;*****************************************************************************************************;        
;------------------------------------- 5.    RS232 -----------------------------------;
;*****************************************************************************************************;        
Unload_uart: 
    call Uart_speed
    call UART_MESSAGE
    ClearLCD
    push de
    push hl
    PrintMessage(UART_MESSAGE_7, 42)
    PrintMessage(ADR_CORRECT_MESSAGE2, 16)
    call InputNumber
    push af    
    PrintMessage(UART_MESSAGE_4, 19)   
    ld a, UART_ENABLE
    out (UART_COMMAND), a
    pop af    
    pop hl
    
    jr nz, Unload_uart_loop
    ld a, e
    call TxD
    ld a, d
    call TxD
    ld a, l
    call TxD
    ld a, h
    call TxD              
    
Unload_uart_loop:
    ld a, (de)
    call TxD  
    call Compare_de_hl
    inc de
    jr nz, Unload_uart_loop
    
Uart_end:
    ld a, %00000101      
    out (UART_COMMAND), a 
    push hl
    PrintMessage(UART_MESSAGE_5, 20)
    pop hl
    pop de
    jp CHECKSUM_start                                             
    
;*****************************************************************************************************;       
;--------------------------------- 6.    -----------------------------------;
;*****************************************************************************************************;
CHECKSUM:
    call UART_MESSAGE
CHECKSUM_start:    
    ld bc, $0000
CHECKSUM_loop:    
    ld a, (de)
    add a, c
    ld c, a
    jr nc, Check_2
    inc b
Check_2: 
    call Compare_de_hl
    inc de    
    jr nz, CHECKSUM_loop
    push bc
    PrintMessage(CHECKSUM_MESSAGE, 19)
    pop bc  
    call PrintBC
    PrintMessage(PRESS_ANY_KEY_MESSAGE-1, 22) 
    BeepMessage     
    WaitAnyKeyPress         ;      
    rst 00h 
     
;*****************************************************************************************************;        
;----------------------------------------- 7.  --------------------------------------------;
;*****************************************************************************************************;
Copy_data:
    call UART_MESSAGE      ; DE -  
    push hl             ; HL -  ,  -  
    PrintMessage(COPY_ADR_MESSAGE, 20)
    call InputBC
    pop hl 
    push bc
    push de
    push hl
Copy_data_loop:
    ld a, (de)
    ld (bc), a
    call Compare_de_hl
    inc de  
    inc bc         
    jp nz, Copy_data_loop
Copy_data_end:
    PrintMessage(UART_MESSAGE_5-1, 21)
    PrintMessage(ADR_CORRECT_MESSAGE, 51)
Copy_data_loop2:    
    WaitAnyKeyPress
    cp ENT_KEY
    jp z, Arress_correct
    cp ESC_KEY
    jr nz, Copy_data_loop2       
    jp Correct_end    
    
;*****************************************************************************************************;        
;----------------------------------------- 8.   -----------------------------------------;
;*****************************************************************************************************;  
Move_adr:
    call UART_MESSAGE      ; DE -  
    push hl             ; HL -  ,  -  
    PrintMessage(COPY_ADR_MESSAGE, 20)
    call InputBC
    pop hl 
    push bc
    push de
    push hl     
               
Arress_correct:
    PrintMessage(ADR_CORRECT_MESSAGE3, 27)
    PrintMessage(ADR_CORRECT_MESSAGE2, 16)
Correct_adr_loop:      
    WaitAnyKeyPress
    cp ENT_KEY
    jr z, Correct_start
    cp ESC_KEY
    jr nz, Correct_adr_loop
    xor a
Correct_start: 
    ld (REG6), a            
    pop hl
    pop de
    pop bc     
        
    ld a, c     ; DE=BC-DE -       
    sub e
    ld e, a
    ld a, b
    sbc a, d
    ld d, a
    add hl, de ; HL=  
    
Correct_adr_loop2:    
    ld a, (bc)
    cp %11000011        ; jp nn
    jp z, Correct_adr 
    cp %11001101        ; call nn
    jp z, Correct_adr 
    and %11000111
    cp %11000010        ; jp cc, nn
    jp z, Correct_adr
    cp %11000100        ; call cc, nn
    jp z, Correct_adr
Correct_adr_loop3:     
    call Compare_bc_hl
    inc bc
    jp c, Correct_adr_loop2
Correct_end:  
    PrintMessage(UART_MESSAGE_5, 20)    
    PrintMessage(PRESS_ANY_KEY_MESSAGE, 21) 
    BeepMessage     
    WaitAnyKeyPress         ;     
    rst 00h                   
  
Correct_adr:
    push hl
    inc bc
    ld a, (bc)
    ld l, a
    inc bc
    ld a, (bc)
    ld h, a
    cp $40
    jp nc, Correct_adr2
    ld a, (REG6)
    cp 0
    jp z, Correct_adr_loop3       
Correct_adr2:    
    add hl, de
    ld a, h
    ld (bc), a
    dec bc
    ld a, l
    ld (bc), a
    inc bc
    jp Correct_adr_loop3
    
;*****************************************************************************************************;        
;------------------------------------ 9.     -----------------------------------------;
;*****************************************************************************************************;         
IO_work:
    ClearLCD    
    PrintMessage(IO_MESSAGE_1, 20)
    call InputBC
    push bc    
    PrintMessage(IO_MESSAGE_2-1, 21)
IO_work_loop:        
    WaitAnyKeyPress
    cp ENT_KEY
    jr z, IO_work_in
    cp ESC_KEY
    jr z, IO_work_out
    jr IO_work_loop
    
IO_work_in:
    pop bc
    in a, (c)
    call PrintA
IO_work_end:     
    PrintMessage(PRESS_ANY_KEY_MESSAGE-1, 22)
    WaitAnyKeyPress
    jr IO_work      

IO_work_out:
    PrintMessage(IO_MESSAGE_3, 26)
    call InputA
    pop bc 
    out (c), a    
    jr IO_work_end  
      
;*****************************************************************************************************;        
;------------------------------------------ A.  --------------------------------------------------;
;*****************************************************************************************************;        
Games:
    ClearLCD
    PrintMessage(GAMES_MESSAGE, 44) 
GamesLoop:     
    WaitAnyKeyPress
    dec a
    jp z, Game_rasing   ;  =1
    dec a
    jp z, Game_snake    ;  =2
    dec a
    jp z, Game_tetris   ;  =3        
    jr GamesLoop  
    
;*****************************************************************************************************;        
;----------------------------------------- B.  -----------------------------------------------;
;*****************************************************************************************************;              
Terminal:
    call Uart_speed
    ClearLCD
    PrintMessage(TERMINAL_MESSAGE, 16)
    ld a, UART_ENABLE         ;    UART
    out (UART_COMMAND), a     
    in a, (UART_DATA)
T_data:
    ld hl, T_data
    push hl
    in a, (UART_COMMAND) 
    and %00000010
    jr z, Terminal_2               ;    
    in a, (UART_DATA)

    cp $7F
    jp z, DelSymbol    
    cp $20
    jp nc, PrintAscii 
           
    ld hl, Terminal_table  
    add a, a
    add a, l
    ld l, a
    jr nc, $+3
    inc h
    ld e, (hl)
    inc hl
    ld d, (hl)
    ex de, hl
    jp (hl)
Terminal_table:
    .dw NOP_COMMAND                     ; 00
    .dw START_OF_HEADING                ; 01
    .dw START_OF_TEXT                   ; 02 
    .dw END_OF_TEXT                     ; 03
    .dw END_OF_TRANSMITTION             ; 04 
    .dw ENQUIRE                         ; 05
    .dw ACKNOWLEDGEMENT                 ; 06 
    .dw BELL                            ; 07
    .dw BackSymbol ;BACKSPASE          ; 08 
    .dw HORIZONTAL_TAB                  ; 09
    .dw LINE_FEED                       ; 0A
    .dw VERTICAL_TAB                    ; 0B
    .dw ResetLCD ;FORM_FEED            ; 0C
    .dw CARRIAGE_RETURN                 ; 0D
    .dw NOP_COMMAND ;SHIFT_OUT          ; 0E
    .dw NOP_COMMAND ;SHIFT_IN           ; 0F
    .dw DATA_LINK_ESCAPE                ; 10
    .dw NOP_COMMAND ;DEVICE_CONTROL_1   ; 11
    .dw NOP_COMMAND ;DEVICE_CONTROL_2   ; 12
    .dw DEVICE_CONTROL_3                ; 13
    .dw NOP_COMMAND ;DEVICE_CONTROL_4   ; 14
    .dw NEGATIVE_ACKNOWLEDGMENT         ; 15
    .dw NOP_COMMAND ;SYNCHRONIZATION    ; 16
    .dw END_OF_TEXT_BLOCK               ; 17
    .dw LcdDelRow ;CANCEL             ; 18
    .dw END_OF_MEDIUM                   ; 19
    .dw NOP_COMMAND ;SUBSTITUTE         ; 1A
    .dw NOP_COMMAND ;ESCAPE             ; 1B
    .dw NOP_COMMAND ;FILE_SEPARATOR     ; 1C
    .dw NOP_COMMAND ;GROUP_SEPARATOR    ; 1D  
    .dw NOP_COMMAND ;RECORD_SEPARATOR   ; 1E
    .dw NOP_COMMAND ;UNIT_SEPARATOR     ; 1F
    
Terminal_2:
    call Key_scan
    ret z
    call InputA
    call TxD
    call LcdCRLF
    ld a, $3E
    call PrintAscii
    
;*****************************************************************************************************;    
NOP_COMMAND:
;  
    nop
    ret
    
;*****************************************************************************************************;   
START_OF_HEADING:
;  
    PrintMessage(START_OF_HEADING_MESSAGE, 12)
    ret

;*****************************************************************************************************;                    
START_OF_TEXT:
;  
    PrintMessage(START_OF_TEXT_MESSAGE, 8)
    ret

;*****************************************************************************************************;
END_OF_TEXT:
;  
    PrintMessage(END_OF_TEXT_MESSAGE, 15)
    ret       

;*****************************************************************************************************;
END_OF_TRANSMITTION:
;  
    PrintMessage(END_OF_TRANSMITTION_MESSAGE, 17)
    ret

;*****************************************************************************************************;
ENQUIRE:
;       .
    ld hl, ENQUIRE_MESSAGE
    ld b, 10
    
    ld a, (hl)
    call TxD  
    inc hl
    djnz $-5
    ret  

;*****************************************************************************************************;
ACKNOWLEDGEMENT:
; 
    PrintMessage(ACKNOWLEDGEMENT_MESSAGE, 14)
    ret   

;*****************************************************************************************************;
BELL: 
;   
    BeepMessage
    ret

;*****************************************************************************************************;
HORIZONTAL_TAB:
; 
    PrintMessage(HORIZONTAL_TAB_message, 4)
    ret

;*****************************************************************************************************;
LINE_FEED:
;  
    ld a, (X_POZ)
    call LcdCRLF
    call LcdSetX
    ret     

;*****************************************************************************************************;
VERTICAL_TAB:
;  
    call LINE_FEED
    jr LINE_FEED

;*****************************************************************************************************;       
CARRIAGE_RETURN:
;     
    push af
    ld a, %01000000
    out (DISPLAY_COMMAND_LR), a            
    xor a
    ld (X_POZ), a
    ld a, $3E
    call PrintAscii
    pop af
    ret

;*****************************************************************************************************;
DATA_LINK_ESCAPE:
;   
; ,          ,     .
    call RxD
    jp PrintAscii

;*****************************************************************************************************;
DEVICE_CONTROL_3:
;     ()  .
    call RxD
    cp $11
    jr nz, DEVICE_CONTROL_3
    ret

;*****************************************************************************************************;
NEGATIVE_ACKNOWLEDGMENT:
;  
    PrintMessage(NEGATIVE_ACKNOWLEDGMENT_MESSAGE, 17)
    ret          

;*****************************************************************************************************;
END_OF_TEXT_BLOCK:
;    
    PrintMessage(END_OF_TEXT_BLOCK_MESSAGE, 14)
    ret

;*****************************************************************************************************;
END_OF_MEDIUM:
;  , .,     ..
    PrintMessage(END_OF_MEDIUM_MESSAGE, 17)
    ret
    
;*****************************************************************************************************;        
;--------------------------------------- C.  ------------------------------------------------;
;*****************************************************************************************************; 
Programs:
    ClearLCD
    PrintMessage(PROGRAMS_MESSAGE, 53)
Programs_loop:
    WaitAnyKeyPress
    dec a
    jp z, Calc       ;  =1
    dec a
    jp z, Timer        ;  =2
    dec a
    jp z, Generator   ;  =3        
    jp Programs_loop 
    
;*****************************************************************************************************;        
;----------------------------------------- D.   -------------------------------------------;
;*****************************************************************************************************;    
TestSystem:
    ClearLCD
    PrintMessage(RAM_TEST_MESSAGE, 12)  
    ld hl, RAM_START
    ld bc, RAM_END
    ld de, $0000
    
;*****************************************************************************************************;       
;-------------------------------------------   ------------------------------------------------;
;*****************************************************************************************************; 
RAM_TEST_loop: 
    ld a, (hl)
    push af
    ld a, $55
    ld (hl), a
    cp (hl)
    jp nz, Ram_err
    
    ld a, $AA
    ld (hl), a
    cp (hl)
    jp nz, Ram_err 
Rtstl: 
    pop af
    ld (hl), a  
    inc hl     
    call Compare_bc_hl     
    jp nz, RAM_TEST_loop
    
    PrintMessage(RAM_END_MESSAGE, 33) 
    call PrintDE   
    PrintMessage(PRESS_ANY_KEY_MESSAGE-1, 22) 
    BeepMessage     
    WaitAnyKeyPress         ;                          

;*****************************************************************************************************;       
;-------------------------------------------   ------------------------------------------------;
;*****************************************************************************************************;
Rom_test:
    ClearLCD
    PrintMessage(ROM_TEST_MESSAGE, 12)
    ld bc, $0000
    ld de, $0008
    ld hl, END_OF_ROM
Rom_check_loop:    
    ld a, (de)
    add a, c
    ld c, a
    jr nc, Rom_check_2
    inc b
Rom_check_2: 
    call Compare_de_hl
    inc de    
    jr nz, Rom_check_loop
       
    ld hl, (ROM_CRC)
    call Compare_bc_hl
    jr nz, Rom_check_err
    
    PrintMessage(ROM_OK_MESSAGE, 13)
    jr Rom_check_end
Rom_check_err:
    PrintMessage(ROM_ERR_MESSAGE, 11)
Rom_check_end:
    PrintMessage(PRESS_ANY_KEY_MESSAGE, 21)
    BeepMessage      
    WaitAnyKeyPress         ;        

;*****************************************************************************************************;       
;------------------------------------------   ---------------------------------------------;
;*****************************************************************************************************; 
Display_test:         
    ClearLCD
    ld b, 252
    xor a
Display_test_loop:          
    inc a
    ld hl, $EFFF
    call Pause
    call PrintAsciiNoCRLF
    djnz Display_test_loop
    
    PrintMessage(PRESS_ANY_KEY_MESSAGE, 21)
    BeepMessage      
    WaitAnyKeyPress         ;      

;*****************************************************************************************************;        
;---------------------------------------   ---------------------------------------------;
;*****************************************************************************************************;                                                                              
Kb_test:
    ClearLCD
    PrintMessage(KB_TEST_MESSAGE, 41)
KB_TEST_loop:    
    WaitAnyKeyPress         ;      
    call PrintA
    call PrintAscii0
    jr KB_TEST_loop          
         
;*****************************************************************************************************; 
Ram_MESSAGE:
    ClearLCD
    PrintMessage(RAM_MESSAGE_START, 18)
    call InputHL  
    ClearLCD 
    ret  
    
;*****************************************************************************************************;
UART_MESSAGE:                      ;   
    ClearLCD              ; DE =  
    PrintMessage(UART_MESSAGE_1, 17)    ; HL =    
    call InputDE 
    call LcdCRLF 
    PrintMessage(UART_MESSAGE_2, 16)         
    call InputHL
    call LcdCRLF
    ret
    
;*****************************************************************************************************;  
Ram_err:
    inc de
    push bc
    push hl
    PrintMessage(RAM_ERR_MESSAGE, 20) 
    pop hl   
    call PrintHL
    push hl
    call LcdCRLF    
    PrintMessage(PRESS_KEY_MESSAGE, 20)
RAM_ERR_loop: 
    BeepMessage         
    WaitAnyKeyPress         ;     
    cp  ESC_KEY
    jp z, Display_test
    cp ENT_KEY
    jr nz, RAM_ERR_loop
    pop hl
    pop bc
    jp Rtstl

;*****************************************************************************************************; 
Uart_speed:        
    ClearLCD 
    PrintMessage(UART_SPEED_MESSAGE, 77)
Get_speed:        
    WaitAnyKeyPress
    cp 8
    jr nc, Get_speed
    call Set_uart_speed
    ret

;*****************************************************************************************************;        
;----------------------       ---------------------------;
;*****************************************************************************************************;
RegInfo:
; AF
    push hl
    push bc
    push af
    PrintMessage(AF_MESSAGE, 4)
    pop hl
    call PrintHL
; BC 
    PrintMessage(BC_MESSAGE, 4)
    pop hl
    call PrintHL
; DE
    PrintMessage(DE_MESSAGE, 4)
    call PrintDE
; HL 
    PrintMessage(HL_MESSAGE, 4)
    pop hl 
    call PrintHL
; IX 
    push ix
    PrintMessage(IX_MESSAGE, 4)
    pop hl
    call PrintHL
; IY
    push iy
    PrintMessage(IY_MESSAGE, 4)
    pop hl
    call PrintHL
    ret

;*****************************************************************************************************;        
;---------------------------------------- / ---------------------------------------------;
;*****************************************************************************************************;
Timer:
    call CursorOFF
    ClearLCD
    PrintMessage(CLOCK_MESSAGE, 61)
Clock_main_loop:
    call Key_scan
    cp DEL_KEY
    jr z, Set_time
    cp ESC_KEY
    jr z, Set_ring
    
    xor a
    ld hl, $FFF1
    cp (hl)
    jr nz, Clock_main_loop

    ld hl, $FFEB
    ld a, 4   
    call Ref_time
    ld a, 2   
    call Ref_time

    dec hl  
    ld a, ($FFED)
    cp (hl)
    jr nz, Clock_main_loop
    dec hl
    ld a, ($FFEC)
    cp (hl)
    jr nz, Clock_main_loop
    dec hl
    ld a, ($FFEB)
    cp (hl)
    jr nz, Clock_main_loop
    ld hl, Beep_note2
    call Play_music
    WaitAnyKeyPress
    call StopMusic
    jr Clock_main_loop  

Set_ring:
    ld hl, $FFEB
    ld a, 4  
    jr Set_time2       
Set_time:
    ld hl, $FFEE
    ld a, 2
Set_time2:       
    call Set_val
    jr Clock_main_loop
    
            
Ref_time:
    call LcdSetY
    ld a, 72
    call LcdSetX
    ld b, 3
Ref_time_loop:    
    ld a, (hl)
    call PrintA
    ld a, 58
    call PrintAscii 
    inc hl
    djnz Ref_time_loop
    call BackSymbol
    ret

Set_val:    
    call LcdSetY
    ld a, 72
    call LcdSetX
    ld b, 3
    call CursorON
    call ClockOFF
    rst 18h
Inp_loop:
    call InputA
    ld (hl), a
    ld a, 58
    call PrintAscii
    inc hl
    djnz Inp_loop
    call BackSymbol
    call CursorOFF
    call ClockON
    jp Clock_main_loop 
    
;*****************************************************************************************************;        
;-----------------------------------   ---------------------------------------------;
;*****************************************************************************************************;
START_MESSAGE:
    .db "   ", $B5, "Z MONITOR V2.0 ", $0D   ; 1 20
    .db "1 -   ", $0D   ; 3 20
    .db "2 -  ", $0D   ; 4 20
    .db "3 -   ", $0D   ; 5 20 -> 140 
    .db "4 -  RS232", $0D   ; 6 19    
    .db "5 -  RS232", $0D   ; 7 19 
    .db "6 - . ", $0D   ; 8 17 
    .db "F - ", $1F   ; 5 
START_MESSAGE_2: 
    .db "7 - ", $0D ; 16     
    .db "8 -  ", $0D     ; 19  -> 114
    .db "9 -   ", $0D  ; 21 
    .db "A - ", $0D         ; 9 
    .db "B - ", $0D     ; 13   
    .db "C - ", $0D    ; 14
    .db "D -  ", $0D ; 17  
    .db "0 - ", $1E             ; 5                                      
RAM_MESSAGE_START:    
    .db "  ", $0D 
PROG_START_MESSAGE:    
    .db "  ", $0D                                    
UART_MESSAGE_1:    
    .db " :", $0D ;17
UART_MESSAGE_2:     
    .db " :", $0D ;16
UART_MESSAGE_3:     
    .db " ...", $0D ;16 
UART_MESSAGE_4:     
    .db " ...", $0D ;19         
UART_MESSAGE_5:
    .db " .", $0D ;20  
UART_MESSAGE_6:
    .db "  ", $0D, "  . ?", $0D ; 42
UART_MESSAGE_7:
    .db "  -   ?", $0D ; 42
CHECKSUM_MESSAGE:                      
    .db " :", $0D ;19 
PRESS_ANY_KEY_MESSAGE:
    .db "  ";21
PRESS_KEY_MESSAGE: 
    .db "ENT-, ESC-" ; 20                
RAM_TEST_MESSAGE:
    .db " ...", $0D ;12  
RAM_END_MESSAGE:
    .db " ", $0D 
    .db " :", $0D  ;14+19 
RAM_ERR_MESSAGE:
    .db " :", $0D ;20
ROM_TEST_MESSAGE:
    .db " ...", $0D ;12
ROM_ERR_MESSAGE:
    .db " CRC", $0D ;11 
ROM_OK_MESSAGE:
    .db " ", $0D ;13
KB_TEST_MESSAGE:
    .db " , ", $0D ;21
    .db "  RES", $0D, $0D ;20
PORTS_TESTMESSAGE_1:
    .db "  ", $0D ; 15
IO_MESSAGE_1:    
    .db "  ", $0D ;20
    .db "   ", $0D ;19
    .db ": " ; 8                   -> 62  
PORTS_TESTMESSAGE_2: 
    .db "  /: "  ; 18     
PORTS_TESTMESSAGE_3: 
    .db $0D, "ENT-, ESC-" ; 22 
COPY_ADR_MESSAGE: 
    .db "  :", $0D ;20
ADR_CORRECT_MESSAGE:
    .db " - ?", $0D ;35  -> 51
ADR_CORRECT_MESSAGE2:    
    .db "ENT-, ESC-", $0D ;16
ADR_CORRECT_MESSAGE3:
    .db " ", $0D, "0000-3FFF?",  $0D ; 27    
TERMINAL_MESSAGE:
    .db "   ", $B5, "Z TERMINAL", $0D, ">" ; 16
UART_SPEED_MESSAGE:     
    .db " ", $0D ; 18
    .db "0-19200,4-1200,", $0D ; 16    -> 77
    .db "1-9600, 5-600,", $0D ; 15 
    .db "2-4800, 6-300,", $0D ; 15
    .db "3-2400, 7-110" ; 13
    .db $0D        
IO_MESSAGE_2:                                                        
    .db "ENT-, ESC-", $0D ;20
IO_MESSAGE_3:
    .db ",  ", $0D ;20
    .db ": " ;6                     -> 26
START_OF_HEADING_MESSAGE:
    .db "//", $0D ;14 
START_OF_TEXT_MESSAGE:
    .db "//", $0D ;8    
END_OF_TEXT_MESSAGE:
    .db "/ /", $0D ;15
END_OF_TRANSMITTION_MESSAGE:
    .db "/ /", $0D ;17
ENQUIRE_MESSAGE:
    .db $B5, "Z-15 V2.0"  ;10     
ACKNOWLEDGEMENT_MESSAGE:
    .db "//", $0D ;14
HORIZONTAL_TAB_message:
    .db "    " ;4 
NEGATIVE_ACKNOWLEDGMENT_MESSAGE:
    .db "/ /", $0D ;17
END_OF_TEXT_BLOCK_MESSAGE:
    .db "/ /", $0D ;14
END_OF_MEDIUM_MESSAGE:
    .db "/ /", $0D ;17
GAMES_MESSAGE:
    .db "        ", $0D ;13 
    .db "1 - ", $0D ;10    -> 44
    .db "2 - ", $0D ;11
    .db "3 - " ;10 
PROGRAMS_MESSAGE:
    .db "     ", $0D ;15 -> 53
    .db "1 - ", $0D ;16
    .db "2 - ", $0D ;9
    .db "3 - " ;13
CLOCK_MESSAGE:    
    .db $0D, $0D, "", $0D, $0D ; 10
    .db "", $0D, $0D ; 11
    .db "DEL- ", $0D ; 21
    .db "ESC-. " ; 19
AF_MESSAGE:
    .db $0D, "AF=" ; 4
BC_MESSAGE:
    .db " BC=" ; 4
DE_MESSAGE:
    .db $0D, "DE=" ; 4
HL_MESSAGE:
    .db " HL=" ; 4
IX_MESSAGE:
    .db $0D, "IX=" ; 4
IY_MESSAGE:
    .db " IY=" ; 4
PC_MESSAGE:
    .db $0D, "PC=" ; 4
SP_MESSAGE:
    .db " SP=" ; 4
                                                                                                                                                                                                                             
Game_rasing:
Game_snake:
Game_tetris:

Calc:

Generator:
;*****************************************************************************************************;
;-------------------------------      ---------------------------------;
;*****************************************************************************************************;
SystemFail: 
    ld b, 4
    ld de, $0001
    ld hl, $0000
    
FailLoop:
    ld a, TMR0_MODE        
    out (TMR_CONTROL), a 
    ld a, $17
    out (TMR_CHANNEL_0), a   
    out (TMR_CHANNEL_0), a
FailLoop2:
    add hl, de
    jr nc, FailLoop2
    
    ld a, TMR0_MODE        
    out (TMR_CONTROL), a 
FailLoop3:
    add hl, de
    jr nc, FailLoop3
    djnz FailLoop   
 
    ld a, %00111111       ;   
    out (DISPLAY_COMMAND_LR), a    
    halt                
    jr SystemFail  
END_OF_ROM:
    .db $00
                                                                                                        
.end

