 

; AGD musicizer v1.6
; david saphier 2017

	org 25500
	;output output.bin 

IJUMP 	equ $FBFF	; location in memory where out jump address will be 
ISR		equ $6060	; ISR 
START 

	jp init 	; main call 25500 starts music 
	jp IMOff	; 25502
	jp tune1	; 25505
	jp tune1	; 25508 
	jp IMStart	; 25511
	ret 

str:	incbin "bin\author.bin"

init: 	
	; for Divmmc 
	ld a,16
	ld (23388),a 
	push iy
	;push hl 
	; check 128 or not
	di
	call is128 
	ld a,(bufferA)
	cp 1
	jr z,exit
	
	di
	; poke ISR address to the ijunp
	call bank0
	di 
	ld hl,ISR 
	ld (IJUMP),hl 

	; bank 4
	call bank4
	
	; extract music to 49152
	ld hl,ayplaybin
	ld de,49152
	call zx7bin 

	; extract music to 51310
	call tune1 
	;ld hl,musicbin
	;ld de,51310
	;call zx7bin
	
	; copy ints to ISR location, by 60bytes
	ld hl,Ints
	ld de,ISR
	ld bc,80
	ldir 

	; init playroutine
	call 49152
	call bank0

	;call IMStart
	;

exit:
	; start agd game
	
	;pop hl
	pop iy 
	ei

	ret
	;call 32000	






; compressed binaries

include "asm\routines.asm"

include "asm\music.asm"
	defs 4
ayplaybin: 	; vtII playroutine Sergio Bulba
	incbin "bin\vt49152.bin.zx7"
	defs 4


END START 
