;PaRtY TiMe! 1024 byte by Sanchez
;begin date: 24.10.2013
;end date: 01.11.2013

;OBJECT STRUCTURE
status		EQU 0; 	object status, 0=none, 1=left, 2=right, 3=ladder up, 4=ladder down,5=fall down
type		EQU 1;	type object, 0=mario, 255=enemy
mapaddr		EQU	2;	map addres
xcur		EQU 3; 	X urrent coord
ycur		EQU 4; 	Y urrent coord
spr			EQU 5;	current sprite
xprev		EQU 6; 	X previous coord
yprev		EQU 7; 	Y previous coord
prev		EQU 8;	previous sprite
direct		EQU 9;  object direct, 0=right, 255=left
updown		EQU 10;	up/down direct, 0=none, 1=up, 2=down
coins		EQU 11;	collected coins

;CONST
sprites		EQU #8000
map			EQU #8200
objects		EQU #8300
max_obj		EQU 3
ATTR_P		EQU #5c8d
INIT_PRINT	EQU #1601
PRINT_STR	EQU #203c

			DEVICE ZXSPECTRUM48
			ORG #6000
			
begin_prog	call cls
			ld a,%11111010
			ld (ATTR_P),a		
			
;init map
			ld hl,pack_map	
			ld d,high map
			push de			
init_map1	ld b,4
init_map2	ld a,(hl)
			rlca
			rlca
			ld (hl),a
			and 3
			ld (de),a
			inc de
			djnz init_map2
			inc hl
			dec c
			jr nz,init_map1
;render sprites
			ld hl,sprites
			ld de,game_graph	
			ld c,l
render_1	ld a,(de)
			ld (hl),a
			inc h
			ld a,(de)
			ld b,8
render_2	rra
			rl (hl)
			djnz render_2
;speaker noise			 
			and #10
			out (254),a
			
			dec h
			inc l,de
			dec c
			jr nz,render_1				
;draw_map	
			ld de,2			
			pop hl								
			ld c,11		
draw_map1	ld b,16	
draw_map2	push bc,de,hl
            ld a,(hl)
			call draw_sprite
			pop hl,de,bc
			inc d,d,l
			djnz draw_map2
			ld d,b
			inc e,e
			dec c
			jr nz,draw_map1
						
;init objects
			ld hl,objects
			call clear_ram
			ld de,objects+1
			ld hl,objects_data
			ld a,max_obj
init_obj1	push de
			ld c,7
			ldir
			pop de
			inc d
			dec a
			jr nz,init_obj1
			
;MAIN GAME LOOP
loop		ei
			dup 4
			halt
			edup

;restore screen under objects
			ld l,6
			call draw_obj
			
;move objects
			ld ix,objects
			ld bc,#effe
			in a,(c)
			rlca
			rlca
			rlca
			and #e0
			ld h,a
			ld b,#f7
			in a,(c)
			and #1f
			or h
			ld c,a
			
			ld b,max_obj
			ld d,high map
move_obj1	push bc			
;load property		
			ld h,(ix+xcur)
			ld l,(ix+ycur)
			ld e,(ix+mapaddr)
			ld b,(ix+direct)
			ld a,(ix+status)
			or a
			jp nz,move_obj20
			
;object type
			ld a,(ix+type)
			or a
			jr nz,move_obj10
			
;MARIO MOVE				
		
;test block under object			
			ld a,e
			add a,16
			ld e,a
			ld a,(de)
			or a
			jr z,$+6
			cp 3
			jr nz,move_obj2
			inc l
			ld a,b
			and 3
			add a,6
			ld b,a
			ld c,5
			jr move_obj8		
;test move right
move_obj2	ld a,e
			sub 15
			ld e,a
			ld a,(de)
			dec a		
			jr z,move_obj3
			bit 5,c
			jr nz,move_obj3
			inc h
			ld bc,#0502
			xor a
			jr move_obj4	
;test move left
move_obj3	ld a,e
			sub 2
			ld e,a
			ld a,(de)
			dec a
			jr z,move_obj5
			bit 4,c
			jr nz,move_obj5
			dec h
			ld bc,#0801
			ld a,#ff
move_obj4	ld (ix+direct),a
			jr move_obj9				
;test ladder up
move_obj5	inc e
			ld a,(de)
			cp 2
			jr nz,move_obj6
			bit 6,c
			jr nz,move_obj6
			ld a,e
			sub 16
			ld e,a
			dec l
			ld bc,#0a03
			jr move_obj9	
;test ladder down
move_obj6	ld a,e
			add a,16
			ld e,a
			ld a,(de)
			cp 2
			jr nz,move_obj7
			bit 7,c
			jr nz,move_obj7
			inc l
			ld bc,#0a04
			jr move_obj9										
;object stay
move_obj7	ld a,b
			and 3
			add a,4
			ld b,a
			ld c,0
			ld e,(ix+mapaddr)
move_obj8	jp move_objs	

;mario run sound			
move_obj9	ld a,#10
			out (254),a
			jr move_obj8
			
;ENEMY MOVE		

;test move up direction
move_obj10	ld a,(ix+updown)
			or a
			jr z,move_obj13
			dec a
			jr nz,move_obj11
			ld a,e
			sub 16
			ld e,a
			ld a,(de)
			dec a
			jr z,move_obj12
			dec l
			ld c,3
			jr move_obj19
;test move down direction
move_obj11 	ld a,e
			add a,16
			ld e,a
			ld a,(de)
			dec a
			jr z,move_obj12
			inc l
			ld c,4
			jr move_obj19
;end move up/down
move_obj12	ld (ix+updown),a
			ld e,(ix+mapaddr)		
			jr move_obj17
;test up ladder			
move_obj13	ld a,(de)		
			cp 2
			jr nz,move_obj14
			
			ld a,r
			and 1
			jr z,move_obj17
			
			jr move_obj15
;test down ladder
move_obj14	ld c,e
			ld a,e
			add a,16
			ld e,a
			ld a,(de)
			ld e,c
			cp 2
			jr nz,move_obj17
			
			ld a,r
			and 2
			jr z,move_obj17
			
move_obj15	ld (ix+updown),a
			ld c,0
			jr move_obj19			
			
;test direction
move_obj17	ld a,b
			cpl
			and 2
			add a,15
			add a,e
			ld e,a
			ld a,(de)
			dec a
			jr z,$+5
			dec a
			jr nz,move_obj18
			ld a,e
			sub 16
			ld e,a
			ld a,(de)
			dec a
			jr z,move_obj18
			ld c,1
			ld a,b
			or c
			add a,h
			ld h,a
			ld a,b
			cpl
			and c
			add a,c
			ld c,a
			jr move_obj19
;change direction
move_obj18	ld a,b
			cpl
			ld (ix+direct),a
			ld e,(ix+mapaddr)
			ld c,0
move_obj19	ld b,12
			jr move_objs
			
;object move left
move_obj20	ld b,(ix+spr)
			ld c,0
			dec a
			jr nz,move_obj21
			dec h	
			jr move_objt			
;object move right
move_obj21	dec a
			jr nz,move_obj22
			inc h
			jr move_objt			
;object ladder up
move_obj22	dec a
			jr nz,move_obj23
			dec l
			jr move_objt			
;object ladder down
move_obj23	dec a
			jr nz,move_obj24
			inc l				
			jr move_objt			
;object fall
move_obj24	inc l
			jr move_objr		
			
move_objt	inc b	
move_objr	ld a,(ix+type)
			or a
			ld a,(de)
			jr nz,move_objr2		
			cp 3
			jr nz,move_objr2
;add coin	
			inc (ix+coins)
;collect coin sound		
			push bc
			ld b,a
beep		ld a,c
			and #10
			out (254),a
			dec bc
			ld a,b
			or c
			jr nz,beep
			pop bc			
			
			ld a,(ix+coins)
			cp 18
			jr nz,move_objr1			
;WINNER		
			pop bc
			call cls				
			ld a,2
			call INIT_PRINT
			ld de,winner_text
			ld c,14
			call PRINT_STR
winner_1	halt
			djnz winner_1
			jr goto_start 
			
move_objr1	xor a
			ld (de),a
;save property				
move_objr2	ld (ix+prev),a
            ld (ix+xprev),h
			ld (ix+yprev),l
			xor a
			out (254),a
move_objs	ld (ix+xcur),h
			ld (ix+ycur),l
			ld (ix+mapaddr),e
			ld (ix+spr),b
			ld (ix+status),c
;test collision
			pop bc
			dec b
			jr z,show_spr
;GAME OVER
			ld a,(objects+#200+xcur)	
			sub h
			adc a,0
			jr nz,move_obje
			ld a,(objects+#200+ycur)	
			sub l
			adc a,0
			jr nz,move_obje
goto_start	jp begin_prog 
			
move_obje	inc xh
			jp move_obj1					
		
;show sprites		
show_spr	ld l,3
			call draw_obj

			jp loop	
			
;PROCEDURE

;clear screen
cls			ld hl,#5800
;clear ram 768 byte, hl - start addres
clear_ram	ld d,h
			ld e,l
			inc de
			ld bc,#2ff
			ld (hl),l
			ldir
			ret

;draw objects, c - draw type (3=show objects, 6=restore screen)
draw_obj	ld h,high objects
			ld b,max_obj	
draw_obj1	push bc,hl
            ld d,(hl)
			inc l
			ld e,(hl)
			inc l
			ld a,(hl)
			call draw_sprite
			pop hl,bc
			inc h
			djnz draw_obj1
			ret
				
;draw sprite, de = screen coord, a = num
draw_sprite	ld b,a
			add a,a
			add a,a
			add a,b
			add a,low spr_num
			ld l,a
			ld h,high spr_num

			ld a,e
			ld b,e
			rrca
			rrca
			rrca
			ld c,a
			and #e0
			or d
			ld e,a
			ld a,c
			and 3
			add a,#58
			ld d,a									
;sprite attributs
			push bc,de,hl
			ld l,(hl)
			ld a,l
			and 7
			ld h,a			
			ld c,2
draw_spr1	ld b,2		
draw_spr2	ld a,l
			and #40
			or h
			ld (de),a
			rl l
			inc e
			djnz draw_spr2
			ld a,e
			add a,30
			ld e,a
			ld a,d
			adc a,b
			ld d,a
			dec c
			jr nz,draw_spr1
			pop hl,de,bc
;sprite data
			ld a,b
			and #18
			add a,#40
			ld d,a
			
			ld c,2
draw_spr3	ld b,2		
draw_spr4	inc hl
			push bc,de,hl
			ld l,(hl)
			ld h,high sprites/8
			add hl,hl
			add hl,hl
			add hl,hl
			ld b,8
draw_spr5	ld a,(hl)
			ld (de),a
			inc l,d
			djnz draw_spr5
			pop hl,de,bc
			inc e
			djnz draw_spr4
			ld a,e
			add a,30
			ld e,a
			jr nc,$+6
			ld a,d
			add a,8
			ld d,a
			dec c
			jr nz,draw_spr3
			ret
		
game_graph		
;SPRITE 1 - block (0)
			DB #df,#df,#df,#00,#fd,#fd,#fd,#00			
;SPRITE 2 - ladder (1)			
			DB #60,#40,#60,#ff,#ff,#40,#60,#40			
;SPRITE 3 - coin (2,3)		
			DB #00,#01,#06,#09,#17,#15,#2d,#2d
			DB #17,#17,#09,#06,#01,#00,#00,#00		
;SPRITE 4 - mario stay (4,5,6,7)					
			DB #07,#0f,#10,#15,#14,#1f,#07,#09
			DB #e0,#fc,#60,#dc,#ee,#c0,#f8,#28
			DB #11,#21,#3a,#3b,#37,#0f,#1e,#3e
			DB #24,#e2,#d6,#f6,#fa,#78,#3c,#3e	
;SPRITE 5 - mario run faze 1 (8,9)				
			DB #10,#22,#10,#18,#0c,#07,#07,#07
			DB #d0,#b0,#f8,#38,#70,#f0,#f8,#c0	
;SPRITE 6 - mario run faze 2 (10,11)				
			DB #61,#81,#ef,#1f,#3f,#7e,#78,#3c
			DB #bf,#71,#72,#fc,#fc,#7c,#00,#00			
;SPRITE 7 - mario climb	(12,13,14,15)	
			DB #07,#0f,#3c,#4f,#48,#34,#17,#0e
			DB #ec,#f2,#32,#f2,#1a,#24,#e4,#68
			DB #06,#07,#07,#0f,#1f,#1c,#1c,#18
			DB #70,#e0,#e0,#f0,#f8,#38,#00,#00			
;SPRITE 8 - enemy (16,17,18)	
			DB #00,#07,#0f,#1f,#27,#6b,#68,#ea
			DB #ee,#e0,#70,#07,#3f,#7b,#7d,#3e
			DB #77,#0f,#0e,#e0,#f0,#d8,#b8,#70
			
;SPRITES NUM
spr_num		DB %00000000,00,00,00,00	;empty
			DB %01100010,00,00,00,00	;block
			DB %01010101,01,33,01,33	;ladder
			DB %01010110,02,34,03,35	;coin
			DB %01100111,04,05,06,07	;mario stay right
			DB %01100111,04,05,08,09	;mario run faze 1 right
			DB %01100111,04,05,10,11	;mario run faze 2 right
			DB %01100111,37,36,39,38	;mario stay left
			DB %01100111,37,36,41,40	;mario run faze 1 left
			DB %01100111,37,36,43,42	;mario run faze 2 left
			DB %01100111,12,13,14,15	;mario climb faze 1
			DB %01100111,45,44,47,46	;mario climb faze 2
			DB %01100100,16,48,17,18	;emeny run faze 1
			DB %01100100,16,48,50,49	;emeny run faze 2
			
pack_map	
			DB %01010101,%01010101,%01010101,%01010101
			DB %01110000,%11111100,%00001111,%00001101
			DB %01011001,%01010110,%01010101,%01100101
			DB %01001000,%00000010,%00110000,%00100001
			DB %01100101,%10110010,%00010110,%01011001
			DB %01100000,%01010010,%00001110,%00111001
			DB %01011000,%00000010,%00100101,%00010101
			DB %01001000,%11110001,%00100011,%00000001
			DB %01100101,%01010101,%00010101,%01011001
			DB %01100011,%00001100,%00001100,%11001001
			DB %01010101,%01010101,%01010101,%01010101
			
;OBJECTS DATA - [type, mapaddr, xcur, ycur, sprite, xprev, yprev]		
objects_data
			DB 255,#3e,28,8,12,28,8
			DB 255,#31,2,8,12,2,8
			DB 0,#98,16,20,4,16,20
			
winner_text	DB #16,11,11,"PaRtY TiMe!"
							
end_prog
			DISPLAY "Code lenght = ", /D, game_graph-begin_prog		
			DISPLAY "Data lenght = ", /D, end_prog-game_graph		
			DISPLAY "Programm lenght = ", /D, end_prog-begin_prog
			SAVEBIN "main.bin",begin_prog,end_prog-begin_prog