; subroutines 

include "asm\irbuff.asm"

tune1:	di 
	;call bank4
	ld hl,musicbin1
	ld de,51310
	call zx7bin
	call 49152
	;ei 
	ret 

; tune2:	di 
; 	ld hl,musicbin2
; 	ld de,51310
; 	call zx7bin
; 	call 49152
; 	ei 
; 	ret 

bank0:	; swap to bank 0 - original @ 49152 - 16k
	;di
	ld a,(23388)   
	and 248
	or 0 
	ld bc,32765
	ld (23388),a
	out (c),a
	;ei
	ret

bank4:	; swap to bank 4 @ 49152 - 16k
	;di
	ld a,(23388)   
	and 248
	or 4 
	ld bc,32765
	ld (23388),a
	out (c),a
	;ei
	ret 

is128:
	
	di 
		
	call bank4 	
		
	; load 49152 with 255
	ld a,255
	ld (65535),a 
			
	; set bank 0
	call bank0	
	; load 49152 with 0
	ld a,0
	ld (65535),a 
		
	call bank4 		
		
	;ei
	
	ld a,(65535)
	cp 255 
	jr z,ending 	
	ld a,1
	ld (bufferA),a
	ret 

ending:
	ld a,0		; returns 1 if true true 
	ld (bufferA),a
	ret 

bufferA:
	db 0,0

; interrupt routine itself 

Ints:	
	di                  ; disable interrupts
	push af             ; save all std regs
	push bc
	push de
	push hl
	push ix             
	push iy
	ex af, af'
	push af             ; save all std regs

	; bank 4 
	ld a,(23388)  	
	and 248  
	or 4 
	ld bc,32765 
	ld (23388),a
	out (c),a
	
	ld a,(23672)
	inc a
	ld (23672),a	
	
	ld bc,65533
	ld a,254
	out (c),a 
	
	call 49157       ; play the current tune
	
	ld bc,65533
	ld a,255
	
	out (c),a 
	;swap back to bank 0
	ld a,(23388)  
	and 248
	or 0 
	ld bc,32765 
	ld (23388),a
	out (c),a

	pop af 
	ex af, af'
	pop iy
	pop ix              
	pop hl
	pop de
	pop bc
	pop af              
	ei             
	;jp 56		; found most stable 
	reti 	

IMStart:

	call is128 
	ld a,(bufferA)
	cp 1
	jr z,exit2
	di
 	call bank4	
	ld a, irbuff
	ld i, a
	im 2
exit2: 	
	call bank0
	ei
	call 32000
	ret       

IMOff:
	di
	im 1
	call bank4
	call 49152
	call bank0
	ei
	ret


; zx7 einar saukas
zx7bin:
	
	call dzx7_turbo

	ret
				
dzx7_turbo:
        ld      a, $80
dzx7s_copy_byte_loop:
        ldi                             ; copy literal byte
dzx7s_main_loop:
        call    dzx7s_next_bit
        jr      nc, dzx7s_copy_byte_loop ; next bit indicates either literal or sequence

; determine number of bits used for length (Elias gamma coding)
        push    de
        ld      bc, 0
        ld      d, b
dzx7s_len_size_loop:
        inc     d
        call    dzx7s_next_bit
        jr      nc, dzx7s_len_size_loop

; determine length
dzx7s_len_value_loop:
        call    nc, dzx7s_next_bit
        rl      c
        rl      b
        jr      c, dzx7s_exit           ; check end marker
        dec     d
        jr      nz, dzx7s_len_value_loop
        inc     bc                      ; adjust length

; determine offset
        ld      e, (hl)                 ; load offset flag (1 bit) + offset value (7 bits)
        inc     hl
        defb    $cb, $33                ; opcode for undocumented instruction "SLL E" aka "SLS E"
        jr      nc, dzx7s_offset_end    ; if offset flag is set, load 4 extra bits
        ld      d, $10                  ; bit marker to load 4 bits
dzx7s_rld_next_bit:
        call    dzx7s_next_bit
        rl      d                       ; insert next bit into D
        jr      nc, dzx7s_rld_next_bit  ; repeat 4 times, until bit marker is out
        inc     d                       ; add 128 to DE
        srl	d			; retrieve fourth bit from D
dzx7s_offset_end:
        rr      e                       ; insert fourth bit into E

; copy previous sequence
        ex      (sp), hl                ; store source, restore destination
        push    hl                      ; store destination
        sbc     hl, de                  ; HL = destination - offset - 1
        pop     de                      ; DE = destination
        ldir
dzx7s_exit:
        pop     hl                      ; restore source address (compressed data)
        jr      nc, dzx7s_main_loop
dzx7s_next_bit:
        add     a, a                    ; check next bit
        ret     nz                      ; no more bits left?
        ld      a, (hl)                 ; load another group of 8 bits
        inc     hl
        rla
        ret