; Helicop game ( " ")
; Original design by Ynicky for NSPEC

	DEVICE ZXSPECTRUM48

	MODULE MAIN

SCREEN=#4000

	ORG SCREEN
;	INCBIN "helicop.scr" ;;;    ZX (Layer 1)

	ORG #6000

HC_XY		DW #0000	;    
CAR_XY		DW #0000	;    
AMMOR_XY	DW #0000	;     
AMMOA_XY	DW #0000	;     
DIRECTION	DB #00		;   
PHASE_HC	DB #00		;  
PHASE_CAR	DB #00		;  
PHASE_AMMO	DB #00		;  
PLAY_SOUND	DB #00
PLAY_MODE	DB #00
FIRE		DB #00		;  

KEY_MAP:
	DS 41,#00

DEFINE_KEYS:
	DW KEY_P,KEY_O,KEY_Q,KEY_A,KEY_1

KEY_A	EQU KEY_MAP+#00
KEY_B	EQU KEY_MAP+#01
KEY_C	EQU KEY_MAP+#02
KEY_D	EQU KEY_MAP+#03
KEY_E	EQU KEY_MAP+#04
KEY_F	EQU KEY_MAP+#05
KEY_G	EQU KEY_MAP+#06
KEY_H	EQU KEY_MAP+#07
KEY_I	EQU KEY_MAP+#08
KEY_J	EQU KEY_MAP+#09
KEY_K	EQU KEY_MAP+#0A
KEY_L	EQU KEY_MAP+#0B
KEY_M	EQU KEY_MAP+#0C
KEY_N	EQU KEY_MAP+#0D
KEY_O	EQU KEY_MAP+#0E
KEY_P	EQU KEY_MAP+#0F
KEY_Q	EQU KEY_MAP+#10
KEY_R	EQU KEY_MAP+#11
KEY_S	EQU KEY_MAP+#12
KEY_T	EQU KEY_MAP+#13	
KEY_U   EQU KEY_MAP+#14
KEY_V	EQU KEY_MAP+#15
KEY_W   EQU KEY_MAP+#16
KEY_X	EQU KEY_MAP+#17
KEY_Y   EQU KEY_MAP+#18
KEY_Z	EQU KEY_MAP+#19

KEY_0	EQU KEY_MAP+#1A
KEY_1	EQU KEY_MAP+#1B
KEY_2	EQU KEY_MAP+#1C
KEY_3	EQU KEY_MAP+#1D
KEY_4	EQU KEY_MAP+#1E
KEY_5	EQU KEY_MAP+#1F
KEY_6	EQU KEY_MAP+#20
KEY_7	EQU KEY_MAP+#21
KEY_8	EQU KEY_MAP+#22
KEY_9	EQU KEY_MAP+#23

KEY_SPC	EQU KEY_MAP+#24
KEY_ENT	EQU KEY_MAP+#25

KEY_CS	EQU KEY_MAP+#26
KEY_SS	EQU KEY_MAP+#27

KEY_ANY	EQU KEY_MAP+#28

START:
	DI
	LD SP,#BFBE
        LD HL,#BE00
        LD A,H
        LD I,A
        IM 2
        LD BC,#00BF
        LD (HL),C
        INC HL
        DJNZ $-2
        LD (HL),C
        LD H,C
        LD L,C
        LD (HL),#C3
	LD DE,MAIN_ISR
	INC L
	LD (HL),E
	INC L
	LD (HL),D
	CALL CLEAR_SCREEN
	CALL	SW_L0
	CALL CLEAR_LAYER0
	CALL	SW_L2
	CALL CLEAR_LAYER2
	CALL	SW_L1

	LD HL,MSG_1
	LD BC,#0A08
	CALL TEXT
	
	LD HL,MSG_2
	LD BC,#0C05
	CALL TEXT

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; port #1FFD:
; D5 -  Layer 0 (Background)
; D6 -  Layer 2 (Foreground)
; Layer 1 (ZX) is allways on
	LD	A,060h		; L0 & L2 are on
	LD	BC,01FFDh;
	OUT	(C),A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	EI
	CALL WAIT_SPACEKEY

	LD A,#FF
	LD (PLAY_MODE),A

	CALL CLEAR_SCREEN

	LD HL,MSG_8
	LD BC,#000B
	CALL TEXT
;	LD HL,MSG_4
;	LD BC,#0020
;	CALL TEXT
;	LD HL,MSG_5
;	LD BC,#0029
;	CALL TEXT
;	LD HL,MSG_6
;	LD BC,#0032
;	CALL TEXT
;	LD HL,MSG_7
;	LD BC,#0038
;	CALL TEXT
	LD HL,MSG_SCORE
	LD BC,#3700
	CALL TEXT
	LD HL,MSG_AMMO
	LD BC,#3717
	CALL TEXT
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	CALL	SW_L0
	call	FILL_LAYER0
	CALL	SW_L2
	call	FILL_LAYER2
	CALL	SW_L1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; screen: Y = (#F0 - #C0) / 2 = 24 .. (#C0 -   3 (#C000 ... #F000))
;         X = (#40 - #00) / 2 = 32 .. (#40 - 64 )
	LD HL,#C808		;    (X = #08, Y = #C8)
	LD (HC_XY),HL
	LD A,3			;   
	LD (PHASE_HC),A

	LD HL,#E638		;    (X = #38, Y = #E6)
	LD (CAR_XY),HL
	LD A,7			;   
	LD (PHASE_CAR),A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	CALL	SW_L2
	CALL	DRAW_SPRITE_HC
;	ld	A,10h		; switch back to L1
;	ld	BC,7FFDh;
;	out	(C),A
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

MAIN_LOOP:
	EI
	HALT
	DI
	LD A,(PLAY_SOUND)
	OR A
	CALL NZ,NOISE
	JP MAIN_LOOP


; port 7FFD:
; D7,D6,D2-D0 -  ,    3
SW_L0:
	PUSH	BC
	LD	A,055h
	LD	BC,7FFDh;
	OUT	(C),A
	POP	BC
	RET

SW_L1:
	PUSH	BC
	LD	A,010h
	LD	BC,7FFDh;
	OUT	(C),A
	POP	BC
	RET

SW_L2:
	PUSH	BC
	LD	A,057h
	LD	BC,7FFDh;
	OUT	(C),A
	POP	BC
	RET

NOISE:
	LD	A,#18
	OUT	(#FE),A
	LD	B,8
	DJNZ	$
	XOR	A
	OUT	(#FE),A
	LD	(PLAY_SOUND),A
	RET	 


MAIN_ISR:
	PUSH IX
	PUSH HL
	PUSH DE
	PUSH BC
	PUSH AF
	EXX
	EX AF,AF'
	PUSH IY
	PUSH HL
	PUSH DE
	PUSH BC
	PUSH AF
	CALL CHECK_KEYBOARD
	CALL SPEED_CTRL
	POP AF
	POP BC
	POP DE
	POP HL
	POP IY
	EX AF,AF'
	EXX
	POP AF
	POP BC
	POP DE
	POP HL
	POP IX

	EI
	RET


SPEED_CTRL:
	PUSH	BC
	
	LD	C,#00		;     
	INC	C
	LD	A,C
;	PUSH	BC
	AND	%00000001		;   (1 pix per 2 int)
	CALL	Z,SHOW_CAR
;	POP	BC
	LD	A,C
	AND	%00000011		;   (1 pix per 4 int)
	CP	3
	CALL	Z,SCROLL_ROAD
	LD	A,C
	AND	%00000111		;   (1 pix per 8 int)
	CP	5
;	PUSH	BC
	CALL	Z,SHOW_HC
;	POP	BC
	LD	A,C
	AND	%00001111		;   (1 step per 16 int)
	CP	10
	CALL	Z,SCROLL_CITY
	LD	A,C
;	AND	%00011111		;   (1 step per 32 int)
;	CP	23
	AND	%00000001
	CALL	Z,SHOW_AMMO
	LD	A,C
	LD	(SPEED_CTRL+2),A
	
	POP	BC
	RET

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SCROLL_ROAD:
	CALL	SW_L0
	PUSH	BC
	PUSH	HL
	LD	HL,#0E400	;     
	LD	B,32		;    
SCRRD1:
	PUSH	HL
	LD	A,(HL)
	RL	A
	PUSH	AF		;  CY
	LD	A,L		;     
	ADD	A,63		;     * 2    - 1
	LD	L,A		;       
	LD	C,64		;       
	POP	AF		;  CY
SCRRD2:
	RL	(HL)		;       
	DEC	HL
	DEC	C
	JR	NZ,SCRRD2	;     

	POP	HL
;      :
	PUSH	HL
	LD	A,(HL)
	RL	A
	PUSH	AF		;  CY
	LD	A,L		;     
	ADD	A,63		;     * 2    - 1
	LD	L,A		;       
	LD	C,64		;       
	POP	AF		;  CY
SCRRD22:
	RL	(HL)
	DEC	HL
	DEC	C
	JR	NZ,SCRRD22	;     
	POP	HL
;	INC	H
	LD	A,L		; get low byte of address.
	ADD	A,64		; one line down.
	LD	L,A		; new low byte.
	JP	NC,SCRRD3	; not reached next 4 lines yet.
	INC	H
SCRRD3:	
	DJNZ	SCRRD1		;     
	POP	HL
	POP	BC
	RET

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SCROLL_CITY:
	CALL	SW_L0		;    0
	PUSH	BC
	PUSH	HL
	LD	HL,#0E000	;     
	LD	B,16		;    
SCRCT1:
	PUSH	HL
	LD	A,(HL)
	RL	A
	PUSH	AF		;  CY
	LD	A,L		;     
	ADD	A,63		;     * 2    - 1
	LD	L,A		;       
	LD	C,64		;       
	POP	AF		;  CY
SCRCT2:
	RL	(HL)		;       
	DEC	HL
	DEC	C
	JR	NZ,SCRCT2	;     

	POP	HL
;      :
	PUSH	HL
	LD	A,(HL)
	RL	A
	PUSH	AF		;  CY
	LD	A,L		;     
	ADD	A,63		;     * 2    - 1
	LD	L,A		;       
	LD	C,64		;       
	POP	AF		;  CY
SCRCT22:
	RL	(HL)
	DEC	HL
	DEC	C
	JR	NZ,SCRCT22	;     
	POP	HL
;	INC	H
	LD	A,L		; get low byte of address.
	ADD	A,64		; one line down.
	LD	L,A		; new low byte.
	JP	NC,SCRCT3	; not reached next 4 lines yet.
	INC	H
SCRCT3:	
	DJNZ	SCRCT1		;     
	POP	HL
	POP	BC
	RET

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SHOW_AMMO:
	CALL	SW_L2
	LD	A,(FIRE)
	CP	0
	RET	Z

	PUSH	DE
	PUSH	HL
	PUSH	BC

	LD	DE,AMMOR_BUF	;      
	LD	HL,(AMMOR_XY)	;     
	LD	BC,#0208	; ( ..  2  .)  (8 pixs .)
	CALL	PUTBL
	
	LD	DE,AMMOA_BUF	;      
	LD	HL,(AMMOA_XY)	;     
	LD	BC,#0401	; ( ..  4  .)  (1 .. .)
	CALL	PUTATTBL

	LD	HL,(AMMOR_XY)
	LD	A,1
	ADD	A,L
	LD	L,A
	LD	A,2
	ADD	A,H
	LD	H,A
	CP	0EAh
	JP	Z,LAMMO3
	LD	(AMMOR_XY),HL

	LD	HL,(AMMOA_XY)
	LD	A,080h
	ADD	A,L
	LD	L,A
	JP	NC,LAMMO5
	INC	H
LAMMO5:
	LD	A,(PHASE_AMMO)
	ADD	A
	ADD	A
	ADD	A,L
	LD	L,A
	LD	(AMMOA_XY),HL

	LD	A,(PHASE_AMMO)
	INC	A
	AND	1
	LD	(PHASE_AMMO),A
	JP	LAMMO4

LAMMO3:
	XOR	A
	LD	(FIRE),A	;   
	
	POP	BC
	POP	HL
	POP	DE
	RET
	
LAMMO4:
	LD	DE,AMMOR_BUF	;      
	LD	HL,(AMMOR_XY)	;     
	LD	BC,#0208	; ( ..  2  .)  (8 pixs .)
	CALL	GETBL
	
	LD	DE,AMMOA_BUF	;      
	LD	HL,(AMMOA_XY)	;     
	LD	BC,#0401	; ( ..  4  .)  (1 .. .)
	CALL	GETATTBL
	
	LD	DE,AMMO0R
;	LD	A,(PHASE_AMMO)
;	OR	A
;	JP	Z,LAMMO1
;	LD	DE,AMMO1R
;LAMMO1:
	LD	HL,(AMMOR_XY)
	LD	BC,00208h
	CALL	PUTSPR
	
	LD	DE,AMMO0A
;	LD	A,(PHASE_AMMO)
;	OR	A
;	JP	Z,LAMMO2
;	LD	DE,AMMO1A
;LAMMO2:
	LD	HL,(AMMOA_XY)
	LD	BC,00401h
	CALL	PUTATTSPR

	POP	BC
	POP	HL
	POP	DE
	RET

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SHOW_CAR:
	CALL	SW_L2
;	LD	A,(PLAY_MODE)
;	OR	A
;	RET	Z

	PUSH HL
	LD A,(PHASE_CAR)
	INC A
	AND 7
	LD (PHASE_CAR),A
	LD HL,CAR_ADR
	LD A,(PHASE_CAR)
	SRA	A
	PUSH	AF
	ADD	A,H
	LD	H,A
	POP	AF
	JP	NC,CPHC
	LD	A,L
	ADD	A,080h
	LD	L,A
CPHC:	
;	RET

	CALL CALC_COORD_CAR
	LD DE,(CAR_XY)
;	LD D,0E6h
	LD A,E
	AND A,03Fh
	LD E,A
; BC -  
	PUSH BC
	LD BC,#1008		; 16 pixs . x (4 syms x 2 bytes) .
	JP SPRITE_OUT

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;       
; . HC_XY =      
; . (DIRECTION) =     
; . (PHASE_HC) =     
; . (HC_XY) =     
CALC_COORD_CAR:
	LD A,(PHASE_CAR)
	CP 0
	RET NZ

	LD DE,CAR_XY
; DE = #6002 - coord X, #6003 - coord Y:
	LD A,(DE)
;	CP #00
;	RET Z
	DEC A
	DEC A
	LD (DE),A
	RET

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SHOW_HC:
	CALL	SW_L2
;	LD	A,(PLAY_MODE)
;	OR	A
;	RET	Z

;	LD A,(PHASE_HC)
;	CP 7
;	JP NZ,DRAW_PHASE_HC	;       
	EXX
	CALL	KEYS
	EXX
;	LD A,(PHASE_HC)
;	CP 7
;	RET Z
;	CALL DRAW_SPRITE_HC	
;	RET

DRAW_PHASE_HC:
	LD A,(PHASE_HC)
	INC A
	AND 3
	LD (PHASE_HC),A
	CALL DRAW_SPRITE_HC	
	RET

KEYS:
;	LD A,(KEY_Q)		;    
;	LD B,A
;	LD A,(KEY_A)
;	OR B
;	RET Z
;	LD A,(KEY_O)
;	LD B,A
;	LD A,(KEY_P)
;	OR B
;	RET Z

	LD IX,DEFINE_KEYS

;	LD C,#08		;   
;	LD E,(IX+0)		; P
;	LD D,(IX+1)
;	LD A,(DE)
;	OR A
;	JP Z,MOVE_FBUD
;	LD C,#10                ;   
;	LD E,(IX+2)		; O
;	LD D,(IX+3)
;	LD A,(DE)
;	OR A
;	JP Z,MOVE_FBUD
;	LD C,#18		;   	
;	LD E,(IX+4)		; Q
;	LD D,(IX+5)
;	LD A,(DE)
;	OR A
;	JP Z,MOVE_FBUD
;	LD C,#20		;   
;	LD E,(IX+6)		; A
;	LD D,(IX+7)
;	LD A,(DE)
;	OR A
;	JP Z,MOVE_FBUD
;	LD A,#00		;    
;	LD (DIRECTION),A	;   

	LD	A,(FIRE)
	OR	A
	RET	NZ		;  ,      
	LD	E,(IX+8)	; 1 - 
	LD	D,(IX+9)
	LD	A,(DE)
	OR	A
	RET	NZ		;  ,     1
	
	LD	A,1
	LD	(FIRE),A	;  
	XOR	A
	LD	(PHASE_AMMO),A	;   

	LD DE,AMMOR_BUF		;      
	LD HL,#D018		;      
;	LD HL,#CC15		;      
	LD (AMMOR_XY),HL
	LD BC,#0208		; ( ..  2  .)  (8 pixs .)
	CALL GETBL
	
	LD DE,AMMOA_BUF		;      
	LD HL,#F430		;      
;	LD HL,#F32E		;      
	LD (AMMOA_XY),HL
	LD BC,#0401		; ( ..  4  .)  (1 .. .)
	CALL GETATTBL
	
	LD	DE,AMMO0R
	LD	HL,(AMMOR_XY)
	LD	BC,00208h
	CALL	PUTSPR
	
	LD	DE,AMMO0A
	LD	HL,(AMMOA_XY)
	LD	BC,00401h
	CALL	PUTATTSPR

	RET

MOVE_FBUD:
	XOR A			;  
	LD (PHASE_HC),A
	LD A,C
	LD (DIRECTION),A	;   
	RET

DRAW_SPRITE_HC:
;	CALL CALC_PHASE_HC
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   
; . HC_ADR =    
; . (DIRECTION) =     
; . (PHASE_HC) =     
; . HL =  
;CALC_PHASE_HC:
	PUSH HL
	LD HL,HC_ADR
	LD A,(DIRECTION)
	ADD A,H
	LD H,A
	LD A,(PHASE_HC)
	ADD A
	ADD A,H
	LD H,A
;	RET

	LD (PLAY_SOUND),A
	CALL CALC_COORD_HC
	LD DE,(HC_XY)

; BC -   
	PUSH BC
	LD BC,#2010		; 32 pixs . x (8 syms x 2 bytes) .
	JP SPRITE_OUT

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;       
; . HC_XY =      
; . (DIRECTION) =     
; . (PHASE_HC) =     
; . (HC_XY) =     
CALC_COORD_HC:
	LD A,(PHASE_HC)
;	CP 4
;	RET NZ

	LD DE,HC_XY
; DE = #6000 - coord X, #6000+1 - coord Y:

	LD A,(DIRECTION)
	CP #08
	JP Z,MOVE_BACKWARD
	CP #10
	JP Z,MOVE_FORWARD
	CP #18
	JP Z,MOVE_UP
	CP #20
	JP Z,MOVE_DOWN
	RET

MOVE_BACKWARD:
	LD A,(DE)
	CP #00
	RET Z
	DEC A
	DEC A
	LD (DE),A
	RET

MOVE_FORWARD:
	LD A,(DE)
	CP #36
	RET Z
	INC A
	INC A
	LD (DE),A
	RET

MOVE_UP:
	INC DE
	LD A,(DE)
	CP #C0
	RET Z
	DEC A
	DEC A
	LD (DE),A
	DEC DE
	RET

MOVE_DOWN:
	INC DE
	LD A,(DE)
	CP #E8
	RET Z
	INC A
	INC A
	LD (DE),A
	DEC DE
	RET

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;B -    
;C -     * 2   
;HL -    
;DE -   
;DOWN_DE -    

SPRITE_OUT:
	push	BC 
	push	DE 
SO1LOOP:
	ld	A,(HL)
	ld	(DE),A 
	inc	HL 
	inc	DE
	dec	C 
	jp	NZ,SO1LOOP 
	pop	DE 
	call	DOWN_DE 
	pop	BC 
	djnz	SPRITE_OUT 

	POP	BC
	POP	HL
	RET
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
DOWN_DE: 
	ld	A,E; get low byte of address.
	add	A,64; one line down.
	ld	E,A; new low byte.
	ret	NC; not reached next segment yet.
	inc	D
	ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

CLEAR_SCREEN:
	LD HL,#4000
	LD DE,#4001
	LD BC,#17FF
	LD (HL),L
	LDIR

CLEAR_ATTR:
	SUB A
	LD HL,#5AFF
	LD DE,#5AFE
	LD BC,#2FF
	EI
	HALT
	DI
	LD (HL),#47
	OUT (#FE),A
	LDDR
	RET

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
CLEAR_LAYER0:
L1RASTR:
	LD HL,0C000h
	LD DE,0C001h
	LD BC,02FFFh
	LD (HL),L
	LDIR
L1ATTR:
	LD HL,0F000h
	LD DE,0F001h
	LD BC,00BFFh
	LD (HL),L
	LDIR

	RET
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
CLEAR_LAYER2:
L2RASTR:
	LD HL,0C000h
	LD DE,0C001h
	LD BC,02FFFh
	LD (HL),0FFh
	LDIR
L2ATTR:
	LD HL,0F000h
	LD DE,0F001h
	LD BC,00BFFh
	LD (HL),L
	LDIR

	RET

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
FILL_LAYER0:
	ld	HL,0C400h		; 2-  
	ld	B,000h			; 8 . 
LOOP1SPR:
	push	BC
	push	HL
	ld	DE,SKY1T
	ld	BC,00208h		; (1 ..  2 )  (8 pix )
	call	PUTSPR
	pop	HL
	ld	A,L
	add	A,2			; 2   ..
	ld	L,A
	pop	BC
	djnz	LOOP1SPR

	ld	HL,0D400h		; 10- 
	ld	B,0E0h			; 7 . 
LOOP2SPR:
	push	BC
	push	HL
	ld	DE,SKY1T
	ld	BC,00208h
	call	PUTSPR
	pop	HL
	ld	A,L
	add	A,2
	ld	L,A
	pop	BC
	djnz	LOOP2SPR

	ld	HL,0F100h		; 2-  
	ld	C,007h			; 7   2 
L1ASPR:
	ld	B,040h			; 2 
LOOP1ASPR:
	push	BC
	push	HL
	ld	DE,SKY1AT
	ld	BC,00401h		; (1 ..  4 )  (1 ..)
	call	PUTATTSPR
	pop	HL
	ld	A,L
	add	A,4			; 4   
	ld	L,A
	pop	BC
	djnz	LOOP1ASPR
	inc	H
	dec	C 
	jp	NZ,L1ASPR 

	ld	DE,CITYT
	ld	HL,0E000h
	ld	BC,04010h		; (32 .. .  2 ) x (   pix)
	call	PUTSPR
	ld	DE,CITYAT
	ld	HL,0F800h
	ld	BC,08002h		; (32 .. .  4 )  (2 .. .)
	call	PUTATTSPR

	ld	DE,ROADR
	ld	HL,0E400h
	ld	BC,04020h		; (32 .. .  2 ) x (   pix)
	call	PUTSPR
	ld	DE,ROADA
	ld	HL,0F900h
	ld	BC,08004h		; (32 .. .  4 )  (4 .. .)
	call	PUTATTSPR

	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
FILL_LAYER2:
;  14  ( )     
	LD	HL,0F100h
	LD	B,#0E; 14 .. .
FL1ATTR:
	LD	C,#20; 32 .. .
FCL1A:
	LD	(HL),092h
	INC	HL
	LD	(HL),049h
	INC	HL
	LD	(HL),003h
	INC	HL
	LD	(HL),000h
	INC	HL
	DEC	C
	JR	NZ,FCL1A
	DJNZ	FL1ATTR

;  4  ( 18-)     
	LD	HL,0F900h
	LD	B,#04; 4 .. .
FL2ATTR:
	LD	C,#20; 32 .. .
FCL2A:
	LD	(HL),049h
	INC	HL
	LD	(HL),040h
	INC	HL
	LD	(HL),003h
	INC	HL
	LD	(HL),000h
	INC	HL
	DEC	C
	JR	NZ,FCL2A
	DJNZ	FL2ATTR

	ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;DE-    , 
;HL-   , 
;B -     * 2  (2   ), 
;C -    . 
;DOWN_HL -    .
 
PUTSPR:
	push	BC 
	push	HL 
P1LOOP:
	ld	A,(DE); byte read 
	ld	(HL),A 
	inc	DE 
	inc	L
	djnz	P1LOOP 
	pop	HL 
	call	DOWN_HL 
	pop	BC 
	dec	C 
	jp	NZ,PUTSPR 
	ret 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;DE-     , 
;HL-    , 
;B -     * 4  (4   ), 
;C -    . 
;DNABL_HL -    .
 
PUTATTSPR:
	push	BC 
	push	HL 
PA1LOOP:
	ld	A,(DE); 
	ld	(HL),A
	inc	DE 
	inc	L
	djnz	PA1LOOP 
	pop	HL 
	call	DNABL_HL 
	pop	BC 
	dec	C 
	jp	NZ,PUTATTSPR 
	ret 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
DOWN_HL: 
	ld	A,L; get low byte of address.
	add	A,64; one line down.
	ld	L,A; new low byte.
	ret	NC; not reached next segment yet.
	inc	H
	ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
DNABL_HL: 
	ld	A,L; get low byte of address.
	add	A,128; one block down.
	ld	L,A; new low byte.
	ret	NC; not reached next symbol yet.
	inc	H
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;DE-    , 
;HL-   , 
;B -     * 2 , 
;C -    . 
;DOWN_HL -    .
 
GETBL:
	push	BC 
	push	HL 
GB1LOOP:
	ld	A,(HL) 
	ld	(DE),A
	inc	DE 
	inc	L
	djnz	GB1LOOP 
	pop	HL 
	call	DOWN_HL 
	pop	BC 
	dec	C 
	jp	NZ,GETBL 
	ret 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;DE-     , 
;HL-    , 
;B -     * 4 , 
;C -    . 
;DNABL_HL -    .
 
GETATTBL:
	push	BC 
	push	HL 
GAB1LOOP:
	ld	A,(HL) 
	ld	(DE),A
	inc	DE 
	inc	L
	djnz	GAB1LOOP 
	pop	HL 
	call	DNABL_HL 
	pop	BC 
	dec	C 
	jp	NZ,GETATTBL 
	ret 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;DE-    , 
;HL-   , 
;B -    , 
;C -    . 
;DOWN_HL -    .
 
PUTBL:
	push	BC 
	push	HL 
PB1LOOP:
	ld	A,(DE) 
	ld	(HL),A
	inc	DE 
	inc	L
	djnz	PB1LOOP 
	pop	HL 
	call	DOWN_HL 
	pop	BC 
	dec	C 
	jp	NZ,PUTBL
 	ret 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;DE-     , 
;HL-    , 
;B -     * 4, 
;C -    . 
;DNABL_HL -    .
 
PUTATTBL:
	push	BC 
	push	HL 
PAB1LOOP:
	ld	A,(DE) 
	ld	(HL),A
	inc	DE 
	inc	L
	djnz	PAB1LOOP 
	pop	HL 
	call	DNABL_HL 
	pop	BC 
	dec	C 
	jp	NZ,PUTATTBL
	ret 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   
REDEFINE_KEYS:
	LD A,(KEY_ANY)
	OR A
	JR Z,REDEFINE_KEYS

	LD HL,MSG_3
	LD BC,#0000
	CALL TEXT
	LD HL,MSG_4
	LD BC,#0100
	CALL TEXT
	LD HL,MSG_5
	LD BC,#0200
	CALL TEXT
	LD HL,MSG_6
	LD BC,#0300
	CALL TEXT
	LD HL,MSG_7
	LD BC,#0400
	CALL TEXT


	LD IX,DEFINE_KEYS
	LD B,#04
	LD A,#01
D_LOOP	EX AF,AF'
	PUSH BC

LISTEN_KEYBOARD:
	EI
	HALT
	SUB A
	LD HL,KEY_MAP
	LD BC,40-2
	CPIR
	JR NZ,LISTEN_KEYBOARD
	DEC HL
	LD (IX+0),L
	INC IX
	LD (IX+0),H
	INC IX
	LD DE,KEY_MAP
	AND A
	SBC HL,DE
	LD A,"A"
	ADD A,L
	LD C,#0C
	EX AF,AF'
	LD B,A
	EX AF,AF'
	CALL CORD_TO_ADR
	CALL SYMBOL
	CALL NOISE
	POP BC
UNHOLD	LD A,(KEY_ANY)
	OR A
	JR Z,UNHOLD
	EX AF,AF'
	INC A
	DJNZ D_LOOP
	RET

WAIT_SPACEKEY:
;	LD A,(KEY_ENT)
;	OR A
;	PUSH AF
;	CALL Z,REDEFINE_KEYS
;	POP AF
;	RET Z

	LD A,(KEY_SPC)
	OR A
	JR NZ,WAIT_SPACEKEY
W_SP:
	LD A,(KEY_SPC)
	OR A
	JR Z,W_SP
	RET

CHECK_KEYBOARD:
        LD HL,KEY_MAP
	LD D,H
	LD E,L
	INC E
        LD BC,40
	LD A,C
        LD (HL),B
	LDIR
        LD B,A
        LD DE,KEY_MAP
        LD HL,KEYTAB
SCANLP  LD A,(HL)
        IN A,(#FE)
        INC HL
        AND (HL)
        INC HL
        JR Z,$+4
        LD A,#FF
        LD (DE),A
        INC E
        DJNZ SCANLP
	XOR A
	IN A,(#FE)
	CPL
	AND #1F
	LD A,#00
        JR NZ,$+4
        LD A,#FF
        LD (DE),A
	RET

;  
TEXT	CALL CORD_TO_ADR
TX_L2	LD A,(HL)
	OR A
	RET Z
	CALL SYMBOL
	INC HL
	INC E
	JP TX_L2

; BC = CORD
; DE = ADR
CORD_TO_ADR:
	PUSH AF
	PUSH HL
	PUSH BC
	LD A,B
	RRCA
	RRCA
	RRCA
	AND #E0
	LD L,A
	LD A,B
	AND #18
	OR #40
	LD H,A
	LD B,#00
	ADD HL,BC
	EX DE,HL
	POP BC
	POP HL
	POP AF
	RET

; DE = ADR
; A = SYMB
SYMBOL:
	PUSH HL
	LD L,A
	LD H,#00
	LD BC,#3C00
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	ADD HL,BC
	LD C,D
	LD B,#08
TX_L1	LD A,(HL)
	RRA
	OR (HL)
	LD (DE),A
	INC HL
	INC D
	DJNZ TX_L1
	LD D,C
	POP HL
	RET

SCREEN_TAB:
	DW #0000		;  1
	DW #0400            	;  2
	DW #0800                ;  3
	DW #0D00                ;  4
;	DW #1000                ;  5
;	DW #1400                ;  6

KEYTAB	DB #FD,1        ;#14
	DB #7F,16       ;#23
	DB #FE,8        ;#21
	DB #FD,4        ;#16
	DB #FB,4        ;#0C
	DB #FD,8        ;#17
	DB #FD,16       ;#18
	DB #BF,16       ;#19
	DB #DF,4        ;#11
	DB #BF,8        ;#1A
	DB #BF,4        ;#1B
	DB #BF,2        ;#1C
	DB #7F,4        ;#25
	DB #7F,8        ;#24
	DB #DF,2        ;#12
	DB #DF,1        ;#13
	DB #FB,1        ;#0A
	DB #FB,8        ;#0D
	DB #FD,2        ;#15
	DB #FB,16       ;#0E
	DB #DF,8        ;#10
	DB #FE,16       ;#22
	DB #FB,2        ;#0B
	DB #FE,4        ;#20
	DB #DF,16       ;#0F
	DB #FE,2        ;#1F

	DB #EF,1	;#09
	DB #F7,1	;#00
	DB #F7,2        ;#01
	DB #F7,4        ;#02
	DB #F7,8        ;#03
	DB #F7,16       ;#04
	DB #EF,16       ;#05
	DB #EF,8        ;#06
	DB #EF,4        ;#07
	DB #EF,2        ;#08

	DB #7F,1        ;#27
	DB #BF,1        ;#1D

	DB #FE,1        ;#1E
	DB #7F,2        ;#26

MSG_1	DB "Helicop game demo",#00
MSG_2	DB "Press SPACE to continue",#00
MSG_0	DB "Press ENTER to redefine keys",#00
MSG_3	DB "Redefine keys:",#00
MSG_4	DB "Right:P;",#00
MSG_5	DB "Left:O;",#00
MSG_6	DB "Up:Q;",#00
MSG_7	DB "Down:A;",#00
MSG_8	DB "HELICOP DEMO",#00
MSG_SCORE	DB "SCORE: 000",#00
MSG_AMMO	DB "AMMO: 100",#00

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

TILES:
SKY1T:
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
SKY1AT:
	DEFB	017h,017h,017h,017h;

;New ZX screen format (NSPEC)
;Converter: bmp sprites (24 bits RGB888) to asm
;Rastr format: 2 bits per pixel
;Attribute format: 4 byte attributes (RGB332) per symbol (8x8 pixs)
;Height = 16; Width = 256

CITYT:
	DEFW	0FFFFh;
	DEFW	0EFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0D5FFh;
	DEFW	07F55h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	055F5h;
	DEFW	05F55h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	05555h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FDFFh;
	DEFW	05755h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0ABFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0AAFAh;
	DEFW	0AAAAh;
	DEFW	095AAh;
	DEFW	07F55h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	05555h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0AAFAh;
	DEFW	0FFAFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0BFFEh;
	DEFW	0FFFFh;
	DEFW	0FFAFh;
	DEFW	0FFFFh;
	DEFW	0FDFFh;
	DEFW	05755h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0BAFEh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0AAFAh;
	DEFW	0AAAAh;
	DEFW	091AAh;
	DEFW	07F11h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FD57h;
	DEFW	0FF5Fh;
	DEFW	04444h;
	DEFW	04544h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	04544h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0AAFAh;
	DEFW	0FFAFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0AFFAh;
	DEFW	0FEFFh;
	DEFW	0FFABh;
	DEFW	0FDFFh;
	DEFW	0FD57h;
	DEFW	01711h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0BAFEh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0A2F8h;
	DEFW	0288Ah;
	DEFW	095A2h;
	DEFW	07F55h;
	DEFW	0FFFFh;
	DEFW	0D5FFh;
	DEFW	05555h;
	DEFW	07F55h;
	DEFW	04444h;
	DEFW	04544h;
	DEFW	0FFFFh;
	DEFW	0FFD7h;
	DEFW	05555h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	088F8h;
	DEFW	0FFAFh;
	DEFW	0EAFFh;
	DEFW	0FEBFh;
	DEFW	0FFABh;
	DEFW	0ABEAh;
	DEFW	0FAFFh;
	DEFW	0FFAAh;
	DEFW	0F5FFh;
	DEFW	0FD55h;
	DEFW	05755h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0AAFAh;
	DEFW	0FFBFh;
	DEFW	0FFFFh;
	DEFW	0AAFAh;
	DEFW	0AAAAh;
	DEFW	091AAh;
	DEFW	07F11h;
	DEFW	0FFFFh;
	DEFW	0D5FFh;
	DEFW	05555h;
	DEFW	06A55h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	0FFFFh;
	DEFW	0FF55h;
	DEFW	04544h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0AAFAh;
	DEFW	0FEAFh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0ABAAh;
	DEFW	0EBEFh;
	DEFW	0FBFFh;
	DEFW	0FFFAh;
	DEFW	0F5FFh;
	DEFW	0FD55h;
	DEFW	01611h;
	DEFW	0AAAAh;
	DEFW	0FFABh;
	DEFW	0FFFFh;
	DEFW	0BBFBh;
	DEFW	055BDh;
	DEFW	055FFh;
	DEFW	0A278h;
	DEFW	0288Ah;
	DEFW	095A2h;
	DEFW	07A55h;
	DEFW	0FFFFh;
	DEFW	0D1EBh;
	DEFW	0A111h;
	DEFW	06A11h;
	DEFW	04444h;
	DEFW	04544h;
	DEFW	0FDFFh;
	DEFW	07F55h;
	DEFW	05555h;
	DEFW	0AAFAh;
	DEFW	0AFAAh;
	DEFW	088F8h;
	DEFW	0FEAFh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0ABAAh;
	DEFW	0ABEAh;
	DEFW	0FAFFh;
	DEFW	055AAh;
	DEFW	0F45Fh;
	DEFW	0FD45h;
	DEFW	05655h;
	DEFW	0AAAAh;
	DEFW	0FFABh;
	DEFW	0FFFFh;
	DEFW	0BBFBh;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	0AA55h;
	DEFW	0AAAAh;
	DEFW	091AAh;
	DEFW	0AA1Ah;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	06295h;
	DEFW	04444h;
	DEFW	04544h;
	DEFW	0FDFFh;
	DEFW	07F11h;
	DEFW	04544h;
	DEFW	0AAEAh;
	DEFW	0ABAAh;
	DEFW	0AAFAh;
	DEFW	0FEAFh;
	DEFW	08820h;
	DEFW	00822h;
	DEFW	02B82h;
	DEFW	0EBEFh;
	DEFW	0FBFFh;
	DEFW	055FAh;
	DEFW	0F557h;
	DEFW	0FD55h;
	DEFW	01611h;
	DEFW	0AAAAh;
	DEFW	0FFABh;
	DEFW	0FFFFh;
	DEFW	0AAFAh;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	0A255h;
	DEFW	0288Ah;
	DEFW	095A2h;
	DEFW	02258h;
	DEFW	02008h;
	DEFW	02088h;
	DEFW	02082h;
	DEFW	06A91h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	0FDFFh;
	DEFW	07F55h;
	DEFW	05555h;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	088B8h;
	DEFW	0FEAFh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0ABAAh;
	DEFW	0ABEAh;
	DEFW	0FAFFh;
	DEFW	011AAh;
	DEFW	0F417h;
	DEFW	0FD45h;
	DEFW	05655h;
	DEFW	02222h;
	DEFW	0FF2Bh;
	DEFW	05555h;
	DEFW	0BB7Bh;
	DEFW	04444h;
	DEFW	04444h;
	DEFW	0AA45h;
	DEFW	0AAAAh;
	DEFW	091AAh;
	DEFW	0AA1Ah;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	06295h;
	DEFW	04444h;
	DEFW	04544h;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	04584h;
	DEFW	0BBBBh;
	DEFW	0BABBh;
	DEFW	0AABAh;
	DEFW	0FEAFh;
	DEFW	08820h;
	DEFW	00822h;
	DEFW	02B82h;
	DEFW	055D5h;
	DEFW	05755h;
	DEFW	056FAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	01611h;
	DEFW	02222h;
	DEFW	0552Bh;
	DEFW	05555h;
	DEFW	0BB57h;
	DEFW	04444h;
	DEFW	04444h;
	DEFW	0A245h;
	DEFW	0288Ah;
	DEFW	095A2h;
	DEFW	02258h;
	DEFW	02008h;
	DEFW	02088h;
	DEFW	02082h;
	DEFW	06A91h;
	DEFW	04444h;
	DEFW	04544h;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	05595h;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	05595h;
	DEFW	05555h;
	DEFW	0AA6Ah;
	DEFW	0AAAAh;
	DEFW	0ABAAh;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	012AAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	05655h;
	DEFW	0AAAAh;
	DEFW	055A9h;
	DEFW	01111h;
	DEFW	0AA16h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	0AA55h;
	DEFW	0AAAAh;
	DEFW	091AAh;
	DEFW	0AA1Ah;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	06295h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	00882h;
	DEFW	08220h;
	DEFW	04584h;
	DEFW	0EEAEh;
	DEFW	0EEEEh;
	DEFW	00481h;
	DEFW	04110h;
	DEFW	08860h;
	DEFW	00822h;
	DEFW	02982h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	0567Ah;
	DEFW	02008h;
	DEFW	00A82h;
	DEFW	01611h;
	DEFW	02222h;
	DEFW	01129h;
	DEFW	05555h;
	DEFW	0BB57h;
	DEFW	04444h;
	DEFW	04444h;
	DEFW	0A245h;
	DEFW	0288Ah;
	DEFW	095A2h;
	DEFW	02258h;
	DEFW	02008h;
	DEFW	02088h;
	DEFW	02082h;
	DEFW	06A91h;
	DEFW	04444h;
	DEFW	04544h;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	05595h;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	05595h;
	DEFW	05555h;
	DEFW	0AA6Ah;
	DEFW	0AAAAh;
	DEFW	0A9AAh;
	DEFW	01111h;
	DEFW	01111h;
	DEFW	0126Ah;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	05655h;
	DEFW	02222h;
	DEFW	05529h;
	DEFW	01111h;
	DEFW	0BB17h;
	DEFW	04444h;
	DEFW	04444h;
	DEFW	0AA45h;
	DEFW	0AAAAh;
	DEFW	091AAh;
	DEFW	0AA1Ah;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	06295h;
	DEFW	05544h;
	DEFW	04555h;
	DEFW	00882h;
	DEFW	08220h;
	DEFW	04584h;
	DEFW	0BBBBh;
	DEFW	0BABBh;
	DEFW	04484h;
	DEFW	04444h;
	DEFW	08860h;
	DEFW	00822h;
	DEFW	02982h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	0567Ah;
	DEFW	02008h;
	DEFW	00A82h;
	DEFW	01611h;
	DEFW	0AAAAh;
	DEFW	011A9h;
	DEFW	05555h;
	DEFW	0AA56h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	0A255h;
	DEFW	0288Ah;
	DEFW	095A2h;
	DEFW	08058h;
	DEFW	08AA2h;
	DEFW	08A02h;
	DEFW	00A28h;
	DEFW	06A95h;
	DEFW	05055h;
	DEFW	05501h;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	05595h;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	05595h;
	DEFW	05555h;
	DEFW	0AA6Ah;
	DEFW	0AAAAh;
	DEFW	0A9AAh;
	DEFW	01111h;
	DEFW	01101h;
	DEFW	0126Ah;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	05655h;
	DEFW	00220h;
	DEFW	05529h;
	DEFW	01111h;
	DEFW	0BB17h;
	DEFW	04444h;
	DEFW	04444h;
	DEFW	0AA45h;
	DEFW	0AAAAh;
	DEFW	091AAh;
	DEFW	0881Ah;
	DEFW	0AAAAh;
	DEFW	0AA22h;
	DEFW	08AA8h;
	DEFW	06291h;
	DEFW	05144h;
	DEFW	04551h;
	DEFW	00882h;
	DEFW	08220h;
	DEFW	04584h;
	DEFW	0EEAEh;
	DEFW	0EEEEh;
	DEFW	00481h;
	DEFW	04110h;
	DEFW	08860h;
	DEFW	00822h;
	DEFW	02982h;
	DEFW	05555h;
	DEFW	05511h;
	DEFW	0567Ah;
	DEFW	02008h;
	DEFW	00A82h;
	DEFW	01611h;
	DEFW	0A222h;
	DEFW	01129h;
	DEFW	05555h;
	DEFW	0AA56h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	0AA55h;
	DEFW	0AAAAh;
	DEFW	095AAh;
	DEFW	0885Ah;
	DEFW	0AAAAh;
	DEFW	0AA22h;
	DEFW	08AA8h;
	DEFW	06A95h;
	DEFW	05155h;
	DEFW	05551h;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	05595h;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	05595h;
	DEFW	05555h;
	DEFW	0A86Ah;
	DEFW	0AA2Ah;
	DEFW	0A982h;
	DEFW	05555h;
	DEFW	05511h;
	DEFW	0566Ah;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	05655h;
	DEFW	0A2A2h;
	DEFW	055A9h;
CITYAT:
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;
	DEFB	0B6h,06Dh,049h,017h;

;New ZX screen format (NSPEC)
;Converter: bmp sprites (24 bits RGB888) to sjasm
;Rastr format: 2 bits per pixel
;Attribute format: 4 byte attributes (RGB332) per symbol (8x8 pixs)
;Height = 32; Width = 256

ROADR:
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	01BB9h;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	056E5h;
	DEFW	0AAEAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0BBAAh;
	DEFW	01595h;
	DEFW	0AABBh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0EEAAh;
	DEFW	05555h;
	DEFW	0EA6Eh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0B9ABh;
	DEFW	01555h;
	DEFW	0BA5Bh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0E5AFh;
	DEFW	05555h;
	DEFW	0FE56h;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	095BEh;
	DEFW	01555h;
	DEFW	0AF55h;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	055EEh;
	DEFW	05555h;
	DEFW	06E55h;
	DEFW	0AAEAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAAAh;
	DEFW	0AAABh;
	DEFW	0BAAAh;
	DEFW	0ABBAh;
	DEFW	0AAAAh;
	DEFW	0BABAh;
	DEFW	0AAABh;
	DEFW	0BAAAh;
	DEFW	0ABBAh;
	DEFW	0AAAAh;
	DEFW	0AFBAh;
	DEFW	055B9h;
	DEFW	01555h;
	DEFW	05B55h;
	DEFW	0AABEh;
	DEFW	0ABBAh;
	DEFW	0AAAAh;
	DEFW	0BABAh;
	DEFW	0AAABh;
	DEFW	0BAAAh;
	DEFW	0ABBAh;
	DEFW	0AAAAh;
	DEFW	0BABAh;
	DEFW	0AAABh;
	DEFW	0BAAAh;
	DEFW	0ABBAh;
	DEFW	0AAAAh;
	DEFW	0BABAh;
	DEFW	0AAABh;
	DEFW	0BAAAh;
	DEFW	0ABBAh;
	DEFW	0AAAAh;
	DEFW	0BABAh;
	DEFW	0EAAFh;
	DEFW	0FEEAh;
	DEFW	0AFEEh;
	DEFW	0EAEAh;
	DEFW	0EEFEh;
	DEFW	0EAAFh;
	DEFW	0FEEAh;
	DEFW	0AFEEh;
	DEFW	0EAEAh;
	DEFW	0EEFEh;
	DEFW	055E5h;
	DEFW	05555h;
	DEFW	05655h;
	DEFW	0AAEBh;
	DEFW	0AFEEh;
	DEFW	0EAEAh;
	DEFW	0EEFEh;
	DEFW	0EAAFh;
	DEFW	0FEEAh;
	DEFW	0AFEEh;
	DEFW	0EAEAh;
	DEFW	0EEFEh;
	DEFW	0EAAFh;
	DEFW	0FEEAh;
	DEFW	0AFEEh;
	DEFW	0EAEAh;
	DEFW	0EEFEh;
	DEFW	0EAAFh;
	DEFW	0FEEAh;
	DEFW	0AFEEh;
	DEFW	0EAEAh;
	DEFW	0EEFEh;
	DEFW	0EBBEh;
	DEFW	0EEBBh;
	DEFW	0BEBAh;
	DEFW	0BBEBh;
	DEFW	0BAEEh;
	DEFW	0EBBEh;
	DEFW	0EEBBh;
	DEFW	0BEBAh;
	DEFW	0BBEBh;
	DEFW	0BFEFh;
	DEFW	05595h;
	DEFW	01555h;
	DEFW	05555h;
	DEFW	0AEBBh;
	DEFW	0BEBAh;
	DEFW	0BBEBh;
	DEFW	0BAEEh;
	DEFW	0EBBEh;
	DEFW	0EEBBh;
	DEFW	0BEBAh;
	DEFW	0BBEBh;
	DEFW	0BAEEh;
	DEFW	0EBBEh;
	DEFW	0EEBBh;
	DEFW	0BEBAh;
	DEFW	0BBEBh;
	DEFW	0BAEEh;
	DEFW	0EBBEh;
	DEFW	0EEBBh;
	DEFW	0BEBAh;
	DEFW	0BBEBh;
	DEFW	0BAEEh;
	DEFW	0FABBh;
	DEFW	0BFEBh;
	DEFW	0BBAAh;
	DEFW	0EBFAh;
	DEFW	0AABFh;
	DEFW	0FABBh;
	DEFW	0BFEBh;
	DEFW	0BBAAh;
	DEFW	0EBFAh;
	DEFW	0EEBEh;
	DEFW	05555h;
	DEFW	01555h;
	DEFW	05555h;
	DEFW	0FB6Fh;
	DEFW	0BBAAh;
	DEFW	0EBFAh;
	DEFW	0AABFh;
	DEFW	0FABBh;
	DEFW	0BFEBh;
	DEFW	0BBAAh;
	DEFW	0EBFAh;
	DEFW	0AABFh;
	DEFW	0FABBh;
	DEFW	0BFEBh;
	DEFW	0BBAAh;
	DEFW	0EBFAh;
	DEFW	0AABFh;
	DEFW	0FABBh;
	DEFW	0BFEBh;
	DEFW	0BBAAh;
	DEFW	0EBFAh;
	DEFW	0AABFh;
	DEFW	0BEFBh;
	DEFW	0BBAFh;
	DEFW	0FBEAh;
	DEFW	0AFBEh;
	DEFW	0EABBh;
	DEFW	0BEFBh;
	DEFW	0BBAFh;
	DEFW	0FBEAh;
	DEFW	0AFBEh;
	DEFW	0F9BBh;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	0EF5Ah;
	DEFW	0FBEAh;
	DEFW	0AFBEh;
	DEFW	0EABBh;
	DEFW	0BEFBh;
	DEFW	0BBAFh;
	DEFW	0FBEAh;
	DEFW	0AFBEh;
	DEFW	0EABBh;
	DEFW	0BEFBh;
	DEFW	0BBAFh;
	DEFW	0FBEAh;
	DEFW	0AFBEh;
	DEFW	0EABBh;
	DEFW	0BEFBh;
	DEFW	0BBAFh;
	DEFW	0FBEAh;
	DEFW	0AFBEh;
	DEFW	0EABBh;
	DEFW	0FEFFh;
	DEFW	0FFEFh;
	DEFW	0FFEEh;
	DEFW	0EFFEh;
	DEFW	0EEFFh;
	DEFW	0FEFFh;
	DEFW	0FFEFh;
	DEFW	0FFEEh;
	DEFW	0EFFEh;
	DEFW	0A5FFh;
	DEFW	05555h;
	DEFW	01555h;
	DEFW	05555h;
	DEFW	0FB56h;
	DEFW	0FFEEh;
	DEFW	0EFFEh;
	DEFW	0EEFFh;
	DEFW	0FEFFh;
	DEFW	0FFEFh;
	DEFW	0FFEEh;
	DEFW	0EFFEh;
	DEFW	0EEFFh;
	DEFW	0FEFFh;
	DEFW	0FFEFh;
	DEFW	0FFEEh;
	DEFW	0EFFEh;
	DEFW	0EEFFh;
	DEFW	0FEFFh;
	DEFW	0FFEFh;
	DEFW	0FFEEh;
	DEFW	0EFFEh;
	DEFW	0EEFFh;
	DEFW	0EBAFh;
	DEFW	0FEBAh;
	DEFW	0AFBBh;
	DEFW	0BAEBh;
	DEFW	0BBFEh;
	DEFW	0EBAFh;
	DEFW	0FEBAh;
	DEFW	0AFBBh;
	DEFW	0BAEBh;
	DEFW	095FFh;
	DEFW	05555h;
	DEFW	01555h;
	DEFW	05555h;
	DEFW	0BF55h;
	DEFW	0AFBBh;
	DEFW	0BAEBh;
	DEFW	0BBFEh;
	DEFW	0EBAFh;
	DEFW	0FEBAh;
	DEFW	0AFBBh;
	DEFW	0BAEBh;
	DEFW	0BBFEh;
	DEFW	0EBAFh;
	DEFW	0FEBAh;
	DEFW	0AFBBh;
	DEFW	0BAEBh;
	DEFW	0BBFEh;
	DEFW	0EBAFh;
	DEFW	0FEBAh;
	DEFW	0AFBBh;
	DEFW	0BAEBh;
	DEFW	0BBFEh;
	DEFW	0AAABh;
	DEFW	0BAEAh;
	DEFW	0ABAEh;
	DEFW	0EAAAh;
	DEFW	0AEBAh;
	DEFW	0AAABh;
	DEFW	0BAEAh;
	DEFW	0ABAEh;
	DEFW	0EAAAh;
	DEFW	055BAh;
	DEFW	05555h;
	DEFW	01555h;
	DEFW	05555h;
	DEFW	06E55h;
	DEFW	0ABAEh;
	DEFW	0EAAAh;
	DEFW	0AEBAh;
	DEFW	0AAABh;
	DEFW	0BAEAh;
	DEFW	0ABAEh;
	DEFW	0EAAAh;
	DEFW	0AEBAh;
	DEFW	0AAABh;
	DEFW	0BAEAh;
	DEFW	0ABAEh;
	DEFW	0EAAAh;
	DEFW	0AEBAh;
	DEFW	0AAABh;
	DEFW	0BAEAh;
	DEFW	0ABAEh;
	DEFW	0EAAAh;
	DEFW	0AEBAh;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	00140h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05555h;
ROADA:
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;
	DEFB	0FFh,092h,035h,029h;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	ORG #8000
HC_ADR:

;New ZX screen format (NSPEC)
;Converter: bmp sprites (24 bits RGB888) to asm
;Rastr format: 2 bits per pixel
;Attribute format: 4 byte attributes (RGB332) per symbol (8x8 pixs)
;Height = 32; Width = 64

HC0T:
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0C0FFh;
	DEFW	0FF0Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FCFFh;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	04155h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	0FF4Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	000FDh;
	DEFW	0FF01h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0DDFFh;
	DEFW	0FFDFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	055FFh;
	DEFW	05555h;
	DEFW	0FF57h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	000FDh;
	DEFW	00000h;
	DEFW	0FF69h;
	DEFW	0FFFFh;
	DEFW	0FDFFh;
	DEFW	0FF55h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	001F4h;
	DEFW	05055h;
	DEFW	07F6Ah;
	DEFW	0FFFFh;
	DEFW	0F4FFh;
	DEFW	07F00h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	004D0h;
	DEFW	00400h;
	DEFW	09F6Ah;
	DEFW	0FFFFh;
	DEFW	0D0FFh;
	DEFW	01F00h;
	DEFW	0FFFFh;
	DEFW	055FFh;
	DEFW	04455h;
	DEFW	00400h;
	DEFW	0A76Ah;
	DEFW	0FFFFh;
	DEFW	040FFh;
	DEFW	04755h;
	DEFW	0FFFFh;
	DEFW	000FDh;
	DEFW	00400h;
	DEFW	00440h;
	DEFW	0A96Ah;
	DEFW	0FFFFh;
	DEFW	041FFh;
	DEFW	051FFh;
	DEFW	0FFFFh;
	DEFW	055F5h;
	DEFW	04455h;
	DEFW	00440h;
	DEFW	0AA6Ah;
	DEFW	0FF7Fh;
	DEFW	047FFh;
	DEFW	054FDh;
	DEFW	0FF7Fh;
	DEFW	000D0h;
	DEFW	00400h;
	DEFW	00440h;
	DEFW	0AA1Ah;
	DEFW	0FF9Fh;
	DEFW	047FFh;
	DEFW	074F5h;
	DEFW	05515h;
	DEFW	05555h;
	DEFW	04455h;
	DEFW	00400h;
	DEFW	05505h;
	DEFW	0FF57h;
	DEFW	047FFh;
	DEFW	0F4D5h;
	DEFW	05505h;
	DEFW	00000h;
	DEFW	00400h;
	DEFW	00400h;
	DEFW	00000h;
	DEFW	0FF05h;
	DEFW	047FFh;
	DEFW	0F457h;
	DEFW	00000h;
	DEFW	00000h;
	DEFW	00400h;
	DEFW	00400h;
	DEFW	00000h;
	DEFW	0FF01h;
	DEFW	045FFh;
	DEFW	0F45Fh;
	DEFW	00000h;
	DEFW	00000h;
	DEFW	00100h;
	DEFW	05055h;
	DEFW	00000h;
	DEFW	0FF05h;
	DEFW	0D1FFh;
	DEFW	0D07Fh;
	DEFW	05515h;
	DEFW	05555h;
	DEFW	00040h;
	DEFW	00000h;
	DEFW	05501h;
	DEFW	0FF57h;
	DEFW	0F4FFh;
	DEFW	04055h;
	DEFW	0FF7Fh;
	DEFW	0FDFFh;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	04155h;
	DEFW	0FF7Fh;
	DEFW	0FDFFh;
	DEFW	00100h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	00054h;
	DEFW	00000h;
	DEFW	04117h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	05755h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	055D5h;
	DEFW	05555h;
	DEFW	0555Fh;
	DEFW	0FF7Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FDFFh;
	DEFW	0FF5Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FF57h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFD5h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFF5h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;

HC1T:
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0C0FFh;
	DEFW	0FF0Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0C5FFh;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05505h;
	DEFW	05555h;
	DEFW	05455h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	000FDh;
	DEFW	0FF01h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0DDFFh;
	DEFW	0FFDFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	055FFh;
	DEFW	05555h;
	DEFW	0FF57h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	000FDh;
	DEFW	00000h;
	DEFW	0FF69h;
	DEFW	0FFFFh;
	DEFW	0FDFFh;
	DEFW	0FF55h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	001F4h;
	DEFW	05055h;
	DEFW	07F6Ah;
	DEFW	0FFFFh;
	DEFW	0F4FFh;
	DEFW	07F00h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	004D0h;
	DEFW	00400h;
	DEFW	09F6Ah;
	DEFW	0FFFFh;
	DEFW	0D0FFh;
	DEFW	01F00h;
	DEFW	0FFFFh;
	DEFW	055FFh;
	DEFW	04455h;
	DEFW	00400h;
	DEFW	0A76Ah;
	DEFW	0FFFFh;
	DEFW	040FFh;
	DEFW	04755h;
	DEFW	0FFFFh;
	DEFW	000FDh;
	DEFW	00400h;
	DEFW	00440h;
	DEFW	0A96Ah;
	DEFW	0FFFFh;
	DEFW	041FFh;
	DEFW	0D1FFh;
	DEFW	0FFFFh;
	DEFW	055F5h;
	DEFW	04455h;
	DEFW	00440h;
	DEFW	0AA6Ah;
	DEFW	0FF7Fh;
	DEFW	047FFh;
	DEFW	0F4FFh;
	DEFW	0FF7Fh;
	DEFW	000D0h;
	DEFW	00400h;
	DEFW	00440h;
	DEFW	0AA1Ah;
	DEFW	0FF9Fh;
	DEFW	045FFh;
	DEFW	05455h;
	DEFW	05515h;
	DEFW	05555h;
	DEFW	04455h;
	DEFW	00400h;
	DEFW	05505h;
	DEFW	0FF57h;
	DEFW	045FFh;
	DEFW	05455h;
	DEFW	05505h;
	DEFW	00000h;
	DEFW	00400h;
	DEFW	00400h;
	DEFW	00000h;
	DEFW	0FF05h;
	DEFW	045FFh;
	DEFW	05455h;
	DEFW	00000h;
	DEFW	00000h;
	DEFW	00400h;
	DEFW	00400h;
	DEFW	00000h;
	DEFW	0FF01h;
	DEFW	047FFh;
	DEFW	0F4FFh;
	DEFW	00000h;
	DEFW	00000h;
	DEFW	00100h;
	DEFW	05055h;
	DEFW	00000h;
	DEFW	0FF05h;
	DEFW	0D1FFh;
	DEFW	0D0FFh;
	DEFW	05515h;
	DEFW	05555h;
	DEFW	00040h;
	DEFW	00000h;
	DEFW	05501h;
	DEFW	0FF57h;
	DEFW	0F4FFh;
	DEFW	04055h;
	DEFW	0FF7Fh;
	DEFW	0FDFFh;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	04155h;
	DEFW	0FF7Fh;
	DEFW	0FDFFh;
	DEFW	00100h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	00054h;
	DEFW	00000h;
	DEFW	04117h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	05755h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	055D5h;
	DEFW	05555h;
	DEFW	0555Fh;
	DEFW	0FF7Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FDFFh;
	DEFW	0FF5Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FF57h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFD5h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFF5h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;

HC2T:
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0C0FFh;
	DEFW	0FF0Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FCFFh;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	04155h;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	0FF4Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	000FDh;
	DEFW	0FF01h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0DDFFh;
	DEFW	0FFDFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	055FFh;
	DEFW	05555h;
	DEFW	0FF57h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	000FDh;
	DEFW	00000h;
	DEFW	0FF69h;
	DEFW	0FFFFh;
	DEFW	0FDFFh;
	DEFW	0FF55h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	001F4h;
	DEFW	05055h;
	DEFW	07F6Ah;
	DEFW	0FFFFh;
	DEFW	0F4FFh;
	DEFW	07F00h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	004D0h;
	DEFW	00400h;
	DEFW	09F6Ah;
	DEFW	0FFFFh;
	DEFW	0D0FFh;
	DEFW	01F00h;
	DEFW	0FFFFh;
	DEFW	055FFh;
	DEFW	04455h;
	DEFW	00400h;
	DEFW	0A76Ah;
	DEFW	0FFFFh;
	DEFW	040FFh;
	DEFW	04755h;
	DEFW	0FFFFh;
	DEFW	000FDh;
	DEFW	00400h;
	DEFW	00440h;
	DEFW	0A96Ah;
	DEFW	0FFFFh;
	DEFW	041FFh;
	DEFW	0D17Fh;
	DEFW	0FFFFh;
	DEFW	055F5h;
	DEFW	04455h;
	DEFW	00440h;
	DEFW	0AA6Ah;
	DEFW	0FF7Fh;
	DEFW	045FFh;
	DEFW	0F45Fh;
	DEFW	0FF7Fh;
	DEFW	000D0h;
	DEFW	00400h;
	DEFW	00440h;
	DEFW	0AA1Ah;
	DEFW	0FF9Fh;
	DEFW	047FFh;
	DEFW	0F457h;
	DEFW	05515h;
	DEFW	05555h;
	DEFW	04455h;
	DEFW	00400h;
	DEFW	05505h;
	DEFW	0FF57h;
	DEFW	047FFh;
	DEFW	0F4D5h;
	DEFW	05505h;
	DEFW	00000h;
	DEFW	00400h;
	DEFW	00400h;
	DEFW	00000h;
	DEFW	0FF05h;
	DEFW	047FFh;
	DEFW	074F5h;
	DEFW	00000h;
	DEFW	00000h;
	DEFW	00400h;
	DEFW	00400h;
	DEFW	00000h;
	DEFW	0FF01h;
	DEFW	047FFh;
	DEFW	054FDh;
	DEFW	00000h;
	DEFW	00000h;
	DEFW	00100h;
	DEFW	05055h;
	DEFW	00000h;
	DEFW	0FF05h;
	DEFW	0D1FFh;
	DEFW	050FFh;
	DEFW	05515h;
	DEFW	05555h;
	DEFW	00040h;
	DEFW	00000h;
	DEFW	05501h;
	DEFW	0FF57h;
	DEFW	0F4FFh;
	DEFW	04055h;
	DEFW	0FF7Fh;
	DEFW	0FDFFh;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	04155h;
	DEFW	0FF7Fh;
	DEFW	0FDFFh;
	DEFW	00100h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	00054h;
	DEFW	00000h;
	DEFW	04117h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	05755h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	055D5h;
	DEFW	05555h;
	DEFW	0555Fh;
	DEFW	0FF7Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FDFFh;
	DEFW	0FF5Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FF57h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFD5h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFF5h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;

HC3T:
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0C0FFh;
	DEFW	0FF0Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0C5FFh;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	05505h;
	DEFW	05555h;
	DEFW	05455h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	000FDh;
	DEFW	0FF01h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0DDFFh;
	DEFW	0FFDFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	055FFh;
	DEFW	05555h;
	DEFW	0FF57h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	000FDh;
	DEFW	00000h;
	DEFW	0FF69h;
	DEFW	0FFFFh;
	DEFW	0FDFFh;
	DEFW	0FF55h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	001F4h;
	DEFW	05055h;
	DEFW	07F6Ah;
	DEFW	0FFFFh;
	DEFW	0F4FFh;
	DEFW	07F00h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	004D0h;
	DEFW	00400h;
	DEFW	09F6Ah;
	DEFW	0FFFFh;
	DEFW	0D0FFh;
	DEFW	01F00h;
	DEFW	0FFFFh;
	DEFW	055FFh;
	DEFW	04455h;
	DEFW	00400h;
	DEFW	0A76Ah;
	DEFW	0FFFFh;
	DEFW	040FFh;
	DEFW	04755h;
	DEFW	0FFFFh;
	DEFW	000FDh;
	DEFW	00400h;
	DEFW	00440h;
	DEFW	0A96Ah;
	DEFW	0FFFFh;
	DEFW	041FFh;
	DEFW	0D1D5h;
	DEFW	0FFFFh;
	DEFW	055F5h;
	DEFW	04455h;
	DEFW	00440h;
	DEFW	0AA6Ah;
	DEFW	0FF7Fh;
	DEFW	047FFh;
	DEFW	0F4D5h;
	DEFW	0FF7Fh;
	DEFW	000D0h;
	DEFW	00400h;
	DEFW	00440h;
	DEFW	0AA1Ah;
	DEFW	0FF9Fh;
	DEFW	047FFh;
	DEFW	0F4D5h;
	DEFW	05515h;
	DEFW	05555h;
	DEFW	04455h;
	DEFW	00400h;
	DEFW	05505h;
	DEFW	0FF57h;
	DEFW	047FFh;
	DEFW	0F4D5h;
	DEFW	05505h;
	DEFW	00000h;
	DEFW	00400h;
	DEFW	00400h;
	DEFW	00000h;
	DEFW	0FF05h;
	DEFW	047FFh;
	DEFW	0F4D5h;
	DEFW	00000h;
	DEFW	00000h;
	DEFW	00400h;
	DEFW	00400h;
	DEFW	00000h;
	DEFW	0FF01h;
	DEFW	047FFh;
	DEFW	0F4D5h;
	DEFW	00000h;
	DEFW	00000h;
	DEFW	00100h;
	DEFW	05055h;
	DEFW	00000h;
	DEFW	0FF05h;
	DEFW	0D1FFh;
	DEFW	0D0D5h;
	DEFW	05515h;
	DEFW	05555h;
	DEFW	00040h;
	DEFW	00000h;
	DEFW	05501h;
	DEFW	0FF57h;
	DEFW	0F4FFh;
	DEFW	04055h;
	DEFW	0FF7Fh;
	DEFW	0FDFFh;
	DEFW	05555h;
	DEFW	05555h;
	DEFW	04155h;
	DEFW	0FF7Fh;
	DEFW	0FDFFh;
	DEFW	00100h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	00054h;
	DEFW	00000h;
	DEFW	04117h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	05755h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	055D5h;
	DEFW	05555h;
	DEFW	0555Fh;
	DEFW	0FF7Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FDFFh;
	DEFW	0FF5Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FF57h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFD5h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFF5h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
CAR_ADR:

;New ZX screen format (NSPEC)
;Converter: bmp sprites (24 bits RGB888) to sjasm
;Rastr format: 2 bits per pixel
;Attribute format: 4 byte attributes (RGB332) per symbol (8x8 pixs)
;Height = 16; Width = 32

CAR0R:
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	03FFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	03FFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	03FFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	03FFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	00FFCh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	04CFCh;
	DEFW	0FF03h;
	DEFW	0FFFFh;
	DEFW	0FCFFh;
	DEFW	00000h;
	DEFW	0FF00h;
	DEFW	0FFFFh;
	DEFW	0F2FFh;
	DEFW	08A8Ah;
	DEFW	03FA1h;
	DEFW	0FFFFh;
	DEFW	0CAFFh;
	DEFW	08A2Ah;
	DEFW	04FA8h;
	DEFW	0FFFFh;
	DEFW	000C0h;
	DEFW	00000h;
	DEFW	05300h;
	DEFW	0FFFFh;
	DEFW	05415h;
	DEFW	04555h;
	DEFW	05354h;
	DEFW	0FCFFh;
	DEFW	00454h;
	DEFW	04555h;
	DEFW	01350h;
	DEFW	0FCFFh;
	DEFW	01151h;
	DEFW	04555h;
	DEFW	04344h;
	DEFW	0FFFFh;
	DEFW	01101h;
	DEFW	04555h;
	DEFW	04344h;
	DEFW	0FFFFh;
	DEFW	010F1h;
	DEFW	00000h;
	DEFW	04F04h;
	DEFW	0FFFFh;
	DEFW	00FFCh;
	DEFW	0FFFFh;
	DEFW	03FF0h;

CAR1R:
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFCh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFCh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFCh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFCh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	03FF0h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	030F1h;
	DEFW	0FF0Fh;
	DEFW	0FFFFh;
	DEFW	0F0FFh;
	DEFW	00000h;
	DEFW	0FF03h;
	DEFW	0FFFFh;
	DEFW	0CAFFh;
	DEFW	02A2Ah;
	DEFW	0FF84h;
	DEFW	0FFFFh;
	DEFW	028FFh;
	DEFW	02AAAh;
	DEFW	03FA1h;
	DEFW	0FFFFh;
	DEFW	00000h;
	DEFW	00000h;
	DEFW	04F01h;
	DEFW	0FCFFh;
	DEFW	05155h;
	DEFW	01555h;
	DEFW	04F51h;
	DEFW	0F1FFh;
	DEFW	01150h;
	DEFW	01555h;
	DEFW	04F40h;
	DEFW	0F1FFh;
	DEFW	00545h;
	DEFW	01555h;
	DEFW	00F14h;
	DEFW	0FCFFh;
	DEFW	04504h;
	DEFW	01555h;
	DEFW	00F11h;
	DEFW	0FFFFh;
	DEFW	040C1h;
	DEFW	00000h;
	DEFW	03F05h;
	DEFW	0FFFFh;
	DEFW	03FF0h;
	DEFW	0FFFFh;
	DEFW	0FFC0h;

CAR2R:
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFF3h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFF3h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFF3h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFF3h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFC0h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0C0C4h;
	DEFW	0FF3Fh;
	DEFW	0FFFFh;
	DEFW	0C0FFh;
	DEFW	00000h;
	DEFW	0FF0Fh;
	DEFW	0FFFFh;
	DEFW	028FFh;
	DEFW	0AAA8h;
	DEFW	0FF13h;
	DEFW	0FFFFh;
	DEFW	0A2FCh;
	DEFW	0AAA8h;
	DEFW	0FF84h;
	DEFW	0FCFFh;
	DEFW	00000h;
	DEFW	00000h;
	DEFW	03F05h;
	DEFW	0F1FFh;
	DEFW	04555h;
	DEFW	05554h;
	DEFW	03F45h;
	DEFW	0C5FFh;
	DEFW	04540h;
	DEFW	05554h;
	DEFW	03F01h;
	DEFW	0C5FFh;
	DEFW	01515h;
	DEFW	05454h;
	DEFW	03F54h;
	DEFW	0F0FFh;
	DEFW	01500h;
	DEFW	05454h;
	DEFW	03F00h;
	DEFW	0FFFFh;
	DEFW	00015h;
	DEFW	00000h;
	DEFW	0FF54h;
	DEFW	0FFFFh;
	DEFW	0FFC0h;
	DEFW	0FFFFh;
	DEFW	0FF03h;

CAR3R:
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFCFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFCFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFCFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFCFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FF03h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	00013h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	000FFh;
	DEFW	00000h;
	DEFW	0FF3Fh;
	DEFW	0FFFFh;
	DEFW	0A2FCh;
	DEFW	0A8A2h;
	DEFW	0FF4Fh;
	DEFW	0FFFFh;
	DEFW	08AF2h;
	DEFW	0AAA2h;
	DEFW	0FF13h;
	DEFW	0F0FFh;
	DEFW	00000h;
	DEFW	00000h;
	DEFW	0FF14h;
	DEFW	0C5FFh;
	DEFW	01555h;
	DEFW	05551h;
	DEFW	0FF14h;
	DEFW	015FFh;
	DEFW	01501h;
	DEFW	05451h;
	DEFW	0FF04h;
	DEFW	014FFh;
	DEFW	05514h;
	DEFW	05051h;
	DEFW	0FF50h;
	DEFW	0C0FFh;
	DEFW	05544h;
	DEFW	05151h;
	DEFW	0FF10h;
	DEFW	0FCFFh;
	DEFW	00050h;
	DEFW	00100h;
	DEFW	0FF43h;
	DEFW	0FFFFh;
	DEFW	0FF03h;
	DEFW	0FCFFh;
	DEFW	0FF0Fh;

CAR4R:
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FF3Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FF3Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FF3Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FF3Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FCFFh;
	DEFW	0FF0Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FCFFh;
	DEFW	0034Ch;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	000FCh;
	DEFW	00000h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	08AF2h;
	DEFW	0A18Ah;
	DEFW	0FF3Fh;
	DEFW	0FFFFh;
	DEFW	02ACAh;
	DEFW	0A88Ah;
	DEFW	0FF4Fh;
	DEFW	0C0FFh;
	DEFW	00000h;
	DEFW	00000h;
	DEFW	0FF53h;
	DEFW	015FFh;
	DEFW	05554h;
	DEFW	05445h;
	DEFW	0FF53h;
	DEFW	054FCh;
	DEFW	05504h;
	DEFW	05045h;
	DEFW	0FF13h;
	DEFW	051FCh;
	DEFW	05511h;
	DEFW	04445h;
	DEFW	0FF43h;
	DEFW	001FFh;
	DEFW	05511h;
	DEFW	04445h;
	DEFW	0FF43h;
	DEFW	0F1FFh;
	DEFW	00010h;
	DEFW	00400h;
	DEFW	0FF4Fh;
	DEFW	0FCFFh;
	DEFW	0FF0Fh;
	DEFW	0F0FFh;
	DEFW	0FF3Fh;

CAR5R:
	DEFW	0FFFFh;
	DEFW	0FCFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FCFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FCFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FCFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0F0FFh;
	DEFW	0FF3Fh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0F1FFh;
	DEFW	00F30h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	000F0h;
	DEFW	00300h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	02ACAh;
	DEFW	0842Ah;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0AA28h;
	DEFW	0A12Ah;
	DEFW	0FF3Fh;
	DEFW	000FFh;
	DEFW	00000h;
	DEFW	00100h;
	DEFW	0FF4Fh;
	DEFW	055FCh;
	DEFW	05551h;
	DEFW	05115h;
	DEFW	0FF4Fh;
	DEFW	050F1h;
	DEFW	05511h;
	DEFW	04015h;
	DEFW	0FF4Fh;
	DEFW	045F1h;
	DEFW	05505h;
	DEFW	01415h;
	DEFW	0FF0Fh;
	DEFW	004FCh;
	DEFW	05545h;
	DEFW	01115h;
	DEFW	0FF0Fh;
	DEFW	0C1FFh;
	DEFW	00040h;
	DEFW	00500h;
	DEFW	0FF3Fh;
	DEFW	0F0FFh;
	DEFW	0FF3Fh;
	DEFW	0C0FFh;
	DEFW	0FFFFh;

CAR6R:
	DEFW	0FFFFh;
	DEFW	0F3FFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0F3FFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0F3FFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0F3FFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0C0FFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0C4FFh;
	DEFW	03FC0h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	000C0h;
	DEFW	00F00h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0A828h;
	DEFW	013AAh;
	DEFW	0FFFFh;
	DEFW	0FCFFh;
	DEFW	0A8A2h;
	DEFW	084AAh;
	DEFW	0FFFFh;
	DEFW	000FCh;
	DEFW	00000h;
	DEFW	00500h;
	DEFW	0FF3Fh;
	DEFW	055F1h;
	DEFW	05445h;
	DEFW	04555h;
	DEFW	0FF3Fh;
	DEFW	040C5h;
	DEFW	05445h;
	DEFW	00155h;
	DEFW	0FF3Fh;
	DEFW	015C5h;
	DEFW	05415h;
	DEFW	05454h;
	DEFW	0FF3Fh;
	DEFW	000F0h;
	DEFW	05415h;
	DEFW	00054h;
	DEFW	0FF3Fh;
	DEFW	015FFh;
	DEFW	00000h;
	DEFW	05400h;
	DEFW	0FFFFh;
	DEFW	0C0FFh;
	DEFW	0FFFFh;
	DEFW	003FFh;
	DEFW	0FFFFh;

CAR7R:
	DEFW	0FFFFh;
	DEFW	0CFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0CFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0CFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0CFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	003FFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	013FFh;
	DEFW	0FF00h;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	00000h;
	DEFW	03F00h;
	DEFW	0FFFFh;
	DEFW	0FCFFh;
	DEFW	0A2A2h;
	DEFW	04FA8h;
	DEFW	0FFFFh;
	DEFW	0F2FFh;
	DEFW	0A28Ah;
	DEFW	013AAh;
	DEFW	0FFFFh;
	DEFW	000F0h;
	DEFW	00000h;
	DEFW	01400h;
	DEFW	0FFFFh;
	DEFW	055C5h;
	DEFW	05115h;
	DEFW	01455h;
	DEFW	0FFFFh;
	DEFW	00115h;
	DEFW	05115h;
	DEFW	00454h;
	DEFW	0FFFFh;
	DEFW	01414h;
	DEFW	05155h;
	DEFW	05050h;
	DEFW	0FFFFh;
	DEFW	044C0h;
	DEFW	05155h;
	DEFW	01051h;
	DEFW	0FFFFh;
	DEFW	050FCh;
	DEFW	00000h;
	DEFW	04301h;
	DEFW	0FFFFh;
	DEFW	003FFh;
	DEFW	0FFFFh;
	DEFW	00FFCh;
	DEFW	0FFFFh;

AMMO_ADR:
;New ZX screen format (NSPEC)
;Converter: bmp sprites (24 bits RGB888) to sjasm
;Rastr format: 2 bits per pixel
;Attribute format: 4 byte attributes (RGB332) per symbol (8x8 pixs)
;Height = 8; Width = 8

AMMO0R:
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFCFh;
	DEFW	0FFFBh;
	DEFW	0FFFDh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
AMMO0A:
	DEFB	0D8h,080h,048h,000h;
	
AMMO1R:
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0CFFFh;
	DEFW	0FBFFh;
	DEFW	0FDFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
	DEFW	0FFFFh;
AMMO1A:
	DEFB	0D8h,080h,048h,000h;

AMMOR_BUF:
	DEFS	16
	
AMMOA_BUF:
	DEFS	4
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	PAGE #00

	SAVESNA "helicop.sna",START
	ENDMODULE
	