	org	0100h

SPT	equ	63
	
idedat	EQU	0E8H	; IDE DATA REGISTER (LOW)
			; HIGH IS LATCHED INTO E4H ON READ
			; E4H MUST CONTAIN HIGH DATA ON WRITE
ideerr	EQU	0E9H	; IDE ERROR REGISTER
idesc	EQU	0EAH	; IDE SECTOR COUNT REGISTER
idest	EQU	0EBH	; IDE START SECTOR REGISTER
idecyll	EQU	0ECH	; IDE CYLINDER LOW REGISTER
idecylh	EQU	0EDH	; IDE CYLINDER HIGH REGISTER
idehead	EQU	0EEH	; IDE HEAD REGISTER
idecmd	EQU	0EFH	; IDE COMMAND REGISTER
idestat	EQU	0EFH	; IDE STATUS REGISTER
idehi	EQU	0E4H	; IDE HIGH BYTE REGISTER

	lxi	sp,stack
	mvi	c,0		; Sector
	lxi	d,1		; Track
wloop	inr	c
	push	b
	push	d
	call	hdwrite
	pop	d
	pop	b
	mvi	a, SPT
	cmp	c
	jnz	wloop
	mvi	c,0
	inx	d
	xra	a		; Erase first 256 tracks
	ora	e
	jnz	wloop
	hlt

	; Send the C/H/S address to the drive
	
hdwrite	in	idestat		; get status of drive
	xri	040h		; invert ready bit
	ani	0c0h		; mask bsy and ready
	jnz	hdwrite
	
	mov	a,c
	out	idest		; Write sector
	mvi	a,0A0h		; IDE requirement
	out	idehead		; Write head (always 0)
	mov	a,e		; Write low cylinder

	out	idecyll
	mov	a,d
	ani	3		; Mask through two lowest bits
	out	idecylh
	mvi	a, 1		; 1 sector to transfer
	out	idesc
	
	mvi	a, 030h		; write to hard drive
	out	idecmd
wdrq	in	idestat		; get status
	mov	c, a
	ani	1
	jnz	rwerr		; jump on error flag
	mov	a, c
	ani	8
	jz	wdrq		; wait for drq
	mvi	b, 0		; transfer 256 words (512 bytes)
	mvi	a, 0E5h		; Erased byte
	out	idehi		; send high byte
writel	out	idedat		; send low byte
	dcr	b
	jnz	writel		; loop
	in	idestat		; get error flag
	ani	1		; error flag
	rz
rwerr	in	ideerr		; return with non-zero in a on error
	ret
	
	ds	32
stack	equ	$
	