	org	0100h

cpm	equ	0DC00h
bsect	equ	07C00h
	
idedat	EQU	0E8H	; IDE DATA REGISTER (LOW)
			; HIGH IS LATCHED INTO E4H ON READ
			; E4H MUST CONTAIN HIGH DATA ON WRITE
ideerr	EQU	0E9H	; IDE ERROR REGISTER
idesc	EQU	0EAH	; IDE SECTOR COUNT REGISTER
idest	EQU	0EBH	; IDE START SECTOR REGISTER
idecyll	EQU	0ECH	; IDE CYLINDER LOW REGISTER
idecylh	EQU	0EDH	; IDE CYLINDER HIGH REGISTER
idehead	EQU	0EEH	; IDE HEAD REGISTER
idecmd	EQU	0EFH	; IDE COMMAND REGISTER
idestat	EQU	0EFH	; IDE STATUS REGISTER
idehi	EQU	0E4H	; IDE HIGH BYTE REGISTER

	lxi	sp,stack
	lxi	h,bsect		; Write boot sector
	mvi	c,1		; Sector 1
	lxi	d,0		; Track 0
	call	hdwrite
	
	lxi	h,cpm		; Point at CP/M address
	mvi	c,1		; Sector (skip over boot sector)
	mvi	b,14		; Write 13 sectors
rloop	inr	c
	push	b
	call	hdwrite
	pop	b
	dcr	b
	jz	bye		; Jump to cold start when loaded
	jmp	rloop
	
bye	hlt
	
hdwrite
hdready	in	idestat		; get status of drive
	xri	040h		; invert ready bit
	ani	0c0h		; mask bsy and ready
	jnz	hdready

	mov	a,c
	out	idest		; Write sector
	mvi	a,0A0h		; IDE requirement
	out	idehead		; Write head (always 0)
	mvi	a,0		; Write low cylinder
	out	idecyll
	mvi	a,0
	out	idecylh
	mvi	a,1		; 1 sector to transfer
	out	idesc
	
	; send command, wait for drq to go active
	mvi	a, 030h		; write sector command
	out	idecmd
	mvi	b, 0		; transfer 256 words (512 bytes)
wdrq	in	idestat		; get status
	ani	8
	jz	wdrq		; wait for drq
writel	mov	c, m		; get low byte
	inx	h
	mov	a, m		; get high byte
	inx	h
	out	idehi		; send high
	mov	a, c
	out	idedat		; send low
	dcr	b
	jnz	writel		; loop
	in	idestat		; get error flag
	ani	1		; error flag
	ret
	
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
stack	
