bsect	equ	07C00h	;boot sector loading address

cpm	equ	0DC00h	;cpm ccp base
cold	equ	0F200h	;cpm bios base
	
idedat	EQU	0E8H	; IDE DATA REGISTER (LOW)
			; HIGH IS LATCHED INTO E4H ON READ
			; E4H MUST CONTAIN HIGH DATA ON WRITE
ideerr	EQU	0E9H	; IDE ERROR REGISTER
idesc	EQU	0EAH	; IDE SECTOR COUNT REGISTER
idest	EQU	0EBH	; IDE START SECTOR REGISTER
idecyll	EQU	0ECH	; IDE CYLINDER LOW REGISTER
idecylh	EQU	0EDH	; IDE CYLINDER HIGH REGISTER
idehead	EQU	0EEH	; IDE HEAD REGISTER
idecmd	EQU	0EFH	; IDE COMMAND REGISTER
idestat	EQU	0EFH	; IDE STATUS REGISTER
idehi	EQU	0E4H	; IDE HIGH BYTE REGISTER

	ORG	bsect

begin	lxi	sp,stack
	lxi	h,cpm		; Point at CP/M address
	mvi	c,1		; Sector (skip over boot sector)
	mvi	b,15		; Load 14 sectors
rloop	inr	c
	push	b
	call	hdread
	pop	b
	jnz	begin		; Retry on error (infinitely!)
	dcr	b
	jnz	rloop
	
	jmp	cold		; Jump to cold start when loaded
	
hdread
hdready	in	idestat		; get status of drive
	xri	040h		; invert ready bit
	ani	0c0h		; mask bsy and ready
	jnz	hdready

	mov	a,c
	out	idest		; Write sector
	mvi	a,0A0h		; IDE requirement
	out	idehead		; Write head (always 0)
	mvi	a,0		; Write low cylinder
	out	idecyll
	mvi	a,0
	out	idecylh
	mvi	a, 1		; 1 sector to transfer
	out	idesc


	mvi	a, 020h		; read hard drive
	out	idecmd
	mvi	b, 0		; count 256 times in b
rdrq	in	idestat		; get status
	ani	8
	jz	rdrq		; wait for drq to go active
readl	in	idedat		; Get low byte
	mov	m, a
	inx	h	
	in	idehi		; get high byte
	mov	m, a
	inx	h
	dcr	b		; Count in b
	jnz	readl
	in	idestat
	ani	1
	rz
rwerr	in	ideerr		; return with non-zero in a on error
	ret
	
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
stack	
	ORG	bsect+511		;fill 00 unused sector space
	db	0

	end