-- PS2SIMPL.vhd
-- ---------------------------------------------
-- Simplest PS/2 application
-- ---------------------------------------------
-- (c) ALSE - http://www.alse-fr.com

LIBRARY ieee;
  USE ieee.std_logic_1164.ALL;

-- ---------------------------------------------
    Entity PS2SIMPL is
-- ---------------------------------------------
      Port (     Clk : In  std_logic;
               Reset : In  std_logic;
             D7SEG_L : Out std_logic_vector (1 to 7);
             D7SEG_H : Out std_logic_vector (1 to 7);
            PS2_Data : In  std_logic;
             PS2_Clk : In  std_logic;
                nLED : Out std_logic );
end PS2SIMPL;

-- ---------------------------------------------
    Architecture SCHEMATIC of PS2SIMPL is
-- ---------------------------------------------
  component SEVENSEG
     Port (    Data : In    STD_LOGIC_VECTOR (3 downto 0);
                Pol : In    STD_LOGIC;
             Segout : Out   STD_LOGIC_VECTOR (1 to 7) );
  end component;
  component PS2_CTRL
  Generic ( FILTERSIZE : POSITIVE := 8 );
     Port (     Clk : In    STD_LOGIC;
             DoRead : In    STD_LOGIC;
            PS2_Clk : In    STD_LOGIC;
            PS2_Data : In    STD_LOGIC;
              Reset : In    STD_LOGIC;
            Scan_Code : Out   STD_LOGIC_VECTOR (7 downto 0);
            Scan_DAV : Out   STD_LOGIC;
            Scan_Err : Out   STD_LOGIC );
  end component;

  signal Gnd    : std_logic;
  signal Vcc    : std_logic;
  signal LED    : std_logic;
  signal DoRead : std_logic;
  signal Code   : std_logic_vector (7 downto 0);

begin
  Gnd <= '0';
  Vcc <= '1';

  PS2_CTRL_i : PS2_CTRL
    Generic Map ( FILTERSIZE => 2 )
    Port Map ( Clk=>Clk, Reset=>Reset, DoRead=>DoRead,
               PS2_Clk=>PS2_Clk, PS2_Data=>PS2_Data,
                Scan_Code=>Code, Scan_DAV=>DoRead, Scan_Err=>LED );

  -- Note: use Pol=>Gnd if display is active high type.
  Dec7SegL : SEVENSEG
     Port Map ( Data(3 downto 0)=>Code(3 downto 0), Pol=>Gnd,
                Segout(1 to 7)=>D7SEG_L(1 to 7) );

  Dec7SegH : SEVENSEG
     Port Map ( Data(3 downto 0)=>Code(7 downto 4), Pol=>Gnd,
                Segout(1 to 7)=>D7SEG_H(1 to 7) );

  nLED <= not LED; -- Note: remove the "not" if nLED is active high

end SCHEMATIC;
