puts ""
puts " Synthesis script for Leonardo Spectrum. (c) ALSE. http://www.alse-fr.com "
puts ""

# Very simple script for Leonardo Spectrum, (c) ALSE.
# Author : Bert Cuzeau
# Here, we target # a Xilinx XC4010XLpc84

# From Leonardo, simply use "File > Run Script" command.

# Global Clock timing constraints (12.5 MHz)
set register2register 80.0
set input2register 80.0
set register2output 80.0
set input2output 80.0

set synthdir [pwd]
set srcdir [file join ${synthdir} ..]
set fitdir $synthdir

_gc_read_init
_gc_run_init

set input_file_list "${srcdir}/sevenseg.vhd
                     ${srcdir}/ps2_ctrl.vhd
                     ${fitdir}/ps2simpl.vhd "

set module ps2simpl
set wire_table 4010xl-3_avg
set chip TRUE
set macro FALSE
set optimize_for area
set -hierarchy auto
set maxdelay 0
set hierarchy_auto TRUE
set hierarchy_preserve FALSE
set hierarchy_flatten FALSE
set report brief
set edif_write_arrays TRUE

set output_file "${fitdir}/PS2simpl.edf"

set novendor_constraint_file FALSE
set part 4010xlPC84
set process 3
set pack_clbs FALSE
set target xi4xl

_gc_read
_gc_run

