	DEVICE	ZXSPECTRUM48

; PCB ReVerSE U8EP3C POST v0.1 (build 20130506)
; IP Core v0.1 (build 20130506)

; v0.1.1	2013-05-06
; v0.1.0	2013-05-04	 

;  :
; A15 A14 A13
; 0   0   0	0000-07FF ( 8192) ROM
; 0   0   1	2000-32BF ( 4800)   (, , ...)
; 0   0   1	32C0-3FFF ( 3392) RAM
; 0   1   x	4000-7FFF (16384)  
; 1   x   x	8000-FFFF (32768)  SRAM (0..15)

; A15 A14 A14 A13 A12 A11 A10 A9 A8 | A7 A6 A5 A4 A3 A2 A1 A0
; x   x   x   x   x   x   x   x  x    x  x  x  x  x  x  x  0	#FE	R/W:b3..0   SRAM,    32  (  #8000)
; x   x   x   x   x   x   x   x  x    x  x  x  x  x  x  0  x	#FD	R:	b7..0  Soft-Core
; x   x   x   x   x   x   x   x  x    x  x  x  x  x  0  x  x	#FB	W:	mult_data1,	R:	mult_result(7..0) 	Mult Result = mult_data1*mault_data2
; x   x   x   x   x   x   x   x  x    x  x  x  x  0  x  x  x	#F7	W:	mult_data2,	R:	mult_result(15..8)
; x   x   x   x   x   x   x   x  x    x  x  x  0  x  x  x  x	#EF W/R:uart_data(7..0)
; x   x   x   x   x   x   x   x  x    x  x  0  x  x  x  x  x	#DF	R:	b7= uart_tx_busy, b6= CBUS4, b5..2= 1111, b1= uart_rx_error, b0= uart_rx_avail
; x   x   x   x   x   x   x   x  x    x  0  x  x  x  x  x  x	#BF
; x   x   x   x   x   x   x   x  x    0  x  x  x  x  x  x  x	#7F

buffer_txt		EQU #2000
print_color		EQU #3300
sram_page		EQU #3301
print_addr		EQU #3302
dram_page		EQU #3304

port_page		EQU #fe
port_ver		EQU #fd
port_mult1		EQU #fb
port_mult2		EQU #f7
port_uart_data		EQU #ef
port_uart_status	EQU #df

;--------------------------------------
; Reset
		ORG #0000
StartProg:
		di
		jp Test
;--------------------------------------
; INT
		ORG #0038
Int
		reti
;--------------------------------------
; NMI
		ORG #0066
Nmi
		retn
;--------------------------------------
Test
		ld sp,#4000

		call Cls
		ld de,str01
		ld hl,buffer_txt
		call PrintStr
		
		in a,(port_ver)
		ld hl,buffer_txt+56*2
		call ByteToHexStr

		ld de,str14
		ld hl,buffer_txt+160*1
		call PrintStr

;--------------------------------------
;  
TestSram	ld de,str02
		ld hl,buffer_txt+160*2
		call PrintStr

		xor a
		ld hl,buffer_txt+160*2+38*2

testSramNext	out (port_page),a
		ld (sram_page),a
		ld (print_addr),hl

		ld hl,#8000
		ld b,h
		ld c,l

		call TestMem
		jr nz,testSramError

		ld hl,(print_addr)
		ld (hl),251
		inc hl
		inc hl
		
		ld a,(sram_page)
		inc a
		cp 16
		jr nz,testSramNext

		ld de,str05		; "OK."
		ld hl,buffer_txt+160*2+56*2
		call PrintStr

		jr TestDram
;--------------------------------------
testSramError	ld d,a
		push de
		push hl

		ld de,str15		; "Error."
		ld hl,buffer_txt+160*2+56*2
		call PrintStr

		ld de,str04		; "ERROR:"
		ld hl,buffer_txt+160*3
		call PrintStr

		pop de
		ld a,(sram_page)
		rrca
		rrca
		ld c,a
		and %00111111
		ld hl,buffer_txt+160*3+15*2
		call ByteToHexStr
		ld a,c
		and %11000000
		ld c,a
		ld a,d
		and %00111111
		or c
		call ByteToHexStr
		ld a,e
		call ByteToHexStr
		
		pop de
		ld a,d
		ld hl,buffer_txt+160*3+32*2
		call ByteToBitStr
		ld a,e
		ld hl,buffer_txt+160*3+48*2
		call ByteToBitStr
;--------------------------------------
TestDram	ld de,str03
		ld hl,buffer_txt+160*4
		call PrintStr

		ld de,#0000
		ld hl,buffer_txt+160*4+38*2

testDramNext	ld a,e
		out (port_ver),a
		ld a,d
		out (port_mult1),a
		ld (dram_page),de
		ld (print_addr),hl

		ld hl,#4000
		ld b,h
		ld c,l
		call TestMem
		jr nz,testDramError

		ld hl,(print_addr)
		ld (hl),251
		inc hl
		inc hl
		
		ld de,(dram_page)
		inc de
		ld a,d
		cp #04
		jr nc,testDramNext

		ld de,str05		; "OK."
		ld hl,buffer_txt+160*4+56*2
		call PrintStr

		jr TestRTC		
;--------------------------------------
testDramError	ld d,a
		push de
		push hl

		ld de,str15		; "Error."
		ld hl,buffer_txt+160*4+56*2
		call PrintStr

		ld de,str04		; "ERROR:"
		ld hl,buffer_txt+160*5
		call PrintStr

		pop de
		ld bc,(dram_page)
		srl b
		rr c
		rl d
		rrc d

		ld a,b
		ld hl,buffer_txt+160*5+15*2
		call ByteToHexStr
		ld a,c
		call ByteToHexStr
		ld a,d
		call ByteToHexStr
		ld a,e
		call ByteToHexStr
		
		pop de
		ld a,d
		ld hl,buffer_txt+160*5+32*2
		call ByteToBitStr
		ld a,e
		ld hl,buffer_txt+160*5+48*2
		call ByteToBitStr
;--------------------------------------
TestRTC
TestMult
		ld a,#ff		
		out (port_mult1),a
		ld a,#fe
		out (port_mult2),a
		ld de,str16
		ld hl,buffer_txt+160*7
		call PrintStr
		
		in a,(port_mult2)
;		ld a,#02
		ld hl,buffer_txt+160*7+20*2
		call ByteToHexStr
		in a,(port_mult1)
;		ld a,#03
		ld hl,buffer_txt+160*7+22*2
		call ByteToHexStr
;--------------------------------------
TestUART
		ld de,str08			; "Test USB-UART (FT232R):"
		ld hl,buffer_txt+160*8
		call PrintStr

		LD HL,str_test1
		CALL TX_STR
		
		ld de,str17			; "No Conect"
		jr c,testUart1
		ld de,str05			; "OK"
testUart1
		ld hl,buffer_txt+160*8+23*2
		call PrintStr
		halt



;======================================	













;--------------------------------------
;    	
;--------------------------------------
Cls		ld de,#0720
		ld bc,#0960
		ld hl,#2000
cls1		ld (hl),e
		inc hl
		ld (hl),d
		inc hl
		dec bc
		ld a,c
		or b
		jr nz,cls1
		ret

;--------------------------------------
; 
;--------------------------------------
PrintStr	ld a,(print_color)
printStr2	ld c,a
printStr3	ld a,(de)
		or a
		ret z
		inc de
		cp #01
		jr z,printStr1
		ld (hl),a
		inc hl
		ld (hl),c
		inc hl
		jr printStr3
printStr1	ld a,(de)
		ld (print_color),a
		inc de
		jr printStr2
	
;--------------------------------------
;  	
;--------------------------------------
TestMem		xor a
		ld (hl),a
		ld e,(hl)
		cp e
		ret nz
		cpl
		ld (hl),a
		ld e,(hl)
		cp e
		ret nz
		ld a,%01010101
		ld (hl),a
		ld e,(hl)
		cp e
		ret nz
		cpl
		ld (hl),a
		ld e,(hl)
		cp e
		ret nz
testMemNext	inc hl
		dec bc
		ld a,b
		or c
		jr nz,TestMem
		ret

;--------------------------------------
; Byte to BIN string
;--------------------------------------
; A  = byte
; HL = buffer (8 bytes)
ByteToBitStr	ld b,8
byteToBitStr2	rlca
		jr nc,byteToBitStr1
		ld (hl),#31
		inc hl
		inc hl
		djnz byteToBitStr2
		ret
byteToBitStr1	ld (hl),#30
		inc hl
		inc hl
		djnz byteToBitStr2
		ret

;--------------------------------------
; Byte to HEX string
;--------------------------------------
; A  = byte
; HL = buffer
ByteToHexStr	ld b,a
		rrca
		rrca
		rrca
		rrca
		and #0f
		add a,#90
		daa
		adc a,#40
		daa
		ld (hl),a
		inc hl
		inc hl
		ld a,b
		and #0f
		add a,#90
		daa
		adc a,#40
		daa
		ld (hl),a
		inc hl
		inc hl
		ret

;--------------------------------------
; UART 
;--------------------------------------
; Ports:
; DATA		W/R
; STATUS	R: bit7=uart_tx_busy, bit6=CBUS4, bit1=uart_rx_error, bit1=uart_rx_avail

; HL=STRING, #00 = END STRING

TX_IF		RLCA
		RET C		; FT232R NO CONNECT TO HOST!
TX_STR		IN A,(port_uart_status)
		RLCA
		JR C,TX_IF	; CY=1 :BUFFER FULL, WAIT...
		LD A,(HL)
		OR A
		RET Z		; Z=0 :END STRING
		INC HL
		OUT (port_uart_data),A
		JR TX_STR



; 
; b2..0 = ink
; b5..3 = paper
; b6	= bright
; b7	= -

;				 00000000001111111111222222222233333333334444444444555555555566666666667777777777	
;				 01234567890123456789012345678901234567890123456789012345678901234567890123456789
str01		db 1,%00111000,	"                      REVERSE U8EP3C DEVBOARD TEST v0.1.00                      ",0
str02		db 1,%00000111,	"Test SRAM (CY7C1049DV33-10ZSX) 512KB [0123456789ABCDEF]",0
str03		db 1,%00000111,	"Test SDRAM (MT48LC32M8A2TG-75)  32MB [0123456789ABCDEF]",0
str04		db 1,%01000010,	"ERROR: Address 00000000h (Write 00000000b, Read 00000000b)",0
str05		db 1,%00000100,	"OK",0
str06		db 1,%00000111,	"Test RTC (PCF8583):",0
str07		db 1,%00000111,	"Test FLASH (M25P40):",0
str08		db 1,%00000111,	"Test USB-UART (FT232R):",0
str09		db 1,%00000111,	"Test SD/MMC:",0
str10		db 1,%00000111,	"Test PS/2 Mouse:",0
str11		db 1,%00000111,	"Test PS/2 Keyboard:",0
str12		db 1,%00000111,	"Test Audio Codec (VS1053B):",0
str13		db 1,%00000110,	"Passed",0
str14		db 1,%00000111,	"Processor: NextZ80v1 @ 35MHz",0
str15		db 1,%01000010, "ERROR",0
str16		db 1,%00000111, "Test Mult (FEh*FFh)=    h",0
str17		db 1,%01000110, "No Conect",0

str_test1	db #0D,#0A
		db #0D,#0A,"PCB U8EP3C"
		db #0D,#0A,"POST version 0.1 (build 20130506)",0


	savebin "rom.bin",StartProg, 8192