msbt
	ds	14
spbt
	ds	2
	db	42,6,0

cntbit
	ds	1
cntbyt
	ds	2
shfbit
	ds	1
shfbyt
	ds	2
counter
	ds	2*20
shifter
	ds	2*20
; machine state after test
msat
	ds	14	; memop,iy,ix,hl,de,bc,af
spat
	ds	2	; stack pointer after test
flgsat =spat-2	; flags

spsav
	ds	2	; saved stack pointer
crcval
	ds	4
; test harness
test
	push	af
	push	bc
	push	de
	push	hl
      if	0
	ld	hl,crlf
	call	print_str
	ld	hl,iut
	ld	b,4
	call	hexstr
	ld	a,' '
	call print_char
	ld	b,16
	ld	hl,msbt
	call	hexstr
      endif
	di			; disable interrupts
	ld	(spsav),sp	; save stack pointer
	ld	sp,msbt+2	; point to test-case machine state
	pop	iy		; and load all regs
	pop	ix
	pop	hl
	pop	de
	pop	bc
	pop	af
	ld	sp,(spbt)
iut
	ds	4		; max 4 byte instruction under test
	ld	(spat),sp	; save stack pointer
	ld	sp,spat
	push	af		; save other registers
	push	bc
	push	de
	push	hl
	push	ix
	push	iy
	ld	sp,(spsav)	; restore stack pointer
	ei			; enable interrupts
	ld	hl,(msbt)	; copy memory operand
	ld	(msat),hl
	ld	hl,flgsat	; flags after test
	ld	a,(hl)
flgmsk
	and	0d7h		; mask-out irrelevant bits (self-modified code!)
	ld	(hl),a
	ld	b,16		; total of 16 bytes of state
	ld	de,msat
	ld	hl,crcval
tcrc
	ld	a,(de)
	inc	de
	call	updcrc		; accumulate crc of this test case
	dec	b
	jp	nz,tcrc
      if	0
	ld	a,' '
	call	print_char
	ld	de,crcval
	call	phex8
	ld	hl,crlf
	call	print_str
	ld	hl,msat
	ld	b,16
	call	hexstr
	ld	hl,crlf
	call	print_str
      endif
	pop	hl
	pop	de
	pop	bc
	pop	af
	ret