	output rom0.bin

	display "Size of ROM is: ",/a,endpp

	MACRO PORG addr
		IF $ < addr
		BLOCK addr-$
		ENDIF
		ORG addr
	ENDM

endprog			=	$4000
video_ram		=	$2800
vr					=	video_ram / 2
page_port		= $fe
config			= $fd
mult1				= $fb
mult2				= $f7
vaddr_low		=	$bf
vaddr_high	=	$7f

	PORG	0
	jp	reset

	PORG $38
	reti

pr_param
	ds 3

	PORG $66
	retn

	PORG $f3
zexall

	include "zexall_core.asm"

	include "print_u8.asm"

reset
	di
	ld	sp,video_ram-2
	ld a,low video_ram / 2
	out (vaddr_low),a
	ld a,high video_ram / 2
	out (vaddr_high),a
	call cls
	ld hl,str1
	call print_str
	in a,(config)
	ld c,a
	and $F0
	rrca
	rrca
	rrca
	rrca
	call print_hex
	ld hl,str2
	call print_str
	ld a,c
	and $0f
	call print_hex
	ld	hl,msg1
	call print_str
	ld hl,str3
	call print_str
	call zexall

;	ld hl,clear_w
;	call print_str

endpp
	jp endpp


str1
	db 23,0,0,17,7,"u8_test ver.",17,5,0
str2
	db 17,7," rev.",17,5,0
str3
	db 17,$47,"X80 CPU softcore - 40 MHz",17,7,13,13,0
clear_w
	dup 27
	db 13
	edup
	db 0

msg1
	db	23,0,1,17,7,"Z80 instruction exerciser for ",17,$46,"Reverse",17,7," u8 board",13,0
msg2
	db	13,"Tests complete",0
okmsg
	db	17,4," OK",17,7,13,0
ermsg1
	db	13,17,2,"CRC: ",17,7,0
ermsg2
	db	",expected: ",0
crlf
	db	13,0

	block endprog-$