/*  This file is part of UKNCBTL.
    UKNCBTL is free software: you can redistribute it and/or modify it under the terms
of the GNU Lesser General Public License as published by the Free Software Foundation,
either version 3 of the License, or (at your option) any later version.
    UKNCBTL is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU Lesser General Public License for more details.
    You should have received a copy of the GNU Lesser General Public License along with
UKNCBTL. If not, see <http://www.gnu.org/licenses/>. */

#define _CRT_SECURE_NO_WARNINGS

#include "ESCParser.h"
#include <windows.h>
#include <iostream>
#include <fstream>
#include <stdio.h>


//////////////////////////////////////////////////////////////////////
// Globals

const char* g_InputFileName = 0;
OutputDriver* g_pOutputDriver = 0;

//////////////////////////////////////////////////////////////////////

bool ParseCommandLine (int argc, char* argv[])
{
    for (int argn = 1; argn < argc; argn++)
    {
        const char* arg = argv[argn];
        if (arg[0] == '-' || arg[0] == '/')
        {
        }
        else
        {
            if (g_InputFileName == 0)
                g_InputFileName = arg;
        }
    }

    // Parsed options validation
    if (g_InputFileName == 0)
    {
        std::cerr << "Input file is not specified. printer.log used" << std::endl;
		g_InputFileName = "printer.log";
    }
    return true;
}


void main (int argc, char* argv[])
{
    std::cerr << "ESCParser utility based on Nikita Zimin code " << __DATE__ << " " << __TIME__ << std::endl;

    ParseCommandLine(argc, argv);
    g_pOutputDriver = new OutputDriverPdf(std::cout);	

    // First run: calculate total page count
    int pagestotal = 1;
    {
        // Prepare the input stream
        std::ifstream input(g_InputFileName, std::ifstream::in | std::ifstream::binary);
        if (input.fail())
        {
            std::cerr << "Failed to open the input file." << std::endl;
            return;
        }

        // Prepare stub driver
        OutputDriverStub driverstub(std::cout);

        // Run the interpreter to count the pages
        EscInterpreter intrpr1(input, driverstub);
        while (true)
        {
            if (!intrpr1.InterpretNext())
            {
                if (intrpr1.IsEndOfFile())
                    break;
                pagestotal++;
            }
        }
    }
    std::cerr << "Pages total: " << pagestotal << std::endl;

    // Second run: output the pages
    {
        // Prepare the input stream
        std::ifstream input(g_InputFileName, std::ifstream::in | std::ifstream::binary);
        if (input.fail())
        {
            std::cerr << "Failed to open the input file." << std::endl;
            return;
        }

        // Prepare the output driver
        g_pOutputDriver->WriteBeginning(pagestotal);
        int pageno = 1;
        std::cerr << "Page " << pageno << std::endl;
        g_pOutputDriver->WritePageBeginning(pageno);

        // Initialize the interpreter
        EscInterpreter intrpr(input, *g_pOutputDriver);

        // Run the interpreter to produce the pages
        while (true)
        {
            if (!intrpr.InterpretNext())
            {
                g_pOutputDriver->WritePageEnding();

                if (intrpr.IsEndOfFile())
                    break;

                pageno++;
                std::cerr << "Page " << pageno << std::endl;

                g_pOutputDriver->WritePageBeginning(pageno);
            }
        }

        g_pOutputDriver->WriteEnding();
    }

    // Cleanup
    delete g_pOutputDriver;
    g_pOutputDriver = 0;
}


//////////////////////////////////////////////////////////////////////
