	prompt 		equ 	0F86Ch
	clr_scr		equ	0FACEh
	wait_any_key	equ	0xF803  ; ожидание нажатия клавиши

	screenlc equ 077D0h 	; фиксируем левый верхний угол видеопамяти
	screenh equ 25 		; высота видимой области
	screenw equ 64 		; ширина видимой области
	h_offset equ 3Eh 	; межстрочный сдвиг

	scr_addr: dw 0000h

	org 0033h 		; старт сразу после системных 030h-032h

	lxi HL, screenlc	; задаём верхний угол картинки в HL для последующей передачи в указатель
	mvi A, 0Fh		; счётчик количества изображений
	;__________________________________________________________________
	; старт процедуры отрисовки картинки

once_again:
	push H
	shld scr_addr		; задать начальную точку в указателе scr_addr

	lxi BC, 1004h		; задать в BC размер картинки
	lxi HL, pic		; загрузили в HL адрес старта картинки

	call draw_pic		; процедура отрисовки картинки

	pop H			; сдвигаем начальное знакоместо на 1
	inx H
	dcr A
	jnz once_again

	call wait_any_key
	jmp prompt
	;-----------------------------------------------------------------

;_________________________________________________________________________
; процедура отрисовки картинки расположенной по адресу pic, размером BC
draw_pic:
	push PSW
	push D

	mov A, C		; загрузили в A длину строки в байтах
	add A			; умножаем А на 2, чтобы счётчик ходил через строку
				; так как одна строка псевдографики задаётся двумя строками байт

next_pic_str:	
	push PSW		; старт обхода одной строки
	push H
	
	mov A, C

get_next_byte:
	mov D, M		; записываем в D байт с адреса HL
	call d_pair_wr		; записываем в E пару для D

	; рисуем DE		
	push H
	lhld scr_addr		; вытаскиваем указатель на адрес видеопамяти из scr_addr

	call draw_byte_pair

	inx H			; двигаем указатель на байт вправо
	shld scr_addr
	pop H

	inx H
	dcr A
	jnz get_next_byte
	
	call scr_addr_next_line ; теперь надо указатель видеопамяти сдвинуть на строку вниз

	pop H
	pop PSW			; финиш обхода одной строки

	

	call pic_point_ns	; сдвигаем указатель на следующую строку псевдографики
	dcr B			; вычитаем строку из B
	jnz next_pic_str	; если строка не последняя, то продолжить чтение строк

	pop D
	pop PSW
	ret
;-------------------------------------------------------------------

write_dbg_info:
	push H
	push B
	push A
	
	lhld scr_addr
	mov B, H
	mov C, L

	lhld dbg_addr
	mov M, B
	inx H
	mov M, C
	inx H
	shld dbg_addr

	lxi HL, dbg_cnt
	mov A, M
	dcr A
	jz dbg_bp
	mov M, A
	
	pop A
	pop B
	pop H
	ret

dbg_bp:
	mov A, B
	ret

;___________________________________________________________________
; процедура сдвига адреса видеопамяти на строку вниз
scr_addr_next_line:
	push PSW
	push H

	mvi A, h_offset
	lhld scr_addr
sa_next:
	inx H	
	dcr A
	jnz sa_next

	shld scr_addr

	pop H
	pop PSW
	ret
;-------------------------------------------------------------------

;___________________________________________________________________
; процедура вычисления пары для байта в регистре D, 
; для этого требуется сдвинуть указатель адреса HL на длину строки 

d_pair_wr:
	push PSW
	push H
	mov A, C

dpwr_next_byte:	
	inx H
	dcr A
	jnz dpwr_next_byte
	
	mov E, M

	pop H
	pop PSW
	ret
;------------------------------------------------------------------

;___________________________________________________________________
; процедура сдвига указателя НL на следующую строку псевдографики

pic_point_ns:			
	push B
	mov B, A

ppns_inc:
	inx H
	dcr A
	jnz ppns_inc

	mov A, B
	pop B
	ret
;------------------------------------------------------------------

	; эта процедура пока неактивна
draw_line: 			; закидываем в __ адрес старта картинки с первым байтом-длиной строки
	push B
	push H
	lxi HL, pic
	mov B, M

	pop H
	pop B
	ret

draw_byte_pair: 		; загрузить в DE пару соседних байт изображения
				; загрузить в HL координаты
	push B
	push PSW

	push H

	mov A, D
	mvi B, 0F0h
	ana B
	mov B, A 		; посчитали верх первого байта

	mov A, E
	mvi C, 0F0h
	ana C
	rrc
	rrc
	rrc
	rrc
	mov C, A 		; посчитали низ первого байта
	ora B 			; сделали из них один байт, готовый для дешифровки
	mov H, A

	mov A, D
	mvi B, 00Fh
	ana B
	rrc
	rrc
	rrc
	rrc
	mov B, A 		; посчитали верх второго байта

	mov A, E
	mvi C, 00Fh
	ana C
	mov C, A 		; посчитали низ второго байта
	ora B 			; сделали из них второй байт, готовый для дешифровки
	mov L, A

	xchg
	pop H 			; не забыть вернуть из стека адрес видеопамяти 
				; HL после записи его в DE

	mov B, D 		; сохраняем оба байта DE в BC
	mov C, E


				; раскодируем и печатаем первый байт

	mov E, D 		; загружаем в E первый байт
	call byte_to_pix 	; на выходе должны получить в DE два байта для отрисовки

	mov A, D 		; грузим в A закодированный символ (пример)
	call pix_to_sym 	; загрузить в A закодированный символ знакоместа
	mov M, A 		; pix_to_sym вернёт в A раскодированный символ, его и печатаем

	inx H

	mov A, E 		; грузим в A закодированный символ (пример)
	call pix_to_sym 	; загрузить в A закодированный символ знакоместа
	mov M, A 		; pix_to_sym вернёт в A раскодированный символ, его и печатаем

				; раскодируем и печатаем второй байт

	inx H

	mov E, C 		; загружаем в E первый байт
	call byte_to_pix 	; на выходе должны получить в DE два байта для отрисовки

	mov A, D 		; грузим в A закодированный символ (пример)
	call pix_to_sym 	; загрузить в A закодированный символ знакоместа
	mov M, A 		; pix_to_sym вернёт в A раскодированный символ, его и печатаем

	inx H

	mov A, E 		; грузим в A закодированный символ (пример)
	call pix_to_sym 	; загрузить в A закодированный символ знакоместа
	mov M, A 		; pix_to_sym вернёт в A раскодированный символ, его и печатаем

	pop PSW
	pop B
	ret


byte_to_pix: 			; загрузить в E 8 бит точек в двух знакоместах
	push PSW 		; друг над другом и получить в DE два байта
				; закодированных символов 
	mov A, E
	mvi D, 0CCh
	ana D
	mov D, A

	mov A, E
	mvi E, 33h
	ana E
	rlc
	rlc
	mov E, A

	pop PSW
	ret

pix_to_sym: 			; загрузить в A закодированный символ знакоместа
	cpi 04h 		; pix_to_sym вернёт в A раскодированный символ
	rz
	cpi 80h
	jz sym01h
	cpi 40h
	jz sym02h
	cpi 0C0h
	jz sym03h
	cpi 08h
	jz sym10h
	cpi 88h
	jz sym11h 
	cpi 84h
	jz sym05h
	cpi 48h
	jz sym12h
	cpi 44h
	jz sym06h
	cpi 0Ch
	jz sym14h
	cpi 0C8h
	jz sym13h
	cpi 0C4h
	jz sym07h
	cpi 8Ch
	jz sym15h
	cpi 4Ch
	jz sym16h
	cpi 0CCh
	jz sym17h

	mvi A, 00h
	ret
 

sym01h: mvi A, 01h
	ret
sym02h: mvi A, 02h
	ret
sym03h: mvi A, 03h
	ret
sym10h: mvi A, 10h
	ret
sym11h: mvi A, 11h
	ret
sym05h: mvi A, 05h
	ret
sym12h: mvi A, 12h
	ret
sym06h: mvi A, 06h
	ret
sym14h: mvi A, 14h
	ret
sym13h: mvi A, 13h
	ret
sym07h: mvi A, 07h
	ret
sym15h: mvi A, 15h
	ret
sym16h: mvi A, 16h
	ret
sym17h: mvi A, 17h
	ret

pic: db 00h, 00h, 00h, 00h, 7Fh, 0FFh, 0FFh, 0FEh, 50h, 6Eh, 00h, 0Ah, 6Fh, 5Ch, 40h, 06h, 4Bh, 78h, 0E1h, 0C2h, 49h, 71h, 0B3h, 0E2h, 4Fh, 60h, 0A2h, 0EEh, 48h, 01h, 0B3h, 0EAh, 48h, 60h, 0A1h, 0C2h, 40h, 0B1h, 0B0h, 0Ah, 60h, 90h, 0E0h, 0Ah, 70h, 0F0h, 40h, 46h, 78h, 90h, 00h, 0A2h, 7Ch, 93h, 0B7h, 12h, 76h, 02h, 80h, 0A2h, 6Ch, 22h, 80h, 42h, 78h, 12h, 80h, 4Eh, 71h, 0A7h, 0C0h, 4Eh, 61h, 94h, 52h, 02h, 42h, 20h, 12h, 42h, 4Ch, 7Ah, 96h, 02h, 5Ah, 25h, 5Ah, 42h, 52h, 00h, 12h, 02h, 5Eh, 0AFh, 0D2h, 0F2h, 40h, 00h, 00h, 0B2h, 58h, 89h, 0C0h, 92h, 45h, 58h, 40h, 92h, 49h, 48h, 80h, 92h, 5Ch, 9Ch, 80h, 0F2h, 40h, 00h, 00h, 06h, 7Fh, 0FFh, 0FFh, 0FEh, 00h, 00h, 00h, 00h


dbg_addr: dw 0300h
dbg_cnt: db 32h
