{
  TZXCompiler -      ZX   .
  (C) by Vladimir Kladov, 2003-2006
}

unit ZXAsmCompile;

interface

//{$DEFINE LOG_OUT}

uses Windows, KOL, ZxAsmTypes, ZXAsmFastMem, err;

const
  IdentifierStart = [ 'A'..'Z', 'a'..'z', ''..'', ''..'',
                      '', '', '_', '$', '@', '!',
                      '\', '/', '%', '[', ']', '{', '}', '~' ];
  IdentifierContinue = [ 'A'..'Z', 'a'..'z', ''..'', ''..'',
                      '', '', '_', '$', '@', '!',
                      '\', {'/',} '%', '[', ']', '{', '}', '~',
                      '0'..'9', '#' ];

type
  TOperation = ( oNone, oAdd, oSub, oMul, oDiv, oMod, oAnd, oOr, oXor, oShl, oShr,
                 oLT, oLE, oGT, oGE, oEQ, oNE,
                 oXchg, oCmp, oNot
               );

const
  opname: array[ TOperation ] of String = ( '(none)', '+', '-', '*', '/', '%',
    '&', '|', '^', '<<', '>>', '<', '<=', '>', '>=', '=', '<>',
    '><', '?', '!' );
  Priority: array[ TOperation ] of Integer = ( 0, 4, 4, 5, 5, 5,
    3, 2, 3,        6, 6,       1, 1, 1, 1, 1, 1,
    0, 0, 0  );
type TIncrement = ( none, inc_prefix, inc_suffix, dec_prefix, dec_suffix );
     TRegister = ( rBC, rDE, rHL, rAF, rSP, rIX, rIY, rB, rC, rD, rE, rH,
                   rL, rM, rA, rIXH, rIXL, rIYH, rIYL, rI, rR, wImm, noReg );
     TKind = ( kOther, kAF, kRegs );

const Kind: array[ TRegister ] of TKind =
                 ( kRegs, kRegs, kRegs, kAF, kOther, kOther, kOther,
                   kRegs, kRegs, kRegs, kRegs, kRegs, kRegs, kRegs, kAF,
                   kOther, kOther, kOther, kOther, kOther, kOther, kOther, kOther )  ;

      no_param  = 0;
      can_param = 1;
      end_dirs  = 2;

type
  TByteArray = array[0..65535] of Byte;
  PByteArray = ^TByteArray;


  PZXCompiler = ^TZXCompiler;
  TZXCompiler = object( TObj )
  public
    IncludeDirs: PStrList;
    Memory: PMemory;
    Options: DWORD;
    Src: PChar;
    Cur: PChar;
    OrgBank: Integer;
    Org: Word;
    Addr, AddrNext, AddrStart: Word;
    IncludeStack: PStrListEx;
    IncludeStkPos: PList;
    IncludeStkChanges: Integer;
    IncludeSources: PStrListEx;
    Pass: Integer;
    ErrCount: Integer;
    OnError: TOnError;
    OnLabel: TOnLabel;
    Labels: PNames;
    Undefined: PStrListEx;
    CurLabel: Integer;
    Defines: PNames;
    MacroList: PNames;
    NeedAllValues, TreatDotAsAddr, DotAsOperandUsed: Boolean;
    Ignore_Out: Integer; // >0    
    Compiling_Struct: Integer;
    CmdLens: PStream;
    pop_noinvert: Boolean;
    Skip_Level: Integer;
    ReservedLabelIdx: Integer;
    StkBreakCont: PStrListEx;
    LoopLabel: String;
    Pass3_needed: Boolean;
    AskedEditROM: Boolean;
    Encode: array[ Char ] of Char;
    EntryPointSetPass: Integer;
    EntryPoint: Word;
    procedure Init; virtual;
    DESTRUCTOR Destroy; virtual;
    procedure InitReservedTable( var Table: array of Byte; const List: array of String);
    function CompileZX: Integer;
    function CompileTo(const finMarks: array of String): Integer;
    procedure CallMacro( i: Integer );
    procedure DirectiveORG;
    procedure DirectiveEQU( i: Integer );
    procedure DirectiveAssign( i: Integer );
    procedure DirectiveDefine;
    procedure DirectiveProc( i: Integer );
    procedure DirectiveStruct( i: Integer );
    procedure DirectiveMacro( MacroToken, aName: PChar; aLen: Integer );
    procedure DirectiveENUM;
    procedure DirectiveDEFB( Bit7On: Boolean );
    procedure DirectiveDEFS;
    procedure DirectiveDEFW;
    procedure DirectiveDEFG;
    procedure DirectiveDEFD;
    procedure DirectiveFILE;
    procedure DirectiveINCLUDE;
    procedure DirectiveFOR;
    procedure DirectiveDUP;
    procedure DirectiveIF;
    procedure DirectiveIFCond( cond: Integer; Long: Boolean );
    procedure DirectiveGOTO( cond: Integer );
    procedure DirectiveWHILE( Long: Boolean; Djnz: Boolean );
    procedure DirectiveBREAK( cond: Integer; Long: Boolean );
    procedure DirectiveCONTINUE( cond: Integer; Long: Boolean );
    procedure DoBreakContinue( i, cond: Integer; Long: Boolean );
    procedure DirectivePUSH;
    procedure DirectivePOP;
    procedure DirectivePOPINVERT( invert: Boolean );
    procedure DirectiveERROR;
    procedure DirectiveDISPLAY;
    procedure DirectiveENCODE;
    procedure DirectiveCTEXT;
    procedure DirectiveENTRYPOINT;
    procedure OpEX;
    procedure OpIM;
    procedure OpIN;
    procedure OpJP;
    procedure OpJR;
    procedure OpLD;
    procedure OpADD;
    procedure OpOUT;
    procedure OpRET;
    procedure OpRST;
    procedure OpCALL;
    procedure OpDJNZ;
    procedure Op_Arithmetic_A( Base_R, Base_B: Byte );
    procedure Op_ADC_SBC( Base_R, Base_B, Base_RP: Byte );
    procedure Op_Shift( Base_R: Byte );
    procedure Op_BIT_RES_SET( Base: Byte );
    procedure Op_INC_DEC( Base_R, Base_RP: Byte );
    procedure IncAddr;
    procedure OutByte( b: Byte );
    procedure OutBytes( const a: array of Byte );
    procedure OutWord( w: Word );
    procedure SkipExpression;
    function Expression: Word;
    function Expression2( op1: TOperation; opd1: Word; var op2: TOperation ): Word;
    function Operand: Word;
    function GetOperation( var op: TOperation ): Boolean;
    function DoOperation( opd1: Word; op: TOperation; opd2: Word ): Word;
    function Compare2Strings: Word;
  public
    PassIndicated: Boolean;
    procedure Error( const s: String; Severity: Integer = 1 );
    procedure ErrorAt( pos: PChar; const s: String; Severity: Integer = 1 );
    procedure ErrorEndDir;
  public
    Handling_C_like: Boolean;
    reg1, reg2: TRegister;
    off1, off2: Integer;
    ref1, ref2: Boolean;
    alt1, alt2: Boolean;
    af_altered, regs_altered: Boolean;
    OpCanBeAtStartOfLine: Boolean;
    procedure C_like;
    procedure C_like_ADC_SBC( Base_R, Base_RP, Base_Imm: Byte );
    procedure C_like_ADD_SUB( Base_R, Base_RP, Base_Imm: Byte; const op_name: String );
    procedure C_like_Shl( CF: Boolean );
    procedure C_like_Shr( CF: Boolean );
    procedure C_like_Xchg;
    procedure C_like_Assign;
    function ScanRegister( var Reg: TRegister; var Alt: Boolean ): Boolean;
    function ScanIncrement( var Inc: TIncrement; Prefix: Boolean ): Boolean;
    function GetOperation_C_like( var op: TOperation; var CF: Boolean ): Boolean;
  public
    Token: PChar;
    Len: Integer;
    AtStartOfLine: Boolean;
    TokensScanned: Integer;
    DirectivesHash, OpCodes2, OpCodes3, OpCodes4: array[ 0..8192 ] of Byte;
    procedure Next; //   ""
    procedure SkipSp; //  
    procedure SkipTo( C: Char );
    procedure SkipToToken( const a: array of String );
    procedure SkipToken( var p: PChar );
    function Wait( const s: String ): Boolean;
    function SEq( Start: PChar; L: Integer; const s: String ): Boolean;
    function SIn( Start: PChar; L: Integer; const a: array of String ): Boolean;
    function TokenEq( const s: String ): Boolean;
    function CheckTokenEq( const s: String ): Boolean;
    function TokenIn( const a: array of String ): Boolean;
    function CheckTokenIn( const a: array of String ): Boolean;
    function CheckToken_Reserved( TokenKind: Integer ): Boolean;
    function TokenInIdx( const a: array of String; var idx: Integer ): Boolean;
    function TokenInReserved( const a: array of String; var idx: Integer;
             var Hash: array of Byte ): Boolean;
    function TokenStartsFrom( const s: String ): Boolean;
    function TokenStr: String;
    function IsIdentifier: Boolean;
    function IsHexNumber: Boolean;
    function IsBinaryNumber: Boolean;
    function CouldBeHexNumber( const s: String ): Boolean;
    function MustBeIdentifier: Boolean;
    function NextEq( const s: String ): Boolean; //    
             //         s
    function NextIdInLine( const str: String ): Boolean;
    function NextIn( const a: array of String ): Boolean;
    function FindLabel( aName: PChar; aLen: Integer; prefix: Char ): Integer;
    function AddLabel( aName: PChar; aLen: Integer; aAddr: DWORD ): Integer;
    function SearchLabelBack( aName: PChar; aLen: Integer; Special: Char; chk: Word ): Integer;
    function SearchLabelFwd( aName: PChar; aLen: Integer; Special: Char; chk: Word ): Integer;
    function IsLocalPrefix( C: Char ): Boolean;
    function FindDefine: Integer;
    function FindMacro( aName: PChar; aLen: Integer; var i: Integer ): Boolean;
    function Number: Word;
    function ScanDecimal( var s: PChar ): Integer;
    function ScanFileName: String;
    function FindInclude( const fname: String ): String;
    procedure CorrectLabels( FromLabel: Integer; FromAddr: Word; Delta: Integer );
    function ReserveLabel: Integer;
    function AddReservedLabel( i: Integer ): Integer;
    function FindReserveLabel( i: Integer ): Integer;
    procedure ReplaceDefines;
  end;

var
  ZXCompiler: PZXCompiler;

implementation

type
  TMacro = packed record
    Src_Path: PChar;
    Source: PChar;
    MacroStart: PChar;
  end;
  PMacro = ^TMacro;

const OrgCur64K = -1000000; // OrdBank =  ,  Org 
                            //  64     .
                            //       
                            //   Org = 0..16383.   
                            //    Addr   
                            //    (..  
                            //   ,     
                            //       ).
      //  
      Macro_Marker = DWORD(-1); //  
      Proc_Start = DWORD(-2); //   
      Proc_End   = DWORD(-3); //   
      Define_Marker = DWORD(-5); //  
      Struct_Start = DWORD(-6);  //  
      Struct_End   = DWORD(-7);  //   
      Field_Flag    = $40000000; //   
      Variable_Flag = $20000000; //  
      EQU_Flag      = $10000000; //  EQU- 
      Org_Flag      = $08000000; //   ORG
      Dot_Flag      = $04000000; //   . =  $ =

      //  -     
      Ignore_TooLongOffset: Boolean = FALSE;
      Ignore_NotMatchingAddr: Boolean = FALSE;

      //   ,     
      //         ':'
      // (,       
      //  ,  ,  )
      ReservedList_Param: array[ 0..55 ] of String = ( 'ORG', 'ENUM', 'DEFB',
        'DEFW', 'DEFS', 'DEFM', 'DEFG', 'STRUCT', 'FILE', 'INCLUDE', 'ERROR',
        'PROC', 'DUP', 'IF', 'BREAK', 'CONTINUE', 'LONGBREAK', 'LONGCONTINUE',
        'GOTO', 'PUSH', 'POP', 'DISPLAY', 'ENTRYPOINT',
        'ADC', 'ADD', 'AND', 'BIT', 'CALL', 'CP', 'DEC', 'DJNZ', 'EX', 'IM',
        'IN', 'INC', 'JP', 'JR', 'LD', 'OR', 'OUT', 'RES', 'RET', 'RL', 'RLC',
        'RR', 'RRC', 'RST', 'SBC', 'SET', 'SLA', 'SLI', 'SLL', 'SRA', 'SRL',
        'SUB', 'XOR' );

      //   ,     
      //          ':'
      // (,         ,
      //    )
      ReservedList_NoParam: array[ 0..81 ] of String = ( 'STRUCT', 'MACRO',
        'PROC', 'IFNZ', 'IFZ', 'IFNC', 'IFC', 'IFPO', 'IFPE', 'IFP', 'IFM',
        'LONGIFNZ', 'LONGIFZ', 'LONGIFNC', 'LONGIFC',
        'LONGIFPO', 'LONGIFPE', 'LONGIFP', 'LONGIFM',
        'ELSE', 'EIF', 'ENDIF', 'WHILE', 'LONGWHILE', 'EWHILE', 'EWHILEB',
        'BREAK', 'CONTINUE', 'LONGBREAK', 'LONGCONTINUE',
        'POPNOINVERT', 'POPINVERT', 'ESTRUCT', 'ENDSTRUCT', 'ENDS',
        'EPROC', 'ENDPROC', 'ENDP', 'ENDM', 'EMAC', 'ENDMACRO', 'EDUP', 'ENDDUP',
        'EFOR', 'ENDFOR',
        'CCF', 'CPD', 'CPDR', 'CPI', 'CPIR', 'CPL', 'DAA', 'DI', 'EI', 'EXX',
        'HALT', 'IM0', 'IM1', 'IM2', 'IND', 'INDR', 'INI', 'INIR',
        'LDD', 'LDDR', 'LDI', 'LDIR', 'NEG', 'NOP', 'OUTD', 'OTDR', 'OUTI', 'OTIR',
        'RETI', 'RETN', 'RLA', 'RLCA', 'RLD', 'RRA', 'RRCA', 'RRD',
        'SCF' );

      //   ,     
      //    ,     
      //    .
      ReservedList_EndDirs: array[ 0..21 ] of String = ( 'ELSE',
        'EIF', 'EWHILE', 'EWHILEB', 'EWHILENZ', 'EWHILEZ', 'EWHILENC', 'EWHILEC',
        'EWHILEPO', 'EWHILEPE', 'EWHILEP', 'EWHILEM',
        'EMAC', 'EMACRO', 'ENDIF', 'ENDM', 'ENDP',
        'ENDPROC', 'ENDS', 'EPROC', 'ESTRUCT', 'THEN' );

var Upper: array[ Char ] of Char;
    ReservedTable_NoParam, ReservedTable_Param,
    ReservedTable_EndDirs: array[ 0..8191 ] of Byte;

procedure InitUpper;
var c: Char;
begin
  for c := #0 to #255 do
    Upper[ c ] := AnsiUpperCase( c + ' ' )[ 1 ];
end;

{ TZXCompiler }

function TZXCompiler.AddLabel(aName: PChar; aLen: Integer; aAddr: DWORD): Integer;
var s: String;
begin
  Result := -1;
  if (Pass = 0) and (aAddr and Variable_Flag = 0) then Exit;
  if Pass <= 1 then
    Result := Labels.AddObject( aName, aLen, aAddr )
  else
  begin
    if not Labels.NameEq( CurLabel, aName, aLen ) then
    begin
      SetString( s, aName, aLen );
      Error( 'At pass ' + Int2Str( pass ) + ' label ' + s + ' is adding ' +
             'in place of label ' + Labels.Items[ CurLabel ] );
    end;
    Result := CurLabel;
  end;
  inc( CurLabel );
end;

function TZXCompiler.AddReservedLabel(i: Integer): Integer;
var s: String;
    n: PChar;
begin
  s := #1 + Int2Str( i );
  n := GetMemFast( Length( s ) + 1 );
  Move( s[ 1 ], n^, Length( s ) + 1 );
  Result := AddLabel( n, Length( s ), Addr );
  if Pass >= 2 then
  begin
    if (Pass = 2) and not Pass3_needed or (Pass = 3) then
      if (Labels.Objects[ Result ] <> Addr) and
         not Ignore_NotMatchingAddr then
        Error( 'Warning: at pass ' + Int2Str( Pass ) + ', label ' +
          Labels.Items[ Result ] + ' has different addr (' + Int2Hex( Addr, 4 ) +
          ') then earlier (' + Int2Hex( Labels.Objects[ Result ], 4 ) + ')', 0 );
    Labels.Objects[ Result ] := Addr;
  end;
end;

procedure TZXCompiler.CallMacro(i: Integer);
type
  PMacroParam = ^TMacroParam;
  TMacroParam = packed record
    next_param: PMacroParam;
    p_name: PChar;
    pname_len: Integer;
    p_val: PChar;
    pval_len: Integer;
    Optional: Boolean;
    Assigned: Boolean;
  end;
var M: PMacro;
    j, k: Integer;
    ParamToken, ParamCur: PChar;
    ParamLen: Integer;
    MacroToken, MacroCur: PChar;
    MacroLen: Integer;
    Now_Param: Boolean;
    procedure RestoreParam;
    begin
      if Now_Param then Exit;
      MacroCur := Cur;     Cur := ParamCur;
      MacroToken := Token; Token := ParamToken;
      MacroLen := Len;     Len := ParamLen;
      Now_Param := TRUE;
    end;
    procedure RestoreMacro;
    begin
      if not Now_Param then Exit;
      ParamCur := Cur;     Cur := MacroCur;
      ParamToken := Token; Token := MacroToken;
      ParamLen := Len;     Len := MacroLen;
      Now_Param := FALSE;
    end;
var s: PChar;
    optional: Boolean;
    procedure ScanParam( Param: PMacroParam );
    begin
      CASE Token^ OF
      '''': begin
              s := Token;
              while not( Token^ in [ '''', #13, #10, #0 ] ) do inc( Token );
              if Token^ = '''' then inc( Token );
              Param.pval_len := DWORD( Token ) - DWORD( s );
              Param.p_val := ReallocateMemFast( Param.p_val, Param.pval_len + 1 );
              Move( s^, Param.p_val^, Param.pval_len );
              Param.p_val[ Param.pval_len ] := #0;
              Cur := Token; Next;
            end;
      '"' : begin
              inc( Token ); s := Token;
              while not( Token^ in [ '"', #13, #10, #0 ] ) do inc( Token );
              Param.pval_len := DWORD( Token ) - DWORD( s );
              Param.p_val := ReallocateMemFast( Param.p_val, Param.pval_len + 1 );
              Move( s^, Param.p_val^, Param.pval_len );
              Param.p_val[ Param.pval_len ] := #0;
              if Token^ = '"' then inc( Token );
              Cur := Token; Next;
            end;
      ',' : ;
      else  s := Token;
            while not( Token^ in [ #0..' ', ',', ';' ] ) do inc( Token );
            Param.pval_len := DWORD( Token ) - DWORD( s );
            Param.p_val := AllocMemFast( Param.pval_len + 1 );
            Move( s^, Param.p_val^, Param.pval_len );
            //Param.p_val[ Param.pval_len ] := #0;
            Cur := Token; Next;
      END;
    end;
var Params, LastParam, AParam: PMacroParam;
begin
  Next; //   (    )
  M := Pointer( MacroList.Objects[ i ] );
  j := IncludeStack.Count;
  k := Defines.Count;
  TRY
    ParamCur := Cur;
    ParamToken := Token;
    ParamLen := Len;
    MacroCur := M.MacroStart;
    Now_Param := FALSE;
    TokensScanned := 0;
    Cur := MacroCur; Next;
    if not TokenEq( 'MACRO' ) then
    begin
      RestoreParam;
      Error( 'MACRO not found' ); Exit;
    end;
    //macro_param_end := FALSE;
    //actual_param_end := FALSE;
    Params := nil;
    LastParam := nil;
    if not AtStartOfLine then
    begin //   - 
      RestoreMacro;
      optional := FALSE;
      //e := FALSE;
      while Token^ <> #0 do
      begin
        if IsIdentifier then
        begin
          AParam := AllocMemFast( Sizeof( TMacroParam ) );
          if LastParam <> nil then LastParam.next_param := AParam
          else Params := AParam;
          LastParam := AParam;
          AParam.p_name := Token;
          AParam.pname_len := Len;
          Next;
          AParam.p_val := AllocMemFast( 1 );
          AParam.pval_len := 0;
          if TokenEq( '=' ) then //    
          begin
            AParam.optional := TRUE;
            Optional := TRUE;
            ScanParam( AParam );
          end
          else if Optional then
            Error( 'Fixed parameter can not follow optional parameter(s)' );

          {RestoreParam;
          if not actual_param_end then
          begin
            if optional and (Len = pname_len) and
               (StrLComp( p_name, Token, Len ) = 0) and
               NextEq( '=' ) then
            begin
              Next; Next;
            end;
            ScanParam;
            if not TokenEq( ',' ) then actual_param_end := TRUE;
          end
          else if not optional and not e then
          begin
            ErrorAt( PChar( IncludeStkPos.Last ), 'Not enough macro params' );
            e := TRUE;
          end;
          Defines.AddObject( p_name, pname_len, DWORD( p_val ) );
          RestoreMacro;}
          if not TokenEq( ',' ) then
          begin
            //macro_param_end := TRUE;
            break;
          end;
        end else break;
      end;
    end;
    RestoreParam;
    LastParam := Params;
    Optional := FALSE;
    while Token^ <> #0 do
    begin
      if LastParam = nil then break;
      if not LastParam.Optional then
      begin
        ScanParam( LastParam );
        LastParam := LastParam.next_param;
      end
      else //   
      begin
        if IsIdentifier and NextEq( '=' ) then
        begin
          AParam := LastParam;
          while AParam <> nil do
          begin
            if not AParam.Assigned and
               (AParam.pname_len = Len) and
               (StrLComp( AParam.p_name, Token, Len ) = 0) then
            begin //    
              Optional := TRUE;
              Next; Next; ScanParam( AParam );
              AParam.Assigned := TRUE;
              break;
            end;
            AParam := AParam.next_param;
          end;
          if AParam = nil then
          begin
            if Optional then
              Error( 'It is not allowed to pass optional parameter without name ' +
                     'if other parameters passed by name already' );
            ScanParam( LastParam ); LastParam.Assigned := TRUE;
            LastParam := LastParam.next_param;
          end;
          if TokenEq( ',' ) then
          begin
            continue;
          end
          else
          begin
            if not LastParam.Optional then
              Error( 'Not enough macro parameters' );
            break;
          end;
        end
        else //    
        begin
          if Optional then
            Error( 'It is not allowed to pass optional paramter without name ' +
                     'if other parameters passed by name already' );
          ScanParam( LastParam ); LastParam.Assigned := TRUE;
          LastParam := LastParam.next_param;
        end;
      end;
      if LastParam = nil then
      begin
        if TokenEq( ',' ) then
        begin
          Error( 'Too many macro paramters' );
          break;
        end;
      end
      else
      begin
        if TokenEq( ',' ) then continue;
        if not LastParam.Optional then
          Error( 'Not enough macro parameters' );
        break;
      end;
    end;
    AParam := Params;
    while AParam <> nil do
    begin
      Defines.AddObject( AParam.p_name, AParam.pname_len,
        DWORD( AParam.p_val ) );
      AParam := AParam.next_param;
    end;
    //if {macro_param_end and} not actual_param_end then
    //  Error( 'Too many macro params' );
    RestoreMacro;
    AtStartOfLine := TRUE;
    IncludeStkPos.Add( Cur );
    IncludeStack.AddObject( M.Src_Path, DWORD( M.Source ) );
    inc( IncludeStkChanges );
    AddLabel( '', 0, Proc_Start );
    if Skip_Level = 0 then
      CompileTo( [ 'ENDMACRO', 'ENDM', 'EMACRO', 'EMAC' ] );
  FINALLY
    RestoreParam;
    AddLabel( '', 0, Proc_End );
    while j < IncludeStkPos.Count do
    begin
      IncludeStack.DeleteLast;
      IncludeStkPos.Delete( IncludeStkPos.Count - 1);
      inc( IncludeStkChanges );
    end;
    while k < Defines.Count do
      Defines.DeleteLast;
  END;
end;

function TZXCompiler.CheckTokenEq(const s: String): Boolean;
var i: Integer;
    p: PChar;
begin
  Result := Length( s ) = Len;
  if not Result then Exit;
  Result := FALSE;
  p := Token;
  for i := 1 to Len do
  begin
    if Upper[ p^ ] <> s[ i ] then Exit;
    inc( p );
  end;
  Result := TRUE;
end;

function TZXCompiler.CheckTokenIn(const a: array of String): Boolean;
var i: Integer;
begin
  Result := TRUE;
  for i := 0 to High( a ) do
    if CheckTokenEq( a[ i ] ) then Exit;
  Result := FALSE;
end;

function TZXCompiler.CheckToken_Reserved(TokenKind: Integer): Boolean;
var chk: Word;
    s: PChar;
    i: Integer;
begin
  Result := FALSE;
  chk := 0;
  s := Token;
  i := Len;
  while i > 0 do
  begin
    chk := ((chk shl 1) or (chk shr 15)) xor Byte( Upper[ s^ ] );
    inc( s );
    dec( i );
  end;
  if (TokenKind = 1) and
     (ReservedTable_Param[ chk shr 3 ] and (1 shl (chk and 7)) = 0)
     OR
     (TokenKind = 0) and
     (ReservedTable_NoParam[ chk shr 3 ] and (1 shl (chk and 7)) = 0)
     OR
     (TokenKind = 2) and
     (ReservedTable_EndDirs[ chk shr 3 ] and (1 shl (chk and 7)) = 0)
  then Exit;
  if (TokenKind = 1) and not CheckTokenIn( ReservedList_Param )
     or
     (TokenKind = 0) and not CheckTokenIn( ReservedList_NoParam )
     or
     (TokenKind = 2) and not CheckTokenIn( ReservedList_EndDirs )
  then Exit;
  Result := TRUE;
end;

function TZXCompiler.Compare2Strings: Word;
var L: Integer;
    s, s1, s2: PChar;
    op1: TOperation;
begin
  Result := 1;
  inc( Token );
  s := Token;
  while not( Token^ in [ '"', #13, #10, #0 ] ) do inc( Token );
  L := DWORD( Token ) - DWORD( s );
  s1 := AllocMemFast( L + 1 );
  Move( s^, s1^, L );
  if Token^ = '"' then inc( Token )
  else Error( 'Unterminated string' );
  Cur := Token; Next;
  if not GetOperation( op1 ) then
  begin
    Error( 'Waiting for coparison operation' ); Exit;
  end;
  s := Token;
  if Token^ = '"' then inc( Token );
  while not( Token^ in [ #13, #10, #0 ] ) and
        ((s^ <> '"') or (s^ = '"') and (Token^ <> '"')) do inc( Token );
  L := DWORD( Token ) - DWORD( s ); if s^ = '"' then Dec( L );
  if s^ = '"' then
  begin
    inc( s );
    if Token^ = '"' then inc( Token )
    else Error( 'Unterminated string' );
  end;
  s2 := AllocMemFast( L + 1 );
  Move( s^, s2^, L );
  CASE op1 OF
  oEQ: Result := Integer( StrComp( s1, s2 ) = 0 );
  oNE: Result := Integer( StrComp( s1, s2 ) <> 0 );
  oLT: Result := Integer( StrComp( s1, s2 ) < 0 );
  oLE: Result := Integer( StrComp( s1, s2 ) <= 0 );
  oGT: Result := Integer( StrComp( s1, s2 ) > 0 );
  oGE: Result := Integer( StrComp( s1, s2 ) >= 0 );
  else Error( 'Invalid comparison operation' );
  END;
  Cur := Token; Next;
end;

function TZXCompiler.CompileTo(const finMarks: array of String): Integer;
var i, j: Integer;
    Addr0: Word;
    aLabel: PChar;
    aLabLen: Integer;
    p: PChar;
    CmdLen_Pos, Save_Pos: DWORD;
    s: String;
begin
  AtStartOfLine := TRUE;
  Result := -1;
  while (Token^ <> #0) and (ErrCount < 10) do
  begin //      
    Result := -1;
    AddrStart := Addr;
    AddrNext := Addr;
    CmdLen_Pos := CmdLens.Position;
    if Pass = 0 then
    else if Pass = 1 then
    begin
      i := 0; CmdLens.Write( i, 2 );
    end
    else
    begin
      i := 0; CmdLens.Read( i, 2 );
      AddrNext := Addr + i;
    end;
    Addr0 := Addr;
    LoopLabel := '';
    if AtStartOfLine and (Defines.Count > 0) and
       not NextIdInLine( 'MACRO' ) then
      ReplaceDefines;
    if TokenInIdx( finMarks, Result ) then break;
    if TokenEq( ':' ) then continue;
    if TokenIn( [ '.', '$' ] ) then
    begin
      Wait( '=' );
      NeedAllValues := TRUE;
      TreatDotAsAddr := TRUE;
      DotAsOperandUsed := FALSE;
      if Skip_Level > 0 then
      begin
        NeedAllValues := FALSE;
        Expression;
      end
      else
      begin
        Addr := Expression;
        Org := Addr;
        TreatDotAsAddr := FALSE;
        NeedAllValues := FALSE;
        i := AddLabel( '', 0, Dot_Flag or Addr );
        if Pass >= 2 then
        begin
          if Labels.Objects[ CurLabel-1 ] and Dot_Flag = 0 then
          asm
            int 3 //        ""
          end;
          i := Labels.Objects[ CurLabel-1 ] and $FFFF;
          if (Pass = 2) and (Addr <> i) then
            CorrectLabels( CurLabel, i, Addr - i );
        end;
      end;
    end
      else
    if IsIdentifier then
    BEGIN
      if AtStartOfLine and CheckTokenEq( 'CTEXT' ) then
      begin
        DirectiveCTEXT;
      end
      else if AtStartOfLine and NextEq( '=' ) and
         not CheckTokenIn( [ 'BC', 'DE', 'HL', 'IX', 'IY', 'SP',
             'B', 'C', 'D', 'E', 'H', 'L', 'M', 'A' ] ) then
      begin //  id = expr
        aLabel := Token;
        aLabLen := Len;
        Next; Next;
        i := FindLabel( aLabel, aLabLen, 'v' );
        if (Pass = 0) and (i < 0) then
          i := AddLabel( aLabel, aLabLen, Variable_Flag )
        else if (i < 0) then
        begin
          SetString( s, aLabel, aLabLen );
          Error( 'Name ' + s + ' not found ' );
        end
        else if Labels.Objects[ i ] and Variable_Flag = 0 then
          Error( 'Identifier is not a variable' );
        DirectiveAssign( i ); // label = expr
      end
      else if AtStartOfLine and NextEq( 'DEFINE' ) then
      begin
        DirectiveDefine; // label DEFINE string
      end
      else if AtStartOfLine and
         (NextIn( [ ':', 'EQU', 'DEFINE', 'PROC', 'PROCEDURE', 'STRUCT', 'MACRO' ] ) or
          NextEq( '=' ) and
          not CheckTokenIn( [ 'A', 'B', 'C', 'D', 'E', 'H', 'L', 'M', 'I', 'R',
                  'IXH', 'IXL', 'IYH', 'IYL', 'BC', 'DE', 'HL', 'IX', 'IY', 'SP', 'AF' ] ))
         and not( NextEq( ':' ) and CheckToken_Reserved( no_param ) or
                  not NextEq( ':' ) and CheckToken_Reserved( can_param ) )
      then
      begin //   
        if CheckToken_Reserved( end_dirs ) then
          ErrorEndDir;
        aLabel := Token;
        aLabLen := Len;
        Next; if TokenEq( ':' ) then ;
        if CheckTokenEq( 'MACRO' ) then
        begin
          DirectiveMacro( Token, aLabel, aLabLen );
          continue;
        end
        else
        begin
          j := FindLabel( aLabel, aLabLen, '?' );
          i := 0; if Compiling_Struct > 0 then i := Field_Flag;
          if Skip_Level > 0 then
            i := -1
          else i := AddLabel( aLabel, aLabLen, Addr or i );
          if Pass = 0 then
          else if Pass = 1 then
          begin
            if FindMacro( aLabel, aLabLen, i ) then
              Error( 'It is not allowed to use the same name for macro and for label' );
            if (j >= 0) and (i >= 0) then
            begin
              if Labels.Objects[ i ] and Variable_Flag = 0 then
              begin
                SetString( s, aLabel, aLabLen );
                Error( 'Duplicate label ' + s );
              end;
            end;
          end
          else if (Pass >= 2) and (Skip_Level = 0) then
          begin
            if (Labels.Objects[ i ] <> Addr) and
               (Labels.Objects[ i ] <> Macro_Marker) and
               (Labels.Objects[ i ] <> Struct_Start) and
               (Labels.Objects[ i ] <> Define_Marker) and
               (Labels.Objects[ i ] and Variable_Flag = 0) and
               (Labels.Objects[ i ] and EQU_Flag = 0) and
               not Ignore_NotMatchingAddr then
            Error( 'Warning: at pass ' + Int2Str( Pass ) + ', label ' +
              Labels.Items[ i ] + ' has different addr (' + Int2Hex( Addr, 4 ) +
              ') then earlier (' + Int2Hex( Labels.Objects[ i ], 4 ) + ')', 0 );
          end;
        End;
        if TokenInIdx( [ 'EQU', 'PROC', 'PROCEDURE', 'STRUCT', 'WHILE',
           'LONGWHILE', 'WHILEB' ], j ) then
        CASE j OF
        0: DirectiveEQU( i );    // label EQU expr
        1,2: DirectiveProc( i ); // label PROC ...
        3: DirectiveStruct( i ); // label STRUCT ...
        4,5,6: begin
                 SetString( LoopLabel, aLabel, aLabLen );
                 DirectiveWHILE( j = 5, j = 6 );     // label WHILE ...
               end;
        else ; // Label[:]
        END;
      end
      else
      begin
        if FindMacro( Token, Len, i ) then
        begin
          CallMacro( i );
        end
        else if TokenInReserved( [ 'ORG', 'ENUM', 'DEFB', 'DEFW', 'DEFS', 'DEFM',
           'DEFG', 'DEFD',
           'FILE', 'INCLUDE', 'DUP', 'FOR', 'IF',
           'IFNZ', 'IFZ', 'IFNC', 'IFC', 'IFPO', 'IFPE', 'IFP', 'IFM',
           'LONGIFNZ', 'LONGIFZ', 'LONGIFNC', 'LONGIFC',
           'LONGIFPO', 'LONGIFPE', 'LONGIFP', 'LONGIFM',
           'WHILE', 'LONGWHILE', 'WHILEB',
           'BREAK', 'LONGBREAK', 'CONTINUE', 'LONGCONTINUE',
           'GOTO', 'PUSH', 'POP', 'POPINVERT', 'POPNOINVERT', 'PROC', 'ERROR',
           'DISPLAY', 'ENCODE', 'ENTRYPOINT' ],
           j, DirectivesHash ) then
        CASE j OF
        0: DirectiveORG;
        1: DirectiveENUM;
        2: DirectiveDEFB( FALSE ); // DEFB
        3: DirectiveDEFW;
        4: DirectiveDEFS;
        5: DirectiveDEFB( TRUE );  // DEFM (TRUE =  bit7   )
        6: DirectiveDEFG;
        7: DirectiveDEFD;
        8: DirectiveFILE;
        9: DirectiveINCLUDE;
        10:DirectiveDUP;
        11:DirectiveFOR;
        12:DirectiveIF;
        13..20: DirectiveIFCond( j-13, FALSE );
        21..28: DirectiveIFCond( j-21, TRUE );
        29,30,31:Begin LoopLabel := ''; DirectiveWHILE( j=30, j=31 ); End;
        32:DirectiveBREAK( -1, FALSE );
        33:DirectiveBREAK( -1, TRUE );
        34:DirectiveCONTINUE( -1, FALSE );
        35:DirectiveCONTINUE( -1, TRUE );
        36:If TokenInIdx( [ 'NZ', 'Z', 'NC', 'C', 'PO', 'PE', 'P', 'M' ], i ) then
           begin
             Wait( ',' ); DirectiveGOTO( i );
           end
           else DirectiveGOTO( -1 );
        37:DirectivePUSH;
        38:DirectivePOP;
        39:DirectivePOPINVERT( TRUE );
        40:DirectivePOPINVERT( FALSE );
        41:DirectivePROC( -1 );
        42:DirectiveERROR;
        43:DirectiveDISPLAY;
        44:DirectiveENCODE;
        45:DirectiveENTRYPOINT;
        END
        else if CheckTokenIn( [ 'A', 'B', 'C', 'D', 'E', 'H', 'L', 'M',
             'IXH', 'IXL', 'IYH', 'IYL', 'BC', 'DE', 'HL', 'IX', 'IY', 'SP' ] ) then
        begin //  C- ,     
              // (    --R, ++R, (...)..., op...);
          C_like;
        end
        else if (Len = 2) and TokenInReserved( [ 'CP', 'DI', 'EI', 'EX', 'IM', 'IN',
             'JP', 'JR', 'LD', 'OR', 'RL', 'RR' ], j, OpCodes2 ) then
        CASE j OF
        0: Op_Arithmetic_A( $B8, $FE ); // CP [A,]r | CP [A,]#b
        1: OutByte( $F3 ); // DI
        2: OutByte( $FB ); // EI
        3: OpEX;
        4: OpIM;
        5: OpIN;
        6: OpJP;
        7: OpJR;
        8: OpLD;
        9: Op_Arithmetic_A( $B0, $F6 ); // OR [A,]r | OR [A,]#b
        10:Op_Shift( $10 ); // RL r
        11:Op_Shift( $18 ); // RR r
        END
        else if (Len = 3) and TokenInReserved( [ 'ADC', 'ADD', 'AND', 'BIT', 'CCF',
             'CPD', 'CPI', 'CPL', 'DAA', 'DEC', 'EXX', 'IM0', 'IM1', 'IM2',
             'INC', 'IND', 'INI', 'LDD', 'LDI', 'NEG', 'NOP', 'OUT', 'RES',
             'RET', 'RLA', 'RLC', 'RLD', 'RRA', 'RRC', 'RRD', 'RST', 'SBC',
             'SCF', 'SET', 'SLA', 'SLI', 'SLL', 'SRA', 'SRL', 'SUB', 'XOR' ],
             j, OpCodes3 ) then
        CASE j OF
        0: Op_ADC_SBC( $88, $CE, $4A ); // ADC [A,]r | ADC [A,]#b | ADC rp[,rp2]
        1: OpADD;
        2: Op_Arithmetic_A( $A0, $E6 ); // AND [A,]r  | AND [A,]#b
        3: Op_BIT_RES_SET( $40 ); // BIT n,r
        4: OutByte( $3F ); // CCF
        5: OutBytes( [ $ED, $A9 ] ); // CPD
        6: OutBytes( [ $ED, $A1 ] ); // CPI
        7: OutByte( $2F ); // CPL
        8: OutByte( $27 ); // DAA
        9: Op_INC_DEC( $05, $0B ); // DEC r | DEC rp
        10:OutByte( $D9 ); // EXX
        11:OutBytes( [ $ED, $46 ] ); // IM0
        12:OutBytes( [ $ED, $56 ] ); // IM1
        13:OutBytes( [ $ED, $5E ] ); // IM2
        14:Op_INC_DEC( $04, $03 ); // INC r | INC rp
        15:OutBytes( [ $ED, $AA ] ); // IND
        16:OutBytes( [ $ED, $A2 ] ); // INI
        17:OutBytes( [ $ED, $A8 ] ); // LDD
        18:OutBytes( [ $ED, $A0 ] ); // LDI
        19:OutBytes( [ $ED, $44 ] ); // NEG
        20:OutByte( 0 ); // NOP
        21:OpOUT;
        22:Op_BIT_RES_SET( $80 ); // RES n,r
        23:OpRET;
        24:OutByte( $17 ); // RLA
        25:Op_Shift( $00 ); // RLC r
        26:OutBytes( [ $ED, $6F ] ); // RLD
        27:OutByte( $1F ); // RRA
        28:Op_Shift( $08 );  // RRC r
        29:OutBytes( [ $ED, $67 ] ); // RRD
        30:OpRST;
        31:Op_ADC_SBC( $98, $DE, $42 ); // SBC [A,]r | SBC [A,]#b | SBC rp[,rp2]
        32:OutByte( $37 ); // SCF
        33:Op_BIT_RES_SET( $C0 ); // SET n,r
        34:Op_Shift( $20 ); // SLA r
        35:Op_Shift( $30 ); // SLI r
        36:Op_Shift( $30 ); // SLL r
        37:Op_Shift( $28 ); // SRA r
        38:Op_Shift( $38 ); // SRL r
        39:Op_Arithmetic_A( $90, $D6 ); // SUB [A,]r | SUB [A,]#b
        40:Op_Arithmetic_A( $A8, $EE ); // XOR [A,]r | XOR [A,]#b
        END
        else if (Len = 4) and TokenInReserved( [ 'CALL', 'CPDR', 'CPIR', 'DJNZ',
             'HALT', 'INDR', 'INIR', 'LDDR', 'LDIR', 'OUTD', 'OTDR', 'OUTI',
             'OTIR', 'RETI', 'RETN', 'RLCA', 'RRCA' ], j, OpCodes4 ) then
        CASE j OF
        0: OpCALL;
        1: OutBytes( [ $ED, $B9 ] ); // CPDR
        2: OutBytes( [ $ED, $B1 ] ); // CPIR
        3: OpDJNZ;
        4: OutByte( $76 );
        5: OutBytes( [ $ED, $BA ] ); // INDR
        6: OutBytes( [ $ED, $B2 ] ); // INIR
        7: OutBytes( [ $ED, $B8 ] ); // LDDR
        8: OutBytes( [ $ED, $B0 ] ); // LDIR
        9: OutBytes( [ $ED, $AB ] ); // OUTD
        10:OutBytes( [ $ED, $BB ] ); // OTDR
        11:OutBytes( [ $ED, $A3 ] ); // OUTI
        12:OutBytes( [ $ED, $AB ] ); // OTIR
        13:OutBytes( [ $ED, $4D ] ); // RETI
        14:OutBytes( [ $ED, $45 ] ); // RETN
        15:OutByte( $07 ); // RLCA
        16:OutByte( $0F ); // RRCA
        END
        else //   - 
        begin
          if CheckToken_Reserved( 2 ) then
            ErrorEndDir;
          if IsLocalPrefix( Token^ ) then j := -1
          else j := FindLabel( Token, Len, ' ' );
          i := 0; if Compiling_Struct > 0 then i := Field_Flag;
          i := AddLabel( Token, Len, Addr or i ); //dec( CurLabel );
          if Pass = 0 then
          else if Pass = 1 then
          begin
            if (j >= 0) then
              Error( 'Duplicate label ' + TokenStr );
          end
          else if (Pass = 2) and not Pass3_needed or (Pass = 3) then
          begin
            if i < 0 then i := FindLabel( Token, Len, ' ' );
            if i < 0 then
            begin
              if not FindMacro( Token, Len, i ) then
              begin
                Error( 'Name ' + TokenStr + ' not found' );
                Exit;
              end;
            end
            else if (Labels.Objects[ i ] and $FFFF <> Addr) and
                    not Ignore_NotMatchingAddr then
            Error( 'Warning: at pass ' + Int2Str( Pass ) + ', label ' +
              Labels.Items[ i ] + ' has different addr (' + Int2Hex( Addr, 4 ) +
              ') then earlier (' + Int2Hex( Labels.Objects[ i ], 4 ) + ')', 0 );
          end;
          Next;
        end;
      end;
    END //    ,    like-C:
    else if CheckTokenEq( '(' ) or
            (Token^ in [ '+', '-', '&', '|', '^', '>', '<', '?' ]) then
    begin
      p := Token;
      C_like;
      if p = Token then
      begin
        Cur := p + 1; TokensScanned := 0;
        Next;
      end;
      if TokenEq( ':' ) then ;
    end
    else
    begin
      Error( 'Syntax invalid' );
      Next;
    end;
    i := Addr - Addr0;
    Save_Pos := CmdLens.Position;
    CmdLens.Position := CmdLen_Pos;
    CmdLens.Write( i, 2 );
    CmdLens.Position := Save_Pos;
  end;
end;

function TZXCompiler.CompileZX: Integer;
var s, lab: String;
    i, a, j: Integer;
    U: PStrList;
    start_CurLabel: Integer;
    c: Char;
begin
  {$IFDEF LOG_OUT}
  DeleteFile( 'c:\ZXAsmPP1.log' );
  DeleteFile( 'c:\ZXAsmPP2.log' );
  DeleteFile( 'c:\ZXAsmPP3.log' );
  {$ENDIF}
  TRY

    Result := -1;
    Pass := 0;
    start_CurLabel := 0;
    while Pass <= 3 do
    begin
      Result := -1;
      PassIndicated := FALSE;
      TokensScanned := 0;
      Cur := Src; Next; //     
      AtStartOfLine := TRUE;
      OrgBank := OrgCur64K; //   ""   0
      Org := 0; Addr := 0;
      CurLabel := start_CurLabel; //     
      CmdLens.Position := 0; //       
                             //  ,   
                             //   (   
                             //  $  .   AddrNext)
      ReservedLabelIdx := 0;
      //MacroList.Clear;
      if Pass = 0 then Skip_Level := 1;
      CompileTo( [ 'END' ] );
      Skip_Level := 0;
      Defines.Clear;
      for c := #0 to #255 do
        Encode[ c ] := c;
      if Pass = 0 then
        start_CurLabel := CurLabel //  0-   
      else if Pass = 1 then
      begin
        U := NewStrList;
        TRY
          for i := 0 to Undefined.Count-1 do
          begin
            CurLabel := Undefined.Objects[ i ];
            lab := Undefined.Items[ i ];
            j := FindLabel( PChar( lab ), Length( lab ), ' ' );
            if (j < 0) and not CouldBeHexNumber( lab ) then
            begin
              if U.IndexOf( lab )<0 then
                U.Add( lab );
              if U.Count > 4 then break;
            end;
          end;
          s := U.Text;
        FINALLY
          U.Free;
        END;
        if s <> '' then
        begin
          //Error( 'Label(s) ' + s + ' still not defined' );
          inc( Ignore_Out );
        end;
      end;
      if ErrCount > 0 then break;
      Result := Addr;
      if Options and Option_SyntaxCheckOnly <> 0 then break;
      inc( Pass );
      if (Pass = 3) and not Pass3_needed then break;
    end;
    if (Options and Option_SyntaxCheckOnly = 0) and
       (Pass > 1) and Assigned( OnLabel ) then
    begin
      for i := 0 to Labels.Count-1 do
      begin
        a := Labels.Objects[ i ];
        if a < 0 then continue;
        if a and Org_Flag <> 0 then
          OnLabel( nil, a and $FFFF, OrgCur64K );
        s := Labels.Items[ i ];
        if s = '' then continue;
        if s[ 1 ] = #1 then continue;
        OnLabel( PChar( s ), a, OrgCur64K );
      end;
      if EntryPointSetPass > 0 then
        OnLabel( '.', EntryPoint, OrgCur64K );
    end;
  EXCEPT on E: Exception do
         begin
           if (E.Code = e_Custom) and (e.Message = 'Fatal error') then
           else Error( 'Fatal error while compiling: ' + e.Message );
           Result := -1;
         end;
  END;
end;

procedure TZXCompiler.CorrectLabels(FromLabel: Integer; FromAddr: Word; Delta: Integer);
var i, j: Integer;
begin
  if (Skip_Level > 0) then
  begin
    if Pass > 0 then
    asm
      int 3
    end;
    Exit;
  end;
  for i := FromLabel to Labels.Count-1 do
  begin
    j := Labels.Objects[ i ];
    if (j < 0) or (j and Variable_Flag <> 0) or
                  (j and Field_Flag <> 0) or
                  (j and EQU_Flag <> 0) then continue;
    if j and ( Org_Flag or Dot_Flag ) <> 0 then break;
    if Word( j ) >= FromAddr then
    begin
      if Pass = 2 then Pass3_needed := TRUE;
      Labels.Objects[ i ] := Word( j + Delta );
    end;
  end;
end;

function TZXCompiler.CouldBeHexNumber(const s: String): Boolean;
var i: Integer;
begin
  Result := FALSE;
  if Length( s ) > 4 then Exit;
  for i := 1 to Length( s ) do
    if not(Upper[s[ i ]] in [ '0'..'9', 'A'..'F' ]) then Exit;
  Result := TRUE;
end;

procedure TZXCompiler.C_like;
var Incs1Opd, Incs1Reg, Incs2Opd, Incs2Reg: TIncrement;
    start_from_operation: Boolean;
    op: TOperation;
    cf: Boolean;
    procedure Alter_AF;
    begin
      OutByte( 8 ); af_altered := not af_altered;
    end;
    procedure Alter_Regs;
    begin
      OutByte( $D9 ); regs_altered := not regs_altered;
    end;
    procedure DoIncDec( Reg: TRegister; Off: Integer; MemRef, Alt: Boolean; Delta: Integer );
    begin
      CASE Reg OF
      rA, rAF: if Alt xor af_altered then Alter_AF;
      rBC, rDE, rHL, rB, rC, rD, rE, rH, rL, rM:
        if Alt xor regs_altered then Alter_Regs;
      else if Alt then Error( 'Wrong register to alter it' );
      END;
      if MemRef then
      CASE Reg OF
      rHL: if Delta > 0 then OutByte( $34 ) else OutByte( $35 );
      rIX: if Delta > 0 then OutBytes( [ $DD, $34, Off ] )
                        else OutBytes( [ $DD, $35, Off ] );
      rIY: if Delta > 0 then OutBytes( [ $FD, $34, Off ] )
                        else OutBytes( [ $FD, $35, Off ] );
      rSP: if Delta > 0 then OutBytes( [ $E3, $23, $E3 ] )
                        else OutBytes( [ $E3, $2B, $E3 ] ); // ++(SP) increments word!
      else Error( 'Wrong addressing for increment/decrement' )
      END
      else
      CASE Reg OF
      rBC : if Delta > 0 then OutByte( $03 ) else OutByte( $0B );
      rDE : if Delta > 0 then OutByte( $13 ) else OutByte( $1B );
      rHL : if Delta > 0 then OutByte( $23 ) else OutByte( $2B );
      rSP : if Delta > 0 then OutBytes( [ $33, $33 ] ) // ++SP increments by 2!
                         else OutBytes( [ $3B, $3B ] );
      rIX : if Delta > 0 then OutBytes( [ $DD, $23 ] )
                         else OutBytes( [ $DD, $2B ] );
      rIY : if Delta > 0 then OutBytes( [ $FD, $23 ] )
                         else OutBytes( [ $FD, $2B ] );
      rB  : if Delta > 0 then OutByte( $04 ) else OutByte( $05 );
      rC  : if Delta > 0 then OutByte( $0C ) else OutByte( $0D );
      rD  : if Delta > 0 then OutByte( $14 ) else OutByte( $15 );
      rE  : if Delta > 0 then OutByte( $1C ) else OutByte( $1D );
      rH  : if Delta > 0 then OutByte( $24 ) else OutByte( $25 );
      rL  : if Delta > 0 then OutByte( $2C ) else OutByte( $2D );
      rM  : if Delta > 0 then OutByte( $34 ) else OutByte( $35 );
      rA  : if Delta > 0 then OutByte( $3C ) else OutByte( $3D );
      rIXH: if Delta > 0 then OutBytes( [ $DD, $24 ] )
                         else OutBytes( [ $DD, $25 ] );
      rIXL: if Delta > 0 then OutBytes( [ $DD, $2C ] )
                         else OutBytes( [ $DD, $2D ] );
      rIYH: if Delta > 0 then OutBytes( [ $FD, $24 ] )
                         else OutBytes( [ $FD, $25 ] );
      rIYL: if Delta > 0 then OutBytes( [ $FD, $2C ] )
                         else OutBytes( [ $FD, $2D ] );
      else Error( 'Wrong register to increment/decrement' );
      END;
    end;
label get_operation;
var do_scan_op, do_scan_opd2: Boolean;
begin
  Handling_C_like := TRUE;
  start_from_operation := FALSE;
  Incs1Opd := none;
  Incs1Reg := none;
  Incs2Opd := none;
  Incs2Reg := none;
  reg1 := noReg;
  reg2 := noReg;
  off1 := 0;
  off2 := 0;
  ref1 := FALSE;
  ref2 := FALSE;
  alt1 := FALSE;
  alt2 := FALSE;
  do_scan_opd2 := FALSE;
  af_altered := FALSE;
  regs_altered := FALSE;
  TRY
    OpCanBeAtStartOfLine := TRUE;
    TRY
      if not ScanIncrement( Incs1Opd, TRUE ) then
      if GetOperation_C_like( op, cf ) then
      begin
        CASE op OF
        oMul, oDiv, oMod, oLT, oGT, oLE, oGE:
          begin
            Error( 'Syntax unknown' ); Exit;
          end;
        END;
        start_from_operation := TRUE;
      end;
    FINALLY
      OpCanBeAtStartOfLine := FALSE;
    END;
    if not start_from_operation then
    begin
      if TokenEq( '(' ) then
      begin // (BC), (DE), (SP), (HL), (IX+n), (IY+n), (addr), ...
        ref1 := TRUE;
        ScanIncrement( Incs1Reg, TRUE );
        if ScanRegister( reg1, alt1 ) then
        begin
          CASE reg1 OF
          rIX, rIY: begin
                      if not ScanIncrement( Incs1Reg, FALSE ) then
                        if CheckTokenIn( [ '+', '-' ] ) then
                          off1 := Expression;
                      if TokenEq( ',' ) then SkipTo( ')' );
                    end;
          rBC, rDE, rHL, rSP: ;
          else begin Error( 'Wrong addressing' ); Exit; end;
          END;
          if Incs1Reg = none then ScanIncrement( Incs1Reg, FALSE );
        end
        else if Incs1Reg = none then
        begin
          reg1 := wImm;
          off1 := Expression;
        end else
        begin Error( 'Syntax unknown' ); Exit; end;
        Wait( ')' );
        if Incs1Opd = none then ScanIncrement( Incs1Opd, FALSE );
      end
      else if ScanRegister( reg1, alt1 ) then
      begin
        Incs1Reg := Incs1Opd;
        Incs1Opd := none;
        if Incs1Reg = none then ScanIncrement( Incs1Reg, FALSE );
      end;
      get_operation: do_scan_op := TRUE;
      if (Token^ in [ '&', '|', '^', '?' ]) and
         not(reg1 in [ rA ]) or
         (Token^ in [ '+', '-' ]) and
         not(reg1 in [ rA, rHL, rIX, rIY ]) then
         do_scan_op := FALSE;
      if do_scan_op and GetOperation_C_like( op, cf ) then
      begin //   ( ?)  
        if ScanIncrement( Incs2Opd, TRUE ) then
          do_scan_opd2 := TRUE;
      end
        else
      if (Incs1Reg = none) and (Incs1Opd = none) then
      begin
        Error( 'Waiting for operation' ); Exit;
      end;
    end
      else do_scan_opd2 := TRUE;
    CASE op OF
    oAdd, oSub, oAnd, oOr, oXor, oCmp, oEQ:
      do_scan_opd2 := TRUE;
    END;
    if op <> oNone then
    begin
      if TokenEq( '(' ) then
      begin
        ref2 := TRUE;
        ScanIncrement( Incs2Reg, TRUE );
        if ScanRegister( reg2, alt2 ) then
        begin
          CASE reg2 OF
          rIX, rIY: begin
                      if not ScanIncrement( Incs2Reg, FALSE ) then
                        if CheckTokenIn( [ '+', '-' ] ) then
                          off2 := Expression;
                      if TokenEq( ',' ) then SkipTo( ')' );
                    end;
          rBC, rDE, rHL, rSP: ;
          else begin Error( 'Wrong addressing' ); Exit; end;
          END;
          if Incs2Reg = none then ScanIncrement( Incs2Reg, FALSE );
        end
        else if Incs2Reg = none then
        begin
          reg2 := wImm;
          off2 := Expression;
        end else
        begin Error( 'Syntax unknown' ); Exit; end;
        Wait( ')' );
        if Incs2Opd = none then ScanIncrement( Incs2Opd, FALSE );
      end
      else if ScanRegister( reg2, alt2 ) then
      begin
        Incs2Reg := Incs2Opd;
        Incs2Opd := none;
        if Incs2Reg = none then ScanIncrement( Incs2Reg, FALSE );
      end
      else if do_scan_opd2 then
      begin
        if (Incs2Opd = none) and
           (Reg1 = noReg) and (op in [ oShl, oShr ]) then
        else if Incs2Opd = none then
        begin
          Reg2 := wImm;
          Off2 := Expression;
        end else begin Error( 'Waiting for operand' ); Exit; end;
      end;
    end;
    //    .
    //      :
    if Reg1 = noReg then
    CASE op OF
    oXchg: if not Ref2 and (Reg2 = rAF) then
           begin
             Reg1 := rAF;
             alt2 := TRUE;
           end;
    END;
    if Reg1 = noReg then
    CASE op OF
    oAdd, oSub:
      if not Ref2 then
      CASE Reg2 OF
      rBC, rDE, rHL, rSP: Reg1 := rHL;
      rB, rC, rD, rE, rH, rL, rM, rA:
        begin
          Reg1 := rA;
          alt1 := alt2;
        end;
      wImm:
        begin
          if Off2 <= 255 then Reg1 := rA
          else Error( 'Left operand not qualified' );
        end;
      else Error( 'Invalid second operand' ); Exit;
      END
      else
      CASE Reg2 OF
      rHL, rIX, rIY: Reg1 := rA;
      else Error( 'Invalid addressing' ); Exit;
      END;
    oAnd, oOr, oXor, oCmp:
      if not Ref2 then
      CASE Reg2 OF
      rB, rC, rD, rE, rH, rL, rM, rA, wImm:
        begin
          Reg1 := rA;
          alt1 := alt2;
        end;
      else Error( 'Invalid second operand' ); Exit;
      END
      else
      CASE Reg2 OF
      rHL, rIX, rIY: Reg1 := rA;
      else Error( 'Invalid addressing' ); Exit;
      END;
    oShl, oShr:
      begin
        Reg1 := Reg2; Reg2 := noReg;
        alt1 := alt2; alt2 := FALSE;
        off1 := off2; off2 := 0;
        if Reg1 = noReg then
          Reg1 := rA;
      end;
    else Error( 'Left operand required' ); Exit;
    END;
    if Reg1 = noReg then
    CASE op OF
    oAdd, oSub, oAnd, oOr, oXor:
      if not Ref2 then
      CASE Reg2 OF
      rBC, rDE, rHL, rSP: Reg1 := rHL;
      rIX: Reg1 := rIX;
      rIY: Reg1 := rIY;
      rB, rC, rD, rE, rH, rL, rM, rA: Reg1 := rA;
      END;
    oXchg:
      if not Ref2 and (Reg2 = rAF) then
      begin
        Reg1 := rAF;
        alt2 := TRUE;
      end;
    END;
    if Reg2 = noReg then
    CASE op OF
    oXchg:
      if not Ref1 and (Reg1 = rAF) then
      begin
        Reg2 := rAF;
        alt2 := TRUE;
      end;
    END;
    //       (AF),(BC,DE,HL),   -
    //   ,      
    //  :
    if (op <> oEQ) and (Reg1 <> noReg) and (Reg2 <> noReg) and
       (Kind[ Reg1 ] = Kind[ Reg2 ]) then
      if (alt1 <> alt2) and not (
         (op = oXchg) and not Ref1 and not Ref2 and (Reg1 = rAF) and (Reg2 = rAF)) then
      begin
        Error( 'Alternativity of registers must be the same for this operation' ); Exit;
      end;
    //     R1=R1    
    //    ( R1=R1+R2),    
    // R1+R2.
    if (Op = oEQ) and (Reg1 = Reg2) and (off1 = off2) and (alt1 = alt2) and
       (Incs1Reg = none) and (Incs1Opd = none) then
    begin
      if Token^ in [ '+', '-', '&', '|', '^' ] then
      begin
        Reg2 := noReg;
        off2 := 0;
        alt2 := FALSE;
        goto get_operation;
      end;
    end;
    //     ,    +CF  -CF
    //     /   :
    if not CF then
    CASE op OF
    oAdd: if (Token^ = '+') and NextEq( 'CF' ) then
          begin
            Next; Next; CF := TRUE;
          end;
    oSub: if (Token^ = '-') and NextEq( 'CF' ) then
          begin
            Next; Next; CF := TRUE;
          end;
    END;
    //     
    CASE Incs1Reg OF
    inc_prefix: DoIncDec( reg1, off1, FALSE, alt1, +1 );
    dec_prefix: DoIncDec( reg1, off1, FALSE, alt1, -1 );
    END;
    if ref1 then
    CASE Incs1Opd OF
    inc_prefix: DoIncDec( reg1, off1, TRUE, alt1, +1 );
    dec_prefix: DoIncDec( reg1, off1, TRUE, alt1, -1 );
    END;
    CASE Incs2Reg OF
    inc_prefix: DoIncDec( reg2, off2, FALSE, alt2, +1 );
    dec_prefix: DoIncDec( reg2, off2, FALSE, alt2, -1 );
    END;
    if ref2 then
    CASE Incs2Opd OF
    inc_prefix: DoIncDec( reg2, off2, TRUE, alt2, +1 );
    dec_prefix: DoIncDec( reg2, off2, TRUE, alt2, -1 );
    END;
    //   
    if (op = oXchg) and not Ref1 and not Ref2 and (Reg1 = rAF) and (Reg2 = rAF) and
       (alt1 <> alt2) then // AF><AF'
    begin
      OutByte( 8 );
      if (Incs1Reg <> none) or (Incs1Reg <> none) then
        Error( 'Increments and decrements are not allowed' );
    end
    else if op <> oNone then
    Begin
      if (op <> oEq) or (Kind[ Reg1 ] <> Kind[ Reg2 ]) then
      CASE Reg1 OF
      rA, rAF: if alt1 xor af_altered then Alter_AF;
      rBC, rDE, rHL, rB, rC, rD, rE, rH, rL, rM:
        if alt1 xor regs_altered then Alter_Regs;
      END;
      CASE Reg2 OF
      rA, rAF: if alt2 xor af_altered then Alter_AF;
      rBC, rDE, rHL, rB, rC, rD, rE, rH, rL, rM:
        if alt2 xor regs_altered then Alter_Regs;
      END;
      CASE op OF
      oAdd: if CF then
              C_like_ADC_SBC( $88, $4A, $CE )
            else //  ADD
              C_like_ADD_SUB( $80, $09, $C6, 'ADD' );
      oSub: if CF then
              C_like_ADC_SBC( $98, $42, $DE )
            else
            begin
              if Reg1 in [ rBC, rDE, rHL, rSP, rIX, rIY ] then
              begin
                OutByte( $A7 );
                C_like_ADC_SBC( $90, $42, $D6 );
              end
              else C_like_ADD_SUB( $90, 0, $D6, 'SUB' );
            end;
      oAnd: C_like_ADD_SUB( $A0, 0, $E6, 'AND' );
      oXor: C_like_ADD_SUB( $A8, 0, $EE, 'XOR' );
      oOr : C_like_ADD_SUB( $B0, 0, $F6, 'OR' );
      oCmp: C_like_ADD_SUB( $B8, 0, $FE, 'CP' );
      oShl: C_like_Shl( CF );
      oShr: C_like_Shr( CF );
      oXchg: C_like_Xchg;
      oEQ : C_like_Assign;
      else Error( 'Unknown operation' );
      END;
    End;
    //     
    CASE Incs1Reg OF
    inc_suffix: DoIncDec( reg1, off1, FALSE, alt1, +1 );
    dec_suffix: DoIncDec( reg1, off1, FALSE, alt1, -1 );
    END;
    if ref1 then
    CASE Incs1Opd OF
    inc_suffix: DoIncDec( reg1, off1, TRUE, alt1, +1 );
    dec_suffix: DoIncDec( reg1, off1, TRUE, alt1, -1 );
    END;
    CASE Incs2Reg OF
    inc_suffix: DoIncDec( reg2, off2, FALSE, alt2, +1 );
    dec_suffix: DoIncDec( reg2, off2, FALSE, alt2, -1 );
    END;
    if ref2 then
    CASE Incs2Opd OF
    inc_suffix: DoIncDec( reg2, off2, TRUE, alt2, +1 );
    dec_suffix: DoIncDec( reg2, off2, TRUE, alt2, -1 );
    END;
  FINALLY
    if af_altered then Alter_AF;
    if regs_altered then Alter_Regs;
    Handling_C_like := FALSE;
  END;
end;

procedure TZXCompiler.C_like_ADC_SBC(Base_R, Base_RP, Base_Imm: Byte);
begin
  if Ref1 then
  CASE Reg1 OF
  rSP: // ADC (SP), RP
       if Ref2 then Error( 'Right operand must be in register for ADC/SBC' )
       else
       CASE Reg2 OF
       rBC: OutBytes( [ $E3, $ED, Base_RP, $E3 ] );
       rDE: OutBytes( [ $E3, $ED, Base_RP+$10, $E3 ] );
       rHL: OutBytes( [ $EB, $E3, $ED, Base_RP+$20, $E3, $EB ] );
       rSP: OutBytes( [ $E3, $ED, Base_RP+$30, $E3 ] );
       else Error( 'Invalid right operand for ADC/SBC' )
       END;
  else Error( 'Invalid left operand for ADC/SBC' );
  END
  else
  CASE Reg1 OF
  rDE: // ADC DE, RP
       if Ref2 then Error( 'Right operand must be in register for ADC/SBC' )
       else
       CASE Reg2 OF
       rBC: OutBytes( [ $EB, $ED, Base_RP, $EB ] );
       rDE: OutBytes( [ $EB, $ED, Base_RP+$20, $EB ] );
       rHL: OutBytes( [ $EB, $ED, Base_RP+$10, $EB ] );
       rSP: OutBytes( [ $EB, $ED, Base_RP+$30, $EB ] );
       else Error( 'Invalid second operand for ADC' );
       END;
  rHL: // ADC HL, RP
       if Ref2 then Error( 'Right operand must be in register for ADC/SBC' )
       else
       CASE Reg2 OF
       rBC: OutBytes( [ $ED, Base_RP ] );
       rDE: OutBytes( [ $ED, Base_RP+$10 ] );
       rHL: OutBytes( [ $ED, Base_RP+$20 ] );
       rSP: OutBytes( [ $ED, Base_RP+$30 ] );
       else Error( 'Invalid right operand for ADC/SBC' )
       END;
  rA:  // ADC A, r | ADC A, #b
       if Ref2 then
       CASE Reg2 OF
       rHL: OutByte( Base_R+6 );
       rIX: OutBytes( [ $DD, Base_R+6, off2 ] );
       rIY: OutBytes( [ $FD, Base_R+6, off2 ] );
       else Error( 'Invalid right operand for ADC/SBC' );
       END
       else
       CASE Reg2 OF
       rB, rC, rD, rE, rH, rL, rM, rA:
         OutByte( Base_R + Ord( Reg2 ) - Ord( rB ) );
       rIXH: OutBytes( [ $DD, Base_R + 4 ] );
       rIXL: OutBytes( [ $DD, Base_R + 5 ] );
       rIYH: OutBytes( [ $FD, Base_R + 4 ] );
       rIYL: OutBytes( [ $FD, Base_R + 5 ] );
       wImm: OutBytes( [ Base_Imm, off2 ] );
       else Error( 'Invalid right operand for ADC' )
       END;
  else Error( 'Invalid left operand for ADC/SBC (DE, HL, (SP) or A allowed)' );
  END;
end;

procedure TZXCompiler.C_like_ADD_SUB(Base_R, Base_RP, Base_Imm: Byte; const op_name: String);
begin
  if (Base_RP = 0) and (Reg1 in [ rBC, rDE, rHL, rSP, rIX, rIY ]) then
  begin
    Error( 'Invalid left operand for ' + op_name );
    Exit;
  end;
  if Ref1 then
  CASE Reg1 OF
  rSP: // ADD (SP), RP
       if Ref2 then Error( 'Right operand must be in register for ' + op_name )
       else
       CASE Reg2 OF
       rBC: OutBytes( [ $E3, Base_RP, $E3 ] );
       rDE: OutBytes( [ $E3, Base_RP+$10, $E3 ] );
       rHL: OutBytes( [ $EB, $E3, Base_RP+$20, $E3, $EB ] );
       rSP: OutBytes( [ $E3, Base_RP+$30, $E3 ] );
       else Error( 'Invalid right operand for ' + op_name );
       END;
  else Error( 'Invalid left operand for ' + op_name );
  END
  else
  CASE Reg1 OF
  rDE: // ADD DE, RP
       if Ref2 then Error( 'Right operand must be in register for ' + op_name )
       else
       CASE Reg2 OF
       rBC: OutBytes( [ $EB, Base_RP, $EB ] );
       rDE: OutBytes( [ $EB, Base_RP+$20, $EB ] );
       rHL: OutBytes( [ $EB, Base_RP+$10, $EB ] );
       rSP: OutBytes( [ $EB, Base_RP+$30, $EB ] );
       else Error( 'Invalid second operand for ' + op_name );
       END;
  rHL: // ADD HL, RP
       if Ref2 then Error( 'Right operand must be in register for ' + op_name )
       else
       CASE Reg2 OF
       rBC: OutBytes( [ Base_RP ] );
       rDE: OutBytes( [ Base_RP+$10 ] );
       rHL: OutBytes( [ Base_RP+$20 ] );
       rSP: OutBytes( [ Base_RP+$30 ] );
       else Error( 'Invalid right operand for ' + op_name );
       END;
  rIX: // ADD IX, RP
       if Ref2 then Error( 'Right operand must be in register for ' + op_name )
       else
       CASE Reg2 OF
       rBC: OutBytes( [ $DD, Base_RP ] );
       rDE: OutBytes( [ $DD, Base_RP+$10 ] );
       rIX: OutBytes( [ $DD, Base_RP+$20 ] );
       rSP: OutBytes( [ $DD, Base_RP+$30 ] );
       else Error( 'Invalid right operand for ADD/SUB' );
       END;
  rIY: // ADD IY, RP
       if Ref2 then Error( 'Right operand must be in register for ' + op_name )
       else
       CASE Reg2 OF
       rBC: OutBytes( [ $FD, Base_RP ] );
       rDE: OutBytes( [ $FD, Base_RP+$10 ] );
       rIY: OutBytes( [ $FD, Base_RP+$20 ] );
       rSP: OutBytes( [ $FD, Base_RP+$30 ] );
       else Error( 'Invalid right operand for ' + op_name );
       END;
  rA:  // ADD A, r | ADD A, #b  SUB
       if Ref2 then
       CASE Reg2 OF
       rHL: OutByte( Base_R+6 );
       rIX: OutBytes( [ $DD, Base_R+6, off2 ] );
       rIY: OutBytes( [ $FD, Base_R+6, off2 ] );
       else Error( 'Invalid right operand for ' + op_name );
       END
       else
       CASE Reg2 OF
       rB, rC, rD, rE, rH, rL, rM, rA:
         OutByte( Base_R + Ord( Reg2 ) - Ord( rB ) );
       rIXH: OutBytes( [ $DD, Base_R + 4 ] );
       rIXL: OutBytes( [ $DD, Base_R + 5 ] );
       rIYH: OutBytes( [ $FD, Base_R + 4 ] );
       rIYL: OutBytes( [ $FD, Base_R + 5 ] );
       wImm: OutBytes( [ Base_Imm, off2 ] );
       else Error( 'Invalid right operand for ' + op_name )
       END;
  else Error( 'Invalid left operand for ' + op_name + ' (DE or HL or A allowed)' );
  END;
end;

procedure TZXCompiler.C_like_Assign;
begin
  if Ref1 then
  CASE Reg1 OF
  rHL: if Ref2 then Error( 'Invalid right operand addressing' )
       else
       CASE Reg2 OF
       wImm: OutBytes( [ $36, off2 ] );
       rB, rC, rD, rE, rH, rL, rA:
         begin
           if (alt1 <> alt2) and (Reg2 <> rA) then
             Error( 'Invalid operands alternativity' );
           OutBytes( [ $70 + Ord( Reg2 ) - Ord( rB ) ] );
         end;
       else Error( 'Right operand invalid' );
       END;
  rDE: if Ref2 then Error( 'Invalid right operand addressing' )
       else
       CASE Reg2 OF
       wImm: OutBytes( [ $EB, $36, off2, $EB ] );
       rB, rC, rD, rE, rH, rL:
         begin
           if alt1 <> alt2 then
             Error( 'Invalid operands alternativity' );
           OutBytes( [ $EB, $70 + Ord( Reg2 ) - Ord( rB ), $EB ] );
         end;
       rA: OutByte( $12 );
       else Error( 'Right operand invalid' );
       END;
  rBC: if Ref2 then Error( 'Invalid right operand addressing' )
       else
       CASE Reg2 OF
       rA: OutByte( $02 );
       else Error( 'Right operand invalid' );
       END;
  rIX: if Ref2 then Error( 'Invalid right operand addressing' )
       else
       CASE Reg2 OF
       wImm: OutBytes( [ $DD, $36, off1, off2 ] );
       rB, rC, rD, rE, rH, rL, rA:
         OutBytes( [ $DD, $70 + Ord( Reg2 ) - Ord( rB ), off1 ] );
       rBC: OutBytes( [ $DD, $71, off1, $DD, $70, off1+1 ] );
       rDE: OutBytes( [ $DD, $73, off1, $DD, $72, off1+1 ] );
       rHL: OutBytes( [ $DD, $75, off1, $DD, $74, off1+1 ] );
       else Error( 'Right operand invalid' );
       END;
  rIY: if Ref2 then Error( 'Invalid right operand addressing' )
       else
       CASE Reg2 OF
       wImm: OutBytes( [ $FD, $36, off2 ] );
       rB, rC, rD, rE, rH, rL, rA:
         OutBytes( [ $FD, $70 + Ord( Reg2 ) - Ord( rB ), off1 ] );
       rBC: OutBytes( [ $FD, $71, off1, $FD, $70, off1+1 ] );
       rDE: OutBytes( [ $FD, $73, off1, $FD, $72, off1+1 ] );
       rHL: OutBytes( [ $FD, $75, off1, $FD, $74, off1+1 ] );
       else Error( 'Right operand invalid' );
       END;
  wImm: if Ref2 then Error( 'Invalid right operand addressing' )
        else
        CASE Reg2 OF
        rBC: OutBytes( [ $ED, $43, off1, off1 shr 8 ] );
        rDE: OutBytes( [ $ED, $53, off1, off1 shr 8 ] );
        rHL: OutBytes( [ $22, off1, off1 shr 8 ] );
        rSP: OutBytes( [ $ED, $73, off1, off1 shr 8 ] );
        rIX: OutBytes( [ $DD, $22, off1, off1 shr 8 ] );
        rIY: OutBytes( [ $FD, $22, off1, off1 shr 8 ] );
        rA : OutBytes( [ $32, off1, off1 shr 8 ] );
        else Error( 'Right operand invalid' );
        END;
  else Error( 'Left operand invalid addressing' );
  END
  else
  CASE Reg1 OF
  rA : if Ref2 then
       CASE Reg2 OF
       rBC: OutByte( $0A );
       rDE: OutByte( $1A );
       rHL: OutByte( $7E );
       rIX: OutBytes( [ $DD, $7E, off2 ] );
       rIY: OutBytes( [ $FD, $7E, off2 ] );
       wImm: OutBytes( [ $3A, off2, off2 shr 8 ] );
       else Error( 'Invalid right operand addressing' );
       END
       else
       CASE Reg2 OF
       rA: if alt1 <> alt2 then
             Error( 'Invalid operands alternativity' )
           else ; // LD A,A -  
       rB, rC, rD, rE, rH, rL, rM:
         OutByte( $78 + Ord( Reg2 ) - Ord( rB ) );
       rIXH: OutBytes( [ $DD, $7C ] );
       rIXL: OutBytes( [ $DD, $7D ] );
       rIYH: OutBytes( [ $FD, $7C ] );
       rIYL: OutBytes( [ $FD, $7D ] );
       wImm: OutBytes( [ $3E, off2 ] );
       rI  : OutBytes( [ $ED, $57 ] );
       rR  : OutBytes( [ $ED, $5F ] );
       else Error( 'Invalid right operand' );
       END;
  rM:  if Ref2 then Error( 'Invalid right operand addressing' )
       else
       CASE Reg2 OF
       wImm: OutBytes( [ $36, off2 ] );
       rB, rC, rD, rE, rH, rL, rA:
         begin
           if (alt1 <> alt2) and (Reg2 <> rA) then
             Error( 'Invalid operands alternativity' );
           OutBytes( [ $70 + Ord( Reg2 ) - Ord( rB ) ] );
         end;
       else Error( 'Right operand invalid' );
       END;
  rB, rC, rD, rE, rH, rL:
       if Ref2 then
       CASE Reg2 OF
       rHL: OutByte( $46 + 8 * (Ord( Reg1 ) - Ord( rB )) );
       rIX: OutBytes( [ $DD, $46 + 8 * (Ord( Reg1 ) - Ord( rB )), off2 ] );
       rIY: OutBytes( [ $FD, $46 + 8 * (Ord( Reg1 ) - Ord( rB )), off2 ] );
       else Error( 'Right operand invalid addressing' );
       END
       else
       begin
         if (alt1 <> alt2) and not(Reg2 in [ rA, wImm ] ) then
           Error( 'Invalid operands alternativity' );
         //if Reg1 <> Reg2 then
         CASE Reg2 OF
         wImm: OutBytes( [ $06 + 8 * ( Ord( Reg1 ) - Ord( rB ) ), off2 ] );
         rB, rC, rD, rE, rH, rL, rM, rA:
           OutBytes( [ $40 + 8 * (Ord( Reg1 ) - Ord( rB )) + Ord( Reg2 ) - Ord( rB ) ] );
         rIXH: if Reg1 in [ rH, rL ] then Error( 'Invalid operands' )
               else OutBytes( [ $DD, $40 + 8 * (Ord( Reg1 ) - Ord(rB)) + 4 ] );
         rIXL: if Reg1 in [ rH, rL ] then Error( 'Invalid operands' )
               else OutBytes( [ $DD, $40 + 8 * (Ord( Reg1 ) - Ord(rB)) + 5 ] );
         rIYH: if Reg1 in [ rH, rL ] then Error( 'Invalid operands' )
               else OutBytes( [ $FD, $40 + 8 * (Ord( Reg1 ) - Ord(rB)) + 4 ] );
         rIYL: if Reg1 in [ rH, rL ] then Error( 'Invalid operands' )
               else OutBytes( [ $FD, $40 + 8 * (Ord( Reg1 ) - Ord(rB)) + 5 ] );
         else Error( 'Invalid right operand' );
         END;
       end;
  rIXH: if Ref2 then Error( 'Invalid right operand addressing' )
        else
        CASE Reg2 OF
        wImm: OutBytes( [ $DD, $26, off2 ] );
        rB, rC, rD, rE, rA:
          OutBytes( [ $DD, $60 + Ord( Reg2 ) - Ord( rB ) ] );
        rIXH: OutBytes( [ $DD, $64 ] );
        rIXL: OutBytes( [ $DD, $65 ] );
        else Error( 'Invalid right operand' );
        END;
  rIXL: if Ref2 then Error( 'Invalid right operand addressing' )
        else
        CASE Reg2 OF
        wImm: OutBytes( [ $DD, $36, off2 ] );
        rB, rC, rD, rE, rA:
          OutBytes( [ $DD, $68 + Ord( Reg2 ) - Ord( rB ) ] );
        rIXH: OutBytes( [ $DD, $6C ] );
        rIXL: OutBytes( [ $DD, $6D ] );
        else Error( 'Invalid right operand' );
        END;
  rIYH: if Ref2 then Error( 'Invalid right operand addressing' )
        else
        CASE Reg2 OF
        wImm: OutBytes( [ $FD, $26, off2 ] );
        rB, rC, rD, rE, rA:
          OutBytes( [ $FD, $60 + Ord( Reg2 ) - Ord( rB ) ] );
        rIYH: OutBytes( [ $FD, $64 ] );
        rIYL: OutBytes( [ $FD, $65 ] );
        else Error( 'Invalid right operand' );
        END;
  rIYL: if Ref2 then Error( 'Invalid right operand addressing' )
        else
        CASE Reg2 OF
        wImm: OutBytes( [ $FD, $36, off2 ] );
        rB, rC, rD, rE, rA:
          OutBytes( [ $FD, $68 + Ord( Reg2 ) - Ord( rB ) ] );
        rIYH: OutBytes( [ $FD, $6C ] );
        rIYL: OutBytes( [ $FD, $6D ] );
        else Error( 'Invalid right operand' );
        END;
  rI  : if Ref2 or (Reg2 <> rA) then Error( 'Invalid right operand' )
        else OutBytes( [ $ED, $47 ] );
  rR  : if Ref2 or (Reg2 <> rA) then Error( 'Invalid right operand' )
        else OutBytes( [ $ED, $4F ] );
  rBC : if Ref2 then
        CASE Reg2 OF
        wImm: OutBytes( [ $ED, $4B, off2, off2 shr 8 ] );
        rHL : OutBytes( [ $4E, $23, $46, $2B ] );
        rIX : OutBytes( [ $DD, $4E, off2, $DD, $46, off2+1 ] );
        rIY : OutBytes( [ $FD, $4E, off2, $FD, $46, off2+1 ] );
        else Error( 'Invalid right operand addressing' );
        END
        else
        CASE Reg2 OF
        wImm: OutBytes( [ $01, off2, off2 shr 8 ] );
        rAF : OutBytes( [ $F5, $C1 ] );
        rBC : ;
        rDE : OutBytes( [ $42, $4B ] );
        rHL : OutBytes( [ $44, $4D ] );
        rIX : OutBytes( [ $DD, $44, $DD, $4D ] );
        rIY : OutBytes( [ $FD, $44, $FD, $4D ] );
        else Error( 'Invalid right operand' );
        END;
  rDE : if Ref2 then
        CASE Reg2 OF
        wImm: OutBytes( [ $ED, $5B, off2, off2 shr 8 ] );
        rHL : OutBytes( [ $5E, $23, $56, $2B ] );
        rIX : OutBytes( [ $DD, $5E, off2, $DD, $56, off2+1 ] );
        rIY : OutBytes( [ $FD, $5E, off2, $FD, $56, off2+1 ] );
        else Error( 'Invalid right operand addressing' );
        END
        else
        CASE Reg2 OF
        wImm: OutBytes( [ $11, off2, off2 shr 8 ] );
        rAF : OutBytes( [ $F5, $D1 ] );
        rBC : OutBytes( [ $50, $59 ] );
        rDE : ;
        rHL : OutBytes( [ $54, $5D ] );
        rIX : OutBytes( [ $DD, $54, $DD, $5D ] );
        rIY : OutBytes( [ $FD, $54, $FD, $5D ] );
        rSP : OutBytes( [ $EB, $21, 0, 0, $39, $EB ] );
        else Error( 'Invalid right operand' );
        END;
  rHL : if Ref2 then
        CASE Reg2 OF
        wImm: OutBytes( [ $2A, off2, off2 shr 8 ] );
        rDE : OutBytes( [ $EB, $5E, $23, $56, $2B, $EB ] );
        rIX : OutBytes( [ $DD, $6E, off2, $DD, $66, off2+1 ] );
        rIY : OutBytes( [ $FD, $6E, off2, $FD, $66, off2+1 ] );
        else Error( 'Invalid right operand addressing' );
        END
        else
        CASE Reg2 OF
        wImm: OutBytes( [ $21, off2, off2 shr 8 ] );
        rAF : OutBytes( [ $F5, $E1 ] );
        rBC : OutBytes( [ $60, $69 ] );
        rDE : OutBytes( [ $62, $6B ] );
        rHL : ;
        rIX : OutBytes( [ $DD, $E5, $E1 ] );
        rIY : OutBytes( [ $FD, $E5, $E1 ] );
        rSP : OutBytes( [ $21, 0, 0, $39 ] );
        else Error( 'Invalid right operand' );
        END;
  rIX : if Ref2 then
        CASE Reg2 OF
        wImm: OutBytes( [ $DD, $2A, off2, off2 shr 8 ] );
        else Error( 'Invalid right operand addressing' );
        END
        else
        CASE Reg2 OF
        wImm: OutBytes( [ $DD, $21, off2, off2 shr 8 ] );
        rAF : OutBytes( [ $F5, $DD, $E1 ] );
        rBC : OutBytes( [ $C5, $DD, $E1 ] );
        rDE : OutBytes( [ $D5, $DD, $E1 ] );
        rHL : OutBytes( [ $E5, $DD, $E1 ] );
        rIX : ;
        rIY : OutBytes( [ $FD, $E5, $DD, $E1 ] );
        rSP : OutBytes( [ $DD, $21, 0, 0, $DD, $39 ] );
        else Error( 'Invalid right operand' );
        END;
  rIY : if Ref2 then
        CASE Reg2 OF
        wImm: OutBytes( [ $FD, $2A, off2, off2 shr 8 ] );
        else Error( 'Invalid right operand addressing' );
        END
        else
        CASE Reg2 OF
        wImm: OutBytes( [ $FD, $21, off2, off2 shr 8 ] );
        rAF : OutBytes( [ $F5, $FD, $E1 ] );
        rBC : OutBytes( [ $C5, $FD, $E1 ] );
        rDE : OutBytes( [ $D5, $FD, $E1 ] );
        rHL : OutBytes( [ $E5, $FD, $E1 ] );
        rIX : ;
        rIY : OutBytes( [ $FD, $E5, $FD, $E1 ] );
        rSP : OutBytes( [ $FD, $21, 0, 0, $FD, $39 ] );
        else Error( 'Invalid right operand' );
        END;
  rSP : if Ref2 then
        CASE Reg2 OF
        wImm: OutBytes( [ $ED, $7B, off2, off2 shr 8 ] );
        else Error( 'Invalid right operand addressing' );
        END
        else
        CASE Reg2 OF
        wImm: OutBytes( [ $31, off2, off2 shr 8 ] );
        rDE : OutBytes( [ $EB, $F9, $EB ] );
        rHL : OutByte( $F9 );
        rIX : OutBytes( [ $DD, $F9 ] );
        rIY : OutBytes( [ $FD, $F9 ] );
        rSP : ;
        else Error( 'Invalid right operand' );
        END;
  rAF : if Ref2 then Error( 'Invalid right operand addressing' );
        else
        CASE Reg2 OF
        rBC : OutBytes( [ $C5, $F1 ] );
        rDE : OutBytes( [ $D5, $F1 ] );
        rHL : OutBytes( [ $E5, $F1 ] );
        rIX : OutBytes( [ $DD, $E5, $F1 ] );
        rIY : OutBytes( [ $FD, $E5, $F1 ] );
        else Error( 'Invalid right operand' );
        END;
  END;
end;

procedure TZXCompiler.C_like_Shl(CF: Boolean);
begin
  if Ref1 then
  CASE Reg1 OF
  rHL: if CF then OutBytes( [ $CB, $06 ] )  // RLC (HL)
             else OutBytes( [ $CB, $16 ] ); // RL (HL)
  rIX: if CF then OutBytes( [ $DD, $CB, off1, $06 ] )  // RLC (IX+off1)
             else OutBytes( [ $DD, $CB, off1, $16 ] ); // RL (IX+off1)
  rIY: if CF then OutBytes( [ $FD, $CB, off1, $06 ] )  // RLC (IY+off1)
             else OutBytes( [ $FD, $CB, off1, $16 ] ); // RL (IY+off1)
  else Error( 'Invalid operand for shift' );
  END
  else
  CASE Reg1 OF
  rA: if CF then OutByte( $07 )  // RLCA
            else OutByte( $17 ); // RLA
  rB, rC, rD, rE, rH, rL, rM:
        if CF then OutBytes( [ $CB, $00 + Ord( Reg1 ) - Ord( rB ) ] )
              else OutBytes( [ $CB, $10 + Ord( Reg1 ) - Ord( rB ) ] );
  rBC:  if CF then OutBytes( [ $CB, $11, $CB, $10 ] )  // RL C : RL B
              else OutBytes( [ $CB, $01, $CB, $10 ] ); // RLC C : RL B
  rDE:  if CF then OutBytes( [ $CB, $13, $CB, $12 ] )  // RL E : RL D
              else OutBytes( [ $CB, $03, $CB, $12 ] ); // RLC E : RL D
  rHL:  if CF then OutBytes( [ $CB, $15, $CB, $14 ] )  // RL L : RL H
              else OutBytes( [ $CB, $05, $CB, $14 ] ); // RLC L : RL H
  else Error( 'Invalid operand for shift' );
  END;
end;

procedure TZXCompiler.C_like_Shr(CF: Boolean);
begin
  if Ref1 then
  CASE Reg1 OF
  rHL: if CF then OutBytes( [ $CB, $0E ] )  // RRC (HL)
             else OutBytes( [ $CB, $1E ] ); // RR (HL)
  rIX: if CF then OutBytes( [ $DD, $CB, off1, $0E ] )  // RRC (IX+off1)
             else OutBytes( [ $DD, $CB, off1, $1E ] ); // RR (IX+off1)
  rIY: if CF then OutBytes( [ $FD, $CB, off1, $0E ] )  // RRC (IY+off1)
             else OutBytes( [ $FD, $CB, off1, $1E ] ); // RR (IY+off1)
  else Error( 'Invalid operand for shift' );
  END
  else
  CASE Reg1 OF
  rA: if CF then OutByte( $0F )  // RRCA
            else OutByte( $1F ); // RRA
  rB, rC, rD, rE, rH, RR, rM:
        if CF then OutBytes( [ $CB, $18 + Ord( Reg1 ) - Ord( rB ) ] )
              else OutBytes( [ $CB, $08 + Ord( Reg1 ) - Ord( rB ) ] );
  rBC:  if CF then OutBytes( [ $CB, $18, $CB, $19 ] )  // RR B : RR C
              else OutBytes( [ $CB, $08, $CB, $19 ] ); // RRC B : RR C
  rDE:  if CF then OutBytes( [ $CB, $1A, $CB, $1B ] )  // RR D : RR E
              else OutBytes( [ $CB, $0A, $CB, $1B ] ); // RRC D : RR E
  rHL:  if CF then OutBytes( [ $CB, $1C, $CB, $1D ] )  // RR H : RR L
              else OutBytes( [ $CB, $0C, $CB, $1D ] ); // RRC H : RR L
  else Error( 'Invalid operand for shift' );
  END;
end;

procedure TZXCompiler.C_like_Xchg;
var TmpReg: TRegister;
    TmpAlt: Boolean;
    TmpRef: Boolean;
begin
  if ((Reg2 = rSP) and Ref2 or (Reg2 in [ rAF, rBC, rDE ]) and not ref2) and
     (Reg1 in [ rHL, rIX, rIY ]) and not Ref1 then
  begin
    TmpReg := Reg1; Reg1 := Reg2; Reg2 := TmpReg;
    TmpRef := Ref1; Ref1 := Ref2; Ref2 := TmpRef;
    TmpAlt := alt1; alt1 := alt2; alt2 := TmpAlt;
    Swap( Off1, Off2 );
  end;
  if Ref1 then
  CASE Reg1 OF
  rSP: // EX (SP), rp
       if Ref2 then Error( 'Right operand for EX must be in register' )
       else
       CASE Reg2 OF
       rAF: OutBytes( [ $E3, $F5, $E3, $F1, $E3 ] );
       rBC: OutBytes( [ $E3, $C5, $E3, $C1, $E3 ] );
       rDE: OutBytes( [ $EB, $E3, $EB ] );
       rHL: OutByte( $E3 );
       rIX: OutBytes( [ $DD, $E3 ] );
       rIY: OutBytes( [ $FD, $E3 ] );
       else Error( 'Operands invalid' );
       END;
  else Error( 'Operands invalid' );
  END
  else
  CASE Reg1 OF
  rAF: if Ref2 then Error( 'Operands invalid' )
       else
       CASE Reg2 OF
       rHL: OutBytes( [ $F5, $E3, $F1 ] );
       rIX: OutBytes( [ $F5, $DD, $E3, $F1 ] );
       rIY: OutBytes( [ $F5, $FD, $E3, $F1 ] );
       rDE: OutBytes( [ $EB, $F5, $E3, $F1, $EB ] );
       END;
  rBC: if Ref2 then Error( 'Operands invalid' )
       else
       CASE Reg2 OF
       rHL: OutBytes( [ $C5, $E3, $C1 ] );
       rIX: OutBytes( [ $C5, $DD, $E3, $C1 ] );
       rIY: OutBytes( [ $C5, $FD, $E3, $C1 ] );
       rDE: OutBytes( [ $EB, $C5, $E3, $C1, $EB ] );
       END;
  rDE: if Ref2 then Error( 'Operands invalid' )
       else
       CASE Reg2 OF
       rHL: OutByte( $EB );
       rIX: OutBytes( [ $DD, $EB ] );
       rIY: OutBytes( [ $FD, $EB ] );
       else Error( 'Operands invalid' );
       END;
  else Error( 'Operands invalid' );
  END;
end;

destructor TZXCompiler.Destroy;
var i: Integer;
begin
  IncludeDirs.Free;
  for i := 0 to IncludeSources.Count-1 do
    FreeMem( PChar( IncludeSources.Objects[ i ] ) );
  IncludeSources.Free;
  IncludeStack.Free;
  IncludeStkPos.Free;
  Labels.Free;
  Undefined.Free;
  Defines.Free;
  MacroList.Free;
  CmdLens.Free;
  StkBreakCont.Free;
  LoopLabel := '';
  FreeAllAllocated;
  inherited;
end;

procedure TZXCompiler.DirectiveAssign(i: Integer);
var w: Word;
begin
  w := Expression;
  if (Pass = 0) or (i >= 0) and (Labels.Objects[ i ] and Variable_Flag <> 0) then
  begin
    if Skip_Level = 0 then
      Labels.Objects[ i ] := w or Variable_Flag;
  end
  else if i >= 0 then
    Error( 'Name ' + Labels.Items[ i ] + ' is not a variable' );
end;

procedure TZXCompiler.DirectiveBREAK( cond: Integer; Long: Boolean );
begin
  if StkBreakCont.Count = 0 then
  begin
    Error( 'BREAK out of WHILE' ); Exit;
  end;
  DoBreakContinue( 1, cond, Long );
end;

procedure TZXCompiler.DirectiveCONTINUE( cond: Integer; Long: Boolean );
begin
  if StkBreakCont.Count = 0 then
  begin
    Error( 'CONTINUE out of WHILE' ); Exit;
  end;
  DoBreakContinue( 0, cond, Long );
end;

procedure TZXCompiler.DirectiveCTEXT;
var b: Byte;
    s, s1: PChar;
begin
  if Cur^ = ';' then
    while not( Cur^ in [ #13,#10,#0 ] ) do inc( Cur );
  if (Cur^ <= ' ') and (Cur^ <> #0) then
  begin
    if Cur^ = #13 then
    begin
      inc( Cur ); if Cur^ = #10 then inc( Cur );
    end
    else inc( Cur );
  end;
  //  
  while Cur^ <> #0 do
  begin
    if SEq( Cur, 7, 'ENDTEXT' ) then
    begin
      inc( Cur, 7 ); break;
    end;
    s := Cur;
    while not ( Cur^ in [ #13, #10, #0 ] ) do
    begin
      inc( Cur );
    end;
    s1 := Cur;
    while (DWORD( s1 ) > DWORD( s )) and
          (s1^ in [ #0..' ' ]) do dec( s1 );
    while DWORD( s ) <= DWORD( s1 ) do
    begin
      if s^ in [ #13, #10 ] then b := Byte( ' ' )
      else b := Byte( Encode[ s^ ] );
      if DWORD( s ) = DWORD( s1 ) then b := b or $80;
      OutByte( b );
      inc( s );
    end;
    if Cur^ in [#13,#10] then
    begin
      if Cur^ = #13 then
      begin
        inc( Cur ); if Cur^ = #10 then inc( Cur );
      end
      else inc( Cur );
      Token := Cur;
      ReplaceDefines;
    end;
  end;
  Next;
end;

procedure TZXCompiler.DirectiveDEFB( Bit7On: Boolean );
var b: Byte;
    r: Word;
    Buffer: String;
    i: Integer;
begin
  while Token^ <> #0 do
  begin
    r := 1;
    if TokenEq( '(' ) then
    begin
      NeedAllValues := TRUE;
      r := Expression;
      NeedAllValues := FALSE;
      Wait( ')' );
    end;
    if TokenEq( '?' ) then
      for r := r downto 1 do IncAddr
    else if Token^ in [ '''', '"' ] then
    begin
      Cur := Token + 1;
      Buffer := '';
      while not( Cur^ in [ Token^, #13, #10, #0 ] ) do
      begin
        b := Ord( Encode[ Cur^ ] );
        if Bit7On and (Cur[ 1 ] = Token^) then b := b or $80;
        Buffer := Buffer + Char( b );
        inc( Cur );
      end;
      if Cur^ = Token^ then inc( Cur )
      else Error( 'Unterminated string' );
      for r := r downto 1 do
        for i := 1 to Length( Buffer ) do
          OutByte( Byte( Buffer[ i ] ) );
      Next;
    end
    else
    begin
      b := Expression;
      for r := r downto 1 do OutByte( b );
    end;
    if not TokenEq( ',' ) then break;
  end;
end;

procedure TZXCompiler.DirectiveDEFD;
var b: Byte;
    wait_comma, first_item: Boolean;
begin
  wait_comma := TRUE;
  first_item := TRUE;
  while Token^ <> #0 do
  begin
    if Upper[ Token^ ] in [ '0'..'9','A'..'F' ] then
    begin
      while Upper[ Token^ ] in [ '0'..'9','A'..'F' ] do
      begin
        if Token^ in [ '0'..'9' ] then
          b := (Ord( Token^ ) - Ord( '0' )) * 16
        else b := (Ord( Upper[ Token^ ] ) - Ord( 'A' ) + 10) * 16;
        inc( Token );
        if Upper[ Token^ ] in [ '0'..'9', 'A'..'F' ] then
        begin
          if Token^ in [ '0'..'9' ] then
            b := b + Ord( Token^ ) - Ord( '0' )
          else b := b + Ord( Upper[ Token^ ] ) - Ord( 'A' ) + 10;
          inc( Token );
        end;
        OutByte( b );
      end;
      Cur := Token; Next;
    end
    else
    begin
      b := Expression; OutByte( b );
    end;
    if wait_comma then
    begin
      if not CheckTokenEq( ',' ) and first_item then wait_comma := FALSE;
    end;
    if wait_comma and not TokenEq( ',' ) then break;
    if not( Upper[ Token^ ] in [ '0'..'9','A'..'F' ] ) then break;
    first_item := FALSE;
  end;
end;

procedure TZXCompiler.DirectiveDEFG;
var b: Byte;
    s: PChar;
    sBuffer: PByteArray;
    sLen, line_w, lines: Integer;
    first_line: Boolean;
    y, x, i: Integer;
    num_scanned: Boolean;
begin
  s := Token;
  sBuffer := AllocMemFast( 0 );
  sLen := 0;
  first_line := TRUE;
  line_w := 1;
  lines := 0;
  while TRUE do
  begin
    b := 0;
    num_scanned := FALSE;
    if (s^ in [ '0'..'9', 'A'..'F', 'a'..'f', '%', '#' ]) or
       (s^ = '$') and (Options and Option_BaxHex <> 0) then
    begin
      Cur := s; Next;
      b := Number; s := Token;
      num_scanned := TRUE;
    end
    else
    while s^ > ' ' do
    begin
      b := b shl 1;
      if s^ <> '.' then b := b or 1;
      inc( s );
    end;
    //OutByte( b );
    sBuffer := ReallocateMemFast( sBuffer, sLen + 1 );
    sBuffer[ sLen ] := b; inc( sLen );
    while (s^ <= ' ') and not(s^ in [ #13, #10, #0 ]) do inc( s );
    if (s^ in [ #13, #10, #0 ]) or num_scanned and AtStartOfLine then
    begin
      inc( lines );
      if first_line then
      begin
        line_w := sLen;
        first_line := FALSE;
      end;
      if not num_scanned then
      begin
        Cur := s; Next;
        s := Token;
      end;
      if not (s^ in [ '.', 'X', 'x' ]) then break;
    end;
  end;
  for x := 0 to line_w-1 do
  begin
    for y := 0 to lines-1 do
    begin
      i := x + y * line_w;
      if i < sLen then OutByte( sBuffer[ i ] );
    end;
  end;
  {sBuffer :=} ReallocateMemFast( sBuffer, 0 );
end;

procedure TZXCompiler.DirectiveDefine;
var p: String;
    m: PChar;
    aName: PChar;
    aLen: Integer;
begin
  aName := Token;
  aLen := Len; Next; Next;
  Cur := Token;
  while not( Cur^ in [ #13, #10, #0 ] ) do inc( Cur );
  SetString( p, Token, DWORD( Cur ) - DWORD( Token ) );
  //Labels.Objects[ i ] := Define_Marker;
  m := GetMemFast( Length( p ) + 1 );
  move( p[ 1 ], m^, Length( p ) + 1 );
  Defines.AddObject( aName, aLen, DWORD( m ) );
  Next;
end;

procedure TZXCompiler.DirectiveDEFS;
var r, b, L: Integer;
    sBuffer, s: PChar;
    sLen: Integer;
    i: Integer;
begin
  r := Expression;
  sLen := 0;
  sBuffer := AllocMemFast( 1 );
  if TokenEq( ',' ) then
  while Token^ <> #0 do
  begin
    if Token^ in [ '''', '"' ] then
    begin
      s := Token; inc( Token );
      while not( Token^ in [ s^, #13, #10, #0 ] ) do inc( Token );
      L := DWORD( Token ) - DWORD( s ) - 1;
      if L > 0 then
      begin
        sBuffer := ReallocateMemFast( sBuffer, sLen + L + 1 );
        for i := 1 to L do
          sBuffer[ sLen + i - 1 ] := Encode[ s[ i ] ];
        //Move( s[ 1 ], sBuffer[ sLen ], L );
        inc( sLen, L ); sBuffer[ sLen ] := #0;
      end;
      if Token^ = s^ then inc( Token );
      Cur := Token; Next;
    end
      else
    begin
      b := Expression;
      sBuffer := ReallocateMemFast( sBuffer, sLen + 2 );
      sBuffer[ sLen ] := Char( b );
      inc( sLen );
    end;
    if not TokenEq( ',' ) then break;
  end
  else sLen := 1;
  for r := 1 to r do
  begin
    s := sBuffer; L := sLen;
    while L > 0 do
    begin
      OutByte( Byte( s^ ) );
      inc( s ); dec( L );
    end;
  end;
end;

procedure TZXCompiler.DirectiveDEFW;
var w, r: Word;
begin
  while Token^ <> #0 do
  begin
    r := 1;
    if TokenEq( '(' ) then
    begin
      NeedAllValues := TRUE;
      r := Expression;
      NeedAllValues := FALSE;
      Wait( ')' );
    end;
    if TokenEq( '?' ) then
    begin
      for r := r downto 1 do
      begin
        IncAddr; IncAddr;
      end;
    end
      else
    begin
      w := Expression;
      for r := r downto 1 do OutWord( w );
    end;
    if not TokenEq( ',' ) then break;
  end;
end;

procedure TZXCompiler.DirectiveDISPLAY;
var s, p: PChar;
    msg, msg1: String;
    val, passes: Integer;
    val_scanned: Boolean;
begin
  p := Token;
  val_scanned := FALSE;
  msg := '';
  while Token^ <> #0 do
  begin
    if Token^ in [ '''', '"' ] then
    begin
      s := Token+1;
      while not( s^ in [ Token^, #13, #10, #0 ] ) do inc( s );
      SetString( msg1, Token+1, DWORD( s ) - DWORD( Token ) - 1 );
      msg := msg + msg1;
      if s^ = Token^ then inc( s );
      Cur := s; Next;
      if TokenEq( ',' ) then
      begin
        val_scanned := TRUE;
        val := Expression;
        msg := msg + Int2Str( val ) + '(' + Int2Hex( val, 2 ) + 'H)';
      end;
    end
    else
    begin
      val_scanned := TRUE;
      val := Expression;
      msg := msg + Int2Str( val ) + '(' + Int2Hex( val, 2 ) + 'H)';
    end;
    if CheckTokenEq( ',' ) then
    begin
      if NextEq( '"' ) then
      begin
        Next; continue;
      end
      else break;
    end
    else break;
  end;
  if TokenEq( ',' ) then passes := Expression
  else passes := 7;
  if (Skip_Level = 0) and ((1 shl (pass - 1)) and passes <> 0) then
    if val_scanned then
      ErrorAt( p, msg, 0 )
    else ErrorAt( p, msg, 0 );
end;

procedure TZXCompiler.DirectiveDUP;
var i, j, sav_i: Integer;
    SaveInclStack: PStrListEx;
    SaveInclStkPos: PList;
    SaveCur: PChar;
    p : PChar;
begin
  p := Token;
  i := Expression;
  if (i <= 0) or (Skip_Level > 0) then
  begin
    Inc( Skip_Level ); j := CompileTo( [ 'EDUP', 'ENDDUP' ] );
    Dec( Skip_Level ); if j < 0 then ErrorAt( p, 'DUP without EDUP or ENDDUP' );
  end
  else
  begin
    SaveInclStack := NewStrListEx; SaveInclStack.Assign( IncludeStack );
    SaveInclStkPos := NewList; SaveInclStkPos.Assign( IncludeStkPos );
    sav_i := IncludeStkChanges;
    SaveCur := Token;
    TRY
      while i > 0 do
      begin
        j := CompileTo( [ 'EDUP', 'ENDDUP' ] );
        if j < 0 then
        begin
          ErrorAt( p, 'DUP without EDUP or ENDDUP' );
          break;
        end;
        dec( i );
        if i > 0 then
        begin
          if sav_i <> IncludeStkChanges then
          begin
            IncludeStack.Assign( SaveInclStack );
            IncludeStkPos.Assign( SaveInclStkPos );
          end;
          TokensScanned := 0;
          Cur := SaveCur; Next;
        end;
      end;
    FINALLY
      SaveInclStack.Free;
      SaveInclStkPos.Free;
    END;
  end;
end;

procedure TZXCompiler.DirectiveENCODE;
var val_from, val_to: Byte;
begin
  while Token^ <> #0 do
  begin
    val_from := Expression;
    Wait( ',' );
    val_to := Expression;
    Encode[ Char( val_from ) ] := Char( val_to );
    if not TokenEq( ',' ) then break;
  end;
end;

procedure TZXCompiler.DirectiveENTRYPOINT;
begin
  if EntryPointSetPass = Pass then
    Error( 'Warning: Duplicating ENTRYPOINT (the last applied)', 0 );
  EntryPointSetPass := Pass;
  EntryPoint := Expression;
end;

procedure TZXCompiler.DirectiveENUM;
var aName: PChar; aLen: Integer;
    Val: Integer;
    i: Integer;
begin
  Val := 0;
  while Token^ <> #0 do
  begin
    if not MustBeIdentifier then Exit;
    aName := Token; aLen := Len;
    Next;
    if TokenEq( '=' ) then
      Val := Expression;
    i := AddLabel( aName, aLen, Val );
    if Pass >= 1 then
      Labels.Objects[ i ] := Val;
    inc( Val );
    if not TokenEq( ',' ) then Exit;
  end;
end;

procedure TZXCompiler.DirectiveEQU(i: Integer);
begin
  if Skip_Level > 0 then Expression
  else Labels.Objects[ i ] := Expression or EQU_Flag;
end;

procedure TZXCompiler.DirectiveERROR;
var s, p: PChar;
    msg: String;
    severity: Integer;
    passes: Integer;
begin
  p := Token;;
  Severity := 1;
  if not (Token^ in [ '''', '"' ]) then
  begin
    NeedAllValues := Skip_Level = 0;
    Severity := Expression;
    NeedAllValues := FALSE;
    Wait( ',' );
  end;
  if Token^ in [ '''', '"' ] then
  begin
    s := Token+1;
    while not( s^ in [ Token^, #13, #10, #0 ] ) do inc( s );
    SetString( msg, Token+1, DWORD( s ) - DWORD( Token ) - 1 );
    if s^ = Token^ then inc( s );
    Cur := s; Next;
  end;
  if TokenEq( ',' ) then passes := Expression
  else passes := 7;
  if (Skip_Level = 0) and ((1 shl (pass - 1)) and passes <> 0) then
    ErrorAt( p, msg, Severity );
end;

procedure TZXCompiler.DirectiveFILE;
var F: THandle;
    fname, fname1: String;
    sz: Integer;
    from, size: Integer;
    Buf: PByteArray;
    from_scanned: Boolean;
begin
  fname := ScanFileName; {!} Next;
  from := 0;
  size := -1;
  from_scanned := FALSE;
  if TokenEq( ',' ) then
  begin
    from_scanned := TRUE;
    from := Expression;
    if TokenEq( ',' ) then
      size := Expression;
  end;
  fname1 := FindInclude( fname );
  if fname1 = '' then
  begin
    if not from_scanned and DirectoryExists( fname ) then
    begin
      while Token^ <> #0 do
      begin
        if IncludeDirs.IndexOf_NoCase(fname)<0 then
          IncludeDirs.Add( fname );
        if not TokenEq( ',' ) then break;
        fname := ScanFileName; {!} Next;
      end;
      Exit;
    end;
    Error( 'File ' + fname + ' not found' ); Exit;
  end;
  F := FileCreate( fname1, ofOpenRead or ofOpenExisting or ofShareDenyWrite );
  if F = INVALID_HANDLE_VALUE then
  begin
    Error( 'Error opening file ' + fname1 + ':' + SysErrorMessage( GetLastError ) );
    Exit;
  end;
  TRY
    sz := GetFileSize( F, nil );
    if (size > -1) and (sz < from + size) then
    begin
      Error( 'File is smaller then required' ); Exit;
    end;
    if (size = -1) then size := sz - from;
    if size > 65536 then
    begin
      Error( 'Too big file ' + fname1 + ' (>64K)' ); Exit;
    end;
    if size > 0 then
    begin
      FileSeek( F, from, spBegin );
      GetMem( Buf, size );
      TRY
        FileRead( F, Buf[ 0 ], size );
        for from := 0 to size-1 do
          OutByte( Buf[ from ] );
      FINALLY
        FreeMem( Buf );
      END;
    end;
  FINALLY
    FileClose( F );
  END;
end;

procedure TZXCompiler.DirectiveFOR;
type
  TFor = packed record
    FromVal, ToVal, Step: Integer;
  end; PFor = ^TFor;
var i, j, k, sav_i: Integer;
    s, p: PChar;
    Vals: PStrListEx;
    RFor: PFor;
    str: String;
    SaveInclStack: PStrListEx;
    SaveInclStkPos: PList;
    SaveCur: PChar;
begin
  if not MustBeIdentifier then Exit;
  p := Token;
  s := AllocMem( 2 );
  s^ := '?';
  i := Defines.AddObject( Token, Len, DWORD( s ) );
  Next;
  Vals := NewStrListEx;
  TRY
    //    
    Wait( '=' );
    while Token^ <> #0 do
    begin
      RFor := nil;
      str := '';
      CASE Token^ OF
      '"' : begin
              inc( Token ); s := Token;
              while not(Token^ in [ s[ -1 ], #13, #10, #0]) do inc( Token );
              SetString( str, s, DWORD( Token ) - DWORD( s ) );
              if Token^ = s[ -1 ] then inc( Token )
              else Error( 'Unterminated string' );
              Cur := Token; Next;
            end;
      '''': begin
              s := Token;
              while not(Token^ in [ s^, #13, #10, #0 ]) do Inc( Token );
              if Token^ = s^ then inc( Token )
              else Error( 'Unterminated string' );
              SetString( str, s, DWORD( Token ) - DWORD( s ) );
              Cur := Token; Next;
            end;
      else RFor := AllocMemFast( Sizeof( RFor^ ) );
           RFor.FromVal := Expression;
           if TokenEq( 'TO' ) then
           begin //  FromVal TO ToVal [STEP Step]
             RFor.ToVal := Expression;
             RFor.Step := 1;
             if TokenEq( 'STEP' ) then
               RFor.Step := SmallInt( Expression );
             if RFor.Step = 0 then
             begin
               Error( 'STEP can not be 0' ); RFor.Step := 1;
             end;
           end
             else
           begin //   
             str := Int2Str( RFor.FromVal );
             RFor := nil;
           end;
      END;
      if (str <> '') or (RFor <> nil) and
         ((RFor.Step > 0) and (RFor.FromVal <= RFor.ToVal) or
          (RFor.Step < 0) and (RFor.FromVal >= RFor.ToVal)) then
        Vals.AddObject( str, DWORD( RFor ) );
      if not TokenEq( ',' ) then break;
    end;
    //    EFOR / ENDFOR   , 
    //  
    if (Skip_Level > 0) or (Vals.Count = 0) then
    begin // ,      
      k := IncludeStkPos.Count;
      inc( Skip_Level );
      j := CompileTo( [ 'EFOR', 'ENDFOR' ] );
      dec( Skip_Level );
      if j < 0 then ErrorAt( p, 'FOR not closed with EFOR or ENDFOR' );
      while k < IncludeStkPos.Count do
      begin
        IncludeStkPos.Delete( IncludeStkPos.Count-1 );
        IncludeStack.DeleteLast;
        inc( IncludeStkChanges );
      end;
    end
      else
    begin //  
      SaveInclStack := NewStrListEx; SaveInclStack.Assign( IncludeStack );
      SaveInclStkPos := NewList; SaveInclStkPos.Assign( IncludeStkPos );
      sav_i := IncludeStkChanges;
      SaveCur := Token;
      TRY
        for j := 0 to Vals.Count-1 do
        begin
          str := Vals.Items[ j ];
          if str <> '' then
          begin //   EFOR / ENDFOR     
            s := GetMemFast( Length( str ) + 1 );
            Move( str[ 1 ], s^, Length( str ) + 1 );
            Defines.Objects[ i ] := DWORD( s );
            k := CompileTo( [ 'EFOR', 'ENDFOR' ] );
            if k < 0 then
            begin
              ErrorAt( p, 'FOR not closed with EFOR or ENDFOR' ); Exit;
            end;
          end
            else
          begin //    FromVal TO ToVal [STEP Step]
            RFor := Pointer( Vals.Objects[ j ] );
            while TRUE do
            begin
              str := Int2Str( RFor.FromVal );
              s := GetMemFast( Length( str ) + 1 );
              Move( str[ 1 ], s^, Length( str ) + 1 );
              Defines.Objects[ i ] := DWORD( s );
              k := CompileTo( [ 'EFOR', 'ENDFOR' ] );
              if k < 0 then
              begin
                ErrorAt( p, 'FOR not closed with EFOR or ENDFOR' ); Exit;
              end;
              //   ... TO ... STEP ...
              inc( RFor.FromVal, RFor.Step );
              if (RFor.Step > 0) and (RFor.FromVal > RFor.ToVal) or
                 (RFor.Step < 0) and (RFor.FromVal < RFor.ToVal) then break;
              if sav_i <> IncludeStkChanges then
              begin
                IncludeStack.Assign( SaveInclStack );
                IncludeStkPos.Assign( SaveInclStkPos );
                sav_i := IncludeStkChanges;
              end;
              TokensScanned := 0;
              Cur := SaveCur; Next;
            end;
          end;
          if j < Vals.Count-1 then
          begin
            if sav_i <> IncludeStkChanges then
            begin
              IncludeStack.Assign( SaveInclStack );
              IncludeStkPos.Assign( SaveInclStkPos );
              sav_i := IncludeStkChanges;
            end;
            TokensScanned := 0;
            Cur := SaveCur; Next;
          end;
        end;
      FINALLY
        SaveInclStack.Free;
        SaveInclStkPos.Free;
      END;
    end;
  FINALLY
    if i = Defines.Count-1 then
      Defines.DeleteLast
    else
      Defines.Delete( i );
    Vals.Free;
  END;
end;

procedure TZXCompiler.DirectiveGOTO( cond: Integer );
var i, j, L0: Integer;
    prefix: Char;
begin
  prefix := Token^;
  if not TokenIn( [ '<', '>' ] ) then prefix := ' ';
  if not MustBeIdentifier then Exit;
  if Pass = 0 then i := -1
  else if Pass = 1 then i := -1
  else i := FindLabel( Token, Len, prefix );
  if i < 0 then
  begin
    if Pass > 1 then
      Error( 'Name ' + TokenStr + ' not yet defined' )
    else if Skip_Level = 0 then
      Undefined.AddObject( TokenStr, CurLabel );
    if cond < 0 then OutBytes( [ $C3, 0, 0 ] )
    else OutBytes( [ $C2 + cond * 8, 0, 0 ] );
  end
  else if Skip_Level = 0 then
  begin
    i := Labels.Objects[ i ];
    L0 := AddrNext - Addr;
    if AddrNext = i then
    begin
      if (Pass = 2) then
        CorrectLabels( CurLabel, AddrNext, -L0 );
    end
      else
    begin
      AddrNext := Addr + 2;
      j := SmallInt( Word( i ) - AddrNext );
      if (j >= -128) and (j <= 127) and (cond <= 3) and
         not( (Pass = 3) and (L0 = 3) ) then
      begin
        if cond < 0 then OutBytes( [ $18, j ] )
        else OutBytes( [ $20 + cond * 8, j ] );
        if (Pass = 2) and (L0 = 3) then //      3  
          CorrectLabels( CurLabel, Addr, -1 ); //     
                                               //    ORG
      end
      else
      begin
        if cond < 0 then OutBytes( [ $C3, i, i shr 8 ] )
        else OutBytes( [ $C2 + cond * 8, i, i shr 8 ] );
      end;
    end;
  end;
  Next;
end;

procedure TZXCompiler.DirectiveIF;
var i: Integer;
    b, e: Boolean;
    p: PChar;
begin //  
  p := Token;
  i := Expression; if TokenEq( 'THEN' ) then;
  e := FALSE;
  b := FALSE;
  if (i <> 0) and (Skip_Level = 0) then
  begin
    Skip_Level := -1;
    b := TRUE; //    IF
  end;
  while Token^ <> #0 do
  begin
    inc( Skip_Level );
    if not e then //     ELSE
      i := CompileTo( [ 'ELSEIF', 'ELSE', 'EIF', 'ENDIF' ] )
    else i := CompileTo( [ '', '', 'EIF', 'ENDIF' ] );
    if Skip_Level > 0 then dec( Skip_Level );
    CASE i OF
    -1: begin
          ErrorAt( p, 'IF conditional directive not closed with EIF or ENDIF' );
          Exit;
        end;
     0: begin
          i := Expression; if TokenEq( 'THEN' ) then;
          if not b and (i <> 0) and (Skip_Level = 0) then
          begin
            Skip_Level := -1;
            b := TRUE; //     ELSEIF
          end;
        end;
     1: begin
          e := TRUE;
          if not b and (Skip_Level = 0) then
          begin
            Skip_Level := -1;
            b := TRUE; //   ELSE
          end;
        end;
     else break;
    END;
  end;
end;

procedure TZXCompiler.DirectiveIFCond(cond: Integer; Long: Boolean);
var Addr0: Word;
    i, j, L0: Integer;
    elseLabel, eifLabel, FromLabel: Integer;
    then_goto: Boolean;
    p: PChar;
begin //  
  p := Token;
  if TokenEq( 'THEN' ) then;
  Addr0 := Addr;
  then_goto := CheckTokenIn( [ 'GOTO', 'BREAK', 'CONTINUE' ] );
  if not then_goto then
    cond := cond xor 1; //      ELSE  EIF
  FromLabel := CurLabel;
  elseLabel := ReserveLabel;
  eifLabel := ReserveLabel;
  if then_goto then
  begin
    TokenInIdx( [ 'GOTO', 'BREAK', 'CONTINUE' ], i );
    CASE i OF
    0: DirectiveGOTO( cond );
    1: DirectiveBREAK( cond, Long );
    2: DirectiveCONTINUE( cond, Long );
    END;
    if not TokenInIdx( [ 'ELSE', 'LONGELSE', 'EIF', 'ENDIF' ], i ) then
    begin //  { IFcond [THEN] GOTO label }    EIF
      AddReservedLabel( elseLabel );
      AddReservedLabel( eifLabel );
      Exit;
    end;
  end
    else
  begin
    if Pass = 0 then
    else if Pass = 1 then
    begin
      L0 := 3; CmdLens.Write( L0, 2 );
      OutBytes( [ $C2 + cond * 8, AddrNext, AddrNext shr 8 ] );
    end
    else //     elseLabel  eifLabel  
    begin
      L0 := 0; CmdLens.Read( L0, 2 );
      if Skip_Level = 0 then
      begin
        j := FindReserveLabel( elseLabel );
        if j < 0 then
        asm
          int 3 //  !
        end;
        AddrNext := Labels.Objects[ j ];
        if AddrNext = Addr then
        begin
          if Pass = 2 then CorrectLabels( FromLabel, Addr, -3 )
        end
        else
        begin
          j := SmallInt( AddrNext - (Addr0+2) );
          if (j >= -128) and (j <= 127) and
             not( (Pass = 3) and (L0 = 3) ) and (cond <= 3) and not Long then
          begin
            OutBytes( [ $20 + cond * 8, j ] );
            if Pass = 2 then CorrectLabels( FromLabel, Addr, -1 );
          end
          else OutBytes( [ $C2 + cond * 8, AddrNext, AddrNext shr 8 ] );
        end;
      end;
      L0 := Addr - AddrStart;
      CmdLens.Position := CmdLens.Position - 2;
      CmdLens.Write( L0, 2 );
    end;
    i := CompileTo( [ 'ELSE', 'LONGELSE', 'EIF', 'ENDIF' ] );
  end;
  Long := i=1;
  CASE i OF
  -1: begin
        ErrorAt( p, 'IFcond not finished with EIF or ENDIF' ); Exit;
      end;
   0,1:
      begin //   ELSE -    EIF    ELSE
        if not then_goto and (Skip_Level = 0) then
        begin
          Addr0 := Addr;
          if Pass = 0 then
          else if Pass = 1 then
          begin
            OutBytes( [ $C3, AddrNext, AddrNext shr 8 ] );
            L0 := 3; CmdLens.Write( L0, 2 );
          end
          else //     eifLabel  
          begin
            L0 := 0; CmdLens.Read( L0, 2 );
            j := FindReserveLabel( eifLabel );
            if j < 0 then
            asm
              int 3 //   
            end;
            AddrNext := Labels.Objects[ j ];
            if AddrNext = Addr then
            begin
              if Pass = 2 then CorrectLabels( FromLabel, Addr, -3 )
            end
            else
            begin
              j := SmallInt( AddrNext - (Addr+2) );
              if (j >= -128) and (j <= 127) and not
                 ( (Pass = 3) and (L0 = 3) ) and not Long then
              begin
                OutBytes( [ $18, j ] );
                if Pass = 2 then CorrectLabels( FromLabel, Addr, -1 );
              end
              else OutBytes( [ $C3, AddrNext, AddrNext shr 8 ] );
            end;
            L0 := Addr - Addr0;
            CmdLens.Position := CmdLens.Position - 2;
            CmdLens.Write( L0, 2 );
          end;
        end;
        AddReservedLabel( elseLabel );
        i := CompileTo( [ 'EIF', 'ENDIF' ] );
        if i < 0 then
        begin
          ErrorAt( p, 'IFcond not finished with EIF or ENDIF' ); Exit;
        end;
        AddReservedLabel( eifLabel );
      end;
  else //  ELSE , elseLabel  eifLabel    
    begin
     AddReservedLabel( elseLabel );
     AddReservedLabel( eifLabel );
    end;
  END;
end;

procedure TZXCompiler.DirectiveINCLUDE;
var F: THandle;
    fname, fname1: String;
    sz: Integer;
    Buffer: PChar;
    i: Integer;
begin
  fname := ScanFileName;
  fname1 := FindInclude( fname );
  if fname1 = '' then
  begin
    {!} Next;
    if DirectoryExists( fname ) or CheckTokenEq( ',' ) then
    begin
      while Token^ <> #0 do
      begin
        if IncludeDirs.IndexOf_NoCase( fname ) < 0 then
          IncludeDirs.Add( fname );
        if not TokenEq( ',' ) then break;
        fname := ScanFileName; {!} Next;
      end;
      Exit;
    end;
    Error( 'File ' + fname + ' not found' ); Exit;
  end;
  i := IncludeSources.IndexOf_NoCase( fname1 );
  if i < 0 then
  begin
    F := FileCreate( fname1, ofOpenRead or ofOpenExisting or ofShareDenyWrite );
    if F = INVALID_HANDLE_VALUE then
    begin
      Error( 'Error opening file ' + fname1 + ':' + SysErrorMessage( GetLastError ) );
      Exit;
    end;
    TRY
      sz := GetFileSize( F, nil );
      if sz > 0 then
      begin
        GetMem( Buffer, sz );
        i := IncludeSources.AddObject( fname1, DWORD( Buffer ) );
        FileRead( F, Buffer^, sz );
        Buffer[ sz ] := #0;
      end;
    FINALLY
      FileClose( F );
    END;
  end;
  if IncludeStack.IndexOf_NoCase( fname1 ) >= 0 then
  begin
    Error( 'Include file ' + fname1 + ' uses itself recursively' );
    Exit;
  end;
  IncludeStkPos.Add( Cur );
  IncludeStack.AddObject( fname1, IncludeSources.Objects[ i ] );
  inc( IncludeStkChanges );
  TokensScanned := 0;
  Cur := Pointer( IncludeSources.Objects[ i ] );
  Next;
end;

procedure TZXCompiler.DirectiveMacro(MacroToken: PChar;
  aName: PChar; aLen: Integer);
var s: PChar;
    M: PMacro;
    q: Boolean;
    SaveSkip_LeveL: Integer;
begin
  if Pass = 0 then
  begin //       
        //   ,  ,   
        //    .
    M := GetMemFast( Sizeof( M^ ) );
    M.Source := Src;
    M.MacroStart := MacroToken;
    M.Src_Path := #1#0;
    if IncludeStack.Count > 0 then
    begin
      if IncludeStack.Last <> '' then
        M.Source := Pointer( IncludeStack.LastObj )
      else if IncludeStack.Count > 1 then
      begin
        M.Source := Pointer( IncludeStack.Objects[ IncludeStack.Count-2 ] );
        M.MacroStart := IncludeStkPos.Last;
        M.Src_Path := IncludeStack.ItemPtrs[ IncludeStack.Count-2 ];
      end;
    end;
    MacroList.AddObject( aName,
                         aLen,
                         DWORD( M ) );
  end;
  q := FALSE;
  if not AtStartOfLine then
  while Token^ <> #0 do
  begin
    if IsIdentifier then
    begin
      Next;
      if q and not CheckTokenEq( '=' ) then
        Error( 'Regular parameters must not be after optional parameters' );
      if TokenEq( '=' ) then
      begin
        q := TRUE;
        if not TokenEq( ',' ) then
        begin
          if Token^ in [ '''', '"' ] then
          begin
            s := Token; inc( Token );
            while not(Token^ in [ s^, #13, #10, #0 ]) do inc( Token );
            if Token^ = s^ then inc( Token )
            else Error( 'Unterminated string' );
            TokensScanned := 0;
            Cur := Token; Next;
          end;
        end;
      end;
    end;
    if not TokenEq( ',' ) then break;
  end;
  //SkipToToken( [ 'EMACRO', 'ENDMACRO', 'ENDM', 'EMAC' ] );
  while Token^ <> #0 do
  begin
    if TokenIn( [ 'EMACRO', 'ENDMACRO', 'ENDM', 'EMAC' ] ) then break;
    if TokenEq( 'MACRO' ) then
    begin
      SaveSkip_LeveL := Skip_Level;
      Skip_Level := 0;
      Error( 'Warning: Possible nested macro definition', 0 );
      Skip_Level := SaveSkip_LeveL;
    end;
    Next;
  end;
end;

procedure TZXCompiler.DirectiveORG;
begin
  if TokenStartsFrom( 'RAM' ) then
  begin
    OrgBank := Expression;
    if (OrgBank < 0) or (OrgBank > Memory.MaxRAMPage) then
      Error( 'Bad RAM bank ' + Int2Str( OrgBank ) );
    if TokenEq( ',' ) then;
    NeedAllValues := TRUE;
    Addr := Expression;
    NeedAllValues := FALSE;
    if Org and $C000 <> 0 then
    begin
      Error( 'While compiling to memory bank 16K, address must not exceed 16K' );
      Addr := Addr and $3FFF;
    end;
    Org := Addr;
    if TokenEq( ',' ) then Addr := Expression;
  end
  else if TokenStartsFrom( 'ROM' ) then
  begin
    OrgBank := -Expression -1;
    if (OrgBank >= 0) or (OrgBank < -Memory.MaxRAMPage-1) then
      Error( 'Bad ROM bank ' + Int2Str( -OrgBank+1 ) );
    if TokenEq( ',' ) then;
    NeedAllValues := TRUE;
    Addr := Expression;
    NeedAllValues := FALSE;
    if Org and $C000 <> 0 then
    begin
      Error( 'While compiling to memory bank 16K, address must not exceed 16K' );
      Addr := Addr and $3FFF;
    end;
    Org := Addr;
    if TokenEq( ',' ) then Addr := Expression;
  end
    else
  begin
    OrgBank := OrgCur64K;
    Addr := Expression;
    Org := Addr;
    if TokenEq( ',' ) then Addr := Expression;
  end;
  AddLabel( '', 0, Org_Flag or Addr );
end;

procedure TZXCompiler.DirectivePOP;
var L: PList;
    i, j: Integer;
    wait_comma, first_rp: Boolean;
begin
  L := NewList;
  TRY
    wait_comma := TRUE;
    first_rp := TRUE;
    while Token^ <> #0 do
    begin
      if TokenInIdx( [ 'BC', 'DE', 'HL', 'AF', 'IX', 'IY' ], i ) then
      begin
        if pop_noinvert then
          L.Add( Pointer( i ) )
        else L.Insert( 0, Pointer( i ) );
      end else Error( 'Waiting for register pair' );
      if wait_comma and not TokenEq( ',' ) then
      begin
        if first_rp then wait_comma := FALSE
        else if wait_comma then break;
        if not CheckTokenIn( [ 'BC', 'DE', 'HL', 'AF', 'IX', 'IY' ] ) or
           first_rp and NextIn( [ '=', '+', '-' ] ) then
          break;
      end
      else if not CheckTokenIn( [ 'BC', 'DE', 'HL', 'AF', 'IX', 'IY' ] ) or
              NextIn( [ '=', '+', '-' ] ) then
        break;
      first_rp := FALSE;
    end;
    for j := 0 to L.Count-1 do
    begin
      i := DWORD( L.Items[ j ] );
      CASE i OF
      0..3: OutByte( $C1 + i * 16 );
      4   : OutBytes( [ $DD, $E1 ] );
      5   : OutBytes( [ $FD, $E1 ] );
      END;
    end;
  FINALLY
    L.Free;
  END;
end;

procedure TZXCompiler.DirectivePOPINVERT(invert: Boolean);
begin
  pop_noinvert := not invert;
end;

procedure TZXCompiler.DirectiveProc(i: Integer);
var p: PChar;
begin
  p := Token;
  AddLabel( '', 0, Proc_Start );
  i := CompileTo( [ 'ENDP', 'EPROC', 'ENDPROC' ] );
  if i < 0 then
    ErrorAt( p, 'PROC not finished with ENDP, EPROC or ENDPROC' );
  AddLabel( '', 0, Proc_End );
end;

procedure TZXCompiler.DirectivePUSH;
var i: Integer;
    first_rp, wait_comma: Boolean;
begin
  wait_comma := TRUE;
  first_rp := TRUE;
  while Token^ <> #0 do
  begin
    if TokenInIdx( [ 'BC', 'DE', 'HL', 'AF', 'IX', 'IY' ], i ) then
    CASE i OF
    0..3: OutByte( $C5 + i * 16 );
    4   : OutBytes( [ $DD, $E5 ] );
    5   : OutBytes( [ $FD, $E5 ] );
    END else Error( 'Waiting for register pair' );
    if wait_comma and not TokenEq( ',' ) then
    begin
      if first_rp then wait_comma := FALSE
      else if wait_comma then break;
      if not CheckTokenIn( [ 'BC', 'DE', 'HL', 'AF', 'IX', 'IY' ] ) or
         first_rp and NextIn( [ '=', '+', '-' ] ) then
        break;
    end
    else if not CheckTokenIn( [ 'BC', 'DE', 'HL', 'AF', 'IX', 'IY' ] ) or
         NextIn( [ '=', '+', '-' ] ) then
      break;
    first_rp := FALSE;
  end;
end;

procedure TZXCompiler.DirectiveStruct(i: Integer);
var SaveAddr, SaveOrg: Word;
    SaveOrgBank: Integer;
begin
  Labels.Objects[ i ] := Struct_Start;
  inc( Ignore_Out );
  SaveAddr := Addr;
  SaveOrg := Org;
  SaveOrgBank := OrgBank;
  Addr := 0;
  Org := 0;
  inc( Compiling_Struct );
  CompileTo( [ 'ESTRUCT', 'ENDSTRUCT', 'ENDS' ] );
  dec( Compiling_Struct );
  AddLabel( '', 0, Addr or Field_Flag );
  Addr := SaveAddr;
  Org := SaveOrg;
  OrgBank := SaveOrgBank;
  dec( Ignore_Out );
  AddLabel( '', 0, Struct_End );
end;

procedure TZXCompiler.DirectiveWHILE( Long, Djnz: Boolean );
var i, j, cond: Integer;
    Addr0: Word;
    p: PChar;
    lContinue, lBreak: Integer;
begin
  p := Token;
  Addr0 := Addr;
  lContinue := ReserveLabel; //     BREAK / CONTINUE:
  lBreak := ReserveLabel;
  StkBreakCont.AddObject( LoopLabel, lContinue );
  TRY
    if not Djnz then
      AddReservedLabel( lContinue );
    if TokenEq( ':' ) then ;
    if Djnz then
    begin
      i := CompileTo( [ 'EWHILEB' ] );
      if i = 0 then i := 1;
      AddReservedLabel( lContinue );
    end
    else
    i := CompileTo( [ 'EWHILE', 'EWHILEB', 'EWHILENZ', 'EWHILEZ', 'EWHILENC',
      'EWHILEC', 'EWHILEPO', 'EWHILEPE', 'EWHILEP', 'EWHILEM' ] );
    if i < 0 then
    begin
      ErrorAt( p, 'LOOP not closed with ELOOP or ELOOPB' ); Exit;
    end;
    cond := i - 2;
    if Skip_Level > 0 then Exit;
    AddrNext := Addr + 2;
    j := SmallInt( Addr0 - AddrNext );
    if Pass = 0 then
    else if (Pass = 1) or Long then
    CASE i OF
    0: OutBytes( [ $C3, Addr0, Addr0 shr 8 ] );
    1: OutBytes( [ $05, $C2, Addr0, Addr0 shr 8 ] );
    else OutBytes( [ $C2 + cond * 8, Addr0, Addr0 shr 8 ] )
    END
    else
    if (j >= -128) and (j <= 127) and (cond <= 3) then
    CASE i OF
    0: begin
         OutBytes( [ $18, j ] );
         if Pass = 2 then
           CorrectLabels( CurLabel, AddrNext, -1 );
       end;
    1: begin
         OutBytes( [ $10, j ] );
         if Pass = 2 then
           CorrectLabels( CurLabel, AddrNext, -2 );
       end;
    else
       begin
         OutBytes( [ $20 + cond * 8, j ] );
         if Pass = 2 then
           CorrectLabels( CurLabel, AddrNext, -1 );
       end;
    END
    else CASE i OF
    0: OutBytes( [ $C3, Addr0, Addr0 shr 8 ] );
    1: OutBytes( [ $05, $C2, Addr0, Addr0 shr 8 ] );
    else OutBytes( [ $C2 + 8 * cond, Addr0, Addr0 shr 8 ] );
    END;
  FINALLY
    AddReservedLabel( lBreak );
    StkBreakCont.DeleteLast;
  END;
end;

procedure TZXCompiler.DoBreakContinue(i, cond: Integer; Long: Boolean);
var j, k, off, L0: Integer;
    s: PChar;
begin // i=0 - continue , i=1 - break
  k := StkBreakCont.Count-1;
  if IsIdentifier then
    for j := StkBreakCont.Count-1 downto 0 do
    begin
      s := StkBreakCont.ItemPtrs[ j ];
      if (s^ = Token^) and (StrLen( s ) = DWORD( Len )) and
         (StrLComp( s, Token, Len ) = 0) then
      begin //   BREAK/CONTINUE label   
            //    
        k := j; Next;
        break;
      end;
    end;
  k := StkBreakCont.Objects[ k ] + DWORD( i ); // k =    Labels
  j := Labels.Objects[ k ];
  L0 := AddrNext - Addr;
  AddrNext := Addr + 2;
  off := SmallInt( j - AddrNext );
  if not Long and
     (off >= -128) and (off <= 127) and (cond <= 3) and
     not( (Pass = 3) and (L0 = 3) ) then
  begin
    if cond < 0 then OutBytes( [ $18, off ] )
    else OutBytes( [ $20 + cond * 8, off ] );
    if (Pass = 2) and (i = 1) then CorrectLabels( CurLabel, Addr, -1 );
  end
  else
  begin
    if cond < 0 then OutBytes( [ $C3, j, j shr 8 ] )
    else OutBytes( [ $C2 + cond * 8, j, j shr 8 ] );
  end;
end;

function TZXCompiler.DoOperation(opd1: Word; op: TOperation;
  opd2: Word): Word;
begin
  Result := 0;
  CASE op OF
  oAdd: Result := opd1 + opd2;
  oSub: Result := opd1 - opd2;
  oMul: Result := opd1 * opd2;
  oDiv: if opd2 = 0 then
        begin
          if Pass > 1 then Error( 'Division by zero' );
        end else Result := opd1 div opd2;
  oMod: if opd2 = 0 then
        begin
          if Pass > 1 then Error( 'Division by zero' );
        end else Result := opd1 mod opd2;
  oShl: Result := opd1 shl opd2;
  oShr: Result := opd1 shr opd2;
  oAnd: Result := opd1 and opd2;
  oOr : Result := opd1 or  opd2;
  oXor: Result := opd1 xor opd2;
  oEQ : Result := Integer( opd1 = opd2 );
  oNE : Result := Integer( opd1 <> opd2 );
  oLT : Result := Integer( opd1 < opd2 );
  oLE : Result := Integer( opd1 <= opd2 );
  oGT : Result := Integer( opd1 > opd2 );
  oGE : Result := Integer( opd1 >= opd2 );
  else Error( 'Compiler error' );
  END;
end;

procedure TZXCompiler.Error(const s: String; Severity: Integer = 1);
//   ,   
var p: PChar;
begin
  p := Token;
  if TokensScanned > 0 then
    while (p[ -1 ] < ' ') and (p[ -1 ] <> #0) do dec( p );
  ErrorAt( p, s, Severity );
end;

procedure TZXCompiler.ErrorAt(pos: PChar; const s: String; Severity: Integer = 1);
var InSrc: PChar;
    LineNo, ColNo: Integer;
    inc_file_name: PChar;
    i: Integer;
begin
  if Skip_Level > 0 then Exit; //      
                               //   ?
  if Severity > 0 then
  begin
    if not PassIndicated and Assigned( OnError ) then
    begin
      OnError( nil, -1, 0, PChar( 'Errors found at pass ' + Int2Str( Pass ) ),
               0 );
      PassIndicated := TRUE;
    end;
    inc( ErrCount );
  end;
  if not Assigned( OnError ) then Exit;
  inc_file_name := nil;

  REPEAT
    if ( DWORD( pos ) >= DWORD( Src ) ) and
       ( DWORD( pos ) <= DWORD( Src ) + DWORD( StrLen( Src ) ) ) then
      InSrc := Src
    else
    begin
      InSrc := nil;
      for i := 0 to IncludeSources.Count-1 do
      begin
        InSrc := Pointer( IncludeSources.Objects[ i ] );
        if ( DWORD( pos ) >= DWORD( InSrc ) ) and
           ( DWORD( pos ) <= DWORD( InSrc ) + DWORD( StrLen( InSrc ) ) ) then
        begin
          inc_file_name := IncludeSources.ItemPtrs[ i ];
          break;
        end;
        InSrc := nil;
      end;
      if InSrc = nil then
      begin
        if (IncludeStack.Count > 0) and (IncludeStack.Last = '') then
        begin //      
          if pos = IncludeStkPos.Last then break;
          pos := IncludeStkPos.Last;
        end
        else break;
      end;
    end;
  UNTIL (InSrc <> nil) or (ErrCount >= 10);

  LineNo := 0;
  ColNo := 1;
  if InSrc <> nil then
    while DWORD(InSrc) < DWORD(pos) do
    begin
      CASE InSrc^ OF
      #13: begin
             inc( LineNo ); ColNo := 0;
             inc( InSrc );
             if InSrc^ <> #10 then Dec( InSrc );
           end;
      #0: break;
      END;
      inc( ColNo );
      inc( InSrc );
    end;
  OnError( inc_file_name, LineNo, ColNo, PChar( s ), Severity );
  if Severity > 1 then
    raise Exception.Create( e_Custom, 'Fatal error' );
end;

procedure TZXCompiler.ErrorEndDir;
begin
  Error( 'Misplaced ' + TokenStr );
end;

function TZXCompiler.Expression: Word;
var op1, op2: TOperation;
    opd2: Word;
begin
  if Token^ = '"' then
  begin //  
    Result := Compare2Strings;
    Exit;
  end;
  Result := Operand;
  if GetOperation( op1 ) then
  begin
    opd2 := Operand;
    while Token^ <> #0 do
    begin
      if GetOperation( op2 ) then
      begin // Result op1 opd2 op2 ...
        if Priority[ op1 ] < Priority[ op2 ] then
          opd2 := Expression2( op1, opd2, op2 )
        else
        begin
          Result := DoOperation( Result, op1, opd2 );
          op1 := op2;
          opd2 := Operand;
        end;
      end
      else break;
    end;
    Result := DoOperation( Result, op1, opd2 );
  end;
end;

function TZXCompiler.Expression2(op1: TOperation; opd1: Word;
  var op2: TOperation): Word;
var opd2: Word;
    op3: TOperation;
begin
  Result := opd1;
  if Token^ = '"' then
    opd2 := Compare2Strings
  else
    opd2 := Operand;
  while Priority[ op1 ] < Priority[ op2 ] do
  begin //... op1 opd1 op2 ...
    if GetOperation( op3 ) then
    begin //... op1 opd1 op2 opd2 op3 ...
      if Priority[ op2 ] < Priority[ op3 ] then
        opd2 := Expression2( op2, opd2, op3 )
      else
      begin
        Result := DoOperation( Result, op2, opd2 );
        op2 := op3;
        opd2 := Operand;
      end;
    end
      else break;
  end;
  Result := DoOperation( Result, op2, opd2 );
  op2 := oNone;
end;

function TZXCompiler.FindDefine: Integer;
var i: Integer;
    s: PChar;
begin
  for i := Defines.Count-1 downto 0 do
  begin
    s := Defines.Names[ i ].NameStart;
    if s = nil then continue;
    if (s^ = Token^) and (StrLen( s ) = DWORD( Len )) and
       (StrLComp( s, Token, Len ) = 0) then
    begin
      Result := i; Exit;
    end;
  end;
  Result := -1;
end;

function TZXCompiler.FindInclude(const fname: String): String;
var i: Integer;
    s: String;
begin
  Result := fname;
  if fname = '' then Exit;
  if fname[ 1 ] in [ '''', '"' ] then
  begin
    Result := CopyEnd( fname, 2 );
    Result := Parse( Result, fname[ 1 ] );
  end;
  if DirectoryExists( fname ) then
  begin
    Result := ''; Exit;
  end;
  if pos( ':', fname ) > 0 then Exit;
  for i := 0 to IncludeDirs.Count-1 do
  begin
    s := IncludeTrailingPathDelimiter( IncludeDirs.Items[ i ] ) +
         Result;
    if FileExists( s ) then
    begin
      Result := s; Exit;
    end;
  end;
  if FileExists( Result ) then Exit;
  Result := '';
end;

function TZXCompiler.FindLabel(aName: PChar; aLen: Integer; prefix: Char): Integer;
var chk: Word;
    i: Integer;
begin
  Result := -1;
  if not Labels.NameMayBePresent( aName, aLen, chk ) then Exit;
  if prefix = 'v' then //  
  begin
    for i := 0 to Labels.Count-1 do
    begin
      if Labels.Objects[ i ] and Variable_Flag = 0 then Exit;
      if Labels.NameEq( i, aName, aLen ) then
      begin
        Result := i;
        Exit;
      end;
    end;
  end;
  if (prefix = '<') OR
     (Upper[ aName^ ] = 'B') and IsLocalPrefix( aName[ 1 ] ) then
    Result := SearchLabelBack( aName+1, aLen-1, prefix, chk )
  else
  if (prefix = '>') OR
     (Upper[ aName^ ] = 'F') and IsLocalPrefix( aName[ 1 ] ) then
    Result := SearchLabelFwd( aName+1, aLen-1, prefix, chk )
  else
  begin
    Result := SearchLabelFwd( aName, aLen, prefix, chk );
    if Result < 0 then
      Result := SearchLabelBack( aName, aLen, prefix, chk );
  end;
end;

function TZXCompiler.FindMacro( aName: PChar; aLen: Integer; var i: Integer ): Boolean;
var j: Integer;
    chk: Word;
begin
  Result := MacroList.NameMayBePresent( aName, aLen, chk );
  if not Result then Exit;
  for j := MacroList.Count-1 downto 0 do
  begin
    if (MacroList.Names[ j ].Chk = chk) and
       (MacroList.NameEq( j, aName, aLen )) then
    begin
      i := j;
      Exit;
    end;
  end;
  Result := FALSE;
end;

function TZXCompiler.FindReserveLabel(i: Integer): Integer;
var s: String;
begin
  s := #1 + Int2Str( i );
  Result := FindLabel( PChar( s ), Length( s ), ' ' );
end;

function TZXCompiler.GetOperation(var op: TOperation): Boolean;
var s, s0: PChar;
begin
  Result := FALSE;
  if AtStartOfLine then Exit;
  Result := TRUE;
  s := token + 1;
  CASE Token^ OF
  //'%', '/',
  '&', '|', '^':
    begin
      while not ( s^ in [ #13, #10, #0 ] ) and ( s^ <= ' ' ) do inc( s );
      if Upper[ s^ ] in [ 'A'..'Z' ] then
      begin
        s0 := s;
        while (Upper[ s^ ] in [ 'A'..'Z' ]) and
              (DWORD( s ) - DWORD( s0 ) < 4) do inc( s );
        if (DWORD( s ) - DWORD( s0 ) < 3) and
           SIn( s0, DWORD( s ) - DWORD( s0 ), [ 'B', 'C', 'D', 'E', 'H', 'L',
             'M', 'A', 'BC', 'DE', 'HL', 'IX', 'IY', 'SP',
             'IXH', 'IXL', 'IYH', 'IYL' ] ) then
        begin
          Result := FALSE; Exit;
        end;
      end;
    end;
  END;
  s := Token + 1;
  CASE Token^ OF
  '+' : op := oAdd;
  '-' : op := oSub;
  '*' : op := oMul;
  '/' : op := oDiv;
  '%' : op := oMod;
  '&' : op := oAnd;
  '|' : op := oOr;
  '^' : op := oXor;
  '<' : CASE s^ OF
        '<': begin op := oShl; inc( s ); end;
        '=': begin op := oLE; inc( s ); end;
        '>': begin op := oNE; inc( s ); end;
        else op := oLT;
        END;
  '>' : CASE s^ OF
        '>': begin op := oShr; inc( s ); end;
        '=': begin op := oGE; inc( s ); end;
        '<': Result := FALSE;
        else op := oGT;
        END;
  '=' : op := oEQ;
  '~', '!'
      : if s^ = '=' then
        begin
          op := oNE; inc( s );
        end else Result := FALSE;
  else Result := FALSE;
  END;
  if Result then
  begin
    Cur := s; Next;
  end;
end;

function TZXCompiler.GetOperation_C_like(var op: TOperation; var CF: Boolean): Boolean;
var s: PChar;
begin
  Result := FALSE;
  op := oNone;
  if AtStartOfLine and not OpCanBeAtStartOfLine then Exit;
  Result := TRUE;
  CF := FALSE;
  s := token + 1;
  CASE Token^ OF
  '+' : op := oAdd;
  '-' : op := oSub;
  '&' : op := oAnd;
  '|' : op := oOr;
  '^' : op := oXor;
  '<' : CASE s^ OF
        '<': begin op := oShl; inc( s ); end;
        else Result := FALSE;
        END;
  '>' : CASE s^ OF
        '>': begin op := oShr; inc( s ); end;
        '<': begin op := oXchg; inc( s ); end;
        else Result := FALSE;
        END;
  '=' : op := oEQ;
  '?' : op := oCmp;
  '!' : op := oNot;
  else Result := FALSE;
  END;
  if Result then
  begin
    Cur := s; Next;
    CASE op OF
    oSub,
    oAdd,
    oShl,
    oShr: CF := TokenEq( 'CF' );
    END;
  end;
end;

procedure TZXCompiler.IncAddr;
begin
  inc( Addr );
  inc( Org );
  if OrgBank <> OrgCur64K then
  begin
    Org := Org and $3FFF;
  end;
end;

procedure TZXCompiler.Init;
begin
  IncludeDirs := NewStrList;
  IncludeStack := NewStrListEx;
  IncludeStkPos := NewList;
  IncludeSources := NewStrListEx;
  Labels := NewNames;
  Undefined := NewStrListEx;
  Defines := NewNames;
  MacroList := NewNames;
  CmdLens := NewMemoryStream;
  StkBreakCont := NewStrListEx;
  InitUpper;
  InitReservedTable( ReservedTable_NoParam, ReservedList_NoParam );
  InitReservedTable( ReservedTable_Param, ReservedList_Param );
  InitReservedTable( ReservedTable_EndDirs, ReservedList_EndDirs );
end;

procedure TZXCompiler.InitReservedTable(var Table: array of Byte;
  const List: array of String);
var i: Integer;
    chk: Word;
    s: PChar;
begin
  for i := 0 to High( List ) do
  begin
    s := PChar( List[ i ] );
    chk := 0;
    while s^ <> #0 do
    begin
      chk := ((chk shl 1) or (chk shr 15)) xor Byte( Upper[ s^ ] );
      inc( s );
    end;
    Table[ chk shr 3 ] := Table[ chk shr 3 ] or (1 shl (chk and 7));
  end;
end;

function TZXCompiler.IsBinaryNumber: Boolean;
var s: PChar;
begin
  Result := FALSE;
  s := Token;
  if s^ = '%' then inc( s );
  while (s^ in [ '0', '1' ]) do inc( s );
  if s^ in IdentifierStart then Exit;
  if s^ in [ '2'..'9' ] then Exit;
  if Token^ = '%' then Result := TRUE
  else
  begin
    if s^ <> '.' then Exit;
    inc( s );
    if s^ in [ 'B', 'b' ] then Result := TRUE;
  end;
end;

function TZXCompiler.IsHexNumber: Boolean;
var s: PChar;
    start_digit, start_bax: Boolean;
begin
  start_digit := Token^ in [ '0'..'9' ];
  start_bax := Token^ = '$';
  Result := start_digit or start_bax or (Upper[ Token^ ] in [ 'A'..'F' ]);
  if not Result then Exit;
  s := Token + 1;
  while Upper[s^] in [ '0'..'9', 'A'..'F' ] do inc( s );
  if not start_bax and (DWORD( s ) - DWORD( Token ) > 4) or
     start_bax and (DWORD( s ) - DWORD( Token ) > 5) then
  begin
    if start_digit then Exit;
    Result := FALSE; Exit;
  end;
  if (Upper[ s^ ] = 'H') then
  begin
    if not start_bax and
      not( s[ 1 ] in IdentifierStart ) and
      not( s[ 1 ] in [ '0'..'9' ] ) then Exit;
    if start_bax then
    begin
      Result := FALSE; Exit;
    end;
  end;
  if (s^ = '.') and not start_bax then
  begin
    inc( s );
    if Upper[ s^ ] = 'H' then Exit;
    Result := FALSE;
  end
  else if start_bax then
  begin
    if s^ in IdentifierStart then Result := FALSE;
  end
  else Result := FALSE;
end;

function TZXCompiler.IsIdentifier: Boolean;
begin
  if Token^ = '%' then
    Result := not IsBinaryNumber
  else
  if (Upper[ Token^ ] in [ 'A'..'F' ]) or
     (Token^ = '$') and (Options and Option_BaxHex <> 0) then
    Result := not IsHexNumber
  else
    Result := Token^ in IdentifierStart;
end;

function TZXCompiler.IsLocalPrefix(C: Char): Boolean;
begin
  CASE C OF
  '.': Result := Options and Option_LocalLabel_Dot <> 0;
  '_': Result := Options and Option_LocalLabel_Und <> 0;
  '!': Result := Options and Option_LocalLabel_Exc <> 0;
  '?': Result := Options and Option_LocalLabel_Que <> 0;
  '@': Result := Options and Option_LocalLabel_At <> 0;
  '\': Result := Options and Option_LocalLabel_Bck <> 0;
  else Result := FALSE;
  END;
end;

function TZXCompiler.MustBeIdentifier: Boolean;
begin
  Result := IsIdentifier;
  if not Result then Error( 'Waiting for identifier' );
end;

procedure TZXCompiler.Next;
begin
  SkipSp;
  Token := Cur;
  SkipToken( Cur );
  Len := DWORD(Cur) - DWORD(Token);
end;

function TZXCompiler.NextEq(const s: String): Boolean;
var p, p0: PChar;
    i: Integer;
begin
  Result := FALSE;
  p := Cur;
  while (p^ <= ' ') and not( p^ in [ #13, #10, #0 ] ) do inc( p );
  if p^ < ' ' then Exit;
  p0 := p;
  SkipToken( p );
  if Integer( p ) - Integer( p0 ) <> Length( s ) then Exit;
  for i := 1 to Length( s ) do
  begin
    if Upper[ p0^ ] <> s[ i ] then Exit;
    inc( p0 );
  end;
  Result := TRUE;
end;

function TZXCompiler.NextIdInLine(const str: String): Boolean;
var s, s0: PChar;
    L: Integer;
begin
  Result := FALSE;
  s := Cur;
  while not( s^ in [ #13, #10, #0 ] ) and
        not( s^ in IdentifierStart ) do inc( s );
  s0 := s;
  while s^ in IdentifierContinue do inc( s );
  L := DWORD( s ) - DWORD( s0 );
  if L <> Length( str ) then Exit;
  if StrLComp_NoCase( s0, PChar( str ), L ) <> 0 then Exit;
  Result := TRUE;
end;

function TZXCompiler.NextIn(const a: array of String): Boolean;
var i: Integer;
begin
  Result := TRUE;
  for i := 0 to High( a ) do
    if NextEq( a[ i ] ) then Exit;
  Result := FALSE;
end;

function TZXCompiler.Number: Word;
var Format, MinFormat: Integer;
    Result10: Integer;
    Result16: Integer;
    Result8: Integer;
    Result2: Integer;
begin
  Format := 0;
  MinFormat := 2;
  CASE Token^ OF
  '$' : begin
          Format := 16;
          inc( Token );
          if not( Upper[ Token^ ] in [ '0'..'9', 'A'..'F' ] ) then
          begin
            Result := AddrStart;
            Cur := Token; Next;
            Exit;
          end;
        end;
  '#' : begin
          Format := 16;
          inc( Token );
        end;
  '%' : begin
          Format := 2;
          inc( Token );
          MinFormat := 2;
        end;
  END;
  Result16 := 0;
  Result10 := 0;
  Result8 := 0;
  Result2 := 0;
  while Token^ in [ '0'..'9', 'A'..'F', 'a'..'f' ] do
  begin
    if Token^ in [ '0'..'1' ] then Result2 := Result2 * 2 + Ord( Token^ ) - Ord( '0' );
    if Token^ in [ '0'..'7' ] then
    begin
      Result8 := Result8 * 8 + Ord( Token^ ) - Ord( '0' );
      if Token^ in [ '2'..'7' ] then MinFormat := 8;
    end;
    if Token^ in [ '0'..'9' ] then
    begin
      Result10 := Result10 * 10 + Ord( Token^ ) - Ord( '0' );
      Result16 := Result16 * 16 + Ord( Token^ ) - Ord( '0' );
      if Token^ in [ '8'..'9' ] then MinFormat := 10;
    end;
    if Upper[ Token^ ] in [ 'A'..'F' ] then
    begin
      Result16 := Result16 * 16 + Ord( Upper[ Token^ ] ) - Ord( 'A' ) + 10;
      MinFormat := 16;
    end;
    inc( Token );
  end;
  //      'H'/'h'  '.'{'H'/'B'/'O'/'D'}
  if Format = 0 then
  begin
    if Token^ in [ 'H', 'h' ] then
    begin
      Format := 16; inc( Token );
    end
      else
    if Token^ = '.' then
    begin
      inc( Token );
      CASE Upper[ Token^ ] OF
      'O': Format := 8;
      'B': Format := 2;
      'H': Format := 16;
      'D': Format := 10;
      else Format := 10;
      END;
      inc( Token );
    end;
  end;
  if (Format <> 0) and (Format < MinFormat) then
    Error( 'Number syntax error' )
  else
  if (Format = 0) and (MinFormat < 10) then
    Format := 10
  else
  if MinFormat > Format then Format := MinFormat;
  CASE Format OF
  2: Result := Result2;
  8: Result := Result8;
  10:Result := Result10;
  else Result := Result16;
  END;
  Cur := Token;
  Next;
end;

procedure TZXCompiler.OpADD;
var i, Prefix: Integer;
begin
  if TokenInIdx( [ 'BC', 'DE', 'HL', 'SP', 'IX', 'IY' ], i ) then
  begin
    Prefix := 0;
    if (i = 2) and TokenEq( ',' ) then
    begin
      if not TokenInIdx( [ 'BC', 'DE', 'HL', 'SP' ], i ) then
        Error( 'Waiting for register pair BC, DE, HL or SP' );
    end
      else
    if (i = 4) and TokenEq( ',' ) then
    begin
      Prefix := $DD;
      if not TokenInIdx( [ 'BC', 'DE', 'IX', 'SP' ], i ) then
        Error( 'Waiting for register pair BC, DE, IX or SP' );
    end
      else
    if (i = 5) and TokenEq( ',' ) then
    begin
      Prefix := $FD;
      if not TokenInIdx( [ 'BC', 'DE', 'IY', 'SP' ], i ) then
        Error( 'Waiting for register pair BC, DE, IY or SP' );
    end;
    CASE i OF
    5: begin Prefix := $DD; i := 2; end;
    6: begin Prefix := $FD; i := 2; end;
    END;
    if Prefix <> 0 then OutByte( Prefix );
    OutByte( 9 + i * 16 );
    Exit;
  end;
  Op_Arithmetic_A( $80, $C6 );
end;

procedure TZXCompiler.OpCALL;
var i: Integer;
begin
  if Pass = 0 then
  else if Pass = 1 then AddrNext := AddrStart + 3;
  if TokenInIdx( [ 'NZ', 'Z', 'NC', 'C', 'PO', 'PE', 'P', 'M' ], i ) then
  begin
    OutByte( $C4 + i * 8 ); Wait( ',' );
  end
  else OutByte( $CD );
  i := Expression;
  OutWord( i );
  if TokenEq( ',' ) then SkipExpression;
end;

procedure TZXCompiler.OpDJNZ;
var i: Integer;
begin
  if Pass = 0 then
  else if Pass = 1 then AddrNext := Addr + 2;
  OutByte( $10 );
  i := Expression;
  i := SmallInt( Word( i ) - AddrNext );
  if (i < -128) or (i > 127) then
  if (Pass > 1) and not Ignore_TooLongOffset then
    Error( 'Too long jump offset ' + Int2Str( i ) );
  OutByte( i );
  if TokenEq( ',' ) then SkipExpression;
end;

function TZXCompiler.Operand: Word;
var s: PChar;
    i, j: Integer;
    SaveCurLabel: Integer;
begin
  Result := 0;
  if TokenEq( '-' ) then
    Result := - Operand
  else if TokenEq( '+' ) then
    Result := Operand
  else if TokenEq( '~' ) then
    Result := not Operand
  else if TokenEq( '(' ) then
  begin
    Result := Expression;
    Wait( ')' );
  end
  else if Token^ in [ '''', '"' ] then
  begin
    s := Token; inc( Token );
    if Token^ = s^ then
      Error( 'At least one char must be present in quotations' )
    else
    begin
      Result := Ord( Encode[ Token^ ] );
      inc( Token );
      if Token^ < ' ' then
        Error( 'Unterminated string' )
      else
      begin
        if Token^ <> s^ then
        begin
          Result := Result or Ord( Token^ ) shl 8;
          inc( Token );
        end;
        if Token^ <> s^ then
          Error( 'Too long string to use in expression' )
        else inc( Token );
      end;
      Cur := Token; Next;
    end;
  end
  else if TokenEq( 'SIZEOF' ) then
  begin
    Wait( '(' ); MustBeIdentifier;
    i := FindLabel( Token, Len, ' ' );
    if i < 0 then
    begin
      if Pass = 0 then
      else if NeedAllValues and (Options and Option_StrongAddrCtl <> 0) then
        Error( 'Name ' + TokenStr + ' not yet defined' )
      else if (Pass = 1) or (Skip_Level > 0) then
      begin
        if Skip_Level = 0 then
          Undefined.AddObject( TokenStr, CurLabel );
      end
      else Error( 'Name ' + TokenStr + ' not yet defined' );
    end
      else
    begin
      j := Labels.Objects[ i ];
      if DWORD( j ) <> Struct_Start then
        Error( 'Name ' + TokenStr + ' must be structure name' )
      else
      begin
        Result := 0;
        for i := i+1 to Labels.Count-1 do
        begin
          if Integer( Labels.Objects[ i ] ) < 0 then
            continue;
          if Labels.Objects[ i ] and Field_Flag <> 0 then
            Result := Labels.Objects[ i ] and $FFFF
          else break;
        end;
      end;
    end;
    Next; Wait( ')' );
  end
  else if TokenEq( '$' ) then
  begin
    Result := AddrStart;
    DotAsOperandUsed := TRUE;
  end
  else if TokenEq( '.' ) then
  begin
    if TreatDotAsAddr then Result := Addr
    else Result := AddrNext;
    DotAsOperandUsed := TRUE;
  end
  else if IsIdentifier then
  begin
    //       
    //    ('/'),   
    //     (   -
    //    '/').
    s := Token+1;
    i := Len-1;
    while (i > 0) and (s^ <> '/') do
    begin
      inc( s ); dec( i );
    end;
    if s^ = '/' then
    begin
      Len := i;
      Cur := s;
    end;

    i := FindLabel( Token, Len, ' ' );
    if i < 0 then
    begin
      if Pass = 0 then
      else if NeedAllValues and (Options and Option_StrongAddrCtl <> 0) then
        Error( 'Name ' + TokenStr + ' not yet defined' )
      else if (Pass = 1) or (Skip_Level > 0) then
      begin
        if Skip_Level = 0 then
          Undefined.AddObject( TokenStr, CurLabel );
      end
      else
      if CouldBeHexNumber( TokenStr ) then
      begin
        Result := Number; Exit;
      end
      else
        Error( 'Name ' + TokenStr + ' not defined' );
    end
    else
    begin
      j := Labels.Objects[ i ];
      Result := j;
      if DWORD( j ) = Struct_Start then
      begin
        Result := 0;
        SaveCurLabel := CurLabel;
        CurLabel := i; Next; Wait( '.' );
        REPEAT
          if not MustBeIdentifier then Exit;
          i := FindLabel( Token, Len, '!' );
          if i < 0 then Error( 'Field ' + TokenStr + ' not found' );
          Result := Labels.Objects[ i ] and $FFFF;
        UNTIL not TokenEq( '.' );
        CurLabel := SaveCurLabel;
      end;
    end;
    Next;
  end
  else
  CASE Upper[ Token^ ] OF
  '.': begin
         if TreatDotAsAddr then Result := Addr
         else Result := AddrNext;
         Cur := Token+1; Next;
         DotAsOperandUsed := TRUE;
       end;
  '0'..'9', '#', '%', 'A'..'F': Result := Number;
  '$': if Options and Option_BaxHex <> 0 then Result := Number
       else Error( 'Syntax error' );
  else Error( 'Syntax error' );
       Next;
  END;
end;

procedure TZXCompiler.OpEX;
var i: Integer;
begin
  if TokenInIdx( [ 'AF', 'DE', '(' ], i ) then
  CASE i OF
  0: begin
       if TokenEq( ',' ) then
       begin
         Wait( 'AF' );
         if TokenEq( '''' ) then;
       end;
       OutByte( 8 );
     end;
  1: begin
       Wait( ',' );
       if TokenInIdx( [ 'HL', 'IX', 'IY' ], i ) then
       CASE i OF
       0: OutByte( $EB );
       1: OutBytes( [ $DD, $EB ] );
       2: OutBytes( [ $FD, $EB ] );
       END else Error( 'Waiting for HL, IX or IY' );
     end;
  2: begin
       Wait( 'SP' ); Wait( ')' ); Wait( ',' );
       if TokenInIdx( [ 'HL', 'IX', 'IY' ], i ) then
       CASE i OF
       0: OutByte( $E3 );
       1: OutBytes( [ $DD, $E3 ] );
       2: OutBytes( [ $FD, $E3 ] );
       END else Error( 'Waiting for HL, IX or IY' );
     end;
  END else Error( 'Waiting for AF, DE or (SP)' );
end;

procedure TZXCompiler.OpIM;
var i: Integer;
begin
  if Pass = 1 then AddrNext := Addr + 2;
  i := Expression;
  CASE i OF
  0: OutBytes( [ $ED, $46 ] );
  1: OutBytes( [ $ED, $56 ] );
  2: OutBytes( [ $ED, $5E ] );
  else Error( 'Invalid operand ' + Int2Str( i ) );
  END;
end;

procedure TZXCompiler.OpIN;
var i: Integer;
begin
  if TokenEq( 'A' ) then
  begin
    Wait( ',' );
    if TokenEq( '(' ) then
    begin
      if TokenEq( 'C' ) then
      begin
        Wait( ')' ); OutBytes( [ $ED, $78 ] );
        Exit;
      end;
      i := Expression; Wait( ')' );
    end else i := Expression;
    OutBytes( [ $DB, i ] );
  end
  else if TokenInIdx( [ 'B', 'C', 'D', 'E', 'H', 'L', 'F', 'A' ], i ) then
  begin
    Wait( ',' ); Wait( '(' ); Wait( 'C' ); Wait( ')' );
    OutBytes( [ $ED, $40 + 8 * i ] );
  end
  else
  begin
    i := Expression;
    OutBytes( [ $DB, i ] );
  end;
end;

procedure TZXCompiler.OpJP;
var i: Integer;
    wait_close_bracket: Boolean;
    prefix: Char;
begin
  if Pass = 1 then AddrNext := Addr + 3;
  if TokenInIdx( [ 'NZ', 'Z', 'NC', 'C', 'PO', 'PE', 'P', 'M' ], i ) then
  begin
    OutByte( $C2 + 8 * i );
    Wait( ',' );
  end
  else
  begin
    wait_close_bracket := FALSE;
    if CheckTokenEq( '(' ) and NextIn( [ 'HL', 'IX', 'IY' ] ) then
    begin
      Next; wait_close_bracket := TRUE;
    end;
    if TokenInIdx( [ 'HL', 'IX', 'IY' ], i ) then
    begin
      CASE i OF
      0: OutByte( $E9 );
      1: OutBytes( [ $DD, $E9 ] );
      2: OutBytes( [ $FD, $E9 ] );
      3:
      END;
      if wait_close_bracket then Wait( ')' );
      Exit;
    end;
    OutByte( $C3 );
  end;
  prefix := Token^;
  if TokenIn( [ '<', '>' ] ) then
  begin
    MustBeIdentifier;
    if Pass = 0 then
    else if pass = 1 then i := -1
    else i := FindLabel( Token, Len, prefix );
    if i < 0 then
    begin
      if pass > 1 then Error( 'Label ' + TokenStr + ' not defined' );
    end
    else i := Labels.Objects[ i ];
    Next;
  end
  else i := Expression;
  OutWord( i );
  if TokenEq( ',' ) then SkipExpression;
end;

procedure TZXCompiler.OpJR;
var i: Integer;
    prefix: Char;
begin
  if Pass = 1 then AddrNext := Addr + 2;
  if TokenInIdx( [ 'NZ', 'Z', 'NC', 'C' ], i ) then
  begin
    OutByte( $20 + 8 * i ); Wait( ',' );
  end
  else OutByte( $18 );
  prefix := Token^;
  if TokenIn( [ '<', '>' ] ) then
  begin
    MustBeIdentifier;
    if Pass = 0 then
    else if pass = 1 then i := -1
    else i := FindLabel( Token, Len, prefix );
    if i < 0 then
    begin
      if pass > 1 then Error( 'Label ' + TokenStr + ' not defined' );
    end
    else i := Labels.Objects[ i ];
    Next;
  end
  else i := Expression;
  i := SmallInt( Word( i ) - AddrNext );
  if (i < -128) or (i > 127) then
  if (Pass > 1) and not Ignore_TooLongOffset then
    Error( 'Too long jump offset ' + Int2Str( i ) );
  OutByte( i );
  if TokenEq( ',' ) then SkipExpression;
end;

procedure TZXCompiler.OpLD;
var i, j, k: Integer;
begin
  if TokenInIdx( [ 'BC', 'DE', 'HL', 'SP', 'IX', 'IY' ], i ) then
  begin
    CASE i OF
    4: OutByte( $DD );
    5: OutByte( $FD );
    END; if i >= 4 then i := 2;
    Wait( ',' ); if Pass = 1 then AddrNext := Addr + 3;
    if (i = 3) and TokenInIdx( [ 'HL', 'IX', 'IY' ], j ) then
    CASE j OF
    0: OutByte( $F9 );
    1: OutBytes( [ $DD, $F9 ] );
    2: OutBytes( [ $FD, $F9 ] );
    END
    else if TokenEq( '(' ) then
    begin
      if i <> 2 then if Pass = 1 then AddrNext := Addr + 4;
      j := Expression;
      CASE i OF
      2  : OutBytes( [ $2A, j, j shr 8 ] );
      else OutBytes( [ $ED, $4B + i * 16, j, j shr 8 ] );
      END;
      if TokenEq( ',' ) then SkipTo( ')' );
      Wait( ')' );
    end
    else
    begin
      j := Expression;
      OutBytes( [ 1 + i * 16, j, j shr 8 ] );
      if TokenEq( ',' ) then SkipExpression;
    end;
  end
  else if TokenInIdx( [ 'B', 'C', 'D', 'E', 'H', 'L', 'M', 'A', 'I', 'R',
                        'IXH', 'IXL', 'IYH', 'IYL' ], i ) then
  CASE i OF
  0..7: begin Wait( ',' );
          if (i = 7) and TokenInIdx( [ 'I', 'R', '(' ], j ) or
             (i <= 5) and TokenInIdx( [ '', '', '(' ], j ) then
          CASE j OF
          0: OutBytes( [ $ED, $57 ] );
          1: OutBytes( [ $ED, $5F ] );
          2: begin
               if TokenInIdx( [ 'BC', 'DE', 'HL', 'IX', 'IY' ], j ) then
               begin
                 CASE j OF
                 0: OutByte( $0A );
                 1: OutByte( $1A );
                 2: OutByte( $40 + i * 8 + 6 );
                 3: OutBytes( [ $DD, $40 + i * 8 + 6 ] );
                 4: OutBytes( [ $FD, $40 + i * 8 + 6 ] );
                 END;
                 if j >= 3 then
                 begin
                   if Pass = 1 then AddrNext := AddrStart + 3; j := 0;
                   if CheckTokenIn( [ '+', '-' ] ) then
                     j := SmallInt( Expression );
                   if ((j < -128) or (j > 127)) and not Ignore_TooLongOffset
                      and (Pass >= 2) then
                     Error( 'Too big offset ' + Int2Str( j ) );
                   OutByte( j );
                   if TokenEq( ',' ) then SkipTo( ')' );
                 end;
               end
               else
               begin
                 if Pass = 1 then AddrNext := AddrStart + 3;
                 j := Expression;
                 OutBytes( [ $3A, j, j shr 8 ] );
                 if TokenEq( ',' ) then SkipTo( ')' );
               end;
               Wait( ')' );
             end;
          END
          else if TokenInIdx( [ 'B', 'C', 'D', 'E', 'H', 'L', 'M', 'A' ], j ) then
          begin
            if (i = 6) and (j = 6) then Error( 'Invalid operation' );
            OutByte( $40 + i * 8 + j );
          end
          else if TokenInIdx( [ 'IXH', 'IXL', 'IYH', 'IYL' ], j ) then
          CASE j OF
          0: OutBytes( [ $DD, $40 + i * 8 + 4 ] );
          1: OutBytes( [ $DD, $40 + i * 8 + 5 ] );
          2: OutBytes( [ $FD, $40 + i * 8 + 4 ] );
          3: OutBytes( [ $FD, $40 + i * 8 + 5 ] );
          END
          else
          begin
            if Pass = 1 then AddrNext := Addr + 2;
            j := Expression; OutByte( $06 + i * 8 ); OutByte( j );
          end;
        end;
  8   : if TokenEq( ',' ) and TokenEq( 'A' ) then
          OutBytes( [ $ED, $47 ] )
        else Error( 'Waiting for ,A' );
  9   : if TokenEq( ',' ) and TokenEq( 'A' ) then
          OutBytes( [ $ED, $4F ] )
        else Error( 'Waiting for ,A' );
  10  : begin Wait( ',' );
          if TokenInIdx( [ 'B', 'C', 'D', 'E', 'H', 'L', '', 'A' ], j ) then
          begin
            OutBytes( [ $DD, $40 + 4 * 8 + j ] );
          end
          else if TokenInIdx( [ 'IXH', 'IXL' ], j ) then
          CASE j OF
          0: OutBytes( [ $DD, $40 + 4 * 8 + 4 ] );
          1: OutBytes( [ $DD, $40 + 4 * 8 + 5 ] );
          END
          else
          begin
            if Pass = 1 then AddrNext := AddrStart + 3;
            j := Expression; OutBytes( [ $DD, $06 + 4 * 8, j ] );
          end;
        end;
  11  : begin Wait( ',' );
          if TokenInIdx( [ 'B', 'C', 'D', 'E', 'H', 'L', '', 'A' ], j ) then
          begin
            OutBytes( [ $DD, $40 + 5 * 8 + j ] );
          end
          else if TokenInIdx( [ 'IXH', 'IXL' ], j ) then
          CASE j OF
          0: OutBytes( [ $DD, $40 + 5 * 8 + 4 ] );
          1: OutBytes( [ $DD, $40 + 5 * 8 + 5 ] );
          END
          else
          begin
            if Pass = 1 then AddrNext := AddrStart + 3;
            j := Expression; OutBytes( [ $DD, $06 + 5 * 8, j ] );
          end;
        end;
  12  : begin Wait( ',' );
          if TokenInIdx( [ 'B', 'C', 'D', 'E', 'H', 'L', '', 'A' ], j ) then
          begin
            OutBytes( [ $FD, $40 + 4 * 8 + j ] );
          end
          else if TokenInIdx( [ 'IYH', 'IYL' ], j ) then
          CASE j OF
          0: OutBytes( [ $FD, $40 + 4 * 8 + 4 ] );
          1: OutBytes( [ $FD, $40 + 4 * 8 + 5 ] );
          END
          else
          begin
            if Pass = 1 then AddrNext := AddrStart + 3;
            j := Expression; OutBytes( [ $FD, $06 + 4 * 8, j ] );
          end;
        end;
  13  : begin Wait( ',' );
          if TokenInIdx( [ 'B', 'C', 'D', 'E', 'H', 'L', '', 'A' ], j ) then
          begin
            OutBytes( [ $FD, $40 + 5 * 8 + j ] );
          end
          else if TokenInIdx( [ 'IYH', 'IYL' ], j ) then
          CASE j OF
          0: OutBytes( [ $FD, $40 + 5 * 8 + 4 ] );
          1: OutBytes( [ $FD, $40 + 5 * 8 + 5 ] );
          END
          else
          begin
            if Pass = 1 then AddrNext := AddrStart + 3;
            j := Expression; OutBytes( [ $FD, $06 + 5 * 8, j ] );
          end;
        end;
  END
  else if TokenEq( '(' ) then
  begin
    if TokenInIdx( [ 'BC', 'DE', 'HL', 'IX', 'IY' ], i ) then
    begin
      CASE i OF
      0: begin
           Wait( ')' ); Wait( ',' ); Wait( 'A' );
           OutByte( $02 ); Exit;
         end;
      1: begin
           Wait( ')' ); Wait( ',' ); Wait( 'A' );
           OutByte( $12 ); Exit;
         end;
      3: OutByte( $DD );
      4: OutByte( $FD );
      END;
      if Pass = 1 then AddrNext := AddrStart + 3;
      j := 0;
      if i >= 3 then
      begin
        if CheckTokenIn( [ '+', '-' ] ) then j := SmallInt( Expression );
        if ((j < -128) or (j > 127)) and not Ignore_TooLongOffset and
           (Pass >= 2) then
          Error( 'Too big offset ' + Int2Str( j ) );
        if TokenEq( ',' ) then SkipTo( ')' );
      end;
      Wait( ')' ); Wait( ',' );
      if TokenInIdx( [ 'B', 'C', 'D', 'E', 'H', 'L', '', 'A' ], k ) then
      begin
        OutByte( $70 + k );
        if i>= 3 then OutByte( j );
      end
      else if i >= 2 then
      begin
        k := Expression;
        OutByte( $36 );
        if i>= 3 then OutByte( j );
        OutByte( k );
      end else Error( 'Right operand syntax invalid' );
    end
      else
    begin
      i := Expression;
      if TokenEq( ',' ) then SkipTo( ')' );
      Wait( ')' ); Wait( ',' );
      if TokenInIdx( [ 'BC', 'DE', 'HL', 'SP', 'IX', 'IY', 'A' ], j ) then
      CASE j OF
      0,1,3: OutBytes( [ $ED, $43 + j * 16, i, i shr 8 ] );
      2    : OutBytes( [ $22, i, i shr 8 ] );
      4    : OutBytes( [ $DD, $22, i, i shr 8 ] );
      5    : OutBytes( [ $FD, $22, i, i shr 8 ] );
      6    : OutBytes( [ $32, i, i shr 8 ] );
      END
      else Error( 'Right operand syntax invalid' );
    end;
  end
  else Error( 'Left operand syntax invalid' );
end;

procedure TZXCompiler.OpOUT;
var i: Integer;
begin
  if TokenEq( '(' ) then
  begin
    if TokenEq( 'C' ) then
    begin
      Wait( ')' );
      if TokenEq( ',' ) then
      begin
        if TokenInIdx( [ 'B', 'C', 'D', 'E', 'H', 'L', '0', 'A' ], i ) then
          OutBytes( [ $ED, $41 + i * 8 ] )
        else Error( 'Waiting for register or 0' );
      end
      else OutBytes( [ $ED, $41 + 7 * 8 ] );
      Exit;
    end
      else
    begin
      i := Expression; Wait( ')' );
    end;
  end else i := Expression;
  if TokenEq( ',' ) then Wait( 'A' );
  OutBytes( [ $D3, i ] );
end;

procedure TZXCompiler.OpRET;
var i: Integer;
begin
  if TokenInIdx( [ 'NZ', 'Z', 'NC', 'C', 'PO', 'PE', 'P', 'M' ], i ) then
    OutByte( $C0 + i * 8 )
  else OutByte( $C9 );
end;

procedure TZXCompiler.OpRST;
var i: Integer;
begin
  if Pass = 1 then AddrNext := AddrStart + 1;
  i := Expression;
  if i >= 8 then
  begin
    if (i and 7 <> 0) or (i > $38) then Error( 'Invalid RST address ' + Int2Str( i ) );
    i := (i shr 3) and 7;
  end;
  OutByte( $C7 or (i shl 3) );
  if TokenEq( ',' ) then Expression
end;

procedure TZXCompiler.Op_ADC_SBC(Base_R, Base_B, Base_RP: Byte);
var i: Integer;
begin
  if TokenInIdx( [ 'BC', 'DE', 'HL', 'SP' ], i ) then
  begin
    if (i = 2) and TokenEq( ',' ) then
    begin
      if not TokenInIdx( [ 'BC', 'DE', 'HL', 'SP' ], i ) then
        Error( 'Waiting for register pair BC, DE, HL or SP' );
    end;
    OutBytes( [ $ED, Base_RP + i * 16 ] );
    Exit;
  end;
  Op_Arithmetic_A( Base_R, Base_B );
end;

procedure TZXCompiler.Op_Arithmetic_A(Base_R, Base_B: Byte);
var i: Integer;
begin
  if TokenEq( 'A' ) then
  begin
    if not TokenEq( ',' ) then
    begin
      OutByte( Base_R + 7 ); Exit; // CP A
      Exit;
    end;
  end;
  if TokenInIdx( [ 'B', 'C', 'D', 'E', 'H', 'L', 'M', 'A',
                   'IXH', 'IXL', 'IYH', 'IYL' ], i ) then
  CASE i OF
  0..7: OutByte( Base_R + i );
  8   : OutBytes( [ $DD, Base_R + 4 ] );
  9   : OutBytes( [ $DD, Base_R + 5 ] );
  10  : OutBytes( [ $FD, Base_R + 4 ] );
  11  : OutBytes( [ $FD, Base_R + 5 ] );
  END
  else if TokenEq( '(' ) then
  begin
    if TokenInIdx( [ 'HL', 'IX', 'IY' ], i ) then
    begin
      CASE i OF
      0: OutByte( Base_R + 6 );
      1: OutByte( $DD );
      2: OutByte( $FD );
      END;
      if i > 0 then
      begin
        if CheckTokenIn( [ '-', '+' ] ) then i := SmallInt( Expression )
        else i := 0;
        if ((i < -128) or (i > 127)) and not Ignore_TooLongOffset then
          Error( 'Too long offset' );
        OutByte( Base_R + 6 );
        OutByte( i );
        if TokenEq( ',' ) then SkipTo( ')' );
      end;
    end
      else
    begin
      i := Expression;
      OutBytes( [ Base_B, i ] );
    end;
    Wait( ')' );
  end
    else
  begin
    i := Expression;
    OutBytes( [ Base_B, i ] );
  end;
end;

procedure TZXCompiler.Op_BIT_RES_SET(Base: Byte);
var i, n, r: Integer;
begin
  n := Expression; Wait( ',' );
  if n > 7 then
  begin
    Error( 'Bit number too big ' + Int2Str( n ) );
    n := n and 7;
  end;
  if TokenInIdx( [ 'B', 'C', 'D', 'E', 'H', 'L', 'M', 'A', '(' ], i ) then
  CASE i OF
  0..7: OutBytes( [ $CB, Base + n * 8 + i ] );
  8   : begin
          if TokenEq( 'HL' ) then
          begin
            Wait( ')' ); OutBytes( [ $CB, Base + n * 8 + 6 ] );
          end
          else if TokenInIdx( [ 'IX', 'IY' ], i ) then
          begin
            CASE i OF
            0: OutBytes( [ $DD, $CB ] );
            1: OutBytes( [ $FD, $CB ] );
            END;
            if CheckTokenIn( [ '-', '+' ] ) then i := SmallInt( Expression )
            else i := 0;
            if ((i < -128) or (i > 127)) and not Ignore_TooLongOffset and
               (Pass >= 2) then
              Error( 'Too big offset ' + Int2Str( i ) );
            if TokenEq( ',' ) then SkipTo( ')' );
            Wait( ')' );
            r := 6;
            if TokenEq( ',' ) then
              if not TokenInIdx( [ 'B', 'C', 'D', 'E', 'H', 'L', '', 'A' ], r ) then
                Error( 'Waiting for register' );
            OutBytes( [ i, Base + n * 8 + r ] );
          end else Error( 'Waiting for HL, IX or IY' );
        end;
  END else Error( 'Waiting for register or memory operand' );
end;

procedure TZXCompiler.Op_INC_DEC(Base_R, Base_RP: Byte);
var i: Integer;
begin
  if TokenInIdx( [ 'BC', 'DE', 'HL', 'SP', 'IX', 'IY' ], i ) then
  CASE i OF
  0..3: OutByte( Base_RP + i * 16 );
  4   : OutBytes( [ $DD, Base_RP + 2 * 16 ] );
  5   : OutBytes( [ $FD, Base_RP + 2 * 16 ] );
  END
  else if TokenInIdx( [ 'B', 'C', 'D', 'E', 'H', 'L', 'M', 'A', '(',
          'IXH', 'IXL', 'IYH', 'IYL' ], i ) then
  CASE i OF
  0..7: OutByte( Base_R + i * 8 );
  8   : begin
          if TokenEq( 'HL' ) then
            OutByte( Base_R + 6 * 8 )
          else if TokenInIdx( [ 'IX', 'IY' ], i ) then
          begin
            CASE i OF
            0: OutByte( $DD );
            1: OutByte( $FD );
            END; OutByte( Base_R + 6 * 8 );
            if CheckTokenIn( [ '+', '-' ] ) then i := SmallInt( Expression )
            else i := 0;
            if ((i < -128) or (i > 127)) and not Ignore_TooLongOffset and
               (Pass >= 2) then
              Error( 'Too big offset ' + Int2Str( i ) );
            OutByte( i );
            if TokenEq( ',' ) then SkipTo( ')' );
          end;
          Wait( ')' );
        end;
  9   : OutBytes( [ $DD, Base_R + 4 * 8 ] );
  10  : OutBytes( [ $DD, Base_R + 5 * 8 ] );
  11  : OutBytes( [ $FD, Base_R + 4 * 8 ] );
  12  : OutBytes( [ $FD, Base_R + 5 * 8 ] );
  END else Error( 'Waiting for register or memory or register pair' );
end;

procedure TZXCompiler.Op_Shift(Base_R: Byte);
var i, r: Integer;
begin
  if TokenInIdx( [ 'B', 'C', 'D', 'E', 'H', 'L', 'M', 'A', '(' ], i ) then
  CASE i OF
  0..7: OutBytes( [ $CB, Base_R + i ] );
  8   : begin
          if TokenInIdx( [ 'HL', 'IX', 'IY' ], i ) then
          begin
            CASE i OF
            0: OutBytes( [ $CB, Base_R+6 ] );
            1: OutBytes( [ $DD, $CB ] );
            2: OutBytes( [ $FD, $CB ] );
            END;
            if i > 0 then
            begin
              if Pass = 1 then AddrNext := AddrStart + 4;
              if CheckTokenIn( [ '+', '-' ] ) then i := SmallInt( Expression )
              else i := 0;
              if ((i < -128) or (i > 127)) and (Pass > 1) and
                 not Ignore_TooLongOffset then
                Error( 'Too long offset ' + Int2Str( i ) );
              r := 6;
              if TokenEq( ',' ) then SkipTo( ')' );
              Wait( ')' );
              if TokenEq( ',' ) then
              if not TokenInIdx( [ 'B', 'C', 'D', 'E', 'H', 'L', '', 'A' ], r ) then
                Error( 'Waiting register' );
              OutBytes( [ i, Base_R+r ] );
              Exit;
            end;
          end else Error( 'Waiting for HL, IX or IY' );
          Wait( ')' );
        end;
  END else Error( 'Waiting for register or memory operand' );
end;

procedure TZXCompiler.OutByte(b: Byte);
var pg: Integer;
    Base: PMemBlock;
begin
  if Skip_Level > 0 then Exit;
  if Ignore_Out = 0 then
  begin
    {$IFDEF LOG_OUT}
    LogFileOutput( 'C:\ZXAsmPP' + Int2Str( Pass ) + '.log',
      Int2Hex( Addr, 4 ) + ' ' + Int2Hex( b, 2 ) );
    {$ENDIF}
    if ((Pass = 2) and not Pass3_needed or (Pass = 3)) then
    begin
      if OrgBank = OrgCur64K then
        pg := Memory.Pages[ Addr shr 14 ]
      else pg := OrgBank;
      if pg < 0 then
      begin
        Base := Memory.ROMPages[ -pg - 1 ];
        if Options and Option_NoAskAnswerNo <> 0 then
        begin
          IncAddr; Exit;
        end;
        if (Options and Option_ROMAllowRewrite = 0) and not AskedEditROM then
        begin
          AskedEditROM := TRUE;
          CASE MessageBox( 0, PChar( 'Changing ROM requested at addr ' +
               Int2Hex( Addr, 4 ) + 'H. Enable write to ROM area?'),
               'ZXAsm++', MB_YESNO or MB_DEFBUTTON2 ) OF
          ID_YES: Options := Options or Option_ROMAllowRewrite;
          else IncAddr; Exit;
          END;
        end;
      end
      else
        Base := Memory.RAMPages[ pg ];
      Base[ Addr and $3FFF ] := b;
    end;
  end;
  IncAddr;
end;

procedure TZXCompiler.OutBytes(const a: array of Byte);
var i: Integer;
begin
  for i := 0 to High( a ) do
    OutByte( a[ i ] );
end;

procedure TZXCompiler.OutWord(w: Word);
begin
  OutByte( w and $FF );
  OutByte( w shr 8 );
end;

procedure TZXCompiler.ReplaceDefines;
var s, s0, d: PChar;
    i, L, start: Integer;
    yes_replace: Boolean;
    sBuffer: PChar;
    sLen: Integer;
    prev_was_FOR: Boolean;
    extract_substring: Boolean;
begin
  s := Token;
  yes_replace := FALSE;
  while not( s^ in [ #13, #10, #0 ]) do
  begin
    if s^ in IdentifierStart then
    begin
      s0 := s;
      inc( s );
      while s^ in IdentifierContinue do inc( s );
      L := DWORD( s ) - DWORD( s0 );
      for i := Defines.Count-1 downto 0 do
      begin
        d := Defines.Names[ i ].NameStart;
        if (d^ = s0^) and (L = Defines.Names[ i ].NameLen) and
           (StrLComp( d, s0, L ) = 0) then
        begin
          yes_replace := TRUE;
          break;
        end;
      end;
      if yes_replace then break;
    end else inc( s );
  end;
  if not yes_replace then Exit;
  //      Cur (   )
  //      
  Cur := Token;
  s := Cur;
  sBuffer := AllocMemFast( 1 );
  sLen := 0;
  prev_was_FOR := FALSE;
  while not( Cur^ in [ #13, #10, #0 ] ) do
  begin
    while not( s^ in [ #13, #10, #0 ]) do
    begin
      if s^ in IdentifierStart then break;
      inc( s );
    end;
    L := DWORD( s ) - DWORD( Cur );
    if L > 0 then
    begin
      sBuffer := ReallocateMemFast( sBuffer, sLen + L + 1 );
      Move( Cur^, sBuffer[ sLen ], L );
      inc( sLen, L ); sBuffer[ sLen ] := #0;
    end;
    Cur := s;
    if Cur^ in [ #13, #10, #0 ] then break;
    // Cur->   , ,   
    inc( s );
    while (s^ in IdentifierContinue) do inc( s );
    L := DWORD( s ) - DWORD( Cur );
    yes_replace := FALSE;
    if not prev_was_FOR then
    {  ,    FOR   
         ,   FOR  
                }
    for i := Defines.Count-1 downto 0 do
    begin
      d := Defines.Names[ i ].NameStart;
      if (d^ = Cur^) and (Defines.Names[ i ].NameLen = L) and
         (StrLComp( d, Cur, L ) = 0) then
      begin //   -  
        extract_substring := FALSE;
        if (sLen > 0) and (sBuffer[ sLen-1 ] = '"') and
           (s^ = '"') and (s[ 1 ]='[') then
        begin
          sBuffer := ReallocateMemFast( sBuffer, sLen );
          dec( sLen ); inc( s, 2 );
          extract_substring := TRUE;
        end;
        if (sLen > 0) and (sBuffer[ sLen-1 ] = '.') then
        begin
          sBuffer := ReallocateMemFast( sBuffer, sLen );
          dec( sLen );
        end;
        yes_replace := TRUE;
        d := Pointer( Defines.Objects[ i ] );
        L := StrLen( d );
        if extract_substring then
        begin
          while (s^ <= ' ') and not( s^ in [ #0 ] ) do inc( s );
          start := ScanDecimal( s );
          if start = 0 then
          begin
            Error( 'Invalid start character index ' + Int2Str( start ) );
            start := 1;
          end;
          if start > L then L := 0 else
          begin
            inc( d, start-1 );
            dec( L, start );
          end;
          while (s^ <= ' ') and not( s^ in [ #0 ] ) do inc( s );
          if s^ = ',' then
          begin
            inc( s );
            while (s^ <= ' ') and not( s^ in [ #0 ] ) do inc( s );
            L := min( L, ScanDecimal( s ) );
          end
          else L := 1;
          while (s^ <= ' ') and not( s^ in [ #0 ] ) do inc( s );
          if s^ = ']' then inc( s )
          else Error( 'Waiting for '']''' );
        end;
        if L > 0 then
        begin
          sBuffer := ReallocateMemFast( sBuffer, sLen + L + 1 );
          Move( d^, sBuffer[ sLen ], L );
          inc( sLen, L );
          sBuffer[ sLen ] := #0;
        end;
        prev_was_FOR := FALSE;
        if s^ = '.' then inc( s );
        break;
      end;
    end;
    if not yes_replace then
    begin
      prev_was_FOR := SEq( Cur, L, 'FOR' );
      sBuffer := ReallocateMemFast( sBuffer, sLen + L + 1 );
      Move( Cur^, sBuffer[ sLen ], L );
      inc( sLen, L );
      sBuffer[ sLen ] := #0;
    end;
    Cur := s;
  end;
  //     (strBuffer), ""
  //    :
  IncludeStkPos.Add( Cur );
  IncludeStack.AddObject( '', DWORD( sBuffer ) );
  inc( IncludeStkChanges );
  Cur := sBuffer; Next;
  AtStartOfLine := TRUE;
end;

function TZXCompiler.ReserveLabel: Integer;
begin
  inc( ReservedLabelIdx );
  Result := ReservedLabelIdx;
end;

function TZXCompiler.ScanDecimal(var s: PChar): Integer;
begin
  Result := 0;
  while (s^ in [ '0'..'9' ]) do
  begin
    Result := Result * 10 + Ord( s^ ) - Ord( '0' );
    inc( s );
  end;
end;

function TZXCompiler.ScanFileName: String;
// : Cur      
//   .     INCLUDE  
//     .    
//   ScanFileName   {!} Next;  
//      .
var c: Char;
    s: PChar;
begin
  if Token^ in [ '"', '''' ] then
  begin
    c := Token^;
    inc( Token );
    s := Token;
    while not( Token^ in [ c, #13, #10, #0 ] ) do inc( Token );
    SetString( Result, s, DWORD(Token) - DWORD(s) );
    if Token^ = c then
      inc( Token )
    else Error( 'Unterminated string' );
  end
    else
  begin
    s := Token;
    while not( Token^ in [ #0..' ' ] ) do inc( Token );
    SetString( Result, s, DWORD(Token) - DWORD(s) );
  end;
  Cur := Token;
end;

function TZXCompiler.ScanIncrement(var Inc: TIncrement;
  Prefix: Boolean): Boolean;
begin
  if (Token^ = '+') and (Token[ 1 ] = '+') then
  begin
    Cur := Token+2; Next;
    if Prefix then Inc := inc_prefix
    else Inc := inc_suffix;
    Result := TRUE;
  end
  else if (Token^ = '-') and (Token[ 1 ] = '-') then
  begin
    Cur := Token+2; Next;
    if Prefix then Inc := dec_prefix
    else Inc := dec_suffix;
    Result := TRUE;
  end
  else Result := FALSE;
end;

function TZXCompiler.ScanRegister(var Reg: TRegister; var Alt: Boolean): Boolean;
var i: Integer;
begin
  Reg := noReg;
  Alt := FALSE;
  Result := FALSE;
  if TokenInIdx( [ 'BC', 'DE', 'HL', 'AF', 'SP', 'IX', 'IY', 'B', 'C', 'D',
     'E', 'H', 'L', 'M', 'A', 'IXH', 'IXL', 'IYH', 'IYL', 'I', 'R' ], i ) then
  begin
    Reg := TRegister( i );
    CASE Reg OF
    rBC, rDE, rHL, rAF, rB, rC, rD, rE, rH, rL, rM:
      if TokenEq( '''' ) then Alt := TRUE;
    END;
    Result := TRUE;
  end;
end;

function TZXCompiler.SearchLabelBack(aName: PChar; aLen: Integer; Special: Char;
  chk: Word): Integer;
var i: Integer;
    s: PChar;
    Level: Integer;
    IsLocal: Boolean;
begin
  IsLocal := IsLocalPrefix( aName^ );
  Level := 0;
  for i := Min( Labels.Count-1, CurLabel-1 ) downto 0 do
  begin
    if Labels.Objects[ i ] = Proc_Start then
    begin
      if Level > 0 then Dec( Level );
    end
    else if Labels.Objects[ i ] = Proc_End then
      Inc( Level )
    else if (Compiling_Struct > 0) and
            (Labels.Objects[ i ] = Struct_Start) then break
    else if (Integer( Labels.Objects[ i ] ) < 0) and
            (Labels.Objects[ i ] <> Macro_Marker) and
            (Labels.Objects[ i ] <> Struct_Start) and
            not((Labels.Objects[ i ] = Define_Marker) and
                (Special = '?')) then //     
    else if (Level = 0) and IsLocal or not IsLocal then
    begin
      if (Special = '!') and (Labels.Objects[ i ] and Field_Flag = 0) then
        continue; //    
      if (Labels.Names[ i ].NameLen = aLen) and
         (Labels.Names[ i ].Chk = chk) then
      begin
        s := Labels.Names[ i ].NameStart;
        if (aName^ = s^) and (StrLComp( aName, s, aLen ) = 0) then
        begin
          Result := i; Exit;
        end;
      end;
    end;
  end;
  Result := -1;
end;

function TZXCompiler.SearchLabelFwd(aName: PChar; aLen: Integer; Special: Char;
  chk: Word): Integer;
var i: Integer;
    s: PChar;
    Level: Integer;
    IsLocal: Boolean;
begin
  IsLocal := IsLocalPrefix( aName^ );
  Level := 0;
  for i := CurLabel to Labels.Count-1 do
  begin
    if Labels.Objects[ i ] = Proc_End then
    begin
      if Level > 0 then Dec( Level );
    end
    else if Labels.Objects[ i ] = Proc_Start then
      Inc( Level )
    else if (Integer( Labels.Objects[ i ] ) < 0) and
            (Labels.Objects[ i ] <> Struct_Start) and
            not(IntIn(Labels.Objects[ i ],
                [ Integer( Define_Marker ),
                  Integer( Macro_Marker ) ]) and
                (Special = '?')) then //     
    else if (Level = 0) and IsLocal or not IsLocal then
    begin
      if (Special = '!') and (Labels.Objects[ i ] and Field_Flag = 0) then
        continue; //    
      if (Labels.Names[i].NameLen = aLen) and
         (Labels.Names[ i ].Chk = chk) then
      begin
        s := Labels.Names[ i ].NameStart;
        if (aName^ = s^) and 
           (StrLComp( aName, s, aLen ) = 0) then
        begin
          Result := i; Exit;
        end;
      end;
    end;
  end;
  Result := -1;
end;

function TZXCompiler.SEq(Start: PChar; L: Integer;
  const s: String): Boolean;
var i: Integer;
    p: PChar;
begin
  Result := Length( s ) = L;
  if not Result then Exit;
  Result := FALSE;
  p := Start;
  for i := 1 to L do
  begin
    if Upper[ p^ ] <> s[ i ] then Exit;
    inc( p );
  end;
  Result := TRUE;
end;

function TZXCompiler.SIn(Start: PChar; L: Integer;
  const a: array of String): Boolean;
var i: Integer;
begin
  Result := TRUE;
  for i := 0 to High( a ) do
    if SEq( Start, L, a[ i ] ) then Exit;
  Result := FALSE;
end;

procedure TZXCompiler.SkipExpression;
begin
  inc( Skip_Level );
  Expression;
  dec( Skip_Level );
end;

procedure TZXCompiler.SkipSp;
begin
  AtStartOfLine := FALSE;
  if (Cur^ = ';') or (Cur = '*') and AtStartOfLine then //    
  begin
    while not ( Cur^ in [ #13, #0 ] ) do inc( Cur );
    AtStartOfLine := TRUE;
  end;
  while Cur^ <= ' ' do
  begin
    if Cur^ = #0 then
    begin
      if IncludeStack.Count > 0 then
      begin //   ,   
            //    Include    Src
        Cur := IncludeStkPos.Items[ IncludeStkPos.Count-1 ];
        IncludeStack.DeleteLast;
        IncludeStkPos.Delete( IncludeStkPos.Count-1 );
        inc( IncludeStkChanges );
      end
        else Exit;
    end
    else if Cur^ = #13 then
    begin
      inc( Cur ); if Cur^ = #10 then inc( Cur );
      AtStartOfLine := TRUE;
    end
    else
    inc( Cur );
    if (Cur^ = ';') or AtStartOfLine and (Cur^ = '*') then //    
      while not ( Cur^ in [ #13, #0 ] ) do inc( Cur );
  end;
end;

procedure TZXCompiler.SkipTo(C: Char);
begin
  while not( Token^ in [ C, #0 ] )  do inc( Token );
  Cur := Token; Next;
end;

procedure TZXCompiler.SkipToken(var p: PChar);
begin
  if Len > 0 then inc( TokensScanned );
  if p^ in IdentifierStart then
    // 
    begin
      inc( p );
      if Handling_C_like then
      begin
        while (p^ in IdentifierContinue) and
              not( p^ in [ '&', '|', '^', '!', '?' ] ) do
          inc( p );
      end
        else
      begin
        while p^ in IdentifierContinue do inc( p );
      end;
    end
  else
  CASE p^ OF
  #0: Exit;
  '0'..'9': // /16/8/2
    begin
      inc( p );
      while p^ in [ '0'..'9', 'A'..'F', 'a'..'f' ] do inc( p );
    end;
  else inc( p ); //    - 1-?
  END;
end;

procedure TZXCompiler.SkipToToken(const a: array of String);
begin
  while Token^ <> #0 do
  begin
    if TokenIn( a ) then break;
    Next;
  end;
end;

function TZXCompiler.TokenEq(const s: String): Boolean;
begin
  Result := CheckTokenEq( s );
  if Result then
  begin
    Next;
    if AtStartOfLine and (s = ',') then
      ReplaceDefines;
  end;
end;

function TZXCompiler.TokenIn(const a: array of String): Boolean;
var i: Integer;
begin
  Result := TokenInIdx( a, i );
end;

function TZXCompiler.TokenInIdx(const a: array of String;
  var idx: Integer): Boolean;
var i: Integer;
begin
  for i := 0 to High( a ) do
    if TokenEq( a[ i ] ) then
    begin
      idx := i; Result := TRUE; Exit;
    end;
  idx := -1; Result := FALSE;
end;

function TZXCompiler.TokenInReserved(const a: array of String;
  var idx: Integer; var Hash: array of Byte): Boolean;
var chk: Word;
    s: PChar;
    i, L: Integer;
begin
  if Hash[ 8192 ] = 0 then
  begin //  -   
    Hash[ 8192 ] := 1; //  ,   
    for i := 0 to High( a ) do
    begin
      s := @ a[ i ][ 1 ];
      L := Length( a[ i ] );
      chk := 0;
      while L > 0 do
      begin
        chk := ((chk shl 1) or (chk shr 15)) xor Byte( s^ );
        inc( s ); dec( L );
      end;
      Hash[ chk shr 3 ] := Hash[ chk shr 3 ] or (1 shl (chk and 7));
    end;
  end;
  chk := 0;
  L := Len;
  s := Token;
  while L > 0 do
  begin
    chk := ((chk shl 1) or (chk shr 15)) xor Byte( Upper[ s^ ] );
    inc( s ); dec( L );
  end;
  Result := FALSE;
  if Hash[ chk shr 3 ] and (1 shl (chk and 7)) = 0 then Exit;
  for i := 0 to High( a ) do
  begin
    s := @ a[ i ][ 1 ];
    if (Len = Length( a[ i ] )) and
       (Upper[Token^] = s^) and
       (StrLComp_NoCase( Token, s, Len ) = 0) then
    begin
      idx := i;
      Result := TRUE;
      Next;
      Exit;
    end;
  end;
end;

function TZXCompiler.TokenStartsFrom(const s: String): Boolean;
begin
  Result := (Len >= Length( s )) and
            (StrLComp_NoCase( PChar( s ), Token, Len ) = 0);
  if Result then
  begin
    inc( Token, Length( s ) );
    dec( Len, Length( s ) );
    if Len = 0 then Next;
  end;
end;

function TZXCompiler.TokenStr: String;
begin
  SetString( Result, Token, Len );
end;

function TZXCompiler.Wait(const s: String): Boolean;
begin
  Result := TRUE;
  if TokenEq( s ) then Exit;
  Error( 'Waiting for ' + s );
  Result := FALSE;
end;

end.
