library ZXAsmPP;

uses
  Windows,
  KOL,
  ZxAsmTypes in 'ZxAsmTypes.pas',
  ZXAsmCompile in 'ZXAsmCompile.pas',
  ZXAsmFastMem in 'ZXAsmFastMem.pas';

//{$APPTYPE CONSOLE}

function CompileZX( Src: PChar; IncludeSearchDirs: PChar; AsmOptions: DWORD;
                    Memory: PMemory; OnError: TOnError; OnLabel: TOnLabel )
                    : Integer; stdcall;
begin
  //UseDelphiMemoryManager;
  new( ZXCompiler, Create );
  ZXCompiler.Src := Src;
  ZXCompiler.Memory := Memory;
  ZXCompiler.IncludeDirs := NewStrList;
  ZXCompiler.IncludeDirs.Text := IncludeSearchDirs;
  ZXCompiler.OnError := OnError;
  ZXCompiler.OnLabel := OnLabel;
  ZXCompiler.Options := AsmOptions;
  TRY
    Result := ZXCompiler.CompileZX;
  FINALLY
    ZXCompiler.Free;
  END;
end;

exports CompileZX;

begin
end.
