library LoadTD0;

uses
  Windows, KOL, PluginUnit;

{$DEFINE FIXRLE0}

type
  TByteArray = array[0..1000000] of Byte;
  PByteArray = ^TByteArray;

  THdr = packed record
    sig: array[0..1] of Char;  // signature "TD", null terminated string
                     // (if normal compression used) OR "td" (if Advanced
                     // compression used)
    volseq,          // volume sequence: 0 for staring volume, 1 for the next, etc.
    chksig,          // check signature - must be same for all volumes in a serie
    TDver,           // for v2.11 through v2.16 seems to be 0x15 = 21 decimal
    Density,         // 0: 250Kbps, 1: 300Kbps, 2: 500Kbps.
                     // Bit 7 = 1, if FM (single-density diskette)
    DrvType,         // 1: 360K, 2: 1.2M, 3: 720K (5.25" or 3.5"), 4: 1.44M
    TrkDensity,      // 0: src density = media density, 1: DD media in QD drive,
                     // 2: QD media in DD drive
                     // + among other things can indicate comment field (bit 7 set)
    DosMode,         // 0: no DOS FAT analyzed
    Sides: Byte;     // 0x01 (always with rx50 or 0x02 with most MSDOS disks)
    crc: Word;       //   crc of 1st 0xA bytes in record
  end;

  TComment = packed record
    crc,             //  checksum of 8 bytes from &len to end of record
    len: Word;       // length of string data region following date
    yr,mon,day,
    hr,min,sec: Byte;// date and time info....
  end;

  {
   After the header,  the diskette structure information and  sector
   data  follows.	  If advanced data compression was used to produce
   this file, the information appears in 6,144 byte blocks of 12 bit
   Lempel-Zev code.   Each block is preceded by a 2 byte CRC and a 2
   byte code packet count (one packet = 12 bits).
  }

  TTrackRec = packed record
    nsec,            // number of sectors on track. 255: end of data
    trk,             // physical cylinder number, 0 based
    head: Byte;      // head number, 0 based (0..1)
    crc: Byte;       // sum of 3 bytes above by modulo 256
  end;

  TSectorRec = packed record
    trk,head,sec: Byte; // Logical trk,head,sector following dat is for
    secsz,              // bytes in sec = 128 * (2 ^ secsz)
    Syndroms: Byte;     // 1: This sector number occurred more than once on this track
                        // 2: A data CRC error occurred when this sector  was read.
                        // 4: A deleted data control mark was present for this sector.
                        // 16: A DOS sector copy was requested;
                        //     this sector was not allocated.
                        //     In this case,  no sector data follows this header.
                        // 32: This sector's data field is missing;
                        //     no sector data follows this header
                        // 64: No ID address field was present for this sector,
                        //     but there is a data field.
                        // The sector information in the header represents
                        // fabricated information.
  end;

  TSectorDataRec = packed record
    crc: Byte;          // if there is sector data, this is low byte of crc
                        //   for entire sector
                        // its NOT crc of 1st 5 bytes, see DSCRC
    unknwn: Word;       // please tell me if you have a guess! (see eof)
    flag: Byte;         // controls extra bytes and use
                        // 0: read the full sector directly from the file
                        // 1: read next 4 bytes and treat as a rep_rec;
                        //    fill sector with rep_rec.count repeats of rep_rec.pat[]
                        //    I believe this implies count is always half the sector size
                        // 2: repeat until sector buffer is full:
                        //    read 2 bytes and treat as start of pat_rec
                        //    flag value and count determine action.
                        //    I call this a fragmented read as multiple
                        //    pat_rec reads are required to fill the buffer.
  end;

  TRepRec = packed record
    count: Word;
    pat: Word;
  end;

  TPatRec = packed record
    flag,count: Byte;
    pat: array[0..1] of Byte; //if flag > 0, repeat pat count times
  end;

var TDError: PChar = nil;

//------------------------------------------------------------------------------
// LZH unpacking
const
  N = 4096; // buffer size
  F = 60;   // lookahead buffer size
  THRESHOLD = 2;
  N_CHAR = (256 - THRESHOLD + F); // kind of characters (char code = 0..N_CHAR-1)
  T = N_CHAR * 2 - 1;             // size of table
  RootPos = T - 1;                // position of root
  MAX_FREQ = $8000;               // updates tree when the root frequency comes to this
var r: Integer;
    text_buf: array[ 0..N+F-2 ] of Char;
    freq: array[ 0..T ] of Word;  // frequency table
    prnt: array[ 0..T+N_CHAR-1 ] of SmallInt; // pointers to parent nodes
      // except for the elements [T..T+N_CHAR-1] which are used to get the positions
      // of leaves corresponding to the codes.
    son: array[ 0..T-1 ] of SmallInt; // pointers to child nodes (son[ ], son[ ]+1)
    getbuf: Integer;
    getlen: Byte;
    SrcStrm: PStream;

const d_code: array[0..255] of Byte = (
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,
        $00, $00, $00, $00, $00, $00, $00, $00,
        $01, $01, $01, $01, $01, $01, $01, $01,
        $01, $01, $01, $01, $01, $01, $01, $01,
        $02, $02, $02, $02, $02, $02, $02, $02,
        $02, $02, $02, $02, $02, $02, $02, $02,
        $03, $03, $03, $03, $03, $03, $03, $03,
        $03, $03, $03, $03, $03, $03, $03, $03,
        $04, $04, $04, $04, $04, $04, $04, $04,
        $05, $05, $05, $05, $05, $05, $05, $05,
        $06, $06, $06, $06, $06, $06, $06, $06,
        $07, $07, $07, $07, $07, $07, $07, $07,
        $08, $08, $08, $08, $08, $08, $08, $08,
        $09, $09, $09, $09, $09, $09, $09, $09,
        $0A, $0A, $0A, $0A, $0A, $0A, $0A, $0A,
        $0B, $0B, $0B, $0B, $0B, $0B, $0B, $0B,
        $0C, $0C, $0C, $0C, $0D, $0D, $0D, $0D,
        $0E, $0E, $0E, $0E, $0F, $0F, $0F, $0F,
        $10, $10, $10, $10, $11, $11, $11, $11,
        $12, $12, $12, $12, $13, $13, $13, $13,
        $14, $14, $14, $14, $15, $15, $15, $15,
        $16, $16, $16, $16, $17, $17, $17, $17,
        $18, $18, $19, $19, $1A, $1A, $1B, $1B,
        $1C, $1C, $1D, $1D, $1E, $1E, $1F, $1F,
        $20, $20, $21, $21, $22, $22, $23, $23,
        $24, $24, $25, $25, $26, $26, $27, $27,
        $28, $28, $29, $29, $2A, $2A, $2B, $2B,
        $2C, $2C, $2D, $2D, $2E, $2E, $2F, $2F,
        $30, $31, $32, $33, $34, $35, $36, $37,
        $38, $39, $3A, $3B, $3C, $3D, $3E, $3F
);

const d_len: array[0..255] of Byte = (
        $03, $03, $03, $03, $03, $03, $03, $03,
        $03, $03, $03, $03, $03, $03, $03, $03,
        $03, $03, $03, $03, $03, $03, $03, $03,
        $03, $03, $03, $03, $03, $03, $03, $03,
        $04, $04, $04, $04, $04, $04, $04, $04,
        $04, $04, $04, $04, $04, $04, $04, $04,
        $04, $04, $04, $04, $04, $04, $04, $04,
        $04, $04, $04, $04, $04, $04, $04, $04,
        $04, $04, $04, $04, $04, $04, $04, $04,
        $04, $04, $04, $04, $04, $04, $04, $04,
        $05, $05, $05, $05, $05, $05, $05, $05,
        $05, $05, $05, $05, $05, $05, $05, $05,
        $05, $05, $05, $05, $05, $05, $05, $05,
        $05, $05, $05, $05, $05, $05, $05, $05,
        $05, $05, $05, $05, $05, $05, $05, $05,
        $05, $05, $05, $05, $05, $05, $05, $05,
        $05, $05, $05, $05, $05, $05, $05, $05,
        $05, $05, $05, $05, $05, $05, $05, $05,
        $06, $06, $06, $06, $06, $06, $06, $06,
        $06, $06, $06, $06, $06, $06, $06, $06,
        $06, $06, $06, $06, $06, $06, $06, $06,
        $06, $06, $06, $06, $06, $06, $06, $06,
        $06, $06, $06, $06, $06, $06, $06, $06,
        $06, $06, $06, $06, $06, $06, $06, $06,
        $07, $07, $07, $07, $07, $07, $07, $07,
        $07, $07, $07, $07, $07, $07, $07, $07,
        $07, $07, $07, $07, $07, $07, $07, $07,
        $07, $07, $07, $07, $07, $07, $07, $07,
        $07, $07, $07, $07, $07, $07, $07, $07,
        $07, $07, $07, $07, $07, $07, $07, $07,
        $08, $08, $08, $08, $08, $08, $08, $08,
        $08, $08, $08, $08, $08, $08, $08, $08
);


function readChar: Integer;
begin
  Result := 0;
  if SrcStrm.Position < SrcStrm.Size then
    SrcStrm.Read( Result, 1 )
  else
    Result := -1;
end;

function GetBit: Integer;
var i: Integer;
begin
  while getlen <= 8 do
  begin
    i := readChar;
    if i = -1 then i := 0;
    getbuf := getbuf or (i shl (8 - getlen));
    Inc( getlen, 8 );
  end;
  i := getbuf;
  getbuf := getbuf shl 1;
  Dec( getlen );
  Result := (i shr 15) and 1;
end;

function GetByte: Integer;
var i: Integer;
begin
  while getlen <= 8 do
  begin
    i := readChar;
    if i = -1 then i := 0;
    getbuf := getbuf or ( i shl (8 - getlen) );
    Inc( getlen, 8 );
  end;
  i := getbuf;
  getbuf := getbuf shl 8;
  Dec( getlen, 8 );
  Result := (i shr 8) and $FF;
end;

procedure StartHuff;
var i, j: Integer;
begin
  getbuf := 0;
  getlen := 0;
  for i := 0 to N_CHAR-1 do
  begin
    freq[ i ] := 1;
    son[ i ] := i + T;
    prnt[ i + T ] := i;
  end;
  i := 0;
  j := N_CHAR;
  while j <= R do
  begin
    freq[ j ] := freq[ i ] + freq[ i + 1 ];
    son[ j ] := i;
    prnt[ i ] := j;
    prnt[ i + 1 ] := j;
    Inc( i, 2 );
    Inc( j );
  end;
  freq[ T ] := $FFFF;
  prnt[ RootPos ] := 0;
  for i := 0 to N - F - 1 do
    text_buf[ i ] := ' ';
  r := N - F;
end;

// reconstruction of tree
procedure reconst;
var i, j, k, f, l: Integer;
begin
  // collect leaf nodes in the first half of the table
  // nd replace the freq by (freq + 1) / 2
  j := 0;
  for i := 0 to T-1 do
  begin
    if son[ i ] >= T then
    begin
      freq[ j ] := (freq[ i ] + 1) div 2;
      son[ j ] := son[ i ];
      Inc( j );
    end;
  end;
  // begin constructing tree by connecting sons
  i := 0;
  for j := N_CHAR to T-1 do
  begin
    k := i + 1;
    f := freq[ i ] + freq[ k ];
    freq[ j ] := f;
    k := j-1;
    while f < freq[ k ] do
      Dec( k );
    Inc( k );
    l := (j - k) * Sizeof( freq[ 0 ] );
    Move( freq[ k ], freq[ k+1 ], l );
    freq[ k ] := f;
    Move( son[ k ], son[ k+1 ], l );
    son[ k ] := i;
    Inc( i, 2 );
  end;
  // connect parent
  for i := 0 to T-1 do
  begin
    k := son[ i ];
    if k >= T then
      prnt[ k ] := i
    else
    begin
      prnt[ k ] := i;
      prnt[ k+1 ] := i;
    end;
  end;

end;

// increment frequency of given code by one, and update tree
procedure update( c: Integer );
var i, j, k, l: Integer;
begin
  if freq[ RootPos ] = MAX_FREQ then
    reconst;
  c := prnt[ c + T ];
  REPEAT
    Inc( freq[ c ] );
    k := freq[ c ];
    // if the order is distributed, then exchange nodes
    l := c + 1;
    if k > freq[ l ] then
    begin
      Inc( l );
      while k > freq[ l ] do Inc( l );
      Dec( l );
      freq[ c ] := freq[ l ];
      freq[ l ] := k;

      i := son[ c ];
      prnt[ i ] := l;
      if i < T then
        prnt[ i+1 ] := l;

      j := son[ l ];
      son[ l ] := i;

      prnt[ j ] := c;
      if j < T then
        prnt[ j+1 ] := c;
      son[ c ] := j;

      c := l;
    end;
    c := prnt[ c ];
  UNTIL c = 0;
end;

function DecodeChar: Integer;
begin
  Result := son[ RootPos ];
  //travel from root to leaf, chhosing the smaller child node (son[ ]) if the
  // read bit is 0, the bigger son[ ]+1 if 1 then
  while Result < T do
    Result := son[ Result + GetBit ];
  Dec( Result, T );
  update( Result );
end;

function DecodePosition: Integer;
var i, j, c: Integer;
begin
  // recover upper 6 bits from table
  i := GetByte;
  c := d_code[ i ] shl 6;
  j := d_len[ i ];
  // read lower 6 bits verbatim
  Dec( j, 2 );
  while j > 0 do
  begin
    i := (i shl 1) + GetBit;
    Dec( j );
  end;
  Result := c or i and $3F;
end;

function unpack_lzh( Dst, Src: PStream; Size: DWORD ): DWORD;
var i, j, k, C: Integer;
begin
  Result := 0;
  SrcStrm := Src;
  StartHuff;
  while Size > 0 do
  begin
    C := DecodeChar;
    if C < 256 then
    begin
      Dst.Write( C, 1 );
      text_buf[ r ] := Char( C ); Inc( r );
      Inc( Result );
      r := r and (N - 1);
    end
      else
    begin
      i := (r - DecodePosition - 1) and (N - 1);
      j := C - 255 + THRESHOLD;
      for k := 0 to j-1 do
      begin
        C := Byte( text_buf[ (i + k) and (N - 1) ] );
        Dst.Write( C, 1 );
        text_buf[ r ] := Char( C ); Inc( r );
        r := r and (N - 1);
        Inc( Result );
      end;
    end;
  end;
end;
//------------------------------------------------------------------------------

function CheckSum( Ptr: PByte; NBytes: Integer ): DWORD;
begin
  Result := 0;
  while NBytes > 0 do
  begin
    Inc( Result, Ptr^ );
    Inc( Ptr );
    Dec( NBytes );
  end;
end;

function RLEExpand( SrcStrm: PStream; DstBuf: PByte; var DLen: Integer ): Integer;
var s2: PByte;
    d1, d2: Byte;
    len, rlen, len2: Integer;
    src_len: Integer;
    src_type: Byte;
    StartPos: DWORD;
begin
  s2 := DstBuf;
  src_len := 0;
  SrcStrm.Read( src_len, 2 );
  StartPos := SrcStrm.Position;
  SrcStrm.Read( src_type, 1 );
  CASE src_type OF
  0: begin
       {$IFDEF FIXRLE0}
       rlen := src_len - 1;
       {$ELSE}
       rlen := src_len;
       {$ENDIF}
       len := rlen;
       while len > 0 do
       begin
         SrcStrm.Read( d1, 1 );
         s2^ := d1; Inc( s2 );
         Dec( len );
       end;
     end;
  1: begin
       len := 0;
       SrcStrm.Read( len, 2 );
       rlen := len shl 1;
       SrcStrm.Read( d1, 1 );
       SrcStrm.Read( d2, 1 );
       while len > 0 do
       begin
         s2^ := d1; Inc( s2 );
         s2^ := d2; Inc( s2 );
         Dec( len );
       end;
     end;
  2: begin
       len2 := src_len-1;
       REPEAT
         SrcStrm.Read( d1, 1 );
         Dec( len2 );
         CASE d1 OF
         0: begin
              len := 0;
              SrcStrm.Read( len, 1 );
              Dec( len2 );
              while len > 0 do
              begin
                SrcStrm.Read( s2^, 1 ); Inc( s2 ); Dec( len2 );
                Dec( len );
              end;
            end;
         1: begin
              len := 0;
              SrcStrm.Read( len, 1 ); Dec( len2 );
              SrcStrm.Read( d1, 1 );  Dec( len2 );
              SrcStrm.Read( d2, 1 );  Dec( len2 );
              while len > 0 do
              begin
                s2^ := d1; Inc( s2 );
                s2^ := d2; Inc( s2 );
                Dec( len );
              end;
            end;
         END;
       UNTIL len2 <= 0;
       rlen := DWORD( s2 ) - DWORD( DstBuf );
     end;
  else
    rlen := -1;
  END;
  if rlen < 0 then
    SrcStrm.Position := StartPos;
  DLen := DLen - Integer( SrcStrm.Position - StartPos );
  Result := rlen;
end;

//------------------------------------------------------------------------------

procedure RegisterLoadSpectrum( LoadFileTypes, SaveFileTypes: PChar;
          Descriptions: PChar; CanSaveS128: PByte ); stdcall;
begin
  StrCopy( LoadFileTypes, '*.TD0' );
  StrCopy( SaveFileTypes, '*.TD0' );
  StrCopy( Descriptions, 'Teledisk image;' +
                         'Teledisk image;Teledisk image' );
  PChar( CanSaveS128 )[ 0 ] := #2;
end;

{$R DISKETTE.RES}

function LoadSpectrum( FileData: Pointer; FileSize: Integer; FileExt: PChar;
         Data: PSpecData; ScreenOnly: Boolean ): Boolean; stdcall;
var H: THdr;
    Comment: TComment;
    T: TTrackRec;
    S: TSectorRec;
    FS, MS: PStream;
    Mem: Pointer;
    I, L, N, DLen, NewL: Integer;
    Chunk: array[ 0..3 ] of Char;
    Buf: array[ 0..65535 ] of Byte;
    Bmp, Bmp1: PBitmap;
    SecCRC: Byte;
begin
  Result := FALSE;
  if ScreenOnly then
  begin
    Chunk := 'PRVW';
    MS := NewMemoryStream;
    MS.Write( Chunk, 4 );
    L := 0;
    MS.Write( L, 4 );
    Bmp := NewBitmap( 0,0 );
    Bmp1 := NewBitmap( 256, 192 );
    Bmp1.Canvas.Brush.Color := clWhite;
    Bmp1.Canvas.FillRect( Bmp1.BoundsRect );
    Bmp.LoadFromResourceName( hInstance, 'DISK' );
    Bmp.Draw( Bmp1.Canvas.Handle, (Bmp1.Width - Bmp.Width) div 2,
      (Bmp1.Height - Bmp.Height) div 2 );
    Bmp.Free;
    Bmp1.SaveToStream( MS );
    Bmp1.Free;
    Bmp.Free;
    L := MS.Size;
    GetMem( Mem, L );
    Move( MS.Memory^, Mem^, L );
    Dec( L, 8 );
    Move( L, Pointer( DWORD( Mem ) + 4 )^, 4 );
    Data.Tape.TapeImgData := Mem;
    Data.Tape.TapeImgLen := L + 8;
    Result := TRUE;
    Exit;
  end;
  TDError := nil;
  FS := NewExMemoryStream( FileData, FileSize );
  TRY
    FS.Read( H, Sizeof( H ) );
    TDError := 'Teledisk signature not found.';
    if (H.sig <> 'TD') and (H.sig <> 'td') then Exit;
    TDError := 'Volume sequence in TD0-file is not 0.';
    if H.volseq <> 0 then Exit;
    TDError := 'Unsupported Teledisk version.';
    if (H.TDVer < 10) or (H.TDver > 21) then Exit;
    TDError := nil;
    if H.sig = 'td' then // compressed disk
    begin
      MS := NewMemoryStream;
      TRY
        unpack_lzh( MS, FS, FS.Size - FS.Position );
        FS.Free;
        FS := MS;
        FS.Position := 0;
        MS := nil;
      FINALLY
        MS.Free;
      END;
    end;
    TDError := 'Suddenly end of input data.';
    MS := NewMemoryStream;
    TRY
      //------------------------------------------------------------------------
      if H.TrkDensity and $80 <> 0 then
      begin // comment
        if FS.Read( Comment, Sizeof( Comment ) ) < Sizeof( Comment ) then Exit;
        FS.Position := FS.Position + Comment.len;
      end;
      while FS.Position < FS.Size do
      begin
        I := FS.Read( T, Sizeof( T ) );
        TDError := nil;
        if T.trk = 255 then break;
        TDError := 'Suddenly end of input data.';
        if I < Sizeof( T ) then break;
        TDError := 'Checksum mismatch in track header.';
        //if Byte( CheckSum( @ T.nsec, 3 ) ) <> T.crc then break;
        for N := 1 to T.nsec do
        begin
          TDError := 'Suddenly end of input data.';
          if FS.Read( S, Sizeof( S ) ) < Sizeof( S ) then break;
          MS.Write( T.trk, 1 );
          MS.Write( T.head, 1 );
          MS.Write( S.trk, 1 );
          MS.Write( S.head, 1 );
          MS.Write( S.sec, 1 );
          case S.secsz of
          0: L := 0;
          1: L := 1;
          2: L := 2;
          3: L := 3;
          else L := 4;
          end;
          MS.Write( L, 1 );
          I := 0;
          MS.Write( I, 2 );
          if (S.Syndroms and $70 = 0) and (S.secsz and $F8 = 0) and
             ((128 shl S.secsz) <= 65536) then
          begin
            FillChar( Buf, Sizeof( Buf ), 0 );
            L := 128 shl S.secsz;
            DLen := 0;
            FS.Read( SecCRC, 1 );
            FS.Read( DLen, 2 );
            FS.Position := FS.Position - 2;
            NewL := RLEExpand( FS, @ Buf[ 0 ], DLen );
            if NewL <> L then
            begin
              Exit;
              if (NewL = -1) and (DLen = 0) then
                FS.Position := FS.Position - 1;
            end;
            MS.Write( L, 2 );
            MS.Write( Buf, L );
          end
            else
          begin // no actual data
            I := 0;
            MS.Write( I, 2 );
          end;
        end;
      end;

      //------------------------------------------------------------------------
      if MS.Size > 0 then
      begin
        L := 255;
        MS.Write( L, 1 );
        L := MS.Size;
        GetMem( Mem, L + 12 );
        Move( MS.Memory^, Pointer( DWORD( Mem ) + 12 )^, L );
        MS.Size := 0;
        Chunk := 'DISK';
        MS.Write( Chunk, 4 );
        MS.Write( L, 4 );
        I := Byte( 'A' );
        MS.Write( I, 1 );
        I := 0;
        MS.Write( I, 3 );
        Move( MS.Memory^, Mem^, 12 );
        Data.Tape.TapeImgData := Mem;
        Data.Tape.TapeImgLen := L + 12;
        TDError := nil;
        Result := TRUE;
      end;
    FINALLY
      MS.Free;
    END;
  FINALLY
    FS.Free;
  END;
end;

//------------------------------------------------------------------------------
const crcTab: array[ 0..255 ] of Word = (
     $0000, $97A0, $B9E1, $2E41, $E563, $72C3, $5C82, $CB22,
     $CAC7, $5D67, $7326, $E486, $2FA4, $B804, $9645, $01E5,
     $032F, $948F, $BACE, $2D6E, $E64C, $71EC, $5FAD, $C80D,
     $C9E8, $5E48, $7009, $E7A9, $2C8B, $BB2B, $956A, $02CA,
     $065E, $91FE, $BFBF, $281F, $E33D, $749D, $5ADC, $CD7C,
     $CC99, $5B39, $7578, $E2D8, $29FA, $BE5A, $901B, $07BB,
     $0571, $92D1, $BC90, $2B30, $E012, $77B2, $59F3, $CE53,
     $CFB6, $5816, $7657, $E1F7, $2AD5, $BD75, $9334, $0494,
     $0CBC, $9B1C, $B55D, $22FD, $E9DF, $7E7F, $503E, $C79E,
     $C67B, $51DB, $7F9A, $E83A, $2318, $B4B8, $9AF9, $0D59,
     $0F93, $9833, $B672, $21D2, $EAF0, $7D50, $5311, $C4B1,
     $C554, $52F4, $7CB5, $EB15, $2037, $B797, $99D6, $0E76,
     $0AE2, $9D42, $B303, $24A3, $EF81, $7821, $5660, $C1C0,
     $C025, $5785, $79C4, $EE64, $2546, $B2E6, $9CA7, $0B07,
     $09CD, $9E6D, $B02C, $278C, $ECAE, $7B0E, $554F, $C2EF,
     $C30A, $54AA, $7AEB, $ED4B, $2669, $B1C9, $9F88, $0828,
     $8FD8, $1878, $3639, $A199, $6ABB, $FD1B, $D35A, $44FA,
     $451F, $D2BF, $FCFE, $6B5E, $A07C, $37DC, $199D, $8E3D,
     $8CF7, $1B57, $3516, $A2B6, $6994, $FE34, $D075, $47D5,
     $4630, $D190, $FFD1, $6871, $A353, $34F3, $1AB2, $8D12,
     $8986, $1E26, $3067, $A7C7, $6CE5, $FB45, $D504, $42A4,
     $4341, $D4E1, $FAA0, $6D00, $A622, $3182, $1FC3, $8863,
     $8AA9, $1D09, $3348, $A4E8, $6FCA, $F86A, $D62B, $418B,
     $406E, $D7CE, $F98F, $6E2F, $A50D, $32AD, $1CEC, $8B4C,
     $8364, $14C4, $3A85, $AD25, $6607, $F1A7, $DFE6, $4846,
     $49A3, $DE03, $F042, $67E2, $ACC0, $3B60, $1521, $8281,
     $804B, $17EB, $39AA, $AE0A, $6528, $F288, $DCC9, $4B69,
     $4A8C, $DD2C, $F36D, $64CD, $AFEF, $384F, $160E, $81AE,
     $853A, $129A, $3CDB, $AB7B, $6059, $F7F9, $D9B8, $4E18,
     $4FFD, $D85D, $F61C, $61BC, $AA9E, $3D3E, $137F, $84DF,
     $8615, $11B5, $3FF4, $A854, $6376, $F4D6, $DA97, $4D37,
     $4CD2, $DB72, $F533, $6293, $A9B1, $3E11, $1050, $87F0
     );

function crc16( P: PByte; L: Integer ): Word;
begin
  Result := 0;
  while L > 0 do
  begin
    Result := (Result shr 8) xor crcTab[ (Result and $FF) xor P^ ];
    Inc( P ); Dec( L );
  end;
end;

procedure TRDOS2TD0( DS, FS: PStream; L: Integer );
var TRDSectors: array[ 0..254, 0..1, 0..255 ] of DWORD;
    P: DWORD;
    Tr, Hd, Sc, Sides: Byte;
    Len, wlen: Word;
    buf: array[ 0..15 ] of Byte;
    dbuf: array[ 0..65535 ] of Byte;
    TrkHdrDone: Boolean;
    sz: Integer;
begin
  Sides := 1;
  FS.Position := FS.Position + 4;
  FillChar( TRDSectors, Sizeof( TRDSectors ), 0 );
  while FS.Position < FS.Size do
  begin
    P := FS.Position;
    FS.Read( Tr, 1 );
    if Tr = 255 then break;
    FS.Read( Hd, 1 );
    if Hd+1 > Sides then Sides := Hd+1;
    FS.Position := FS.Position + 2;
    FS.Read( Sc, 1 );
    FS.Position := FS.Position + 3;
    FS.Read( Len, 2 );
    FS.Position := FS.Position + Len;
    if Len > 0 then
      TRDSectors[ Tr, Hd, Sc ] := P;
  end;
  FillChar( buf, Sizeof( buf ), 0 );
  buf[ 0 ] := Byte( 'T' );
  buf[ 1 ] := Byte( 'D' );
  buf[ 4 ] := 21;
  buf[ 6 ] := 2;
  buf[ 9 ] := Sides;
  PWord( @ buf[ 10 ] )^ := crc16( @ buf[ 0 ], 10 );
  DS.Write( buf, 12 );
  for Tr := 0 to 254 do
    for Hd := 0 to Sides-1 do
    begin
      TrkHdrDone := FALSE;
      for Sc := 0 to 255 do
      begin
        P := TRDSectors[ Tr, Hd, Sc ];
        if P <> 0 then
        begin
          if not TrkHdrDone then
          begin
            TrkHdrDone := TRUE;
            buf[ 0 ] := 0;
            for sz := 0 to 255 do
              if TRDSectors[ Tr, Hd, sz ] <> 0 then
                Inc( buf[ 0 ] );
            buf[ 1 ] := Tr;
            buf[ 2 ] := Hd;
            buf[ 3 ] := crc16( @ buf[ 0 ], 3 );
            DS.Write( buf, 4 );
          end;
          FS.Position := P + 2;
          FS.Read( buf, 3 );
          FS.Position := FS.Position + 3;
          FS.Read( Len, 2 );
          sz := (Len + 127) and not 127;
          sz := sz shr 7;
          buf[ 3 ] := 0;
          while (sz <> 1) and (sz <> 0) do
          begin
            Inc( buf[ 3 ] );
            sz := sz shr 1;
          end;
          wlen := 128 shl (buf[ 3 ]);
          FS.Read( dbuf, Len );

          buf[ 4 ] := 0;
          buf[ 5 ] := crc16( @ dbuf[ 0 ], wlen );
          {$IFDEF FIXRLE0}
          PWord( @ buf[ 6 ] )^ := wlen+1;
          {$ELSE}
          PWord( @ buf[ 6 ] )^ := wlen;
          {$ENDIF}
          buf[ 8 ] := 0;
          DS.Write( buf, 9 );
          DS.Write( dbuf, wlen );
        end;
      end;
    end;
    sz := 255;
    DS.Write( sz, 4 );
end;

function SaveSpectrum( FilePath: PChar; Data: PSpecData ): Boolean; stdcall;
var FS, DS: PStream;
    Chunk: array[ 0..3 ] of Char;
    L: DWORD;
begin
  Result := FALSE;
  if Data.Tape.TapeImgData = nil then Exit;
  DS := NewExMemoryStream( Data.Tape.TapeImgData, Data.Tape.TapeImgLen );
  TRY
    while DS.Position < DS.Size do
    begin
      Chunk := '   ';
      DS.Read( Chunk, 4 );
      DS.Read( L, 4 );
      if Chunk = 'DISK' then break;
      DS.Position := DS.Position + L;
    end;
    if DS.Position >= DS.Size then Exit;
    FS := NewReadWriteFileStream( FilePath );
    TRY
      if FS.Handle = INVALID_HANDLE_VALUE then Exit;
      FS.Size := 0;
      Result := TRUE;
      TRDOS2TD0( FS, DS, L );
    FINALLY
      FS.Free;
    END;
  FINALLY
    DS.Free;
  END;
end;

procedure ReleaseData( MemAddr: Pointer ); stdcall;
begin
  if MemAddr <> nil then
    FreeMem( MemAddr );
end;

procedure GetErrorText( Buf: PChar ); stdcall;
begin
  Buf^ := #0;
  if TDError <> nil then
    StrCopy( Buf, TDError );
end;

exports RegisterLoadSpectrum, LoadSpectrum, SaveSpectrum, ReleaseData,
  GetErrorText;

begin
  //UseDelphiMemoryManager;
end.
