library LoadTRDos;

uses
  Windows, KOL, PluginUnit;

type
  TByteArray = array[0..1000000] of Byte;
  PByteArray = ^TByteArray;

procedure RegisterLoadSpectrum( LoadFileTypes, SaveFileTypes: PChar;
          Descriptions: PChar; CanSaveS128: PByte ); stdcall;
begin
  StrCopy( LoadFileTypes, '*.TRD;*.SCL' );
  StrCopy( SaveFileTypes, '*.TRD;*.SCL' );
  StrCopy( Descriptions, 'TRDOS disk image;TRDOS disk image;' +
                         'TRDOS disk image;TRDOS disk image;TRDOS disk image' );
  PChar( CanSaveS128 )[ 0 ] := #2; // TRD
  PChar( CanSaveS128 )[ 1 ] := #2; // SCL
end;

{$R DISKETTE.RES}

type
  TSCLHeader = packed record
    FileName: array[ 0..7 ] of Char;
    FileType: Char;
    StartAddr: Word;
    FileLen: Word;
    FileSizeSec: Byte;
  end;

  PCatalogEntry = ^TCatalogEntry;
  TCatalogEntry = packed record
    FileName: array[ 0..7 ] of Char;
    FileExt: Char;
    FileStart: Word;
    FileLength: Word;
    FileLenSec: Byte;
    StartSec: Byte;
    StartTrk: Byte;
  end;

procedure SCL2TRDOS( TS, SS: PStream );
var Sector, Sector8: PByteArray;
    FreeSectors: Word;
    I, N: Integer;
    PosH, PosD: DWORD;
    H: TSCLHeader;
    E: PCatalogEntry;
    DestOffset, Free1st: DWORD;
begin
  FreeSectors := 159 * 16;
  if TS.Size < 256 * 16 then
  begin //  0- 
    TS.Size := 256 * 16;
    FillChar( TS.Memory^, TS.Size, 0 );
    Sector8 := Pointer( DWORD( TS.Memory ) + 256 * 8 );
    Sector8[ 225 ] := 0;   // 1st free sector
    Sector8[ 226 ] := 1;   // 1st free track
    Sector8[ 227 ] := $16; // disk type: 80 trks, 2 sides
    Sector8[ 229 ] := FreeSectors and $FF;
    Sector8[ 230 ] := FreeSectors shr 8;
    Sector8[ 231 ] := $10;
    for I := 233 to 242 do Sector8[ I ] := $20;
    for I := 245 to 252 do Sector8[ I ] := $20;
  end;
  N := 0;
  SS.Read( N, 1 );
  Sector8 := Pointer( DWORD( TS.Memory ) + 256 * 8 );
  Sector8[ 228 ] := N; // num files
  PosH := SS.Position;
  PosD := PosH + DWORD( N * Sizeof( TSCLHeader ) );
  for I := 0 to N-1 do
  begin
    SS.Position := PosH;
    if SS.Read( H, Sizeof( H ) ) <> Sizeof( H ) then
      break;
    PosH := SS.Position;
    SS.Position := PosD;
    E := Pointer( Integer( TS.Memory ) + 16 * I );
    Sector := Pointer( DWORD( TS.Memory ) + 256 * 8 );
    Move( H.FileName[ 0 ], E.FileName[ 0 ], 13 );
    if E.FileName[ 0 ] = #1 then
      Inc( Sector8[ 244 ] ); // num deleted files ++
    E.FileLenSec := H.FileSizeSec;
    E.StartSec := Sector[ 225 ];
    E.StartTrk := Sector[ 226 ];
    DestOffset := (Sector[ 225 ] + Sector[ 226 ] shl 4) * 256;
    Free1st := (Sector[ 225 ] + Sector[ 226 ] shl 4) + H.FileSizeSec;
    Sector[ 225 ] := Free1st and $F;
    Sector[ 226 ] := Free1st shr 4;
    Dec( FreeSectors, H.FileSizeSec );
    if Integer( FreeSectors ) < 0 then FreeSectors := 0;
    Sector[ 229 ] := FreeSectors and $FF;
    Sector[ 230 ] := FreeSectors shr 8;
    if TS.Size < DestOffset + H.FileSizeSec * 256 then
      TS.Size := DestOffset + H.FileSizeSec * 256;
    TS.Position := DestOffset;
    Stream2Stream( TS, SS, 256 * H.FileSizeSec );
    PosD := SS.Position;
  end;
end;

function LoadSpectrum( FileData: Pointer; FileSize: Integer; FileExt: PChar;
         Data: PSpecData; ScreenOnly: Boolean ): Boolean; stdcall;

         procedure TRDOS2Stream( Dst, Src: PStream );
         var I, Trk, Sid, Sec: Integer;
             SecBuf: array[ 0..255 ] of Byte;
             CC: Word;
             TwoSides: Boolean;
         begin
           Trk := 0;
           Sid := 0;
           Sec := 0;
           TwoSides := FALSE;
           while Src.Position < Src.Size do
           begin
             Src.Read( SecBuf[ 0 ], 256 );
             CC := 0;
             for I := 0 to 255 do
               CC := CC + SecBuf[ I ];
             Dst.Write( Trk, 1 );
             Dst.Write( Sid, 1 );
             Dst.Write( Trk, 1 );
             Dst.Write( Sid, 1 );
             I := Sec + 1;
             Dst.Write( I, 1 );
             I := 1; // size code (1=256 bytes)
             Dst.Write( I, 1 );
             Dst.Write( CC, 2 );
             I := 256;
             Dst.Write( I, 2 );
             Dst.Write( SecBuf[ 0 ], 256 );

             if (Sec = 8) and (Sid = 0) and (Trk = 0) then
             begin
               TwoSides := SecBuf[ 227 ] <= $17;
             end;

             Inc( Sec );
             if Sec >= 16 then
             begin
               Sec := 0;
               if TwoSides then
               begin
                 Inc( Sid );
                 if Sid >= 2 then
                 begin
                   Sid := 0;
                   Inc( Trk );
                 end;
               end
                 else
               begin
                 Inc( Trk );
               end;
             end;
             if Trk >= 255 then break;
           end;
           Trk := 255;
           Dst.Write( Trk, 1 );
         end;

var FS, TS, MS: PStream;
    DiskLetter: Char;
    Chunk: array[ 0..3 ] of Char;
    Len: DWORD;
    I: Integer;
    Bmp, Bmp1: PBitmap;
begin
  Result := FALSE;
  FS := NewMemoryStream;
  TS := NewMemoryStream;
  FS.Size := FileSize;

  TRY
    if not ScreenOnly then
    begin
      Move( FileData^, FS.Memory^, FileSize );
      Chunk := 'DISK';
      TS.Write( Chunk, 4 );
      Len := 0;
      TS.Write( Len, 4 );
      DiskLetter := 'A';
      TS.Write( DiskLetter, 1 );
      I := 0;
      TS.Write( I, 1 ); // current track #
      TS.Write( I, 1 ); // disk states: D0 = read only, D1 = head down, D2 = FM/MFM
      TS.Write( I, 1 ); // reserved
      if StrEq( FileExt, '.trd' ) then
      begin // .TRD - file:
        TRDOS2Stream( TS, FS );
      end
      else if StrEq( FileExt, '.SCL' ) then
      begin // .SCL-file:
        if not CompareMem( FS.Memory, PChar( 'SINCLAIR' ), 8 ) then
          Exit;
        FS.Position := FS.Position + 8;
        MS := NewMemoryStream;
        TRY
          SCL2TRDOS( MS, FS );
          MS.Position := 0;
          TRDOS2Stream( TS, MS );
        FINALLY
          MS.Free;
        END;
      end;
    end
      else
    begin
      Chunk := 'PRVW';
      TS.Write( Chunk, 4 );
      Len := 0;
      TS.Write( Len, 4 );
      Bmp := NewBitmap( 0,0 );
      Bmp1 := NewBitmap( 256, 192 );
      Bmp1.Canvas.Brush.Color := clWhite;
      Bmp1.Canvas.FillRect( Bmp1.BoundsRect );
      Bmp.LoadFromResourceName( hInstance, 'DISK' );
      Bmp.Draw( Bmp1.Canvas.Handle, (Bmp1.Width - Bmp.Width) div 2,
        (Bmp1.Height - Bmp.Height) div 2 );
      Bmp.Free;
      Bmp1.SaveToStream( TS );
      Bmp1.Free;
      Bmp.Free;
    end;

    I := TS.Size - 8;
    TS.Position := 4;
    TS.Write( I, 4 );
    GetMem( Data.Tape.TapeImgData, TS.Size );
    Move( TS.Memory^, Data.Tape.TapeImgData^, TS.Size );
    Data.Tape.TapeImgLen := TS.Size;
    Result := TRUE;
  FINALLY
    FS.Free;
    TS.Free;
  END;
end;

procedure DiskImage2TRDOS( FS, DS: PStream; L: DWORD );
var I: Integer;
    SecList: array[ 0..254, 0..1, 0..15 ] of DWORD;
    TwoSided: Byte;
    StartPos, SectorPos: DWORD;
    MaxTrk: Byte;
    Trk, Sid, Sec, Typ: Byte;
    SecBuf: array[ 0..255 ] of Byte;
    P: DWORD;
begin
  FillChar( SecList[ 0 ], Sizeof( SecList ), 0 );
  StartPos := DS.Position;
  DS.Read( I, 4 );
  TwoSided := 0;
  MaxTrk := 39;
  while DS.Position < StartPos + L do
  begin
    DS.Read( Trk, 1 );
    if Trk = 255 then break;
    DS.Read( Sid, 1 );
    DS.Read( I, 1 ); // track
    DS.Read( I, 1 ); // side
    DS.Read( Sec, 1 ); // sector ID
    Dec( Sec );
    DS.Read( I, 1 ); // size code - not used
    DS.Read( I, 2 ); // CC - not used
    SectorPos := DS.Position;
    I := 0;
    DS.Read( I, 2 ); // Sector data length
    DS.Position := DS.Position + DWORD( I );
    if (Trk <= 254) and (Sid <= 1) and (Sec <= 15) then
      SecList[ Trk, Sid, Sec ] := SectorPos;
    if (Sid > 0) then TwoSided := 1
    else
    if (Trk = 0) and (Sid = 0) and (Sec = 8) then
    begin
      I := DS.Position;
      DS.Position := SectorPos + 2 + 227;
      DS.Read( Typ, 1 );
      if Typ <= $17 then TwoSided := 1;
      DS.Position := I;
    end;
    if Trk > 39 then
      MaxTrk := Max( Trk, 79 );
  end;

  for Trk := 0 to MaxTrk do
    for Sid := 0 to TwoSided do
      for Sec := 0 to 15 do
      begin
        //FillChar( SecBuf[ 0 ], Sizeof( SecBuf ), 0 );
        P := SecList[ Trk, Sid, Sec ];
        if P <> 0 then
        begin
          DS.Position := P;
          I := 0;
          DS.Read( I, 2 );
          DS.Read( SecBuf[ 0 ], Min( I, 256 ) );
          if I < 256 then
            FillChar( SecBuf[ I ], 256 - I, 0 );
        end
          else
          FillChar( SecBuf[ 0 ], 256, 0 );
        FS.Write( SecBuf[ 0 ], 256 );
      end;
end;

procedure TRDOS2SCL( SS, TS: PStream );
var I, N: Integer;
    E: PCatalogEntry;
    H: TSCLHeader;
begin
  SS.WriteStr( 'SINCLAIR' );
  N := 0;
  E := Pointer( TS.Memory );
  for I := 0 to 8 * 16 - 1 do
  begin
    if E.FileName[ 0 ] <> #1 then
    begin
      if E.FileName[ 0 ] = #0 then break;
      Inc( N );
    end;
    Inc( E );
  end;
  SS.Write( N, 1 );
  E := Pointer( TS.Memory );
  for I := 0 to 8 * 16 - 1 do
  begin
    if E.FileName[ 0 ] <> #1 then
    begin
      if E.FileName[ 0 ] = #0 then break;
      Move( E.FileName[ 0 ], H.FileName[ 0 ], 13 );
      H.FileSizeSec := E.FileLenSec;
      SS.Write( H, Sizeof( H ) );
    end;
    Inc( E );
  end;
  E := Pointer( TS.Memory );
  for I := 0 to 8 * 16 - 1 do
  begin
    if E.FileName[ 0 ] = #1 then continue;
    if E.FileName[ 0 ] = #0 then break;
    TS.Position := (E.StartSec + E.StartTrk shl 4) * 256;
    Stream2Stream( SS, TS, E.FileLenSec * 256 );
    Inc( E );
  end;
  SS.Position := 0;
  N := 0;
  while SS.Position < SS.Size do
  begin
    I := 0;
    SS.Read( I, 1 );
    N := N + I;
  end;
  SS.Write( N, 4 );
end;

function SaveSpectrum( FilePath: PChar; Data: PSpecData ): Boolean; stdcall;
var FS, DS, MS: PStream;
    Chunk: array[ 0..3 ] of Char;
    L: DWORD;
begin
  Result := FALSE;
  if Data.Tape.TapeImgData = nil then Exit;
  DS := NewExMemoryStream( Data.Tape.TapeImgData, Data.Tape.TapeImgLen );
  TRY
    while DS.Position < DS.Size do
    begin
      Chunk := '   ';
      DS.Read( Chunk, 4 );
      DS.Read( L, 4 );
      if Chunk = 'DISK' then break;
      DS.Position := DS.Position + L;
    end;
    if DS.Position >= DS.Size then Exit;
    FS := NewReadWriteFileStream( FilePath );
    TRY
      if FS.Handle = INVALID_HANDLE_VALUE then Exit;
      FS.Size := 0;
      Result := TRUE;
      if StrEq( ExtractFileExt( FilePath ), '.trd' ) then
        DiskImage2TRDOS( FS, DS, L )
      else
      if StrEq( ExtractFileExt( FilePath ), '.scl' ) then
      begin
        MS := NewMemoryStream;
        TRY
          DiskImage2TRDOS( MS, DS, L );
          TRDOS2SCL( FS, MS );
        FINALLY
          MS.Free;
        END;
      end;
    FINALLY
      FS.Free;
    END;
  FINALLY
    DS.Free;
  END;
end;

procedure ReleaseData( MemAddr: Pointer ); stdcall;
begin
  FreeMem( MemAddr );
end;

exports RegisterLoadSpectrum, LoadSpectrum, SaveSpectrum, ReleaseData;

begin
  UseDelphiMemoryManager;
end.
