library LoadTZX;

uses
  Windows, KOL, PluginUnit;

{$I KOLDEF.INC}  

const
  TZXSignature: String = 'ZXTape!';

type
  TTZXHeader = packed record
    MajorVersion: Byte;
    MinorVersion: Byte;
  end;

  THdrStandardSpeedBlock = packed record
    PauseAfter_ms: Word;
    DataLength: Word;
  end;

  THdrTurboLoadingDataBlock = packed record
    PilotPulseLength: Word;
    SyncFirstLength: Word;
    SyncSecondLength: Word;
    ZeroPulseLength: Word;
    OnePulseLength: Word;
    PilotPulseCount: Word;
    UsedBitsInLastByte: Byte;
    PauseAfter_ms: Word;
    DataLength: array[0..2] of Byte;
  end;

  THdrPureTone = packed record
    PulseLength: Word;
    PulseCount: Word;
  end;

  THdrPulsesDifferentLength = packed record
    PulseCount: Byte;
  end;

  THdrPureDataBlock = packed record
    ZeroPulseLength: Word;
    OnePulseLength: Word;
    UsedBitsInLastByte: Byte;
    PauseAfter_ms: Word;
    DataLength: array[0..2] of Byte;
  end;

  THdrDirectRecording = packed record
    SampleLength: Word;
    PauseAfter_ms: Word;
    UsedBitsInLastByte: Byte;
    DataLength: array[0..2] of Byte;
  end;

  TOutToneHdr = packed record
    Flag: Byte;
    ToneLength: Word;
    ToneCount: DWORD;
  end;

var
  Callback: TCallback;

procedure RegisterLoadSpectrum( LoadFileTypes, SaveFileTypes: PChar;
          Descriptions: PChar; CanSaveS128: PByte ); stdcall;
begin
  StrCopy( LoadFileTypes, '*.TZX' );
  StrCopy( Descriptions, 'TZX 1.13 tape image' );
end;

type
  PFakeStream = ^TFakeStream;
  TFakeStream = object( TStream )
  end;

function SkipWrite( Strm: PStream; var Buffer; Count: DWORD ): DWORD;
begin
  PFakeStream(Strm).fData.fPosition := Strm.Data.fPosition + Count;
  Result := Count;
end;

function SearchPlugin( const Ext: String ): PPlugin;
var DL: PDirList;
    I: Integer;
    RegProc: TRegProc;
    LoadTypesBuf, SaveTypesBuf, Descriptions, CanSave128Buf: array[ 0..1023 ] of Char;
begin
  Result := nil;
  DL := NewDirListEx( GetStartDir, '*.dll', FILE_ATTRIBUTE_NORMAL );
  TRY
    DL.Sort( [ ] );
    for I := 0 to DL.Count-1 do
    begin
      new( Result, Create );
      Result.Module := LoadLibrary( PChar( DL.Path + DL.Names[ I ] ) );
      if Result.Module <> 0 then
      begin
        RegProc := GetProcAddress( Result.Module, 'RegisterLoadSpectrum' );
        if Assigned( RegProc ) then
        begin
          RegProc( @ LoadTypesBuf[ 0 ], @ SaveTypesBuf[ 0 ], @ Descriptions[ 0 ],
                   @ CanSave128Buf[ 0 ] );
          if pos( Ext, UpperCase( '' + LoadTypesBuf + ';' ) ) > 0 then
          begin
            Result.LoadProc := GetProcAddress( Result.Module, 'LoadSpectrum' );
            Result.ReleaseProc := GetProcAddress( Result.Module, 'ReleaseData' );
            if Assigned( Result.LoadProc ) then Exit;
          end;
        end;
      end;
      Free_And_Nil( Result );
    end;
  FINALLY
    DL.Free;
  END;
end;

function ConvertTZX( RS, MS: PStream; LS: PList; ListBlocks: Boolean;
         Data: PSpecData ): Boolean;
var
  DoublePilot: Boolean;
  DoubleTone: Integer;
var I, J, L: Integer;
    HdrTZX: TTZXHeader;
    Signature: array[ 0..7 ] of Char;
    ID {$IFNDEF PASS_STDBLK_ASIS}, B{$ENDIF}: Byte;
    HdrStdSpeedBlk: THdrStandardSpeedBlock;
    HdrTurboBlk: THdrTurboLoadingDataBlock;
    HdrPureTone: THdrPureTone;
    HdrDiffLen: THdrPulsesDifferentLength;
    HdrPureData: THdrPureDataBlock;
    HdrDirectRec: THdrDirectRecording;
    OutToneHdr: TOutToneHdr;
    DataLength: DWORD;
    D, P: DWORD;
    BlkIdx: Integer;
    S: String;
    Off: ShortInt;
    CIbuf: array[ 0..$10 ] of Char;
    Plugin: PPlugin;
    Ext: String;
    LastLevel: Byte;

    procedure AddText( const S: String );
    var B: Byte;
        D: DWORD;
    begin
       B := 8; //  ""
       RS.Write( B, 1 );
       //Pos := RS.Position;
       B := 1; // 1  (  )
       RS.Write( B, 1 );
       D := 4 + length( S ) + 1;
       RS.Write( D, 4 );
       RS.WriteStrZ( S );
    end;

    function ProducePause( PauseLength_ms: Word ): Boolean;
    var K: Integer;
        B: Byte;
    begin
       B := LastLevel;
       if PauseLength_ms > 0 then
       begin
         OutToneHdr.ToneLength := 3500; // 1ms = 3500 tacts of Speccy
         OutToneHdr.ToneCount := PauseLength_ms;
         RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
         {if LastLevel = 0 then B := 1
                          else B := 0;}
         B := $40;
         //B := 0;
         for K := 1 to (OutToneHdr.ToneCount+7) div 8 do
         begin
           if RS.Capacity < RS.Size + 100 then
             RS.Capacity := RS.Size + 1000;
           RS.Write( B, 1 ); // up to 8 tones "0" of length 3500 tacts each
           B := 0;
         end;
         Result := TRUE;
       end
         else
         Result := TRUE;
       LastLevel := B and 1;
    end;

    {$IFDEF PURE_1}
    function WritePureDataBlock( InvertData: Boolean ): Boolean;
    var K: Integer;
        DataLength: DWORD;
        L1, L0, P, PosEnd: DWORD;
    begin
      Result := FALSE;
       DataLength := PDWORD( @ HdrPureData.DataLength[ 0 ] )^ and $FFFFFF;
       if (DataLength <> 0) and
          ((HdrPureData.ZeroPulseLength > 0) or
           (HdrPureData.OnePulseLength > 0)) then
       begin //  
         //        :
         if (HdrPureData.ZeroPulseLength > 0) and
            (HdrPureData.OnePulseLength > 0) then
         begin
           if HdrPureData.OnePulseLength > HdrPureData.ZeroPulseLength then
             D := HdrPureData.OnePulseLength * 8 div HdrPureData.ZeroPulseLength
           else
             D := HdrPureData.ZeroPulseLength * 8 div HdrPureData.OnePulseLength;
           L0 := 1; L1 := D div 8;
           OutToneHdr.ToneLength := Min( HdrPureData.OnePulseLength,
                                         HdrPureData.ZeroPulseLength );
           if (D and 4) <> 0 then
           begin
             L0 := 2;
             L1 := L1 * 2 + 1;
             OutToneHdr.ToneLength := OutToneHdr.ToneLength div 2;
           end;
           if (D and 2) <> 0 then
           begin
             if (D and 4) <> 0 then
             begin
               L0 := L0 * 2;
               L1 := L1 * 2 + 1;
               OutToneHdr.ToneLength := OutToneHdr.ToneLength div 2;
             end
               else
             begin
               L0 := L0 * 4;
               L1 := L1 * 4 + 1;
               OutToneHdr.ToneLength := OutToneHdr.ToneLength div 4;
             end;
           end;
           if (D and 1) <> 0 then
           begin
             if (D and 6) <> 0 then
             begin
               L0 := L0 * 2;
               L1 := L1 * 2 + 1;
               OutToneHdr.ToneLength := OutToneHdr.ToneLength div 2;
             end
               else
             begin
               L0 := L0 * 8;
               L1 := L1 * 8 + 1;
               OutToneHdr.ToneLength := OutToneHdr.ToneLength div 8;
             end;
           end;
           if HdrPureData.OnePulseLength < HdrPureData.ZeroPulseLength then
             Swap( Integer( L0 ), Integer( L1 ) );
         end
           else
         begin
           OutToneHdr.ToneLength := HdrPureData.ZeroPulseLength or
                                    HdrPureData.OnePulseLength;
           L1 := 1; L0 := 1; // ,     0   1
         end;
         OutToneHdr.ToneCount := 0;
         P := RS.Position;
         RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
         //    :
         D := 1;
         while DataLength > 0 do
         begin
           Dec( DataLength );
           if MS.Read( Src, 1 ) <> 1 then Exit;
           I := 8;
           if DataLength = 0 then I := HdrPureData.UsedBitsInLastByte;
           while I > 0 do
           begin
             if (Src and $80) <> 0 then
             begin //  1
               J := L1;
             end
               else
             begin //  0
               J := L0;
             end;
             //  
             for K := J-1 downto 0 do
             begin
               D := (D shl 1);
               if InvertData then D := D or 1;
               if (D and $100) <> 0 then
               begin //   
                 Inc( OutToneHdr.ToneCount, 8 );
                 RS.Write( D, 1 );
                 LastLevel := D and 1;
                 D := 1;
               end;
             end;
             //  
             for K := J-1 downto 0 do
             begin
               D := (D shl 1);
               if not InvertData then D := D or 1;
               if (D and $100) <> 0 then
               begin //   
                 Inc( OutToneHdr.ToneCount, 8 );
                 RS.Write( D, 1 );
                 LastLevel := D and 1;
                 D := 1;
               end;
             end;
             Src := Src shl 1;
             Dec( I );
           end;
         end;
         //    
         if D <> 1 then
         begin
           Inc( OutToneHdr.ToneCount, 8 );
           LastLevel := D and 1;
           while (D and $100) = 0 do
           begin
             D := D shl 1;
             Dec( OutToneHdr.ToneCount );
           end;
           RS.Write( D, 1 );
         end;
         //  :
         if not ListBlocks then
         begin
           PosEnd := RS.Position;
           RS.Position := P;
           RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
           RS.Position := PosEnd;
         end;
       end;
       Result := ProducePause( HdrPureData.PauseAfter_ms );
    end;
    {$ENDIF}

    {$IFDEF PURE_2}
    function WritePureDataBlock( InvertData: Boolean ): Boolean;
    const Precision = 16;
    var K: Integer;
        DataLength: DWORD;
        L1, L0, P, PosEnd: DWORD;
        Src: Byte;
    begin
      Result := FALSE;
       DataLength := PDWORD( @ HdrPureData.DataLength[ 0 ] )^ and $FFFFFF;
       if (DataLength <> 0) and
          ((HdrPureData.ZeroPulseLength > 0) or
           (HdrPureData.OnePulseLength > 0)) then
       begin //  
         //        :
         if (HdrPureData.ZeroPulseLength > 0) and
            (HdrPureData.OnePulseLength > 0) then
         begin
           if HdrPureData.OnePulseLength > HdrPureData.ZeroPulseLength then
             D := HdrPureData.OnePulseLength * Precision div HdrPureData.ZeroPulseLength
           else
             D := HdrPureData.ZeroPulseLength * Precision div HdrPureData.OnePulseLength;
           L0 := Precision; L1 := D;
           OutToneHdr.ToneLength := Min( HdrPureData.OnePulseLength,
                                         HdrPureData.ZeroPulseLength );
           D := Precision;
           while (L0 and 1 = 0) and (L1 and 1 = 0) do
           begin
             L0 := L0 div 2;
             L1 := L1 div 2;
             D := D div 2;
           end;
           OutToneHdr.ToneLength := OutToneHdr.ToneLength div D;
           if HdrPureData.OnePulseLength < HdrPureData.ZeroPulseLength then
             Swap( Integer( L0 ), Integer( L1 ) );
         end
           else
         begin
           OutToneHdr.ToneLength := HdrPureData.ZeroPulseLength or
                                    HdrPureData.OnePulseLength;
           L1 := 1; L0 := 1; // ,     0   1
         end;
         OutToneHdr.ToneCount := 0;
         P := RS.Position;
         RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
         //    :
         D := 1;
         while DataLength > 0 do
         begin
           Dec( DataLength );
           if MS.Read( Src, 1 ) <> 1 then Exit;
           I := 8;
           if DataLength = 0 then I := HdrPureData.UsedBitsInLastByte;
           while I > 0 do
           begin
             if (Src and $80) <> 0 then
             begin //  1
               J := L1;
             end
               else
             begin //  0
               J := L0;
             end;
             //  
             for K := 1 to J do
             begin
               D := (D shl 1);
               if InvertData then D := D or 1;
               if (D and $100) <> 0 then
               begin //   
                 Inc( OutToneHdr.ToneCount, 8 );
                 if RS.Capacity < RS.Size + 100 then
                   RS.Capacity := RS.Size + 1000;
                 RS.Write( D, 1 );
                 LastLevel := D and 1;
                 D := 1;
               end;
             end;
             //  
             for K := 1 to J do
             begin
               D := (D shl 1);
               if not InvertData then D := D or 1;
               if (D and $100) <> 0 then
               begin //   
                 Inc( OutToneHdr.ToneCount, 8 );
                 if RS.Capacity < RS.Size + 100 then
                   RS.Capacity := RS.Size + 1000;
                 RS.Write( D, 1 );
                 LastLevel := D and 1;
                 D := 1;
               end;
             end;
             Src := Src shl 1;
             Dec( I );
           end;
         end;
         //    
         if D <> 1 then
         begin
           Inc( OutToneHdr.ToneCount, 8 );
           LastLevel := D and 1;
           while (D and $100) = 0 do
           begin
             D := D shl 1;
             Dec( OutToneHdr.ToneCount );
           end;
           RS.Write( D, 1 );
         end;
         //  :
         if not ListBlocks then
         begin
           PosEnd := RS.Position;
           RS.Position := P;
           RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
           RS.Position := PosEnd;
         end;
       end;
       Result := ProducePause( HdrPureData.PauseAfter_ms );
    end;
    {$ENDIF}

    {$IFDEF PURE_3}
    function WritePureDataBlock( InvertData: Boolean ): Boolean;
    const Precision = 64;
    var K: Integer;
        DataLength: DWORD;
    begin
       DataLength := PDWORD( @ HdrPureData.DataLength[ 0 ] )^ and $FFFFFF;
       if (DataLength <> 0) and
          ((HdrPureData.ZeroPulseLength > 0) or
           (HdrPureData.OnePulseLength > 0)) then
       begin //  
         K := $0C;
         RS.Write( K, 1 );
         RS.Write( HdrPureData.ZeroPulseLength, 2 );
         RS.Write( HdrPureData.OnePulseLength, 2 );
         K := (DataLength - 1) * 8 + HdrPureData.UsedBitsInLastByte;
         RS.Write( K, 4 );
         Stream2Stream( RS, MS, DataLength );
       end;
       LastLevel := 1;
       Result := ProducePause( HdrPureData.PauseAfter_ms );
    end;
    {$ENDIF}


var
  TapeChunk: array[ 0..3 ] of Char;
  B: Byte;
begin
  Result := FALSE;
  OutToneHdr.Flag := 1;
  DoublePilot := (Data.Tape.Pilot and 1) <> 0;
  if DoublePilot then
    DoubleTone := 2
  else
    DoubleTone := 1;

  Signature[ 7 ] := #0;
  if MS.Read( Signature, 7 ) <> 7 then Exit;
  if Signature <> TZXSignature then Exit;
  if MS.Read( B, 1 ) <> 1 then Exit;
  if (B = $1A) or (B = 0) then
  begin
    if MS.Read( HdrTZX, Sizeof( HdrTZX ) ) <> Sizeof( HdrTZX ) then Exit;
    if not ((HdrTZX.MajorVersion <= 1) or
            (HdrTZX.MinorVersion = 49)) then Exit; //  
  end
    else
    MS.Position := MS.Position - 1;
  BlkIdx := -1;
  TapeChunk := 'TAPE';
  RS.Write( TapeChunk[ 0 ], 4 );
  I := 0;
  RS.Write( I, 4 ); //    
  while MS.Position < MS.Size do
  begin
    if Callback( -1 ) then
    begin
      Result := FALSE;
      Exit;
    end;
    Inc( BlkIdx );
    if ListBlocks then
      LS.Add( Pointer( RS.Position ) );
    if MS.Read( ID, 1 ) <> 1 then break; // 
    CASE ID OF
    $0..$F: ; // skip 1 byte
    $10: // Standard Speed Data Block
         begin
           if MS.Read( HdrStdSpeedBlk, Sizeof( HdrStdSpeedBlk ) ) <>
              Sizeof( HdrStdSpeedBlk ) then Exit;
           {$IFDEF PASS_STDBLK_ASIS}
           ID := 0;
           RS.Write( ID, 1 );
           RS.Write( HdrStdSpeedBlk.DataLength, 2 );
           if Stream2Stream( RS, MS, HdrStdSpeedBlk.DataLength ) <>
              HdrStdSpeedBlk.DataLength then Exit;
           LastLevel := 1;
           {$ELSE}
           //  :
           OutToneHdr.ToneLength := 2168;
           OutToneHdr.ToneCount := $C98 * 2;
           RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
           ID := $55;
           for I := 1 to OutToneHdr.ToneCount div 8 do
           begin
             if RS.Capacity < RS.Size + 100 then
               RS.Capacity := RS.Size + 1000;
             RS.Write( ID, 1 );
           end;
           //   :
           OutToneHdr.ToneLength := 667;
           OutToneHdr.ToneCount := 1;
           RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
           ID := 0;
           RS.Write( ID, 1 );
           OutToneHdr.ToneLength := 735;
           OutToneHdr.ToneCount := 1;
           RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
           ID := $80;
           RS.Write( ID, 1 );
           //  .   - 
           for I := 1 to HdrStdSpeedBlk.DataLength do
           begin
             if MS.Read( B, 1 ) <> 1 then Exit;
             for J := 0 to 7 do
             begin
               OutToneHdr.ToneLength := 855;
               OutToneHdr.ToneCount := 2;
               ID := $40;
               if (B and $80) <> 0 then
               begin
                 OutToneHdr.ToneCount := 4;
                 ID := $30;
               end;
               if RS.Capacity < RS.Size + 100 then
                 RS.Capacity := RS.Size + 1000;
               RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
               RS.Write( ID, 1 );
               B := B shl 1;
             end;
           end;
           LastLevel := 1;
           {$ENDIF}
           //if not ProducePause( 1000 ) then Exit;
           if not ProducePause( HdrStdSpeedBlk.PauseAfter_ms ) then Exit;
           {ID := $0B; // "wait"
           RS.Write( ID, 1 );}
         end;
    $11: // Turbo Loading Data Block
         begin
           if MS.Read( HdrTurboBlk, Sizeof( HdrTurboBlk ) ) <>
              Sizeof( HdrTurboBlk ) then Exit;
           AddText( 'Turbo Loading Data Block' );
           AddText( 'Pilot Pulse:' + Int2Str( HdrTurboBlk.PilotPulseLength ) +
                    ' Length: ' + Int2Str( HdrTurboBlk.PilotPulseCount ) );
           AddText( 'Sync1: ' + Int2Str( HdrTurboBlk.SyncFirstLength ) +
                    ' Sync2: ' + Int2Str( HdrTurboBlk.SyncSecondLength ) );
           AddText( 'Zero Pulse: ' + Int2Str( HdrTurboBlk.ZeroPulseLength ) +
                    ' One Pulse: ' + Int2Str( HdrTurboBlk.OnePulseLength ) );
           AddText( 'Bytes: ' + Int2Str( HdrTurboBlk.DataLength[ 0 ] +
                    (HdrTurboBlk.DataLength[ 1 ] shl 8) +
                    (HdrTurboBlk.DataLength[ 2 ] shl 16) ) +
                    ' Bits in last byte: ' + Int2Str( HdrTurboBlk.UsedBitsInLastByte ) );
           AddText( 'Pause After: ' + Int2Str( HdrTurboBlk.PauseAfter_ms ) + ' ms' );
           if HdrTurboBlk.PilotPulseCount > 0 then
           begin //  
             {$IFDEF DEBUG_1}
             if (HdrTurboBlk.PilotPulseCount and 1) <> 0 then
             asm
               int 3
             end;
             {$ENDIF}
             OutToneHdr.ToneLength := HdrTurboBlk.PilotPulseLength;

             ID := $55;
             {$IFDEF PILOT_SMART}
             OutToneHdr.ToneCount := HdrTurboBlk.PilotPulseCount;
             if OutToneHdr.ToneCount and 1 <> 0 then ID := $AA;
             {$ELSE}
             OutToneHdr.ToneCount := HdrTurboBlk.PilotPulseCount * DoubleTone;
             {$ENDIF}
             RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
             for I := 0 to OutToneHdr.ToneCount div 8 - 1 do
               RS.Write( ID, 1 );
             I := OutToneHdr.ToneCount and 7;
             CASE I OF
             0: ;
             1: ID := ID and $80;
             2: ID := ID and $C0;
             3: ID := ID and $E0;
             4: ID := ID and $F0;
             5: ID := ID and $F8;
             6: ID := ID and $FC;
             7: ID := ID and $FE;
             END;
             if I <> 0 then
               RS.Write( ID, 1 );
             LastLevel := 1;
             if not DoublePilot then
               LastLevel := (OutToneHdr.ToneCount and 1) xor 1;
           end;
           if HdrTurboBlk.SyncFirstLength > 0 then
           begin //   
             OutToneHdr.ToneLength := HdrTurboBlk.SyncFirstLength;
             OutToneHdr.ToneCount := 1;
             RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
             ID := (LastLevel xor 1) shl 7;
             RS.Write( ID, 1 );
           end;
           if HdrTurboBlk.SyncSecondLength > 0 then
           begin //   
             OutToneHdr.ToneLength := HdrTurboBlk.SyncSecondLength;
             OutToneHdr.ToneCount := 1;
             RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
             ID := ID xor $80;
             RS.Write( ID, 1 );
           end;
           HdrPureData.ZeroPulseLength := HdrTurboBlk.ZeroPulseLength;
           HdrPureData.OnePulseLength := HdrTurboBlk.OnePulseLength;
           HdrPureData.UsedBitsInLastByte := HdrTurboBlk.UsedBitsInLastByte;
           HdrPureData.PauseAfter_ms := HdrTurboBlk.PauseAfter_ms;
           Move( HdrTurboBlk.DataLength, HdrPureData.DataLength,
                 Sizeof( HdrPureData.DataLength ) );
           if not WritePureDataBlock( not DoublePilot and (LastLevel = 0) ) then Exit;
         end;
    $12: // PureTone
         begin
           if MS.Read( HdrPureTone, Sizeof( HdrPureTone ) ) <>
              Sizeof( HdrPureTone ) then Exit;
           AddText( 'Pure Tone Block' );
           AddText( 'Pulse Length: ' + Int2Str( HdrPureTone.PulseLength ) +
                    ' Pulse Count: ' + Int2Str( HdrPureTone.PulseCount ) );
           OutToneHdr.ToneLength := HdrPureTone.PulseLength;

           ID := $55;
           {$IFDEF PILOT_SMART}
           OutToneHdr.ToneCount := HdrTurboBlk.PilotPulseCount;
           if OutToneHdr.ToneCount and 1 <> 0 then ID := $AA;
           {$ELSE}
           OutToneHdr.ToneCount := HdrTurboBlk.PilotPulseCount * DoubleTone;
           {$ENDIF}

           OutToneHdr.ToneCount := HdrPureTone.PulseCount * DoubleTone;
           RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
           for I := 0 to OutToneHdr.ToneCount div 8 - 1 do
           begin
             if RS.Capacity < RS.Size + 100 then
               RS.Capacity := RS.Size + 1000;
             RS.Write( ID, 1 );
           end;
           CASE OutToneHdr.ToneCount and 7 OF
             0: ;
             1: ID := ID and $80;
             2: ID := ID and $C0;
             3: ID := ID and $E0;
             4: ID := ID and $F0;
             5: ID := ID and $F8;
             6: ID := ID and $FC;
             7: ID := ID and $FE;
           END;
           if OutToneHdr.ToneCount and 7 <> 0 then
             RS.Write( ID, 1 );
           {$IFDEF PILOT_SMART}
           LastLevel := 1;
           {$ELSE}
           LastLevel := (OutToneHdr.ToneCount and 1) xor 1;
           {$ENDIF}
         end;
    $13: // Sequence of Pulses of Different Lengths
         begin
           if MS.Read( HdrDiffLen, Sizeof( HdrDiffLen ) ) <>
              Sizeof( HdrDiffLen ) then Exit;
           AddText( 'Sequence of Pulses of Different Length' );
           AddText( 'Pulse Count: ' + Int2Str( HdrDiffLen.PulseCount ) );
           D := 0;
           ID := (LastLevel xor 1) shl 7;
           for I := 1 to HdrDiffLen.PulseCount do
           begin
             if MS.Read( D, 2 ) <> 2 then Exit;
             OutToneHdr.ToneLength := D;
             OutToneHdr.ToneCount := 1;
             RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
             RS.Write( ID, 1 );
             ID := ID xor $80;
             LastLevel := ID shr 7;
           end;
         end;
    $14: // Pure Data Block
         begin
           if MS.Read( HdrPureData, Sizeof( HdrPureData ) ) <>
              Sizeof( HdrPureData ) then Exit;
           AddText( 'Pure Data Block' );
           AddText( 'Zero Pulse: ' + Int2Str( HdrPureData.ZeroPulseLength ) +
                    ' One Pulse: ' + Int2Str( HdrPureData.OnePulseLength ) );
           AddText( 'Bytes: ' + Int2Str( HdrPureData.DataLength[ 0 ] +
                    (HdrPureData.DataLength[ 1 ] shl 8) + (HdrPureData.DataLength[ 2 ] shl 16) ) +
                    ' Bits in last byte: ' + Int2Str( HdrPureData.UsedBitsInLastByte ) );
           AddText( 'Pause After: ' + Int2Str( HdrPureData.PauseAfter_ms ) + ' ms' );
           if not WritePureDataBlock( FALSE ) then Exit;
         end;
    $15: // Direct Recording
         begin
           if MS.Read( HdrDirectRec, Sizeof( HdrDirectRec ) ) <>
              Sizeof( HdrDirectRec ) then Exit;
           AddText( 'Direct Recording' );
           AddText( 'Sample Len: ' + Int2Str( HdrDirectRec.SampleLength ) );
           AddText( 'Bytes: ' + Int2Str( HdrDirectRec.DataLength[ 0 ] +
                    (HdrDirectRec.DataLength[ 1 ] shl 8) + (HdrDirectRec.DataLength[ 2 ] shl 16) ) +
                    ' Bits in last byte: ' + Int2Str( HdrDirectRec.UsedBitsInLastByte ) );
           AddText( 'Pause After: ' + Int2Str( HdrDirectRec.PauseAfter_ms ) + ' ms' );
           OutToneHdr.ToneLength := HdrDirectRec.SampleLength;
           DataLength := PDWORD( @ HdrDirectRec.DataLength[ 0 ] )^ and $FFFFFF;
           OutToneHdr.ToneCount := (DataLength - 1) * 8 + HdrDirectRec.UsedBitsInLastByte;
           RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
           if Stream2Stream( RS, MS, DataLength ) <> DataLength then Exit;
           MS.Position := MS.Position-1;
           MS.Read( LastLevel, 1 );
           LastLevel := (LastLevel shr (8 - HdrDirectRec.UsedBitsInLastByte)) and 1;
           if not ProducePause( HdrDirectRec.PauseAfter_ms ) then Exit;
         end;
    {
    $16, // C64 ROM Type Data Block
    $17: // C64 Turbo Tape Data Block
         begin
           if MS.Read( D, 4 ) <> 4 then Exit;
           D := MS.Position + D - 4; // ?
           MS.Position := D;
           if MS.Position <> D then Exit;
         end;
    }
    $20: // Pause (Silence) or `Stop the Tape' Command
         begin
           D := 0;
           if MS.Read( D, 2 ) <> 2 then Exit;
           if D = 0 then
           begin // stop command
             OutToneHdr.ToneLength := 3500;
             OutToneHdr.ToneCount := 1;
             RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
             ID := 0;
             RS.Write( ID, 1 );
             ID := 2;
             RS.Write( ID, 1 );
           end
             else
           begin
             AddText( 'Pause: ' + Int2Str( D ) + ' ms' );
             if not ProducePause( D ) then Exit;
           end;
         end;
    $21: // Group Start
         begin
           D := 0;
           if MS.Read( D, 1 ) <> 1 then Exit;
           I := MS.Position + D;
           SetLength( S, D );
           MS.Read( S[ 1 ], D );
           AddText( 'Group: ' + S );
           if DoublePilot then
           if pos( 'speedlock', lowercase( S ) ) > 0 then
           begin
             if (pos( 'speedlock 1', lowercase( S ) ) > 0) or
                (pos( 'speedlock 2', lowercase( S ) ) > 0) then
               DoubleTone := 1
             else
               DoubleTone := 2;
           end;
           MS.Position := I;
           if MS.Position <> DWORD( I ) then Exit;
         end;
    $22: // Group End
         ;
    $23: // Jump To Block
         begin
           ID := 3;
           RS.Write( ID, 1 );
           if MS.Read( Off, 2 ) <> 2 then Exit;
           if ListBlocks then D := 0
                         else begin
                                D := DWORD( LS.Items[ BlkIdx + Off ] ) - RS.Position + 5;
                              end;
           RS.Write( D, 4 );
         end;
    $24: // Loop Start
         begin
           ID := 4;
           RS.Write( ID, 1 );
           D := 0;
           if MS.Read( D, 2 ) <> 2 then Exit;
           RS.Write( D, 4 );
         end;
    $25: // Loop End
         begin
           ID := 5;
           RS.Write( ID, 1 );
         end;
    $26: // Call Sequence
         begin
           ID := 6;
           I := 0;
           if MS.Read( I, 2 ) <> 2 then Exit;
           while I > 0 do
           begin
             if MS.Read( Off, 2 ) <> 2 then Exit;
             RS.Write( ID, 1 );
             if ListBlocks then D := 0
                           else begin
                                  D := DWORD( LS.Items[ BlkIdx + Off ] ) - RS.Position;
                                end;
             RS.Write( D, 4 );
             Dec( I );
           end;
         end;
    $27: // Return from Call
         begin
           ID := 7;
           RS.Write( ID, 1 );
         end;
    $28: // Select Block Menu
         begin
           ID := 8;
           RS.Write( ID, 1 );
           P := RS.Position;
           L := 0;
           if MS.Read( L, 2) <> 2 then Exit;
           I := 0;
           if MS.Read( I, 1 ) <> 1 then Exit;
           RS.Write( I, 1 );
           while I > 0 do
           begin
             if MS.Read( Off, 2 ) <> 2 then Exit;
             J := 0;
             if MS.Read( J, 1 ) <> 1 then Exit;
             SetLength( S, J );
             if MS.Read( S[ 1 ], J ) <> DWORD( J ) then Exit;
             if ListBlocks then D := 0
                           else begin
                                  D := DWORD( LS.Items[ BlkIdx + Off ] ) - P;
                                end;
             RS.Write( D, 4 );
             RS.WriteStrZ( PChar( S ) );
             Dec( I );
           end;
         end;
    $2A: // Stop Tape if in 48K Mode -   ",  S128",
         //        ( 1ms)   ""
         begin
           if (MS.Read( D, 4 ) <> 4) or (D <> 0) then Exit;
           ID := 9;
           RS.Write( ID, 1 );
           D := 5 + 9; //(Sizeof( OutToneHdr ) + 1) + 1;
           RS.Write( D, 4 );
           OutToneHdr.ToneLength := 3500;
           OutToneHdr.ToneCount := 1;
           RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
           ID := 0;
           RS.Write( ID, 1 );
           ID := 2; //  ""
           RS.Write( ID, 1 );
         end;
    $30: // Text Description =     1 
         begin
           I := 0;
           if MS.Read( I, 1 ) <> 1 then Exit;
           SetLength( S, I );
           if MS.Read( S[ 1 ], I ) <> DWORD( I ) then Exit;
           S := PChar( S );
           ID := 8; //  ""
           RS.Write( ID, 1 );
           //P := RS.Position;
           ID := 1; // 1  (  )
           RS.Write( ID, 1 );
           D := 4 + length( S ) + 1;
           RS.Write( D, 4 );
           RS.WriteStrZ( S );
         end;
    $31: // Message Block
         begin
           I := 0;
           if MS.Read( I, 1 ) <> 1 then Exit;
           ID := 10;
           RS.Write( ID, 1 );
           RS.Write( I, 1 );
           if MS.Read( I, 1 ) <> 1 then Exit;
           SetLength( S, I );
           if MS.Read( S[ 1 ], I ) <> DWORD( I ) then Exit;
           RS.WriteStrZ( S );
         end;
    $32: // Archive Info - 
         begin
           I := 0;
           if MS.Read( I, 2 ) <> 2 then Exit;
           P := MS.Position + DWORD( I );
           MS.Position := P;
           if MS.Position <> P then Exit;
         end;
    $33: // Hardware type -  
         begin
           AddText( 'Hrdware Type Block' );
           I := 0;
           if MS.Read( I, 1 ) <> 1 then Exit;
           while I > 0 do
           begin
             if MS.Read( D, 3 ) <> 3 then Exit;
             Dec( I );
           end;
         end;
    $34: // Emulation Info - 
         begin
           AddText( 'Emulation Info Block' );
           P := MS.Position + 8;
           MS.Position := P;
           if MS.Position <> P then Exit;
         end;
    $35: // Custom info block -  ,    Pokes
         begin
           AddText( 'Custom Info Block' );
           CIbuf[ $10 ] := #0;
           if MS.Read( CIbuf, $10 ) <> $10 then Exit;
           if MS.Read( D, 4 ) <> 4 then Exit;
           P := MS.Position + D;
           MS.Position := P;
           if MS.Position <> P then Exit;
         end;
    $40: // Snapshot block (Z80  SNA)
         begin
           I := 0;
           if MS.Read( I, 1 ) <> 1 then Exit;
           if I = 0 then
             AddText( 'Snapshot Block: 0 (Z80)' )
           else
             AddText( 'Snapshot Block: 1 (SNA)' );
           if I > 1 then Exit; //  0 - Z80  1 - SNA
           D := 0;
           if MS.Read( D, 3 ) <> 3 then Exit;
           if ListBlocks then
           begin
             P := MS.Position + D;
             MS.Position := P;
             if MS.Position <> P then Exit;
           end
             else
           begin
             if I = 0 then Ext := '.Z80' else Ext := '.SNA';
             Plugin := SearchPlugin( Ext );
             if Plugin = nil then Exit;
             TRY
               if not Plugin.LoadProc( Pointer( DWORD( MS.Memory ) + MS.Position ),
                  D, PChar( Ext ), Data, FALSE ) then Exit;
             FINALLY
               Plugin.Free;
             END;
           end;
         end;
    $5A: // ZXTape!#2A
         begin
           AddText( 'ZXTape!' );
           P := MS.Position + 9;
           MS.Position := P;
           if MS.Position <> P then Exit;
         end;
    else //   
         begin
           if MS.Read( D, 4 ) <> 4 then Exit;
           AddText( 'Unknown Block #' + Int2Hex( ID, 2 ) + ' Length: ' + Int2Str( D ) );
           D := MS.Position + D - 4; // ?
           MS.Position := D;
           if MS.Position <> D then Exit;
         end;
    END;
  end;
  if RS.Size = 0 then Exit;
  //    -   
  OutToneHdr.ToneLength := 3500;
  OutToneHdr.ToneCount := 80;
  RS.Write( OutToneHdr, Sizeof( OutToneHdr ) );
  ID := 0;
  for I := 1 to 10 do
    RS.Write( ID, 1 );
  Result := TRUE;
end;

{$IFDEF System_Replace}
var SysReplaceOn: Boolean;
{$ENDIF}

//{$R memory128.res}
{$R memory48.res}
function LoadSpectrum( FileData: Pointer; FileSize: Integer; FileExt: PChar;
         Data: PSpecData; ScreenOnly: Boolean ): Boolean; stdcall;
var Mem: Pointer;
    MS, RS: PStream;
    LS: PList;
    NormalWrite: function( Strm: PStream; var Buffer; Count: DWORD ): DWORD;
    MemSize: DWORD;
begin
  {$IFDEF System_Replace}
  if not SysReplaceOn then
  begin
    SysReplaceOn := TRUE;
    UseDelphiMemoryManager;
  end;
  {$ENDIF}
  Result := FALSE;
  Data.Tape.Active := TRUE;
  if ScreenOnly then Exit;
  //     
  MS := NewMemoryStream;
  TRY
    MS.Size := FileSize;
    Move( FileData^, MS.Memory^, FileSize );
    RS := NewMemoryStream;
    LS := NewList;
    TRY
      NormalWrite := RS.Methods.fWrite;
      RS.Methods.fWrite := SkipWrite;
      if not ConvertTZX( RS, MS, LS, TRUE, Data ) then Exit;
      if RS.Size = 0 then Exit;
      RS.Methods.fWrite := NormalWrite;
      RS.Size := 0;
      MS.Position := 0;
      if not ConvertTZX( RS, MS, LS, FALSE, Data ) then Exit;
      if RS.Size = 0 then Exit;
      GetMem( Mem, RS.Size );
      Move( RS.Memory^, Mem^, RS.Size );
      Data.Tape.TapeImgData := Mem;
      Data.Tape.TapeImgLen := RS.Size;
      Data.Tape.Active := TRUE;
      Data.ReleaseDescriptor := DWORD( Mem );
      Result := TRUE;
    FINALLY
      RS.Free;
      LS.Free;
    END;
  FINALLY
    MS.Free;
  END;
  if not Result then Exit;
  //   -   
  Result := FALSE;
  {$IFDEF LOADER128}
  Data.State.AF := $7FA9;
  Data.State.BC := $9F22;
  Data.State.DE := $0011;
  Data.State.HL := $053F;
  Data.State.IX := $5CE2;
  Data.State.IY := $5C3A;
  Data.State.AFalt := $0001;
  Data.State.BCalt := $1821;
  Data.State.DEalt := $369B;
  Data.State.HLalt := $0038;
  Data.State.I := $00;
  Data.State.R := $3C;
  Data.State.IFF1 := FALSE;
  Data.State.IFF2 := FALSE;
  Data.State.ImMode := 1;
  Data.State.BorderColor := 7;

  Data.State.BankROM_0000 := 1;
  Data.State.BankVideo := 0;
  Data.State.BankRAM_C000 := 0;
  Data.State.PC := $05F5;
  Data.State.SP := $FF44;
  MemSize := 8 * 16384;
  {$ELSE}
  Data.State.AF := $FFA8;
  Data.State.BC := $EB22;
  Data.State.DE := $0011;
  Data.State.HL := $053F;
  Data.State.IX := $5CE2;
  Data.State.IY := $5C3A;
  Data.State.AFalt := $0001;
  Data.State.BCalt := $1721;
  Data.State.DEalt := $369B;
  Data.State.HLalt := $FFFF;
  Data.State.I := $3F;
  Data.State.R := $13;
  Data.State.IFF1 := FALSE;
  Data.State.IFF2 := FALSE;
  Data.State.ImMode := 1;
  Data.State.BorderColor := 7;

  Data.State.BankROM_0000 := 1;
  Data.State.BankVideo := 0;
  Data.State.BankRAM_C000 := 0;
  Data.State.PC := $05F3;
  Data.State.SP := $FF48;
  MemSize := 3 * 16384;
  {$ENDIF}

  MS := NewMemoryStream;
  TRY
    Resource2Stream( MS, hInstance, 'MEMORY', RT_RCDATA );
    if MS.Size = MemSize then
    if MS.Size = 8 * 16384 then
    begin
      Move( MS.Memory^, Data.RAMs[ 0 ], 8 * 16384 );
      //Data.Tape.Pilot := $C98 shr 1;
      Result := TRUE;
    end
      else
    begin
      Move( MS.Memory^, Data.RAMs[ 1 ], MemSize );
      Move( Data.RAMs[ 1 ], Data.RAMs[ 5 ], 16384 );
      //Move( Data.RAMs[ 2 ], Data.RAMs[ 2 ], 16384 );
      Move( Data.RAMs[ 3 ], Data.RAMs[ 0 ], 16384 );
      Result := TRUE;
    end;
  FINALLY
    MS.Free;
  END;

end;

procedure ReleaseData( MemAddr: Pointer ); stdcall;
begin
  FreeMem( MemAddr );
end;

procedure SetupCallback( Proc: TCallback ); stdcall;
begin
  Callback := Proc;
end;

exports RegisterLoadSpectrum, LoadSpectrum, ReleaseData, SetupCallback;

end.
