library LoadUDI;

uses
  Windows, KOL, PluginUnit;

type
  TByteArray = array[0..1000000] of Byte;
  PByteArray = ^TByteArray;

procedure RegisterLoadSpectrum( LoadFileTypes, SaveFileTypes: PChar;
          Descriptions: PChar; CanSaveS128: PByte ); stdcall;
begin
  StrCopy( LoadFileTypes, '*.UDI' );
  //StrCopy( SaveFileTypes, '*.UDI' );
  StrCopy( Descriptions, 'UDI disk image;' +
                         'UDI disk image' );
  PChar( CanSaveS128 )[ 0 ] := #2; // UDI -  
end;

{$R DISKETTE.RES}

type
  TUDIHeader = packed record
    Signature: array[ 0..3 ] of Char; // UDI!
    DiskSz: DWORD;
    Version: Byte;
    MaxCyl: Byte;
    MaxSid: Byte;
    ZeroB: Byte;
    ZeroD: DWORD;
  end;

function LoadSpectrum( FileData: Pointer; FileSize: Integer; FileExt: PChar;
         Data: PSpecData; ScreenOnly: Boolean ): Boolean; stdcall;
var FS, TS, BS, CS: PStream;
    DiskLetter: Char;
    Chunk: array[ 0..3 ] of Char;
    Len: DWORD;
    I, Sz, CSz: Integer;
    Bmp, Bmp1: PBitmap;
    Hdr: TUDIHeader;
    Trk, Cyl: Byte;

    procedure ReadRawTrack;
    var B: Byte;
      function Read1: Byte;
      begin
        BS.Read( B, 1 );
        Result := B;
      end;
    var CC, HH, RR, NN: Byte;
        CRC: Word;
        FirstSec: Boolean;
        Len: Word;
        SecBuf: array[ 0..16383 ] of Byte;
    begin
      FirstSec := TRUE;
      //   
      while BS.Position < BS.Size do
      begin
        while Read1 <> 0 do
          if BS.Position >= BS.Size then break;
        while Read1 = 0 do
          if BS.Position >= BS.Size then break;
        if B <> $C2 then continue;
        while Read1 = $C2 do 
          if BS.Position >= BS.Size then break;
        if B = $FC then break;
      end;
      //  
      while BS.Position < BS.Size do
      begin
        while Read1 <> $A1 do
          if BS.Position >= BS.Size then break;
        if B <> $A1 then continue;
        while Read1 = $A1 do
          if BS.Position >= BS.Size then break;
        if B <> $FE then continue;
        CC := Read1;
        HH := Read1;
        RR := Read1;
        NN := Read1;
        CRC := Read1 shl 8;
        CRC := CRC + Read1;
        while Read1 <> 0 do
          if BS.Position >= BS.Size then break;
        if B <> 0 then continue;
        while Read1 = 0 do
          if BS.Position >= BS.Size then break;
        //if B <> $A1 then continue;
        while (B <> $F8) and (B <> $FB) do
        begin
          if BS.Position >= BS.Size then break;
          Read1;
        end;
        //DD := B;
        if NN > 7 then Exit;
        Len := 128 shl (NN and 7);
        FillChar( SecBuf, Len, 0 );
        BS.Read( SecBuf, Min( Len, BS.Size - BS.Position ) );
        CRC := Read1 shl 8;
        CRC := CRC + Read1;
        //  , 
        if FirstSec then
        begin
          FirstSec := FALSE;
          if Hdr.MaxCyl = 0 then
          begin // - 
            if Trk < CC then
              Trk := CC
            else
              Inc( Trk );
          end
            else
          begin
            if Cyl <> HH then
            begin
              Cyl := (HH and 1);
              if Trk < CC then
                Trk := CC
              else
                Inc( Trk );
            end
              else
            begin
              if Trk < CC then
                Trk := CC
              else
                Inc( Trk );
            end;
          end;
        end;
        if Trk = 255 then Exit;
        TS.Write( Trk, 1 );
        TS.Write( Cyl, 1 );
        TS.Write( CC, 1 );
        TS.Write( HH, 1 );
        TS.Write( RR, 1 );
        TS.Write( NN, 1 );
        TS.Write( CRC, 2 );
        TS.Write( Len, 2 );
        TS.Write( SecBuf, Len );
      end;

    end;
begin
  Result := FALSE;
  FS := NewMemoryStream;
  TS := NewMemoryStream;
  FS.Size := FileSize;

  BS := NewMemoryStream;
  CS := NewMemoryStream;
  TRY
    if not ScreenOnly then
    begin
      Move( FileData^, FS.Memory^, FileSize );
      Chunk := 'DISK';
      TS.Write( Chunk, 4 );
      Len := 0;
      TS.Write( Len, 4 );
      DiskLetter := 'A';
      TS.Write( DiskLetter, 1 );
      I := 0;
      TS.Write( I, 1 ); // current track #
      TS.Write( I, 1 ); // disk states: D0 = read only, D1 = head down, D2 = FM/MFM
      TS.Write( I, 1 ); // reserved
      if not CompareMem( FS.Memory, PChar( 'UDI!' ), 4 ) then
        Exit;
      FS.Read( Hdr, Sizeof( Hdr ) );
      Trk := $FF;
      Cyl := 1;
      while FS.Position < FS.Size do
      begin
        I := 0;
        FS.Read( I, 1 );
        if I <> 0 then break;
        Sz := 0;
        FS.Read( Sz, 2 );
        BS.Size := Sz;
        Stream2Stream( BS, FS, Sz );
        BS.Position := 0;
        CS.Size := 0;
        if I = 0 then
        begin
          CSz := Sz div 8 + Byte((Sz-(Sz div 8)*8) <> 0);
          CS.Size := CSz;
          Stream2Stream( CS, FS, CSz );
          CS.Position := 0;
        end;

        ReadRawTrack;
      end;
      I := 255;
      TS.Write( I, 1 );
    end
      else
    begin
      Chunk := 'PRVW';
      TS.Write( Chunk, 4 );
      Len := 0;
      TS.Write( Len, 4 );
      Bmp := NewBitmap( 0,0 );
      Bmp1 := NewBitmap( 256, 192 );
      Bmp1.Canvas.Brush.Color := clWhite;
      Bmp1.Canvas.FillRect( Bmp1.BoundsRect );
      Bmp.LoadFromResourceName( hInstance, 'DISK' );
      Bmp.Draw( Bmp1.Canvas.Handle, (Bmp1.Width - Bmp.Width) div 2,
        (Bmp1.Height - Bmp.Height) div 2 );
      Bmp.Free;
      Bmp1.SaveToStream( TS );
      Bmp1.Free;
      Bmp.Free;
    end;

    I := TS.Size - 8;
    TS.Position := 4;
    TS.Write( I, 4 );
    GetMem( Data.Tape.TapeImgData, TS.Size );
    Move( TS.Memory^, Data.Tape.TapeImgData^, TS.Size );
    Data.Tape.TapeImgLen := TS.Size;
    Result := TRUE;
  FINALLY
    FS.Free;
    TS.Free;
    BS.Free;
    CS.Free;
  END;
end;

procedure ReleaseData( MemAddr: Pointer ); stdcall;
begin
  FreeMem( MemAddr );
end;

exports RegisterLoadSpectrum, LoadSpectrum, ReleaseData;

begin
  UseDelphiMemoryManager;
end.
