unit ZxAsmTypes;

interface

uses Windows, KOL;

type
  TOnError = procedure( IncludeFileName: PChar; LineNo, ColNo: Integer;
                        ErrorString: PChar; Severity: Integer ); stdcall;
  TOnLabel = procedure( aLabel: PChar; Addr: Word; Bank: Integer );
                        stdcall;

  TMemBlock = array[0..16383] of Byte;
  PMemBlock = ^TMemBlock;

  TPages = array[0..1023] of PMemBlock;
  PPages = ^TPages;

  PMemory = ^TMemory;
  TMemory = packed record
    Pages: array[ 0..3 ] of Integer; //   "" 
    //    RAM 0..n (n = MaxRAMPage)
    //    ROM -1->1..-m->m (m=MaxROMPage)
    //   0    -1  -2,   1 -  5,
    //   2 -   2,   3 -     0
    //  MaxRAMPage.      ( ...)
    MaxRAMPage: Integer;
    MaxROMPage: Integer; // ROM1 = SOS ROM2 = S128 ROM3 = TRDOS
    RAMPages: PPages;
    ROMPages: PPages;
  end;

const
  Option_SyntaxCheckOnly = 1;   //    1,     
  Option_ROMAllowReWrite = 2;   //  2,    
  Option_LocalLabel_Dot  = 4;   //      '.'
  Option_LocalLabel_Und  = 8;   // ...  '_'
  Option_LocalLabel_At   = 16;  // ...  '@'
  Option_LocalLabel_Exc  = 32;  // ...  '!'
  Option_LocalLabel_Que  = 64;  // ...  '?'
  Option_LocalLabel_Bck  = 128; // ...  '\'
  Option_NoAskAnswerNo   = 256; //   ,    NO
                                // (   ROM)
  Option_StrongAddrCtl   = 512; //      ORG, .=, ...
  Option_BaxHex          = 1024; // $xxxx  x := 0..9,A..F  

type
  TCompileZX = function( Src: PChar; IncludeSearchDirs: PChar; AsmOptions: DWORD;
                    Memory: PMemory; OnError: TOnError; OnLabel: TOnLabel ): Integer;
                    stdcall;

implementation

end.
